/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.control.StockGatherMoveFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class StockGatherBillDataTransmission
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return StockGatherMoveFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("Get local instance error: ", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        throw new TaskExternalException(this.getResource("importNotSupport"), null);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable hTable = new Hashtable();
        Locale currentLocale = ctx.getLocale();
        try {
            StockGatherBillDataTransmission.putTable(hTable, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            StockGatherBillDataTransmission.putTable(hTable, "FNumber", rs.getString("number"));
            StockGatherBillDataTransmission.putTable(hTable, "FBizDate", rs.getString("bizDate"));
            if (rs.getString("baseStatus") != null) {
                StockGatherBillDataTransmission.putTable(hTable, "FBaseStatus", BillBaseStatusEnum.getEnum((int)rs.getInt("baseStatus")).getAlias(currentLocale));
            }
            StockGatherBillDataTransmission.putTable(hTable, "FRemark", rs.getString("remark"));
            StockGatherBillDataTransmission.putTable(hTable, "FAuditor_number", rs.getString("auditor.number"));
            StockGatherBillDataTransmission.putTable(hTable, "FAuditTime", rs.getString("auditTime"));
            StockGatherBillDataTransmission.putTable(hTable, "FModifier_number", rs.getString("modifier.number"));
            StockGatherBillDataTransmission.putTable(hTable, "FModificationTime", rs.getString("modificationTime"));
            StockGatherBillDataTransmission.putTable(hTable, "FCreator_number", rs.getString("creator.number"));
            StockGatherBillDataTransmission.putTable(hTable, "FCreateTime", rs.getString("createTime"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys$material_number", rs.getString("material.number"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys_model", rs.getString("entrys.model"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys$unit_number", rs.getString("unit.number"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys_qty", rs.getBigDecimal("entrys.qty"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys_moveQty", rs.getBigDecimal("entrys.moveQty"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys$baseUnit_number", rs.getString("baseUnit.number"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys_baseQty", rs.getBigDecimal("entrys.baseQty"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys_moveBaseQty", rs.getBigDecimal("entrys.moveBaseQty"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys$warehouse_number", rs.getString("defaultWareHouse.number"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys$moveOutStorageOrgUnit_number", rs.getString("moveOutStorageOrgUnit.number"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys$moveOutWarehouse_number", rs.getString("moveOutWarehouse.number"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys_moveInPlanDate", rs.getString("entrys.moveInPlanDate"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys_remark", rs.getString("entrys.remark"));
            StockGatherBillDataTransmission.putTable(hTable, "FEntrys_transferBillNum", rs.getString("entrys.transferBillNum"));
        }
        catch (SQLException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return hTable;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.mm.control.app.StockGatherMoveForPrintQuery";
    }

    public static void putTable(Hashtable hTable, Object key, Object value) {
        if (value != null) {
            hTable.put(key, value);
        }
    }

    private String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.control.TaskDispBillResource", (String)strKey);
    }
}

