/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.app.LotFrameManu;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.TaskDispBillInfo;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;
import java.util.ArrayList;
import java.util.List;

public class TaskDispLotServerUtils {
    public static void getReleasedLot(Context ctx, TaskDispBillInfo taskInfo) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)taskInfo.getMaterial().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)taskInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
        EntityViewInfo viewer = new EntityViewInfo();
        viewer.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("isLotNumber");
        viewer.setSelector(selector);
        MaterialInventoryCollection inv = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewer);
        if (inv.size() <= 0) {
            return;
        }
        MaterialInventoryInfo invInfo = inv.get(0);
        if (!invInfo.isIsLotNumber()) {
            return;
        }
        LotParamValueInfo param = LotFacadeFactory.getLocalInstance((Context)ctx).getLotParamValueByOrg(taskInfo.getStorageOrgUnit().getId().toString());
        boolean isPlanOrderGene = param.isProductionOrderPlan();
        boolean isPrdOrderGene = param.isProductionOrderProduction();
        boolean isTaskGene = param.isProductionOrderTaskDisp();
        boolean isDefaultCarried = param.isProductionOrderProsee();
        if (isPlanOrderGene) {
            if (isTaskGene) {
                if (isDefaultCarried) {
                    TaskDispLotServerUtils.carriedLotNo(ctx, taskInfo);
                } else {
                    TaskDispLotServerUtils.dealLotRule(ctx, taskInfo);
                }
            } else {
                TaskDispLotServerUtils.carriedLotNo(ctx, taskInfo);
            }
        } else if (isPrdOrderGene) {
            if (isTaskGene) {
                if (isDefaultCarried) {
                    TaskDispLotServerUtils.carriedLotNo(ctx, taskInfo);
                } else {
                    TaskDispLotServerUtils.dealLotRule(ctx, taskInfo);
                }
            } else {
                TaskDispLotServerUtils.carriedLotNo(ctx, taskInfo);
            }
        } else if (isTaskGene) {
            TaskDispLotServerUtils.dealLotRule(ctx, taskInfo);
        }
    }

    private static void carriedLotNo(Context ctx, TaskDispBillInfo taskInfo) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic = new SelectorItemCollection();
        sic.add("lotNo");
        ProductionOrderInfo orderInfo = (ProductionOrderInfo)ProductionOrderFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(taskInfo.getSourceBillId()), sic);
        taskInfo.setLotNo(orderInfo.getLotNo());
    }

    private static void dealLotRule(Context ctx, TaskDispBillInfo taskInfo) throws EASBizException, BOSException {
        LotFrame lotFrame = LotRuleFactory.getLocalInstance((Context)ctx).getLotFrame(taskInfo.getMaterial().getId().toString(), taskInfo.getStorageOrgUnit().getId().toString());
        if (lotFrame != null && lotFrame.getLotRule() != null) {
            LotFrameManu lot = new LotFrameManu();
            lot.setSeq(lotFrame.getSeq());
            lot.setSysDate(lotFrame.getSysDate());
            lot.setCurrentSerial(lotFrame.getCurrentSerial());
            lot.setLotRule(lotFrame.getLotRule());
            lot.setBillNumber(taskInfo.getNumber());
            lot.setMainBizOrg(taskInfo.getStorageOrgUnit().getNumber());
            lot.setMaterial(taskInfo.getMaterial().getNumber());
            lot.setFreeProp1(taskInfo.getProductLine().getNumber());
            lot.setMfg(taskInfo.getEndDate());
            lot.setBizDate(taskInfo.getBizDate());
            String lotNo = lot.getLotNumber();
            taskInfo.setLotNo(lotNo);
        }
    }

    public static int dealLotNoSituation(StorageOrgUnitInfo sou, MaterialInfo material, Context ctx) throws EASBizException, BOSException {
        if (material == null || sou == null) {
            return 0;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
        EntityViewInfo viewer = new EntityViewInfo();
        viewer.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("isLotNumber");
        viewer.setSelector(selector);
        MaterialInventoryCollection inv = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewer);
        if (inv.size() <= 0) {
            return 0;
        }
        MaterialInventoryInfo invInfo = inv.get(0);
        if (!invInfo.isIsLotNumber()) {
            return 0;
        }
        LotFrame lotFrame = new LotFrame();
        lotFrame.setMainBizOrg(sou.getId().toString());
        lotFrame.setMaterial(material.getId().toString());
        List lotList = new ArrayList<LotFrame>();
        lotList.add(lotFrame);
        lotList = LotRuleFactory.getLocalInstance((Context)ctx).fillLotFramesNoSerial(lotList);
        if (lotList != null && lotList.size() > 0) {
            lotFrame = (LotFrame)lotList.get(0);
        }
        LotParamValueInfo param = LotFacadeFactory.getLocalInstance((Context)ctx).getLotParamValueByOrg(sou.getId().toString());
        boolean isPlanOrderGene = param.isProductionOrderPlan();
        boolean isPrdOrderGene = param.isProductionOrderProduction();
        boolean isTaskDispGene = param.isProductionOrderTaskDisp();
        if (null == lotFrame || null == lotFrame.getLotRule()) {
            if (isPlanOrderGene) {
                return 1;
            }
            if (isPrdOrderGene) {
                return 1;
            }
            if (isTaskDispGene) {
                return 1;
            }
            return 0;
        }
        if (isPlanOrderGene) {
            return 1;
        }
        if (isPrdOrderGene) {
            return 1;
        }
        if (isTaskDispGene) {
            return 1;
        }
        return 0;
    }
}

