/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.common.util.ParamUtil;
import com.kingdee.eas.mm.control.SATransactionEnum;
import java.math.BigDecimal;

public class StockAllocationUtil {
    private static String[] REQUIREPARAMS = new String[]{"AllocationMethod"};
    private static String ALLOCATIONMETHOD_WAREHOUSERESTOCK = String.valueOf((Object)SATransactionEnum.WAREHOUSERESTOCK);
    public static final int PRECISION_DEFAUL_DB = 8;
    public static final int PRECISION_DB = 16;
    public static final String ZERO_SQLSERVER = "0E-8";
    public static final BigDecimal EXCHANGERATE_DEFAULT = new BigDecimal("1.0");

    public static BigDecimal getExchangePrecisionQtyForServer(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, 16, 4);
        }
        return targetQty;
    }

    public static BigDecimal effectualNumeric(BigDecimal v) {
        return StockAllocationUtil.equalsZero(v) ? SysConstant.BIGZERO : v;
    }

    public static boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    public static BigDecimal effectualExchangeRate(BigDecimal exchangeRate) {
        return StockAllocationUtil.isDistrustExchangeRate(exchangeRate) ? exchangeRate : EXCHANGERATE_DEFAULT;
    }

    public static boolean isDistrustExchangeRate(BigDecimal exchangeRate) {
        return exchangeRate != null && exchangeRate.compareTo(SysConstant.BIGZERO) != 0 && exchangeRate.compareTo(SysConstant.BIGZERO) != -1;
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("wpEntry.*"));
        sic.add(new SelectorItemInfo("stockEntry.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("productLine.*"));
        sic.add(new SelectorItemInfo("unit.*"));
        sic.add(new SelectorItemInfo("warehouse.*"));
        sic.add(new SelectorItemInfo("baseUnit.*"));
        sic.add(new SelectorItemInfo("assistUnit.name"));
        sic.add(new SelectorItemInfo("workShop.*"));
        sic.add(new SelectorItemInfo("classTeam.*"));
        sic.add(new SelectorItemInfo("classGroup.*"));
        sic.add(new SelectorItemInfo("formula.*"));
        sic.add(new SelectorItemInfo("bom.*"));
        sic.add(new SelectorItemInfo("trackNumber.*"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("billType.*"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("actualEndDate"));
        sic.add(new SelectorItemInfo("mmBizType.*"));
        sic.add(new SelectorItemInfo("mmBizType"));
        sic.add(new SelectorItemInfo("expectEndDate"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("OutSourceFlag"));
        sic.add(new SelectorItemInfo("stockEntry.material.*"));
        sic.add(new SelectorItemInfo("stockEntry.baseUnit.*"));
        sic.add(new SelectorItemInfo("stockEntry.unit.*"));
        sic.add(new SelectorItemInfo("stockEntry.moveOutWarehouse.*"));
        sic.add(new SelectorItemInfo("stockEntry.moveOutStorageOrgUnit.*"));
        sic.add(new SelectorItemInfo("stockEntry.defaultWarehouse.*"));
        sic.add(new SelectorItemInfo("stockEntry.productLineWP.id"));
        sic.add(new SelectorItemInfo("stockEntry.productLineWP.name"));
        sic.add(new SelectorItemInfo("stockEntry.productLineWP.number"));
        sic.add(new SelectorItemInfo("stockEntry.supplyOrgUnit.*"));
        return sic;
    }

    public static boolean isAllocationMethod(Context ctx, String storageUnitInfoID) {
        ParamUtil paramUtil = new ParamUtil(ctx, storageUnitInfoID, REQUIREPARAMS);
        String temp = paramUtil.getAllocationMethod(ALLOCATIONMETHOD_WAREHOUSERESTOCK);
        return "1".equals(temp);
    }
}

