/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common;

import com.kingdee.eas.base.forewarn.dataDeal.KSQLData;
import com.kingdee.eas.tools.datatask.DEBaseInfo;
import com.kingdee.eas.tools.datatask.DEDataExportImplHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class NCMKSQLData {
    static Logger logger = Logger.getLogger(KSQLData.class);
    private static final SimpleDateFormat FORMAT_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String dealData(ResultSet resut, int i, boolean isGenXml, DEBaseInfo dEBaseInfo) throws SQLException {
        ResultSetMetaData restmd = resut.getMetaData();
        String sqlstr = null;
        int typeCode = restmd.getColumnType(i);
        switch (typeCode) {
            case 4: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "int", dEBaseInfo);
                break;
            }
            case 5: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "int", dEBaseInfo);
                break;
            }
            case 6: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "float", dEBaseInfo);
                break;
            }
            case -6: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "int", dEBaseInfo);
                break;
            }
            case 7: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "double", dEBaseInfo);
                break;
            }
            case -7: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "int", dEBaseInfo);
                break;
            }
            case 8: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "double", dEBaseInfo);
                break;
            }
            case 3: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "BigDecimal", dEBaseInfo);
                break;
            }
            case 93: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "datetime", dEBaseInfo);
                break;
            }
            case -2: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "timestamp", dEBaseInfo);
                break;
            }
            case 92: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "timestamp", dEBaseInfo);
                break;
            }
            case 12: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "string", dEBaseInfo);
                break;
            }
            case 1: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "string", dEBaseInfo);
                break;
            }
            case 2: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "int", dEBaseInfo);
                break;
            }
            case 91: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "date", dEBaseInfo);
                break;
            }
            case -1: {
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "string", dEBaseInfo);
                break;
            }
            case 2004: {
                sqlstr = "?";
                break;
            }
            case 2005: {
                if (isGenXml) {
                    sqlstr = "?";
                    break;
                }
                sqlstr = NCMKSQLData.getDataKsqlData(resut, i, "string", dEBaseInfo);
                break;
            }
            default: {
                logger.info((Object)typeCode);
            }
        }
        if (sqlstr == null) {
            return "null";
        }
        return sqlstr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBlobData(String tableName, ResultSet result, String colName) throws SQLException, IOException {
        byte[] b = null;
        Blob tmpBlob = result.getBlob(colName);
        if (tmpBlob == null) {
            return null;
        }
        int size = Long.valueOf(tmpBlob.length()).intValue();
        b = new byte[size];
        try (InputStream is = null;){
            is = tmpBlob.getBinaryStream();
            is.read(b);
        }
        return b;
    }

    public static String getClobData(String tableName, ResultSet result, String colName) throws SQLException, IOException {
        return result.getString(colName);
    }

    public static String getDataKsqlData(ResultSet resut, int i, String str2, DEBaseInfo dEBaseInfo) {
        String str = "";
        DecimalFormat format = new DecimalFormat("###0.00000000");
        try {
            if ("int".equals(str2)) {
                str = String.valueOf(resut.getInt(i));
            }
            if ("float".equals(str2)) {
                str = resut.wasNull() ? "0.0000" : String.valueOf(resut.getShort(i));
            }
            if ("double".equals(str2)) {
                str = resut.wasNull() ? "0.0000" : String.valueOf(resut.getDouble(i));
            }
            if ("BigDecimal".equals(str2)) {
                str = resut.getBigDecimal(i) == null && resut.wasNull() ? "0.00000000" : String.valueOf(format.format(resut.getBigDecimal(i)));
            }
            if ("string".equals(str2)) {
                String tempStr = resut.getString(i);
                str = tempStr == null ? "null" : (NCMKSQLData.isIncludeChinese(tempStr) ? "N'" + DEDataExportImplHelper.getString((String)DEDataExportImplHelper.parseString((String)tempStr)) + "'" : "'" + DEDataExportImplHelper.getString((String)DEDataExportImplHelper.parseString((String)tempStr)) + "'");
            }
            if ("datetime".equals(str2)) {
                Timestamp tmpdate = resut.getTimestamp(i);
                str = tmpdate == null ? "null" : "{ts'" + FORMAT_TIME.format(tmpdate) + "'}";
            }
        }
        catch (Exception e) {
            logger.info((Object)"", (Throwable)e);
        }
        if (str.contains("\n")) {
            str = str.replace("\n", "");
        }
        return str;
    }

    public static boolean isIncludeChinese(String str) {
        boolean isIncludeChinese = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if ('\u4e00' >= c || c >= '\u9fbb') continue;
            isIncludeChinese = true;
            break;
        }
        return isIncludeChinese;
    }

    public static boolean isEnglishString(String str) {
        boolean isEnglishString = true;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) <= '\u00ff') continue;
            isEnglishString = false;
            break;
        }
        return isEnglishString;
    }

    public static void writeFile(byte[] fileBytes, String filePath, boolean isContuWrite) throws Exception {
        File file = new File(filePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fs = new FileOutputStream(file, isContuWrite);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fs, "utf-8");
        osw.write(new String(fileBytes, "utf-8"));
        if (osw != null) {
            osw.close();
        }
        if (fs != null) {
            fs.close();
        }
    }
}

