/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CMBillBaseCollection;
import com.kingdee.eas.ncm.common.CMBillBaseInfo;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.app.AbstractCMBillBaseControllerBean;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbBatchUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class CMBillBaseControllerBean
extends AbstractCMBillBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.common.app.CMBillBaseControllerBean");
    protected static final String BILL_RESOURCE = "com.kingdee.eas.ncm.bill.BillResource";

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this.updateAuditStatus(ctx, pks);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.updateAuditStatus(ctx, pks);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.updateUnAuditStatus(ctx, pks);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this.updateUnAuditStatus(ctx, pks);
    }

    public void updateAuditStatus(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        String tableName = this.checkTableName(ctx, pks);
        try {
            this._checkStart(ctx, pks);
            StringBuffer params = NCMUtils.splitPK(pks);
            StringBuffer checkSql = new StringBuffer(" select FNumber from ").append(tableName).append(" where fid in ( ").append(params.toString()).append(" ) and FBillStatus = 4");
            IRowSet checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
            if (checkSet.next() && checkSet.getString(1) != null) {
                throw new CMBillException(CMBillException.CHECKAUDITEDOK);
            }
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(tableName).append(" set FBillStatus = 4,FAuditorId='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("',").append(" FAuditTime = getDate() where fid in(").append(params.toString()).append(" )");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    protected void checkStart(Context ctx, IObjectCollection billColl) throws BOSException, EASBizException {
        PeriodInfo period;
        PeriodInfo curPeriod;
        if (billColl == null || billColl.isEmpty()) {
            return;
        }
        CMBillBaseInfo info = (CMBillBaseInfo)billColl.getObject(0);
        CompanyOrgUnitInfo companyInfo = info.getCompanyOrg();
        if (this.isUsingPeriod() && info.getCalculatePeriod() == null) {
            throw new CMBillException(CMBillException.NO_PERIOD);
        }
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        this.checkStartDiff(ctrol, companyInfo.getId().toString());
        if (this.isCheckStart() && !NCMUtils.isBig(curPeriod = ctrol.getCacheCurrentPeriod(1001, companyInfo.getId().toString()), period = this.getLeastPeriodInfo(ctx, billColl))) {
            throw new CMBillException(CMBillException.NOT_EDIT);
        }
    }

    private void checkStartDiff(ISystemStatusCtrol ctrol, String companyId) throws CMBillException, EASBizException, BOSException {
        boolean isInit = ctrol.isStart(1001, companyId);
        if (this.checkStartForCommon()) {
            if (!isInit) {
                throw new CMBillException(CMBillException.COST_NOTON);
            }
        } else if (isInit) {
            throw new CMBillException(CMBillException.COST_ISON);
        }
    }

    protected boolean checkStartForCommon() {
        return true;
    }

    protected boolean isUsingPeriod() {
        return true;
    }

    @Override
    protected void _checkStart(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        CMBillBaseCollection billColl = this.getBillColl(ctx, pks, null);
        this.checkStart(ctx, (IObjectCollection)billColl);
    }

    private CMBillBaseCollection getBillColl(Context ctx, IObjectPK[] pks, SelectorItemCollection sic) throws BOSException {
        Set idSet = NCMUtils.arrayPK2Set(pks);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        if (sic != null) {
            evi.setSelector(sic);
        }
        return this.getCMBillBaseCollection(ctx, evi);
    }

    protected PeriodInfo getLeastPeriodInfo(Context ctx, IObjectCollection billColl) throws BOSException {
        if (!this.isUsingPeriod()) {
            return new PeriodInfo();
        }
        if (billColl == null || billColl.isEmpty()) {
            return new PeriodInfo();
        }
        HashSet<String> idSet = new HashSet<String>();
        int size = billColl.size();
        for (int i = 0; i < size; ++i) {
            CMBillBaseInfo info = (CMBillBaseInfo)billColl.getObject(i);
            idSet.add(info.getCalculatePeriod().getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        PeriodCollection periodColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        if (periodColl.size() > 0) {
            return periodColl.get(0);
        }
        return new PeriodInfo();
    }

    public void updateUnAuditStatus(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        String tableName = this.checkTableName(ctx, pks);
        try {
            this._checkStart(ctx, pks);
            StringBuffer params = NCMUtils.splitPK(pks);
            StringBuffer checkSql = new StringBuffer(" select FNumber from ").append(tableName).append(" where fid in ( ").append(params.toString()).append(" ) and FBillStatus <> 4");
            IRowSet checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
            this.checkFivouchered(ctx, tableName, params.toString());
            if (checkSet.next() && checkSet.getString(1) != null) {
                throw new CMBillException(CMBillException.CHECKAUDITEDNOTOK);
            }
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(tableName).append(" set FBillStatus = 2,FAuditorId = null, ").append(" FAuditTime = null where fid in(").append(params.toString()).append(" )");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    protected void checkFivouchered(Context ctx, String tableName, String ids) throws BOSException, CMBillException, SQLException {
    }

    private String checkTableName(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        String tableName = this.getMainTableName(ctx, pks);
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        return tableName;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((CMBillBaseInfo)model).setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _setUpdateNull(Context ctx, String pk) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        try {
            IObjectPK[] pks = new IObjectPK[2];
            String tableName = this.checkTableName(ctx, pks);
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            StringBuffer checkSql = new StringBuffer("update ").append(tableName).append(" set FLastUpdateUserID=null,FLastUpdateTime=null where ").append(" FID='" + pk + "'");
            statement.executeUpdate(checkSql.toString());
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (Exception ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((CMBillBaseInfo)model).setBillStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._delete(ctx, pks);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        IObjectPK[] pks = this.recycleBatchNumber(ctx, arrayPK);
        if (this.isSupportBotp()) {
            super._delete(ctx, pks);
        } else {
            super.innerDelete(ctx, pks);
        }
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        this.recycleBatchNumber(ctx, pkArray);
        super._deleteBatchData(ctx, pkArray);
    }

    private CMBillBaseCollection getBillCollValid(Context ctx, IObjectPK[] pks, SelectorItemCollection sic) throws BOSException {
        Set idSet = NCMUtils.arrayPK2Set(pks);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        HashSet<Integer> statusSet = new HashSet<Integer>();
        statusSet.add(1);
        statusSet.add(2);
        statusSet.add(3);
        filter.getFilterItems().add(new FilterItemInfo("billStatus", statusSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        if (sic != null) {
            evi.setSelector(sic);
        }
        return this.getCMBillBaseCollection(ctx, evi);
    }

    protected boolean isSupportBotp() {
        return true;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (((CMBillBaseInfo)model).getCU() == null) {
            ((CMBillBaseInfo)model).setCU(CMBillBaseControllerBean.getRootCU(ctx));
        }
        this.checkNumber(ctx, model);
        super._addnew(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnewForCalCost(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (((CMBillBaseInfo)model).getCU() == null) {
            ((CMBillBaseInfo)model).setCU(CMBillBaseControllerBean.getRootCU(ctx));
        }
        if (StringUtils.isEmpty((String)((String)model.get("number")))) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String number = iCodingRuleManager.getNumber(model, ((CMBillBaseInfo)model).getCompanyOrg().getId().toString());
            ((CMBillBaseInfo)model).setNumber(number);
        }
        ObjectUuidPK pk = new ObjectUuidPK(model.getBOSUuid("id"));
        this._checkNumberBlank(ctx, (IObjectPK)pk, model);
        this._checkNumberDup(ctx, (IObjectPK)pk, model);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkStart(ctx, model);
        if (((CMBillBaseInfo)model).getCU() == null) {
            ((CMBillBaseInfo)model).setCU(CMBillBaseControllerBean.getRootCU(ctx));
        }
        this.checkNumber(ctx, model);
        return super._addnew(ctx, model);
    }

    protected boolean WarnningWhenCodingRureNotExsit() {
        return false;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (!"true".equals(model.getString("isForVoucherDel"))) {
            this.checkStart(ctx, model);
        }
        if (((CMBillBaseInfo)model).getCU() == null) {
            ((CMBillBaseInfo)model).setCU(CMBillBaseControllerBean.getRootCU(ctx));
        }
        this._checkNumberBlank(ctx, pk, model);
        this._checkNumberDup(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    public static CtrlUnitInfo getRootCU(Context ctx) {
        CtrlUnitInfo rootCU = new CtrlUnitInfo();
        rootCU.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        return rootCU;
    }

    @Override
    protected String _getAddNewPItemName(Context ctx, String objectType) throws BOSException {
        String permItemName = null;
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("select FName from t_pm_permitem where FObjectType = '").append(objectType).append("' AND FOperationType = 'ADDNEW'");
        IRowSet permItemNameRowSet = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString());
        try {
            if (permItemNameRowSet != null && permItemNameRowSet.next()) {
                permItemName = permItemNameRowSet.getString("FName");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return permItemName;
    }

    protected String _getViewPermItemName(Context ctx, String objectType) throws BOSException {
        String permItemName = null;
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("select FName from t_pm_permitem where FObjectType = '").append(objectType).append("' AND FOperationType = 'READ'");
        IRowSet permItemNameRowSet = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString());
        try {
            if (permItemNameRowSet != null && permItemNameRowSet.next()) {
                permItemName = permItemNameRowSet.getString("FName");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return permItemName;
    }

    protected void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CMBillBaseInfo info = (CMBillBaseInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(model, info.getCompanyOrg().getId().toString());
        if (ruleStatus.isExist() && (StringUtils.isEmpty((String)info.getNumber()) || ruleStatus.isAddNoBreak() || !ruleStatus.isModifiable() && this.isNumberUsed(ctx, info))) {
            this.setNewNumber(ctx, info, iCodingRuleManager, null);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(model.getBOSUuid("id"));
            super._checkNumberBlank(ctx, (IObjectPK)pk, model);
            super._checkNumberDup(ctx, (IObjectPK)pk, model);
        }
    }

    protected boolean isNumberUsed(Context ctx, CMBillBaseInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (info.getCU() != null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        boolean exist = super._exists(ctx, filter);
        return exist;
    }

    protected void setNewNumber(Context ctx, CMBillBaseInfo info, ICodingRuleManager iCodingRuleManager, String customString) throws BOSException, EASBizException {
        String number = iCodingRuleManager.getNumber((IObjectValue)info, info.getCompanyOrg().getId().toString(), customString);
        info.setNumber(number);
        if (this.isNumberUsed(ctx, info)) {
            this.setNewNumber(ctx, info, iCodingRuleManager, customString);
        }
    }

    @Override
    protected String _getNewNumber(Context ctx, IObjectValue model, String strCompanyID, String customString) throws BOSException, EASBizException {
        String strBindProp;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CMBillBaseInfo aSCMBillBaseInfo = (CMBillBaseInfo)model;
        String number = "";
        boolean isNumberNoSet = false;
        if (aSCMBillBaseInfo.getNumber() == null || aSCMBillBaseInfo.getNumber().length() == 0) {
            isNumberNoSet = true;
        }
        if ((strBindProp = this.getBindingProperty(ctx)) != null && strBindProp.trim().length() > 0) {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString);
            aSCMBillBaseInfo.setNumber(number);
        } else {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            aSCMBillBaseInfo.setNumber(number);
        }
        ObjectUuidPK pk = new ObjectUuidPK(aSCMBillBaseInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
            String newNumber = "";
            newNumber = strBindProp != null && strBindProp.trim().length() > 0 ? iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString) : iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            if (newNumber.equals(aSCMBillBaseInfo.getNumber())) {
                throw new CMBillException(CMBillException.NUMBERRULEERROR);
            }
            number = newNumber;
            aSCMBillBaseInfo.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
                return this._getNewNumber(ctx, (IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            }
        }
        return number;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CMBillBaseInfo aSCMBillBaseInfo = (CMBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aSCMBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aSCMBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && aSCMBillBaseInfo.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue(aSCMBillBaseInfo), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected String getBindingProperty(Context ctx) throws BOSException {
        return null;
    }

    protected Object getBindingPropertyValue(CMBillBaseInfo aSCMBillBaseInfo) {
        return null;
    }

    public void checkStart(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyinfo = ((CMBillBaseInfo)model).getCompanyOrg();
        if (((CMBillBaseInfo)model).getCalculatePeriod() == null) {
            throw new CMBillException(CMBillException.NO_PERIOD);
        }
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(((CMBillBaseInfo)model).getCalculatePeriod().getId().toString()));
        if (!ctrol.isStart(1001, companyinfo.getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.isCheckStart() && !NCMUtils.isBig(ctrol.getCacheCurrentPeriod(1001, companyinfo.getId().toString()), period)) {
            throw new CMBillException(CMBillException.NOT_EDIT);
        }
    }

    protected boolean isCheckStart() {
        return true;
    }

    public abstract String getMainTableName(Context var1, IObjectPK[] var2) throws EASBizException, BOSException;

    protected FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("companyOrg.id", (Object)((CMBillBaseInfo)model).getCompanyOrg().getId().toString());
        return filter;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            srcBillVO.setString("isForVoucherDel", "true");
        }
        this._reverseSave(ctx, srcBillPK, srcBillVO);
    }

    @Override
    protected Map _submit(Context ctx, List ids, Map param) throws BOSException, EASBizException {
        int i;
        final HashMap report = new HashMap();
        if (ids == null || ids.isEmpty()) {
            return report;
        }
        final Map errorDetail = this.bizCheckForSubmit(ctx, ids, param);
        ArrayList<Object[]> successIds = new ArrayList<Object[]>();
        int size = ids.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (errorDetail.containsKey(ids.get(i2))) continue;
            successIds.add(new Object[]{ids.get(i2)});
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append(" update " + this.getMainTableName(ctx, null) + " \n");
        kSql.append("    set FBillStatus = 3 \n");
        kSql.append("  where FID in (");
        for (i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append(" )");
        NCMDbBatchUtil.batchExecuteUpdate(ctx, kSql.toString(), successIds, new NCMDbBatchUtil.UpdateCallbackHandler(){

            @Override
            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                return 0;
            }
        });
        if (errorDetail != null && !errorDetail.isEmpty()) {
            kSql.setLength(0);
            kSql.append(" select FID,FNumber \n");
            kSql.append("   from " + this.getMainTableName(ctx, null) + " \n");
            kSql.append("  where FID in (");
            for (i = 0; i < 200; ++i) {
                if (i == 199) {
                    kSql.append(" ? ");
                    continue;
                }
                kSql.append(" ?, ");
            }
            kSql.append(" )");
            Iterator itr = errorDetail.keySet().iterator();
            ArrayList<Object[]> errorIds = new ArrayList<Object[]>();
            while (itr.hasNext()) {
                errorIds.add(new Object[]{itr.next()});
            }
            NCMDbBatchUtil.batchExecuteQuery(ctx, kSql.toString(), errorIds, new NCMDbBatchUtil.QueryCallbackHandler(){

                @Override
                public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                    return 0;
                }

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String fid = rs.getString("FID");
                    String fnumber = rs.getString("FNumber");
                    report.put(fnumber, errorDetail.get(fid));
                }
            });
        }
        return report;
    }

    protected Map bizCheckForSubmit(Context ctx, List ids) throws BOSException, EASBizException {
        throw new RuntimeException(ResourceBase.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"BizBill_NO_RealseMethod", (Locale)ctx.getLocale()));
    }

    protected Map bizCheckForSubmit(Context ctx, List ids, Map param) throws BOSException, EASBizException {
        return this.bizCheckForSubmit(ctx, ids);
    }

    @Override
    protected void _logPrint(Context ctx, BOSObjectType BosType, String logItemName, IObjectValue model) throws BOSException {
        IObjectPK pklog = null;
        pklog = model == null ? LogUtil.beginLog((Context)ctx, (String)"print", (BOSObjectType)BosType, null, null, (String)logItemName) : LogUtil.beginLog((Context)ctx, (String)"print", (BOSObjectType)BosType, null, (String)model.getString("number"), (String)logItemName);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
    }

    private IObjectPK[] recycleBatchNumber(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("companyOrg.id");
        sic.add("calculatePeriod.id");
        CMBillBaseCollection billColl = this.getBillCollValid(ctx, arrayPK, sic);
        if (billColl == null || billColl.isEmpty()) {
            throw new CMBillException(CMBillException.CANNOT_DELETE);
        }
        int pksSize = billColl.size();
        ObjectUuidPK[] pks = new ObjectUuidPK[pksSize];
        for (int i = 0; i < pksSize; ++i) {
            pks[i] = new ObjectUuidPK(billColl.get(i).getId().toString());
        }
        this.checkStart(ctx, (IObjectCollection)billColl);
        CMBillBaseInfo info = billColl.get(0);
        String companyId = info.getCompanyOrg().getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isExistCodingRule = iCodingRuleManager.isExist((IObjectValue)info, companyId);
        if (isExistCodingRule) {
            String[] numbers = new String[billColl.size()];
            int size = billColl.size();
            for (int i = 0; i < size; ++i) {
                numbers[i] = billColl.get(i).getNumber();
            }
            iCodingRuleManager.recycleBatchNumber((IObjectValue)info, companyId, numbers);
        }
        return pks;
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        botpSelectors.add(new SelectorItemInfo("billStatus"));
        botpSelectors.add(new SelectorItemInfo("number"));
        return super._generateVoucher(ctx, sourceBillPkList, botMappingPK, botpSelectors);
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        CMBillBaseInfo ncmbill = null;
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            ncmbill = (CMBillBaseInfo)sourceBillCollection.getObject(i);
            if (ncmbill.getBillStatus().equals((Object)BillBaseStatusEnum.AUDITED)) continue;
            throw new NcmBillException(NcmBillException.MUSTAUDIT, (Object[])new String[]{ncmbill.getNumber()});
        }
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }
}

