/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.cal.report.NCMReportHelper;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.app.AbstractCMVoucherBaseControllerBean;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMGenVoucherHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CMVoucherBaseControllerBean
extends AbstractCMVoucherBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)CMVoucherBaseControllerBean.class.getName());

    protected void generbyArrayList(Context ctx, List tempTblIdList, Set srcBillIdSet, String botMappingId, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        if (tempTblIdList.isEmpty()) {
            return;
        }
        IObjectPK[] srcBillPks = new IObjectPK[tempTblIdList.size()];
        for (int i = 0; i < tempTblIdList.size(); ++i) {
            srcBillPks[i] = new ObjectUuidPK(tempTblIdList.get(i).toString());
        }
        DAPTransformResult dapResult = NCMGenVoucherHelper.generateVoucher(ctx, srcBillPks, botMappingPK, botpSelectors);
        if (dapResult == null || dapResult.getVoucherCollection() == null || dapResult.getVoucherCollection().isEmpty()) {
            return;
        }
        VoucherCollection voucherColl = (VoucherCollection)dapResult.getVoucherCollection();
        String voucherId = voucherColl.get(0).getId().toString();
        HashMap<String, String> botpRelationMap = new HashMap<String, String>();
        Iterator iterator = srcBillIdSet.iterator();
        while (iterator.hasNext()) {
            botpRelationMap.put(iterator.next().toString(), voucherId);
        }
        NCMUtils.saveBOTRelation(ctx, botpRelationMap, botMappingId);
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(this.getSourceBillTableName()).append(" set FFivouchered=1 , fvoucherid='").append(voucherId).append("' where 1=1 and ").append(StringUtil.buildIn((String)" FID ", (Object[])srcBillIdSet.toArray()));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        tempTblIdList.clear();
        srcBillIdSet.clear();
    }

    public String getMappingIdByCU(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys) throws BOSException, EASBizException {
        String boMappId = null;
        try {
            IRowSet mapRs = NCMUtils.getMappingByCU(ctx, sourceBillType, targetBillType, defineSys);
            if (mapRs == null || mapRs.size() < 1) {
                this.throwExceptionForNoDAP();
            }
            while (mapRs.next()) {
                boMappId = mapRs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return boMappId;
    }

    protected void throwExceptionForNoDAP() throws CMBillException {
        throw new CMBillException(CMBillException.NO_MATERIALREQ_VOUCHER);
    }

    @Override
    protected void _addVoucherByAll(Context ctx, List idList, String companyId, String periodId, BOTMappingInfo botpInfo) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        String matAllocResultTblName = this.getDynamicTableName(ctx, companyId);
        this.genTempVoucherData(ctx, matAllocResultTblName, companyId, periodId, idList, true);
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid,FSourceBillID from ").append(this.getMainTableName(ctx, null)).append(" where").append(" FCompanyorg='").append(companyId).append("' AND FCalculatePeriod='").append(periodId).append("' and ").append(StringUtil.buildIn((String)" FSourceBillID ", (Object[])idList.toArray())).append("order by FSourceBillID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() == 0) {
            throw new NcmBillException(NcmBillException.CHECK_FIVOUCHERED);
        }
        String boMappId = this.getMappingIdByCU(ctx, this.getSourceBillType(), this.getTargetBillType(), DefineSysEnum.DAP);
        SelectorItemCollection botSelectors = null;
        ObjectUuidPK botpID = new ObjectUuidPK(botpInfo.getId());
        try {
            botSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)botpInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        List tempTableIdList = this.getTempTblIdList(ctx, companyId, periodId);
        Set srcBillIdSet = this.getSrcBillIdSet(ctx, matAllocResultTblName, companyId, periodId, idList);
        this.generbyArrayList(ctx, tempTableIdList, srcBillIdSet, boMappId, (IObjectPK)botpID, botSelectors);
        this.delTempVoucherData(ctx, idList);
    }

    private List getTempTblIdList(Context ctx, String companyId, String periodId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid from  ").append(this.getMainTableName(ctx, null)).append(" where FCompanyorg= ? AND FCalculatePeriod = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodId});
        ArrayList<String> tempTblIdList = new ArrayList<String>();
        try {
            while (rs.next()) {
                String Id = rs.getString(1);
                tempTblIdList.add(Id);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"0_CMVoucherBaseControllerBean", (Locale)ctx.getLocale()) + tempTblIdList.size()));
        return tempTblIdList;
    }

    private Set getSrcBillIdSet(Context ctx, String matAllocResultTblName, String companyId, String periodId, List idList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.FSourceBillID from ").append(matAllocResultTblName).append(" as a , ").append(this.getSourceBillTableName()).append(" as b").append(" where  a.FSourceBillID = b.fid and (b.ffivouchered = 0 or b.ffivouchered is null) and b.FBillStatus = 4  ").append(" and ").append(StringUtil.buildIn((String)" b.FID ", (Object[])idList.toArray()));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> srcBillSet = new HashSet<String>();
        try {
            while (rs.next()) {
                srcBillSet.add(rs.getString("FSourceBillID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"1_CMVoucherBaseControllerBean", (Locale)ctx.getLocale()) + srcBillSet.size()));
        return srcBillSet;
    }

    @Override
    protected void _addVoucherByBill(Context ctx, List idList, String companyId, String periodId, BOTMappingInfo botpInfo) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        String matAllocResultTblName = this.getDynamicTableName(ctx, companyId);
        this.genTempVoucherData(ctx, matAllocResultTblName, companyId, periodId, idList, false);
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid,FSourceBillID from ").append(this.getMainTableName(ctx, null)).append(" where").append(" FCompanyorg='").append(companyId).append("' AND FCalculatePeriod='").append(periodId).append("' and ").append(StringUtil.buildIn((String)" FSourceBillID ", (Object[])idList.toArray())).append("order by FSourceBillID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() == 0) {
            throw new NcmBillException(NcmBillException.CHECK_FIVOUCHERED);
        }
        String boMappId = this.getMappingIdByCU(ctx, this.getSourceBillType(), this.getTargetBillType(), DefineSysEnum.DAP);
        SelectorItemCollection botSelectors = null;
        ObjectUuidPK botpID = new ObjectUuidPK(botpInfo.getId());
        try {
            botSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)botpInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HashSet<String> srcBillIdSet = new HashSet<String>();
        ArrayList<String> tempTableIdList = new ArrayList<String>();
        try {
            while (rs.next()) {
                String Id = rs.getString(1);
                String sourceBillID = rs.getString(2);
                if (srcBillIdSet.contains(sourceBillID)) {
                    tempTableIdList.add(Id);
                    continue;
                }
                this.generbyArrayList(ctx, tempTableIdList, srcBillIdSet, boMappId, (IObjectPK)botpID, botSelectors);
                srcBillIdSet.add(sourceBillID);
                tempTableIdList.add(Id);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.generbyArrayList(ctx, tempTableIdList, srcBillIdSet, boMappId, (IObjectPK)botpID, botSelectors);
        this.delTempVoucherData(ctx, idList);
    }

    private void genTempVoucherData(Context ctx, String matAllocResultTblName, String companyId, String periodId, List idList, boolean isByAll) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)("DELETE FROM " + this.getMainTableName(ctx, null)));
        String sql = "";
        sql = isByAll ? this.buildTempVoucherDataByAll(ctx, companyId, periodId, idList, matAllocResultTblName) : this.buildTempVoucherDataByBill(ctx, companyId, periodId, idList, matAllocResultTblName);
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected String buildTempVoucherDataByBill(Context ctx, String companyId, String periodId, List idList, String matAllocResultTblName) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(this.getMainTableName(ctx, null)).append("(").append("FID,FCostCenterID,FSourceBillID,FCostObjectID,FCostItemID,FAmount,FCreatorID,").append("FCreateTime,FIsDirect,FNumber,").append("FbizDate,FExpenseID,FCompanyOrg,FCalculatePeriod,FMaterialID,FQty,FPrice) ").append("select newbosid('").append(this.getAllocVoucherResultBOSType()).append("') ,a.FCostCenterID,a.FSourceBillID ,a.FCostObjectID ,a.FCostItemID,").append("\ta.FAmount,a.FCreatorID ,a.FCreateTime ,a.FIsDirect,b.FNumber,b.fbizdate,'").append("ml7t5QEaEADgAAwawKgRe0olWCc=").append("','").append(companyId).append("','").append(periodId).append("',FMaterialID,FQty,FPrice  from ").append(matAllocResultTblName).append(" as a ,  ").append(this.getSourceBillTableName()).append("  as b").append(" where  a.FSourceBillID=b.fid and b.ffivouchered=0 and b.FBaseStatus=4  ").append(" and ").append(StringUtil.buildIn((String)" b.FID ", (Object[])idList.toArray()));
        return sql.toString();
    }

    protected String buildTempVoucherDataByAll(Context ctx, String companyId, String periodId, List idList, String matAllocResultTblName) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(this.getMainTableName(ctx, null)).append("(").append("FID,FCostCenterID,FSourceBillID,FCostObjectID,FCostItemID,FAmount,FCreatorID,").append("FCreateTime,FIsDirect,FNumber,").append("FbizDate,FExpenseID,FCompanyOrg,FCalculatePeriod,FMaterialID,FQty,FPrice) ").append("select newbosid('").append(this.getAllocVoucherResultBOSType()).append("'), a.FCostCenterID, max(a.FSourceBillID) ,a.FCostObjectID ,a.FCostItemID,").append("\tsum(a.FAmount), max(a.FCreatorID) ,max(a.FCreateTime) ,1, max(b.FNumber),max(b.fbizdate),'").append("ml7t5QEaEADgAAwawKgRe0olWCc=").append("','").append(companyId).append("','").append(periodId).append("',FMaterialID,sum(FQty), ");
        NCMReportHelper.AppendCaseSQLClause((StringBuffer)sql, (String)"sum(a.famount)", (String)"sum(fqty)", (String)"0", (String)"FPrice", (String)"10");
        sql.append(matAllocResultTblName).append(" as a ,  ").append(this.getSourceBillTableName()).append("  as b").append(" where  a.FSourceBillID=b.fid and b.ffivouchered=0 and b.FBaseStatus=4  ").append(" and ").append(StringUtil.buildIn((String)" b.FID ", (Object[])idList.toArray())).append(" GROUP BY a.FCostCenterID, a.FCostObjectID, a.FCostItemID, FMaterialID");
        return sql.toString();
    }

    public void delTempVoucherData(Context ctx, List idList) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete ").append(this.getMainTableName(ctx, null)).append(" where").append(" 1=1 and ").append(StringUtil.buildIn((String)" FSourceBillID ", (Object[])idList.toArray()));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum billOperStateEnum, IObjectValue relationInfo) throws BOSException, EASBizException {
    }

    protected void _reverseSave(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    public void checkStart(Context ctx, IObjectValue model) throws EASBizException, BOSException {
    }

    protected boolean _checkNumberDup(Context arg0, IObjectPK arg1, IObjectValue arg2) throws EASBizException, BOSException {
        return false;
    }

    protected boolean _checkNumberBlank(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        return false;
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] pks, IObjectCollection srcBillColl, BOTBillOperStateEnum billOperStateEnum, IObjectCollection botRelationColl) throws BOSException {
    }

    @Override
    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return null;
    }

    protected String getAllocVoucherResultBOSType() {
        return null;
    }

    protected String getSourceBillTableName() {
        return null;
    }

    protected String getSourceBillType() {
        return null;
    }

    public String getTargetBillType() {
        return "2652E01E";
    }

    protected String getDynamicTableName(Context ctx, String companyId) throws EASBizException, BOSException {
        return null;
    }
}

