/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.ncm.common.utils.NCMCommonParams;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.util.Assert;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CalcTable {
    private static Logger logger = Logger.getLogger((String)CalcTable.class.getName());
    protected Map _param = null;
    protected NCMCommonParams _ncmCommonParam;
    protected Context _ctx;
    protected String _companyId;
    protected String _periodId;
    protected String _tblCostCalResult = null;
    protected String _tblCostCalMatDetailResult = null;
    protected String _tblCostCalPrdDetailResult = null;
    protected String _tempTblCostCalResult = null;
    protected String _tempTblCostCalMatDetailResult = null;
    protected String _tblDataByCostObj = null;
    protected String _tblDataByProduct = null;
    protected String _tblMatAllocResult = null;
    protected String _tblOtherAllocResult = null;
    protected String _tblAuxAllocResult = null;
    protected String _tblLinearEquations = null;
    protected String _tblAugmentedMatrix = null;
    protected String _tblBalance = null;
    protected String _tblBalanceEntry = null;
    protected String _tblBalanceMatDetail = null;
    protected Connection _globalConnection = null;
    protected TempTablePool _pool = null;
    protected String _tblResult = null;
    protected String _tempTblObjectRange = null;
    protected Map _tblAllocDataCache = null;
    protected String _tblCostCalRevertInfo = null;
    private String _tempTblCostObjList = null;
    private boolean isUseSystemTempTable = true;
    private boolean isNeedRebuildTempTable = true;

    public CalcTable(Map param) throws Exception {
        int dbType;
        boolean isOracle;
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("userId"));
        this._param = param;
        this._ctx = (Context)this._param.get("ctx");
        this._companyId = (String)this._param.get("companyId");
        this._periodId = (String)this._param.get("periodId");
        this._globalConnection = (Connection)this._param.get("globalConnection");
        this._pool = TempTablePool.getInstance((Context)this._ctx);
        Object value = param.get("isUseSystemTempTable");
        if (value != null && value instanceof Boolean) {
            this.isUseSystemTempTable = (Boolean)value;
        }
        if ((isOracle = DbType.isOracle((int)(dbType = DbType.getValue((String)((String)this._ctx.get((Object)"dbType")))))) && this.isUseSystemTempTable) {
            this.isNeedRebuildTempTable = false;
        }
        this.setResultTableInfo();
    }

    public CalcTable(NCMCommonParams param) throws Exception {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("userId"));
        this._ncmCommonParam = param;
        this._ctx = this._ncmCommonParam.getCTX();
        this._companyId = this._ncmCommonParam.getCOMPANY_ID();
        this._periodId = this._ncmCommonParam.getPERIOD_ID();
        this._globalConnection = (Connection)this._ncmCommonParam.getGolbalConnection();
        this._pool = TempTablePool.getInstance((Context)this._ctx);
        this.setResultTableInfo();
    }

    protected void setResultTableInfo() throws Exception {
        this._tblCostCalResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_CostCalResult");
        this._tblCostCalMatDetailResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_CostCalMatDetailResult");
        this._tblCostCalPrdDetailResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_CostCalPrdDetailResult");
        this._tblMatAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_MatAllocResult");
        this._tblOtherAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_OtherAllocResult");
        this._tblAuxAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_AuxAllocResult");
        this._tblLinearEquations = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_LinearEquations");
        this._tblAugmentedMatrix = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_AugmentedMatrix");
        this._tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_Balance");
        this._tblBalanceEntry = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_BalanceEntry");
        this._tblBalanceMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_BalanceMatDetail");
        this._tblDataByCostObj = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_DataByCostObj");
        this._tblDataByProduct = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_DataByProduct");
        this._tblCostCalRevertInfo = NCMDynamicTableManager.getPhysicalTblNameWithCreate(this._ctx, this._companyId, "T_NCM_CostCalRevertInfo");
        this.setTmpResultTableInfo();
    }

    protected void setTmpResultTableInfo() throws Exception {
        this._tempTblCostObjList = this._pool.createTempTable("Create Table t_tempTblCostObjList (FCostObjectID VARCHAR(44))");
    }

    public void createTempCostCalResultTable() throws Exception {
        if (this._tempTblCostCalResult != null) {
            return;
        }
        String ksql = "create table T (FID varchar(44),FCostCenterID varchar(44),FCostObjectID varchar(44),FCostItemID varchar(44),FAllocStdID VARCHAR(44),FAllocStdData NUMERIC(24,12) DEFAULT 0,FFinishedAmount NUMERIC(17,4) DEFAULT 0,FEoPWIPAmount NUMERIC(17,4) DEFAULT 0,FRecvAmount NUMERIC(17,4) DEFAULT 0,FAmount NUMERIC(17,4) DEFAULT 0,FQty NUMERIC(21,8) DEFAULT 0,FFinishedQty NUMERIC(21,8) DEFAULT 0, FEoPWIPQty NUMERIC(21,8) DEFAULT 0,FIsMatType INT DEFAULT 0,FTotalFinishedQty NUMERIC(21,8) DEFAULT 0, FTotalEoPWIPQty NUMERIC(21,8) DEFAULT 0,FAmountPrecision INT DEFAULT 2,FQtyPrecision INT DEFAULT 8 , FEoPWIPAssistQty NUMERIC(21,8) DEFAULT 0,FFinishedAssistQty NUMERIC(21,8) DEFAULT 0,FEoPWIPAddQty NUMERIC(21,8) DEFAULT 0,FFinishedAddQty NUMERIC(21,8) DEFAULT 0,FUnitID varchar(44),FAssistQty NUMERIC(21,8) DEFAULT 0 ,FAssistQtyPrecision INT DEFAULT 8 ,FAddqty NUMERIC(21,8) DEFAULT 0 , FAddqtyPrecision INT DEFAULT 8)";
        this._tempTblCostCalResult = this.isUseSystemTempTable ? this._pool.createDBSystemTempTable(ksql, this._globalConnection) : this._pool.createTempTable(ksql);
        if (!this.isNeedRebuildTempTable) {
            this.doCreateTempCostCalResultTableIndex();
        }
    }

    public void createTempCostCalResultTableIndex() throws Exception {
        if (this.isNeedRebuildTempTable) {
            this.doCreateTempCostCalResultTableIndex();
        }
    }

    private void doCreateTempCostCalResultTableIndex() throws Exception {
        if (this.isUseSystemTempTable) {
            this._pool.createDBSystemTempTableIndex(this._tempTblCostCalResult, "FID", false, false, this._globalConnection);
            this._pool.createDBSystemTempTableIndex(this._tempTblCostCalResult, "FCostCenterID,FCostObjectID,FCostItemID", false, false, this._globalConnection);
            this._pool.createDBSystemTempTableIndex(this._tempTblCostCalResult, "FAllocStdID", false, false, this._globalConnection);
        } else {
            this._pool.createIndex(this._tempTblCostCalResult, "FID", false, false);
            this._pool.createIndex(this._tempTblCostCalResult, "FCostCenterID,FCostObjectID,FCostItemID", false, false);
            this._pool.createIndex(this._tempTblCostCalResult, "FAllocStdID", false, false);
        }
    }

    public void clearTempCostCalResultTable() throws Exception {
        if (this.isNeedRebuildTempTable) {
            if (this.isUseSystemTempTable) {
                if (this._tempTblCostCalResult != null) {
                    this._pool.releaseDBSystemTempTable(this._tempTblCostCalResult, this._globalConnection);
                }
            } else if (this._tempTblCostCalResult != null) {
                this._pool.releaseTable(this._tempTblCostCalResult);
            }
            this._tempTblCostCalResult = null;
        } else {
            NCMDbUtil.execute(this._ctx, "truncate table " + this._tempTblCostCalResult, this._globalConnection);
        }
    }

    public void createTempCostCalMatDetailResultTable() throws Exception {
        if (this._tempTblCostCalMatDetailResult != null) {
            return;
        }
        String ksql = "Create Table T ( FID VARCHAR(44) NOT NULL,FParentID VARCHAR(44) NULL,FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FLot NVARCHAR(80),FAllocStdID VARCHAR(44),FAllocStdData NUMERIC(24,12) DEFAULT 0,FFinishedQty NUMERIC(21,8) DEFAULT 0,FEoPWIPQty NUMERIC(21,8) DEFAULT 0,FFinishedAmount NUMERIC(17,4) DEFAULT 0,FEoPWIPAmount NUMERIC(17,4) DEFAULT 0,FAmount NUMERIC(17,4) DEFAULT 0, FQty NUMERIC(21,8) DEFAULT 0, FIsSelfManufacture INT DEFAULT 0, FSpendCostObjectID VARCHAR(44), FPricePrecision INT DEFAULT 8,FQtyPrecision INT DEFAULT 8,FAmountPrecision INT DEFAULT 2, FIsReWork INT DEFAULT 0, FEoPWIPAssistQty NUMERIC(21,8) DEFAULT 0,FFinishedAssistQty NUMERIC(21,8) DEFAULT 0,FEoPWIPAddQty NUMERIC(21,8) DEFAULT 0,FFinishedAddQty NUMERIC(21,8) DEFAULT 0,FUnitID varchar(44),FAssistQty NUMERIC(21,8) DEFAULT 0 ,FAssistQtyPrecision INT DEFAULT 8 ,FAddqty NUMERIC(21,8) DEFAULT 0 , FAddqtyPrecision INT DEFAULT 8, FWIPCoefQty  NUMERIC(21,8) DEFAULT 0, FWIPCoefAmount NUMERIC(21,8) DEFAULT 0 , FPrice NUMERIC(21,8) DEFAULT 0 , FAddPrice NUMERIC(21,8) DEFAULT 0 , FAssistPrice NUMERIC(21,8) DEFAULT 0, FSourceBillID VARCHAR(44), FSourceBillEntryID VARCHAR(44), FIsDirect INT ) ";
        this._tempTblCostCalMatDetailResult = this.isUseSystemTempTable ? this._pool.createDBSystemTempTable(ksql, this._globalConnection) : this._pool.createTempTable(ksql);
        if (!this.isNeedRebuildTempTable) {
            this.doCreateTempCostCalMatDetailResultTableIndex();
        }
    }

    public void createTempCostCalMatDetailResultTableIndex() throws Exception {
        if (this.isNeedRebuildTempTable) {
            this.doCreateTempCostCalMatDetailResultTableIndex();
        }
    }

    private void doCreateTempCostCalMatDetailResultTableIndex() throws Exception {
        if (this.isUseSystemTempTable) {
            this._pool.createDBSystemTempTableIndex(this._tempTblCostCalMatDetailResult, "FCostCenterID,FCostObjectID,FCostItemID", false, false, this._globalConnection);
            this._pool.createDBSystemTempTableIndex(this._tempTblCostCalMatDetailResult, "FMaterialID", false, false, this._globalConnection);
        } else {
            this._pool.createIndex(this._tempTblCostCalMatDetailResult, "FCostCenterID,FCostObjectID,FCostItemID", false, false);
            this._pool.createIndex(this._tempTblCostCalMatDetailResult, "FMaterialID", false, false);
        }
    }

    public void clearTempCostCalMatDetailResultTable() throws Exception {
        if (this.isNeedRebuildTempTable) {
            if (this.isUseSystemTempTable) {
                if (this._tempTblCostCalMatDetailResult != null) {
                    this._pool.releaseDBSystemTempTable(this._tempTblCostCalMatDetailResult, this._globalConnection);
                }
            } else if (this._tempTblCostCalMatDetailResult != null) {
                this._pool.releaseTable(this._tempTblCostCalMatDetailResult);
            }
            this._tempTblCostCalMatDetailResult = null;
        } else {
            NCMDbUtil.execute(this._ctx, "truncate table " + this._tempTblCostCalMatDetailResult, this._globalConnection);
        }
    }

    public String GetCostCalResultTable() {
        return this._tblCostCalResult;
    }

    public String GetCostCalMatDetailResultTable() {
        return this._tblCostCalMatDetailResult;
    }

    public String GetCostCalPrdDetailResultTable() {
        return this._tblCostCalPrdDetailResult;
    }

    public String GetTemp_CostCalResultTable() {
        return this._tempTblCostCalResult;
    }

    public String GetTemp_CostCalMatDetailResultTable() {
        return this._tempTblCostCalMatDetailResult;
    }

    public String GetMatAllocResultTable() {
        return this._tblMatAllocResult;
    }

    public String GetOtherAllocResultTable() {
        return this._tblOtherAllocResult;
    }

    public String GetAuxAllocResultTable() {
        return this._tblAuxAllocResult;
    }

    public String GetLinearEquationsTable() {
        return this._tblLinearEquations;
    }

    public String GetAugmentedMatrixTable() {
        return this._tblAugmentedMatrix;
    }

    public String GetBalanceTable() {
        return this._tblBalance;
    }

    public String GetBalanceEntryTable() {
        return this._tblBalanceEntry;
    }

    public String GetBalanceMatDetailTable() {
        return this._tblBalanceMatDetail;
    }

    public String GetDataByCostObjTable() {
        return this._tblDataByCostObj;
    }

    public String GetCostCalRevertInfoTable() {
        return this._tblCostCalRevertInfo;
    }

    public String GetDataByProductTable() {
        return this._tblDataByProduct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String GetAllocDataTable(String factorFldCreateList) {
        if (this._tblAllocDataCache == null) {
            Class<CalcTable> clazz = CalcTable.class;
            // MONITORENTER : com.kingdee.eas.ncm.common.app.CalcTable.class
            this._tblAllocDataCache = Collections.synchronizedMap(new HashMap());
            // MONITOREXIT : clazz
        }
        if (this._tblAllocDataCache.containsKey(factorFldCreateList)) {
            return (String)this._tblAllocDataCache.get(factorFldCreateList);
        }
        StringBuffer createSqlTempTblAllocDataTable = new StringBuffer();
        createSqlTempTblAllocDataTable.append(" create table t_tempAllocData ( ").append(" FID varchar(44),").append(factorFldCreateList).append(" FRatio NUMERIC(24,12) Default(0) ,").append(" FRatioSum NUMERIC(24,12) Default(0) ,").append(" FAllocRatio NUMERIC(24,12) Default(0) ,").append(" FHasAllocData INT Default(0) )");
        String tblname = null;
        try {
            if (this.isUseSystemTempTable) {
                tblname = this._pool.createDBSystemTempTable(createSqlTempTblAllocDataTable.toString(), this._globalConnection);
                try {
                    this._pool.createDBSystemTempTableIndex(tblname, "FID", false, false, this._globalConnection);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            } else {
                tblname = this._pool.createTempTable(createSqlTempTblAllocDataTable.toString());
                try {
                    this._pool.createIndex(tblname, "FID", false, false);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
            this._tblAllocDataCache.put(factorFldCreateList, tblname);
            return tblname;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return tblname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTempTable() {
        try {
            if (this.isUseSystemTempTable) {
                if (this._tempTblCostCalResult != null) {
                    this._pool.releaseDBSystemTempTable(this._tempTblCostCalResult, this._globalConnection);
                }
                if (this._tempTblCostCalMatDetailResult != null) {
                    this._pool.releaseDBSystemTempTable(this._tempTblCostCalMatDetailResult, this._globalConnection);
                }
            } else {
                if (this._tempTblCostCalResult != null) {
                    this._pool.releaseTable(this._tempTblCostCalResult);
                }
                if (this._tempTblCostCalMatDetailResult != null) {
                    this._pool.releaseTable(this._tempTblCostCalMatDetailResult);
                }
            }
            if (this._tempTblCostObjList != null) {
                this._pool.releaseTable(this._tempTblCostObjList);
            }
            if (this._tblAllocDataCache != null) {
                for (Map.Entry entry : this._tblAllocDataCache.entrySet()) {
                    String tblname = (String)entry.getValue();
                    if (this.isUseSystemTempTable) {
                        this._pool.releaseDBSystemTempTable(tblname, this._globalConnection);
                        continue;
                    }
                    this._pool.releaseTable(tblname);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this._tempTblCostCalResult = null;
            this._tempTblCostCalMatDetailResult = null;
        }
    }

    public String GetTempTBL_CostObjList() {
        return this._tempTblCostObjList;
    }
}

