/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.app.AbstractNCMCommonFacadeControllerBean;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.scm.cal.CalculateKindRefactorBillInfo;
import com.kingdee.eas.scm.cal.CalculateKindRefactorEntryCollection;
import com.kingdee.eas.scm.cal.CalculateKindRefactorEntryInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NCMCommonFacadeControllerBean
extends AbstractNCMCommonFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.common.app.NCMCommonFacadeControllerBean");

    @Override
    protected Timestamp _getServerDate(Context ctx) throws BOSException {
        Calendar cal = Calendar.getInstance();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        return ts;
    }

    @Override
    protected String _getPhysicalTblName(Context ctx, String companyId, String busiTblName) throws BOSException {
        try {
            return NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, busiTblName);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return null;
    }

    @Override
    protected Object _doCancelabeTask(Context ctx, Map args) throws BOSException, EASBizException {
        while (!((Boolean)ctx.get((Object)"TaskCancelled")).booleanValue()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"", (Throwable)e);
            }
            String remark = Thread.currentThread().getName() + "_doCancelabTask\n" + ctx.getContextID() + "_" + System.currentTimeMillis();
            String sql = "Insert Into T_SUN_TEST(FREMARK) Values('" + remark + "')";
            DbUtil.execute((Context)ctx, (String)sql);
            logger.debug((Object)remark);
        }
        throw new EASBizException(EASBizException.RPCCOMMERR);
    }

    @Override
    protected void _setCancellationStatus(Context ctx, Object arg) throws BOSException, EASBizException {
        ctx.put((Object)"TaskCancelled", arg);
        String remark = Thread.currentThread().getName() + "_setCancellationStatus\n" + ctx.getContextID();
        logger.debug((Object)remark);
    }

    protected HashMap _getBaseInfoForWizardForm(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getBaseInfoForWizardForm(Context ctx, Map param) throws BOSException, EASBizException {
        Assert.that((boolean)param.containsKey("companyId"));
        String companyId = (String)param.get("companyId");
        HashMap<String, String> ret = new HashMap<String, String>();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        ret.put("IsCostStart", String.valueOf(sysctrol.isStart(1001, companyId)));
        PeriodInfo curPeriodInfo = null;
        if (sysctrol.isStart(1001, companyId)) {
            curPeriodInfo = sysctrol.getCacheCurrentPeriod(1001, companyId);
        }
        ret.put("currPeriod", (String)curPeriodInfo);
        return ret;
    }

    @Override
    protected Map _getBaseInfoForWizardForm_OrderCost(Context ctx, Map param) throws BOSException, EASBizException {
        Assert.that((boolean)param.containsKey("companyId"));
        String companyId = (String)param.get("companyId");
        HashMap<String, String> ret = new HashMap<String, String>();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        boolean isStart = false;
        isStart = sysctrol.isStart(1010, companyId);
        ret.put("IsCostStart", String.valueOf(isStart));
        PeriodInfo curPeriodInfo = null;
        if (isStart) {
            curPeriodInfo = sysctrol.getCacheCurrentPeriod(1010, companyId);
        }
        ret.put("currPeriod", (String)curPeriodInfo);
        return ret;
    }

    @Override
    protected String _getUIPermissiionItem(Context ctx, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        IServiceManager manager;
        IServiceBinder binder;
        ServiceBindItem[] bind;
        String permItemName = null;
        if (uiPK != null && actionPK != null && (bind = (binder = (manager = ServiceManagerFactory.getServiceManager()).getServiceBinder(ctx)).getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK)) != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)bind[i].getName())) continue;
                permItemName = bind[i].getName();
            }
        }
        return permItemName;
    }

    @Override
    protected String _getPermissionItem(Context ctx, BOSObjectType metaType, IMetaDataPK bosPK) throws BOSException, EASBizException {
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(metaType, bosPK);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                return permItemName;
            }
        }
        return null;
    }

    @Override
    protected boolean _isUsedCostObjectOfMateiral(Context ctx, CoreBillBaseInfo coreBillBaseInfo) throws BOSException, EASBizException {
        if (coreBillBaseInfo == null) {
            return false;
        }
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        String companyID = null;
        CalculateKindRefactorEntryCollection entries = null;
        AccountType newAccountType = null;
        AccountType oldAccountType = null;
        if (coreBillBaseInfo instanceof CalculateKindRefactorBillInfo) {
            if (((CalculateKindRefactorBillInfo)coreBillBaseInfo).getCompanyOrgUnit() != null) {
                companyID = ((CalculateKindRefactorBillInfo)coreBillBaseInfo).getCompanyOrgUnit().getId().toString();
            }
            entries = ((CalculateKindRefactorBillInfo)coreBillBaseInfo).getEntry();
            newAccountType = ((CalculateKindRefactorBillInfo)coreBillBaseInfo).getNewAccountType();
            oldAccountType = ((CalculateKindRefactorBillInfo)coreBillBaseInfo).getSoureAccountType();
        }
        if (entries == null || entries.size() < 1 || companyID == null) {
            return false;
        }
        if (!sysctrol.isStart(1001, companyID)) {
            return false;
        }
        for (int i = 0; i < entries.size(); ++i) {
            CalculateKindRefactorEntryInfo entryInfo = entries.get(i);
            if (entryInfo.getMaterial() == null || entryInfo.getMaterial().getId() == null) continue;
            String materialID = entryInfo.getMaterial().getId().toString();
            this.isUsedCostObjectOfMateiral(ctx, materialID, companyID, newAccountType, oldAccountType);
        }
        return false;
    }

    private boolean isUsedCostObjectOfMateiral(Context ctx, String materialID, String companyID, AccountType newAccountType, AccountType oldAccountType) throws BOSException, EASBizException {
        String tblBalance = null;
        PeriodInfo period = NCMUtils.GetCurrentPeriod(ctx, companyID);
        String periodID = period.getId().toString();
        int calculateMode = -1;
        calculateMode = oldAccountType.getValue() == AccountType.SPECIAL_ACCT.getValue() ? 4 : 1;
        String getCOSql = "select co.fid fid,co.FNumber fnumber from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '" + companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getCOSql);
        String costobjectID = null;
        String costObjectNumber = null;
        HashMap<String, String> costObjectMap = null;
        try {
            if (rs != null) {
                tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyID, "T_NCM_Balance");
                costObjectMap = new HashMap<String, String>();
                while (rs.next()) {
                    costobjectID = rs.getString("fid");
                    costObjectNumber = rs.getString("fnumber");
                    costObjectMap.put(costobjectID, costObjectNumber);
                }
            } else {
                return false;
            }
            StringBuffer sb = new StringBuffer();
            sb.setLength(0);
            sb.append("  select top 1 bill.FCostobjectID fid from " + tblBalance + " bill \n").append("  where bill.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u671f\u521d\u4f59\u989d\u8868"});
            }
            sb.setLength(0);
            sb.append("  select top 1 entry.FCostobjectID fid from T_IM_ManufactureRecBillEntry entry \n").append("  inner join T_IM_ManufactureRecBill bill on bill.Fid = entry.FParentID ").append("    and entry.FCompanyOrgUnitID = '").append(companyID).append("' \n").append("    and bill.FYear = ").append(period.getPeriodYear()).append(" \n").append("    and bill.FPeriod = ").append(period.getPeriodNumber()).append(" \n").append("  where entry.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u5b8c\u5de5\u5165\u5e93\u5355"});
            }
            sb.setLength(0);
            sb.append("  select top 1 entry.FCostobjectID fid from T_IM_MaterialReqBillEntry entry \n").append("  inner join T_IM_MaterialReqBill bill on bill.Fid = entry.FParentID ").append("    and entry.FCompanyorgUnitID = '").append(companyID).append("' \n").append("    and bill.FYear = ").append(period.getPeriodYear()).append(" \n").append("    and bill.FPeriod = ").append(period.getPeriodNumber()).append(" \n").append("  where entry.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u9886\u6599\u51fa\u5e93\u5355"});
            }
            sb.setLength(0);
            sb.append("  select top 1 entry.FCostobjectID fid from T_NCM_OtherFeeBillEntry entry \n").append("  inner join T_NCM_OtherFeeBill bill on bill.Fid = entry.FParentID ").append("    and bill.FCompanyOrg = '").append(companyID).append("' and FCalculatePeriod = '").append(periodID).append("' \n").append("  where entry.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u5176\u5b83\u8d39\u7528\u5f52\u96c6\u5355"});
            }
            sb.setLength(0);
            sb.append("  select top 1 entry.FCostobjectID fid from T_NCM_ActualHourEntry entry \n").append("  inner join T_NCM_ActualHour bill on bill.Fid = entry.FParentID ").append("    and bill.FCompanyOrg = '").append(companyID).append("' and bill.FCalculatePeriod = '").append(periodID).append("' \n").append("  where entry.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u5b9e\u9645\u5de5\u65f6"});
            }
            sb.setLength(0);
            sb.append("  select top 1 bill.FCostobjectID fid from T_NCM_AllocStdSetByClass bill \n").append("  where bill.FCompanyID = '").append(companyID).append("' and bill.FCalculatePeriodID = '").append(periodID).append("' \n").append("  and bill.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u5206\u7c7b\u6cd5\u5206\u914d\u6807\u51c6\u8bbe\u7f6e"});
            }
            sb.setLength(0);
            sb.append("  select top 1 bill.FCostobjectID fid from T_NCM_AllocStdSetByWIP bill \n").append("  where bill.FCompanyID = '").append(companyID).append("' and bill.FCalculatePeriodID = '").append(periodID).append("' \n").append("  and bill.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u5728\u4ea7\u5206\u914d\u6807\u51c6\u8bbe\u7f6e"});
            }
            sb.setLength(0);
            sb.append("  select top 1 bill.FCostobjectID fid from T_NCM_BoPInvSFPCost bill \n").append("  where bill.FCompanyorg = '").append(companyID).append("' and bill.FCalculatePeriod = '").append(periodID).append("' \n").append("  and bill.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u671f\u521d\u534a\u4ea7\u54c1\u7ed3\u6784"});
            }
            sb.setLength(0);
            sb.append("  select top 1 bill.FCostobjectID fid from T_NCM_EquiCoefIntegrated bill \n").append("  where bill.FCompanyID = '").append(companyID).append("' and bill.FCalculatePeriodID = '").append(periodID).append("' \n").append("  and bill.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u7ea6\u5f53\u7cfb\u6570\u7ef4\u62a4(\u7efc\u5408)"});
            }
            sb.setLength(0);
            sb.append("  select top 1 bill.FCostobjectID fid from T_NCM_EquivalentCoef bill \n").append("  where bill.FCompanyID = '").append(companyID).append("' and bill.FCalculatePeriodID = '").append(periodID).append("' \n").append("  and bill.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u7ea6\u5f53\u7cfb\u6570\u7ef4\u62a4(\u9879\u76ee)"});
            }
            sb.setLength(0);
            sb.append("  select top 1 entry.FCostobjectID fid from T_NCM_GLFetchDataEntry entry \n").append("  inner join T_NCM_GLFetchData bill on bill.Fid = entry.FParentID ").append("    and bill.FCompanyOrg = '").append(companyID).append("' and FCalculatePeriod = '").append(periodID).append("' \n").append("  where entry.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u603b\u8d26\u53d6\u6570\u65b9\u6848"});
            }
            sb.setLength(0);
            sb.append("  select top 1 bill.FCostobjectID fid from T_NCM_InitBalance bill \n").append("  where bill.FCompanyOrg = '").append(companyID).append("' and bill.FCalculatePeriod = '").append(periodID).append("' \n").append("  and bill.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u671f\u521d\u4f59\u989d"});
            }
            sb.setLength(0);
            sb.append("  select top 1 entry.FConsumeCostobjectID fid from T_NCM_InnerOverheadBillEntry entry \n").append("  inner join T_NCM_InnerOverheadBill bill on bill.Fid = entry.FParentID ").append("    and bill.FCompanyOrg = '").append(companyID).append("' and FCalculatePeriod = '").append(periodID).append("' \n").append("  where entry.FConsumeCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u5185\u90e8\u8d39\u7528\u7ed3\u7b97\u5355"});
            }
            sb.setLength(0);
            sb.append("  select top 1 entry.FCostobjectID fid from T_NCM_InputQtyBillEntry entry \n").append("  inner join T_NCM_InputQtyBill bill on bill.Fid = entry.FParentID ").append("    and bill.FCompanyOrg = '").append(companyID).append("' and FCalculatePeriod = '").append(periodID).append("' \n").append("  where entry.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u6295\u5165\u4ea7\u91cf"});
            }
            sb.setLength(0);
            sb.append("  select top 1 bill.FCostobjectID fid from T_NCM_UnitStandardHour bill \n").append("  where bill.FCompanyOrg = '").append(companyID).append("' and bill.FCalculatePeriod = '").append(periodID).append("' \n").append("  and bill.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u5355\u4f4d\u6807\u51c6\u5de5\u65f6"});
            }
            sb.setLength(0);
            sb.append("  select top 1 bill.FCostobjectID fid from T_NCM_UserDefinedData bill \n").append("  where bill.FCompanyID = '").append(companyID).append("' and bill.FCalculatePeriodID = '").append(periodID).append("' \n").append("  and bill.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u81ea\u5b9a\u4e49\u5206\u914d\u6807\u51c6\u6570\u636e\u5f55\u5165"});
            }
            sb.setLength(0);
            sb.append("  select top 1 bill.FCostobjectID fid from T_NCM_WIPCountingBill bill \n").append("  where bill.FCompanyOrg = '").append(companyID).append("' and bill.FCalculatePeriod = '").append(periodID).append("' \n").append("  and bill.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u5728\u4ea7\u54c1\u76d8\u70b9"});
            }
            sb.setLength(0);
            sb.append("  select top 1 bill.FCostobjectID fid from T_NCM_WIPCountingMaterial bill \n").append("  where bill.FCompanyOrg = '").append(companyID).append("' and bill.FCalculatePeriod = '").append(periodID).append("' \n").append("  and bill.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u5728\u4ea7\u6750\u6599\u76d8\u70b9"});
            }
            sb.setLength(0);
            sb.append("  select top 1 entry.FCostobjectID fid from T_IM_OtherInWarehsBillEntry entry \n").append("  inner join T_IM_OtherInWarehsBill bill on bill.Fid = entry.FParentID ").append("    and entry.FCompanyOrgUnitID = '").append(companyID).append("' \n").append("    and bill.FYear = ").append(period.getPeriodYear()).append(" \n").append("    and bill.FPeriod = ").append(period.getPeriodNumber()).append(" \n").append("  where entry.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u5176\u4ed6\u5165\u5e93\u5355"});
            }
            sb.setLength(0);
            sb.append("  select top 1 entry.FCostobjectID fid from T_IM_OtherIssueBillEntry entry \n").append("  inner join T_IM_OtherIssueBill bill on bill.Fid = entry.FParentID ").append("    and entry.FCompanyOrgUnitID = '").append(companyID).append("' \n").append("    and bill.FYear = ").append(period.getPeriodYear()).append(" \n").append("    and bill.FPeriod = ").append(period.getPeriodNumber()).append(" \n").append("  where entry.FCostobjectID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null && rs.size() > 0) {
                if (rs.next()) {
                    costObjectNumber = (String)costObjectMap.get(rs.getString("fid"));
                }
                throw new CMBillException(CMBillException.COSTOBJECTISUSED, new String[]{costObjectNumber, "\u5176\u4ed6\u8c03\u6574\u5355"});
            }
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" Update T_BD_CostObject set FIsForbiden = 1 where FID in ( \n").append("select co.fid from T_BD_CostObject co  inner join T_BD_CostobjectEntry coEntry on co.Fid = coEntry.FParentID where co.FCompanyID = '").append(companyID + "' and coEntry.FRelatedID = '" + materialID + "' and FcalcuLateMode = " + calculateMode + ")");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        try {
            this.genNewCostObject(ctx, materialID, companyID, newAccountType);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private void genNewCostObject(Context ctx, String materialID, String companyID, AccountType newAccountType) throws BOSException, SQLException {
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        UserInfo UserInfo2 = (UserInfo)ctx.get((Object)"UserInfo");
        int calculateMode = -1;
        calculateMode = newAccountType.getValue() == AccountType.SPECIAL_ACCT.getValue() ? 4 : 1;
        StringBuffer sb = new StringBuffer();
        sb.append("select co.fid from T_BD_CostObject co \n").append(" inner join T_Bd_CostObjectEntry coEntry on co.FID = coEntry.FParentID \n").append("where co.FCompanyID = '").append(companyID).append("' \n").append("  and co.FcalcuLateMode = " + calculateMode).append("  and co.FIsForbiden = 1 \n").append("  and coEntry.FRelatedID = '").append(materialID).append("' \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (rs != null && rs.size() > 0) {
            sb.setLength(0);
            sb.append(" update T_BD_Costobject set FIsForbiden = 0 where fid in ( \n").append("select co.fid from T_BD_CostObject co \n").append(" inner join T_Bd_CostObjectEntry coEntry on co.FID = coEntry.FParentID \n").append(" where co.FCompanyID = '").append(companyID).append("' \n").append("  and co.FcalcuLateMode = " + calculateMode).append("  and co.FIsForbiden = 1 \n").append("  and coEntry.FRelatedID = '").append(materialID).append("') \n");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        } else {
            StringBuffer sql1 = new StringBuffer();
            StringBuffer sql2 = new StringBuffer();
            StringBuffer sql3 = new StringBuffer();
            sql1.append("insert into t_bd_costobject").append("(FID,FName_l1,FName_l2,FName_l3,FNumber ,FCompanyID ,FGroupId ,").append("FRelatedID ,FRelatedType ,FCalculateMode ,FIsSys,FStdProductIDID,FControlUnitID,FCreatorID, FCreateTime, FLastUpdateUserID,FLastUpdateTime,FCOGROUPID,FIsForbiden)").append("select  newbosid('39734A77') as fid,material.fname_l1,material.fname_l2,material.fname_l3,material.fnumber,materialcompany.fcompanyid,material.fmaterialgroupid,").append("material.fid,0," + calculateMode + ",1,material.fid,'").append(DefaultCU.getId().toString()).append("','").append(companyID).append("', GetDate() AS FCreateTime, '").append(UserInfo2.getId().toString()).append("', GetDate() AS FLastUpdateTime, ").append(" coGroup.fid ").append(" ,0  ").append(" from T_BD_Material as material ,T_BD_MaterialCompanyInfo as materialcompany,T_BD_CostObjectGroup coGroup").append(" where material.fid=materialcompany.FMaterialID and").append(" material.fid = '").append(materialID).append("' and \n").append(" material.fstatus=1 and materialcompany.fstatus=1 ").append(" and material.FMaterialGroupID = coGroup.FsourceID").append(" and materialcompany.FCalculateType=2  and materialcompany.FCompanyID='").append(companyID).append("' ");
            sql1.append("and (materialcompany.FCreateCOByOrder is null or materialcompany.FCreateCOByOrder = 0) ");
            sql2.append("insert into t_bd_costobjectentry ").append("(FID,FQuotiety,FParentID,FIsByproduct,FIsMainProduct,FRemark,FSeq,FRelatedID,FRelatedNumber ,FRelatedName)").append("select  newbosid('CC1BC03B') as fid,1.0,costobject.fid,0,1,material.fmodel,1,material.fid,material.fnumber,material.fname_l2").append(" from t_bd_costobject as costobject,t_bd_material as material where ").append("costobject.FStdProductIDID=material.fid and ").append(" costobject.fcompanyid='").append(companyID).append("'  and costobject.fissys=1").append("");
            sql3.append("update t_bd_costobject set fissys=0");
            DbUtil.execute((Context)ctx, (String)sql1.toString());
            DbUtil.execute((Context)ctx, (String)sql2.toString());
            DbUtil.execute((Context)ctx, (String)sql3.toString());
        }
    }

    @Override
    protected Map _getCostItemInfoByMatIDs(Context ctx, StorageOrgUnitInfo storageInfo, List materialIDs) throws BOSException, EASBizException {
        if (storageInfo == null || materialIDs == null) {
            return null;
        }
        HashMap<String, CostItemInfo> costItems = new HashMap<String, CostItemInfo>();
        String materialIdTable = null;
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(" CREATE TABLE calcSecTemp ");
        createTableSql.append(" (");
        createTableSql.append("   FMaterialID               VARCHAR(44)");
        createTableSql.append("  )");
        try {
            materialIdTable = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
            if (materialIdTable == null) {
                Map map = null;
                return map;
            }
            IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection coll = iOUR.getToUnit(storageInfo.getId().toString(), 4, 1);
            if (coll == null || coll.size() == 0) {
                Map map = null;
                return map;
            }
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)coll.get(0);
            this.initMaterialIDTable(ctx, materialIdTable, materialIDs);
            StringBuffer sql = new StringBuffer();
            sql.append("select ci.Fid FCostItemID,ci.Fname_" + ctx.getLocale() + " FCostItemName, ci.FNumber FCostItemNumber, matc.FMaterialID FMaterialID \n");
            sql.append("  From T_NCM_CostItem ci \n");
            sql.append("  Inner join T_BD_MaterialCost matc on matc.FDefaultCostItemID = ci.Fid \n");
            sql.append("  Inner join " + materialIdTable + " mat on mat.FMaterialID = matc.FMaterialid \n");
            sql.append("  where matc.FOrgunit = '" + companyInfo.getId().toString() + "' \n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                CostItemInfo ci = new CostItemInfo();
                ci.setId(BOSUuid.read((String)rs.getString("FCostItemID")));
                ci.setNumber(rs.getString("FCostItemNumber"));
                ci.setName(rs.getString("FCostItemName"));
                costItems.put(rs.getString("FMaterialID"), ci);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (materialIdTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(materialIdTable);
            }
        }
        return costItems;
    }

    @Override
    protected Map _getCostItemInfoByMats(Context ctx, StorageOrgUnitInfo storageInfo, List materialInfos) throws BOSException, EASBizException {
        if (storageInfo == null || materialInfos == null) {
            return null;
        }
        ArrayList<String> matIds = new ArrayList<String>();
        for (int i = 0; i < materialInfos.size(); ++i) {
            if (materialInfos.get(i) == null || !(materialInfos.get(i) instanceof MaterialInfo)) continue;
            MaterialInfo matInfo = (MaterialInfo)materialInfos.get(i);
            matIds.add(matInfo.getId().toString());
        }
        Map costItems = this.getCostItemInfoByMatIDs(ctx, storageInfo, matIds);
        return costItems;
    }

    @Override
    protected CostItemInfo _getCostItemInfoByMat(Context ctx, StorageOrgUnitInfo storageInfo, MaterialInfo materialInfo) throws BOSException, EASBizException {
        if (storageInfo == null || materialInfo == null) {
            return null;
        }
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOUR.getToUnit(storageInfo.getId().toString(), 4, 1);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)coll.get(0);
        StringBuffer sql = new StringBuffer();
        sql.append("select ci.Fid,ci.Fname_l2,ci.Fnumber From T_NCM_CostItem ci where fid in (\n");
        sql.append("  select matc.FDefaultCostItemID from T_BD_MaterialCost matc where matc.FMaterialid = '" + materialInfo.getId().toString() + "' \n");
        sql.append("      and matc.FOrgunit = '" + companyInfo.getId().toString() + "') \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        CostItemInfo ci = new CostItemInfo();
        try {
            if (rs.next()) {
                ci.setId(BOSUuid.read((String)rs.getString(1)));
                ci.setName(rs.getString(2));
                ci.setNumber(rs.getString(3));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ci;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initMaterialIDTable(Context ctx, String materialIdTable, List materialIDs) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmtInsert = null;
        try {
            StringBuffer sqlInsert = new StringBuffer();
            sqlInsert.append("INSERT INTO " + materialIdTable).append("(FMaterialID) VALUES(?)");
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sqlInsert.toString());
            for (int i = 0; i < materialIDs.size(); ++i) {
                pstmtInsert.setString(1, (String)materialIDs.get(i));
                pstmtInsert.addBatch();
            }
            pstmtInsert.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (Exception e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
    }
}

