/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ncm.common.DataConditionBaseInfo;
import com.kingdee.eas.ncm.common.DataSqlInfo;
import com.kingdee.eas.ncm.common.DataToolGroupInfo;
import com.kingdee.eas.ncm.common.NCMKSQLData;
import com.kingdee.eas.ncm.common.app.AbstractNCMDBUtilServerFacadeControllerBean;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.tools.datatask.DEBaseInfo;
import com.kingdee.eas.tools.datatask.DEDataTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class NCMDBUtilServerFacadeControllerBean
extends AbstractNCMDBUtilServerFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.common.app.NCMDBUtilServerFacadeControllerBean");
    private BufferedWriter sqlOut = null;
    private BufferedWriter deleSqlOut = null;

    @Override
    protected DataSqlInfo _exportData(Context ctx, DataConditionBaseInfo conditionInfo) throws BOSException, EASBizException {
        if (conditionInfo == null) {
            return null;
        }
        DataSqlInfo dataSql = new DataSqlInfo();
        if (conditionInfo.getScriptType() == 0) {
            dataSql.sql = this.exportDataByKsql(ctx, conditionInfo);
            dataSql.deletesql = this.genDeleteSql(conditionInfo.getTableName(), conditionInfo.getWhereStr());
        }
        return dataSql;
    }

    @Override
    protected void _importData(Context ctx, DataConditionBaseInfo conditionInfo) throws BOSException {
        Statement stmt;
        block10: {
            Statement ps;
            block9: {
                List<String> ksqls = conditionInfo.getKsqls();
                Connection conn = null;
                ps = null;
                stmt = null;
                boolean isNewGetConnection = false;
                try {
                    conn = (Connection)ctx.get((Object)"ConnectionKey");
                    if (conn == null) {
                        isNewGetConnection = true;
                        conn = EJBFactory.getConnection((Context)ctx);
                    }
                    stmt = conn.createStatement();
                    int count = 0;
                    for (String sql : ksqls) {
                        if (sql.startsWith("--")) continue;
                        stmt.addBatch(sql);
                        if (++count % 1000 != 0) continue;
                        stmt.executeBatch();
                        stmt.clearBatch();
                    }
                    if (count > 0 && count % 1000 != 0) {
                        stmt.executeBatch();
                        stmt.clearBatch();
                    }
                    if (!isNewGetConnection) break block9;
                }
                catch (SQLException exc) {
                    try {
                        logger.error((Object)exc);
                        throw new BOSException((Throwable)exc);
                    }
                    catch (Throwable throwable) {
                        if (isNewGetConnection) {
                            SQLUtils.cleanup(ps, (Connection)conn);
                            SQLUtils.cleanup(stmt);
                        } else {
                            SQLUtils.cleanup(ps);
                        }
                        SQLUtils.cleanup(stmt);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup(ps, (Connection)conn);
                SQLUtils.cleanup((Statement)stmt);
                break block10;
            }
            SQLUtils.cleanup(ps);
        }
        SQLUtils.cleanup((Statement)stmt);
    }

    @Override
    protected List _getAllchildsData(Context ctx, TreeBaseInfo treeNodeInfo) throws BOSException, EASBizException {
        ArrayList<DataConditionBaseInfo> exportDataList = new ArrayList<DataConditionBaseInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FTableName,isnull(FWhere,N' ') as FWhere,FIsRepeatExec From T_NCM_DataToolSolution t1 \n");
        sql.append("  inner join T_NCM_DataToolGroup t2 ON t2.FID = t1.FGroup \n");
        if (treeNodeInfo != null) {
            sql.append("where t2.FLongNumber like '%!" + treeNodeInfo.getNumber() + "' \n");
            sql.append("   or t2.FLongNumber like '%!" + treeNodeInfo.getNumber() + "!%' \n");
            sql.append("   or t2.FLongNumber like '" + treeNodeInfo.getNumber() + "!%' \n");
            sql.append("   or t2.FLongNumber = '" + treeNodeInfo.getNumber() + "' \n");
        }
        sql.append(" order by t2.FLongNumber desc,t1.FNumber desc \n");
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql.toString());
        try {
            while (rs.next()) {
                DataConditionBaseInfo condition = new DataConditionBaseInfo();
                condition.setTableName(rs.getString("FTableName"));
                condition.setWhereStr(rs.getString("FWhere"));
                if (rs.getInt("FIsRepeatExec") == 1) {
                    condition.setContainDel(true);
                } else {
                    condition.setContainDel(false);
                }
                exportDataList.add(condition);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return exportDataList;
    }

    private byte[] exportDataByKsql(Context ctx, DataConditionBaseInfo conditionInfo) throws BOSException, EASBizException {
        try {
            String tableName = conditionInfo.getTableName();
            String whereStr = conditionInfo.getWhereStr();
            ByteArrayOutputStream basqlout = new ByteArrayOutputStream();
            this.sqlOut = new BufferedWriter(new OutputStreamWriter((OutputStream)basqlout, "utf-8"));
            this.sqlOut.newLine();
            if (conditionInfo.isContainDel()) {
                this.deleteData(tableName, whereStr);
            }
            this.insertData(tableName, whereStr, this.getConnection(ctx));
            if ("T_NCM_DynamicTableMap".equalsIgnoreCase(conditionInfo.getTableName())) {
                this.dealInitBalaTblSql(ctx, conditionInfo);
            }
            return basqlout.toByteArray();
        }
        catch (UnsupportedEncodingException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void insertData(String tableName, String whereStr, Connection con) throws BOSException, IOException {
        if (tableName == null || tableName.trim().length() == 0) {
            return;
        }
        ResultSet result = null;
        Statement statement = null;
        ResultSetMetaData restmd = null;
        try {
            statement = con.createStatement();
            String sqlquery = "select * from " + tableName + " " + whereStr;
            result = statement.executeQuery(sqlquery);
            restmd = result.getMetaData();
            StringBuffer colNames = new StringBuffer(125);
            int colCount = restmd.getColumnCount();
            for (int i = 1; i <= colCount; ++i) {
                if (i == 1) {
                    colNames.append(restmd.getColumnName(i));
                    continue;
                }
                colNames.append(" , ").append(restmd.getColumnName(i));
            }
            this.dealSql(tableName, con, result, colNames);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(result, (Statement)statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)result, (Statement)statement, (Connection)con);
    }

    private void deleteData(String tableName, String whereStr) throws BOSException, IOException {
        if (tableName == null || tableName.trim().length() == 0) {
            return;
        }
        this.sqlOut.newLine();
        this.sqlOut.write("--\u8868\u540d: ");
        this.sqlOut.write(tableName);
        this.sqlOut.newLine();
        this.sqlOut.write("--\u7c7b\u578b\uff1aDelete");
        this.sqlOut.newLine();
        this.sqlOut.write("delete from ");
        this.sqlOut.write(tableName);
        this.sqlOut.write(" ");
        this.sqlOut.write(whereStr);
        this.sqlOut.write(";");
        this.sqlOut.newLine();
    }

    private void dealSql(String tableName, Connection con, ResultSet result, StringBuffer colNames) throws SQLException, IOException, BOSException {
        DEDataTypeEnum dataType;
        int iAllRow = 0;
        DEBaseInfo dEBaseInfo = new DEBaseInfo();
        dEBaseInfo.ExportDataType = dataType = DEDataTypeEnum.getEnum((String)"009");
        ResultSetMetaData restmd = result.getMetaData();
        int numberOfColumns = restmd.getColumnCount();
        this.sqlOut.newLine();
        this.sqlOut.write("--\u8868\u540d\uff1a" + tableName);
        this.sqlOut.newLine();
        this.sqlOut.write("--\u7c7b\u578b\uff1aInsert ");
        this.sqlOut.newLine();
        while (result.next()) {
            ++iAllRow;
            this.sqlOut.write("insert into ");
            this.sqlOut.write(tableName);
            this.sqlOut.write(" (");
            this.sqlOut.write(colNames.toString());
            this.sqlOut.write(")  values( ");
            for (int i = 1; i <= numberOfColumns; ++i) {
                if (i > 1) {
                    this.sqlOut.write(",");
                }
                this.sqlOut.write(NCMKSQLData.dealData(result, i, false, dEBaseInfo));
            }
            this.sqlOut.write(")");
            this.sqlOut.write(";");
            this.sqlOut.newLine();
        }
        this.sqlOut.write("--" + tableName + ":RowCount=" + iAllRow);
        this.sqlOut.newLine();
        this.sqlOut.flush();
    }

    private byte[] genDeleteSql(String tableName, String whereStr) throws BOSException {
        if (tableName == null || tableName.trim().length() == 0) {
            return null;
        }
        ByteArrayOutputStream deletebasqlout = new ByteArrayOutputStream();
        try {
            this.deleSqlOut = new BufferedWriter(new OutputStreamWriter((OutputStream)deletebasqlout, "utf-8"));
            this.deleSqlOut.newLine();
            this.deleSqlOut.newLine();
            this.deleSqlOut.write("--\u8868\u540d: ");
            this.deleSqlOut.write(tableName);
            this.deleSqlOut.newLine();
            this.deleSqlOut.write("--\u7c7b\u578b\uff1aDelete");
            this.deleSqlOut.newLine();
            this.deleSqlOut.write("delete from ");
            this.deleSqlOut.write(tableName);
            this.deleSqlOut.write(" ");
            this.deleSqlOut.write(whereStr);
            this.deleSqlOut.write(";");
            this.deleSqlOut.newLine();
            this.deleSqlOut.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        return deletebasqlout.toByteArray();
    }

    private void dealInitBalaTblSql(Context ctx, DataConditionBaseInfo conditionInfo) throws BOSException {
        String tableName = conditionInfo.getTableName();
        String whereStr = conditionInfo.getWhereStr();
        StringBuffer sql = new StringBuffer();
        sql.append("select FBusinesstblName,FPhysicalTblName From " + tableName + " \n" + whereStr);
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql.toString());
        try {
            while (rs.next()) {
                String businesstblName = rs.getString("FBusinesstblName");
                String PhysicalTblName = rs.getString("FPhysicalTblName");
                this.genInitBalaCreaSql(ctx, businesstblName, PhysicalTblName);
                this.deleteData(PhysicalTblName, "");
                this.insertData(PhysicalTblName, "", this.getConnection(ctx));
                this.genDeleteSql(PhysicalTblName, "");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void genInitBalaCreaSql(Context ctx, String businesstblName, String PhysicalTblName) throws IOException {
        this.sqlOut.newLine();
        this.sqlOut.write("--\u8868\u540d\uff1a" + PhysicalTblName);
        this.sqlOut.newLine();
        this.sqlOut.write("--\u7c7b\u578b\uff1aCreate ");
        this.sqlOut.newLine();
        this.sqlOut.write("If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='" + PhysicalTblName + "') ");
        String sql = null;
        if ("T_NCM_Balance".equalsIgnoreCase(businesstblName)) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCalculatePeriodID VARCHAR(44),FCompanyOrg VARCHAR(44),FCostObjectID VARCHAR(44),FCostCenterID VARCHAR(44),FBopWIPQty NUMERIC(28,10),FYTDFinishedQty NUMERIC(28,10),FBopWIPHour NUMERIC(28,10) NOT NULL DEFAULT 0,FAdjBopWipQty NUMERIC(28,10),FAdjBopWipHour NUMERIC(28,10),CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if ("T_NCM_BalanceEntry".equalsIgnoreCase(businesstblName)) {
            sql = "Create Table {0} (  FID VARCHAR(44) NOT NULL ,FParentID VARCHAR(44),FCostItemID VARCHAR(44),FYTDInputAmount NUMERIC(28,10),FBoPWIPAmount NUMERIC(28,10),FYTDFinishAmount NUMERIC(28,10), FBopWIPQty NUMERIC(28,10), FPrice NUMERIC(28,10), FAdjBopWipQty NUMERIC(28,10), FAdjBoPWipAmount NUMERIC(28,10), CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if ("T_NCM_BalanceMatDetail".equalsIgnoreCase(businesstblName)) {
            sql = "Create Table {0} (  FID VARCHAR(44) NOT NULL ,FMaterialID VARCHAR(44),FMaterialName NVARCHAR(80),FBatchNo NVARCHAR(80),FQty NUMERIC(28,10),FPrice NUMERIC(28,10),FAmount NUMERIC(28,10),FYTDInputMatQty NUMERIC(28,10),FYTDInputMatAmou NUMERIC(28,10),FYTDFinishedMatQ NUMERIC(28,10),FYTDFinishedMatA NUMERIC(28,10),FParentID VARCHAR(44),FUnitID VARCHAR(44),FAssistQty NUMERIC(28,10),FAddqty NUMERIC(28,10),FIsRework INT NOT NULL DEFAULT 0,FAdjQty NUMERIC(28,10),FAdjAmount NUMERIC(28,10), CONSTRAINT {1} PRIMARY KEY (FID))";
        }
        if (sql != null) {
            Object[] param = new Object[]{PhysicalTblName, this.getPKName()};
            sql = MessageFormat.format(sql, param);
            this.sqlOut.write(sql + ";");
        }
        this.sqlOut.newLine();
        this.sqlOut.flush();
    }

    private String getPKName() {
        String tablePkConstrait = new UUTN("ZC").toString();
        if (tablePkConstrait.length() > 10) {
            tablePkConstrait = tablePkConstrait.substring(0, 10);
        }
        tablePkConstrait = tablePkConstrait.replaceFirst("ZC", "PK_NCM");
        return tablePkConstrait;
    }

    @Override
    protected TreeBaseCollection _getSubGroupNode(Context ctx, TreeBaseInfo treeNodeInfo) throws BOSException, EASBizException {
        TreeBaseCollection coll = new TreeBaseCollection();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FNumber From T_NCM_DataToolGroup t1 \n");
        if (treeNodeInfo != null) {
            sql.append("where t1.FLongNumber like '" + treeNodeInfo.getLongNumber() + "!%' \n");
            sql.append("  and t1.FLevel = " + (treeNodeInfo.getLevel() + 1) + " \n");
        } else {
            sql.append(" Where t1.FLevel = 1 \n");
        }
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql.toString());
        try {
            while (rs.next()) {
                DataToolGroupInfo info = new DataToolGroupInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setNumber(rs.getString("FNumber"));
                coll.add((TreeBaseInfo)info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return coll;
    }
}

