/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.asynrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptCollection;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptFactory;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptInfo;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptSchemeCollection;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptSchemeFactory;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptSchemeInfo;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptUtils;
import com.kingdee.eas.ncm.common.asynrpt.app.AbstractAsynRptFacadeControllerBean;
import com.kingdee.eas.ncm.common.asynrpt.app.BaseAsynRpt;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class AsynRptFacadeControllerBean
extends AbstractAsynRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.common.asynrpt.app.AsynRptFacadeControllerBean");

    @Override
    protected RptParams _build(Context ctx, RptParams params) throws BOSException, EASBizException {
        String reportId = params.getString("asynrpt#key.report.id");
        if (reportId == null) {
            throw new BOSException("\u62a5\u8868UI\u6ca1\u6709\u5b9a\u4e49\u62a5\u8868\u7684ID\u3002");
        }
        try {
            int queryType = AsynRptUtils.getQueryType(params);
            if (queryType == 2) {
                return this.buildSolution(ctx, params);
            }
            return this.buildDynamic(ctx, params);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private RptParams buildDynamic(Context ctx, RptParams params) throws Exception {
        RptParams result = new RptParams();
        String reportId = params.getString("asynrpt#key.report.id");
        String solutionId = params.getString("asynrpt#key.solution.id");
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        AsynRptInfo report = this.getReport(ctx, reportId);
        BaseAsynRpt instance = this.createReport(ctx, report);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("report", (Object)reportId));
        filter.getFilterItems().add(new FilterItemInfo("solution", (Object)solutionId));
        filter.getFilterItems().add(new FilterItemInfo("queryType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)user.getId().toString()));
        AsynRptSchemeCollection coll = this.getSchemes(ctx, filter);
        AsynRptSchemeInfo scheme = null;
        if (coll.size() == 1) {
            scheme = coll.get(0);
        } else if (coll.size() > 1) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                AsynRptSchemeInfo error = (AsynRptSchemeInfo)it.next();
                instance.init(ctx, report, error, params);
                instance.deleteScheme();
            }
        }
        if (scheme != null) {
            if (scheme.getStatus() == 0) {
                if (scheme.getTmpTable() == null || AsynRptUtils.isTableExists(ctx, scheme.getTmpTable())) {
                    result.setString("asynrpt#key.scheme.id", scheme.getId().toString());
                    result.setBoolean("isBack", Boolean.TRUE.booleanValue());
                    return result;
                }
            } else if (AsynRptUtils.isTableExists(ctx, scheme.getTmpTable()) && !AsynRptUtils.isTableEmpty(ctx, scheme.getTmpTable())) {
                result.setString("asynrpt#key.scheme.id", scheme.getId().toString());
                result.setBoolean("isBack", Boolean.TRUE.booleanValue());
                return result;
            }
            instance.init(ctx, report, scheme, params);
            instance.deleteScheme();
        }
        scheme = new AsynRptSchemeInfo();
        scheme.setReport(reportId);
        scheme.setSolution(solutionId);
        scheme.setContext(ctx.getContextID());
        scheme.setQueryType(1);
        scheme.setTableType(1);
        scheme.setInstance("server1");
        scheme.setThread("solutionId");
        scheme.setCreator(user);
        scheme.setCreateTime(new Timestamp(System.currentTimeMillis()));
        AsynRptSchemeFactory.getLocalInstance(ctx).addnew(scheme);
        params.setString("asynrpt#key.scheme.id", scheme.getId().toString());
        instance.init(ctx, report, scheme, params);
        this.build(instance, scheme.getThread());
        result.setString("asynrpt#key.scheme.id", scheme.getId().toString());
        return result;
    }

    private RptParams buildSolution(Context ctx, RptParams params) throws Exception {
        RptParams result = new RptParams();
        String reportId = params.getString("asynrpt#key.report.id");
        String solutionId = params.getString("asynrpt#key.solution.id");
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (solutionId == null) {
            throw new BOSException("\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        AsynRptInfo report = this.getReport(ctx, reportId);
        BaseAsynRpt instance = this.createReport(ctx, report);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("report", (Object)reportId));
        filter.getFilterItems().add(new FilterItemInfo("solution", (Object)solutionId));
        filter.getFilterItems().add(new FilterItemInfo("queryType", (Object)2));
        AsynRptSchemeCollection coll = this.getSchemes(ctx, filter);
        AsynRptSchemeInfo scheme = null;
        if (coll.size() == 1) {
            scheme = coll.get(0);
        } else if (coll.size() > 1) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                AsynRptSchemeInfo error = (AsynRptSchemeInfo)it.next();
                instance.init(ctx, report, error, params);
                instance.deleteScheme();
            }
        }
        if (scheme != null) {
            if (AsynRptUtils.isTableRefresh(params)) {
                if (scheme.getStatus() == 0) {
                    result.setString("asynrpt#key.scheme.id", scheme.getId().toString());
                    result.setBoolean("isBack", Boolean.TRUE.booleanValue());
                    return result;
                }
                instance.init(ctx, report, scheme, params);
                instance.deleteScheme();
            } else {
                if (AsynRptUtils.isTableExists(ctx, scheme.getTmpTable()) && !AsynRptUtils.isTableEmpty(ctx, scheme.getTmpTable())) {
                    result.setString("asynrpt#key.scheme.id", scheme.getId().toString());
                    result.setBoolean("isBack", Boolean.TRUE.booleanValue());
                    return result;
                }
                instance.init(ctx, report, scheme, params);
                instance.deleteScheme();
            }
        }
        scheme = new AsynRptSchemeInfo();
        scheme.setReport(reportId);
        scheme.setSolution(solutionId);
        scheme.setContext(ctx.getContextID());
        scheme.setQueryType(2);
        scheme.setTableType(2);
        scheme.setInstance("server1");
        scheme.setThread("solutionId");
        scheme.setCreator(user);
        scheme.setCreateTime(new Timestamp(System.currentTimeMillis()));
        AsynRptSchemeFactory.getLocalInstance(ctx).addnew(scheme);
        params.setString("asynrpt#key.scheme.id", scheme.getId().toString());
        instance.init(ctx, report, scheme, params);
        this.build(instance, scheme.getThread());
        result.setString("asynrpt#key.scheme.id", scheme.getId().toString());
        return result;
    }

    private void build(final BaseAsynRpt instance, String threadName) {
        Thread builder = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    instance._build();
                }
                finally {
                    if (instance != null) {
                        try {
                            instance.clean();
                        }
                        catch (Exception e) {
                            logger.error((Object)"", (Throwable)e);
                        }
                    }
                }
            }
        }, threadName);
        builder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RptParams _querySummary(Context ctx, RptParams params) throws BOSException, EASBizException {
        String reportId = params.getString("asynrpt#key.report.id");
        BaseAsynRpt instance = null;
        try {
            AsynRptInfo report = this.getReport(ctx, reportId);
            instance = this.createReport(ctx, report);
            instance.init(ctx, report, params);
            RptParams rptParams = instance._querySummary();
            return rptParams;
        }
        finally {
            if (instance != null) {
                instance.clean();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RptParams _queryData(Context ctx, RptParams params) throws BOSException, EASBizException {
        String reportId = params.getString("asynrpt#key.report.id");
        BaseAsynRpt instance = null;
        try {
            AsynRptInfo report = this.getReport(ctx, reportId);
            instance = this.createReport(ctx, report);
            instance.init(ctx, report, params);
            RptParams rptParams = instance._queryData();
            return rptParams;
        }
        finally {
            if (instance != null) {
                instance.clean();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RptParams _release(Context ctx, RptParams params) throws BOSException, EASBizException {
        String reportId = params.getString("asynrpt#key.report.id");
        BaseAsynRpt instance = null;
        try {
            AsynRptInfo report = this.getReport(ctx, reportId);
            instance = this.createReport(ctx, report);
            instance.init(ctx, report, params);
            RptParams rptParams = instance.release();
            return rptParams;
        }
        finally {
            if (instance != null) {
                instance.clean();
            }
        }
    }

    private BaseAsynRpt createReport(Context ctx, AsynRptInfo report) throws BOSException {
        try {
            String className = report.getClassName();
            Class<?> clazz = Class.forName(className);
            return (BaseAsynRpt)clazz.newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private AsynRptInfo getReport(Context ctx, String reportId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)reportId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("className");
        view.setSelector(selector);
        AsynRptCollection coll = AsynRptFactory.getLocalInstance(ctx).getAsynRptCollection(view);
        AsynRptInfo report = null;
        if (coll.size() <= 0) {
            throw new BOSException("\u62a5\u8868\u4e0d\u5b58\u5728\u3002");
        }
        report = coll.get(0);
        return report;
    }

    private AsynRptSchemeInfo getScheme(Context ctx, String schemeId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)schemeId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("tableType");
        selector.add("tmpTable");
        selector.add("status");
        view.setSelector(selector);
        AsynRptSchemeCollection coll = this.getSchemes(ctx, filter);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private AsynRptSchemeCollection getSchemes(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("tableType");
        selector.add("tmpTable");
        selector.add("status");
        view.setSelector(selector);
        AsynRptSchemeCollection coll = AsynRptSchemeFactory.getLocalInstance(ctx).getAsynRptSchemeCollection(view);
        return coll;
    }
}

