/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.asynrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptInfo;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptSchemeFactory;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptSchemeInfo;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class BaseAsynRpt {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.common.rpt.app.BaseAsynRpt");
    protected Context ctx;
    protected AsynRptInfo report;
    protected AsynRptSchemeInfo scheme;
    protected String schemeId;
    private Connection con = null;
    protected RptParams params;
    protected RptTableHeader tblHeader = null;
    protected String tmpTable = null;

    public final void init(Context ctx, AsynRptInfo report, RptParams params) {
        this.init(ctx, report, null, params);
    }

    public final void init(Context ctx, AsynRptInfo report, AsynRptSchemeInfo scheme, RptParams params) {
        this.ctx = ctx;
        this.report = report;
        this.scheme = scheme;
        this.params = params;
        if (this.scheme != null) {
            this.schemeId = scheme.getId().toString();
        }
    }

    public void setParams(RptParams params) {
        this.params = params;
    }

    public RptParams getParams() {
        return this.params;
    }

    protected RptParams getFilteredParams() throws Exception {
        RptParams params = new RptParams();
        RptParams srcParams = this.getParams();
        if (srcParams != null) {
            params.putAll(srcParams.toMap());
            params.remove("asynrpt#key.report.id");
            params.remove("asynrpt#key.scheme.id");
            params.remove("asynrpt#key.solution.id");
            params.remove("asynrpt#key.tmp.table");
        }
        return params;
    }

    public void setTblHeader(RptTableHeader tblHeader) {
        this.tblHeader = tblHeader;
    }

    public RptTableHeader getTblHeader() {
        return this.tblHeader;
    }

    public void setTmpTable(String tmpTable) {
        this.tmpTable = tmpTable;
    }

    public String getTmpTable() {
        return this.tmpTable;
    }

    public void _build() {
        try {
            this.updateStart();
            this.build();
            this.updateSuccess();
        }
        catch (Throwable t) {
            try {
                this.updateFailure(t);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    protected abstract void build() throws Throwable;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RptParams _querySummary() throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        RptParams result;
        block8: {
            result = new RptParams();
            String schemeId = this.params.getString("asynrpt#key.scheme.id");
            if (schemeId == null) {
                return result;
            }
            StringBuffer ksql = new StringBuffer();
            ksql.append("select \n");
            ksql.append("    FID, FReportID, FSolutionID, FStatus, \n");
            ksql.append("    FParams, FTblHeader, FTmpTable, FException \n");
            ksql.append("from T_NCM_AsynRptScheme \n");
            ksql.append("where FID = '" + schemeId + "' \n");
            pstmt = null;
            rs = null;
            try {
                pstmt = this.getConnection().prepareStatement(ksql.toString());
                rs = pstmt.executeQuery();
                if (!rs.next()) break block8;
                AsynRptSchemeInfo scheme = new AsynRptSchemeInfo();
                scheme.setId(BOSUuid.read((String)rs.getString("FID")));
                scheme.setReport(rs.getString("FReportID"));
                scheme.setSolution(rs.getString("FSolutionID"));
                scheme.setStatus(rs.getInt("FStatus"));
                scheme.setParams(rs.getBytes("FParams"));
                scheme.setTblHeader(rs.getBytes("FTblHeader"));
                scheme.setTmpTable(rs.getString("FTmpTable"));
                scheme.setException(rs.getString("FException"));
                result = this.querySummary(scheme);
                if (AsynRptUtils.getQueryType(this.params) == 1) {
                    AsynRptSchemeFactory.getLocalInstance(this.ctx).delete((IObjectPK)new ObjectUuidPK(schemeId));
                }
            }
            catch (EASBizException e) {
                try {
                    throw e;
                    catch (BOSException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        throw new BOSException((Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        return result;
    }

    public RptParams querySummary(AsynRptSchemeInfo scheme) throws Exception {
        RptParams result = new RptParams();
        RptParams params = this.queryParams(scheme);
        result.setObject("params", (Object)params);
        this.params = params;
        RptTableHeader tblHeader = this.queryTblHeader(scheme);
        result.setObject("tblHeader", (Object)tblHeader);
        result.setString("asynrpt#key.tmp.table", scheme.getTmpTable());
        List ids = this.queryIds(scheme);
        if (ids != null) {
            result.setObject("asynrpt#key.data.ids", (Object)ids);
            result.setInt("rowCount", ids.size());
        } else {
            int rowCount = this.queryRowCount(scheme);
            result.setInt("rowCount", rowCount);
        }
        return result;
    }

    protected RptParams queryParams(AsynRptSchemeInfo scheme) throws Exception {
        byte[] params = scheme.getParams();
        if (params == null || params.length == 0) {
            return null;
        }
        RptParams rptParams = (RptParams)BaseAsynRpt.bytesToObject(params);
        rptParams.setString("asynrpt#key.report.id", scheme.getReport());
        rptParams.setString("asynrpt#key.scheme.id", scheme.getId().toString());
        rptParams.setString("asynrpt#key.solution.id", scheme.getSolution());
        return rptParams;
    }

    protected RptTableHeader queryTblHeader(AsynRptSchemeInfo scheme) throws Exception {
        byte[] tblHeader = scheme.getTblHeader();
        if (tblHeader == null || tblHeader.length == 0) {
            return null;
        }
        return (RptTableHeader)BaseAsynRpt.bytesToObject(tblHeader);
    }

    protected List queryIds(AsynRptSchemeInfo scheme) throws Exception {
        String sql = this.getQueryIdsSql(scheme.getTmpTable());
        if (sql != null) {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            ArrayList<String> ids = new ArrayList<String>(rs.size());
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
            return ids;
        }
        return null;
    }

    protected String getIdFieldName() throws BOSException, EASBizException {
        return "FID";
    }

    protected String getQueryIdsSql(String T_TMP_Table) throws Exception {
        return null;
    }

    protected int queryRowCount(AsynRptSchemeInfo scheme) throws Exception {
        String T_TMP_Table = scheme.getTmpTable();
        if (T_TMP_Table == null) {
            return 0;
        }
        String sql = this.getQueryRowCountSql(T_TMP_Table);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        int count = 0;
        if (rs.next()) {
            count = rs.getInt(1);
        }
        return count;
    }

    protected String getQueryRowCountSql(String T_TMP_Table) throws Exception {
        String sql = "select count(*) from " + T_TMP_Table + " ";
        return sql;
    }

    public RptParams _queryData() throws BOSException, EASBizException {
        RptParams result = null;
        String T_TMP_Table = this.params.getString("asynrpt#key.tmp.table");
        List ids = (List)this.params.getObject("asynrpt#key.data.ids");
        if (ids != null) {
            result = this.queryData(T_TMP_Table, ids);
        } else {
            int from = this.params.getInt("asynrpt#key.data.from");
            int len = this.params.getInt("asynrpt#key.data.len");
            result = this.queryData(T_TMP_Table, from, len);
        }
        return result;
    }

    protected RptParams queryData(String T_TMP_Table, List ids) throws BOSException, EASBizException {
        RptParams result = new RptParams();
        if (T_TMP_Table == null || ids.size() == 0) {
            return result;
        }
        String sql = this.getQueryDataSqlByIds(T_TMP_Table, ids);
        RptRowSet rs = this.executeQuery(sql);
        rs = this.sortData(rs, ids);
        result.setObject("rowset", (Object)rs);
        return result;
    }

    protected RptRowSet sortData(RptRowSet rs, List ids) throws BOSException, EASBizException {
        int i;
        String[] columns = rs.getColumnNames();
        String idFieldName = this.getIdFieldName();
        int index = -1;
        for (int i2 = 0; i2 < columns.length; ++i2) {
            if (!idFieldName.equals(columns[i2])) continue;
            index = i2;
            break;
        }
        if (index == -1) {
            return rs;
        }
        Object[][] data = rs.toArray();
        HashMap<Object, Object[]> map = new HashMap<Object, Object[]>();
        for (i = 0; i < data.length; ++i) {
            map.put(data[i][index], data[i]);
        }
        if (ids.size() > data.length) {
            return rs;
        }
        for (i = 0; i < ids.size(); ++i) {
            data[i] = (Object[])map.get(ids.get(index));
        }
        return new RptRowSet(columns, data);
    }

    protected String getQueryDataSqlByIds(String T_TMP_Table, List ids) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from " + T_TMP_Table + " \n");
        sql.append("where FID in (");
        sql.append("'" + ids.get(0).toString() + "'");
        for (int i = 1; i < ids.size(); ++i) {
            sql.append(", '" + ids.get(i).toString() + "'");
        }
        sql.append(") \n");
        return sql.toString();
    }

    protected RptParams queryData(String T_TMP_Table, int from, int len) throws BOSException, EASBizException {
        RptParams result = new RptParams();
        if (T_TMP_Table == null) {
            return result;
        }
        String sql = this.getQueryDataSqlByLimit(T_TMP_Table);
        RptRowSet rs = this.executeQuery(sql, from, len);
        result.setObject("rowset", (Object)rs);
        return result;
    }

    protected String getQueryDataSqlByLimit(String T_TMP_Table) throws BOSException, EASBizException {
        String sql = "select * from " + T_TMP_Table + " ";
        return sql;
    }

    public boolean execute(String sql) throws BOSException, EASBizException {
        return this.execute(sql, null);
    }

    public boolean execute(String sql, SqlParams pp) throws BOSException, EASBizException {
        try {
            return DBUtil.execute((String)sql, (Connection)this.getConnection());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public int executeUpdate(String sql) throws BOSException, EASBizException {
        return this.executeUpdate(sql, null);
    }

    public int executeUpdate(String sql, SqlParams pp) throws BOSException, EASBizException {
        try {
            return DBUtil.executeUpdate((String)sql, (SqlParams)pp, (Connection)this.getConnection());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public RptRowSet executeQuery(String sql) throws BOSException, EASBizException {
        return this.executeQuery(sql, null);
    }

    public RptRowSet executeQuery(String sql, SqlParams pp) throws BOSException, EASBizException {
        return this.executeQuery(sql, pp, 0, -1);
    }

    protected RptRowSet executeQuery(String sql, int from, int len) throws BOSException, EASBizException {
        return this.executeQuery(sql, null, from, len);
    }

    protected RptRowSet executeQuery(String sql, SqlParams params, int from, int len) throws BOSException, EASBizException {
        try {
            return DBUtil.executeQuery((String)sql, (SqlParams)params, (int)from, (int)len, (Connection)this.getConnection());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public RptParams release() throws BOSException, EASBizException {
        try {
            int queryType = AsynRptUtils.getQueryType(this.params);
            if (queryType == 1) {
                Object object = this.params.getObject("asynrpt#key.tmp.table");
                if (object instanceof String) {
                    TempTablePool.getInstance((Context)this.ctx).releaseTable((String)object);
                } else if (object instanceof Collection) {
                    Iterator it = ((Collection)object).iterator();
                    while (it.hasNext()) {
                        TempTablePool.getInstance((Context)this.ctx).releaseTable((String)it.next());
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
        return null;
    }

    public void deleteScheme() throws BOSException, EASBizException {
        if (this.scheme.getTmpTable() != null) {
            if (this.scheme.getTableType() == 1) {
                try {
                    TempTablePool.getInstance((Context)this.ctx).releaseTable(this.scheme.getTmpTable());
                }
                catch (Exception e) {
                    logger.warn((Object)"", (Throwable)e);
                }
            } else {
                StringBuffer ksql = new StringBuffer();
                ksql.append("SELECT 1 WHERE EXISTS ( \n");
                ksql.append("    SELECT 1 FROM KSQL_USERTABLES \n");
                ksql.append("    WHERE KSQL_TABNAME = '" + this.scheme.getTmpTable() + "' \n");
                ksql.append(") \n");
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)ksql.toString());
                try {
                    if (rs.next()) {
                        DbUtil.execute((Context)this.ctx, (String)("drop table " + this.scheme.getTmpTable()));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if (this.schemeId != null) {
            AsynRptSchemeFactory.getLocalInstance(this.ctx).delete((IObjectPK)new ObjectUuidPK(this.schemeId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStart() throws SQLException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("update T_NCM_AsynRptScheme \n");
        ksql.append("set FProgress = 0, FHint = ?, FStatus = 1, \n");
        ksql.append("    FBeginTime = ? \n");
        ksql.append("where FID = ? ");
        PreparedStatement pstmt = null;
        try {
            pstmt = this.getConnection().prepareStatement(ksql.toString());
            int index = 0;
            pstmt.setString(++index, "\u5f00\u59cb");
            pstmt.setTimestamp(++index, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(++index, this.schemeId);
            pstmt.executeUpdate();
        }
        finally {
            if (pstmt != null) {
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSuccess() throws Exception {
        StringBuffer ksql = new StringBuffer();
        ksql.append("update T_NCM_AsynRptScheme \n");
        ksql.append("set FProgress = 100, FHint = ?, FStatus = 2, ");
        ksql.append("    FTmpTable = ?, ");
        if (this.getTblHeader() != null) {
            ksql.append("    FTblHeader = ?, ");
        }
        if (this.getParams() != null) {
            ksql.append("    FParams = ?, ");
        }
        ksql.append("    FEndTime = ? \n");
        ksql.append("where FID = ? ");
        PreparedStatement pstmt = null;
        try {
            pstmt = this.getConnection().prepareStatement(ksql.toString());
            int index = 0;
            pstmt.setString(++index, "\u5b8c\u6210");
            pstmt.setString(++index, this.getTmpTable());
            if (this.getTblHeader() != null) {
                pstmt.setBytes(++index, BaseAsynRpt.objectToBytes(this.getTblHeader()));
            }
            if (this.getParams() != null) {
                pstmt.setBytes(++index, BaseAsynRpt.objectToBytes(this.getFilteredParams()));
            }
            pstmt.setTimestamp(++index, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(++index, this.schemeId);
            pstmt.executeUpdate();
        }
        finally {
            if (pstmt != null) {
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFailure(Throwable t) throws Exception {
        StringBuffer ksql = new StringBuffer();
        ksql.append("update T_NCM_AsynRptScheme \n");
        ksql.append("set FProgress = 100, FHint = ?, FStatus = 3, ");
        if (this.getParams() != null) {
            ksql.append("    FParams = ?, ");
        }
        ksql.append("    FEndTime = ? \n");
        ksql.append("where FID = ? ");
        PreparedStatement pstmt = null;
        try {
            pstmt = this.getConnection().prepareStatement(ksql.toString());
            int index = 0;
            pstmt.setString(++index, "\u5931\u8d25");
            if (this.getParams() != null) {
                pstmt.setBytes(++index, BaseAsynRpt.objectToBytes(this.getFilteredParams()));
            }
            pstmt.setTimestamp(++index, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(++index, this.schemeId);
            pstmt.executeUpdate();
        }
        finally {
            if (pstmt != null) {
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
    }

    public void progress(int progress) throws Exception {
        this.progress(progress, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progress(int progress, String hint) throws Exception {
        String sql = "update T_NCM_AsynRptScheme set FProgress = ?, FHint = ? where FID = ? ";
        if (progress >= 100) {
            progress = 99;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = this.getConnection().prepareStatement(sql.toString());
            int index = 0;
            pstmt.setInt(++index, progress);
            pstmt.setString(++index, hint);
            pstmt.setString(++index, this.schemeId);
            pstmt.executeUpdate();
        }
        finally {
            if (pstmt != null) {
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
    }

    protected Connection getConnection() throws SQLException {
        if (this.con != null) {
            return this.con;
        }
        this.con = EJBFactory.getConnection((Context)this.ctx);
        return this.con;
    }

    public void clean() throws BOSException, EASBizException {
        try {
            if (this.con != null) {
                SQLUtils.cleanup((Connection)this.con);
                this.con = null;
            }
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
    }

    protected String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToBytes(Object object) throws Exception {
        ByteArrayOutputStream byteOut = null;
        ObjectOutputStream objectOut = null;
        try {
            byte[] bytes;
            byteOut = new ByteArrayOutputStream();
            objectOut = new ObjectOutputStream(byteOut);
            objectOut.writeObject(object);
            objectOut.flush();
            byte[] byArray = bytes = byteOut.toByteArray();
            return byArray;
        }
        finally {
            if (objectOut != null) {
                objectOut.close();
            }
            if (byteOut != null) {
                byteOut.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object bytesToObject(byte[] bytes) throws Exception {
        ByteArrayInputStream byteIn = null;
        ObjectInputStream objectIn = null;
        try {
            Object object;
            byteIn = new ByteArrayInputStream(bytes);
            objectIn = new ObjectInputStream(byteIn);
            Object object2 = object = objectIn.readObject();
            return object2;
        }
        finally {
            if (objectIn != null) {
                objectIn.close();
            }
            if (byteIn != null) {
                byteIn.close();
            }
        }
    }
}

