/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.asynrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptSchemeInfo;
import com.kingdee.eas.ncm.common.asynrpt.app.BaseAsynRpt;
import com.kingdee.eas.util.app.DbUtil;

public class ExampleAsynRpt
extends BaseAsynRpt {
    @Override
    public void build() throws Throwable {
        String materialFrom = this.params.getString("materialFrom");
        String materialTo = this.params.getString("materialTo");
        int sleep = 50;
        if (materialFrom != null && materialFrom.equals(materialTo)) {
            sleep = 5;
        }
        for (int i = 1; i <= 99; ++i) {
            Thread.sleep(sleep);
            this.progress(i, "do something...");
        }
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("    FID varchar(44), \n");
        ksql.append("    FNumber nvarchar(80), \n");
        ksql.append("    FName nvarchar(80), \n");
        ksql.append("    FStatus int, \n");
        ksql.append("    FPricePrecision int, \n");
        ksql.append("    FVersion int \n");
        ksql.append(") \n");
        String T_TMP_Table = TempTablePool.getInstance((Context)this.ctx).createTempTable(ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into " + T_TMP_Table + " ( \n");
        ksql.append("    FID, \n");
        ksql.append("    FNumber, \n");
        ksql.append("    FName, \n");
        ksql.append("    FStatus, \n");
        ksql.append("    FPricePrecision, \n");
        ksql.append("    FVersion \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    FID, fnumber, fname_" + this.getLoc(this.ctx) + " fname, FStatus, FPricePrecision, FVersion \n");
        ksql.append("from t_bd_material \n");
        ksql.append("where 1=1 \n");
        if (materialFrom != null && materialFrom.length() > 0) {
            ksql.append("and fnumber >= '" + materialFrom + "' \n");
        }
        if (materialTo != null && materialTo.length() > 0) {
            ksql.append("and fnumber <= '" + materialTo + "' \n");
        }
        DbUtil.execute((Context)this.ctx, (String)ksql.toString());
        TempTablePool.getInstance((Context)this.ctx).createIndex(T_TMP_Table, "FID", true, false);
        this.setTmpTable(T_TMP_Table);
        this.setTblHeader(this.buildTblHeader());
    }

    protected RptTableHeader buildTblHeader() {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("fnumber");
        col.setWidth(200);
        header.addColumn(col);
        col = new RptTableColumn("fname");
        col.setWidth(200);
        header.addColumn(col);
        col = new RptTableColumn("FStatus");
        col.setWidth(80);
        header.addColumn(col);
        col = new RptTableColumn("FPricePrecision");
        col.setWidth(80);
        header.addColumn(col);
        col = new RptTableColumn("FVersion");
        col.setWidth(80);
        header.addColumn(col);
        header.setLabels((Object[][])new Object[][]{{"\u7269\u6599", "\u7269\u6599", "\u72b6\u6001", "\u7cbe\u5ea6", "\u7248\u672c"}, {"\u7f16\u7801", "\u540d\u79f0", "\u72b6\u6001", "\u7cbe\u5ea6", "\u7248\u672c"}}, true);
        return header;
    }

    @Override
    protected RptTableHeader queryTblHeader(AsynRptSchemeInfo scheme) throws Exception {
        return this.buildTblHeader();
    }

    @Override
    protected String getQueryIdsSql(String T_TMP_Table) throws Exception {
        return null;
    }

    @Override
    protected String getQueryDataSqlByLimit(String T_TMP_Table) throws BOSException, EASBizException {
        String sql = "select * from " + T_TMP_Table + " order by FNumber";
        return sql;
    }
}

