/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.dyntbl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.dyntbl.DynamicTableCollection;
import com.kingdee.eas.ncm.common.dyntbl.DynamicTableEntryInfo;
import com.kingdee.eas.ncm.common.dyntbl.DynamicTableFactory;
import com.kingdee.eas.ncm.common.dyntbl.DynamicTableInfo;
import com.kingdee.eas.ncm.common.dyntbl.app.IDynamicTableDDL;
import com.kingdee.eas.ncm.common.dyntbl.app.IDynamicTableDDLFactory;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DynamicTableManager {
    private static final char CLF = '\n';
    private static Logger logger = Logger.getLogger((String)DynamicTableManager.class.getName());
    private static final String CFG_FILE = "com/kingdee/eas/ncm/common/dyntbl/app/DynamicTable.properties";
    public static final String KEY_CATEGORY_EMPTY = "key.category.empty";
    private static final String TABLE_PREFIX = "T_DYN_";
    private static final String CONSTRAINT_PK_PREFIX = "PK_DYN_";
    private static final String CONSTRAINT_IX_PREFIX = "IX_DYN_";
    private static List ddlFactoryInfos = new ArrayList();

    public static String getPhysicalTblName(Context ctx, String busiTblName) throws BOSException, EASBizException, SQLException {
        return DynamicTableManager.getPhysicalTblName(ctx, (String)null, busiTblName);
    }

    public static String getPhysicalTblName(Context ctx, String categoryId, String busiTblName) throws BOSException, EASBizException, SQLException {
        return DynamicTableManager.getPhysicalTblName(ctx, categoryId, null, busiTblName);
    }

    public static String getPhysicalTblName(Context ctx, String categoryId, String categoryexId, String busiTblName) throws BOSException, EASBizException, SQLException {
        return DynamicTableManager.getPhysicalTblName(ctx, categoryId, categoryexId, busiTblName, null);
    }

    public static String getPhysicalTblName(Context ctx, String categoryId, String categoryexId, String busiTblName, String type) throws BOSException, EASBizException, SQLException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("businessTblName", (Object)busiTblName));
        if (StringUtils.isNotBlank((String)categoryId)) {
            filter.getFilterItems().add(new FilterItemInfo("category", (Object)categoryId));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("category", null, CompareType.EQUALS));
        }
        if (StringUtils.isNotBlank((String)categoryexId)) {
            filter.getFilterItems().add(new FilterItemInfo("categoryex", (Object)categoryexId));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("categoryex", null, CompareType.EQUALS));
        }
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("category");
        selector.add("categoryex");
        selector.add("businessTblName");
        selector.add("physicalTblName");
        selector.add("needUpdateIndex");
        selector.add("needUpdateColumn");
        selector.add("entries.*");
        view.setSelector(selector);
        DynamicTableCollection dynamicTableCollection = DynamicTableFactory.getLocalInstance(ctx).getDynamicTableCollection(view);
        if (dynamicTableCollection != null && dynamicTableCollection.size() > 0) {
            return DynamicTableManager.getPhysicalTblName(ctx, dynamicTableCollection.get(0), type);
        }
        return null;
    }

    private static String getPhysicalTblName(Context ctx, DynamicTableInfo dynamicTableInfo, String type) throws BOSException, EASBizException, SQLException {
        IDynamicTableDDL dynamicTableDDL = DynamicTableManager.getDynamicTableDDL(dynamicTableInfo.getBusinessTblName(), type);
        boolean isNeedUpdate = false;
        if (dynamicTableInfo.isNeedUpdateColumn()) {
            DynamicTableManager.updateColumn(ctx, dynamicTableInfo, dynamicTableDDL);
            dynamicTableInfo.setNeedUpdateColumn(false);
            isNeedUpdate = true;
        }
        if (dynamicTableInfo.isNeedUpdateIndex()) {
            DynamicTableManager.updateIndexs(ctx, dynamicTableInfo, dynamicTableDDL);
            dynamicTableInfo.setNeedUpdateIndex(false);
            isNeedUpdate = true;
        }
        if (isNeedUpdate) {
            ObjectUuidPK pk = new ObjectUuidPK(dynamicTableInfo.getId());
            DynamicTableFactory.getLocalInstance(ctx).update((IObjectPK)pk, dynamicTableInfo);
        }
        return dynamicTableInfo.getPhysicalTblName();
    }

    public static Map getPhysicalTblNames(Context ctx, String categoryId, Set categoryexIds, String busiTblName) throws BOSException, EASBizException, SQLException {
        return DynamicTableManager.getPhysicalTblNames(ctx, categoryId, categoryexIds, busiTblName, null);
    }

    public static Map getPhysicalTblNames(Context ctx, String categoryId, Set categoryexIds, String busiTblName, String type) throws BOSException, EASBizException, SQLException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("businessTblName", (Object)busiTblName));
        if (StringUtils.isNotBlank((String)categoryId)) {
            filter.getFilterItems().add(new FilterItemInfo("category", (Object)categoryId));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("category", null, CompareType.EQUALS));
        }
        if (categoryexIds != null && categoryexIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("categoryex", (Object)categoryexIds, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("categoryex", null, CompareType.EQUALS));
        }
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("category");
        selector.add("categoryex");
        selector.add("businessTblName");
        selector.add("physicalTblName");
        selector.add("needUpdateIndex");
        selector.add("needUpdateColumn");
        selector.add("entries.*");
        view.setSelector(selector);
        DynamicTableCollection dynamicTableCollection = DynamicTableFactory.getLocalInstance(ctx).getDynamicTableCollection(view);
        HashMap<String, String> result = new HashMap<String, String>();
        String key = null;
        DynamicTableInfo dynamicTableInfo = null;
        Iterator it = dynamicTableCollection.iterator();
        while (it.hasNext()) {
            dynamicTableInfo = (DynamicTableInfo)it.next();
            String physicalTblName = DynamicTableManager.getPhysicalTblName(ctx, dynamicTableInfo, type);
            key = dynamicTableInfo.getCategoryex();
            if (StringUtils.isBlank((String)key)) {
                key = dynamicTableInfo.getCategory();
            }
            if (StringUtils.isBlank((String)key)) {
                result.put(KEY_CATEGORY_EMPTY, physicalTblName);
                return result;
            }
            result.put(key, physicalTblName);
        }
        return result;
    }

    public static String unionPhysicalTblNames(Map map) {
        if (map != null && map.size() > 0) {
            StringBuffer ksql = new StringBuffer();
            Object[] tables = map.values().toArray();
            int size = tables.length;
            for (int i = 0; i < size; ++i) {
                ksql.append("select * from " + tables[i] + "\n");
                if (i >= size - 1) continue;
                ksql.append("union\n");
            }
            return ksql.toString();
        }
        return null;
    }

    public static String getPhysicalTblNameWithCreate(Context ctx, String busiTblName) throws BOSException, EASBizException, SQLException {
        return DynamicTableManager.getPhysicalTblNameWithCreate(ctx, null, busiTblName);
    }

    public static String getPhysicalTblNameWithCreate(Context ctx, String categoryId, String busiTblName) throws BOSException, EASBizException, SQLException {
        return DynamicTableManager.getPhysicalTblNameWithCreate(ctx, categoryId, null, busiTblName);
    }

    public static String getPhysicalTblNameWithCreate(Context ctx, String categoryId, String categoryexId, String busiTblName) throws BOSException, EASBizException, SQLException {
        return DynamicTableManager.getPhysicalTblNameWithCreate(ctx, categoryId, categoryexId, busiTblName, null);
    }

    public static String getPhysicalTblNameWithCreate(Context ctx, String categoryId, String categoryexId, String busiTblName, String type) throws BOSException, EASBizException, SQLException {
        String physTableName = null;
        physTableName = DynamicTableManager.getPhysicalTblName(ctx, categoryId, categoryexId, busiTblName, type);
        if (physTableName != null) {
            return physTableName;
        }
        if (StringUtils.isBlank((String)categoryId) && StringUtils.isNotBlank((String)categoryexId)) {
            return null;
        }
        physTableName = DynamicTableManager.createDynamicTable(ctx, categoryId, categoryexId, busiTblName, type);
        return physTableName;
    }

    private static synchronized IDynamicTableDDL getDynamicTableDDL(String busiTblName, String type) throws BOSException {
        IDynamicTableDDL dynamicTableDDL = null;
        for (DDLFactoryInfo ddlFactoryInfo : ddlFactoryInfos) {
            if (type != null && !type.equals(ddlFactoryInfo.type)) continue;
            if (ddlFactoryInfo.factory == null) {
                try {
                    Class<?> clazz = Class.forName(ddlFactoryInfo.className);
                    ddlFactoryInfo.factory = (IDynamicTableDDLFactory)clazz.newInstance();
                }
                catch (Exception e) {
                    logger.error((Object)"can not instance ddl factory.", (Throwable)e);
                }
            }
            if (ddlFactoryInfo.factory == null || (dynamicTableDDL = ddlFactoryInfo.factory.getDynamicTableDDL(busiTblName)) == null) continue;
            break;
        }
        if (dynamicTableDDL == null) {
            throw new BOSException("can not found DynamicTableDDL define for business table " + busiTblName + ".");
        }
        return dynamicTableDDL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createDynamicTable(Context ctx, String categoryId, String categoryexId, String busiTblName, String type) throws SQLException, EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = null;
        String tblName = null;
        String tblPkName = null;
        IDynamicTableDDL dynamicTableDDL = DynamicTableManager.getDynamicTableDDL(busiTblName, type);
        sql = dynamicTableDDL.getCreateTableDDL();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (sql != null) {
                tblName = DynamicTableManager.generateTableName(ctx);
                tblPkName = DynamicTableManager.generatePKName(ctx);
                Object[] param = new Object[]{tblName, tblPkName};
                sql = MessageFormat.format(sql, param);
                pstmt = conn.prepareStatement(sql);
                pstmt.execute();
            }
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
        DynamicTableInfo dynamicTableInfo = new DynamicTableInfo();
        dynamicTableInfo.setCategory(categoryId);
        dynamicTableInfo.setCategoryex(categoryexId);
        dynamicTableInfo.setBusinessTblName(busiTblName);
        dynamicTableInfo.setPhysicalTblName(tblName);
        dynamicTableInfo.setNeedUpdateColumn(false);
        dynamicTableInfo.setNeedUpdateIndex(true);
        DynamicTableEntryInfo dynamicTableEntryInfo = new DynamicTableEntryInfo();
        dynamicTableEntryInfo.setIndexName(tblPkName);
        dynamicTableEntryInfo.setIndexColumns("FID");
        dynamicTableEntryInfo.setParent(dynamicTableInfo);
        dynamicTableInfo.getEntries().add(dynamicTableEntryInfo);
        DynamicTableFactory.getLocalInstance(ctx).addnew(dynamicTableInfo);
        return tblName;
    }

    public static String generateTableName(Context ctx) throws SQLException, BOSException {
        String tableName;
        do {
            tableName = new UUTN(true).toString();
            if ((tableName = tableName.replaceFirst("VT", TABLE_PREFIX)).length() <= 28) continue;
            tableName = tableName.substring(0, 30);
        } while (DynamicTableManager.isTableExists(ctx, tableName));
        return tableName;
    }

    private static String generatePKName(Context ctx) throws SQLException, BOSException {
        String tablePkConstrait;
        do {
            tablePkConstrait = new UUTN("ZC").toString();
            if ((tablePkConstrait = tablePkConstrait.replaceFirst("ZC", CONSTRAINT_PK_PREFIX)).length() <= 18) continue;
            tablePkConstrait = tablePkConstrait.substring(0, 18);
        } while (DynamicTableManager.isConstrainsExists(ctx, tablePkConstrait));
        return tablePkConstrait;
    }

    private static boolean isTableExists(Context ctx, String tableName) throws SQLException, BOSException {
        Assert.that((tableName != null ? 1 : 0) != 0);
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = ?)";
        IRowSet rs = null;
        rs = NCMDbUtil.executeQuery(ctx, sql, new String[]{tableName});
        return rs.next();
    }

    private static boolean isConstrainsExists(Context ctx, String consName) throws SQLException, BOSException {
        Assert.that((consName != null ? 1 : 0) != 0);
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_CONSTRAINTS WHERE  KSQL_CONS_NAME = '" + consName + "')";
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql);
        return rs.next();
    }

    private static void updateColumn(Context ctx, DynamicTableInfo dynamicTableInfo, IDynamicTableDDL dynamicTableDDL) throws EASBizException, BOSException, SQLException {
        if (dynamicTableDDL == null) {
            logger.warn((Object)"updateColumn: can not found DynamicTableDDL.");
            return;
        }
        Map columnDDLs = dynamicTableDDL.getAddColumnDDLs();
        if (columnDDLs == null || columnDDLs.size() == 0) {
            return;
        }
        for (Map.Entry entry : columnDDLs.entrySet()) {
            String columnSQL = (String)entry.getValue();
            if (DynamicTableManager.isColumnExists(ctx, dynamicTableInfo.getPhysicalTblName(), entry.getKey().toString())) continue;
            String ksql = MessageFormat.format(columnSQL, dynamicTableInfo.getPhysicalTblName());
            NCMDbUtil.execute(ctx, ksql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isColumnExists(Context ctx, String tblName, String columnName) throws SQLException {
        String sql = "SELECT 1 FROM KSQL_USERCOLUMNS ";
        sql = sql + "WHERE KSQL_COL_TABNAME = '" + tblName + "' AND KSQL_COL_NAME = '" + columnName + "'";
        IRowSet rs = null;
        try {
            rs = NCMDbUtil.executeQuery(ctx, sql);
            boolean bl = rs.next();
            return bl;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return false;
    }

    private static void updateIndexs(Context ctx, DynamicTableInfo dynamicTableInfo, IDynamicTableDDL dynamicTableDDL) throws EASBizException, BOSException, SQLException {
        if (dynamicTableDDL == null) {
            logger.warn((Object)"updateIndexs: can not found DynamicTableDDL define.");
            return;
        }
        Map indexDDLs = dynamicTableDDL.getCreateIndexDDLs();
        if (indexDDLs == null || indexDDLs.size() == 0) {
            return;
        }
        StringBuffer ksql = new StringBuffer();
        HashSet<String> indexColumnss = new HashSet<String>();
        for (int i = 0; i < dynamicTableInfo.getEntries().size(); ++i) {
            indexColumnss.add(dynamicTableInfo.getEntries().get(i).getIndexColumns());
        }
        for (Map.Entry entry : indexDDLs.entrySet()) {
            String sql = (String)entry.getValue();
            if (indexColumnss.contains(entry.getKey())) continue;
            String indexName = DynamicTableManager.generateIndexName(ctx);
            ksql.append(MessageFormat.format(sql, indexName, dynamicTableInfo.getPhysicalTblName()));
            DynamicTableEntryInfo dynamicTableEntryInfo = new DynamicTableEntryInfo();
            dynamicTableEntryInfo.setIndexName(indexName);
            dynamicTableEntryInfo.setIndexColumns(entry.getKey().toString());
            dynamicTableEntryInfo.setParent(dynamicTableInfo);
            dynamicTableInfo.getEntries().add(dynamicTableEntryInfo);
            indexColumnss.add((String)entry.getKey());
        }
        if (ksql.length() > 0) {
            NCMDbUtil.BatchSqlExecute(ctx, ksql.toString(), ";");
        }
    }

    public static String generateIndexName(Context ctx) throws SQLException, BOSException {
        String indexName;
        do {
            indexName = new UUTN("ZC").toString();
            if ((indexName = indexName.replaceFirst("ZC", CONSTRAINT_IX_PREFIX)).length() <= 18) continue;
            indexName = indexName.substring(0, 18);
        } while (DynamicTableManager.isIndexExists(ctx, indexName));
        return indexName;
    }

    private static boolean isIndexExists(Context ctx, String indexName) throws SQLException, BOSException {
        Assert.that((indexName != null ? 1 : 0) != 0);
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = ?)";
        IRowSet rs = null;
        rs = NCMDbUtil.executeQuery(ctx, sql, new String[]{indexName});
        return rs.next();
    }

    public static boolean deleteTable(Context ctx, String categoryId, String busiTblName, String whereClause) throws SQLException, BOSException, EASBizException {
        String physTbl = DynamicTableManager.getPhysicalTblName(ctx, categoryId, busiTblName);
        String sqlTrunc = "truncate table " + physTbl;
        String sqlDelete = "delete from " + physTbl + " where " + whereClause;
        if (physTbl != null) {
            if (whereClause == null) {
                NCMDbUtil.execute(ctx, sqlTrunc);
            } else {
                NCMDbUtil.execute(ctx, sqlDelete);
            }
        }
        return false;
    }

    public static boolean deleteTable(Context ctx, String categoryId, String categoryexId, String busiTblName, String whereClause) throws SQLException, BOSException, EASBizException {
        String physTbl = DynamicTableManager.getPhysicalTblName(ctx, categoryId, categoryexId, busiTblName);
        String sqlTrunc = "truncate table " + physTbl;
        String sqlDelete = "delete from " + physTbl + " where " + whereClause;
        if (physTbl != null) {
            if (whereClause == null) {
                NCMDbUtil.execute(ctx, sqlTrunc);
            } else {
                NCMDbUtil.execute(ctx, sqlDelete);
            }
        }
        return false;
    }

    public static boolean deleteTable(Context ctx, String physicalTblName, String whereClause) throws SQLException {
        Assert.that((physicalTblName != null ? 1 : 0) != 0);
        String sqlTrunc = "truncate table " + physicalTblName;
        String sqlDelete = "delete from " + physicalTblName;
        if (whereClause != null) {
            sqlDelete = sqlDelete + " " + whereClause;
        }
        try {
            if (DynamicTableManager.isTableExists(ctx, physicalTblName)) {
                if (whereClause == null) {
                    NCMDbUtil.execute(ctx, sqlTrunc);
                } else {
                    NCMDbUtil.execute(ctx, sqlDelete);
                }
            }
        }
        catch (BOSException e) {
            throw new SQLException(e.getMessage());
        }
        return false;
    }

    public static void TruncateTables(Context ctx, String[] physicalTblName) throws BOSException {
        Assert.that((physicalTblName != null ? 1 : 0) != 0);
        Assert.that((physicalTblName.length > 0 ? 1 : 0) != 0);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < physicalTblName.length; ++i) {
            sb.append("truncate table ").append(physicalTblName[i]).append(";").append('\n');
        }
        if (sb.length() > 0) {
            NCMDbUtil.BatchSqlExecute(ctx, sb.toString(), ";");
        }
    }

    static {
        InputStream inputStream = DynamicTableManager.class.getClassLoader().getResourceAsStream(CFG_FILE);
        Properties props = new Properties();
        try {
            props.load(inputStream);
        }
        catch (IOException e) {
            logger.error((Object)"can not load config file: com/kingdee/eas/ncm/common/dyntbl/app/DynamicTable.properties", (Throwable)e);
            throw new RuntimeException("can not load config file: com/kingdee/eas/ncm/common/dyntbl/app/DynamicTable.properties", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = props.getProperty(key);
            if (!StringUtils.isNotBlank((String)key)) continue;
            DDLFactoryInfo ddlLFactoryInfo = new DDLFactoryInfo();
            ddlLFactoryInfo.className = key;
            ddlLFactoryInfo.type = value;
            ddlFactoryInfos.add(ddlLFactoryInfo);
        }
    }

    private static class DDLFactoryInfo {
        public String className;
        public IDynamicTableDDLFactory factory;
        public String type;

        private DDLFactoryInfo() {
        }
    }
}

