/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.log.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.ncm.common.log.app.NCMLogger;
import com.kingdee.eas.ncm.common.log.app.NCMSQLLogParamSet;
import com.kingdee.eas.ncm.common.log.app.SQLLogInfo;
import com.kingdee.eas.ncm.common.utils.app.NCMDbBatchUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NCMSQLLogUtils {
    private static final int MAX_SQL_LENGTH = 3000;

    private static boolean isLogOPen() {
        return NCMSQLLogParamSet.getInstance().isOpen();
    }

    private static String getParamsString(Object[] params) {
        String result = null;
        if (params != null && params.length != 0) {
            StringBuffer param = new StringBuffer();
            for (int i = 0; i < params.length; ++i) {
                if (params[i] instanceof Object[]) {
                    Object[] temp = (Object[])params[i];
                    for (int j = 0; j < temp.length; ++j) {
                        param.append(temp[j]);
                        param.append(",");
                    }
                    continue;
                }
                param.append(params[i]);
                param.append(",");
            }
            result = param.toString().length() > 3000 ? param.toString().substring(0, 3000) : param.toString();
        }
        return result;
    }

    private static String getParamsString2(List params) {
        String result = null;
        if (params != null && params.size() != 0) {
            StringBuffer sb = new StringBuffer();
            Object[] paramArray = null;
            for (int i = 0; i < params.size(); ++i) {
                paramArray = (Object[])params.get(i);
                StringBuffer tmp = new StringBuffer();
                for (int j = 0; j < paramArray.length; ++j) {
                    tmp.append(paramArray[j]).append(",");
                }
                sb.append(tmp.substring(0, tmp.length() - 1)).append(";\n");
            }
            result = sb.toString().length() > 3000 ? sb.toString().substring(0, 3000) : sb.toString();
        }
        return result;
    }

    private static String getParamsString3(Map[] params) {
        String result = null;
        if (params != null && params.length != 0) {
            StringBuffer sb = new StringBuffer();
            Map param = null;
            for (int i = 0; i < params.length; ++i) {
                param = params[i];
                StringBuffer tmp = new StringBuffer();
                for (Map.Entry entry : param.entrySet()) {
                    String val = null;
                    val = entry.getValue() == null ? null : entry.getValue().toString();
                    tmp.append(val).append(",");
                }
                sb.append(tmp.substring(0, tmp.length() - 1)).append(";\n");
            }
            result = sb.toString().length() > 3000 ? sb.toString().substring(0, 3000) : sb.toString();
        }
        return result;
    }

    private static String[] getClassMethod() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String url = null;
        String methodName = null;
        String className = null;
        for (int i = 0; i < stack.length; ++i) {
            if (stack[i].getClassName().equalsIgnoreCase(NCMDbUtil.class.getName()) || stack[i].getClassName().equalsIgnoreCase(NCMDbBatchUtil.class.getName()) || stack[i].getClassName().equalsIgnoreCase(NCMSQLLogUtils.class.getName()) || stack[i].getClassName().equalsIgnoreCase(NCMServerUtils.class.getName())) continue;
            url = stack[i].toString();
            methodName = stack[i].getMethodName();
            className = stack[i].getClassName();
            break;
        }
        String[] ret = new String[]{url, methodName, className};
        return ret;
    }

    private static void outputLog(SQLLogInfo logInfo, String paramStr) {
        Logger logger = NCMLogger.getLogger();
        logger.info((Object)"\n");
        logger.info((Object)("[thread]:" + Thread.currentThread().getName()));
        logger.info((Object)("[url]:" + logInfo.url));
        for (int i = 0; i < logInfo.ksql.length && i <= 20; ++i) {
            if (logInfo.ksql[i].trim().length() <= 0) continue;
            logger.info((Object)("[KSQL-" + i + "]: " + logInfo.ksql[i]));
        }
        if (logInfo.ksql.length > 20) {
            logger.info((Object)("\r\nSQL is too mutch. All sql qty: " + logInfo.ksql.length));
        }
        logger.info((Object)("[SQL Parameters]:" + paramStr));
        logger.info((Object)("[execute start time]:" + new Timestamp(logInfo.timeStart)));
        logger.info((Object)("[execute end time]:" + new Timestamp(logInfo.timeEnd)));
        logger.info((Object)("[execute time]:" + String.valueOf(logInfo.timeSpan) + "ms"));
        logger.info((Object)("[return record count]:" + String.valueOf(logInfo.rowSize)));
    }

    public static final void writeLog(Context ctx, Connection conn, long timeStart, long timeEnd, String sql, Object[] params, int number) {
        if (!NCMSQLLogUtils.isLogOPen()) {
            return;
        }
        if (sql == null || sql.length() <= 0) {
            return;
        }
        SQLLogInfo logInfo = new SQLLogInfo();
        logInfo.ksql = new String[]{sql};
        logInfo.timeStart = timeStart;
        logInfo.timeEnd = timeEnd;
        logInfo.timeSpan = timeEnd - timeStart;
        logInfo.rowSize = number;
        String[] classMethodArray = NCMSQLLogUtils.getClassMethod();
        logInfo.url = classMethodArray[0];
        logInfo.className = classMethodArray[1];
        logInfo.methodName = classMethodArray[2];
        NCMSQLLogUtils.outputLog(logInfo, NCMSQLLogUtils.getParamsString(params));
    }

    public static final void writeLog(Context ctx, Connection conn, long timeStart, long timeEnd, String[] sql, List params, int[] number) {
        if (!NCMSQLLogUtils.isLogOPen()) {
            return;
        }
        if (sql == null || sql.length <= 0) {
            return;
        }
        SQLLogInfo logInfo = new SQLLogInfo();
        logInfo.ksql = (String[])sql.clone();
        logInfo.timeStart = timeStart;
        logInfo.timeEnd = timeEnd;
        logInfo.timeSpan = timeEnd - timeStart;
        int rowSize = 0;
        if (number != null) {
            for (int i = 0; i < number.length; ++i) {
                rowSize += number[i];
            }
        }
        logInfo.rowSize = rowSize;
        String[] classMethodArray = NCMSQLLogUtils.getClassMethod();
        logInfo.url = classMethodArray[0];
        logInfo.className = classMethodArray[1];
        logInfo.methodName = classMethodArray[2];
        NCMSQLLogUtils.outputLog(logInfo, NCMSQLLogUtils.getParamsString2(params));
    }

    public static final void writeLog(Context ctx, Connection conn, long timeStart, long timeEnd, String sql, Map[] params, int[] number) {
        if (!NCMSQLLogUtils.isLogOPen()) {
            return;
        }
        if (sql == null || sql.length() <= 0) {
            return;
        }
        SQLLogInfo logInfo = new SQLLogInfo();
        logInfo.ksql = new String[]{sql};
        logInfo.timeStart = timeStart;
        logInfo.timeEnd = timeEnd;
        logInfo.timeSpan = timeEnd - timeStart;
        int rowSize = 0;
        if (number != null) {
            for (int i = 0; i < number.length; ++i) {
                rowSize += number[i];
            }
        }
        logInfo.rowSize = rowSize;
        String[] classMethodArray = NCMSQLLogUtils.getClassMethod();
        logInfo.url = classMethodArray[0];
        logInfo.className = classMethodArray[1];
        logInfo.methodName = classMethodArray[2];
        NCMSQLLogUtils.outputLog(logInfo, NCMSQLLogUtils.getParamsString3(params));
    }

    public static final void writeLog(Context ctx, Connection conn, long timeStart, long timeEnd, String[] sql, int[] number) {
        if (!NCMSQLLogUtils.isLogOPen()) {
            return;
        }
        if (sql == null || sql.length <= 0) {
            return;
        }
        SQLLogInfo logInfo = new SQLLogInfo();
        logInfo.ksql = (String[])sql.clone();
        logInfo.timeStart = timeStart;
        logInfo.timeEnd = timeEnd;
        logInfo.timeSpan = timeEnd - timeStart;
        int rowSize = 0;
        if (number != null) {
            for (int i = 0; i < number.length; ++i) {
                rowSize += number[i];
            }
        }
        logInfo.rowSize = rowSize;
        String[] classMethodArray = NCMSQLLogUtils.getClassMethod();
        logInfo.url = classMethodArray[0];
        logInfo.className = classMethodArray[1];
        logInfo.methodName = classMethodArray[2];
        NCMSQLLogUtils.outputLog(logInfo, null);
    }
}

