/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.progress;

import com.kingdee.bos.olap.util.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;

public class ProgressUtils {
    public static String calTime(long millis) {
        long h = millis / 3600000L;
        long m = millis / 60000L % 60L;
        long s = millis / 1000L % 3600L % 60L;
        String time = "";
        time = h < 10L ? time + "0" + h : time + h;
        time = time + ":";
        time = m < 10L ? time + "0" + m : time + m;
        time = time + ":";
        time = s < 10L ? time + "0" + s : time + s;
        return time;
    }

    public static void debug(Map item, Object msg) {
        ProgressUtils.debug(item, msg, null);
    }

    public static void debug(Map item, Object msg, Throwable t) {
        item.put("task.msg", msg);
        item.put("task.msg.level", 10);
    }

    public static void info(Map item, Object msg) {
        ProgressUtils.info(item, msg, null);
    }

    public static void info(Map item, Object msg, Throwable t) {
        item.put("task.msg", msg);
        item.put("task.msg.level", 20);
    }

    public static void warn(Map item, Object msg) {
        ProgressUtils.warn(item, msg, null);
    }

    public static void warn(Map item, Object msg, Throwable t) {
        item.put("task.msg", msg);
        item.put("task.msg.level", 30);
    }

    public static void error(Map item, Object msg) {
        ProgressUtils.error(item, msg, null);
    }

    public static void error(Map item, Object msg, Throwable t) {
        item.put("task.msg", msg);
        item.put("task.msg.level", 40);
        ProgressUtils.logex(item, t);
    }

    public static void logex(Map item, Throwable t) {
        if (t != null) {
            item.put("task.msg.exception", ProgressUtils.printStackTrace(t));
        }
    }

    public static String printStackTrace(Throwable t) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter((OutputStream)stream);
        t.printStackTrace(writer);
        writer.flush();
        String s = stream.toString();
        writer.close();
        return s;
    }
}

