/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.progress.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.concurrent.BlockingQueue;
import com.kingdee.bos.util.backport.concurrent.LinkedBlockingQueue;
import com.kingdee.bos.util.backport.concurrent.RejectedExecutionException;
import com.kingdee.bos.util.backport.concurrent.RejectedExecutionHandler;
import com.kingdee.bos.util.backport.concurrent.ThreadPoolExecutor;
import com.kingdee.bos.util.backport.concurrent.TimeUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.progress.IProgressTask;
import com.kingdee.eas.ncm.common.progress.ProgressException;
import com.kingdee.eas.ncm.common.progress.app.AbstractProgressServiceFacadeControllerBean;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ProgressServiceFacadeControllerBean
extends AbstractProgressServiceFacadeControllerBean {
    private static final long serialVersionUID = 6032628355887105244L;
    private static Logger logger;
    private static ThreadPoolExecutor executor;
    private static Hashtable taskClazzes;
    private static Hashtable tasksMap;
    private static Vector tasksList;
    private static Hashtable concurrentMap;
    private static Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _submit(Context ctx, Map param) throws BOSException, EASBizException {
        String taskClass = (String)param.get("task.class");
        if (StringUtils.isEmpty((String)taskClass)) {
            throw new BOSException("\u8bf7\u6307\u5b9a\u4efb\u52a1\u5904\u7406\u7c7b\u3002");
        }
        IProgressTask task = null;
        Class<?> taskClazz = (Class<?>)taskClazzes.get(taskClass);
        if (taskClazz == null) {
            try {
                taskClazz = Class.forName(taskClass);
                taskClazzes.put(taskClass, taskClazz);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException("\u4efb\u52a1\u5904\u7406\u7c7b\u4e0d\u5b58\u5728\u3002", (Throwable)e);
            }
        }
        try {
            task = (IProgressTask)taskClazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new BOSException("\u4efb\u52a1\u5904\u7406\u7c7b\u521d\u59cb\u5316\u5931\u8d25\u3002", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BOSException("\u4efb\u52a1\u5904\u7406\u7c7b\u521d\u59cb\u5316\u5931\u8d25\u3002", (Throwable)e);
        }
        param.put("task.context", ctx);
        task.init(param);
        try {
            task.check();
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
        boolean waitFinished = false;
        Object temp = param.get("task.wait.finished");
        if (temp != null) {
            if (temp instanceof Boolean) {
                waitFinished = (Boolean)temp;
            } else if (temp instanceof String) {
                waitFinished = "true".equalsIgnoreCase((String)temp);
            }
        }
        boolean startAtonce = false;
        temp = param.get("task.start.atonce");
        if (temp != null) {
            if (temp instanceof Boolean) {
                startAtonce = (Boolean)temp;
            } else if (temp instanceof String) {
                startAtonce = "true".equalsIgnoreCase((String)temp);
            }
        }
        boolean poolExecute = true;
        String concurrentID = task.getConcurrentID();
        if (concurrentID != null && concurrentID.length() > 0) {
            Object object = lock;
            synchronized (object) {
                LinkedList<IProgressTask> concurrents = (LinkedList<IProgressTask>)concurrentMap.get(concurrentID);
                if ((waitFinished || startAtonce) && concurrents != null && concurrents.size() > 0) {
                    throw new BOSException("\u5df2\u6709\u540c\u7c7b\u4efb\u52a1\u6b63\u5728\u5904\u7406\uff0c\u4e0d\u5141\u8bb8\u7acb\u5373\u6267\u884c\u3002");
                }
                if (concurrents == null) {
                    concurrents = new LinkedList<IProgressTask>();
                }
                if (concurrents.size() <= 0) {
                    try {
                        task.beforeConcurrent();
                    }
                    catch (EASBizException e) {
                        throw e;
                    }
                    catch (BOSException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new BOSException(e);
                    }
                    concurrents.add(task);
                } else {
                    IProgressTask aTask = null;
                    for (int i = 0; i < concurrents.size(); ++i) {
                        aTask = (IProgressTask)concurrents.get(i);
                        if (aTask.getConcurrentSeq() != task.getConcurrentSeq()) continue;
                        throw new BOSException("\u5df2\u6709\u540c\u6837\u7684\u4efb\u52a1\u6b63\u5728\u5904\u7406\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u3002");
                    }
                    aTask = (IProgressTask)concurrents.getLast();
                    if (task.getConcurrentSeq() < aTask.getConcurrentSeq()) {
                        throw new BOSException("\u5df2\u6709\u540e\u7f6e\u4efb\u52a1\u6b63\u5728\u5904\u7406\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u524d\u7f6e\u4efb\u52a1\u3002");
                    }
                    concurrents.add(task);
                    poolExecute = false;
                }
                concurrentMap.put(concurrentID, concurrents);
            }
        }
        String id = task.getTaskID();
        this.addTask(task);
        if (waitFinished) {
            try {
                ProgressServiceFacadeControllerBean.executorBeforeExecute(Thread.currentThread(), task);
                task.run();
            }
            finally {
                ProgressServiceFacadeControllerBean.executorAfterExecute(task, null);
            }
            this._query(ctx, id);
            this._query(ctx, id);
            return id;
        }
        if (startAtonce) {
            final IProgressTask task2 = task;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProgressServiceFacadeControllerBean.executorBeforeExecute(Thread.currentThread(), task2);
                        task2.run();
                    }
                    finally {
                        ProgressServiceFacadeControllerBean.executorAfterExecute(task2, null);
                    }
                }
            }).start();
            return id;
        }
        if (poolExecute) {
            try {
                executor.execute((Runnable)task);
            }
            catch (RejectedExecutionException e) {
                this.removeTask(id);
                throw new ProgressException(ProgressException.SERVER_BUSY);
            }
        }
        return id;
    }

    @Override
    protected List _query(Context ctx, String id) throws BOSException, EASBizException {
        List result = null;
        IProgressTask task = null;
        if (StringUtils.isEmpty((String)id)) {
            throw new BOSException("\u53c2\u6570\u9519\u8bef\uff0c\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        task = this.getTask(id);
        if (task == null) {
            throw new BOSException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u6e05\u9664\u3002");
        }
        try {
            result = task.query();
            if (task.isFinished()) {
                this.removeTask(id);
            }
        }
        catch (Throwable e) {
            this.removeTask(id);
            if (e instanceof EASBizException) {
                throw (EASBizException)e;
            }
            if (e instanceof BOSException) {
                throw (BOSException)e;
            }
            throw new BOSException(e);
        }
        return result;
    }

    @Override
    protected void _pause(Context ctx, String id, boolean pausing) throws BOSException, EASBizException {
        IProgressTask task = null;
        if (StringUtils.isEmpty((String)id)) {
            throw new BOSException("\u53c2\u6570\u9519\u8bef\uff0c\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        task = this.getTask(id);
        if (task == null) {
            throw new BOSException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u6e05\u9664\u3002");
        }
        try {
            task.pause();
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    @Override
    protected void _interrupt(Context ctx, String id) throws BOSException, EASBizException {
        IProgressTask task = null;
        if (StringUtils.isEmpty((String)id)) {
            throw new BOSException("\u53c2\u6570\u9519\u8bef\uff0c\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        task = this.getTask(id);
        if (task == null) {
            throw new BOSException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u6e05\u9664\u3002");
        }
        try {
            task.interrupt();
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getCollection(Context ctx, Map param) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        IProgressTask task2 = null;
        HashMap<String, Object> item = null;
        Object object = lock;
        synchronized (object) {
            for (IProgressTask task2 : tasksList) {
                item = new HashMap<String, Object>();
                item.put("ID", task2.getTaskID());
                item.put("name", task2.getTaskName());
                item.put("submitTime", task2.getSubmitTime());
                item.put("startTime", task2.getStartTime());
                item.put("usedTime", task2.getUsedTime());
                item.put("remainTime", task2.getRemainTime());
                item.put("progress", task2.getProgress());
                item.put("userId", task2.getUserID());
                item.put("userName", task2.getUserName());
                item.put("orgId", task2.getOrgID());
                item.put("orgName", task2.getOrgName());
                item.put("remark", task2.getRemark());
                list.add(item);
            }
        }
        return list;
    }

    private static void executorBeforeExecute(Thread t, Runnable r) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executorAfterExecute(Runnable r, Throwable t) {
        Object object = lock;
        synchronized (object) {
            IProgressTask task = (IProgressTask)r;
            String concurrentID = task.getConcurrentID();
            if (concurrentID != null && concurrentID.length() > 0) {
                LinkedList concurrents = (LinkedList)concurrentMap.get(concurrentID);
                Assert.that((concurrents != null && concurrents.size() > 0 ? 1 : 0) != 0, (String)"\u8fdb\u5ea6\u4efb\u52a1\u5e76\u53d1\u7ea6\u675f\u4e22\u5931\u3002");
                IProgressTask task2 = (IProgressTask)concurrents.removeFirst();
                Assert.that((task2 == task ? 1 : 0) != 0, (String)"\u8fdb\u5ea6\u4efb\u52a1\u5e76\u53d1\u7ea6\u675f\u9519\u8bef\u3002");
                if (concurrents.size() == 0) {
                    try {
                        task.afterConcurrent();
                    }
                    catch (Throwable e) {
                        logger.error((Object)"", e);
                    }
                    concurrentMap.remove(concurrentID);
                } else {
                    executor.execute((Runnable)((IProgressTask)concurrents.getFirst()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(IProgressTask task) {
        Object object = lock;
        synchronized (object) {
            if (task != null) {
                tasksMap.put(task.getTaskID(), task);
                tasksList.add(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProgressTask getTask(String taskId) {
        Object object = lock;
        synchronized (object) {
            if (taskId != null) {
                return (IProgressTask)tasksMap.get(taskId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProgressTask removeTask(String taskId) {
        Object object = lock;
        synchronized (object) {
            if (taskId != null) {
                IProgressTask task = (IProgressTask)tasksMap.remove(taskId);
                if (task != null) {
                    tasksList.remove(task);
                }
                return task;
            }
            return null;
        }
    }

    static {
        int corePoolSize;
        logger = Logger.getLogger((String)"com.kingdee.eas.ncm.common.progress.app.ProgressServiceFacadeControllerBean");
        lock = new Object();
        taskClazzes = new Hashtable();
        tasksMap = new Hashtable();
        tasksList = new Vector();
        concurrentMap = new Hashtable();
        int processors = Runtime.getRuntime().availableProcessors();
        if ((processors /= 2) < 2) {
            processors = 2;
        } else if (processors > 8) {
            processors = 8;
        }
        int maximumPoolSize = corePoolSize = processors;
        int keepAliveTime = 60;
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        ThreadPoolExecutor.AbortPolicy handler = new ThreadPoolExecutor.AbortPolicy();
        executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, (BlockingQueue)queue, (RejectedExecutionHandler)handler){

            public void beforeExecute(Thread t, Runnable r) {
                super.beforeExecute(t, r);
                ProgressServiceFacadeControllerBean.executorBeforeExecute(t, r);
            }

            public void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                ProgressServiceFacadeControllerBean.executorAfterExecute(r, t);
            }
        };
    }
}

