/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.task.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.progress.ProgressUtils;
import com.kingdee.eas.ncm.common.task.CostTaskEntryInfo;
import com.kingdee.eas.ncm.common.task.CostTaskFactory;
import com.kingdee.eas.ncm.common.task.CostTaskInfo;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.task.CostTaskStatusEnum;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.ICostTask;
import com.kingdee.eas.ncm.common.task.app.CostTaskExecutor;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BaseCostTaskExecutor
implements CostTaskExecutor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.app.BaseCostTaskExecutor");
    protected Context ctx;
    protected CostTaskInfo costTask;
    protected Map param;
    protected Context simpleCtx;

    @Override
    public void init(Context ctx, CostTaskInfo costTask, Map param) {
        this.ctx = ctx;
        this.costTask = costTask;
        this.param = param;
        this.param.put("ctx", ctx);
        this.simpleCtx = CostTaskUtils.cloneContext(ctx, null, true);
    }

    @Override
    public void initCostTaskEntries() {
        try {
            LinkedList entries = this.buildCostTaskEntries();
            this.addCostTaskEntries(entries);
        }
        catch (Throwable t) {
            this.costTask.setResult(CostTaskResultEnum.EXCEPTION);
            logger.error((Object)"", t);
        }
    }

    public void beforeExecute() throws Exception {
        if (!CostTaskUtils.isSubTask(this.param)) {
            this.costTask.setBeginTime(new Timestamp(CostTaskUtils.getCurrentTime(this.simpleCtx)));
            this.costTask.setStatus(CostTaskStatusEnum.RUNNING);
            this.updateCostTask();
        }
    }

    public abstract CostTaskResultEnum doExecute() throws Throwable;

    public void afterExecute() throws Exception {
        if (!CostTaskUtils.isSubTask(this.param)) {
            this.costTask.setStatus(CostTaskStatusEnum.FINISHED);
            this.costTask.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime(this.simpleCtx)));
            this.updateCostTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CostTaskResultEnum execute() {
        CostTaskResultEnum result = this.costTask.getResult();
        try {
            if (result.getValue() <= 3) {
                this.beforeExecute();
                CostTaskResultEnum newResult = this.doExecute();
                if (newResult.getValue() > result.getValue()) {
                    result = newResult;
                }
            }
            this.costTask.setResult(result);
        }
        catch (Throwable t) {
            this.costTask.setResult(CostTaskResultEnum.EXCEPTION);
            String str = ProgressUtils.printStackTrace(t);
            if (str.length() > 10240) {
                str.substring(0, 10240);
            }
            this.costTask.setException(str);
            logger.error((Object)"", t);
        }
        finally {
            try {
                this.afterExecute();
            }
            catch (Throwable t) {
                logger.error((Object)"", t);
            }
        }
        return this.costTask.getResult();
    }

    @Override
    public CostTaskEntryInfo getCostTaskEntry(String number) {
        return null;
    }

    @Override
    public CostTaskEntryInfo newCostTaskEntry(int typeSeq, int seq) {
        CostTaskEntryInfo costTaskEntry = new CostTaskEntryInfo();
        costTaskEntry.setTypeSeq(typeSeq);
        costTaskEntry.setSeq(seq);
        costTaskEntry.setProgress(1);
        costTaskEntry.setStatus(CostTaskStatusEnum.NULL);
        costTaskEntry.setResult(CostTaskResultEnum.NULL);
        costTaskEntry.setLevel(1);
        costTaskEntry.setLeaf(true);
        return costTaskEntry;
    }

    @Override
    public void addCostTaskEntries(LinkedList entries) throws BOSException, EASBizException {
        for (int i = 0; i < entries.size(); ++i) {
            CostTaskEntryInfo costTaskEntry = (CostTaskEntryInfo)entries.get(i);
            if (costTaskEntry.getStatus() == null) {
                costTaskEntry.setStatus(CostTaskStatusEnum.NULL);
            }
            if (costTaskEntry.getResult() == null) {
                costTaskEntry.setResult(CostTaskResultEnum.NULL);
            }
            costTaskEntry.setTask(this.costTask);
            this.costTask.getEntries().add(costTaskEntry);
        }
        ICostTask icostTask = CostTaskFactory.getLocalInstance(this.ctx);
        icostTask.saveOrUpdate(this.costTask);
    }

    @Override
    public void updateCostTaskEntryRunning(String number) throws BOSException, EASBizException {
        CostTaskEntryInfo entry = this.getCostTaskEntry(number);
        if (entry == null) {
            return;
        }
        entry.setStatus(CostTaskStatusEnum.RUNNING);
        entry.setBeginTime(new Timestamp(CostTaskUtils.getCurrentTime(this.simpleCtx)));
        this.updateCostTaskEntry(entry);
    }

    @Override
    public void updateCostTaskEntryFinished(String number) throws BOSException, EASBizException {
        this.updateCostTaskEntryFinished(number, CostTaskResultEnum.SUCCESS);
    }

    @Override
    public void updateCostTaskEntryFinished(String number, CostTaskResultEnum result) throws BOSException, EASBizException {
        CostTaskEntryInfo entry = this.getCostTaskEntry(number);
        if (entry == null) {
            return;
        }
        entry.setStatus(CostTaskStatusEnum.FINISHED);
        entry.setResult(result);
        entry.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime(this.simpleCtx)));
        this.updateCostTaskEntry(entry);
    }

    @Override
    public void updateCostTaskEntry(CostTaskEntryInfo costTaskEntry) throws BOSException, EASBizException {
        LinkedList<CostTaskEntryInfo> entries = new LinkedList<CostTaskEntryInfo>();
        if (costTaskEntry != null) {
            entries.add(costTaskEntry);
        }
        this.updateCostTaskEntries(entries);
    }

    @Override
    public void updateCostTaskEntries(LinkedList entries) throws BOSException, EASBizException {
        HashSet<String> entryIds = new HashSet<String>();
        if (entries != null) {
            for (int i = 0; i < entries.size(); ++i) {
                CostTaskEntryInfo entry = (CostTaskEntryInfo)entries.get(i);
                if (entry.getId() == null) continue;
                entryIds.add(entry.getId().toString());
            }
        }
        ICostTask icostTask = CostTaskFactory.getLocalInstance(this.ctx);
        icostTask.saveOrUpdate(this.costTask, entryIds);
    }

    @Override
    public void updateCostTask() throws BOSException, EASBizException {
        ICostTask icostTask = CostTaskFactory.getLocalInstance(this.ctx);
        icostTask.saveOrUpdate(this.costTask);
    }
}

