/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.task.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.task.CostTaskCollection;
import com.kingdee.eas.ncm.common.task.CostTaskEntryCollection;
import com.kingdee.eas.ncm.common.task.CostTaskEntryInfo;
import com.kingdee.eas.ncm.common.task.CostTaskInfo;
import com.kingdee.eas.ncm.common.task.CostTaskStatusEnum;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.app.AbstractCostTaskControllerBean;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class CostTaskControllerBean
extends AbstractCostTaskControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.common.task.app.CostTaskControllerBean");

    @Override
    public CostTaskCollection getCostTaskCollection(Context ctx, EntityViewInfo view) throws BOSException {
        CostTaskCollection coll = super.getCostTaskCollection(ctx, view);
        Timestamp current = new Timestamp(CostTaskUtils.getCurrentTime(ctx));
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                CostTaskInfo costTask = coll.get(i);
                if (costTask.getBeginTime() != null && costTask.getEndTime() == null) {
                    costTask.setEndTime(current);
                }
                for (int j = 0; j < costTask.getEntries().size(); ++j) {
                    CostTaskEntryInfo costTaskEntry = costTask.getEntries().get(j);
                    if (costTaskEntry.getBeginTime() == null || costTaskEntry.getEndTime() != null) continue;
                    if (costTask.getStatus() != null && CostTaskStatusEnum.FINISHED.equals((Object)costTask.getStatus())) {
                        costTaskEntry.setEndTime(costTask.getEndTime());
                        continue;
                    }
                    costTaskEntry.setEndTime(current);
                }
            }
        }
        return coll;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CostTaskInfo newCostTask = (CostTaskInfo)model;
        CostTaskInfo oldCostTask = this.getCostTaskInfo(ctx, pk);
        oldCostTask.setStatus(newCostTask.getStatus());
        if (newCostTask.getStatus().getValue() == 9) {
            oldCostTask.setResult(newCostTask.getResult());
        }
        oldCostTask.setBeginTime(newCostTask.getBeginTime());
        oldCostTask.setEndTime(newCostTask.getEndTime());
        HashMap<String, CostTaskEntryInfo> map = new HashMap<String, CostTaskEntryInfo>();
        CostTaskEntryInfo newCostTaskEntry = null;
        for (int i = 0; i < newCostTask.getEntries().size(); ++i) {
            newCostTaskEntry = newCostTask.getEntries().get(i);
            map.put(newCostTaskEntry.getId().toString(), newCostTaskEntry);
        }
        int totalProgress = 0;
        int finishedProgress = 0;
        CostTaskEntryInfo oldCostTaskEntry = null;
        for (int i = 0; i < oldCostTask.getEntries().size(); ++i) {
            oldCostTaskEntry = oldCostTask.getEntries().get(i);
            newCostTaskEntry = (CostTaskEntryInfo)map.get(oldCostTaskEntry.getId().toString());
            if (newCostTaskEntry != null) {
                oldCostTaskEntry.setProgressInfo(newCostTaskEntry.getProgressInfo());
                oldCostTaskEntry.setStatus(newCostTaskEntry.getStatus());
                oldCostTaskEntry.setResult(newCostTaskEntry.getResult());
                oldCostTaskEntry.setReport(newCostTaskEntry.getReport(NCMConst.l1), NCMConst.l1);
                oldCostTaskEntry.setReport(newCostTaskEntry.getReport(NCMConst.l2), NCMConst.l2);
                oldCostTaskEntry.setReport(newCostTaskEntry.getReport(NCMConst.l3), NCMConst.l3);
                oldCostTaskEntry.setFunction(newCostTaskEntry.getFunction());
                oldCostTaskEntry.setParam(newCostTaskEntry.getParam());
                oldCostTaskEntry.setBeginTime(newCostTaskEntry.getBeginTime());
                oldCostTaskEntry.setEndTime(newCostTaskEntry.getEndTime());
            }
            if (!oldCostTaskEntry.isLeaf()) continue;
            int progress = 1;
            if (oldCostTaskEntry.getProgress() != 0) {
                progress = oldCostTaskEntry.getProgress();
            }
            totalProgress += progress;
            if (oldCostTaskEntry.getStatus().getValue() != 9) continue;
            finishedProgress += progress;
        }
        if (oldCostTask.getStatus() != null && oldCostTask.getStatus().getValue() == 9 && oldCostTask.getResult() != null && (oldCostTask.getResult().getValue() == 1 || oldCostTask.getResult().getValue() == 3)) {
            oldCostTask.setProgress(100);
        } else if (totalProgress == 0) {
            oldCostTask.setProgress(0);
        } else {
            int progress = finishedProgress * 100 / totalProgress;
            if (progress > oldCostTask.getProgress()) {
                oldCostTask.setProgress(progress);
            }
        }
        super._update(ctx, pk, (IObjectValue)oldCostTask);
    }

    @Override
    protected IObjectPK _saveOrUpdate(Context ctx, CostTaskInfo costTask) throws BOSException, EASBizException {
        return this._saveOrUpdate(ctx, costTask, null);
    }

    @Override
    protected IObjectPK _saveOrUpdate(Context ctx, CostTaskInfo costTask, Set entryIds) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            boolean isNewCostTask;
            conn = EJBFactory.getConnection((Context)ctx);
            boolean bl = isNewCostTask = costTask.getId() == null;
            if (isNewCostTask) {
                costTask.setId(BOSUuid.create((BOSObjectType)costTask.getBOSType()));
            }
            CostTaskEntryCollection entries = costTask.getEntries();
            CostTaskEntryCollection newEntries = new CostTaskEntryCollection();
            CostTaskEntryCollection oldEntries = new CostTaskEntryCollection();
            CostTaskEntryInfo costTaskEntry = null;
            int totalProgress = 0;
            int finishedProgress = 0;
            for (int i = 0; i < entries.size(); ++i) {
                costTaskEntry = entries.get(i);
                if (costTaskEntry.getId() == null) {
                    costTaskEntry.setId(BOSUuid.create((BOSObjectType)costTaskEntry.getBOSType()));
                    newEntries.add(costTaskEntry);
                } else if (entryIds != null && entryIds.contains(costTaskEntry.getId().toString())) {
                    oldEntries.add(costTaskEntry);
                }
                if (!costTaskEntry.isLeaf()) continue;
                int progress = 1;
                if (costTaskEntry.getProgress() != 0) {
                    progress = costTaskEntry.getProgress();
                }
                totalProgress += progress;
                if (costTaskEntry.getStatus().getValue() != 9) continue;
                finishedProgress += progress;
            }
            if (costTask.getStatus() != null && costTask.getStatus().getValue() == 9) {
                costTask.setProgress(100);
            } else if (totalProgress == 0) {
                costTask.setProgress(0);
            } else {
                int progress = finishedProgress * 100 / totalProgress;
                if (progress > costTask.getProgress()) {
                    costTask.setProgress(progress);
                }
            }
            if (isNewCostTask) {
                this.saveOrUpdateAddCostTask(conn, costTask);
            } else {
                this.saveOrUpdateUpdateCostTask(conn, costTask);
            }
            if (newEntries.size() > 0) {
                this.saveOrUpdateAddCostTaskEntries(conn, newEntries);
            }
            if (oldEntries.size() > 0) {
                this.saveOrUpdateUpdateCostTaskEntries(conn, oldEntries);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return new ObjectUuidPK(costTask.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOrUpdateAddCostTask(Connection conn, CostTaskInfo costTask) throws SQLException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("insert into T_NCM_CostTask (                     \n");
        ksql.append("    FID, FNumber, FName_l1, FName_l2, FName_l3,  \n");
        ksql.append("    FCompanyID, FPeriodID,                       \n");
        ksql.append("    FSubSys, FCatagory, FFunction, FProgress,    \n");
        ksql.append("    FStatus, FResult, FBeginTime, FEndTime,      \n");
        ksql.append("    FCreatorID, FCreateTime                      \n");
        ksql.append(")                                                \n");
        ksql.append("values (                                         \n");
        ksql.append("    ?, ?, ?, ?, ?,                               \n");
        ksql.append("    ?, ?,                                        \n");
        ksql.append("    ?, ?, ?, ?,                                  \n");
        ksql.append("    ?, ?, ?, ?,                                  \n");
        ksql.append("    ?, ?                                         \n");
        ksql.append(")                                                \n");
        PreparedStatement pstmt = null;
        int index = 0;
        try {
            pstmt = conn.prepareStatement(ksql.toString());
            pstmt.setString(++index, costTask.getId().toString());
            pstmt.setString(++index, costTask.getNumber());
            pstmt.setString(++index, costTask.getName(NCMConst.l1));
            pstmt.setString(++index, costTask.getName(NCMConst.l2));
            pstmt.setString(++index, costTask.getName(NCMConst.l3));
            pstmt.setString(++index, costTask.getCompany().getId().toString());
            pstmt.setString(++index, costTask.getPeriod().getId().toString());
            pstmt.setString(++index, costTask.getSubSys());
            pstmt.setString(++index, costTask.getCatagory());
            pstmt.setString(++index, costTask.getFunction());
            pstmt.setInt(++index, costTask.getProgress());
            pstmt.setInt(++index, costTask.getStatus().getValue());
            pstmt.setInt(++index, costTask.getResult().getValue());
            pstmt.setTimestamp(++index, costTask.getBeginTime());
            pstmt.setTimestamp(++index, costTask.getEndTime());
            pstmt.setString(++index, costTask.getCreator().getId().toString());
            pstmt.setTimestamp(++index, costTask.getCreateTime());
            pstmt.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOrUpdateUpdateCostTask(Connection conn, CostTaskInfo costTask) throws SQLException {
        StringBuffer ksql = new StringBuffer();
        boolean finished = costTask.getStatus().getValue() == 9;
        boolean exception = costTask.getException() != null && costTask.getException().length() > 0;
        ksql.append("update T_NCM_CostTask set                    \n");
        ksql.append("    FProgress = ?, FStatus = ?, \n");
        if (finished) {
            ksql.append("    FResult = ?, \n");
        }
        if (exception) {
            ksql.append("    FException = ?, \n");
        }
        ksql.append("    FBeginTime = ?, FEndTime = ?             \n");
        ksql.append("where FID = ?                                \n");
        PreparedStatement pstmt = null;
        int index = 0;
        try {
            pstmt = conn.prepareStatement(ksql.toString());
            pstmt.setInt(++index, costTask.getProgress());
            pstmt.setInt(++index, costTask.getStatus().getValue());
            if (finished) {
                pstmt.setInt(++index, costTask.getResult().getValue());
            }
            if (exception) {
                pstmt.setString(++index, costTask.getException());
            }
            pstmt.setTimestamp(++index, costTask.getBeginTime());
            pstmt.setTimestamp(++index, costTask.getEndTime());
            pstmt.setString(++index, costTask.getId().toString());
            pstmt.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOrUpdateAddCostTaskEntries(Connection conn, CostTaskEntryCollection entries) throws SQLException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("insert into T_NCM_CostTaskEntry ( \n");
        ksql.append("    FID, FNumber, FName_l1, FName_l2, FName_l3,            \n");
        ksql.append("    FTaskID, FParentID,                                    \n");
        ksql.append("    FProgress, FProgressInfo, FStatus, FResult,            \n");
        ksql.append("    FReport_l1, FReport_l2, FReport_l3, FFunction, FParam, \n");
        ksql.append("    FLevel, FIsLeaf, FTypeSeq, FSeq,                       \n");
        ksql.append("    FIsHide, FBackground,                                  \n");
        ksql.append("    FBeginTime, FEndTime                                   \n");
        ksql.append(")                                                          \n");
        ksql.append("values (                                                   \n");
        ksql.append("    ?, ?, ?, ?, ?,                                         \n");
        ksql.append("    ?, ?,                                                  \n");
        ksql.append("    ?, ?, ?, ?,                                            \n");
        ksql.append("    ?, ?, ?, ?, ?,                                         \n");
        ksql.append("    ?, ?, ?, ?,                                            \n");
        ksql.append("    ?, ?,                                                  \n");
        ksql.append("    ?, ?                                                   \n");
        ksql.append(") \n");
        PreparedStatement pstmt = null;
        int index = 0;
        try {
            pstmt = conn.prepareStatement(ksql.toString());
            CostTaskEntryInfo costTaskEntry = null;
            for (int i = 0; i < entries.size(); ++i) {
                costTaskEntry = entries.get(i);
                index = 0;
                pstmt.setString(++index, costTaskEntry.getId().toString());
                pstmt.setString(++index, costTaskEntry.getNumber());
                pstmt.setString(++index, costTaskEntry.getName(NCMConst.l1));
                pstmt.setString(++index, costTaskEntry.getName(NCMConst.l2));
                pstmt.setString(++index, costTaskEntry.getName(NCMConst.l3));
                pstmt.setString(++index, costTaskEntry.getTask().getId().toString());
                if (costTaskEntry.getParent() != null) {
                    pstmt.setString(++index, costTaskEntry.getParent().getId().toString());
                } else {
                    pstmt.setString(++index, null);
                }
                pstmt.setInt(++index, costTaskEntry.getProgress());
                pstmt.setString(++index, costTaskEntry.getProgressInfo());
                pstmt.setInt(++index, costTaskEntry.getStatus().getValue());
                pstmt.setInt(++index, costTaskEntry.getResult().getValue());
                pstmt.setString(++index, costTaskEntry.getReport(NCMConst.l1));
                pstmt.setString(++index, costTaskEntry.getReport(NCMConst.l2));
                pstmt.setString(++index, costTaskEntry.getReport(NCMConst.l3));
                pstmt.setString(++index, costTaskEntry.getFunction());
                pstmt.setString(++index, costTaskEntry.getParam());
                pstmt.setInt(++index, costTaskEntry.getLevel());
                pstmt.setBoolean(++index, costTaskEntry.isLeaf());
                pstmt.setInt(++index, costTaskEntry.getTypeSeq());
                pstmt.setInt(++index, costTaskEntry.getSeq());
                pstmt.setBoolean(++index, costTaskEntry.isHide());
                pstmt.setInt(++index, costTaskEntry.getBackground());
                pstmt.setTimestamp(++index, costTaskEntry.getBeginTime());
                pstmt.setTimestamp(++index, costTaskEntry.getEndTime());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOrUpdateUpdateCostTaskEntries(Connection conn, CostTaskEntryCollection entries) throws SQLException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("update T_NCM_CostTaskEntry set  \n");
        ksql.append("    FProgress = ?, FProgressInfo = ?, \n");
        ksql.append("    FStatus = ?, FResult = ?, \n");
        ksql.append("    FReport_l1 = ?, FReport_l2 = ?, FReport_l3 = ?, \n");
        ksql.append("    FFunction = ?, FParam = ?, \n");
        ksql.append("    FLevel = ?, FIsLeaf = ?, FTypeSeq = ?, FSeq = ?, \n");
        ksql.append("    FIsHide = ?, FBackground = ?, \n");
        ksql.append("    FBeginTime = ?, FEndTime = ? \n");
        ksql.append("where FID = ? \n");
        PreparedStatement pstmt = null;
        int index = 0;
        try {
            pstmt = conn.prepareStatement(ksql.toString());
            CostTaskEntryInfo costTaskEntry = null;
            for (int i = 0; i < entries.size(); ++i) {
                costTaskEntry = entries.get(i);
                index = 0;
                pstmt.setInt(++index, costTaskEntry.getProgress());
                pstmt.setString(++index, costTaskEntry.getProgressInfo());
                pstmt.setInt(++index, costTaskEntry.getStatus().getValue());
                pstmt.setInt(++index, costTaskEntry.getResult().getValue());
                pstmt.setString(++index, costTaskEntry.getReport(NCMConst.l1));
                pstmt.setString(++index, costTaskEntry.getReport(NCMConst.l2));
                pstmt.setString(++index, costTaskEntry.getReport(NCMConst.l3));
                pstmt.setString(++index, costTaskEntry.getFunction());
                pstmt.setString(++index, costTaskEntry.getParam());
                pstmt.setInt(++index, costTaskEntry.getLevel());
                pstmt.setBoolean(++index, costTaskEntry.isLeaf());
                pstmt.setInt(++index, costTaskEntry.getTypeSeq());
                pstmt.setInt(++index, costTaskEntry.getSeq());
                pstmt.setBoolean(++index, costTaskEntry.isHide());
                pstmt.setInt(++index, costTaskEntry.getBackground());
                pstmt.setTimestamp(++index, costTaskEntry.getBeginTime());
                pstmt.setTimestamp(++index, costTaskEntry.getEndTime());
                pstmt.setString(++index, costTaskEntry.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)pstmt);
    }
}

