/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.task.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.task.CostTaskCollection;
import com.kingdee.eas.ncm.common.task.CostTaskException;
import com.kingdee.eas.ncm.common.task.CostTaskFactory;
import com.kingdee.eas.ncm.common.task.CostTaskInfo;
import com.kingdee.eas.ncm.common.task.CostTaskStatusEnum;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.app.AbstractCostTaskFacadeControllerBean;
import com.kingdee.eas.ncm.common.task.app.CostTaskExecutor;
import com.kingdee.eas.util.ResourceBase;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CostTaskFacadeControllerBean
extends AbstractCostTaskFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.common.task.app.CostTaskFacadeControllerBean");
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.common.task.CostTaskResource";

    protected void check(Context ctx, CostTaskInfo costTask) throws BOSException, EASBizException {
        ArrayList<CostTaskInfo> costTasks = new ArrayList<CostTaskInfo>(1);
        costTasks.add(costTask);
        this.check(ctx, costTasks);
    }

    protected void check(Context ctx, List costTasks) throws BOSException, EASBizException {
        int i;
        StringBuffer oql = new StringBuffer();
        oql.append("select \n");
        oql.append("    number, \n");
        oql.append("    name, \n");
        oql.append("    function, \n");
        oql.append("    company.name, \n");
        oql.append("    period.number \n");
        oql.append("where \n");
        for (int i2 = 0; i2 < costTasks.size(); ++i2) {
            CostTaskInfo costTask = (CostTaskInfo)costTasks.get(i2);
            oql.append("    function = '" + costTask.getFunction() + "' \n");
            oql.append("    and status <> 9 \n");
            if (i2 >= costTasks.size() - 1) continue;
            oql.append("    or \n");
        }
        HashMap<String, CostTaskInfo> existCostTasks = new HashMap<String, CostTaskInfo>();
        CostTaskCollection coll = CostTaskFactory.getLocalInstance(ctx).getCostTaskCollection(oql.toString());
        for (i = 0; i < coll.size(); ++i) {
            CostTaskInfo existCostTask = coll.get(i);
            if (existCostTasks.containsKey(existCostTask.getFunction())) continue;
            existCostTasks.put(existCostTask.getFunction(), existCostTask);
        }
        for (i = 0; i < costTasks.size(); ++i) {
            CostTaskInfo costTask = (CostTaskInfo)costTasks.get(i);
            if (!existCostTasks.containsKey(costTask.getFunction())) continue;
            CostTaskInfo existCostTask = (CostTaskInfo)existCostTasks.get(costTask.getFunction());
            Object[] params = new Object[]{existCostTask.getCompany().getName(), existCostTask.getName()};
            throw new CostTaskException(CostTaskException.CONCURRENT, params);
        }
    }

    @Override
    protected Map _execute(Context ctx, Map param) throws BOSException, EASBizException {
        ArrayList<Map> params = new ArrayList<Map>();
        params.add(param);
        List list = this._execute(ctx, params);
        if (list != null && list.size() > 0) {
            return (Map)list.get(0);
        }
        return null;
    }

    @Override
    protected List _execute(Context ctx, List params) throws BOSException, EASBizException {
        int i;
        Context newCtx = CostTaskUtils.cloneContext(ctx, null);
        Context simpleCtx = CostTaskUtils.cloneContext(ctx, null, true);
        ArrayList<Map> list = new ArrayList<Map>(params.size());
        Map param = null;
        try {
            for (i = 0; i < params.size(); ++i) {
                param = (Map)params.get(i);
                param.put("dbType", simpleCtx.get((Object)"dbType"));
                this.doCheck(simpleCtx, param);
            }
        }
        catch (Throwable t) {
            for (int i2 = 0; i2 < params.size(); ++i2) {
                CostTaskUtils.releaseMutex(simpleCtx, param);
            }
            logger.error((Object)ResourceBase.getString((String)RES_CLASSNAME, (String)"TASK_EXEERR_UNKNOWN", (Locale)simpleCtx.getLocale()), t);
            if (t instanceof BOSException) {
                throw (BOSException)t;
            }
            if (t instanceof EASBizException) {
                throw (EASBizException)t;
            }
            throw new BOSException(t);
        }
        try {
            for (i = 0; i < params.size(); ++i) {
                param = (Map)params.get(i);
                Map result = this.doExecute(newCtx, simpleCtx, param);
                list.add(result);
            }
        }
        catch (Throwable t) {
            CostTaskUtils.releaseMutex(simpleCtx, param);
            logger.error((Object)ResourceBase.getString((String)RES_CLASSNAME, (String)"TASK_EXEERR_UNKNOWN", (Locale)simpleCtx.getLocale()), t);
            if (t instanceof BOSException) {
                throw (BOSException)t;
            }
            if (t instanceof EASBizException) {
                throw (EASBizException)t;
            }
            throw new BOSException(t);
        }
        return list;
    }

    private void doCheck(Context ctx, Map param) throws Exception {
        CostTaskInfo costTask = CostTaskUtils.getTask(param);
        if (costTask == null) {
            throw new BOSException(ResourceBase.getString((String)RES_CLASSNAME, (String)"TASK_EXEERR_NOTASK", (Locale)ctx.getLocale()));
        }
        if (CostTaskUtils.getExecutorClazz(param) == null) {
            throw new BOSException(ResourceBase.getString((String)RES_CLASSNAME, (String)"TASK_EXEERR_NOEXECUTOR", (Locale)ctx.getLocale()));
        }
        if (costTask.getNumber() == null) {
            throw new BOSException(ResourceBase.getString((String)RES_CLASSNAME, (String)"TASK_EXEERR_NONUMBER", (Locale)ctx.getLocale()));
        }
        if (costTask.getCompany() == null || costTask.getCompany().getId() == null) {
            throw new BOSException(ResourceBase.getString((String)RES_CLASSNAME, (String)"TASK_EXEERR_NOCOMPANY", (Locale)ctx.getLocale()));
        }
        Class<?> executorClazz = Class.forName(CostTaskUtils.getExecutorClazz(param));
        CostTaskExecutor executor = (CostTaskExecutor)executorClazz.newInstance();
        if (!CostTaskUtils.isSendQueue(param)) {
            CostTaskUtils.setExecutor(param, executor);
        }
        CostTaskUtils.requestMutex(ctx, param);
    }

    private Map doExecute(Context ctx, Context simpleCtx, Map param) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        CostTaskInfo costTask = CostTaskUtils.getTask(param);
        costTask.setId(null);
        costTask.setCreateTime(new Timestamp(CostTaskUtils.getCurrentTime(ctx)));
        costTask.setStatus(CostTaskStatusEnum.NULL);
        if (costTask.getEntries() != null) {
            costTask.getEntries().clear();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)costTask.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)costTask.getNumber()));
        CostTaskFactory.getLocalInstance(ctx).delete(filter);
        if (CostTaskUtils.isSendQueue(param) && CostTaskUtils.isSyn(param)) {
            JobConfig config = new JobConfig();
            config.setNumber("ncmCostCal");
            config.setTitle("\u3010" + param.get("companyName") + "(" + param.get("companyNumber") + ")\u3011(" + costTask.getName() + ")");
            config.setSyn(CostTaskUtils.isSyn(param));
            costTask.setStatus(CostTaskStatusEnum.QUEUING);
            IObjectPK pk = CostTaskFactory.getLocalInstance(ctx).saveOrUpdate(costTask);
            costTask.setId(BOSUuid.read((String)pk.toString()));
            Map jobResult = CreateJobFacadeFactory.getLocalInstance((Context)ctx).executeJob(new JobParam((Object)param), config);
            String jobInstExtId = (String)jobResult.get("jobInstExtId");
            result.put("taskId", pk.toString());
            result.put("jobId", jobInstExtId);
            return result;
        }
        final CostTaskExecutor aExecutor = CostTaskUtils.getExecutor(param);
        final Context aCtx = ctx;
        final Context aSimpleCtx = simpleCtx;
        final CostTaskInfo aCostTask = costTask;
        final Map aParam = param;
        IObjectPK pk = CostTaskFactory.getLocalInstance(ctx).saveOrUpdate(costTask);
        costTask.setId(BOSUuid.read((String)pk.toString()));
        if (CostTaskUtils.isSyn(aParam)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    CostTaskFacadeControllerBean.this.runTask(aExecutor, aCtx, aSimpleCtx, aCostTask, aParam);
                }
            }).start();
        } else {
            this.runTask(aExecutor, aCtx, aSimpleCtx, aCostTask, aParam);
        }
        result.put("taskId", pk.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask(CostTaskExecutor aExecutor, Context aCtx, Context aSimpleCtx, CostTaskInfo aCostTask, Map aParam) {
        try {
            aExecutor.init(aCtx, aCostTask, aParam);
            aExecutor.initCostTaskEntries();
            aExecutor.execute();
        }
        finally {
            try {
                CostTaskUtils.releaseMutex(aSimpleCtx, aParam);
            }
            catch (Throwable t) {
                logger.error((Object)ResourceBase.getString((String)RES_CLASSNAME, (String)"TASK_EXEERR_MUTEX", (Locale)aCtx.getLocale()), t);
            }
        }
    }
}

