/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.transmission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.transmission.app.NCMTaskBlockDataRunner;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class AbstractNCMBatchDataImport
extends BlockDataTransmission {
    private static Logger logger = SysLog.getLogger(AbstractNCMBatchDataImport.class);
    private NCMTaskBlockDataRunner runner = null;
    protected CompanyOrgUnitInfo company = null;
    protected String companyId = null;
    protected PeriodInfo period = null;
    protected String periodId = null;
    protected String userId = null;
    protected String cuId = null;
    protected String tempTable = null;
    protected int index = -1;

    public void importFile(Context ctx, TaskExternalCode task) throws TaskExternalException {
        try {
            this.runner = new NCMTaskBlockDataRunner(task, this, ctx);
            this.index = this.runner.getBiginIndex();
            this.runner.run();
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected void doBeforeProcessData(Context ctx) throws Exception {
        this.company = ContextUtil.getCurrentFIUnit((Context)ctx);
        this.companyId = this.company.getId().toString();
        this.period = NCMUtils.GetCurrentPeriod(ctx, this.companyId);
        this.periodId = this.period.getId().toString();
        this.userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        this.cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String sql = this.buildTempTableSQL();
        if (sql != null && sql.length() > 0) {
            this.tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql);
        }
    }

    protected String buildTempTableSQL() {
        return null;
    }

    protected abstract void doProcessBlockData(Context var1, RecordCollection var2) throws Exception;

    protected abstract int doProcessData(Context var1) throws Exception;

    protected void doAfterProcessData(Context ctx) throws Exception {
        if (this.tempTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(this.tempTable);
        }
    }

    protected void onDataError(int nCurCount, Object error) throws TaskExternalException, TaskRunnerException {
        this.runner.onDataError(nCurCount, error);
    }

    protected String getResource(String key, Context ctx) {
        return this.getResource(key, ctx.getLocale());
    }

    protected String getResource(String key, Locale locale) {
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.ImportExportResource", (String)key, (Locale)locale);
    }

    public String getNotBlankString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public String getData(SimpleRecord record, String key) {
        String result;
        Object value;
        DataToken token = record.get(key);
        if (token != null && (value = token.data) != null && (result = value.toString().trim()).length() > 0) {
            return result;
        }
        return null;
    }

    protected BigDecimal getBigDecimalValueByFeildData(Context ctx, String fieldName, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return new BigDecimal("0");
        }
        BigDecimal value = null;
        try {
            value = TypeConversionUtils.objToBigDecimal((Object)data);
        }
        catch (Exception e) {
            throw new BOSException("\u8f6c\u6362 " + fieldName + " \u7684\u503c " + data + " \u51fa\u9519\uff0c\u8bf7\u68c0\u67e5 " + fieldName + " \u662f\u5426\u6b63\u786e\uff01");
        }
        return value;
    }

    public CostItemInfo getCostItemByNumber(Context ctx, String number) throws BOSException, EASBizException {
        throw new BOSException("\u4e0d\u652f\u6301");
    }

    protected String getTempTable() {
        return this.tempTable;
    }

    protected String getCompanyId() {
        return this.companyId;
    }

    protected String getCUId() {
        return this.cuId;
    }

    protected void buildCostCenterSQL(StringBuffer sql) {
        sql.append("     FCostCenterID varchar(44), \n");
        sql.append("     FCostCenterName nvarchar(255), \n");
        sql.append("     FCostCenterNumber nvarchar(255), \n");
        sql.append("     FCostCenterType int default(0), \n");
        sql.append("     FCostCenterIsBizUnit int default(0), \n");
        sql.append("     FCostCenterIsLegal int default(0), \n");
    }

    protected void buildCostObjectSQL(StringBuffer sql) {
        sql.append("     FCostObjectID varchar(44), \n");
        sql.append("     FCostObjectNumber nvarchar(255), \n");
        sql.append("     FCostObjectName nvarchar(255), \n");
        sql.append("     FCostObjectRelatedType int default(0), \n");
        sql.append("     FCostObjectCalculateMode int default(0), \n");
        sql.append("     FCostObjectIsForbiden int default(0), \n");
    }

    protected void buildStorageSQL(StringBuffer sql) {
        sql.append("     FStorageOrgUnitID varchar(44), \n");
        sql.append("     FStorageOrgUnitNumber nvarchar(255), \n");
        sql.append("     FStorageOrgUnitIsLegal int default(0), \n");
    }

    protected void buildOrderSQL(StringBuffer sql) {
        sql.append("     FOrderID varchar(44), \n");
        sql.append("     FOrderNumber nvarchar(255), \n");
        sql.append("     FOrderMaterialID varchar(44), \n");
    }

    protected void buildProductSQL(StringBuffer sql) {
        sql.append("     FProductID varchar(44), \n");
        sql.append("     FProductNumber nvarchar(255), \n");
        sql.append("     FProductName nvarchar(255), \n");
    }

    protected void buildCostItemSQL(StringBuffer sql) {
        sql.append("     FCostItemID varchar(44), \n");
        sql.append("     FCostItemName varchar(44), \n");
        sql.append("     FCostItemNumber nvarchar(255), \n");
    }

    protected void buildMaterialSQL(StringBuffer sql) {
        sql.append("     FMaterialID varchar(44), \n");
        sql.append("     FMaterialNumber nvarchar(255), \n");
        sql.append("     FMaterialName nvarchar(255), \n");
    }

    protected void buildAllocStdUnitSQL(StringBuffer sql) {
        sql.append("     FAllocStdUnitID varchar(44), \n");
        sql.append("     FAllocStdUnitNumber nvarchar(255), \n");
        sql.append("     FAllocStdUnitName nvarchar(255), \n");
        sql.append("     FAllocStdUnitType int default(0), \n");
    }

    protected void fillAndVerifyCostCenter(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        Locale locale = ctx.getLocale();
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FCostCenterID, \n");
        sql.append("    FCostCenterName, \n");
        sql.append("    FCostCenterType, \n");
        sql.append("    FCostCenterIsBizUnit \n");
        sql.append(") = ( \n");
        sql.append("    select \n");
        sql.append("        FID, \n");
        sql.append("        FName_" + locale + ", \n");
        sql.append("        FCostCenterType, \n");
        sql.append("        FIsBizUnit \n");
        sql.append("    from T_ORG_CostCenter cc \n");
        sql.append("    where cc.FNumber = t.FCostCenterNumber \n");
        sql.append("); \n");
        sql.append("update " + this.getTempTable() + " t set  \n");
        sql.append("    FCostCenterIsLegal = 1 \n");
        sql.append("where exists ( \n");
        sql.append("    select 1 from T_ORG_UnitRelation ur \n");
        sql.append("    join T_ORG_TypeRelation tr \n");
        sql.append("        on tr.FID = ur.FTypeRelationID \n");
        sql.append("        and tr.FFromType = 5 \n");
        sql.append("        and tr.FToType = 1 \n");
        sql.append("        where ur.FToUnitID = '" + this.getCompanyId() + "' \n");
        sql.append("        and ur.FFromUnitID = t.FCostCenterID \n");
        sql.append("); \n");
        NCMDbUtil.BatchSqlExecute(ctx, sql.toString());
        sql.setLength(0);
        sql.append("select * from " + this.getTempTable() + " \n");
        sql.append("where (\n");
        sql.append("    FCostCenterNumber is not null \n");
        sql.append("    and FCostCenterID is null \n");
        sql.append(") \n");
        sql.append("or ( \n");
        sql.append("    FCostCenterID is not null \n");
        sql.append("    and ( \n");
        sql.append("        FCostCenterIsBizUnit <> 1 \n");
        sql.append("        or FCostCenterIsLegal <> 1 \n");
        sql.append("    ) \n");
        sql.append(") \n");
        sql.append("or ( \n");
        sql.append("    FCostCenterID is not null \n");
        sql.append("    and FCostCenterType <>0 ); \n");
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String costCenterNumber = rs.getString("FCostCenterNumber");
            String costObjectId = rs.getString("FCostCenterID");
            if (costObjectId == null) {
                this.onDataError(index, "\u7f16\u7801\u4e3a[" + costCenterNumber + "]\u7684\u6210\u672c\u4e2d\u5fc3\u4e0d\u5b58\u5728\u3002");
                continue;
            }
            int type = rs.getInt("FCostCenterType");
            if (type != 0) {
                this.onDataError(index, "\u7f16\u7801\u4e3a[" + costCenterNumber + "]\u7684\u6210\u672c\u4e2d\u5fc3\u4e3a\u975e\u76f4\u63a5\u6210\u672c\u4e2d\u5fc3\u3002");
                continue;
            }
            boolean costCenterIsBizUnit = rs.getBoolean("FCostCenterIsBizUnit");
            if (!costCenterIsBizUnit) {
                this.onDataError(index, "\u7f16\u7801\u4e3a[" + costCenterNumber + "]\u7684\u6210\u672c\u4e2d\u5fc3\u4e0d\u662f\u5b9e\u4f53\u7ec4\u7ec7\u3002");
                continue;
            }
            boolean costCenterIsLegal = rs.getBoolean("FCostCenterIsLegal");
            if (costCenterIsLegal) continue;
            this.onDataError(index, "\u7f16\u7801\u4e3a[" + costCenterNumber + "]\u7684\u6210\u672c\u4e2d\u5fc3\u6ca1\u6709\u59d4\u6258\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u3002");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where (\n");
            sql.append("    FCostCenterNumber is not null \n");
            sql.append("    and FCostCenterID is null \n");
            sql.append(") \n");
            sql.append("or ( \n");
            sql.append("    FCostCenterID is not null \n");
            sql.append("    and ( \n");
            sql.append("        FCostCenterIsBizUnit <> 1 \n");
            sql.append("        or FCostCenterIsLegal <> 1 \n");
            sql.append("    ) \n");
            sql.append(") \n");
            sql.append("or ( \n");
            sql.append("    FCostCenterID is not null \n");
            sql.append("    and FCostCenterType <>0 ); \n");
            NCMDbUtil.execute(ctx, sql.toString());
        }
    }

    protected void fillAndVerifyCostObject(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        Locale locale = ctx.getLocale();
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FCostObjectID, \n");
        sql.append("    FCostObjectName, \n");
        sql.append("    FCostObjectRelatedType, \n");
        sql.append("    FCostObjectCalculateMode, \n");
        sql.append("    FCostObjectIsForbiden \n");
        sql.append(") = ( \n");
        sql.append("    select top 1 \n");
        sql.append("        FID, \n");
        sql.append("        FName_" + locale + ", \n");
        sql.append("        FRelatedType, \n");
        sql.append("        FCalculateMode, \n");
        sql.append("        FIsForbiden \n");
        sql.append("    from T_BD_CostObject co \n");
        sql.append("    where co.FNumber = t.FCostObjectNumber \n");
        sql.append("    and co.FCompanyID = '" + this.getCompanyId() + "' \n");
        sql.append("); \n");
        NCMDbUtil.BatchSqlExecute(ctx, sql.toString());
        sql.setLength(0);
        sql.append("select * from " + this.getTempTable() + " \n");
        sql.append("where (\n");
        sql.append("    FCostObjectNumber is not null \n");
        sql.append("    and FCostObjectID is null \n");
        sql.append(") \n");
        sql.append("or ( \n");
        sql.append("    FCostObjectID is not null \n");
        sql.append("    and FCostObjectIsForbiden = 1 \n");
        sql.append(") \n");
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String costObjectNumber = rs.getString("FCostObjectNumber");
            String costObjectId = rs.getString("FCostObjectID");
            if (costObjectId == null) {
                this.onDataError(index, "\u7f16\u7801\u4e3a[" + costObjectNumber + "]\u7684\u6210\u672c\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002");
                continue;
            }
            boolean costObjectIsForbiden = rs.getBoolean("FCostObjectIsForbiden");
            if (!costObjectIsForbiden) continue;
            this.onDataError(index, "\u7f16\u7801\u4e3a[" + costObjectNumber + "]\u7684\u6210\u672c\u5bf9\u8c61\u5df2\u7ecf\u88ab\u7981\u7528\u3002");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where (\n");
            sql.append("    FCostObjectNumber is not null \n");
            sql.append("    and FCostObjectID is null \n");
            sql.append(") \n");
            sql.append("or ( \n");
            sql.append("    FCostObjectID is not null \n");
            sql.append("    and FCostObjectIsForbiden = 1 \n");
            sql.append(") \n");
            NCMDbUtil.execute(ctx, sql.toString());
        }
    }

    protected void fillAndVerifyStorage(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FStorageOrgUnitID \n");
        sql.append(") = ( \n");
        sql.append("    select FID from T_ORG_Storage s \n");
        sql.append("    where s.FNumber = t.FStorageOrgUnitNumber \n");
        sql.append("); \n");
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FStorageOrgUnitIsLegal \n");
        sql.append(") = ( \n");
        sql.append("    select 1 from T_ORG_UnitRelation ur \n");
        sql.append("    join T_ORG_TypeRelation tr \n");
        sql.append("        on tr.FID = ur.FTypeRelationID \n");
        sql.append("        and tr.FFromType = 4 \n");
        sql.append("        and tr.FToType = 1 \n");
        sql.append("        where ur.FToUnitID = '" + this.getCompanyId() + "' \n");
        sql.append("        and ur.FFromUnitID = t.FStorageOrgUnitID \n");
        sql.append("); \n");
        NCMDbUtil.BatchSqlExecute(ctx, sql.toString());
        sql.setLength(0);
        sql.append("select * from " + this.getTempTable() + " \n");
        sql.append("where ( \n");
        sql.append("    FStorageOrgUnitNumber is not null \n");
        sql.append("    and FStorageOrgUnitID is null \n");
        sql.append(") \n");
        sql.append("or ( \n");
        sql.append("    FStorageOrgUnitID is not null \n");
        sql.append("    and FStorageOrgUnitIsLegal <> 1 \n");
        sql.append(") \n");
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String storageOrgUnitNumber = rs.getString("FStorageOrgUnitNumber");
            String storageOrgUnitId = rs.getString("FStorageOrgUnitID");
            if (storageOrgUnitId == null) {
                this.onDataError(index, "\u7f16\u7801\u4e3a[" + storageOrgUnitNumber + "]\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002");
                continue;
            }
            boolean storageOrgUnitIsLegal = rs.getBoolean("FStorageOrgUnitIsLegal");
            if (storageOrgUnitIsLegal) continue;
            this.onDataError(index, "\u7f16\u7801\u4e3a[" + storageOrgUnitNumber + "]\u7684\u5e93\u5b58\u7ec4\u7ec7\u6ca1\u6709\u59d4\u6258\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u3002");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where ( \n");
            sql.append("    FStorageOrgUnitNumber is not null \n");
            sql.append("    and FStorageOrgUnitID is null \n");
            sql.append(") \n");
            sql.append("or ( \n");
            sql.append("    FStorageOrgUnitID is not null \n");
            sql.append("    and FStorageOrgUnitIsLegal <> 1 \n");
            sql.append(") \n");
            NCMDbUtil.execute(ctx, sql.toString());
        }
    }

    protected void fillAndVerifyOrder(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FOrderID, FOrderMaterialID \n");
        sql.append(") = ( \n");
        sql.append("    select FID, FMaterialID from T_MM_ManufactureOrder mo \n");
        sql.append("    where mo.FNumber = t.FOrderNumber \n");
        sql.append("    and mo.FStorageOrgUnitID = t.FStorageOrgUnitID \n");
        sql.append("); \n");
        NCMDbUtil.BatchSqlExecute(ctx, sql.toString());
        sql.setLength(0);
        sql.append("select * from " + this.getTempTable() + " \n");
        sql.append("where ( \n");
        sql.append("    FOrderNumber is not null \n");
        sql.append("    and FOrderID is null \n");
        sql.append(") \n");
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String orderNumber = rs.getString("FOrderNumber");
            String orderId = rs.getString("FOrderID");
            if (orderId != null) continue;
            this.onDataError(index, "\u7f16\u7801\u4e3a[" + orderNumber + "]\u7684\u8ba2\u5355\u4e0d\u5b58\u5728\u3002");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where ( \n");
            sql.append("    FOrderNumber is not null \n");
            sql.append("    and FOrderID is null \n");
            sql.append(") \n");
            NCMDbUtil.execute(ctx, sql.toString());
        }
    }

    protected void fillAndVerifyProduct(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        Locale locale = ctx.getLocale();
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FProductID, FProductName \n");
        sql.append(") = ( \n");
        sql.append("    select FID, FName_" + locale + " \n");
        sql.append("    from T_BD_Material m \n");
        sql.append("    where m.FNumber = t.FProductNumber \n");
        sql.append("); \n");
        NCMDbUtil.BatchSqlExecute(ctx, sql.toString());
        sql.setLength(0);
        sql.append("select * from " + this.getTempTable() + " \n");
        sql.append("where (\n");
        sql.append("    FProductNumber is not null \n");
        sql.append("    and FProductID is null \n");
        sql.append(") \n");
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String productNumber = rs.getString("FProductNumber");
            String productId = rs.getString("FProductID");
            if (productId != null) continue;
            this.onDataError(index, "\u7f16\u7801\u4e3a[" + productNumber + "]\u7684\u7269\u6599\u4e0d\u5b58\u5728\u3002");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where (\n");
            sql.append("    FProductNumber is not null \n");
            sql.append("    and FProductID is null \n");
            sql.append(") \n");
            NCMDbUtil.execute(ctx, sql.toString());
        }
    }

    protected void fillAndVerifyCostItem(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        Locale locale = ctx.getLocale();
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FCostItemID, FCostItemName \n");
        sql.append(") = ( \n");
        sql.append("    select ci.FID, ci.FName_" + locale + " \n");
        sql.append("    from T_NCM_CostItem ci \n");
        sql.append("    join T_ORG_CtrlUnit cu on ci.FAdminCUID = cu.FID \n");
        sql.append("    where ci.FNumber = t.FCostItemNumber \n");
        sql.append("    and ( cu.FID = '" + this.getCUId() + "' or \n");
        sql.append("        ci.FID in ( \n");
        sql.append("            select FDataBaseDID from T_BD_DataBaseDAssign \n");
        sql.append("            where FBOSObjectType = '548C5A91' and FAssignCUID ='" + this.getCUId() + "' \n");
        sql.append("        ) \n");
        sql.append("    ) \n");
        sql.append("); \n");
        NCMDbUtil.BatchSqlExecute(ctx, sql.toString());
        sql.setLength(0);
        sql.append("select * from " + this.getTempTable() + " \n");
        sql.append("where (\n");
        sql.append("    FCostItemNumber is not null \n");
        sql.append("    and FCostItemID is null \n");
        sql.append(") \n");
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String costItemNumber = rs.getString("FCostItemNumber");
            String costItemId = rs.getString("FCostItemID");
            if (costItemId != null) continue;
            this.onDataError(index, "\u7f16\u7801\u4e3a[" + costItemNumber + "]\u7684\u6210\u672c\u9879\u76ee\u4e0d\u5b58\u5728\u3002");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where (\n");
            sql.append("    FCostItemNumber is not null \n");
            sql.append("    and FCostItemID is null \n");
            sql.append(") \n");
            NCMDbUtil.execute(ctx, sql.toString());
        }
    }

    protected void fillAndVerifyMaterial(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        Locale locale = ctx.getLocale();
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FMaterialID, FMaterialName \n");
        sql.append(") = ( \n");
        sql.append("    select FID, FName_" + locale + " \n");
        sql.append("    from T_BD_Material m \n");
        sql.append("    where m.FNumber = t.FMaterialNumber \n");
        sql.append("); \n");
        NCMDbUtil.BatchSqlExecute(ctx, sql.toString());
        sql.setLength(0);
        sql.append("select * from " + this.getTempTable() + " \n");
        sql.append("where (\n");
        sql.append("    FMaterialNumber is not null \n");
        sql.append("    and FMaterialID is null \n");
        sql.append(") \n");
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            if (rs.getString("FMaterialNumber").trim().length() <= 0) continue;
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String productNumber = rs.getString("FMaterialNumber");
            String productId = rs.getString("FMaterialID");
            if (productId != null) continue;
            this.onDataError(index, "\u7f16\u7801\u4e3a[" + productNumber + "]\u7684\u7269\u6599\u4e0d\u5b58\u5728\u3002");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where (\n");
            sql.append("    FMaterialNumber is not null \n");
            sql.append("    and FMaterialID is null \n");
            sql.append(") \n");
            NCMDbUtil.execute(ctx, sql.toString());
        }
    }

    protected void fillAndVerifyAllocStdUnit(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        Locale locale = ctx.getLocale();
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FAllocStdUnitID, FAllocStdUnitName, FAllocStdUnitType \n");
        sql.append(") = ( \n");
        sql.append("    select asu.FID, asu.FName_" + locale + ", asu.FAllocStdType \n");
        sql.append("    from T_NCM_AllocStdUnit asu \n");
        sql.append("    join T_ORG_CtrlUnit cu on asu.FAdminCUID = cu.FID \n");
        sql.append("    where asu.FNumber = t.FAllocStdUnitNumber \n");
        sql.append("    and ( cu.FID = '" + this.getCUId() + "' or \n");
        sql.append("        asu.FID in ( \n");
        sql.append("            select FDataBaseDID from T_BD_DataBaseDAssign \n");
        sql.append("            where FBOSObjectType = '9DD41AE3' and FAssignCUID ='" + this.getCUId() + "' \n");
        sql.append("        ) \n");
        sql.append("    ) \n");
        sql.append("); \n");
        NCMDbUtil.BatchSqlExecute(ctx, sql.toString());
        sql.setLength(0);
        sql.append("select * from " + this.getTempTable() + " \n");
        sql.append("where (\n");
        sql.append("    FAllocStdUnitNumber is not null \n");
        sql.append("    and FAllocStdUnitID is null \n");
        sql.append(") \n");
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String allocStdUnitNumber = rs.getString("FAllocStdUnitNumber");
            String allocStdUnitId = rs.getString("FAllocStdUnitID");
            if (allocStdUnitId != null) continue;
            this.onDataError(index, "\u7f16\u7801\u4e3a[" + allocStdUnitNumber + "]\u7684\u5206\u914d\u6807\u51c6\u5355\u5143\u4e0d\u5b58\u5728\u3002");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where (\n");
            sql.append("    FAllocStdUnitNumber is not null \n");
            sql.append("    and FAllocStdUnitID is null \n");
            sql.append(") \n");
            NCMDbUtil.execute(ctx, sql.toString());
        }
    }

    protected void fillPeriod(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FPeriodID \n");
        sql.append(") = ( \n");
        sql.append("    select period.FID \n");
        sql.append("    from T_BD_Period period \n");
        sql.append("    inner join T_Org_Company company \n");
        sql.append("    on company.FAccountPeriodID = period.FTypeID  and company.FID = '" + this.getCompanyId() + "' \n");
        sql.append("    where period.FBeginDate <= t.FBizDate and period.FEndDate >= t.FBizDate \n");
        sql.append("    ); \n");
        NCMDbUtil.BatchSqlExecute(ctx, sql.toString());
    }

    protected void findCostObjectByOrder(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FCostObjectID \n");
        sql.append(") = ( \n");
        sql.append("    select mo.FCostObjectID \n");
        sql.append("    from T_MM_ManufactureOrder mo \n");
        sql.append("    where mo.FID = t.FOrderID \n");
        sql.append(") \n");
        sql.append("where t.FCostObjectID is null \n");
        sql.append("; \n");
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FCostObjectID \n");
        sql.append(") = ( \n");
        sql.append("    select co.FID \n");
        sql.append("    from T_BD_CostObject co \n");
        sql.append("    join T_MM_ManufactureOrder mo \n");
        sql.append("        on mo.FID = co.FOrderID \n");
        sql.append("    join T_BD_Material m \n");
        sql.append("        on m.FID = mo.FMaterialID \n");
        sql.append("    join T_BD_MaterialCompanyInfo mc \n");
        sql.append("        on mc.FMaterialID = m.FID \n");
        sql.append("        and mc.FCompanyID = '" + this.getCompanyId() + "' \n");
        sql.append("        and mc.FCreateCOByOrder = 1 \n");
        sql.append("    where mo.FID = t.FOrderID \n");
        sql.append(") \n");
        sql.append("where t.FCostObjectID is null \n");
        sql.append("; \n");
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FCostObjectID \n");
        sql.append(") = ( \n");
        sql.append("    select co.FID \n");
        sql.append("    from T_BD_CostObject co \n");
        sql.append("    join T_BD_Material m \n");
        sql.append("        on m.FID = co.FStdProductIDID \n");
        sql.append("    where co.FCompanyID = '" + this.getCompanyId() + "' \n");
        sql.append("    and co.FIsForbiden = 0 \n");
        sql.append("    and m.FID = t.FOrderMaterialID \n");
        sql.append("    and ( \n");
        sql.append("        co.FCalculateMode = 1 \n");
        sql.append("        or \n");
        sql.append("        co.FCalculateMode = 3 \n");
        sql.append("        or \n");
        sql.append("        co.FCalculateMode = 4 \n");
        sql.append("        and co.FBatchNumber = t.FBatch \n");
        sql.append("    ) \n");
        sql.append(") \n");
        sql.append("where t.FCostObjectID is null \n");
        sql.append("; \n");
        NCMDbUtil.BatchSqlExecute(ctx, sql.toString());
        sql.setLength(0);
        sql.setLength(0);
        sql.append("select * from " + this.getTempTable() + " \n");
        sql.append("where FCostObjectID is null \n");
        sql.append("and FOrderID is not null \n");
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String orderNumber = rs.getString("FOrderNumber");
            this.onDataError(index, "\u627e\u4e0d\u5230\u8ba2\u5355[" + orderNumber + "]\u5bf9\u5e94\u7684\u6210\u672c\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where FCostObjectID is null \n");
            sql.append("and FOrderID is not null \n");
            NCMDbUtil.execute(ctx, sql.toString());
        }
    }

    protected void findCostObjectByProduct(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + this.getTempTable() + " t set ( \n");
        sql.append("    FCostObjectID \n");
        sql.append(") = ( \n");
        sql.append("    select co.FID \n");
        sql.append("    from T_BD_CostObject co \n");
        sql.append("    join T_BD_Material m \n");
        sql.append("        on m.FID = co.FStdProductIDID \n");
        sql.append("    where co.FCompanyID = '" + this.getCompanyId() + "' \n");
        sql.append("    and co.FIsForbiden = 0 \n");
        sql.append("    and m.FID = t.FProductID \n");
        sql.append("    and ( \n");
        sql.append("        co.FCalculateMode = 1 \n");
        sql.append("        or \n");
        sql.append("        co.FCalculateMode = 3 \n");
        sql.append("        or \n");
        sql.append("        co.FCalculateMode = 4 \n");
        sql.append("        and co.FBatchNumber = t.FBatch \n");
        sql.append("    ) \n");
        sql.append(") \n");
        sql.append("where FCostObjectID is null \n");
        sql.append("; \n");
        NCMDbUtil.BatchSqlExecute(ctx, sql.toString());
        sql.setLength(0);
        sql.setLength(0);
        sql.append("select * from " + this.getTempTable() + " \n");
        sql.append("where FCostObjectID is null \n");
        sql.append("and FProductID is not null \n");
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            String productNumber = rs.getString("FProductNumber");
            String batch = rs.getString("FBatch");
            this.onDataError(index, "\u627e\u4e0d\u5230\u7269\u6599[" + productNumber + "]+\u6279\u6b21[" + (batch == null ? "" : batch) + "]\u5bf9\u5e94\u7684\u6210\u672c\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where FCostObjectID is null \n");
            sql.append("and FProductID is not null \n");
            NCMDbUtil.execute(ctx, sql.toString());
        }
    }
}

