/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.transmission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostItemTypeTreeCollection;
import com.kingdee.eas.basedata.assistant.CostItemTypeTreeFactory;
import com.kingdee.eas.basedata.assistant.CostItemTypeTreeInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupCollection;
import com.kingdee.eas.basedata.assistant.CostObjectGroupFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteCollection;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteFactory;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteInfo;
import com.kingdee.eas.basedata.assistant.ICostItem;
import com.kingdee.eas.basedata.assistant.ICostItemTypeTree;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.ICostObjectGroup;
import com.kingdee.eas.basedata.assistant.ICostObjectSuite;
import com.kingdee.eas.basedata.assistant.IKAClassfication;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.IProject;
import com.kingdee.eas.basedata.assistant.KACLlassficationTypeCollection;
import com.kingdee.eas.basedata.assistant.KACLlassficationTypeFactory;
import com.kingdee.eas.basedata.assistant.KACLlassficationTypeInfo;
import com.kingdee.eas.basedata.assistant.KAClassficationCollection;
import com.kingdee.eas.basedata.assistant.KAClassficationFactory;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.ProjectCollection;
import com.kingdee.eas.basedata.assistant.ProjectFactory;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.framework.DataBaseDAssignCollection;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.master.account.AccountTypeCollection;
import com.kingdee.eas.basedata.master.account.AccountTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.AUXOverheadCollection;
import com.kingdee.eas.basedata.ncm.AUXOverheadFactory;
import com.kingdee.eas.basedata.ncm.AUXOverheadInfo;
import com.kingdee.eas.basedata.ncm.AllocStdCollection;
import com.kingdee.eas.basedata.ncm.AllocStdFactory;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.AllocStdUnitCollection;
import com.kingdee.eas.basedata.ncm.AllocStdUnitFactory;
import com.kingdee.eas.basedata.ncm.AllocStdUnitInfo;
import com.kingdee.eas.basedata.ncm.CostCenterOrgUnitGroupCollection;
import com.kingdee.eas.basedata.ncm.CostCenterOrgUnitGroupFactory;
import com.kingdee.eas.basedata.ncm.CostCenterOrgUnitGroupInfo;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.ExpenseTreeCollection;
import com.kingdee.eas.basedata.ncm.ExpenseTreeFactory;
import com.kingdee.eas.basedata.ncm.ExpenseTreeInfo;
import com.kingdee.eas.basedata.ncm.IAUXOverhead;
import com.kingdee.eas.basedata.ncm.IAllocStd;
import com.kingdee.eas.basedata.ncm.IAllocStdUnit;
import com.kingdee.eas.basedata.ncm.ICostCenterOrgUnitGroup;
import com.kingdee.eas.basedata.ncm.IExpense;
import com.kingdee.eas.basedata.ncm.IExpenseTree;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.BomCollection;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.std.basedata.ISTCostBOMQueue;
import com.kingdee.eas.ncm.std.basedata.ISTDCostEstimateScheme;
import com.kingdee.eas.ncm.std.basedata.STCostBOMQueueFactory;
import com.kingdee.eas.ncm.std.basedata.STCostBOMQueueInfo;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeCollection;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeFactory;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NCMDataImportUtil {
    private static Logger logger = Logger.getLogger((String)NCMDataImportUtil.class.getName());

    public static CompanyOrgUnitInfo getCompanyByNumber(Context ctx, String number) throws BOSException {
        CompanyOrgUnitInfo company = null;
        try {
            ICompanyOrgUnit iCompanyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitCollection coll = iCompanyOrg.getCompanyOrgUnitCollection("where number='" + number + "'");
            if (coll == null || coll.size() <= 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"178_NCMDataImportUtil", (Locale)ctx.getLocale()));
            }
            company = coll.get(0);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        return company;
    }

    private static String getExceptionMessage(Context ctx, String fieldName) {
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"179_NCMDataImportUtil", (Locale)ctx.getLocale()) + fieldName + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"180_NCMDataImportUtil", (Locale)ctx.getLocale()) + fieldName + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"181_NCMDataImportUtil", (Locale)ctx.getLocale());
    }

    public static CostObjectGroupInfo getCostObjectGroupByNumber(Context ctx, String fieldName, String number) throws BOSException {
        return NCMDataImportUtil.getCostObjectGroupByNumber(ctx, fieldName, number, null);
    }

    public static CostObjectGroupInfo getCostObjectGroupByNumber(Context ctx, String resourceName, String number, String cuId) throws BOSException {
        ICostObjectGroup iCostObjectGroup = CostObjectGroupFactory.getLocalInstance((Context)ctx);
        CostObjectGroupInfo costObjectGroup = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        if (cuId != null && !"".equals(cuId)) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuId));
        }
        view.setFilter(filter);
        CostObjectGroupCollection coll = iCostObjectGroup.getCostObjectGroupCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, resourceName));
        }
        costObjectGroup = coll.get(0);
        return costObjectGroup;
    }

    public static BomInfo getBomByNumber(Context ctx, String fieldName, String number, String companyId) throws BOSException {
        IBom iBom = BomFactory.getLocalInstance((Context)ctx);
        BomInfo bom = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)NCMDataImportUtil.getStorageSetByCompany(ctx, companyId), CompareType.INCLUDE));
        view.setFilter(filter);
        BomCollection coll = iBom.getBomCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        bom = coll.get(0);
        return bom;
    }

    private static Set getStorageSetByCompany(Context ctx, String companyId) throws BOSException {
        OrgUnitCollection ccColl = null;
        try {
            IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            ccColl = iOUR.getFromUnit(companyId, 1, 4);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"182_NCMDataImportUtil", (Locale)ctx.getLocale()));
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        return ccIDSet;
    }

    public static MaterialInfo getMaterialByNumber(Context ctx, String fieldName, String number) throws BOSException {
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo material = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        MaterialCollection coll = iMaterial.getMaterialCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        material = coll.get(0);
        return material;
    }

    public static MaterialInfo getMaterialByFeild(Context ctx, String field, String value) throws BOSException {
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo material = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(field, (Object)value));
        view.setFilter(filter);
        MaterialCollection coll = iMaterial.getMaterialCollection(view);
        if (coll != null && coll.size() > 0) {
            material = coll.get(0);
        }
        return material;
    }

    public static MaterialCompanyInfoInfo getMaterialCompanyInfoByMaterial(Context ctx, String mateialNumber, String mateialId, String companyId) throws BOSException {
        IMaterialCompanyInfo iMaterialCompanyInfo = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoInfo materialCompanyInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial", (Object)mateialId));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId));
        view.setFilter(filter);
        MaterialCompanyInfoCollection coll = iMaterialCompanyInfo.getMaterialCompanyInfoCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + mateialNumber + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"183_NCMDataImportUtil", (Locale)ctx.getLocale()));
        }
        materialCompanyInfo = coll.get(0);
        return materialCompanyInfo;
    }

    public static ProjectInfo getProjectByNumber(Context ctx, String fieldName, String number) throws BOSException {
        IProject iProject = ProjectFactory.getLocalInstance((Context)ctx);
        ProjectInfo project = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        ProjectCollection coll = iProject.getProjectCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"184_NCMDataImportUtil", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"185_NCMDataImportUtil", (Locale)ctx.getLocale()) + fieldName + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"186_NCMDataImportUtil", (Locale)ctx.getLocale()));
        }
        project = coll.get(0);
        return project;
    }

    public static AUXOverheadInfo getAUXOverheadByNumber(Context ctx, String fieldName, String number) throws BOSException {
        IAUXOverhead iAUXOverhead = AUXOverheadFactory.getLocalInstance((Context)ctx);
        AUXOverheadInfo aUXOverhead = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        AUXOverheadCollection coll = iAUXOverhead.getAUXOverheadCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        aUXOverhead = coll.get(0);
        return aUXOverhead;
    }

    public static CostItemTypeTreeInfo getCostItemTypeTreeByNumber(Context ctx, String fieldName, String number) throws BOSException {
        ICostItemTypeTree iCostItemTypeTree = CostItemTypeTreeFactory.getLocalInstance((Context)ctx);
        CostItemTypeTreeInfo costItemTypeTree = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        CostItemTypeTreeCollection coll = iCostItemTypeTree.getCostItemTypeTreeCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        costItemTypeTree = coll.get(0);
        return costItemTypeTree;
    }

    public static MeasureUnitInfo getMeasureUnitInfoByNumber(Context ctx, String fieldName, String number) throws BOSException {
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
        MeasureUnitInfo measureUnit = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        MeasureUnitCollection coll = iMeasureUnit.getMeasureUnitCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        measureUnit = coll.get(0);
        return measureUnit;
    }

    public static ExpenseTreeInfo getExpenseTreeByNumber(Context ctx, String fieldName, String number) throws BOSException {
        IExpenseTree iExpenseTree = ExpenseTreeFactory.getLocalInstance((Context)ctx);
        ExpenseTreeInfo expenseTree = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        ExpenseTreeCollection coll = iExpenseTree.getExpenseTreeCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        expenseTree = coll.get(0);
        return expenseTree;
    }

    public static ExpenseInfo getExpenseByNumber(Context ctx, String fieldName, String number) throws BOSException {
        return NCMDataImportUtil.getExpenseByNumber(ctx, fieldName, number, null);
    }

    public static ExpenseInfo getExpenseByNumber(Context ctx, String fieldName, String number, FilterInfo exFilter) throws BOSException {
        IExpense iExpense = ExpenseFactory.getLocalInstance((Context)ctx);
        ExpenseInfo expense = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = view.getSelector();
        selector.add("*");
        selector.add("unit.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        if (exFilter != null) {
            filter.mergeFilter(exFilter, "and");
        }
        view.setFilter(filter);
        ExpenseCollection coll = iExpense.getExpenseCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        expense = coll.get(0);
        return expense;
    }

    public static KAClassficationInfo getKAClassficationByNumber(Context ctx, String fieldName, String number) throws BOSException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyOrg");
        IKAClassfication iKAClassfication = KAClassficationFactory.getLocalInstance((Context)ctx);
        KAClassficationInfo kAClassfication = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("currencyCompany", (Object)company.getId().toString()));
        view.setFilter(filter);
        KAClassficationCollection coll = iKAClassfication.getKAClassficationCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        kAClassfication = coll.get(0);
        return kAClassfication;
    }

    public static void checkKAClassfication(Context ctx, String companyId, KAClassficationInfo kAClass) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("typelink", (Object)NCMDataImportUtil.getKACLlassficationType(ctx)));
        filter.getFilterItems().add(new FilterItemInfo("currencyCompany", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)kAClass.getId().toString()));
        view.setFilter(filter);
        KAClassficationCollection coll = KAClassficationFactory.getLocalInstance((Context)ctx).getKAClassficationCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"187_NCMDataImportUtil", (Locale)ctx.getLocale()) + kAClass.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"188_NCMDataImportUtil", (Locale)ctx.getLocale()));
        }
    }

    private static String getKACLlassficationType(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("objectType", (Object)"9UMPQgEcEADgAAkZwKgSKbmZyjk="));
        view.setFilter(filter);
        KACLlassficationTypeInfo KACLlassficationType = null;
        KACLlassficationTypeCollection coll = KACLlassficationTypeFactory.getLocalInstance((Context)ctx).getKACLlassficationTypeCollection(view);
        if (coll == null || coll.size() < 1) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"189_NCMDataImportUtil", (Locale)ctx.getLocale()));
        }
        KACLlassficationType = coll.get(0);
        return KACLlassficationType.getId().toString();
    }

    public static CostItemInfo getCostItemByNumber(Context ctx, String fieldName, String number) throws BOSException {
        ICostItem iCostItem = CostItemFactory.getLocalInstance((Context)ctx);
        CostItemInfo costItem = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        CostItemCollection coll = iCostItem.getCostItemCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        costItem = coll.get(0);
        return costItem;
    }

    public static AllocStdUnitInfo getAllocStdUnitByNumber(Context ctx, String fieldName, String number) throws BOSException {
        IAllocStdUnit iAllocStdUnit = AllocStdUnitFactory.getLocalInstance((Context)ctx);
        AllocStdUnitInfo allocStdUnit = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        AllocStdUnitCollection coll = iAllocStdUnit.getAllocStdUnitCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        allocStdUnit = coll.get(0);
        return allocStdUnit;
    }

    public static CostCenterOrgUnitInfo getCostCenterbyNumber(Context ctx, String fieldName, String number) throws BOSException {
        ICostCenterOrgUnit iCostCenterOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        CostCenterOrgUnitInfo costCenter = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        CostCenterOrgUnitCollection coll = iCostCenterOrgUnit.getCostCenterOrgUnitCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        costCenter = coll.get(0);
        return costCenter;
    }

    public static CostObjectInfo getCostObjectbyNumber(Context ctx, String fieldName, String number, String companyID) throws BOSException {
        ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        CostObjectInfo costObject = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID));
        view.setFilter(filter);
        CostObjectCollection coll = iCostObject.getCostObjectCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        costObject = coll.get(0);
        return costObject;
    }

    public static CostCenterOrgUnitGroupInfo getCostCenterGroupbyNumber(Context ctx, String fieldName, String number, String companyID) throws BOSException {
        ICostCenterOrgUnitGroup iCostCenterGroup = CostCenterOrgUnitGroupFactory.getLocalInstance((Context)ctx);
        CostCenterOrgUnitGroupInfo costCenterOrgUnitGroupInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyID));
        view.setFilter(filter);
        CostCenterOrgUnitGroupCollection coll = iCostCenterGroup.getCostCenterOrgUnitGroupCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        costCenterOrgUnitGroupInfo = coll.get(0);
        return costCenterOrgUnitGroupInfo;
    }

    public static AllocStdInfo getAllocStdByNumber(Context ctx, String fieldName, String number) throws BOSException {
        IAllocStd iAllocStd = AllocStdFactory.getLocalInstance((Context)ctx);
        AllocStdInfo allocStd = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        AllocStdCollection coll = iAllocStd.getAllocStdCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        allocStd = coll.get(0);
        return allocStd;
    }

    public static CostObjectSuiteInfo getCostObjectSuitebyNumber(Context ctx, String fieldName, String number, String companyID) throws BOSException {
        ICostObjectSuite iCostObjectSuite = CostObjectSuiteFactory.getLocalInstance((Context)ctx);
        CostObjectSuiteInfo costObjectSuite = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID));
        view.setFilter(filter);
        CostObjectSuiteCollection coll = iCostObjectSuite.getCostObjectSuiteCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        costObjectSuite = coll.get(0);
        return costObjectSuite;
    }

    public static void checkDataBaseDPermission(Context ctx, String thisCUId, String compareCUId, String bosType, String checkDataId, String number, String feildName) throws BOSException {
        if (!NCMDataImportUtil.isDataBaseDPermission(ctx, thisCUId, compareCUId, bosType, checkDataId)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"190_NCMDataImportUtil", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"237_NCMDataImportUtil", (Locale)ctx.getLocale()) + feildName + "\uff01");
        }
    }

    public static boolean isDataBaseDPermission(Context ctx, String thisCUId, String compareCUId, String bosType, String checkDataId) throws BOSException {
        return NCMDataImportUtil.isAdminData(thisCUId, compareCUId) || NCMDataImportUtil.isAssignedDataBaseDId(ctx, bosType, thisCUId, checkDataId);
    }

    public static boolean isAdminData(String thisCUId, String compareCUId) {
        return thisCUId.equals(compareCUId);
    }

    public static boolean isAssignedDataBaseDId(Context ctx, String bosObjectType, String assignCUId, String dataBaseDID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bosObjectType", (Object)bosObjectType));
        filter.getFilterItems().add(new FilterItemInfo("assignCU", (Object)assignCUId));
        filter.getFilterItems().add(new FilterItemInfo("dataBaseDID", (Object)dataBaseDID));
        view.setFilter(filter);
        DataBaseDAssignCollection coll = DataBaseDAssignFactory.getLocalInstance((Context)ctx).getDataBaseDAssignCollection(view);
        return coll != null && coll.size() > 0;
    }

    public static void checkCostCenter(Context ctx, CostCenterOrgUnitInfo costCenter, String companyId) throws BOSException {
        if (!costCenter.isIsBizUnit()) {
            throw new BOSException(costCenter.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"191_NCMDataImportUtil", (Locale)ctx.getLocale()));
        }
        if (costCenter.isIsSealUp()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + costCenter.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"192_NCMDataImportUtil", (Locale)ctx.getLocale()));
        }
        NCMDataImportUtil.isCostCenterDelegateCurCompany(ctx, costCenter.getId().toString(), costCenter.getNumber(), companyId);
    }

    public static void isCostCenterDelegateCurCompany(Context ctx, String costCenterId, String costCenterNumber, String companyId) throws BOSException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = null;
        try {
            coll = iOUR.getFromUnit(companyId, 1, 5);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        boolean isValidCC = false;
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                if (!costCenterId.equals(coll.get(i).getId().toString())) continue;
                isValidCC = true;
            }
        }
        if (!isValidCC) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"193_NCMDataImportUtil", (Locale)ctx.getLocale()) + costCenterNumber + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"194_NCMDataImportUtil", (Locale)ctx.getLocale()));
        }
    }

    public static void checkCUBDControlForAdd(Context ctx, String objectType, String ctrlUnitPK) throws BOSException {
        if (!NCMDataImportUtil.isCUBDControlForAdd(ctx, objectType, ctrlUnitPK)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"70_CostItemDataImport", (Locale)ctx.getLocale()));
        }
    }

    public static void checkCUBDControlForUpdate(Context ctx, String objectType, String ctrlUnitPK) throws BOSException {
        if (!NCMDataImportUtil.isCUBDControlForUpdate(ctx, objectType, ctrlUnitPK)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"71_CostItemDataImport", (Locale)ctx.getLocale()));
        }
    }

    public static boolean isCUBDControlForAdd(Context ctx, String objectType, String ctrlUnitPK) throws BOSException {
        CUBDControlInfo controlInfo = NCMDataImportUtil.getCUBDControlInfo(ctx, objectType, ctrlUnitPK);
        return controlInfo == null ? false : controlInfo.isIsSubordinateAddnewable();
    }

    public static boolean isCUBDControlForUpdate(Context ctx, String objectType, String ctrlUnitPK) throws BOSException {
        CUBDControlInfo controlInfo = NCMDataImportUtil.getCUBDControlInfo(ctx, objectType, ctrlUnitPK);
        return controlInfo == null ? false : controlInfo.isIsSubordinateEditable();
    }

    private static CUBDControlInfo getCUBDControlInfo(Context ctx, String objectType, String ctrlUnitPK) throws BOSException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = null;
        try {
            controlInfo = iCUBDControl.getBDCtrlInfo(objectType, ctrlUnitPK);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return controlInfo;
    }

    public static StorageOrgUnitInfo getStorageOrgByNumber(Context ctx, String fieldName, String number) throws BOSException, EASBizException {
        IStorageOrgUnit i = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        StorageOrgUnitCollection storageOrgUnitCol = i.getStorageOrgUnitCollection(view);
        if (storageOrgUnitCol == null || storageOrgUnitCol.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        storageOrgUnitInfo = storageOrgUnitCol.get(0);
        return storageOrgUnitInfo;
    }

    public static STDCostEstimateSchemeInfo getEstimateSchemeByNumber(Context ctx, String fieldName, String number) throws BOSException, EASBizException {
        ISTDCostEstimateScheme i = STDCostEstimateSchemeFactory.getLocalInstance((Context)ctx);
        STDCostEstimateSchemeInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        STDCostEstimateSchemeCollection collection = i.getSTDCostEstimateSchemeCollection(view);
        if (collection == null || collection.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        info = collection.get(0);
        return info;
    }

    public static STCostBOMQueueInfo getBOMQueueByNumber(Context ctx, String fieldName, String number) throws BOSException, EASBizException {
        STCostBOMQueueInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        ISTCostBOMQueue i = STCostBOMQueueFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection collection = i.getCollection(view);
        if (collection == null || collection.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        info = (STCostBOMQueueInfo)collection.get(0);
        return info;
    }

    public static AccountViewInfo getAccountViewByNumber(Context ctx, String fieldName, String number) throws BOSException {
        AccountViewInfo accountViewInfo = null;
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        CompanyOrgUnitInfo companyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        String accounttableID = "";
        if (companyInfo.getAccountTable() != null && companyInfo.getAccountTable().getId() != null) {
            accounttableID = companyInfo.getAccountTable().getId().toString();
        }
        StringBuffer getAccountType = new StringBuffer();
        getAccountType.append("select * where property = 3 ").append(" and accountTableID = '").append(accounttableID).append("'");
        AccountTypeCollection accountTypeColl = AccountTypeFactory.getLocalInstance((Context)ctx).getAccountTypeCollection(getAccountType.toString());
        HashSet<String> accountTypeIDSet = new HashSet<String>();
        Iterator iter = accountTypeColl.iterator();
        while (iter.hasNext()) {
            accountTypeIDSet.add(((AccountTypeInfo)iter.next()).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("accounttableID", (Object)accounttableID));
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)DefaultCU.getId().toString()));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CAA.*"));
        view.setSelector(sic);
        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
        AccountViewCollection collection = iAccountView.getAccountViewCollection(view);
        if (collection == null || collection.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        accountViewInfo = collection.get(0);
        return accountViewInfo;
    }

    public static Map getAsstActInfoByAccount(Context ctx, String fieldName, AccountViewInfo accountViewInfo) throws BOSException, EASBizException {
        String asstAccountID = null;
        HashMap<String, String> asstAccountNumberMap = null;
        AsstAccountInfo asstAccount = accountViewInfo.getCAA();
        if (asstAccount == null) {
            return asstAccountNumberMap;
        }
        asstAccountID = asstAccount.getId().toString();
        IAsstAccount iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
        AsstAccountInfo asstAccountInfo = iAsstAccount.getAsstAccountInfo((IObjectPK)new ObjectStringPK(asstAccountID));
        AsstActGroupDetailCollection asstCollection = asstAccountInfo.getAsstActGpDt();
        AsstActTypeInfo asstActTypeInfo = null;
        asstAccountNumberMap = new HashMap<String, String>();
        int count1 = asstCollection.size();
        for (int i = 0; i < count1; ++i) {
            asstActTypeInfo = asstAccountInfo.getAsstActGpDt().get(i).getAsstActType();
            if (asstActTypeInfo.getId() == null) continue;
            IAsstActType iAsstAcctType = AsstActTypeFactory.getLocalInstance((Context)ctx);
            AsstActTypeInfo fullAsstActTypeInfo = iAsstAcctType.getAsstActTypeInfo((IObjectPK)new ObjectStringPK(asstActTypeInfo.getId().toString()));
            asstAccountNumberMap.put(fullAsstActTypeInfo.getNumber(), fullAsstActTypeInfo.getDefaultQueryName());
        }
        return asstAccountNumberMap;
    }

    public static AdminOrgUnitInfo getFullOrgUnitInfoByNumber(Context ctx, String fieldName, String number, String companyId) throws BOSException, EASBizException {
        AdminOrgUnitInfo info = null;
        Set ccIDSet = BDCMUtils.getAdminAndCostCenterSet((Context)ctx, (String)companyId);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("number", (Object)number);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ccIDSet, CompareType.INCLUDE));
        view.setFilter(filter);
        AdminOrgUnitCollection coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(NCMDataImportUtil.getExceptionMessage(ctx, fieldName));
        }
        info = coll.get(0);
        return info;
    }

    public static ManufactureOrderInfo getManufactureOrderByNumber(Context ctx, String FieldName, String number, String companyID, String storageNumber) throws EASBizException, BOSException {
        ManufactureOrderInfo orderInfo = null;
        if (storageNumber == null || storageNumber.trim().length() == 0) {
            throw new BOSException("\u6839\u636e\u8ba2\u5355\u53d6\u6210\u672c\u5bf9\u8c61\uff0c\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        String sql = "select id,number where number = '" + storageNumber + "'";
        StorageOrgUnitInfo storageInfo = null;
        CoreBaseCollection storColl = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getCollection(sql);
        if (storColl != null && storColl.size() > 0) {
            storageInfo = (StorageOrgUnitInfo)storColl.get(0);
        }
        if (storageInfo == null) {
            throw new BOSException("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u975e\u6cd5");
        }
        Set storageIDsSet = BDCMUtils.getStorageOrgUnitIdsOfCompany((Context)ctx, (String)companyID);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        if (!storageIDsSet.contains(storageInfo.getId().toString())) {
            throw new BOSException("\u5e93\u5b58\u7ec4\u7ec7 " + storageNumber + " \u6ca1\u6709\u59d4\u6258\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u8bb0\u8d26\uff0c\u4e0d\u80fd\u5f15\u5165\u8be5\u751f\u4ea7\u8ba2\u5355\u3002");
        }
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageInfo.getId().toString()));
        view.setFilter(filter);
        ManufactureOrderCollection orderColl = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderCollection(view);
        if (orderColl != null && orderColl.size() > 1) {
            throw new BOSException("\u8be5\u751f\u4ea7\u8ba2\u5355\u7f16\u7801\u5bf9\u5e94\u591a\u4e2a\u751f\u4ea7\u8ba2\u5355\uff0c\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u3002");
        }
        if (orderColl != null && orderColl.size() > 0) {
            orderInfo = orderColl.get(0);
        }
        return orderInfo;
    }

    public static CostObjectInfo getCostObjectByOrder(Context ctx, String companyId, String storageOrgUnitNumber, String orderNumber, String batch) throws BOSException, EASBizException {
        if (storageOrgUnitNumber == null || storageOrgUnitNumber.length() == 0) {
            throw new BOSException("\u6839\u636e\u8ba2\u5355\u53d6\u6210\u672c\u5bf9\u8c61\uff0c\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(5);
        statuses.add(7);
        statuses.add(8);
        statuses.add(11);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)6));
        filter.getFilterItems().add(new FilterItemInfo("oldBaseStatus", statuses, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)orderNumber));
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)storageOrgUnitNumber));
        Set storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany((Context)ctx, (String)companyId);
        if (storageOrgUnitIds != null && storageOrgUnitIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitIds, CompareType.INCLUDE));
            filter.setMaskString("(#0 or #1 and #2) and #3 and #4 and #5");
        } else {
            filter.setMaskString("(#0 or #1 and #2) and #3 and #4");
        }
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("material.id");
        selector.add("material.number");
        selector.add("material.name");
        selector.add("costObject.id");
        selector.add("costObject.number");
        selector.add("costObject.name");
        selector.add("costObject.calculateMode");
        selector.add("costObject.batchNumber");
        selector.add("costObject.isForbiden");
        selector.add("costObject.company.id");
        selector.add("costObject.StdProductID.id");
        selector.add("costObject.StdProductID.number");
        selector.add("costObject.StdProductID.name");
        view.setSelector(selector);
        ManufactureOrderCollection orderColl = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderCollection(view);
        if (orderColl.size() == 0) {
            throw new BOSException("\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u4e0d\u6ee1\u8db3\u6761\u4ef6\u3002");
        }
        ManufactureOrderInfo orderInfo = orderColl.get(0);
        if (orderInfo.getCostObject() != null) {
            CostObjectInfo costObjectInfo = orderInfo.getCostObject();
            if (costObjectInfo.getCompany() == null || !costObjectInfo.getCompany().getId().toString().equals(companyId)) {
                throw new BOSException("\u8be5\u8ba2\u5355\u4e0a\u7684\u6210\u672c\u5bf9\u8c61\u4e0d\u5b58\u5728\u6216\u975e\u672c\u8d22\u52a1\u7ec4\u7ec7\u4e0b\u7684\u6210\u672c\u5bf9\u8c61\u3002");
            }
            return costObjectInfo;
        }
        if (orderInfo.getMaterial() == null) {
            throw new BOSException("\u8be5\u8ba2\u5355\u672a\u6307\u5b9a\u7269\u6599\u3002");
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)orderInfo.getMaterial().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        view.setFilter(filter);
        selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("createCOByOrder");
        view.setSelector(selector);
        MaterialCompanyInfoCollection mcColl = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(view);
        if (mcColl.size() == 0) {
            throw new BOSException("\u8be5\u8ba2\u5355\u4e0a\u7684\u7269\u6599\u672a\u5b9a\u4e49\u8d22\u52a1\u8d44\u6599\u6216\u8d22\u52a1\u8d44\u6599\u672a\u5ba1\u6838\u3002");
        }
        MaterialCompanyInfoInfo mcInfo = mcColl.get(0);
        if (mcInfo.isCreateCOByOrder()) {
            if (BillBaseStatusEnum.RELEASED.equals((Object)orderInfo.getBaseStatus())) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orderInfo.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("orderID", (Object)orderInfo.getId().toString()));
                view.setFilter(filter);
                selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                selector.add("batchNumber");
                selector.add("isForbiden");
                selector.add("StdProductID.id");
                selector.add("StdProductID.number");
                selector.add("StdProductID.name");
                view.setSelector(selector);
                CostObjectCollection coColl = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(view);
                if (coColl.size() == 0) {
                    throw new BOSException("\u6839\u636e\u8ba2\u5355\u627e\u4e0d\u5230\u6210\u672c\u5bf9\u8c61\u3002");
                }
                return coColl.get(0);
            }
            throw new BOSException("\u8be5\u8ba2\u5355\u8fd8\u672a\u4e0b\u8fbe\uff0c\u65e0\u6cd5\u627e\u5230\u76f8\u5e94\u7684\u6210\u672c\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002");
        }
        MaterialInfo materialInfo = orderInfo.getMaterial();
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)Boolean.FALSE));
        HashSet<Integer> modes = new HashSet<Integer>();
        modes.add(1);
        modes.add(3);
        modes.add(4);
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", modes, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("StdProductID.id", (Object)materialInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)3));
        StringBuffer ksql = new StringBuffer();
        ksql.append("select ");
        ksql.append("    FParentID ");
        ksql.append("from T_BD_CostObjectEntry ");
        ksql.append("where FRelatedID = '" + materialInfo.getId().toString() + "'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ksql.toString(), CompareType.INNER));
        filter.setMaskString("#0 and #1 and #2 and (#3 or (#4 and #5))");
        view.setFilter(filter);
        selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("batchNumber");
        selector.add("calculateMode");
        selector.add("isForbiden");
        selector.add("StdProductID.id");
        selector.add("StdProductID.number");
        selector.add("StdProductID.name");
        view.setSelector(selector);
        CostObjectCollection coColl = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(view);
        if (coColl.size() == 0) {
            throw new BOSException("\u6839\u636e\u8ba2\u5355\u627e\u4e0d\u5230\u6210\u672c\u5bf9\u8c61\u3002");
        }
        CostObjectInfo costObjectInfo = coColl.get(0);
        if (CalculateModeEnum.BYCLASS.equals((Object)costObjectInfo.getCalculateMode()) || CalculateModeEnum.VARIET.equals((Object)costObjectInfo.getCalculateMode())) {
            return costObjectInfo;
        }
        if (CalculateModeEnum.BYBATCH.equals((Object)costObjectInfo.getCalculateMode())) {
            for (int i = 0; i < coColl.size(); ++i) {
                if ((coColl.get(i).getBatchNumber() != null || batch != null) && !coColl.get(i).getBatchNumber().equals(batch)) continue;
                return coColl.get(i);
            }
        }
        throw new BOSException("\u6839\u636e\u8ba2\u5355\u627e\u4e0d\u5230\u6210\u672c\u5bf9\u8c61\u3002");
    }

    public static CostObjectInfo getCostObjectByProduct(Context ctx, String companyId, String productNumber, String batch) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)Boolean.FALSE));
        HashSet<Integer> modes = new HashSet<Integer>();
        modes.add(1);
        modes.add(3);
        modes.add(4);
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", modes, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("StdProductID.number", (Object)productNumber));
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)3));
        StringBuffer ksql = new StringBuffer();
        ksql.append("select ");
        ksql.append("    FParentID ");
        ksql.append("from T_BD_CostObjectEntry coe join T_BD_Material m on m.FID = coe.FRelatedID ");
        ksql.append("where m.FNumber = '" + productNumber + "'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ksql.toString(), CompareType.INNER));
        filter.setMaskString("#0 and #1 and #2 and (#3 or (#4 and #5))");
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("batchNumber");
        selector.add("calculateMode");
        selector.add("isForbiden");
        view.setSelector(selector);
        CostObjectCollection coColl = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(view);
        if (coColl.size() == 0) {
            throw new BOSException("\u627e\u4e0d\u5230\u7269\u6599[" + productNumber + "]+\u6279\u6b21[" + (batch == null ? "" : batch) + "]\u5bf9\u5e94\u7684\u6210\u672c\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002");
        }
        CostObjectInfo costObjectInfo = coColl.get(0);
        if (CalculateModeEnum.BYCLASS.equals((Object)costObjectInfo.getCalculateMode()) || CalculateModeEnum.VARIET.equals((Object)costObjectInfo.getCalculateMode())) {
            return costObjectInfo;
        }
        if (CalculateModeEnum.BYBATCH.equals((Object)costObjectInfo.getCalculateMode())) {
            for (int i = 0; i < coColl.size(); ++i) {
                if ((coColl.get(i).getBatchNumber() != null || batch != null) && (coColl.get(i).getBatchNumber() == null || !coColl.get(i).getBatchNumber().equals(batch))) continue;
                return coColl.get(i);
            }
        }
        throw new BOSException("\u627e\u4e0d\u5230\u7269\u6599[" + productNumber + "]+\u6279\u6b21[" + (batch == null ? "" : batch) + "]\u5bf9\u5e94\u7684\u6210\u672c\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002");
    }
}

