/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.transmission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CostItemEnum;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoCollection;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.ExpenseTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.ActualHourInfo;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.transmission.app.NcmDataImportCache;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Locale;

public class NcmCacheDataImportUtil {
    protected NcmDataImportCache cache;
    private static final String[] GET_COST_OBJ_SOURCE = new String[]{"_BY_NUMBER", "_BY_ORDER", "_BY_MATERIAL_NUMBER"};
    private static final String[] BASE_DATA_TYPE = new String[]{"_BASE_CURRENCY"};
    private static final String RESOURCE_CLS_NAME = "com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource";

    public NcmCacheDataImportUtil(NcmDataImportCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("field : cache is null");
        }
        this.cache = cache;
    }

    public CostObjectInfo getCostObjectInfoByNumber(Context ctx, Object number, String companyId, String propertyLocalName, String msgOfNull) throws TaskExternalException {
        if (this.checkIsNull(number, msgOfNull)) {
            return null;
        }
        String key = number + this.toString(companyId) + GET_COST_OBJ_SOURCE[0];
        Object cacheObj = this.cache.getCostObjectInfo(key);
        if (!(cacheObj instanceof CostObjectInfo)) {
            if (cacheObj == null) {
                try {
                    cacheObj = NCMDataImportUtil.getCostObjectbyNumber(ctx, propertyLocalName, number.toString(), companyId);
                    this.cache.setCostObjectInfo(key, cacheObj);
                }
                catch (BOSException e) {
                    this.cache.setCostObjectInfo(key, e.getMessage());
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new TaskExternalException(cacheObj.toString());
            }
        }
        return (CostObjectInfo)cacheObj;
    }

    public CostObjectInfo getCostObjectInfoByOrder(Context ctx, Object orderNumber, String storageOrgNumber, String batch, String companyId, String msgOfNull) throws TaskExternalException {
        if (this.checkIsNull(orderNumber, msgOfNull)) {
            return null;
        }
        String key = orderNumber + this.toString(storageOrgNumber) + this.toString(batch) + this.toString(companyId) + GET_COST_OBJ_SOURCE[1];
        Object cacheObj = this.cache.getCostObjectInfo(key);
        if (!(cacheObj instanceof CostObjectInfo)) {
            if (cacheObj == null) {
                try {
                    cacheObj = NCMDataImportUtil.getCostObjectByOrder(ctx, companyId, storageOrgNumber, orderNumber.toString(), batch);
                    this.cache.setCostObjectInfo(key, cacheObj);
                }
                catch (BOSException e) {
                    this.cache.setCostObjectInfo(key, e.getMessage());
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                catch (EASBizException e) {
                    this.cache.setCostObjectInfo(key, e.getMessage());
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new TaskExternalException(cacheObj.toString());
            }
        }
        return (CostObjectInfo)cacheObj;
    }

    public CostObjectInfo getCostObjectInfoByMaterialNumber(Context ctx, Object materialNumber, String batch, String companyId, String msgOfNull) throws TaskExternalException {
        if (this.checkIsNull(materialNumber, msgOfNull)) {
            return null;
        }
        String key = materialNumber + this.toString(batch) + this.toString(companyId) + GET_COST_OBJ_SOURCE[2];
        Object cacheObj = this.cache.getCostObjectInfo(key);
        if (!(cacheObj instanceof CostObjectInfo)) {
            if (cacheObj == null) {
                try {
                    cacheObj = NCMDataImportUtil.getCostObjectByProduct(ctx, companyId, materialNumber.toString(), batch);
                    this.cache.setCostObjectInfo(key, cacheObj);
                }
                catch (BOSException e) {
                    this.cache.setCostObjectInfo(key, e.getMessage());
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new TaskExternalException(cacheObj.toString());
            }
        }
        return (CostObjectInfo)cacheObj;
    }

    public CostCenterOrgUnitInfo getCostCenterOrgUnitInfoByNumber(Context ctx, Object costCenterNumber, String propertyLocalName, String msgOfNull) throws TaskExternalException {
        if (this.checkIsNull(costCenterNumber, msgOfNull)) {
            return null;
        }
        String key = costCenterNumber.toString();
        Object cacheObj = this.cache.getCostCenterOrgUnitInfo(key);
        if (!(cacheObj instanceof CostCenterOrgUnitInfo)) {
            if (cacheObj == null) {
                try {
                    cacheObj = NCMDataImportUtil.getCostCenterbyNumber(ctx, propertyLocalName, costCenterNumber.toString());
                    this.cache.setCostCenterOrgUnitInfo(key, cacheObj);
                }
                catch (BOSException e) {
                    this.cache.setCostCenterOrgUnitInfo(key, e.getMessage());
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new TaskExternalException(cacheObj.toString());
            }
        }
        return (CostCenterOrgUnitInfo)cacheObj;
    }

    public void checkCostCenterByActualHourInfo(Context ctx, ActualHourInfo actualHour) throws TaskExternalException {
        String key = this.toString(actualHour.getCostCenter().getId().toString()) + this.toString(actualHour.getCompanyOrg().getId().toString());
        Object cacheObj = this.cache.getCostCenterOrgUnitCheckInfo(key);
        if (cacheObj == null) {
            try {
                NCMDataImportUtil.checkCostCenter(ctx, actualHour.getCostCenter(), actualHour.getCompanyOrg().getId().toString());
            }
            catch (BOSException e) {
                this.cache.setCostCenterOrgUnitCheckInfo(key, e.getMessage());
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.cache.setCostCenterOrgUnitCheckInfo(key, true);
        } else if (cacheObj instanceof String) {
            throw new TaskExternalException(cacheObj.toString());
        }
    }

    public ExpenseInfo getExpenseInfoByNumber(Context ctx, Object expenseNumber, String propertyLocalName, String msgOfNull) throws TaskExternalException {
        if (this.checkIsNull(expenseNumber, msgOfNull)) {
            return null;
        }
        String key = expenseNumber.toString();
        Object cacheObj = this.cache.getExpenseInfo(key);
        if (!(cacheObj instanceof ExpenseInfo)) {
            if (cacheObj == null) {
                try {
                    cacheObj = NCMDataImportUtil.getExpenseByNumber(ctx, propertyLocalName, expenseNumber.toString());
                    this.cache.setExpenseInfo(key, cacheObj);
                }
                catch (BOSException e) {
                    this.cache.setExpenseInfo(key, e.getMessage());
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new TaskExternalException(cacheObj.toString());
            }
        }
        return (ExpenseInfo)cacheObj;
    }

    public void checkExpenseCompanyInfo(Context ctx, String expenseId, String companyId, String expenseNumber, String companyNumber) throws TaskExternalException {
        String key = expenseId + companyId;
        Object cacheObj = this.cache.getExpenseCheckInfo(key);
        if (cacheObj == null) {
            String sql = "select 1 from T_Ncm_ExpenseCompanyInfo where FExpenseId = ? and FCompanyOrgUnitId = ?;";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{expenseId, companyId});
                if (!rowSet.next()) {
                    String msg = ResourceBase.getString((String)RESOURCE_CLS_NAME, (String)"EXPENSE_COMPANY_NOT_EXIST", (Locale)ctx.getLocale(), (Object[])new Object[]{expenseNumber, companyNumber});
                    this.cache.setExpenseCheckInfo(key, msg);
                    throw new TaskExternalException(msg);
                }
                this.cache.setExpenseCheckInfo(key, true);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        } else if (cacheObj instanceof String) {
            throw new TaskExternalException(cacheObj.toString());
        }
    }

    public void checkExpenseTypeIsOther(Context ctx, ExpenseInfo expense) throws TaskExternalException {
        if (expense == null || expense.getExpenseType() == null) {
            throw new IllegalArgumentException("expense or expenseType must not be null");
        }
        if (ExpenseTypeEnum.MATERIAL.equals((Object)expense.getExpenseType())) {
            throw new TaskExternalException(ResourceBase.getString((String)RESOURCE_CLS_NAME, (String)"140_ExpenseDataImport", (Locale)ctx.getLocale()));
        }
    }

    public CostItemInfo getCostItemInfoByNumber(Context ctx, Object costItemNumber, String propertyLocalName, String msgOfNull) throws TaskExternalException {
        if (this.checkIsNull(costItemNumber, msgOfNull)) {
            return null;
        }
        String key = costItemNumber.toString();
        Object cacheObj = this.cache.getCostItemInfo(key);
        if (!(cacheObj instanceof CostItemInfo)) {
            if (cacheObj == null) {
                try {
                    cacheObj = NCMDataImportUtil.getCostItemByNumber(ctx, propertyLocalName, costItemNumber.toString());
                    this.cache.setCostItemInfo(key, cacheObj);
                }
                catch (BOSException e) {
                    this.cache.setCostItemInfo(key, e.getMessage());
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new TaskExternalException(cacheObj.toString());
            }
        }
        return (CostItemInfo)cacheObj;
    }

    public CostItemInfo getCostItemInfoByExpenseCompanyInfo(Context ctx, String expenseId, String companyId) throws TaskExternalException {
        if (expenseId == null || companyId == null) {
            throw new IllegalArgumentException("expenseId or companyId must not be null");
        }
        String key = expenseId + companyId;
        Object cacheObj = this.cache.getCostItemInfo(key);
        if (!(cacheObj instanceof CostItemInfo)) {
            if (cacheObj == null) {
                try {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    SelectorItemCollection selector = viewInfo.getSelector();
                    selector.add("costItem.*");
                    selector.add("costItem.unit.*");
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("expense.id", (Object)expenseId, CompareType.EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId, CompareType.EQUALS));
                    viewInfo.setFilter(filterInfo);
                    ExpenseCompanyInfoCollection coll = ExpenseCompanyInfoFactory.getLocalInstance((Context)ctx).getExpenseCompanyInfoCollection(viewInfo);
                    if (!CollectionUtil.isEmpty((AbstractObjectCollection)coll) && coll.get(0) != null) {
                        cacheObj = coll.get(0).getCostItem();
                    }
                    this.cache.setCostItemInfo(key, cacheObj);
                }
                catch (BOSException e) {
                    this.cache.setCostItemInfo(key, e.getMessage());
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new TaskExternalException(cacheObj.toString());
            }
        }
        return (CostItemInfo)cacheObj;
    }

    public void checkCostItemTypeIsOther(Context ctx, CostItemInfo costItem) throws TaskExternalException {
        if (costItem == null || costItem.getItemType() == null) {
            throw new IllegalArgumentException("costItem or costItemType must not be null");
        }
        if (CostItemEnum.STUFF.equals((Object)costItem.getItemType())) {
            throw new TaskExternalException(ResourceBase.getString((String)RESOURCE_CLS_NAME, (String)"155_InitBalanceDataImport", (Locale)ctx.getLocale()));
        }
    }

    public void checkDataBaseDPermission(Context ctx, String companyCuId, String baseDataCuId, String baseDataId, String baseDataNumber, String baseDataLocalName) throws TaskExternalException {
        String baseDataBosType = BOSUuid.read((String)baseDataId).getType().toString();
        String key = baseDataId + companyCuId + "_CHECK_DP_INFO";
        Object cacheObj = this.cache.getBaseDataCheckInfo(key);
        if (cacheObj == null) {
            try {
                NCMDataImportUtil.checkDataBaseDPermission(ctx, companyCuId, baseDataCuId, baseDataBosType, baseDataId, baseDataNumber, baseDataLocalName);
            }
            catch (BOSException e) {
                this.cache.setBaseDataCheckInfo(key, e.getMessage());
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.cache.setBaseDataCheckInfo(key, true);
        } else if (cacheObj instanceof String) {
            throw new TaskExternalException(cacheObj.toString());
        }
    }

    public CurrencyInfo getBaseCurrencyInfoByCompanyId(Context ctx, String companyId) throws TaskExternalException {
        String key = companyId + BASE_DATA_TYPE[0];
        Object cacheObj = this.cache.getBaseDataInfo(key);
        if (!(cacheObj instanceof CurrencyInfo)) {
            if (cacheObj == null) {
                try {
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                    String baseCurrencyId = company.getBaseCurrency().getId().toString();
                    cacheObj = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrencyId));
                    this.cache.setBaseDataInfo(key, cacheObj);
                }
                catch (EASBizException e) {
                    this.cache.setBaseDataInfo(key, e.getMessage());
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                catch (BOSException e) {
                    this.cache.setBaseDataInfo(key, e.getMessage());
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new TaskExternalException(cacheObj.toString());
            }
        }
        return (CurrencyInfo)cacheObj;
    }

    public boolean checkIsNull(Object data, String msgOfNull) throws TaskExternalException {
        if (StringUtil.isEmpty((String)this.toString(data)) && msgOfNull != null) {
            throw new TaskExternalException(msgOfNull);
        }
        return StringUtil.isEmpty((String)this.toString(data));
    }

    public String toString(Object data) {
        return data == null ? "" : data.toString();
    }
}

