/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoCollection;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.IExpenseCompanyInfo;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.AllocatorFacadeFactory;
import com.kingdee.eas.ncm.bill.IAllocatorFacade;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.AllocStdSetModeByCCOEnum;
import com.kingdee.eas.ncm.common.AllocStdSetModeByPrdEnum;
import com.kingdee.eas.ncm.common.AllocStdSetModeByWIPEnum;
import com.kingdee.eas.ncm.common.INCMCommonFacade;
import com.kingdee.eas.ncm.common.NCMCommonFacadeFactory;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NCMUtils {
    private static Logger logger = Logger.getLogger((String)NCMUtils.class.getName());
    static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public static String getNcmCommonBillResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.ncm.common.NcmCommonBillResource", (String)key);
    }

    public static String getNcmCheckResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.ncm.cal.CheckResource", (String)key);
    }

    public static IObjectPK[] convertStringToObjectPK(String[] pkStrs) {
        if (pkStrs == null || pkStrs.length == 0) {
            return null;
        }
        int num = pkStrs.length;
        ObjectUuidPK[] objectPk = new ObjectUuidPK[num];
        for (int i = 0; i < num; ++i) {
            objectPk[i] = new ObjectUuidPK(pkStrs[i]);
        }
        return objectPk;
    }

    public static StringBuffer splitPK(IObjectPK[] pks) {
        return BDCMUtils.splitPK((Object[])pks);
    }

    public static StringBuffer splitPK(String[] pks) {
        return BDCMUtils.splitPK((Object[])pks);
    }

    public static StringBuffer splitPK(List ids) {
        return BDCMUtils.splitPK((Collection)ids);
    }

    public static void setDefaultPeriodForPeriod(KDBizPromptBox company, KDBizPromptBox period) {
        try {
            if (company.getValue() != null) {
                String companyId = ((CompanyOrgUnitInfo)company.getValue()).getId().toString();
                if (SystemStatusCtrolFactory.getRemoteInstance().isStart(1001, companyId)) {
                    period.setValue((Object)SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1001, companyId));
                    period.setEnabled(false);
                } else {
                    MsgBox.showInfo((String)(((CompanyOrgUnitInfo)company.getValue()).getName() + EASResource.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"19_NCMUtils")));
                    period.setValue(null);
                    SysUtil.abort();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public static PeriodInfo GetCurrentPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        ISystemStatusCtrol ibiz = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        return ibiz.getCacheCurrentPeriod(1001, companyId);
    }

    public static PeriodInfo GetStartPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        ISystemStatusCtrol ibiz = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        return ibiz.getStartPeriod(1001, companyId);
    }

    public static PeriodInfo getMaxPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        return NCMUtils.getMaxPeriod(company, null);
    }

    public static PeriodInfo getMaxPeriod(CompanyOrgUnitInfo company, PeriodInfo currentPeriod) throws EASBizException, BOSException {
        return NCMUtils.getMaxPeriod(null, company, currentPeriod);
    }

    public static PeriodInfo getMaxPeriod(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currentPeriod) throws EASBizException, BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("where periodType = '" + company.getAccountPeriodType().getId().toString() + "' \n");
        if (currentPeriod != null) {
            oql.append("and isadjustPeriod = 0 and periodYear >= " + currentPeriod.getPeriodYear() + " \n");
        }
        oql.append("order by periodYear desc, periodNumber desc \n");
        IPeriod period = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection coll = period.getPeriodCollection(oql.toString());
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public static boolean isStart(Context ctx, String companyId) throws EASBizException, BOSException {
        ISystemStatusCtrol ibiz = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        return ibiz.isStart(1001, companyId);
    }

    public static boolean isBig(PeriodInfo currentperiod, PeriodInfo period) {
        return NCMUtils.isBig(currentperiod.getPeriodYear(), currentperiod.getNumber(), period.getPeriodYear(), period.getNumber());
    }

    public static boolean isBig(int currenctyear, int currenctnumber, int selectyear, int selectnumber) {
        boolean falg = false;
        if (selectyear > currenctyear) {
            falg = true;
        } else if (selectyear == currenctyear && selectnumber >= currenctnumber) {
            falg = true;
        }
        return falg;
    }

    public static boolean isEquals(PeriodInfo currentperiod, PeriodInfo period) {
        if (currentperiod == null || period == null) {
            return false;
        }
        return NCMUtils.isEquals(currentperiod.getPeriodYear(), currentperiod.getNumber(), period.getPeriodYear(), period.getNumber());
    }

    public static boolean isEquals(int currenctyear, int currenctnumber, int selectyear, int selectnumber) {
        boolean falg = false;
        if (selectyear == currenctyear && selectnumber == currenctnumber) {
            falg = true;
        }
        return falg;
    }

    public static Timestamp getServerDate() throws Exception {
        INCMCommonFacade iCMBillCommonFacade = NCMCommonFacadeFactory.getRemoteInstance();
        return iCMBillCommonFacade.getServerDate();
    }

    public static Timestamp getClientDate(Context ctx) throws Exception {
        INCMCommonFacade iCMBillCommonFacade = NCMCommonFacadeFactory.getLocalInstance(ctx);
        return iCMBillCommonFacade.getServerDate();
    }

    public static Date getServerDate2() {
        try {
            return new Date(NCMUtils.getServerDate().getTime());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static CostItemInfo getCostItemByExpense(Context ctx, String expenseID, String companyID) throws BOSException {
        String oql;
        IExpenseCompanyInfo ieci = null;
        ieci = ctx == null ? ExpenseCompanyInfoFactory.getRemoteInstance() : ExpenseCompanyInfoFactory.getLocalInstance((Context)ctx);
        ExpenseCompanyInfoCollection ecColl = ieci.getExpenseCompanyInfoCollection(oql = "SELECT costItem.id, costItem.number, costItem.name, companyOrgUnit.id, expense.id  WHERE companyOrgUnit.id = '" + companyID + "' AND expense.id = '" + expenseID + "'");
        if (ecColl.size() > 0) {
            return ecColl.get(0).getCostItem();
        }
        return null;
    }

    public static void saveBOTRelation(Context ctx, Map idMap, String botmappingid) throws BOSException {
        if (idMap == null || idMap.isEmpty()) {
            return;
        }
        BOTRelationInfo relateInfo = null;
        String srcBillId = null;
        String destBillId = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        for (Map.Entry entry : idMap.entrySet()) {
            srcBillId = (String)entry.getKey();
            destBillId = (String)entry.getValue();
            relateInfo = new BOTRelationInfo();
            relateInfo.setSrcEntityID(BOSUuid.read((String)srcBillId).getType().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)destBillId).getType().toString());
            relateInfo.setSrcObjectID(srcBillId);
            relateInfo.setDestObjectID(destBillId);
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            if (botmappingid != null) {
                relateInfo.setBOTMappingID(botmappingid);
            }
            iBOTRelation.addnew(relateInfo);
        }
    }

    public static void saveBOTRelation(Context ctx, String srcBillId, String destBillId, String botmappingid) throws BOSException {
        if (srcBillId == null || destBillId == null || botmappingid == null) {
            return;
        }
        BOTRelationInfo relateInfo = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        relateInfo = new BOTRelationInfo();
        relateInfo.setSrcEntityID(BOSUuid.read((String)srcBillId).getType().toString());
        relateInfo.setDestEntityID(BOSUuid.read((String)destBillId).getType().toString());
        relateInfo.setSrcObjectID(srcBillId);
        relateInfo.setDestObjectID(destBillId);
        relateInfo.setDate(new Date());
        relateInfo.setOperatorID("unknown");
        relateInfo.setIsEffected(true);
        relateInfo.setType(0);
        relateInfo.setBOTMappingID(botmappingid);
        iBOTRelation.addnew(relateInfo);
    }

    public static IRowSet getMappingByCU(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys) throws SQLException, BOSException {
        IRowSet rs;
        String currentCuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        if (defineSys != null) {
            ArrayList<Object> paramsWithDefineSys = new ArrayList<Object>();
            paramsWithDefineSys.add(currentCuId);
            paramsWithDefineSys.add(sourceBillType);
            paramsWithDefineSys.add(targetBillType);
            paramsWithDefineSys.add(1);
            paramsWithDefineSys.add(10);
            paramsWithDefineSys.add(30);
            paramsWithDefineSys.add(defineSys.getValue());
            String sql = "SELECT MAPPING.FID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND MAPPING.FDESTENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) AND MAPPING.FDEFINESYS = ? ORDER BY MAPPING.FLASTUPDATETIME DESC";
            rs = NCMDbUtil.executeQuery(ctx, sql, paramsWithDefineSys.toArray());
            if (rs == null || rs.size() < 1) {
                sql = "SELECT MAPPING.FID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND MAPPING.FDESTENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) AND MAPPING.FDEFINESYS = ? ORDER BY MAPPING.FLASTUPDATETIME DESC";
                paramsWithDefineSys.remove(0);
                paramsWithDefineSys.add(0, "00000000-0000-0000-0000-000000000000CCE7AED4");
                rs = NCMDbUtil.executeQuery(ctx, sql, paramsWithDefineSys.toArray());
            }
        } else {
            ArrayList<Object> paramsWithoutDefineSys = new ArrayList<Object>();
            paramsWithoutDefineSys.add(currentCuId);
            paramsWithoutDefineSys.add(sourceBillType);
            paramsWithoutDefineSys.add(targetBillType);
            paramsWithoutDefineSys.add(1);
            paramsWithoutDefineSys.add(10);
            paramsWithoutDefineSys.add(30);
            String sql = "SELECT  MAPPING.FID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND MAPPING.FDESTENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) ORDER BY MAPPING.FLASTUPDATETIME DESC";
            rs = NCMDbUtil.executeQuery(ctx, sql, paramsWithoutDefineSys.toArray());
            if (rs == null || rs.size() < 1) {
                sql = "SELECT MAPPING.FID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND MAPPING.FDESTENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) ORDER BY MAPPING.FLASTUPDATETIME DESC";
                paramsWithoutDefineSys.remove(0);
                paramsWithoutDefineSys.add(0, "00000000-0000-0000-0000-000000000000CCE7AED4");
                rs = NCMDbUtil.executeQuery(ctx, sql, paramsWithoutDefineSys.toArray());
            }
        }
        return rs;
    }

    public static String getcalcHMSString(int timeSecond) {
        int timeInSecond;
        String resHour = EASResource.getString((String)"com.kingdee.eas.ncm.cal.CalResource", (String)"COST_HOUR");
        String resMinute = EASResource.getString((String)"com.kingdee.eas.ncm.cal.CalResource", (String)"COST_MINUTE");
        String resSecond = EASResource.getString((String)"com.kingdee.eas.ncm.cal.CalResource", (String)"COST_SECOND");
        int es = timeSecond / 1000;
        int hour = es / 3600;
        int timeInminute = es - hour * 3600;
        int minute = timeInminute / 60;
        int second = timeInSecond = timeInminute - minute * 60;
        return hour + " " + resHour + " " + minute + " " + resMinute + " " + second + " " + resSecond;
    }

    public static ReportFormatConditions formatConditions(String sumColunm) {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = null;
        for (int i = 0; i < NCMConst.reportColors20.length; ++i) {
            a = new Appearance();
            a.backColor = NCMConst.reportColors20[i];
            conditions.add(sumColunm, 1, (Object)new BigDecimal(i), a);
        }
        return conditions;
    }

    public static void analyzeTempTable(Context ctx, Connection conn, String tblName) throws BOSException {
        NCMDbUtil.analyzeTempTableByConnection(ctx, conn, tblName);
    }

    public static void analyzeTempTable(Context ctx, String tblName) throws BOSException {
        NCMDbUtil.analyzeTempTable(ctx, tblName);
    }

    public static void analyzeDBSystemTempTable(Context ctx, String tblName, Connection conn) throws BOSException {
        NCMDbUtil.analyzeTempTableByConnection(ctx, conn, tblName);
    }

    public static Set arrayPK2Set(IObjectPK[] pks) {
        HashSet<String> set = new HashSet<String>();
        int len = pks.length;
        for (int i = 0; i < len; ++i) {
            set.add(pks[i].toString());
        }
        return set;
    }

    public static void addEASLogForAlloc(Context ctx, String methodName, String instanceDetail, AllocSourceBillEnum allocSourceBill, AllocTypeEnum allocType, String companyId, boolean isSuccessed) {
        String type = allocType.getName().charAt(0) + allocType.getName().substring(1).toLowerCase();
        String oprationName = allocSourceBill.getName() + "Alloc_" + type;
        NCMUtils.addEASLogForAlloc(ctx, methodName, instanceDetail, oprationName, companyId, isSuccessed);
    }

    public static void addEASLogForAlloc(Context ctx, String methodName, String instanceDetail, String oprationName, String companyId, boolean isSuccessed) {
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)BOSObjectType.create((String)"DE8319CC"), null, (String)instanceDetail, (String)oprationName, (String)companyId);
        if (isSuccessed) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        }
    }

    public static boolean isMustCalCost(Context ctx, String companyId) {
        try {
            IParamControl iParamControl = null;
            iParamControl = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
            String value = iParamControl.getParamValue((IObjectPK)companyPK, "CM004");
            if (value != null && Boolean.valueOf(value).booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public static boolean isSetByComForCCO(Context ctx, String companyId) {
        return true;
    }

    public static boolean isSetByCCGroupForCCO(Context ctx, String companyId) {
        return true;
    }

    public static boolean isSetByComForPrd(Context ctx, String companyId) {
        return true;
    }

    public static boolean isSetByCCForPrd(Context ctx, String companyId) {
        return true;
    }

    public static KDBizPromptBox materialTreeDisplay(Object ownerUI, KDBizPromptBox promt, FilterInfo filter) throws BOSException {
        KDBizPromptBox dealedPromt = promt;
        dealedPromt.setQueryInfo("com.kingdee.eas.basedata.ncm.app.MaterialF7TreeQuery");
        MaterialF7TreeListSelector arg = new MaterialF7TreeListSelector(ownerUI, dealedPromt);
        arg.setBaseFilter(filter);
        dealedPromt.setSelector((KDPromptSelector)arg);
        return dealedPromt;
    }

    public static boolean isAllocWIPCounting(Context ctx, String companyId) {
        return NCMUtils.isSelectedUsed(ctx, companyId, "CM006");
    }

    public static String getMainOrgNullMsg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Purchase)) {
            return NCMUtils.getResource("PURORGNOTNULL");
        }
        if (orgType.equals((Object)OrgType.Storage)) {
            return NCMUtils.getResource("STORAGENOTNULL");
        }
        if (orgType.equals((Object)OrgType.Sale)) {
            return NCMUtils.getResource("SALEORGNOTNULL");
        }
        if (orgType.equals((Object)OrgType.Company)) {
            return NCMUtils.getResource("COMPANYORGNOTNULL");
        }
        return NCMUtils.getResource("MAINBIZORGISNULL");
    }

    public static String getResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)"com.kingdee.eas.ncm.common.CommonResource", (String)strKey);
    }

    public static boolean isQtyWipType(Context ctx, String companyId) {
        boolean result = true;
        try {
            IParamControl ipctr = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK comPk = new ObjectUuidPK(companyId);
            String value = ipctr.getParamValue((IObjectPK)comPk, "CM006");
            if (value != null && value.equals("1")) {
                result = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static boolean isSelectedUsed(Context ctx, String companyId, String sign) {
        try {
            IParamControl iParamControl = null;
            iParamControl = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
            String value = iParamControl.getParamValue((IObjectPK)companyPK, sign);
            if (value != null && Boolean.valueOf(value).booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public static boolean isIncludeCostAdjustData(Context ctx, String companyId) {
        boolean isIncludeCostAdjustData = false;
        try {
            IAllocatorFacade allocatorFacade = null;
            allocatorFacade = ctx == null ? AllocatorFacadeFactory.getRemoteInstance() : AllocatorFacadeFactory.getLocalInstance((Context)ctx);
            isIncludeCostAdjustData = allocatorFacade.isIncludeCostAdjustData(companyId);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return isIncludeCostAdjustData;
    }

    public static boolean isCostObjectOfBillRequired(Context ctx) throws BOSException, EASBizException {
        ICostObject iCostObject = null;
        iCostObject = ctx == null ? CostObjectFactory.getRemoteInstance() : CostObjectFactory.getLocalInstance((Context)ctx);
        return iCostObject.isCostObjectOfBillRequired(null);
    }

    public static boolean isCostObjectOfBillRequired(Context ctx, String companyID) throws BOSException, EASBizException {
        ICostObject iCostObject = null;
        iCostObject = ctx == null ? CostObjectFactory.getRemoteInstance() : CostObjectFactory.getLocalInstance((Context)ctx);
        return iCostObject.isCostObjectOfBillRequired(companyID);
    }

    public static int getCurrencyPrecision(Context ctx, String companyID) throws BOSException {
        int amtPrecision = 2;
        try {
            ICompanyOrgUnit ic = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo company = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
            amtPrecision = currency.getPrecision();
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return amtPrecision;
    }

    public static AllocStdSetModeByWIPEnum getAllocStdSetModeByWIP(Context ctx, String companyId) throws BOSException {
        IParamControl ipctr = null;
        ipctr = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        try {
            ObjectUuidPK com = new ObjectUuidPK(companyId);
            String st = ipctr.getParamValue((IObjectPK)com, "CM012");
            if (st == null) {
                return AllocStdSetModeByWIPEnum.CostItemAndCostObj;
            }
            if (st.compareTo("1") == 0) {
                return AllocStdSetModeByWIPEnum.CostItem;
            }
            if (st.compareTo("2") == 0) {
                return AllocStdSetModeByWIPEnum.CostItemAndCostCenter;
            }
            return AllocStdSetModeByWIPEnum.CostItemAndCostObj;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static AllocStdSetModeByCCOEnum getAllocStdSetModeByCCO(Context ctx, String companyId) throws BOSException {
        IParamControl ipctr = null;
        ipctr = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        try {
            ObjectUuidPK com = new ObjectUuidPK(companyId);
            String st = ipctr.getParamValue((IObjectPK)com, "CM015");
            if (st.compareTo("1") == 0) {
                return AllocStdSetModeByCCOEnum.SetByCom;
            }
            if (st.compareTo("0") == 0) {
                return AllocStdSetModeByCCOEnum.SetByCCGroup;
            }
            return AllocStdSetModeByCCOEnum.SetByCCGroup;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static AllocStdSetModeByPrdEnum getAllocStdSetModeByPrd(Context ctx, String companyId) throws BOSException {
        IParamControl ipctr = null;
        ipctr = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        try {
            ObjectUuidPK com = new ObjectUuidPK(companyId);
            String st = ipctr.getParamValue((IObjectPK)com, "CM016");
            if (st.compareTo("1") == 0) {
                return AllocStdSetModeByPrdEnum.SetByCom;
            }
            if (st.compareTo("0") == 0) {
                return AllocStdSetModeByPrdEnum.SetByCC;
            }
            return AllocStdSetModeByPrdEnum.SetByCC;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isWipCountResetWipQty(Context ctx, String companyId) throws BOSException {
        IParamControl ipctr = null;
        ipctr = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        try {
            ObjectUuidPK com = new ObjectUuidPK(companyId);
            String st = ipctr.getParamValue((IObjectPK)com, "CM017");
            if (st == null) {
                return false;
            }
            return st.trim().equalsIgnoreCase("true");
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isDoOutSourcCalc(Context ctx, String companyId) throws BOSException {
        IParamControl ipctr = null;
        ipctr = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        try {
            ObjectUuidPK com = new ObjectUuidPK(companyId);
            String st = ipctr.getParamValue((IObjectPK)com, "CM018");
            if (st == null) {
                return false;
            }
            return st.trim().equalsIgnoreCase("true");
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isAuditAfterSubmit(Context ctx, String companyId) throws BOSException {
        IParamControl ipctr = null;
        ipctr = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        try {
            ObjectUuidPK com = new ObjectUuidPK(companyId);
            String st = ipctr.getParamValue((IObjectPK)com, "CM014");
            if (st == null) {
                return false;
            }
            return st.trim().equalsIgnoreCase("true");
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isAlgebraicdAuxAlloc(Context ctx, String companyId) throws BOSException {
        try {
            IParamControl ipctr = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK comPk = new ObjectUuidPK(companyId);
            String value = ipctr.getParamValue((IObjectPK)comPk, "CM013");
            return value == null || value.equals("0");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isPlannedAuxAlloc(Context ctx, String companyId) throws BOSException {
        return !NCMUtils.isAlgebraicdAuxAlloc(ctx, companyId);
    }

    public static void resetFilterItemCompareValue(EntityViewInfo view, String propertyName, Object Value, CompareType type) {
        if (StringUtils.isEmpty((String)propertyName)) {
            return;
        }
        boolean hasProperty = false;
        FilterInfo filter = view.getFilter();
        if (filter != null && filter.getFilterItems().size() != 0) {
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo item = filter.getFilterItems().get(i);
                if (!propertyName.equals(item.getPropertyName())) continue;
                item.setCompareValue(Value);
                hasProperty = true;
                item.setCompareType(type);
            }
            if (!hasProperty) {
                filter.getFilterItems().add(new FilterItemInfo(propertyName, Value, type));
            }
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(propertyName, Value, type));
        }
    }

    public static Date getMinMonthDate(String date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateFormat.parse(date));
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getMaxMonthDate(String date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateFormat.parse(date));
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static BigDecimal getBigDecimal(Object obj) {
        BigDecimal value = null;
        if (obj == null) {
            return SysConstant.BIGZERO;
        }
        String s = obj.toString();
        if (s == null || s.trim().length() == 0) {
            return SysConstant.BIGZERO;
        }
        if (obj instanceof BigDecimal) {
            value = (BigDecimal)obj;
        } else if (NCMUtils.verifyIsNumber(s)) {
            value = new BigDecimal(s);
        } else {
            throw new IllegalArgumentException("object is not BigDecimal type!");
        }
        return value;
    }

    public static boolean verifyIsNumber(String value) {
        boolean result = true;
        try {
            new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            result = false;
        }
        return result;
    }

    public static String generateQuestionMark(int size) {
        if (size <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder("?");
        for (int i = 1; i < size; ++i) {
            builder.append(",?");
        }
        return builder.toString();
    }
}

