/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class OrgUnitUtils {
    private static Logger logger = Logger.getLogger((String)OrgUnitUtils.class.getName());
    public static final String ORG_DELEGATE_SALE_FI = "00000000-0000-0000-0000-0000000000050FE9F8B5";
    public static final String ORG_DELEGATE_PURCHARSE_FI = "00000000-0000-0000-0000-0000000000030FE9F8B5";
    public static final String ORG_DELEGATE_STORAGE_FI = "00000000-0000-0000-0000-0000000000070FE9F8B5";
    public static final String ORG_DELEGATE_ADMIN_FI = "00000000-0000-0000-0000-0000000000010FE9F8B5";
    public static final String ORG_DELEGATE_HR_FI = "00000000-0000-0000-0000-0000000000130FE9F8B5";
    public static final int ORG_OU_BIZUNIT = 1;
    public static final int ORG_OU_VIRTUAL = 2;
    public static final int ORG_OU_ALL = 3;
    public static final int ORG_OU_UP = 1;
    public static final int ORG_OU_DOWN = 2;

    public static final boolean isBizUnit(OrgUnitInfo orgUnit) throws EASBizException, BOSException {
        boolean bIsBizUnit = false;
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("isBizUnit"));
        if (orgUnit != null) {
            CompanyOrgUnitInfo company;
            if (orgUnit instanceof CompanyOrgUnitInfo && orgUnit.getId() != null && (company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnit.getId()), selectors)) != null) {
                bIsBizUnit = company.isIsBizUnit();
            }
            if (orgUnit instanceof StorageOrgUnitInfo && orgUnit.getId() != null && (company = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnit.getId()), selectors)) != null) {
                bIsBizUnit = company.isIsBizUnit();
            }
            if (orgUnit instanceof SaleOrgUnitInfo && orgUnit.getId() != null && (company = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnit.getId()), selectors)) != null) {
                bIsBizUnit = company.isIsBizUnit();
            }
            if (orgUnit instanceof PurchaseOrgUnitInfo && orgUnit.getId() != null && (company = PurchaseOrgUnitFactory.getRemoteInstance().getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnit.getId()), selectors)) != null) {
                bIsBizUnit = company.isIsBizUnit();
            }
            if (orgUnit instanceof HROrgUnitInfo && orgUnit.getId() != null && (company = HROrgUnitFactory.getRemoteInstance().getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnit.getId()), selectors)) != null) {
                bIsBizUnit = company.isIsBizUnit();
            }
        }
        return bIsBizUnit;
    }

    public static final CompanyOrgUnitInfo readCompanyOrgUnitInfo(Context ctx, OrgUnitInfo orgUnit) throws EASBizException, BOSException {
        return OrgUnitUtils.readCompanyOrgUnitInfo(ctx, orgUnit, false);
    }

    public static final CompanyOrgUnitInfo readFullCompanyOrgUnitInfo(Context ctx, OrgUnitInfo orgUnit) throws EASBizException, BOSException {
        return OrgUnitUtils.readCompanyOrgUnitInfo(ctx, orgUnit, true);
    }

    public static CompanyOrgUnitInfo readCompanyOrgUnitInfo(Context ctx, OrgUnitInfo orgUnit, boolean isFull) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        if (orgUnit != null) {
            if (orgUnit instanceof CompanyOrgUnitInfo && orgUnit.getId() != null) {
                company = (CompanyOrgUnitInfo)orgUnit;
                if (isFull && (company.getBaseCurrency() == null || company.getBaseCurrency().getName() == null || !company.getBaseCurrency().containsKey("precision") || company.getBaseExchangeTable() == null)) {
                    company = OrgUnitUtils.fullCompanyOrgUnitInfo(ctx, company.getId().toString());
                }
            } else {
                OrgUnitInfo ou = null;
                ou = ctx != null ? OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUint(OrgUnitUtils.getOrgRelationTypeByOU(orgUnit), orgUnit) : OrgUnitRelationFactory.getRemoteInstance().getToUint(OrgUnitUtils.getOrgRelationTypeByOU(orgUnit), orgUnit);
                if (ou != null && ou.getId() != null) {
                    if (isFull) {
                        company = OrgUnitUtils.fullCompanyOrgUnitInfo(ctx, ou.getId().toString());
                    } else {
                        company = new CompanyOrgUnitInfo();
                        company.setId(ou.getId());
                    }
                }
            }
        }
        return company;
    }

    public static CompanyOrgUnitInfo fullCompanyOrgUnitInfo(Context ctx, String Id) throws EASBizException, BOSException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("longNumber"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("baseCurrency.id"));
        selectors.add(new SelectorItemInfo("baseCurrency.name"));
        selectors.add(new SelectorItemInfo("baseCurrency.precision"));
        selectors.add(new SelectorItemInfo("baseExchangeTable.id"));
        ICompanyOrgUnit ie = null;
        ie = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return ie.getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(Id), selectors);
    }

    public static CompanyOrgUnitInfo getCurrentCompanyOrgUnitInfo(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        String id = (String)ctx.get((Object)"CurCompanyId");
        if (id != null && id.trim().length() != 0) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(id));
        }
        return company;
    }

    public static CompanyOrgUnitCollection getSuperiorCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf, SortType sortType) throws EASBizException, BOSException {
        return OrgUnitUtils.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, sortType, 1);
    }

    public static CompanyOrgUnitCollection getSuperiorCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf) throws EASBizException, BOSException {
        return OrgUnitUtils.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, SortType.ASCEND, 1);
    }

    public static CompanyOrgUnitCollection getChildrenCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf, SortType sortType) throws EASBizException, BOSException {
        return OrgUnitUtils.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, sortType, 2);
    }

    public static CompanyOrgUnitCollection getChildrenCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf) throws EASBizException, BOSException {
        return OrgUnitUtils.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, SortType.ASCEND, 2);
    }

    public static CompanyOrgUnitCollection getThreadCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf, SortType sortType, int upOrDown) throws EASBizException, BOSException {
        if (ctx == null || companyId == null || companyId.trim().length() == 0) {
            return null;
        }
        String sp = " \r\n";
        String locale = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("SELECT b.FID, b.FNumber, b.FName").append(locale).append(" As FCompanyName, b.FLongNumber, b.FBaseExgTableID, ").append(sp);
        strSQL.append("  b.FBaseCurrencyID, c.FName").append(locale).append(" As FCurrencyName, c.FPrecision").append(sp);
        strSQL.append("FROM T_ORG_Company a, T_ORG_Company b, T_BD_Currency c").append(sp);
        strSQL.append("WHERE a.FID = ? And b.FBaseCurrencyID = c.FID ").append(sp);
        if (isContainSelf) {
            if (2 == upOrDown) {
                strSQL.append("  And ( (SUBSTRING(b.FLongNumber, 0,LENGTH(a.FLongNumber) + 1) = a.FLongNumber || '!' AND b.FLevel > a.FLevel) OR ").append(sp);
                strSQL.append("  (b.FLongNumber = a.FLongNumber) ) ").append(sp);
            } else if (1 == upOrDown) {
                strSQL.append("  And ( (SUBSTRING(a.FLongNumber, 0,LENGTH(b.FLongNumber) + 1) = b.FLongNumber || '!' AND b.FLevel < a.FLevel) OR ").append(sp);
                strSQL.append("  (b.FLongNumber = a.FLongNumber) ) ").append(sp);
            }
        } else if (2 == upOrDown) {
            strSQL.append("  And (SUBSTRING(b.FLongNumber, 0,LENGTH(a.FLongNumber) + 1) = a.FLongNumber || '!' AND b.FLevel > a.FLevel) ").append(sp);
        } else if (1 == upOrDown) {
            strSQL.append("  And (SUBSTRING(a.FLongNumber, 0,LENGTH(b.FLongNumber) + 1) = b.FLongNumber || '!' AND b.FLevel < a.FLevel) ").append(sp);
        }
        if (isBizUnit == 1) {
            strSQL.append("  And b.FIsBizUnit = 1").append(sp);
        } else if (isBizUnit == 2) {
            strSQL.append("  And b.FIsBizUnit = 0").append(sp);
        }
        if (sortType == null || SortType.ASCEND.getName().equalsIgnoreCase(sortType.getName())) {
            strSQL.append("Order By b.FLongNumber ASC");
        } else {
            strSQL.append("Order By b.FLongNumber DESC");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{companyId});
        CompanyOrgUnitCollection companys = new CompanyOrgUnitCollection();
        if (rs != null) {
            try {
                CompanyOrgUnitInfo company = null;
                while (rs.next()) {
                    company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)rs.getString("FID")));
                    company.setNumber(rs.getString("FNumber"));
                    company.setName(rs.getString("FCompanyName"));
                    company.setLongNumber(rs.getString("FLongNumber"));
                    if (rs.getString("FBaseExgTableID") != null) {
                        ExchangeTableInfo exchangeTable = new ExchangeTableInfo();
                        exchangeTable.setId(BOSUuid.read((String)rs.getString("FBaseExgTableID")));
                        company.setBaseExchangeTable(exchangeTable);
                    }
                    CurrencyInfo baseCurrency = new CurrencyInfo();
                    baseCurrency.setId(BOSUuid.read((String)rs.getString("FBaseCurrencyID")));
                    baseCurrency.setName(rs.getString("FCurrencyName"));
                    baseCurrency.setPrecision(rs.getInt("FPrecision"));
                    company.setBaseCurrency(baseCurrency);
                    companys.add(company);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return companys;
    }

    public static DelegationPartsEnum getDelegationDirection(OrgType orgType, OrgType mainOrgType) {
        int iMainType = mainOrgType.getValue();
        int iDeleType = orgType.getValue();
        DelegationPartsEnum ret = DelegationPartsEnum.THE_TO_UNIT;
        switch (iMainType) {
            case 1: {
                ret = DelegationPartsEnum.THE_FROM_UNIT;
                break;
            }
            case 2: {
                if (iDeleType == 4) {
                    ret = DelegationPartsEnum.THE_FROM_UNIT;
                    break;
                }
                ret = DelegationPartsEnum.THE_TO_UNIT;
                break;
            }
            case 3: {
                if (iDeleType == 1) {
                    ret = DelegationPartsEnum.THE_TO_UNIT;
                    break;
                }
                ret = DelegationPartsEnum.THE_FROM_UNIT;
                break;
            }
            case 4: {
                ret = DelegationPartsEnum.THE_TO_UNIT;
                break;
            }
            default: {
                ret = DelegationPartsEnum.THE_TO_UNIT;
            }
        }
        return ret;
    }

    public static AdminOrgUnitInfo getAdminOrgUnitInfoByPerson(Context ctx, PersonInfo person) throws EASBizException, BOSException {
        AdminOrgUnitInfo adminOrg = null;
        if (person != null && person.getId() != null) {
            String personId = person.getId().toString();
            CtrlUnitInfo cu = null;
            cu = ctx != null ? ContextUtil.getCurrentCtrlUnit((Context)ctx) : SysContext.getSysContext().getCurrentCtrlUnit();
            StringBuffer oql = new StringBuffer();
            oql.append("Select id,position.adminOrgUnit.*  ").append("Where person.id = '").append(personId).append("' and isPrimary = 1 ").append("\tAnd position.adminOrgUnit.unitLayerType.id = '").append("00000000-0000-0000-0000-00000000000362824988").append("' ");
            if (cu != null) {
                oql.append("\tAnd position.adminOrgUnit.CU.id = '").append(cu.getString("id")).append("' ");
            }
            PositionMemberInfo positionMemInfo = PositionMemberFactory.getRemoteInstance().getPositionMemberInfo(oql.toString());
            adminOrg = positionMemInfo.getPosition().getAdminOrgUnit();
        }
        return adminOrg;
    }

    private static OrgTypeRelationInfo getOrgRelationTypeByOU(OrgUnitInfo orgUnit) {
        OrgTypeRelationInfo ri = null;
        if (orgUnit != null) {
            ri = new OrgTypeRelationInfo();
            if (orgUnit instanceof PurchaseOrgUnitInfo) {
                ri.setId(BOSUuid.read((String)ORG_DELEGATE_PURCHARSE_FI));
            } else if (orgUnit instanceof SaleOrgUnitInfo) {
                ri.setId(BOSUuid.read((String)ORG_DELEGATE_SALE_FI));
            } else if (orgUnit instanceof StorageOrgUnitInfo) {
                ri.setId(BOSUuid.read((String)ORG_DELEGATE_STORAGE_FI));
            } else if (orgUnit instanceof AdminOrgUnitInfo) {
                ri.setId(BOSUuid.read((String)ORG_DELEGATE_ADMIN_FI));
            } else if (orgUnit instanceof HROrgUnitInfo) {
                ri.setId(BOSUuid.read((String)ORG_DELEGATE_HR_FI));
            }
        }
        return ri;
    }

    public static CostCenterOrgUnitCollection getCostCentersByCompany(Context ctx, String companyId, boolean isBizUnit) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyId, 1, 5);
        if (ccColl == null || ccColl.isEmpty()) {
            return new CostCenterOrgUnitCollection();
        }
        HashSet<String> ccIDSet = new HashSet<String>();
        for (int i = 0; i < ccColl.size(); ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)isBizUnit));
        filter.getFilterItems().add(new FilterItemInfo("id", ccIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)1, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        return CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(evi);
    }

    public static CostCenterOrgUnitCollection getChildrenCostCentersByCompany(Context ctx, String companyId, int isBizUnit, SortType sortType) throws BOSException {
        CostCenterOrgUnitCollection costCenters = new CostCenterOrgUnitCollection();
        StringBuffer kSQL = new StringBuffer();
        kSQL.append(" select cc.FID         as ccID,");
        kSQL.append("        cc.FNumber      as ccNumber,");
        kSQL.append("        cc.FLongNumber  as ccLongNumber,");
        kSQL.append("        cc.FName_" + ctx.getLocale() + "    as ccName");
        kSQL.append("   from T_ORG_CostCenter cc, ");
        kSQL.append("        T_ORG_Company cp");
        kSQL.append("  where cp.fid = ?");
        kSQL.append("    and ( cc.fid = ? ");
        kSQL.append("           or ");
        kSQL.append("          (SUBSTRING(cc.FLongNumber, 0, LENGTH(cp.FLongNumber) + 1) = cp.FLongNumber || '!')");
        kSQL.append("         )");
        if (isBizUnit == 1) {
            kSQL.append("    and cc.FIsBizUnit = 1 ");
        } else if (isBizUnit == 2) {
            kSQL.append("    and cc.FIsBizUnit = 0 ");
        }
        if (sortType == null || SortType.ASCEND.getName().equalsIgnoreCase(sortType.getName())) {
            kSQL.append(" Order By ccLongNumber ASC ");
        } else {
            kSQL.append(" Order By ccLongNumber DESC ");
        }
        IRowSet rst = null;
        try {
            rst = DbUtil.executeQuery((Context)ctx, (String)kSQL.toString(), (Object[])new String[]{companyId, companyId});
            while (rst.next()) {
                String costCenterId = rst.getString("ccID");
                String costCenterNumber = rst.getString("ccNumber");
                String costCenterName = rst.getString("ccName");
                CostCenterOrgUnitInfo ccInfo = new CostCenterOrgUnitInfo();
                ccInfo.setId(BOSUuid.read((String)costCenterId));
                ccInfo.setNumber(costCenterNumber);
                ccInfo.setName(costCenterName);
                costCenters.add(ccInfo);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return costCenters;
    }
}

