/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.ncm.common.log.app.NCMSQLLogUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class NCMDbBatchUtil {
    private static Logger logger = Logger.getLogger((String)NCMDbBatchUtil.class.getName());
    public static final int PARAM_SIZE = 200;
    private static final int BATCH_EXE_COUNTER = 100;
    private static final Object NOT_FOUND_VALUE = "#";

    private static String buildLogString(String sql, List params) {
        StringBuffer log = new StringBuffer();
        log.append("\r\n----NCM Exception Start----");
        log.append("\r\nThread ID:" + Thread.currentThread().toString());
        log.append("\r\nSQL is:" + sql);
        StringBuffer sb = new StringBuffer();
        Object[] paramArray = null;
        for (int i = 0; i < params.size(); ++i) {
            paramArray = (Object[])params.get(i);
            StringBuffer tmp = new StringBuffer();
            for (int j = 0; j < paramArray.length; ++j) {
                tmp.append(paramArray[j]).append(",");
            }
            sb.append(tmp.substring(0, tmp.length() - 1)).append(";\r\n");
        }
        log.append("\r\nParam is:").append(sb.toString());
        log.append("\r\n----NCM Exception End----");
        return log.toString();
    }

    public static int[] arrayCopyAndAdd(int[] resultNum, int[] result) {
        int[] temp = new int[result.length + resultNum.length];
        System.arraycopy(result, 0, temp, 0, result.length);
        System.arraycopy(resultNum, 0, temp, result.length, resultNum.length);
        return (int[])temp.clone();
    }

    public static void batchExecuteQuery(Context ctx, String sql, List params, QueryCallbackHandler handler) throws BOSException {
        if (StringUtil.isEmptyString((String)sql) || handler == null || params == null || params.isEmpty()) {
            return;
        }
        Object obj = params.get(0);
        if (!(obj instanceof Object[])) {
            throw new IllegalArgumentException("the params.get(i) must be a Object[] type!");
        }
        if (((Object[])obj).length == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int columnSize = ((Object[])obj).length;
        int size = params.size() * columnSize;
        int count = (params.size() - 1) / 200 + 1;
        int pos = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < count; ++i) {
                int start = handler.beforeBatchBindParams(ps);
                for (int j = 0; j < 200; ++j) {
                    int k = 0;
                    while (k < columnSize) {
                        if (pos < size) {
                            Object param = params.get(i * 200 + j);
                            ps.setObject(start + j * columnSize + k + 1, ((Object[])param)[k]);
                        } else {
                            ps.setObject(start + j * columnSize + k + 1, NOT_FOUND_VALUE);
                        }
                        ++k;
                        ++pos;
                    }
                }
                long timeStart = System.currentTimeMillis();
                rs = ps.executeQuery();
                int number = rs.getFetchSize();
                long timeEnd = System.currentTimeMillis();
                NCMSQLLogUtils.writeLog(ctx, conn, timeStart, timeEnd, sql, params.toArray(), number);
                while (rs.next()) {
                    handler.processRow(rs);
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)NCMDbBatchUtil.buildLogString(sql, params), (Throwable)ex);
                throw new BOSException("\r\nSQL is: " + sql, (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
    }

    public static void batchExecuteUpdate(Context ctx, String sql, List params, UpdateCallbackHandler handler) throws BOSException {
        if (StringUtil.isEmptyString((String)sql) || handler == null || params == null || params.isEmpty()) {
            return;
        }
        Object obj = params.get(0);
        if (!(obj instanceof Object[])) {
            throw new IllegalArgumentException("the params.get(i) must be a Object[] type!");
        }
        if (((Object[])obj).length == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        int columnSize = ((Object[])obj).length;
        int size = params.size() * columnSize;
        int count = (params.size() - 1) / 200 + 1;
        int pos = 0;
        long startTime = 0L;
        long timeOffset = 0L;
        int[] resultNum = new int[]{0};
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            int batchCounter = 0;
            for (int i = 0; i < count; ++i) {
                int start = handler.beforeBatchBindParams(ps);
                for (int j = 0; j < 200; ++j) {
                    int k = 0;
                    while (k < columnSize) {
                        if (pos < size) {
                            Object param = params.get(i * 200 + j);
                            ps.setObject(start + j * columnSize + k + 1, ((Object[])param)[k]);
                        } else {
                            ps.setObject(start + j * columnSize + k + 1, NOT_FOUND_VALUE);
                        }
                        ++k;
                        ++pos;
                    }
                }
                ps.addBatch();
                if (++batchCounter < 100) continue;
                long timeFrom = System.currentTimeMillis();
                if (startTime <= 0L) {
                    startTime = timeFrom;
                }
                int[] result = ps.executeBatch();
                long timeTo = System.currentTimeMillis();
                timeOffset += timeTo - timeFrom;
                resultNum = NCMDbBatchUtil.arrayCopyAndAdd(resultNum, result);
                batchCounter = 0;
            }
            if (batchCounter != 0) {
                long timeFrom = System.currentTimeMillis();
                if (startTime <= 0L) {
                    startTime = timeFrom;
                }
                int[] result = ps.executeBatch();
                long timeTo = System.currentTimeMillis();
                timeOffset += timeTo - timeFrom;
                resultNum = NCMDbBatchUtil.arrayCopyAndAdd(resultNum, result);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)NCMDbBatchUtil.buildLogString(sql, params), (Throwable)ex);
                throw new BOSException("\r\nSQL is: " + sql, (Throwable)ex);
            }
            catch (Throwable throwable) {
                NCMSQLLogUtils.writeLog(ctx, conn, startTime, startTime + timeOffset, new String[]{sql}, params, resultNum);
                SQLUtils.cleanup((Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        NCMSQLLogUtils.writeLog(ctx, conn, startTime, startTime + timeOffset, new String[]{sql}, params, resultNum);
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static interface UpdateCallbackHandler {
        public int beforeBatchBindParams(PreparedStatement var1) throws SQLException;
    }

    public static interface QueryCallbackHandler {
        public int beforeBatchBindParams(PreparedStatement var1) throws SQLException;

        public void processRow(ResultSet var1) throws SQLException;
    }
}

