/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.ncm.common.log.app.NCMSQLLogUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.SerializableByteArrayInputStream;
import com.kingdee.util.db.SQLUtils;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NCMDbUtil {
    private static Logger logger = Logger.getLogger((String)NCMDbUtil.class.getName());
    private static String CONFIG_EXCEPTION = "CONFIG_EXCEPTION";
    private static final int MAX_DATA_ROW = 1000;
    public static final String ConnectionKey = "ConnectionKey";
    public static final String paramKey_tempTablePool = "tempTablePool";

    private static String buildLogString(String sql, Object[] params) {
        StringBuffer log = new StringBuffer();
        log.append("\r\n----NCM Exception Start----");
        log.append("\r\nThread ID:" + Thread.currentThread().toString());
        log.append("\r\nSQL is: " + sql);
        StringBuffer sb = new StringBuffer("");
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                sb.append(params[i]).append(",");
            }
            log.append("\r\nParam is:" + sb.substring(0, sb.length() - 1));
        }
        log.append("\r\n----NCM Exception End----");
        return log.toString();
    }

    private static String buildLogString2(String sql, List params) {
        StringBuffer log = new StringBuffer();
        log.append("\r\n----NCM Exception Start----");
        log.append("\r\nThread ID:" + Thread.currentThread().toString());
        log.append("\r\nSQL is:" + sql);
        StringBuffer sb = new StringBuffer();
        Object[] paramArray = null;
        for (int i = 0; i < params.size(); ++i) {
            paramArray = (Object[])params.get(i);
            StringBuffer tmp = new StringBuffer();
            for (int j = 0; j < paramArray.length; ++j) {
                tmp.append(paramArray[j]).append(",");
            }
            sb.append(tmp.substring(0, tmp.length() - 1)).append(";\r\n");
        }
        log.append("\r\nParam is:").append(sb.toString());
        log.append("\r\n----NCM Exception End----");
        return log.toString();
    }

    private static String buildLogString3(String sql, Map[] params) {
        StringBuffer log = new StringBuffer();
        log.append("\r\n----NCM Exception Start----");
        log.append("\r\nThread ID:" + Thread.currentThread().toString());
        log.append("\r\nSQL is:" + sql);
        StringBuffer sb = new StringBuffer();
        Map param = null;
        for (int i = 0; i < params.length; ++i) {
            param = params[i];
            StringBuffer tmp = new StringBuffer();
            for (Map.Entry entry : param.entrySet()) {
                String val = null;
                val = entry.getValue() == null ? null : entry.getValue().toString();
                tmp.append(val).append(",");
            }
            sb.append(tmp.substring(0, tmp.length() - 1)).append(";\r\n");
        }
        log.append("\r\nParam is:").append(sb.toString());
        log.append("\r\n----NCM Exception End----");
        return log.toString();
    }

    private static String buildLogString4(String[] sql) {
        StringBuffer log = new StringBuffer();
        log.append("\r\n----NCM Exception Start----");
        log.append("\r\nThread ID:" + Thread.currentThread().toString());
        for (int i = 0; i < sql.length && i <= 20; ++i) {
            if (sql[i].trim().length() <= 0) continue;
            log.append("\r\nSQL" + i + " is:" + sql[i]);
        }
        if (sql.length > 20) {
            log.append("\r\nSQL is too mutch. All sql qty: ").append(sql.length);
        }
        log.append("\r\n----NCM Exception End----");
        return log.toString();
    }

    public static int[] arrayCopyAndAdd(int[] resultNum, int[] result) {
        int[] temp = new int[result.length + resultNum.length];
        System.arraycopy(result, 0, temp, 0, result.length);
        System.arraycopy(resultNum, 0, temp, result.length, resultNum.length);
        return (int[])temp.clone();
    }

    public static IRowSet executeQueryNoTx(Context ctx, String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        block8: {
            ResultSet rs;
            Statement statement;
            block7: {
                Connection conn = null;
                statement = null;
                rs = null;
                boolean isNewGetConnection = false;
                try {
                    conn = (Connection)ctx.get((Object)ConnectionKey);
                    if (conn == null) {
                        isNewGetConnection = true;
                        conn = EJBFactory.getQueryConnection((Context)ctx);
                    }
                    statement = conn.createStatement();
                    long timeFrom = System.currentTimeMillis();
                    rs = statement.executeQuery(sql);
                    long timeTo = System.currentTimeMillis();
                    NCMSQLLogUtils.writeLog(ctx, conn, timeFrom, timeTo, sql, null, rs.getFetchSize());
                    JdbcRowSet rowset = new JdbcRowSet();
                    rowset.populate(rs);
                    jdbcRowSet = rowset;
                    if (!isNewGetConnection) break block7;
                }
                catch (SQLException exc) {
                    try {
                        logger.error((Object)NCMDbUtil.buildLogString(sql, null), (Throwable)exc);
                        throw new BOSException("\r\nSQL is: " + sql, (Throwable)exc);
                    }
                    catch (Throwable throwable) {
                        if (isNewGetConnection) {
                            SQLUtils.cleanup(rs, statement, (Connection)conn);
                        } else {
                            SQLUtils.cleanup(rs, statement);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
                break block8;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
        }
        return jdbcRowSet;
    }

    public static IRowSet executeQueryNoTx(Context ctx, String sql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        block9: {
            ResultSet rs;
            PreparedStatement ps;
            block8: {
                Connection conn = null;
                ps = null;
                rs = null;
                boolean isNewGetConnection = false;
                try {
                    conn = (Connection)ctx.get((Object)ConnectionKey);
                    if (conn == null) {
                        isNewGetConnection = true;
                        conn = EJBFactory.getQueryConnection((Context)ctx);
                    }
                    ps = conn.prepareStatement(sql);
                    for (int i = 0; i < params.length; ++i) {
                        ps.setObject(i + 1, params[i]);
                    }
                    long timeFrom = System.currentTimeMillis();
                    rs = ps.executeQuery();
                    long timeTo = System.currentTimeMillis();
                    NCMSQLLogUtils.writeLog(ctx, conn, timeFrom, timeTo, sql, null, rs.getFetchSize());
                    JdbcRowSet rowset = new JdbcRowSet();
                    rowset.populate(rs);
                    jdbcRowSet = rowset;
                    if (!isNewGetConnection) break block8;
                }
                catch (SQLException exc) {
                    try {
                        logger.error((Object)NCMDbUtil.buildLogString(sql, params), (Throwable)exc);
                        throw new BOSException("\r\nSQL is:" + sql, (Throwable)exc);
                    }
                    catch (Throwable throwable) {
                        if (isNewGetConnection) {
                            SQLUtils.cleanup(rs, ps, (Connection)conn);
                        } else {
                            SQLUtils.cleanup(rs, ps);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
                break block9;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        }
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        block8: {
            ResultSet rs;
            Statement statement;
            block7: {
                Connection conn = null;
                statement = null;
                rs = null;
                boolean isNewGetConnection = false;
                try {
                    conn = (Connection)ctx.get((Object)ConnectionKey);
                    if (conn == null) {
                        isNewGetConnection = true;
                        conn = EJBFactory.getConnection((Context)ctx);
                    }
                    statement = conn.createStatement();
                    long timeFrom = System.currentTimeMillis();
                    rs = statement.executeQuery(sql);
                    long timeTo = System.currentTimeMillis();
                    NCMSQLLogUtils.writeLog(ctx, conn, timeFrom, timeTo, sql, null, rs.getFetchSize());
                    JdbcRowSet rowset = new JdbcRowSet();
                    rowset.populate(rs);
                    jdbcRowSet = rowset;
                    if (!isNewGetConnection) break block7;
                }
                catch (SQLException exc) {
                    try {
                        logger.error((Object)NCMDbUtil.buildLogString(sql, null), (Throwable)exc);
                        throw new BOSException("\r\nSQL is:" + sql, (Throwable)exc);
                    }
                    catch (Throwable throwable) {
                        if (isNewGetConnection) {
                            SQLUtils.cleanup(rs, statement, (Connection)conn);
                        } else {
                            SQLUtils.cleanup(rs, statement);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
                break block8;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
        }
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(Context ctx, String sql, int start, int rows) throws BOSException {
        JdbcRowSet jdbcRowSet;
        block8: {
            ResultSet rs;
            Statement statement;
            block7: {
                Connection conn = null;
                statement = null;
                rs = null;
                boolean isNewGetConnection = false;
                try {
                    conn = (Connection)ctx.get((Object)ConnectionKey);
                    if (conn == null) {
                        isNewGetConnection = true;
                        conn = EJBFactory.getConnection((Context)ctx);
                    }
                    statement = conn.createStatement();
                    long timeFrom = System.currentTimeMillis();
                    rs = statement.executeQuery(sql);
                    long timeTo = System.currentTimeMillis();
                    NCMSQLLogUtils.writeLog(ctx, conn, timeFrom, timeTo, sql, null, rs.getFetchSize());
                    JdbcRowSet rowset = new JdbcRowSet();
                    rowset.populate(rs, start, rows, true);
                    jdbcRowSet = rowset;
                    if (!isNewGetConnection) break block7;
                }
                catch (SQLException exc) {
                    try {
                        logger.error((Object)NCMDbUtil.buildLogString(sql, null), (Throwable)exc);
                        throw new BOSException("\r\nSQL is:" + sql, (Throwable)exc);
                    }
                    catch (Throwable throwable) {
                        if (isNewGetConnection) {
                            SQLUtils.cleanup(rs, statement, (Connection)conn);
                        } else {
                            SQLUtils.cleanup(rs, statement);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
                break block8;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
        }
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        block9: {
            ResultSet rs;
            PreparedStatement ps;
            block8: {
                Connection conn = null;
                ps = null;
                rs = null;
                boolean isNewGetConnection = false;
                try {
                    conn = (Connection)ctx.get((Object)ConnectionKey);
                    if (conn == null) {
                        isNewGetConnection = true;
                        conn = EJBFactory.getConnection((Context)ctx);
                    }
                    ps = conn.prepareStatement(sql);
                    for (int i = 0; i < params.length; ++i) {
                        ps.setObject(i + 1, params[i]);
                    }
                    long timeFrom = System.currentTimeMillis();
                    rs = ps.executeQuery();
                    long timeTo = System.currentTimeMillis();
                    NCMSQLLogUtils.writeLog(ctx, conn, timeFrom, timeTo, sql, params, rs.getFetchSize());
                    JdbcRowSet rowset = new JdbcRowSet();
                    rowset.populate(rs);
                    jdbcRowSet = rowset;
                    if (!isNewGetConnection) break block8;
                }
                catch (SQLException exc) {
                    try {
                        logger.error((Object)NCMDbUtil.buildLogString(sql, params), (Throwable)exc);
                        throw new BOSException("\r\nSQL is:" + sql, (Throwable)exc);
                    }
                    catch (Throwable throwable) {
                        if (isNewGetConnection) {
                            SQLUtils.cleanup(rs, ps, (Connection)conn);
                        } else {
                            SQLUtils.cleanup(rs, ps);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
                break block9;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        }
        return jdbcRowSet;
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        block8: {
            Statement statement;
            block7: {
                Connection conn = null;
                statement = null;
                boolean isNewGetConnection = false;
                try {
                    conn = (Connection)ctx.get((Object)ConnectionKey);
                    if (conn == null) {
                        isNewGetConnection = true;
                        conn = EJBFactory.getConnection((Context)ctx);
                    }
                    statement = conn.createStatement();
                    long timeFrom = System.currentTimeMillis();
                    statement.execute(sql);
                    long timeTo = System.currentTimeMillis();
                    NCMSQLLogUtils.writeLog(ctx, conn, timeFrom, timeTo, sql, null, 0);
                    if (!isNewGetConnection) break block7;
                }
                catch (SQLException exc) {
                    try {
                        logger.error((Object)NCMDbUtil.buildLogString(sql, null), (Throwable)exc);
                        throw new BOSException("\r\nSQL is:" + sql, (Throwable)exc);
                    }
                    catch (Throwable throwable) {
                        if (isNewGetConnection) {
                            SQLUtils.cleanup(statement, (Connection)conn);
                        } else {
                            SQLUtils.cleanup(statement);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)statement, (Connection)conn);
                break block8;
            }
            SQLUtils.cleanup((Statement)statement);
        }
    }

    public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
        block9: {
            PreparedStatement ps;
            block8: {
                Connection conn = null;
                ps = null;
                boolean isNewGetConnection = false;
                try {
                    conn = (Connection)ctx.get((Object)ConnectionKey);
                    if (conn == null) {
                        isNewGetConnection = true;
                        conn = EJBFactory.getConnection((Context)ctx);
                    }
                    ps = conn.prepareStatement(sql);
                    for (int i = 0; i < params.length; ++i) {
                        ps.setObject(i + 1, params[i]);
                    }
                    long timeFrom = System.currentTimeMillis();
                    ps.execute();
                    long timeTo = System.currentTimeMillis();
                    NCMSQLLogUtils.writeLog(ctx, conn, timeFrom, timeTo, sql, params, 0);
                    if (!isNewGetConnection) break block8;
                }
                catch (SQLException exc) {
                    try {
                        logger.error((Object)NCMDbUtil.buildLogString(sql, params), (Throwable)exc);
                        throw new BOSException("\r\nSQL is:" + sql, (Throwable)exc);
                    }
                    catch (Throwable throwable) {
                        if (isNewGetConnection) {
                            SQLUtils.cleanup(ps, (Connection)conn);
                        } else {
                            SQLUtils.cleanup(ps);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)ps, (Connection)conn);
                break block9;
            }
            SQLUtils.cleanup((Statement)ps);
        }
    }

    public static void prepareVarcharParam(PreparedStatement stmt, int index, String param) throws SQLException {
        byte[] value = param.getBytes();
        stmt.setAsciiStream(index, (InputStream)new SerializableByteArrayInputStream(value), value.length);
    }

    public static void executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        int[] resultNum;
        long timeOffset;
        long startTime;
        boolean isNewGetConnection;
        PreparedStatement ps;
        Connection conn;
        block15: {
            conn = null;
            ps = null;
            isNewGetConnection = false;
            startTime = 0L;
            timeOffset = 0L;
            resultNum = new int[]{0};
            try {
                conn = (Connection)ctx.get((Object)ConnectionKey);
                if (conn == null) {
                    isNewGetConnection = true;
                    conn = EJBFactory.getConnection((Context)ctx);
                }
                ps = conn.prepareStatement(sql);
                Object[] params = null;
                int k = 1;
                boolean flag = false;
                for (int i = 0; i < paramsList.size(); ++i) {
                    params = (Object[])paramsList.get(i);
                    for (int j = 0; j < params.length; ++j) {
                        if (params[j] != null) {
                            ps.setObject(j + 1, params[j]);
                            continue;
                        }
                        ps.setNull(j + 1, 12);
                    }
                    ps.addBatch();
                    if (i == k * 1000) {
                        flag = true;
                    }
                    if (i <= k * 1000 || !flag) continue;
                    long timeFrom = System.currentTimeMillis();
                    if (startTime <= 0L) {
                        startTime = timeFrom;
                    }
                    int[] result = ps.executeBatch();
                    long timeTo = System.currentTimeMillis();
                    timeOffset += timeTo - timeFrom;
                    resultNum = NCMDbUtil.arrayCopyAndAdd(resultNum, result);
                    ++k;
                    flag = false;
                    ps.clearBatch();
                }
                if (flag) break block15;
                long timeFrom = System.currentTimeMillis();
                if (startTime <= 0L) {
                    startTime = timeFrom;
                }
                int[] result = ps.executeBatch();
                long timeTo = System.currentTimeMillis();
                timeOffset += timeTo - timeFrom;
                resultNum = NCMDbUtil.arrayCopyAndAdd(resultNum, result);
            }
            catch (SQLException exc) {
                try {
                    logger.error((Object)NCMDbUtil.buildLogString2(sql, paramsList), (Throwable)exc);
                    throw new BOSException("\r\nSQL is: " + sql, (Throwable)exc);
                }
                catch (Throwable throwable) {
                    NCMSQLLogUtils.writeLog(ctx, conn, startTime, startTime + timeOffset, new String[]{sql}, paramsList, resultNum);
                    if (isNewGetConnection) {
                        SQLUtils.cleanup((Statement)ps, (Connection)conn);
                    } else {
                        SQLUtils.cleanup((Statement)ps);
                    }
                    throw throwable;
                }
            }
        }
        NCMSQLLogUtils.writeLog(ctx, conn, startTime, startTime + timeOffset, new String[]{sql}, paramsList, resultNum);
        if (isNewGetConnection) {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        } else {
            SQLUtils.cleanup((Statement)ps);
        }
    }

    public static void BatchSqlExecute(Context ctx, String sql, Map[] paramList) throws SQLDataException, SQLException {
        Connection conn = EJBFactory.getConnection((Context)ctx);
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            Map param = null;
            for (int i = 0; i < paramList.length; ++i) {
                param = paramList[i];
                for (Map.Entry entry : param.entrySet()) {
                    int idx = Integer.parseInt(entry.getKey().toString());
                    String val = null;
                    val = entry.getValue() == null ? null : entry.getValue().toString();
                    pstmt.setString(idx, val);
                }
                pstmt.addBatch();
            }
            long timeFrom = System.currentTimeMillis();
            int[] rowNum = pstmt.executeBatch();
            long timeTo = System.currentTimeMillis();
            NCMSQLLogUtils.writeLog(ctx, conn, timeFrom, timeTo, sql, paramList, rowNum);
        }
        catch (SQLException e) {
            logger.error((Object)NCMDbUtil.buildLogString3(sql, paramList), (Throwable)e);
            throw new SQLException("\r\nSQL is: " + sql);
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    public static void BatchSqlExecute(Context ctx, String sql) throws BOSException {
        NCMDbUtil.BatchSqlExecute(ctx, sql, ";");
    }

    public static void BatchSqlExecute(Context ctx, String sql, String separator) throws BOSException {
        String[] list = sql.split(separator);
        NCMDbUtil.BatchSqlExecute(ctx, list);
    }

    public static void BatchSqlExecute(Context ctx, String[] sqlList) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sb = new StringBuffer();
        boolean isNewGetConnection = false;
        int i = 0;
        try {
            conn = (Connection)ctx.get((Object)ConnectionKey);
            if (conn == null) {
                isNewGetConnection = true;
                conn = EJBFactory.getConnection((Context)ctx);
            }
            statement = conn.createStatement();
            while (i < sqlList.length) {
                if (sqlList[i].trim().length() > 0) {
                    statement.addBatch(sqlList[i]);
                    sb.append(sqlList[i]).append(" ; ");
                }
                ++i;
            }
            long timeFrom = System.currentTimeMillis();
            int[] rowNum = statement.executeBatch();
            long timeTo = System.currentTimeMillis();
            NCMSQLLogUtils.writeLog(ctx, conn, timeFrom, timeTo, sqlList, rowNum);
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)NCMDbUtil.buildLogString4(sqlList), (Throwable)exc);
                throw new BOSException("\r\nSQL is: " + Arrays.toString(sqlList), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                if (isNewGetConnection) {
                    SQLUtils.cleanup((Connection)conn);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        if (isNewGetConnection) {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static List executeSQLByBatch(Context ctx, String sql, Object[] params, Collection in_ids, int inCount) throws BOSException {
        int otherParamsCount;
        if (in_ids == null || in_ids.isEmpty()) {
            throw new IllegalArgumentException("ID is null");
        }
        int idSize = in_ids.size();
        int batchNum = idSize < 200 ? idSize : 200;
        int countForExec = idSize / batchNum + (idSize % batchNum == 0 ? 0 : 1);
        String notFindStr = "#";
        boolean isSelect = sql.trim().toLowerCase().startsWith("select");
        int n = otherParamsCount = params == null ? 0 : params.length;
        if (idSize > 1) {
            StringBuffer sbin = new StringBuffer();
            sbin.append("in (");
            int size = batchNum;
            for (int index = 0; index < size; ++index) {
                sbin.append("?,");
            }
            sql = sql.replaceAll("[iI]+[nN]+\\s*\\(\\s*\\?\\s*\\)", sbin.substring(0, sbin.length() - 1) + ")");
        }
        int pos = 0;
        ArrayList<JdbcRowSet> rsList = new ArrayList<JdbcRowSet>();
        ResultSet rs = null;
        Iterator idsItr = in_ids.iterator();
        ArrayList ids = new ArrayList();
        while (idsItr.hasNext()) {
            ids.add(idsItr.next());
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < otherParamsCount; ++i) {
                pstmt.setObject(i + 1, params[i]);
            }
            for (int execNum = 0; execNum < countForExec; ++execNum) {
                int qutationPos = otherParamsCount + 1;
                while (qutationPos <= otherParamsCount + batchNum) {
                    if (pos < idSize) {
                        for (int i = 0; i < inCount; ++i) {
                            pstmt.setString(qutationPos + batchNum * i, (String)ids.get(pos));
                        }
                    } else {
                        pstmt.setString(qutationPos, "#");
                    }
                    ++qutationPos;
                    ++pos;
                }
                if (isSelect) {
                    rs = pstmt.executeQuery();
                    JdbcRowSet rowset = new JdbcRowSet();
                    rowset.populate(rs);
                    if (rowset.size() <= 0) continue;
                    rsList.add(rowset);
                    continue;
                }
                pstmt.execute();
            }
        }
        catch (SQLException ex) {
            try {
                StringBuffer sb = new StringBuffer("");
                for (int i = 0; i < otherParamsCount; ++i) {
                    sb.append("param ").append(i).append(" is:").append(params[i]);
                }
                logger.error((Object)("444 sql is:" + sql + " param is:" + sb.toString()), (Throwable)ex);
                throw new BOSException("Sql4 execute exception : " + sql, (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
        return isSelect ? rsList : null;
    }

    public static List executeSQLByBatch(Context ctx, String sql, Object[] params, Collection in_ids) throws BOSException {
        int otherParamsCount;
        if (in_ids == null || in_ids.isEmpty()) {
            throw new IllegalArgumentException("ID is null");
        }
        int idSize = in_ids.size();
        int batchNum = idSize < 200 ? idSize : 200;
        int countForExec = idSize / batchNum + (idSize % batchNum == 0 ? 0 : 1);
        String notFindStr = "#";
        boolean isSelect = sql.trim().toLowerCase().startsWith("select");
        int n = otherParamsCount = params == null ? 0 : params.length;
        if (idSize > 1) {
            StringBuffer sbin = new StringBuffer();
            sbin.append("in (");
            int size = batchNum;
            for (int index = 0; index < size; ++index) {
                sbin.append("?,");
            }
            sql = sql.replaceAll("[iI]+[nN]+\\s*\\(\\s*\\?\\s*\\)", sbin.substring(0, sbin.length() - 1) + ")");
        }
        logger.error((Object)("ncm sql in executeSQLByBatch(Context ctx, String sql, Object[] params, Collection in_ids) = (" + sql + ")"));
        int pos = 0;
        ArrayList<JdbcRowSet> rsList = new ArrayList<JdbcRowSet>();
        ResultSet rs = null;
        Iterator idsItr = in_ids.iterator();
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < otherParamsCount; ++i) {
                pstmt.setObject(i + 1, params[i]);
            }
            for (int execNum = 0; execNum < countForExec; ++execNum) {
                int qutationPos = otherParamsCount + 1;
                while (qutationPos <= otherParamsCount + batchNum) {
                    if (pos < idSize) {
                        pstmt.setString(qutationPos, (String)idsItr.next());
                    } else {
                        pstmt.setString(qutationPos, "#");
                    }
                    ++qutationPos;
                    ++pos;
                }
                if (isSelect) {
                    rs = pstmt.executeQuery();
                    JdbcRowSet rowset = new JdbcRowSet();
                    rowset.populate(rs);
                    if (rowset.size() <= 0) continue;
                    rsList.add(rowset);
                    continue;
                }
                pstmt.execute();
            }
        }
        catch (SQLException ex) {
            try {
                StringBuffer sb = new StringBuffer("");
                for (int i = 0; i < otherParamsCount; ++i) {
                    sb.append("param ").append(i).append(" is:").append(params[i]);
                }
                logger.error((Object)("444 sql is:" + sql + " param is:" + sb.toString()), (Throwable)ex);
                throw new BOSException("Sql4 execute exception : " + sql, (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
        return isSelect ? rsList : null;
    }

    public static void execute(Context ctx, String sql, Connection conn) throws BOSException {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            long timeFrom = System.currentTimeMillis();
            statement.execute(sql);
            long timeTo = System.currentTimeMillis();
            NCMSQLLogUtils.writeLog(ctx, conn, timeFrom, timeTo, sql, null, 0);
        }
        catch (SQLException exc) {
            logger.error((Object)NCMDbUtil.buildLogString(sql, null), (Throwable)exc);
            throw new BOSException("\r\nSQL is:" + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)statement);
        }
    }

    public static IRowSet executeQuery(Context ctx, String sql, Connection conn) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.createStatement();
            long timeFrom = System.currentTimeMillis();
            rs = statement.executeQuery(sql);
            long timeTo = System.currentTimeMillis();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            NCMSQLLogUtils.writeLog(ctx, conn, timeFrom, timeTo, sql, null, rowset.getFetchSize());
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)NCMDbUtil.buildLogString(sql, null), (Throwable)exc);
                throw new BOSException("\r\nSQL is:" + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
        return jdbcRowSet;
    }

    public static void BatchSqlExecute(Context ctx, String sql, Connection conn) throws BOSException {
        NCMDbUtil.BatchSqlExecute(ctx, sql, ";", conn);
    }

    public static void BatchSqlExecute(Context ctx, String sql, String separator, Connection conn) throws BOSException {
        String[] list = sql.split(separator);
        NCMDbUtil.BatchSqlExecute(ctx, list, conn);
    }

    private static void BatchSqlExecute(Context ctx, String[] sqlList, Connection conn) throws BOSException {
        Statement statement = null;
        StringBuffer sb = new StringBuffer();
        try {
            statement = conn.createStatement();
            for (int i = 0; i < sqlList.length; ++i) {
                if (sqlList[i].trim().length() <= 0) continue;
                statement.addBatch(sqlList[i]);
                sb.append(sqlList[i]).append(" ; ");
            }
            long timeFrom = System.currentTimeMillis();
            int[] rowNum = statement.executeBatch();
            long timeTo = System.currentTimeMillis();
            NCMSQLLogUtils.writeLog(ctx, conn, timeFrom, timeTo, sqlList, rowNum);
        }
        catch (SQLException exc) {
            logger.error((Object)NCMDbUtil.buildLogString4(sqlList), (Throwable)exc);
            throw new BOSException("\r\nSQL is: " + Arrays.toString(sqlList), (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)statement);
        }
    }

    public static void analyzeTempTable(Context ctx, String tblName) throws BOSException {
        Connection conn = null;
        TempTablePool pool = null;
        boolean isNewGetConnection = false;
        try {
            conn = (Connection)ctx.get((Object)ConnectionKey);
            if (conn == null) {
                isNewGetConnection = true;
                conn = EJBFactory.getConnection((Context)ctx);
            }
            if ((pool = (TempTablePool)ctx.get((Object)paramKey_tempTablePool)) == null) {
                pool = TempTablePool.getInstance((Context)ctx);
            }
            pool.analyzeTable(conn, tblName);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (isNewGetConnection) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    public static void analyzeTempTableByConnection(Context ctx, Connection conn, String tblName) throws BOSException {
        TempTablePool pool = null;
        try {
            pool = (TempTablePool)ctx.get((Object)paramKey_tempTablePool);
            if (pool == null) {
                pool = TempTablePool.getInstance((Context)ctx);
            }
            pool.analyzeTable(conn, tblName);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static String createTempTable(Context ctx, String sqlCreateTbl, String index) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tblName = null;
        try {
            tblName = pool.createTempTable(sqlCreateTbl);
            if (index != null && index.length() > 0) {
                TempTablePool.getInstance((Context)ctx).createIndex(tblName, index, false, false);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tblName;
    }

    public static String createTempTable(Context ctx, String sqlCreateTbl) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return NCMDbUtil.createTempTableByPool(pool, sqlCreateTbl);
    }

    public static String createTempTableByPool(TempTablePool pool, String sqlCreateTbl) throws BOSException {
        String tblName = null;
        try {
            tblName = pool.createTempTable(sqlCreateTbl);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tblName;
    }

    public static String createTempTableIndex(Context ctx, String tblName, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return NCMDbUtil.createTempTableIndexByPool(pool, tblName, columns, isUnique, isClustered);
    }

    public static String createTempTableIndexByPool(TempTablePool pool, String tblName, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        String indexName = null;
        try {
            indexName = pool.createIndex(tblName, columns, isUnique, isClustered);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return indexName;
    }

    public static void releaseTempTable(Context ctx, String tblName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        NCMDbUtil.releaseTempTableByPool(pool, tblName);
    }

    public static void releaseTempTables(Context ctx, String ... tblNames) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        NCMDbUtil.releaseTempTables(pool, tblNames);
    }

    public static void releaseTempTableByPool(TempTablePool pool, String tblName) {
        if (tblName != null) {
            pool.releaseTable(tblName);
        }
    }

    public static void releaseTempTables(TempTablePool pool, String ... tblNames) {
        if (tblNames != null) {
            for (String tblName : tblNames) {
                NCMDbUtil.releaseTempTableByPool(pool, tblName);
            }
        }
    }

    public static String createDBSystemTempTable(Context ctx, Connection conn, String sqlCreateTbl) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tblName = NCMDbUtil.createDBSystemTempTableByPool(pool, conn, sqlCreateTbl);
        return tblName;
    }

    public static String createDBSystemTempTableByPool(TempTablePool pool, Connection conn, String sqlCreateTbl) throws BOSException {
        String tblName = null;
        try {
            tblName = pool.createDBSystemTempTable(sqlCreateTbl, conn);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tblName;
    }

    public static String createDBSystemTempTableIndex(Context ctx, Connection conn, String tblName, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String indexName = NCMDbUtil.createDBSystemTempTableIndexByPool(pool, conn, tblName, columns, isUnique, isClustered);
        return indexName;
    }

    public static String createDBSystemTempTableIndexByPool(TempTablePool pool, Connection conn, String tblName, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        String indexName = null;
        try {
            indexName = pool.createDBSystemTempTableIndex(tblName, columns, isUnique, isClustered, conn);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return indexName;
    }

    public static void releaseDBSystemTempTable(Context ctx, Connection conn, String sqlCreateTbl) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        NCMDbUtil.releaseDBSystemTempTableByPool(pool, conn, sqlCreateTbl);
    }

    public static void releaseDBSystemTempTableByPool(TempTablePool pool, Connection conn, String sqlCreateTbl) throws BOSException {
        try {
            pool.releaseDBSystemTempTable(sqlCreateTbl, conn);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

