/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.NCMDynamicTableMapCollection;
import com.kingdee.eas.ncm.common.NCMDynamicTableMapEntryCollection;
import com.kingdee.eas.ncm.common.NCMDynamicTableMapEntryInfo;
import com.kingdee.eas.ncm.common.NCMDynamicTableMapFactory;
import com.kingdee.eas.ncm.common.NCMDynamicTableMapInfo;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NCMDynamicTableManager {
    private static Logger logger = Logger.getLogger((String)NCMDynamicTableManager.class.getName());
    private static final char CLF = '\n';
    private static ThreadLocal threadLocal = new ThreadLocal();
    private static CustomCacheService m_DynamicTblMapCache = new CustomCacheService("NCMModule.DynamicTblMap");

    private static String getPhysicalTblName(Context ctx, String companyId, String busiTblName) throws BOSException, EASBizException, SQLException {
        NCMDynamicTableManager.checkBusiTblName(busiTblName);
        String sKey = companyId + busiTblName;
        String phyTblName = NCMDynamicTableManager.getPhysicalTblNameFromContext(ctx, companyId, busiTblName);
        if (phyTblName != null) {
            return phyTblName;
        }
        phyTblName = (String)m_DynamicTblMapCache.get(sKey);
        if (phyTblName != null) {
            return phyTblName;
        }
        String sql = "Select physicalTblName,needUpdateIndex,needUpdateColumn, entries.* where businessTblName='" + busiTblName + "' AND company='" + companyId + "'";
        NCMDynamicTableMapCollection data = NCMDynamicTableMapFactory.getLocalInstance(ctx).getNCMDynamicTableMapCollection(sql);
        if (data != null && data.size() > 0) {
            String ret = data.get(0).getPhysicalTblName();
            if (data.get(0).isNeedUpdateIndex()) {
                NCMDynamicTableManager.updateIndexs(ctx, companyId, busiTblName, ret, data.get(0));
            }
            if (data.get(0).isNeedUpdateColumn()) {
                NCMDynamicTableManager.updateColumn(ctx, companyId, busiTblName, ret, data.get(0));
            }
            NCMDynamicTableManager.setPhysicalTblNameFromContext(ctx, companyId, busiTblName, ret);
            m_DynamicTblMapCache.put(sKey, (Object)ret);
            return ret;
        }
        return null;
    }

    public static String getPhysicalTblNameWithCreate(Context ctx, String companyId, String busiTblName) throws BOSException, SQLException, EASBizException {
        NCMDynamicTableManager.checkBusiTblName(busiTblName);
        String physTableName = NCMDynamicTableManager.getPhysicalTblName(ctx, companyId, busiTblName);
        if (physTableName != null) {
            return physTableName;
        }
        String[] tblNameInfo = NCMDynamicTableManager.GetRandomTblName(ctx);
        if (tblNameInfo.length == 2 && NCMDynamicTableManager.CreateDynamicTable(ctx, companyId, busiTblName, tblNameInfo)) {
            physTableName = tblNameInfo[0];
            NCMDynamicTableManager.recordTblMapping(ctx, companyId, busiTblName, physTableName, tblNameInfo[1]);
            if ("T_NCM_AllDataByCostObj_History".equals(busiTblName)) {
                NCMDynamicTableManager.insertHistoryData(ctx, companyId, physTableName);
            }
        }
        NCMDynamicTableManager.setPhysicalTblNameFromContext(ctx, companyId, busiTblName, physTableName);
        m_DynamicTblMapCache.put(companyId + busiTblName, (Object)physTableName);
        return physTableName;
    }

    public static String getPhysicalTblNameForReport(Context ctx, String companyId, String busiTblName, int fromPeriod, int toPeriod) throws BOSException, SQLException, EASBizException {
        NCMDynamicTableManager.checkBusiTblName(busiTblName);
        PeriodInfo currPeriod = NCMUtils.GetCurrentPeriod(ctx, companyId);
        int iCurr = currPeriod.getNumber();
        int flag = 1;
        flag = iCurr == toPeriod && iCurr == fromPeriod ? 1 : (fromPeriod < iCurr && toPeriod < iCurr ? 2 : 3);
        String tblName = NCMDynamicTableManager.TransTBL(busiTblName, flag);
        return NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, tblName);
    }

    public static String getPhysicalTblNameForReportNor(Context ctx, String companyId, String busiTblName) throws BOSException, SQLException, EASBizException {
        NCMDynamicTableManager.checkBusiTblName(busiTblName);
        int flag = 2;
        String tblName = NCMDynamicTableManager.TransTBL(busiTblName, flag);
        return NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, tblName);
    }

    public static String getPhysicalTblNameForReport(Context ctx, String companyId, String busiTblName, int flag) throws BOSException, SQLException, EASBizException {
        NCMDynamicTableManager.checkBusiTblName(busiTblName);
        String tblName = NCMDynamicTableManager.TransTBL(busiTblName, flag);
        return NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, tblName);
    }

    public static String getPhysicalTblNameForReport(Context ctx, String companyId, String busiTblName, Date fromDate, Date toDate) throws BOSException, SQLException, EASBizException {
        NCMDynamicTableManager.checkBusiTblName(busiTblName);
        PeriodInfo currPeriod = NCMUtils.GetCurrentPeriod(ctx, companyId);
        Date begin = currPeriod.getBeginDate();
        Timestamp end = currPeriod.getEndDate();
        int flag = 1;
        flag = fromDate.compareTo(begin) >= 0 && toDate.compareTo(end) <= 0 ? 1 : (fromDate.compareTo(begin) < 0 && toDate.compareTo(begin) < 0 ? 2 : 3);
        String tblName = NCMDynamicTableManager.TransTBL(busiTblName, flag);
        return NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, tblName);
    }

    public static String TransTBL(String busiTblName, int flag) {
        if (busiTblName.equals("T_NCM_MatAllocResult") || busiTblName.equals("T_NCM_MatAllocResult_History") || busiTblName.equals("T_NCM_MatAllocResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_MatAllocResult";
                }
                case 2: {
                    return "T_NCM_MatAllocResult_History";
                }
                case 3: {
                    return "T_NCM_MatAllocResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_DynMatAllocResult") || busiTblName.equals("T_NCM_DynMatAllocResult_History") || busiTblName.equals("T_NCM_DynMatAllocResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_DynMatAllocResult";
                }
                case 2: {
                    return "T_NCM_DynMatAllocResult_History";
                }
                case 3: {
                    return "T_NCM_DynMatAllocResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_OtherAllocResult") || busiTblName.equals("T_NCM_OtherAllocResult_History") || busiTblName.equals("T_NCM_OtherAllocResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_OtherAllocResult";
                }
                case 2: {
                    return "T_NCM_OtherAllocResult_History";
                }
                case 3: {
                    return "T_NCM_OtherAllocResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_DynOtherAllocResult") || busiTblName.equals("T_NCM_DynOtherAllocResult_History") || busiTblName.equals("T_NCM_DynOtherAllocResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_DynOtherAllocResult";
                }
                case 2: {
                    return "T_NCM_DynOtherAllocResult_History";
                }
                case 3: {
                    return "T_NCM_DynOtherAllocResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_AuxAllocResult") || busiTblName.equals("T_NCM_AuxAllocResult_History") || busiTblName.equals("T_NCM_AuxAllocResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_AuxAllocResult";
                }
                case 2: {
                    return "T_NCM_AuxAllocResult_History";
                }
                case 3: {
                    return "T_NCM_AuxAllocResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_LinearEquations") || busiTblName.equals("T_NCM_LinearEquations_History") || busiTblName.equals("T_NCM_LinearEquations_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_LinearEquations";
                }
                case 2: {
                    return "T_NCM_LinearEquations_History";
                }
                case 3: {
                    return "T_NCM_LinearEquations_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_AugmentedMatrix") || busiTblName.equals("T_NCM_AugmentedMatrix_History") || busiTblName.equals("T_NCM_AugmentedMatrix_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_AugmentedMatrix";
                }
                case 2: {
                    return "T_NCM_AugmentedMatrix_History";
                }
                case 3: {
                    return "T_NCM_AugmentedMatrix_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_CostCalResult") || busiTblName.equals("T_NCM_CostCalResult_History") || busiTblName.equals("T_NCM_CostCalResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_CostCalResult";
                }
                case 2: {
                    return "T_NCM_CostCalResult_History";
                }
                case 3: {
                    return "T_NCM_CostCalResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_CostCalMatDetailResult") || busiTblName.equals("T_NCM_CostCalMatDetailResult_History") || busiTblName.equals("T_NCM_CostCalMatDetailResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_CostCalMatDetailResult";
                }
                case 2: {
                    return "T_NCM_CostCalMatDetailResult_History";
                }
                case 3: {
                    return "T_NCM_CostCalMatDetailResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_CostCalPrdDetailResult") || busiTblName.equals("T_NCM_CostCalPrdDetailResult_History") || busiTblName.equals("T_NCM_CostCalPrdDetailResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_CostCalPrdDetailResult";
                }
                case 2: {
                    return "T_NCM_CostCalPrdDetailResult_History";
                }
                case 3: {
                    return "T_NCM_CostCalPrdDetailResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_OrderCostCalResult") || busiTblName.equals("T_NCM_OrderCostCalResult_History") || busiTblName.equals("T_NCM_OrderCostCalResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_OrderCostCalResult";
                }
                case 2: {
                    return "T_NCM_OrderCostCalResult_History";
                }
                case 3: {
                    return "T_NCM_OrderCostCalResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_OrderCostCalMatDetailResult") || busiTblName.equals("T_NCM_OrderCostCalMatDetailResult_History") || busiTblName.equals("T_NCM_OrderCostCalMatDetailResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_OrderCostCalMatDetailResult";
                }
                case 2: {
                    return "T_NCM_OrderCostCalMatDetailResult_History";
                }
                case 3: {
                    return "T_NCM_OrderCostCalMatDetailResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_OrderCostCalActivityResult") || busiTblName.equals("T_NCM_OrderCostCalActivityResult_History") || busiTblName.equals("T_NCM_OrderCostCalActivityResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_OrderCostCalActivityResult";
                }
                case 2: {
                    return "T_NCM_OrderCostCalActivityResult_History";
                }
                case 3: {
                    return "T_NCM_OrderCostCalActivityResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_OrderCostCalActivityDetailResult") || busiTblName.equals("T_NCM_OrderCostCalActivityDetailResult_History") || busiTblName.equals("T_NCM_OrderCostCalActivityDetailResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_OrderCostCalActivityDetailResult";
                }
                case 2: {
                    return "T_NCM_OrderCostCalActivityDetailResult_History";
                }
                case 3: {
                    return "T_NCM_OrderCostCalActivityDetailResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_Balance") || busiTblName.equals("T_NCM_Balance_History") || busiTblName.equals("T_NCM_Balance_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_Balance";
                }
                case 2: {
                    return "T_NCM_Balance_History";
                }
                case 3: {
                    return "T_NCM_Balance_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_BalanceEntry") || busiTblName.equals("T_NCM_BalanceEntry_History") || busiTblName.equals("T_NCM_BalanceEntry_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_BalanceEntry";
                }
                case 2: {
                    return "T_NCM_BalanceEntry_History";
                }
                case 3: {
                    return "T_NCM_BalanceEntry_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_BalanceMatDetail") || busiTblName.equals("T_NCM_BalanceMatDetail_History") || busiTblName.equals("T_NCM_BalanceMatDetail_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_BalanceMatDetail";
                }
                case 2: {
                    return "T_NCM_BalanceMatDetail_History";
                }
                case 3: {
                    return "T_NCM_BalanceMatDetail_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_DataByCostObj") || busiTblName.equals("T_NCM_DataByCostObj_History") || busiTblName.equals("T_NCM_DataByCostObj_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_DataByCostObj";
                }
                case 2: {
                    return "T_NCM_DataByCostObj_History";
                }
                case 3: {
                    return "T_NCM_DataByCostObj_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_DataByOrder") || busiTblName.equals("T_NCM_DataByOrder_History") || busiTblName.equals("T_NCM_DataByOrder_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_DataByOrder";
                }
                case 2: {
                    return "T_NCM_DataByOrder_History";
                }
                case 3: {
                    return "T_NCM_DataByOrder_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_DataByProduct") || busiTblName.equals("T_NCM_DataByProduct_History") || busiTblName.equals("T_NCM_DataByProduct_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_DataByProduct";
                }
                case 2: {
                    return "T_NCM_DataByProduct_History";
                }
                case 3: {
                    return "T_NCM_DataByProduct_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_AllDataByCostObj") || busiTblName.equals("T_NCM_AllDataByCostObj_History") || busiTblName.equals("T_NCM_AllDataByCostObj_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_AllDataByCostObj";
                }
                case 2: {
                    return "T_NCM_AllDataByCostObj_History";
                }
                case 3: {
                    return "T_NCM_AllDataByCostObj_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_CostCalRevertInfo") || busiTblName.equals("T_NCM_CostCalRevertInfo_History") || busiTblName.equals("T_NCM_CostCalRevertInfo_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_CostCalRevertInfo";
                }
                case 2: {
                    return "T_NCM_CostCalRevertInfo_History";
                }
                case 3: {
                    return "T_NCM_CostCalRevertInfo_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_CostRecoveryReportByEnd") || busiTblName.equals("T_NCM_CostRecoveryReportByEnd_History") || busiTblName.equals("T_NCM_CostRecoveryReportByEnd_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_CostRecoveryReportByEnd";
                }
                case 2: {
                    return "T_NCM_CostRecoveryReportByEnd_History";
                }
                case 3: {
                    return "T_NCM_CostRecoveryReportByEnd_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_CostRecoveryReportByStep") || busiTblName.equals("T_NCM_CostRecoveryReportByStep_History") || busiTblName.equals("T_NCM_CostRecoveryReportByStep_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_CostRecoveryReportByStep";
                }
                case 2: {
                    return "T_NCM_CostRecoveryReportByStep_History";
                }
                case 3: {
                    return "T_NCM_CostRecoveryReportByStep_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_CostRecoveryVourchData") || busiTblName.equals("T_NCM_CostRecoveryVourchData_History") || busiTblName.equals("T_NCM_CostRecoveryVourchData_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_CostRecoveryVourchData";
                }
                case 2: {
                    return "T_NCM_CostRecoveryVourchData_History";
                }
                case 3: {
                    return "T_NCM_CostRecoveryVourchData_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_DynCostCalResult") || busiTblName.equals("T_NCM_DynCostCalResult_History") || busiTblName.equals("T_NCM_DynCostCalResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_DynCostCalResult";
                }
                case 2: {
                    return "T_NCM_DynCostCalResult_History";
                }
                case 3: {
                    return "T_NCM_DynCostCalResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_DynCostCalMatDetailResult") || busiTblName.equals("T_NCM_DynCostCalMatDetailResult_History") || busiTblName.equals("T_NCM_DynCostCalMatDetailResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_DynCostCalMatDetailResult";
                }
                case 2: {
                    return "T_NCM_DynCostCalMatDetailResult_History";
                }
                case 3: {
                    return "T_NCM_DynCostCalMatDetailResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_DynDataByCostObj") || busiTblName.equals("T_NCM_DynDataByCostObj_History") || busiTblName.equals("T_NCM_DynDataByCostObj_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_DynDataByCostObj";
                }
                case 2: {
                    return "T_NCM_DynDataByCostObj_History";
                }
                case 3: {
                    return "T_NCM_DynDataByCostObj_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_DynDataByProduct") || busiTblName.equals("T_NCM_DynDataByProduct_History") || busiTblName.equals("T_NCM_DynDataByProduct_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_DynDataByProduct";
                }
                case 2: {
                    return "T_NCM_DynDataByProduct_History";
                }
                case 3: {
                    return "T_NCM_DynDataByProduct_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_DynCostCalPrdDetailResult") || busiTblName.equals("T_NCM_DynCostCalPrdDetailResult_History") || busiTblName.equals("T_NCM_DynCostCalPrdDetailResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_DynCostCalPrdDetailResult";
                }
                case 2: {
                    return "T_NCM_DynCostCalPrdDetailResult_History";
                }
                case 3: {
                    return "T_NCM_DynCostCalPrdDetailResult_View";
                }
            }
        } else if (busiTblName.equals("T_NCM_WIPCountingAllocResult") || busiTblName.equals("T_NCM_WIPCountingAllocResult_History") || busiTblName.equals("T_NCM_WIPCountingAllocResult_View")) {
            switch (flag) {
                case 1: {
                    return "T_NCM_WIPCountingAllocResult";
                }
                case 2: {
                    return "T_NCM_WIPCountingAllocResult_History";
                }
                case 3: {
                    return "T_NCM_WIPCountingAllocResult_View";
                }
            }
        } else {
            if (busiTblName.equals("T_NCM_CostCalReportPreTreatData")) {
                return "T_NCM_CostCalReportPreTreatData";
            }
            if (busiTblName.equals("T_NCM_YearSumAmountData")) {
                return "T_NCM_YearSumAmountData";
            }
            if (busiTblName.equals("T_NCM_YearSumQtyData")) {
                return "T_NCM_YearSumQtyData";
            }
        }
        return null;
    }

    public static boolean DeleteTable(Context ctx, String companyId, String busiTblName, String whereClause) throws SQLException, BOSException, EASBizException {
        String physTbl = NCMDynamicTableManager.getPhysicalTblName(ctx, companyId, busiTblName);
        String sqlTrunc = "truncate table  " + physTbl;
        String sqlDelete = "Delete from " + physTbl + " where  " + whereClause;
        if (physTbl != null) {
            if (whereClause == null) {
                NCMDbUtil.execute(ctx, sqlTrunc);
            } else {
                NCMDbUtil.execute(ctx, sqlDelete);
            }
        }
        return false;
    }

    public static boolean DeleteTable(Context ctx, String physicalTblName, String whereClause) throws SQLException {
        Assert.that((physicalTblName != null ? 1 : 0) != 0);
        String sqlTrunc = "truncate table " + physicalTblName;
        String sqlDelete = "Delete from  " + physicalTblName;
        if (whereClause != null) {
            sqlDelete = sqlDelete + " " + whereClause;
        }
        try {
            if (NCMDynamicTableManager.isTableExists(ctx, physicalTblName)) {
                if (whereClause == null) {
                    NCMDbUtil.execute(ctx, sqlTrunc);
                } else {
                    NCMDbUtil.execute(ctx, sqlDelete);
                }
            }
        }
        catch (BOSException e) {
            throw new SQLException(e.getMessage());
        }
        return false;
    }

    public static void TruncateTables(Context ctx, String[] physicalTblName) throws BOSException {
        Assert.that((physicalTblName != null ? 1 : 0) != 0);
        Assert.that((physicalTblName.length > 0 ? 1 : 0) != 0);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < physicalTblName.length; ++i) {
            sb.append("truncate table ").append(physicalTblName[i]).append(";").append('\n');
        }
        if (sb.length() > 0) {
            NCMDbUtil.BatchSqlExecute(ctx, sb.toString(), ";");
        }
    }

    private static void recordTblMapping(Context ctx, String companyId, String busiTblName, String physicalTblName, String consName) throws BOSException, EASBizException {
        NCMDynamicTableMapInfo data = new NCMDynamicTableMapInfo();
        data.setCompany(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId)));
        data.setBusinessTblName(busiTblName);
        data.setPhysicalTblName(physicalTblName);
        data.setPrimaryKeyName(consName);
        data.setNeedUpdateIndex(true);
        NCMDynamicTableMapFactory.getLocalInstance(ctx).addnew(data);
    }

    private static void recordTblMapping_Entry(Context ctx, NCMDynamicTableMapInfo parent, String indexName, String indexColumns) throws BOSException, EASBizException {
        NCMDynamicTableMapEntryInfo data = new NCMDynamicTableMapEntryInfo();
        data.setParent(parent);
        data.setIndexName(indexName);
        data.setIndexColumns(indexColumns);
        parent.getEntries().add(data);
    }

    private static String[] GetRandomTblName(Context ctx) throws SQLException, BOSException {
        String tablePkConstrait;
        String tableName;
        do {
            if ((tableName = new UUTN(true).toString()).length() > 28) {
                tableName = tableName.substring(0, 28);
            }
            tableName = tableName.replaceFirst("VT", "NCM");
            tablePkConstrait = new UUTN("ZC").toString();
            if (tablePkConstrait.length() > 10) {
                tablePkConstrait = tablePkConstrait.substring(0, 10);
            }
            tablePkConstrait = tablePkConstrait.replaceFirst("ZC", "PK_NCM");
        } while (NCMDynamicTableManager.isTableExists(ctx, tableName) || NCMDynamicTableManager.isConstrainsExists(ctx, tablePkConstrait));
        return new String[]{tableName, tablePkConstrait};
    }

    private static boolean isTableExists(Context ctx, String tableName) throws SQLException, BOSException {
        Assert.that((tableName != null ? 1 : 0) != 0);
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = ?)";
        IRowSet rs = null;
        rs = NCMDbUtil.executeQuery(ctx, sql, new String[]{tableName});
        return rs.next();
    }

    private static boolean isConstrainsExists(Context ctx, String consName) throws SQLException, BOSException {
        Assert.that((consName != null ? 1 : 0) != 0);
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_CONSTRAINTS WHERE  KSQL_CONS_NAME = '" + consName + "' )";
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sql);
        return rs.next();
    }

    private static boolean isIndexExists(Context ctx, String indexName) throws SQLException, BOSException {
        Assert.that((indexName != null ? 1 : 0) != 0);
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = ? )";
        IRowSet rs = null;
        rs = NCMDbUtil.executeQuery(ctx, sql, new String[]{indexName});
        return rs.next();
    }

    public static boolean isTableIndexExists(Context ctx, String tableName) throws SQLException, BOSException {
        Assert.that((tableName != null ? 1 : 0) != 0);
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME=? )";
        IRowSet rs = null;
        rs = NCMDbUtil.executeQuery(ctx, sql, new String[]{tableName});
        return rs.next();
    }

    private static boolean CreateDynamicTable(Context ctx, String companyId, String busiTblName, String[] physicalTblNameInfo) throws SQLException, EASBizException, BOSException {
        String sql = null;
        String tblName = physicalTblNameInfo[0];
        String tblPkName = physicalTblNameInfo[1];
        String tblCurrent = null;
        String tblHistory = null;
        Object[] param = null;
        if (busiTblName.equals("T_NCM_MatAllocResult") || busiTblName.equals("T_NCM_MatAllocResult_History") || busiTblName.equals("T_NCM_MatAllocResult_Adjust") || busiTblName.equals("T_NCM_DynMatAllocResult") || busiTblName.equals("T_NCM_DynMatAllocResult_Adjust") || busiTblName.equals("T_NCM_DynMatAllocResult_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FSourceBillID VARCHAR(44),FSourceBillEntryID VARCHAR(44),FCostObjectID VARCHAR(44),FCostItemID VARCHAR(44),FAllocStdID VARCHAR(44),FAllocStdData NUMERIC(24,12),FQty NUMERIC(21,8),FCommonQty NUMERIC(21,8),FAssistQty NUMERIC(21,8),FBaseUnitID varchar(44),FCommonUnitID varchar(44),FAssistUnitID varchar(44),FPrice NUMERIC(21,8),FAmount NUMERIC(17,4),FMaterialID VARCHAR(44),FLot NVARCHAR(80),FBizDate DateTime,FSeq INT,FCreatorID VARCHAR(44),FCreateTime DateTime,FAdjustUserID VARCHAR(44),FAdjustTime DateTime,FIsDirect INT, AllocBillType VARCHAR(4), FIsRework INT NOT NULL DEFAULT 0,FAdminOrgUnitID varchar(44),FWarehouseID varchar(44), CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_OtherAllocResult") || busiTblName.equals("T_NCM_OtherAllocResult_History") || busiTblName.equals("T_NCM_OtherAllocResult_Adjust") || busiTblName.equals("T_NCM_DynOtherAllocResult") || busiTblName.equals("T_NCM_DynOtherAllocResult_History") || busiTblName.equals("T_NCM_DynOtherAllocResult_Adjust")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FDepartmentID VARCHAR(44),FSourceCostCenterID VARCHAR(44),FSourceBillID VARCHAR(44),FSourceBillEntryID VARCHAR(44),FCostObjectID VARCHAR(44),FCostItemID VARCHAR(44),FAllocStdID VARCHAR(44),FAllocStdData NUMERIC(24,12),FQty NUMERIC(21,8),FPrice NUMERIC(21,8),FAmount NUMERIC(17,4),FCreatorID VARCHAR(44),FCreateTime DateTime,FAdjustUserID VARCHAR(44),FAdjustTime DateTime,FIsDirect INT,CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_CCOAllocResult_Adjust")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FExpenseID VARCHAR(44),FCostCenterGroupID VARCHAR(44),FCostCenterID VARCHAR(44),FDepartmentID VARCHAR(44),FSourceCostCenterID VARCHAR(44),FSourceBillID VARCHAR(44),FSourceBillEntryID VARCHAR(44),FCostItemID VARCHAR(44),FAllocStdID VARCHAR(44),FAllocStdData NUMERIC(24,12),FQty NUMERIC(21,8),FPrice NUMERIC(21,8),FAmount NUMERIC(17,4),FCreatorID VARCHAR(44),FCreateTime DateTime,FAdjustUserID VARCHAR(44),FAdjustTime DateTime,FIsDirect INT,FBizDate DateTime )";
        } else if (busiTblName.equals("T_NCM_AuxAllocResult") || busiTblName.equals("T_NCM_AuxAllocResult_History")) {
            sql = "Create Table {0} ( FID \t\t\t\t    VARCHAR(44) NOT NULL,FCompanyID \t\t\tVARCHAR(44),FCalculatePeriodID \tVARCHAR(44),FSourceBillID \t\t\tVARCHAR(44),FSourceBillEntryID \tVARCHAR(44),FSourceBillEntrySeq \tINT,FAuxOverheadID\t\t\tVARCHAR(44),FCostCenterID \t\t\tVARCHAR(44),FCostObjectID \t\t\tVARCHAR(44),FExpenseID \t\t\tVARCHAR(44),FCostItemID \t\t\tVARCHAR(44),FAllocStdID \t\t\tVARCHAR(44),FAllocStdData \t\t\tNUMERIC(24,12) DEFAULT 1,FAllocQty \t\t\t\tNUMERIC(21,8) DEFAULT 0,FTotalQty \t\t\t\tNUMERIC(21,8) DEFAULT 0,FPrice \t\t\t\tNUMERIC(21,8) DEFAULT 0,FAmount \t\t\t\tNUMERIC(17,4) DEFAULT 0,FIsDirect \t\t\t\tINT DEFAULT 0,CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_LinearEquations") || busiTblName.equals("T_NCM_LinearEquations_History")) {
            sql = "Create Table {0} ( FID \t\t\t\t    VARCHAR(44) NOT NULL,FCompanyID \t\t\tVARCHAR(44),FCalculatePeriodID \tVARCHAR(44),FCostCenterID \t\t\tVARCHAR(44),FCostObjectID \t\t\tVARCHAR(44),FCostItemID \t\t\tVARCHAR(44),FCollectAmount\t\t\tNUMERIC(17,4) DEFAULT 0,FAlgebraAmount\t\t\tNUMERIC(17,4) DEFAULT 0,FTotalAmount\t\t\tNUMERIC(17,4) DEFAULT 0,FTotalQty \t\t\t\tNUMERIC(21,8) DEFAULT 0,FUnitPrice \t\t\tNUMERIC(21,8) DEFAULT 0,FEquationString\t\tNVARCHAR(2000),FVoucherID\t\t        VARCHAR(44),CONSTRAINT {1} \t\tPRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_AugmentedMatrix") || busiTblName.equals("T_NCM_AugmentedMatrix_History")) {
            sql = "Create Table {0} ( FParentID\t\t\t    VARCHAR(44) NOT NULL,FUnkownNumber\t\t\tVARCHAR(44) NOT NULL,FOutputQty \t\t\tNUMERIC(21,8) DEFAULT 0,FCoefficient \t\t\tNUMERIC(21,8) DEFAULT 0,FConstB \t\t\t\tNUMERIC(21,8) DEFAULT 0,FSolution\t \t\t\tNUMERIC(28,12) DEFAULT 0 )";
        } else if (busiTblName.equals("T_NCM_CostCalResult") || busiTblName.equals("T_NCM_CostCalResult_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FCostItemID VARCHAR(44),FAllocStdID VARCHAR(44),FAllocStdData NUMERIC(24,12),FFinishedAmount NUMERIC(17,4),FEoPWIPAmount NUMERIC(17,4),FRecvAmount NUMERIC(17,4),FFinishedQty NUMERIC(21,8) DEFAULT 0, FEoPWIPQty NUMERIC(21,8) DEFAULT 0,FCalcLevel INT,FFinishedAssistQty NUMERIC(21,10),FFinishedAddqty NUMERIC(21,10),FEoPWIPAssistQty NUMERIC(21,10),FEoPWIPAddqty NUMERIC(21,10),FAdjEoPWipQty NUMERIC(21,8), FAdjEoPWipAmount NUMERIC(17,4),  CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_CostCalMatDetailResult") || busiTblName.equals("T_NCM_CostCalMatDetailResult_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FLot NVARCHAR(80),FAllocStdID VARCHAR(44),FAllocStdData NUMERIC(24,12),FFinishedQty NUMERIC(21,8),FEoPWIPQty NUMERIC(21,8),FFinishedAmount NUMERIC(17,4),FEoPWIPAmount NUMERIC(17,4),FCalcLevel INT,FFinishedAssistQty NUMERIC(21,10),FFinishedAddqty NUMERIC(21,10),FEoPWIPAssistQty NUMERIC(21,10),FEoPWIPAddqty NUMERIC(21,10),FIsReWork INT  NOT NULL DEFAULT 0, FAdjEoPWipQty NUMERIC(21,8),FAdjEoPWipAmount NUMERIC(17,4),CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_CostCalPrdDetailResult") || busiTblName.equals("T_NCM_CostCalPrdDetailResult_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FLot NVARCHAR(80),FCostItemID VARCHAR(44),FAllocStdID VARCHAR(44),FAllocStdData NUMERIC(24,12),FFinishedQty NUMERIC(21,8),FFinishedAmount NUMERIC(17,4),FFinishedPrice NUMERIC(21,8),FRecvQty NUMERIC(21,8),FRecvAmount NUMERIC(17,4),FTotalFinishedQty NUMERIC(21,8),FVoucherid VARCHAR(44),FCalcLevel INT, FTempAmount NUMERIC(17,4), CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_OrderCostCalResult") || busiTblName.equals("T_NCM_OrderCostCalResult_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FOrderID VARCHAR(44), FProductID VARCHAR(44), FProdBatchNo NVARCHAR(80), FOrderNumber NVARCHAR(80) NOT NULL,FCostItemID VARCHAR(44),FCostDriverID VARCHAR(44),FAllocCostDriverData NUMERIC(24,12),FFinishedAmount NUMERIC(17,4),FEoPWIPAmount NUMERIC(17,4),FPlanQty NUMERIC(28,10) DEFAULT 0,FFinishedQty NUMERIC(28,10) DEFAULT 0, FEoPWIPQty NUMERIC(28,10) DEFAULT 0,FCalcLevel INT,FTotalFinishedQty NUMERIC(28,10) DEFAULT 0, FTotalEoPWIPQty NUMERIC(28,10) DEFAULT 0,FAmount NUMERIC(17,4) DEFAULT 0, FQty NUMERIC(28,10) DEFAULT 0, FIsMatType INT DEFAULT 0,FPricePrecision INT DEFAULT 8, FQtyPrecision INT DEFAULT 8, FAmountPrecision INT DEFAULT 2, CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_OrderCostCalMatDetailResult") || busiTblName.equals("T_NCM_OrderCostCalMatDetailResult_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FOrderID VARCHAR(44), FProductID VARCHAR(44), FProdBatchNo NVARCHAR(80), FOrderNumber NVARCHAR(80) NOT NULL, FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FMatBatchNo NVARCHAR(80),FCostDriverID VARCHAR(44),FAllocCostDriverData NUMERIC(24,12),FFinishedQty NUMERIC(28,10),FEoPWIPQty NUMERIC(28,10),FFinishedAmount NUMERIC(17,4),FEoPWIPAmount NUMERIC(17,4),FCalcLevel INT,FAmount NUMERIC(17,4) DEFAULT 0, FQty NUMERIC(28,10) DEFAULT 0, FIsSelfManufacture INT DEFAULT 0, FRatio NUMERIC(24,12) DEFAULT 0, FPricePrecision INT DEFAULT 8,FQtyPrecision INT DEFAULT 8,FAmountPrecision INT DEFAULT 2, CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_OrderCostCalActivityResult") || busiTblName.equals("T_NCM_OrderCostCalActivityResult_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FOrderID VARCHAR(44), FProductID VARCHAR(44), FProdBatchNo NVARCHAR(80), FOrderNumber NVARCHAR(80) NOT NULL,FActivityID VARCHAR(44), FCostDriverID VARCHAR(44), FAllocCostDriverData NUMERIC(24,12),FEoPWIPQty NUMERIC(28,10) DEFAULT 0, FFinishedQty NUMERIC(28,10) DEFAULT 0, FCalcLevel INT,FQty NUMERIC(28,10) DEFAULT 0, FQtyPrecision INT DEFAULT 8, CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_OrderCostCalActivityDetailResult") || busiTblName.equals("T_NCM_OrderCostCalActivityDetailResult_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FOrderID VARCHAR(44), FProductID VARCHAR(44), FProdBatchNo NVARCHAR(80), FOrderNumber NVARCHAR(80) NOT NULL,FActivityID VARCHAR(44), FCostItemID VARCHAR(44), FCostDriverID VARCHAR(44), FAllocCostDriverData NUMERIC(24,12),FFinishedAmount NUMERIC(17,4) DEFAULT 0, FEoPWIPAmount NUMERIC(17,4) DEFAULT 0, FFinishedQty NUMERIC(28,10), FEoPWIPQty NUMERIC(28,10),FCalcLevel INT,FAmount NUMERIC(17,4) DEFAULT 0, FQty NUMERIC(28,10) DEFAULT 0, FRatio NUMERIC(24,12) DEFAULT 0,FPricePrecision INT DEFAULT 8,FQtyPrecision INT DEFAULT 8,FAmountPrecision INT DEFAULT 2, CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_CostCalReportPreTreatState")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL, FPeriodId VARCHAR(44),FPeriodNumber VARCHAR(80),FIsPreTreatReportData INT,FIsPreTreatYearSum INT, CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_CostCalReportPreTreatData")) {
            sql = "Create Table {0} ( FPeriodId VARCHAR(44), FCostCenterID VARCHAR(44), FCostObjectID VARCHAR(44), FCostItemID VARCHAR(44), FBegProQty NUMERIC(21,8), FBegProAmount NUMERIC(21,8), FCurInQty NUMERIC(21,8), FCurInAmount NUMERIC(21,8), FCurCompQty NUMERIC(21,8), FCurCompAmount NUMERIC(21,8), FEndProQty NUMERIC(21,8), FEndProAmount NUMERIC(21,8), FMakeSum NUMERIC(21,8), FBalanceYearCompQty NUMERIC(21,8), FBalanceYearCompAmount NUMERIC(21,8), FBalanceYearInAmount NUMERIC(21,8), FYearSumCompQty NUMERIC(21,8), FYearSumCompAmount NUMERIC(21,8), FYearSumInQty NUMERIC(21,8), FYearSumInAmount NUMERIC(21,8),FIsHistoryData int default 0, FAdjBopWipQty NUMERIC(21,8),FAdjBopWipAmount NUMERIC(17,4), \n FAdjEopWipQty NUMERIC(21,8),FAdjEopWipAmount NUMERIC(17,4) \n)";
        } else if (busiTblName.equals("T_NCM_YearSumAmountData")) {
            sql = "Create Table {0} ( FCalculatePeriodID VARCHAR(44), FCostCenterID VARCHAR(44), FCostObjectID VARCHAR(44), FCostItemID VARCHAR(44), FYearSumInAmount NUMERIC(21,8), FYearSumComAmount NUMERIC(21,8) )";
        } else if (busiTblName.equals("T_NCM_YearSumQtyData")) {
            sql = "Create Table {0} ( FCalculatePeriodID VARCHAR(44), FCostCenterID VARCHAR(44), FCostObjectID VARCHAR(44), FYearSumInQty NUMERIC(21,8), FYearSumComQty NUMERIC(21,8) )";
        } else if (busiTblName.equals("T_NCM_LOG_Mat") || busiTblName.equals("T_NCM_LOG_DynMat")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FErrorInfo NVARCHAR(500),FPossibleReason NVARCHAR(500),FAdviceHandle NVARCHAR(500),FLogTime DateTime,CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_LOG_Mat") || busiTblName.equals("T_NCM_LOG_DynMat")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FErrorInfo NVARCHAR(500),FPossibleReason NVARCHAR(500),FAdviceHandle NVARCHAR(500),FLogTime DateTime,CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_LOG_OtherInWH")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FErrorInfo NVARCHAR(500),FPossibleReason NVARCHAR(500),FAdviceHandle NVARCHAR(500),FLogTime DateTime,CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_LOG_CostAdjust")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FErrorInfo NVARCHAR(500),FPossibleReason NVARCHAR(500),FAdviceHandle NVARCHAR(500),FLogTime DateTime,CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_LOG_Other") || busiTblName.equals("T_NCM_LOG_DynOther")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FErrorInfo NVARCHAR(500),FPossibleReason NVARCHAR(500),FAdviceHandle NVARCHAR(500),FLogTime DateTime,CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_LOG_Other")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FErrorInfo NVARCHAR(500),FPossibleReason NVARCHAR(500),FAdviceHandle NVARCHAR(500),FLogTime DateTime,CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_LOG_CCO")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FErrorInfo NVARCHAR(500),FPossibleReason NVARCHAR(500),FAdviceHandle NVARCHAR(500),FLogTime DateTime,CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_Balance") || busiTblName.equals("T_NCM_Balance_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCalculatePeriodID VARCHAR(44),FCompanyOrg VARCHAR(44),FCostObjectID VARCHAR(44),FCostCenterID VARCHAR(44),FBopWIPQty NUMERIC(28,10),FYTDFinishedQty NUMERIC(28,10),FBopWIPHour NUMERIC(28,10) NOT NULL DEFAULT 0,FAdjBopWipQty NUMERIC(28,10),FAdjBopWipHour NUMERIC(28,10),CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_BalanceEntry") || busiTblName.equals("T_NCM_BalanceEntry_History")) {
            sql = "Create Table {0} (  FID VARCHAR(44) NOT NULL ,FParentID VARCHAR(44),FCostItemID VARCHAR(44),FYTDInputAmount NUMERIC(28,10),FBoPWIPAmount NUMERIC(28,10),FYTDFinishAmount NUMERIC(28,10), FBopWIPQty NUMERIC(28,10), FPrice NUMERIC(28,10), FAdjBopWipQty NUMERIC(28,10), FAdjBoPWipAmount NUMERIC(28,10), CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_BalanceMatDetail") || busiTblName.equals("T_NCM_BalanceMatDetail_History")) {
            sql = "Create Table {0} (  FID VARCHAR(44) NOT NULL ,FMaterialID VARCHAR(44),FMaterialName NVARCHAR(80),FBatchNo NVARCHAR(80),FQty NUMERIC(28,10),FPrice NUMERIC(28,10),FAmount NUMERIC(28,10),FYTDInputMatQty NUMERIC(28,10),FYTDInputMatAmou NUMERIC(28,10),FYTDFinishedMatQ NUMERIC(28,10),FYTDFinishedMatA NUMERIC(28,10),FParentID VARCHAR(44),FUnitID VARCHAR(44),FAssistQty NUMERIC(28,10),FAddqty NUMERIC(28,10),FIsRework INT NOT NULL DEFAULT 0,FAdjQty NUMERIC(28,10),FAdjAmount NUMERIC(28,10), CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_DataByCostObj") || busiTblName.equals("T_NCM_DataByCostObj_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FFinishedQty NUMERIC(21,8),  FFinishedAssistQty NUMERIC(21,8) , FFinishedAddQty NUMERIC(21,8),CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_DataByOrder") || busiTblName.equals("T_NCM_DataByOrder_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44), FOrderID VARCHAR(44), FOrderNumber NVARCHAR(80), FProductID VARCHAR(44), FProdBatchNo NVARCHAR(80), FPlanQty NUMERIC(28,10) DEFAULT 0, FEoPWIPQty NUMERIC(28,10) DEFAULT 0, FFinishedQty NUMERIC(28,10) DEFAULT 0, FTotalFinishedQty NUMERIC(28,10) DEFAULT 0,CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_LotMapping")) {
            sql = "Create Table {0} ( FCostObjectID VARCHAR(44),FCostObjBatchNo NVARCHAR(80), FMaterialID VARCHAR(44),FLot NVARCHAR(80) )";
        } else if (busiTblName.equals("T_NCM_DataByProduct") || busiTblName.equals("T_NCM_DataByProduct_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FLot NVARCHAR(80),FFinishedQty NUMERIC(21,8), FFinishedAssistQty  NUMERIC(21,8) , FFinishedAddQty NUMERIC(21,8),CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_AllDataByCostObj") || busiTblName.equals("T_NCM_AllDataByCostObj_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FBopWIPQty NUMERIC(21,8) DEFAULT 0,FInputQty NUMERIC(21,8) DEFAULT 0, FFinishedQty NUMERIC(21,8) DEFAULT 0, FEopWIPQty NUMERIC(21,8) DEFAULT 0,FBopWIPHour NUMERIC(21,8) DEFAULT 0,FInputHour NUMERIC(21,8) DEFAULT 0, FFinishedHour NUMERIC(21,8) DEFAULT 0, FEopWIPHour NUMERIC(21,8) DEFAULT 0,FCoef NUMERIC(21,8) DEFAULT 1,FAdjEopWipQty NUMERIC(21,8), FAdjBoPWipQty NUMERIC(21,8), FAdjBopWipHour NUMERIC(21,8),FAdjEopWipHour NUMERIC(21,8), CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_CostCalRevertInfo") || busiTblName.equals("T_NCM_CostCalRevertInfo_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FCostItemID VARCHAR(44),FSpendCostObjectID VARCHAR(44),FSpendCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FLot NVARCHAR(80),FAmount NUMERIC(17,4),FCoef NUMERIC(24,12),CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_BopWIPCoefByEnd") || busiTblName.equals("T_NCM_BopWIPCoefByEnd_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FProdBatchNo NVARCHAR(80),FSubCostItemID VARCHAR(44),FSubCostObjID VARCHAR(44),FSubProductID VARCHAR(44),FSubProdBatchNo NVARCHAR(80),FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FMatBatchNo NVARCHAR(80),FAmtCoef NUMERIC(24,12) DEFAULT 0,FQtyCoef NUMERIC(24,12) DEFAULT 0,CONSTRAINT {1} PRIMARY KEY NONCLUSTERED(FID))";
        } else if (busiTblName.equals("T_NCM_BopInvCoefByEnd") || busiTblName.equals("T_NCM_BopInvCoefByEnd_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FProdBatchNo NVARCHAR(80),FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FMatBatchNo NVARCHAR(80),FAmtCoef NUMERIC(24,12) DEFAULT 0,FQtyCoef NUMERIC(24,12) DEFAULT 0,CONSTRAINT {1} PRIMARY KEY NONCLUSTERED(FID))";
        } else if (busiTblName.equals("T_NCM_CostRecoveryReportByEnd") || busiTblName.equals("T_NCM_CostRecoveryReportByEnd_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FCostItemGroupID VARCHAR(44),FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FPeriodDispNumber INT,FProductNumber NVARCHAR(80),FProductName NVARCHAR(255),FProdBatchNo NVARCHAR(80),FProductModel NVARCHAR(255),FProductUnitName NVARCHAR(255),FCostItemGroupNumber NVARCHAR(80),FCostItemGroupName NVARCHAR(255),FCostItemNumber NVARCHAR(80),FCostItemName NVARCHAR(255),FMaterialNumber NVARCHAR(80),FMaterialName NVARCHAR(255),FMatBatchNo NVARCHAR(80),FMaterielModel NVARCHAR(255),FMaterielUnitName NVARCHAR(255),FBeforeQty NUMERIC(21,8) DEFAULT 0,FBeforeAmount NUMERIC(17,4) DEFAULT 0,FSFPQty NUMERIC(21,8) DEFAULT 0,FSFPAmount NUMERIC(17,4) DEFAULT 0,FProcessQty NUMERIC(21,8) DEFAULT 0,FProcessAmount NUMERIC(17,4) DEFAULT 0,FAfterQty NUMERIC(21,8) DEFAULT 0,FAfterAmount NUMERIC(17,4) DEFAULT 0,FAfterUnitQty NUMERIC(21,8) DEFAULT 0,FAfterUnitAmount NUMERIC(21,8) DEFAULT 0,FAfterUnitRatio NUMERIC(21,8) DEFAULT 0,FQtyDecimal smallint,FPriceDecimal smallint,FAmountDecimal smallint,FTotalRow Decimal(5,2) not null DEFAULT 0, KSQL_SEQ INT IDENTITY (1, 1) not null,CONSTRAINT {1} PRIMARY KEY NONCLUSTERED (FID))";
        } else if (busiTblName.equals("T_NCM_InitSemifinishedProdCoefByEnd")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FProdBatchNo NVARCHAR(80),FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FMatBatchNo NVARCHAR(80),FAmtCoef NUMERIC(24,12) DEFAULT 0,FQtyCoef NUMERIC(24,12) DEFAULT 0,CONSTRAINT {1} PRIMARY KEY NONCLUSTERED(FID))";
        } else if (busiTblName.equals("T_NCM_BopWIPCoefByStep") || busiTblName.equals("T_NCM_BopWIPCoefByStep_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FProdBatchNo NVARCHAR(80),FSubCostItemID VARCHAR(44),FSubCostObjID VARCHAR(44),FSubProductID VARCHAR(44),FSubProdBatchNo NVARCHAR(80),FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FMatBatchNo NVARCHAR(80),FAmtCoef NUMERIC(24,12) DEFAULT 0,FQtyCoef NUMERIC(24,12) DEFAULT 0,FLayer smallint DEFAULT 0,FDispLayer smallint DEFAULT 0,FIsLeaf smallint DEFAULT 0,FBranch varchar(1020) NOT NULL DEFAULT ('' ''),CONSTRAINT {1} PRIMARY KEY NONCLUSTERED(FID))";
        } else if (busiTblName.equals("T_NCM_BopInvCoefByStep") || busiTblName.equals("T_NCM_BopInvCoefByStep_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FProdBatchNo NVARCHAR(80),FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FMatBatchNo NVARCHAR(80),FAmtCoef NUMERIC(24,12) DEFAULT 0,FQtyCoef NUMERIC(24,12) DEFAULT 0,FLayer smallint DEFAULT 0,FDispLayer smallint DEFAULT 0,FIsLeaf smallint DEFAULT 0,FBranch varchar(1020) NOT NULL DEFAULT ('' ''),CONSTRAINT {1} PRIMARY KEY NONCLUSTERED(FID))";
        } else if (busiTblName.equals("T_NCM_CostRecoveryReportByStep") || busiTblName.equals("T_NCM_CostRecoveryReportByStep_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FCostItemGroupID VARCHAR(44),FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FPeriodDispNumber INT,FProductNumber NVARCHAR(80),FProductName NVARCHAR(255),FProdBatchNo NVARCHAR(80),FProductModel NVARCHAR(255),FProductUnitName NVARCHAR(255),FCostItemGroupNumber NVARCHAR(80),FCostItemGroupName NVARCHAR(255),FCostItemNumber NVARCHAR(80),FCostItemName NVARCHAR(255),FMaterialNumber NVARCHAR(80),FMaterialName NVARCHAR(255),FMatBatchNo NVARCHAR(80),FMaterielModel NVARCHAR(255),FMaterielUnitName NVARCHAR(255),FFinishedQty NUMERIC(21,8) DEFAULT 0,FFinishedAmount NUMERIC(17,4) DEFAULT 0,FFinishedUnitQty NUMERIC(21,8) DEFAULT 0,FFinishedUnitAmount NUMERIC(21,8) DEFAULT 0,FFinishedUnitRatio NUMERIC(21,8) DEFAULT 0,FQtyDecimal smallint,FPriceDecimal smallint,FAmountDecimal smallint,FTotalRow Decimal(5,2) not null DEFAULT 0, FSort NUMERIC(21,0) Default 0,FLayer smallint DEFAULT 0,FDispLayer smallint DEFAULT 0,FIsLeaf smallint DEFAULT 0,FBranch varchar(1020) NOT NULL DEFAULT ('' ''),FDisplayLayerStr VARCHAR(255),FParentID VARCHAR(44),CONSTRAINT {1} PRIMARY KEY NONCLUSTERED (FID))";
        } else if (busiTblName.equals("T_NCM_InitSemifinishedProdCoefByStep")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FProdBatchNo NVARCHAR(80),FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FMatBatchNo NVARCHAR(80),FAmtCoef NUMERIC(24,12) DEFAULT 0,FQtyCoef NUMERIC(24,12) DEFAULT 0,FLayer smallint DEFAULT 0,FDispLayer smallint DEFAULT 0,FIsLeaf smallint DEFAULT 0,FBranch varchar(1020) NOT NULL DEFAULT ('' ''),CONSTRAINT {1} PRIMARY KEY NONCLUSTERED(FID))";
        } else if (busiTblName.equals("T_NCM_RecoveryTreeBranchNode")) {
            sql = "Create Table {0} ( FNodeID \tint\t\t\t\tNOT NULL,FNodeStr\tnvarchar(126)\tNOT NULL )";
            tblPkName = null;
        } else if (busiTblName.equals("T_NCM_RecoveryTreeBranchNode_SEQ")) {
            sql = "Create Table {0} ( KSQL_SEQ INT IDENTITY (1, 1) not null,FNodeStr\tnvarchar(126)\tNOT NULL )";
            tblPkName = null;
        } else if (busiTblName.equals("T_NCM_CostRecoveryVourchData") || busiTblName.equals("T_NCM_CostRecoveryVourchData_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FLot NVARCHAR(80),FCostItemID VARCHAR(44),FRecvQty NUMERIC(21,8),FRecvAmount NUMERIC(17,4),FVoucherid VARCHAR(44),CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_MatAllocResult_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_MatAllocResult");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_MatAllocResult_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FCommonQty ,FAssistQty ,FBaseUnitID ,FCommonUnitID ,FAssistUnitID ,FPrice ,FAmount ,FMaterialID ,FLot ,FBizDate ,FSeq ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect, AllocBillType , FIsRework, FAdminOrgUnitID , FWarehouseID", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FCommonQty ,FAssistQty ,FBaseUnitID ,FCommonUnitID ,FAssistUnitID ,FPrice ,FAmount ,FMaterialID ,FLot ,FBizDate ,FSeq ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect, AllocBillType , FIsRework, FAdminOrgUnitID , FWarehouseID", tblHistory};
        } else if (busiTblName.equals("T_NCM_OtherAllocResult_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_OtherAllocResult");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_OtherAllocResult_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FDepartmentID , FSourceCostCenterID,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FPrice ,FAmount ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FDepartmentID , FSourceCostCenterID,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FPrice ,FAmount ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect ", tblHistory};
        } else if (busiTblName.equals("T_NCM_AuxAllocResult_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_AuxAllocResult");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_AuxAllocResult_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID \t\t\t\t    ,FCompanyID \t\t\t,FCalculatePeriodID \t,FSourceBillID \t\t\t,FSourceBillEntryID \t,FSourceBillEntrySeq \t,FAuxOverheadID\t\t\t,FCostCenterID \t\t\t,FCostObjectID \t\t\t,FExpenseID \t\t\t,FCostItemID \t\t\t,FAllocStdID \t\t\t,FAllocStdData \t\t\t,FAllocQty \t\t\t\t,FTotalQty \t\t\t\t,FPrice \t\t\t\t,FAmount \t\t\t\t,FIsDirect \t\t\t\t ", tblCurrent, "FID \t\t\t\t    ,FCompanyID \t\t\t,FCalculatePeriodID \t,FSourceBillID \t\t\t,FSourceBillEntryID \t,FSourceBillEntrySeq \t,FAuxOverheadID\t\t\t,FCostCenterID \t\t\t,FCostObjectID \t\t\t,FExpenseID \t\t\t,FCostItemID \t\t\t,FAllocStdID \t\t\t,FAllocStdData \t\t\t,FAllocQty \t\t\t\t,FTotalQty \t\t\t\t,FPrice \t\t\t\t,FAmount \t\t\t\t,FIsDirect \t\t\t\t ", tblHistory};
        } else if (busiTblName.equals("T_NCM_LinearEquations_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_LinearEquations");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_LinearEquations_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID \t\t\t\t    ,FCompanyID \t\t\t,FCalculatePeriodID \t,FCostCenterID \t\t\t,FCostObjectID \t\t\t,FCostItemID \t\t\t,FCollectAmount\t\t\t,FAlgebraAmount\t\t\t,FTotalAmount\t\t\t,FTotalQty \t\t\t\t,FUnitPrice \t\t\t,FEquationString\t    ,FVoucherID      \t     ", tblCurrent, "FID \t\t\t\t    ,FCompanyID \t\t\t,FCalculatePeriodID \t,FCostCenterID \t\t\t,FCostObjectID \t\t\t,FCostItemID \t\t\t,FCollectAmount\t\t\t,FAlgebraAmount\t\t\t,FTotalAmount\t\t\t,FTotalQty \t\t\t\t,FUnitPrice \t\t\t,FEquationString\t    ,FVoucherID      \t     ", tblHistory};
        } else if (busiTblName.equals("T_NCM_AugmentedMatrix_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_AugmentedMatrix");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_AugmentedMatrix_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FParentID\t\t\t    ,FUnkownNumber\t\t\t,FOutputQty \t\t\t,FCoefficient \t\t\t,FConstB \t\t\t\t,FSolution\t \t\t\t ", tblCurrent, "FParentID\t\t\t    ,FUnkownNumber\t\t\t,FOutputQty \t\t\t,FCoefficient \t\t\t,FConstB \t\t\t\t,FSolution\t \t\t\t ", tblHistory};
        } else if (busiTblName.equals("T_NCM_CostCalResult_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostCalResult");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostCalResult_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FFinishedAmount ,FEoPWIPAmount ,FRecvAmount ,FFinishedQty , FEoPWIPQty ,FCalcLevel,FFinishedAssistQty,FFinishedAddqty,FEoPWIPAssistQty,FEoPWIPAddqty ,FAdjEoPWipQty, FAdjEoPWipAmount ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FFinishedAmount ,FEoPWIPAmount ,FRecvAmount ,FFinishedQty , FEoPWIPQty ,FCalcLevel,FFinishedAssistQty,FFinishedAddqty,FEoPWIPAssistQty,FEoPWIPAddqty ,FAdjEoPWipQty, FAdjEoPWipAmount ", tblHistory};
        } else if (busiTblName.equals("T_NCM_CostCalMatDetailResult_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostCalMatDetailResult");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostCalMatDetailResult_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FCostItemID ,FMaterialID ,FLot ,FAllocStdID ,FAllocStdData ,FFinishedQty ,FEoPWIPQty ,FFinishedAmount ,FEoPWIPAmount ,FCalcLevel,FFinishedAssistQty,FFinishedAddqty,FEoPWIPAssistQty,FEoPWIPAddqty,FIsReWork, FAdjEoPWipQty, FAdjEoPWipAmount ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FCostItemID ,FMaterialID ,FLot ,FAllocStdID ,FAllocStdData ,FFinishedQty ,FEoPWIPQty ,FFinishedAmount ,FEoPWIPAmount ,FCalcLevel,FFinishedAssistQty,FFinishedAddqty,FEoPWIPAssistQty,FEoPWIPAddqty,FIsReWork, FAdjEoPWipQty, FAdjEoPWipAmount ", tblHistory};
        } else if (busiTblName.equals("T_NCM_CostCalPrdDetailResult_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostCalPrdDetailResult");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostCalPrdDetailResult_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FProductID ,FLot ,FCostItemID ,FAllocStdID ,FAllocStdData ,FFinishedQty ,FFinishedAmount ,FFinishedPrice ,FRecvAmount ,FTotalFinishedQty ,FVoucherid ,FCalcLevel, FTempAmount ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FProductID ,FLot ,FCostItemID ,FAllocStdID ,FAllocStdData ,FFinishedQty ,FFinishedAmount ,FFinishedPrice ,FRecvAmount ,FTotalFinishedQty ,FVoucherid ,FCalcLevel, FTempAmount ", tblHistory};
        } else if (busiTblName.equals("T_NCM_OrderCostCalResult_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_OrderCostCalResult");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_OrderCostCalResult_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID, FCompanyID, FCalculatePeriodID, FCostCenterID, FOrderID, FProductID, FProdBatchNo, FOrderNumber, FCostItemID, FCostDriverID, FAllocCostDriverData ,FFinishedAmount, FEoPWIPAmount, FPlanQty, FFinishedQty, FEoPWIPQty ,FCalcLevel, FTotalFinishedQty, FTotalEoPWIPQty, FAmount, FQty, FIsSelfManufacture, FPricePrecision, FQtyPrecision, FAmountPrecision ", tblCurrent, "FID, FCompanyID, FCalculatePeriodID, FCostCenterID, FOrderID, FProductID, FProdBatchNo, FOrderNumber, FCostItemID, FCostDriverID, FAllocCostDriverData ,FFinishedAmount, FEoPWIPAmount, FPlanQty, FFinishedQty, FEoPWIPQty ,FCalcLevel, FTotalFinishedQty, FTotalEoPWIPQty, FAmount, FQty, FIsSelfManufacture, FPricePrecision, FQtyPrecision, FAmountPrecision ", tblHistory};
        } else if (busiTblName.equals("T_NCM_OrderCostCalMatDetailResult_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_OrderCostCalMatDetailResult");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_OrderCostCalMatDetailResult_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FOrderID, FProductID, FProdBatchNo, FOrderNumber, FCostItemID ,FMaterialID ,FMatBatchNo ,FCostDriverID ,FAllocCostDriverData ,FFinishedQty ,FEoPWIPQty ,FFinishedAmount ,FEoPWIPAmount ,FCalcLevel, FAmount, FQty, FIsSelfManufacture, FRatio, FPricePrecision, FQtyPrecision, FAmountPrecision ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FOrderID, FProductID, FProdBatchNo, FOrderNumber, FCostItemID ,FMaterialID ,FMatBatchNo ,FCostDriverID ,FAllocCostDriverData ,FFinishedQty ,FEoPWIPQty ,FFinishedAmount ,FEoPWIPAmount ,FCalcLevel, FAmount, FQty, FIsSelfManufacture, FRatio, FPricePrecision, FQtyPrecision, FAmountPrecision ", tblHistory};
        } else if (busiTblName.equals("T_NCM_OrderCostCalActivityResult_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_OrderCostCalActivityResult");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_OrderCostCalActivityResult_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FOrderID, FProductID, FProdBatchNo, FOrderNumber, FActivityID, FCostDriverID, FAllocCostDriverData, FEoPWIPQty, FFinishedQty, FCalcLevel, FQty, FQtyPrecision ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FOrderID, FProductID, FProdBatchNo, FOrderNumber, FActivityID, FCostDriverID, FAllocCostDriverData, FEoPWIPQty, FFinishedQty, FCalcLevel, FQty, FQtyPrecision ", tblHistory};
        } else if (busiTblName.equals("T_NCM_OrderCostCalActivityDetailResult_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_OrderCostCalActivityDetailResult");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_OrderCostCalActivityDetailResult_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID, FOrderID, FProductID, FProdBatchNo, FOrderNumber, FActivityID, FCostItemID, FCostDriverID, FAllocCostDriverData, FFinishedAmount, FEoPWIPAmount, FFinishedQty, FEoPWIPQty, FCalcLevel, FAmount, FQty, FRatio, FPricePrecision, FQtyPrecision, FAmountPrecision ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID, FOrderID, FProductID, FProdBatchNo, FOrderNumber, FActivityID, FCostItemID, FCostDriverID, FAllocCostDriverData, FFinishedAmount, FEoPWIPAmount, FFinishedQty, FEoPWIPQty, FCalcLevel, FAmount, FQty, FRatio, FPricePrecision, FQtyPrecision, FAmountPrecision ", tblHistory};
        } else if (busiTblName.equals("T_NCM_Balance_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_Balance");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_Balance_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCalculatePeriodID ,FCompanyOrg ,FCostObjectID ,FCostCenterID ,FBopWIPQty ,FYTDFinishedQty,FBopWIPHour, FAdjBopWipQty,FAdjBopWipHour ", tblCurrent, "FID ,FCalculatePeriodID ,FCompanyOrg ,FCostObjectID ,FCostCenterID ,FBopWIPQty ,FYTDFinishedQty,FBopWIPHour, FAdjBopWipQty,FAdjBopWipHour ", tblHistory};
        } else if (busiTblName.equals("T_NCM_BalanceEntry_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_BalanceEntry");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_BalanceEntry_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, " FID ,FParentID ,FCostItemID ,FYTDInputAmount ,FBoPWIPAmount ,FYTDFinishAmount, FBopWIPQty, FPrice, FAdjBopWipQty, FAdjBoPWipAmount ", tblCurrent, " FID ,FParentID ,FCostItemID ,FYTDInputAmount ,FBoPWIPAmount ,FYTDFinishAmount, FBopWIPQty, FPrice, FAdjBopWipQty, FAdjBoPWipAmount ", tblHistory};
        } else if (busiTblName.equals("T_NCM_BalanceMatDetail_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_BalanceMatDetail");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_BalanceMatDetail_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, " FID ,FMaterialID ,FMaterialName ,FBatchNo ,FQty ,FPrice ,FAmount ,FYTDInputMatQty ,FYTDInputMatAmou ,FYTDFinishedMatQ ,FYTDFinishedMatA ,FParentID,FUnitID,FAssistQty,FAddqty,FIsRework, FAdjQty, FAdjAmount", tblCurrent, " FID ,FMaterialID ,FMaterialName ,FBatchNo ,FQty ,FPrice ,FAmount ,FYTDInputMatQty ,FYTDInputMatAmou ,FYTDFinishedMatQ ,FYTDFinishedMatA ,FParentID,FUnitID,FAssistQty,FAddqty,FIsRework, FAdjQty, FAdjAmount", tblHistory};
        } else if (busiTblName.equals("T_NCM_DataByCostObj_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_DataByCostObj");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_DataByCostObj_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FFinishedQty , FFinishedAssistQty , FFinishedAddQty", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FFinishedQty , FFinishedAssistQty , FFinishedAddQty", tblHistory};
        } else if (busiTblName.equals("T_NCM_DataByOrder_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_DataByOrder");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_DataByOrder_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID, FOrderID, FOrderNumber, FProductID, FProdBatchNo, FPlanQty, FEoPWIPQty, FFinishedQty, FTotalFinishedQty ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID, FOrderID, FOrderNumber, FProductID, FProdBatchNo, FPlanQty, FEoPWIPQty, FFinishedQty, FTotalFinishedQty ", tblHistory};
        } else if (busiTblName.equals("T_NCM_DataByProduct_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_DataByProduct");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_DataByProduct_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FProductID ,FLot ,FFinishedQty , FFinishedAssistQty , FFinishedAddQty", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FProductID ,FLot ,FFinishedQty , FFinishedAssistQty , FFinishedAddQty", tblHistory};
        } else if (busiTblName.equals("T_NCM_AllDataByCostObj_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_AllDataByCostObj");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_AllDataByCostObj_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FBopWIPQty,FInputQty,FFinishedQty,FEopWIPQty, FBopWIPHour ,FInputHour ,FFinishedHour,FEopWIPHour,FCoef, FAdjEopWipQty, FAdjBoPWipQty, FAdjBopWipHour, FAdjEopWipHour ", tblCurrent, "FID,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FBopWIPQty,FInputQty,FFinishedQty,FEopWIPQty, FBopWIPHour ,FInputHour ,FFinishedHour,FEopWIPHour,FCoef, FAdjEopWipQty, FAdjBoPWipQty, FAdjBopWipHour, FAdjEopWipHour ", tblHistory};
        } else if (busiTblName.equals("T_NCM_CostCalRevertInfo_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostCalRevertInfo");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostCalRevertInfo_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FCostItemID ,FSpendCostObjectID ,FSpendCostItemID ,FMaterialID ,FLot ,FAmount ,FCoef ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FCostItemID ,FSpendCostObjectID ,FSpendCostItemID ,FMaterialID ,FLot ,FAmount ,FCoef ", tblHistory};
        } else if (busiTblName.equals("T_NCM_BopWIPCoefByEnd_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_BopWIPCoefByEnd");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_BopWIPCoefByEnd_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostObjectID , FProductID, FProdBatchNo, FSubCostItemID , FSubCostObjID, FSubProductID,FSubProdBatchNo, FCostItemID ,FMaterialID ,FMatBatchNo ,FAmtCoef , FQtyCoef", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostObjectID , FProductID, FProdBatchNo, FSubCostItemID , FSubCostObjID, FSubProductID,FSubProdBatchNo, FCostItemID ,FMaterialID ,FMatBatchNo ,FAmtCoef , FQtyCoef", tblHistory};
        } else if (busiTblName.equals("T_NCM_BopInvCoefByEnd_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_BopInvCoefByEnd");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_BopInvCoefByEnd_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostObjectID , FProductID, FProdBatchNo, FCostItemID ,FMaterialID ,FMatBatchNo ,FAmtCoef , FQtyCoef ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostObjectID , FProductID, FProdBatchNo, FCostItemID ,FMaterialID ,FMatBatchNo ,FAmtCoef , FQtyCoef ", tblHistory};
        } else if (busiTblName.equals("T_NCM_CostRecoveryReportByEnd_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostRecoveryReportByEnd");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostRecoveryReportByEnd_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostObjectID , FProductID, FCostItemGroupID, FCostItemID,FMaterialID, FPeriodDispNumber,FProductNumber,FProductName,FProdBatchNo,FProductModel,FProductUnitName,FCostItemGroupNumber,FCostItemGroupName,FCostItemNumber,FCostItemName,FMaterialNumber,FMaterialName,FMatBatchNo,FMaterielModel,FMaterielUnitName,FBeforeQty,FBeforeAmount,FSFPQty,FSFPAmount,FProcessQty,FProcessAmount,FAfterQty,FAfterAmount,FAfterUnitQty,FAfterUnitAmount,FAfterUnitRatio,FQtyDecimal,FPriceDecimal,FAmountDecimal,FTotalRow ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostObjectID , FProductID, FCostItemGroupID, FCostItemID,FMaterialID, FPeriodDispNumber,FProductNumber,FProductName,FProdBatchNo,FProductModel,FProductUnitName,FCostItemGroupNumber,FCostItemGroupName,FCostItemNumber,FCostItemName,FMaterialNumber,FMaterialName,FMatBatchNo,FMaterielModel,FMaterielUnitName,FBeforeQty,FBeforeAmount,FSFPQty,FSFPAmount,FProcessQty,FProcessAmount,FAfterQty,FAfterAmount,FAfterUnitQty,FAfterUnitAmount,FAfterUnitRatio,FQtyDecimal,FPriceDecimal,FAmountDecimal,FTotalRow ", tblHistory};
        } else if (busiTblName.equals("T_NCM_BopWIPCoefByStep_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_BopWIPCoefByStep");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_BopWIPCoefByStep_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostObjectID , FProductID, FProdBatchNo, FSubCostItemID , FSubCostObjID, FSubProductID,FSubProdBatchNo, FCostItemID ,FMaterialID ,FMatBatchNo ,FAmtCoef , FQtyCoef, FLayer, FDispLayer, FIsLeaf, FBranch ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostObjectID , FProductID, FProdBatchNo, FSubCostItemID , FSubCostObjID, FSubProductID,FSubProdBatchNo, FCostItemID ,FMaterialID ,FMatBatchNo ,FAmtCoef , FQtyCoef, FLayer, FDispLayer, FIsLeaf, FBranch ", tblHistory};
        } else if (busiTblName.equals("T_NCM_BopInvCoefByStep_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_BopInvCoefByStep");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_BopInvCoefByStep_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostObjectID , FProductID, FProdBatchNo, FCostItemID ,FMaterialID ,FMatBatchNo ,FAmtCoef , FQtyCoef, FLayer, FDispLayer, FIsLeaf, FBranch ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostObjectID , FProductID, FProdBatchNo, FCostItemID ,FMaterialID ,FMatBatchNo ,FAmtCoef , FQtyCoef, FLayer, FDispLayer, FIsLeaf, FBranch ", tblHistory};
        } else if (busiTblName.equals("T_NCM_CostRecoveryReportByStep_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostRecoveryReportByStep");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostRecoveryReportByStep_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostObjectID , FProductID, FCostItemGroupID, FCostItemID,FMaterialID, FPeriodDispNumber,FProductNumber,FProductName,FProdBatchNo,FProductModel,FProductUnitName,FCostItemGroupNumber,FCostItemGroupName,FCostItemNumber,FCostItemName,FMaterialNumber,FMaterialName,FMatBatchNo,FMaterielModel,FMaterielUnitName,FFinishedQty,FFinishedAmount,FFinishedUnitQty,FFinishedUnitAmount,FFinishedUnitRatio,FQtyDecimal,FPriceDecimal,FAmountDecimal,FTotalRow, FSort, FLayer, FDispLayer, FIsLeaf, FBranch, FParentID", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostObjectID , FProductID, FCostItemGroupID, FCostItemID,FMaterialID, FPeriodDispNumber,FProductNumber,FProductName,FProdBatchNo,FProductModel,FProductUnitName,FCostItemGroupNumber,FCostItemGroupName,FCostItemNumber,FCostItemName,FMaterialNumber,FMaterialName,FMatBatchNo,FMaterielModel,FMaterielUnitName,FFinishedQty,FFinishedAmount,FFinishedUnitQty,FFinishedUnitAmount,FFinishedUnitRatio,FQtyDecimal,FPriceDecimal,FAmountDecimal,FTotalRow, FSort, FLayer, FDispLayer, FIsLeaf, FBranch, FParentID", tblHistory};
        } else if (busiTblName.equals("T_NCM_CostRecoveryVourchData_View")) {
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostRecoveryVourchData");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_CostRecoveryVourchData_History");
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            param = new Object[]{tblName, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FProductID ,FLot ,FCostItemID ,FRecvQty,FRecvAmount,FVoucherid ", tblCurrent, "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FProductID ,FLot ,FCostItemID ,FRecvQty,FRecvAmount,FVoucherid ", tblHistory};
        } else if (busiTblName.equals("T_NCM_STDCostBomPath")) {
            sql = "CREATE TABLE {0} ( FStorageOrgUnitID  VARCHAR(44),FBomID             VARCHAR(44),FParentMaterialID  VARCHAR(44),FMaterialID        VARCHAR(44),FBomPath           NVARCHAR(1500),FBomEntryID        VARCHAR(44),FLevelCode         SMALLINT,FIsNest            SMALLINT)";
        } else if (busiTblName.equals("T_NCM_STDCostDataMatDetail") || busiTblName.equals("T_NCM_STDCostRollUpMat")) {
            sql = "CREATE TABLE {0} ( FComapnyOrg         VARCHAR(44), FCalculatePeriod    VARCHAR(44), FStorageOrgUnitID   VARCHAR(44), FEstimateSchemeID   VARCHAR(44), FParentMaterialID   VARCHAR(44), FParentCostObjectID VARCHAR(44), FEstimateType       SMALLINT, FStdPrice           NUMERIC(21,8), FMaterialID         VARCHAR(44), FMeasureUnitID      VARCHAR(44), FCostObjectID       VARCHAR(44), FChildCostItemID    VARCHAR(44), FChildQty           NUMERIC(21,8), FChildStdPrice      NUMERIC(21,8), FChildAmount        NUMERIC(21,8), FLowLevelCode       INT, FSpreadPath         NVARCHAR(1200), FID                 VARCHAR(44)   NOT NULL, CONSTRAINT {1} PRIMARY KEY ( FID ))";
        } else if (busiTblName.equals("T_NCM_STDCostDataResDetail") || busiTblName.equals("T_NCM_STDCostRollUpRes")) {
            sql = "CREATE TABLE {0} ( FCompanyOrg         VARCHAR(44), FCalculatePeriod    VARCHAR(44), FStorageOrgUnitID   VARCHAR(44), FEstimateSchemeID   VARCHAR(44), FParentMaterialID   VARCHAR(44), FParentCostObjectID VARCHAR(44), FStdPrice           NUMERIC(21,8), FResourceTypeID     VARCHAR(44), FResMeasureUnitID   VARCHAR(44), FResCostItemID      VARCHAR(44), FResQty             NUMERIC(21,8), FResStdPrice        NUMERIC(21,8), FResAmount          NUMERIC(21,8), FID                 VARCHAR(44)   NOT NULL, CONSTRAINT {1} PRIMARY KEY ( FID ))";
        } else if (busiTblName.equals("T_NCM_STDCostLowLevelCode")) {
            sql = "CREATE TABLE {0} ( FStorageOrgUnitID VARCHAR(44), FMaterialID       VARCHAR(44), FLowLevelCode     INT, FID               VARCHAR(44)   NOT NULL, CONSTRAINT {1} PRIMARY KEY ( FID ))";
        } else if (busiTblName.equals("T_NCM_DynCostCalResult") || busiTblName.equals("T_NCM_DynCostCalResult_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FCostItemID VARCHAR(44),FAllocStdID VARCHAR(44),FAllocStdData NUMERIC(24,12),FFinishedAmount NUMERIC(17,4),FEoPWIPAmount NUMERIC(17,4),FRecvAmount NUMERIC(17,4),FFinishedQty NUMERIC(21,8) DEFAULT 0, FEoPWIPQty NUMERIC(21,8) DEFAULT 0,FCalcLevel INT,FFinishedAssistQty NUMERIC(21,10),FFinishedAddqty NUMERIC(21,10),FEoPWIPAssistQty NUMERIC(21,10),FEoPWIPAddqty NUMERIC(21,10),FAdjEoPWipQty NUMERIC(21,8), FAdjEoPWipAmount NUMERIC(17,4),  CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_DynCostCalMatDetailResult") || busiTblName.equals("T_NCM_DynCostCalMatDetailResult_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FCostItemID VARCHAR(44),FMaterialID VARCHAR(44),FLot NVARCHAR(80),FAllocStdID VARCHAR(44),FAllocStdData NUMERIC(24,12),FFinishedQty NUMERIC(21,8),FEoPWIPQty NUMERIC(21,8),FFinishedAmount NUMERIC(17,4),FEoPWIPAmount NUMERIC(17,4),FCalcLevel INT,FFinishedAssistQty NUMERIC(21,10),FFinishedAddqty NUMERIC(21,10),FEoPWIPAssistQty NUMERIC(21,10),FEoPWIPAddqty NUMERIC(21,10),FIsReWork INT  NOT NULL DEFAULT 0, FAdjEoPWipQty NUMERIC(21,8),FAdjEoPWipAmount NUMERIC(17,4),CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_DynCostCalPrdDetailResult") || busiTblName.equals("T_NCM_DynCostCalPrdDetailResult_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FLot NVARCHAR(80),FCostItemID VARCHAR(44),FAllocStdID VARCHAR(44),FAllocStdData NUMERIC(24,12),FFinishedQty NUMERIC(21,8),FFinishedAmount NUMERIC(17,4),FFinishedPrice NUMERIC(21,8),FRecvQty NUMERIC(21,8),FRecvAmount NUMERIC(17,4),FTotalFinishedQty NUMERIC(21,8),FVoucherid VARCHAR(44),FCalcLevel INT, FTempAmount NUMERIC(17,4), CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_DynDataByCostObj") || busiTblName.equals("T_NCM_DynDataByCostObj_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FFinishedQty NUMERIC(21,8),  FFinishedAssistQty NUMERIC(21,8) , FFinishedAddQty NUMERIC(21,8),CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_DynDataByProduct") || busiTblName.equals("T_NCM_DynDataByProduct_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FProductID VARCHAR(44),FLot NVARCHAR(80),FFinishedQty NUMERIC(21,8), FFinishedAssistQty  NUMERIC(21,8) , FFinishedAddQty NUMERIC(21,8),CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_WIPCountingAllocResult") || busiTblName.equals("T_NCM_WIPCountingAllocResult_History")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44), FCalculatePeriodID VARCHAR(44), FCostCenterid VARCHAR(44), FMaterialID VARCHAR(44), FLot VARCHAR(80), FCostItemId VARCHAR(44), FCostObjectId VARCHAR(44), FWIPCoefAmount NUMERIC(21,8) DEFAULT 0 , FWIPCoefQty NUMERIC(21,8) DEFAULT 0 , FUnitID VARCHAR(44), FAllocCoefficient NUMERIC(21,8) DEFAULT 0 , FAllocAmount NUMERIC(21,8) DEFAULT 0 , FBaseQty NUMERIC(21,8) DEFAULT 0 , FBasePrice NUMERIC(21,8) DEFAULT 0 , FCommonQty NUMERIC(21,8) DEFAULT 0 , FCommonPrice NUMERIC(21,8) DEFAULT 0 , FAssistQty NUMERIC(21,8) DEFAULT 0 , FAssistPrice NUMERIC(21,8) DEFAULT 0 , FIsDirect INT, CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_WIPCountingAllocResult_View")) {
            sql = "create view {0} As Select {1} from {2} Union Select {3} from {4} ";
            tblCurrent = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_WIPCountingAllocResult");
            tblHistory = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_WIPCountingAllocResult_History");
            param = new Object[]{tblName, "FID, FCompanyID, FCalculatePeriodID , FCostCenterid, FMaterialID, FLot, FCostItemId, FCostObjectId, FWIPCoefAmount, FWIPCoefQty, FUnitID, FAllocCoefficient, FAllocAmount, FBaseQty, FBasePrice, FCommonQty, FCommonPrice, FAssistQty, FAssistPrice, FIsDirect", tblCurrent, "FID, FCompanyID, FCalculatePeriodID , FCostCenterid, FMaterialID, FLot, FCostItemId, FCostObjectId, FWIPCoefAmount, FWIPCoefQty, FUnitID, FAllocCoefficient, FAllocAmount, FBaseQty, FBasePrice, FCommonQty, FCommonPrice, FAssistQty, FAssistPrice, FIsDirect", tblHistory};
        } else if (busiTblName.equals("T_NCM_CostCalProcess")) {
            sql = "Create Table {0} ( FFunction VARCHAR(44), FMainProcess INT, FLowRankStep INT, FDetailProcess INT, FDescription NVARCHAR(255), FProcessDate DateTime)";
        } else if (busiTblName.equals("T_NCM_OrderCostCalProcess")) {
            sql = "Create Table {0} ( FFunction VARCHAR(44), FMainProcess INT, FLowRankStep INT, FDetailProcess INT, FDescription NVARCHAR(255), FProcessDate DateTime)";
        } else if (busiTblName.equals("T_NCM_OSBomPath")) {
            sql = "CREATE TABLE {0} ( FStorageOrgUnitID  VARCHAR(44),FParentMaterialID  VARCHAR(44),FBomID             VARCHAR(44),FOrderID           VARCHAR(44),FProjectID         VARCHAR(44),FTrackID           VARCHAR(44),FMaterialID        VARCHAR(44),FBomEntryID        VARCHAR(44),FBomPath           NVARCHAR(1500),FLevelCode         SMALLINT,FIsNest            SMALLINT)";
        } else if (busiTblName.equals("T_NCM_OSLowLevelCode")) {
            sql = "CREATE TABLE {0} ( FMaterialID       VARCHAR(44), FLowLevelCode     INT, FID               VARCHAR(44)   NOT NULL, CONSTRAINT {1} PRIMARY KEY ( FID ))";
        } else if (busiTblName.equals("T_NCM_OSMaterialDetail") || busiTblName.equals("T_NCM_OSMaterialRollUp")) {
            sql = "CREATE TABLE {0} ( FCompanyID          VARCHAR(44), FStorageOrgUnitID   VARCHAR(44), FCostTypeID         VARCHAR(44), FParentMaterialID   VARCHAR(44), FBomID              VARCHAR(44), FOrderID            VARCHAR(44), FProjectID          VARCHAR(44),FTrackID            VARCHAR(44),FStdPrice           NUMERIC(21,8),FMaterialID         VARCHAR(44), FBomEntryID         VARCHAR(44),FMeasureUnitID      VARCHAR(44), FChildCostItemID    VARCHAR(44), FChildQty           NUMERIC(21,8),FChildStdPrice      NUMERIC(21,8),FChildAmount        NUMERIC(21,8),FLowLevelCode       INT, FSpreadPath         NVARCHAR(1200), FID                 VARCHAR(44)   NOT NULL, CONSTRAINT {1} PRIMARY KEY ( FID ))";
        } else if (busiTblName.equals("T_NCM_OSActivityDetail") || busiTblName.equals("T_NCM_OSActivityRollUp")) {
            sql = "CREATE TABLE {0} ( FCompanyID          VARCHAR(44), FStorageOrgUnitID   VARCHAR(44), FCostTypeID         VARCHAR(44), FParentMaterialID   VARCHAR(44), FOrderID            VARCHAR(44), FProjectID          VARCHAR(44),FTrackID            VARCHAR(44),FStdPrice           NUMERIC(21,8),FActivityChainID    VARCHAR(44), FActivityID         VARCHAR(44), FActMeasureUnitID   VARCHAR(44), FActCostItemID      VARCHAR(44), FActQty             NUMERIC(21,8),FActStdPrice        NUMERIC(21,8),FActAmount          NUMERIC(21,8),FID                 VARCHAR(44)   NOT NULL, CONSTRAINT {1} PRIMARY KEY ( FID ))";
        } else if (busiTblName.equals("T_NCM_LOG_ORDERCCO")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FErrorInfo NVARCHAR(500),FPossibleReason NVARCHAR(500),FAdviceHandle NVARCHAR(500),FLogTime DateTime,CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_LOG_OCCC2Activity")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FErrorInfo NVARCHAR(500),FPossibleReason NVARCHAR(500),FAdviceHandle NVARCHAR(500),FLogTime DateTime,CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_OCCC2ActivityAlloc")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCostCenterID VARCHAR(44),FSourceBillID VARCHAR(44), FSourceBillEntryID VARCHAR(44), FExpenseID VARCHAR(44),FDepartmentID VARCHAR(44),FCostItemID VARCHAR(44),FCostDriverID VARCHAR(44),FCostDriverAmount NUMERIC(28,10),FActivityID VARCHAR(44),FOrderID VARCHAR(44),FPrice NUMERIC(28,10) DEFAULT 0,FActivitQty NUMERIC(28,10) DEFAULT 0,FAmount NUMERIC(28,10) DEFAULT 0,FCreatorID VARCHAR(44),FCreateTime DateTime,FAdjustUserID VARCHAR(44),FAdjustTime DateTime,FIsDirect VARCHAR(44),CONSTRAINT {1} PRIMARY KEY (FID))";
        } else if (busiTblName.equals("T_NCM_OCActivity2OrderAlloc")) {
            sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FCalculatePeriodID VARCHAR(44),FCC2ActivityID VARCHAR(44),FCostCenterID VARCHAR(44),FExpenseID VARCHAR(44),FDepartmentID VARCHAR(44),FCostItemID VARCHAR(44),FCostDriverID VARCHAR(44),FCostDriverAmount NUMERIC(28,10),FActivityID VARCHAR(44),FOrderID VARCHAR(44),FOrderProdID VARCHAR(44), FOrderProdBatchNo NVARCHAR(80), FOrderNumber NVARCHAR(80), FStorageOrgUnitID VARCHAR(44),FPrice NUMERIC(28,10) DEFAULT 0,FOrderQty NUMERIC(28,10) DEFAULT 0,FAmount NUMERIC(28,10) DEFAULT 0,FCreatorID VARCHAR(44),FCreateTime DateTime,FAdjustUserID VARCHAR(44),FAdjustTime DateTime,FIsDirect VARCHAR(44),CONSTRAINT {1} PRIMARY KEY (FID))";
        }
        if (sql != null) {
            if (param == null) {
                param = tblPkName == null ? new Object[]{tblName} : new Object[]{tblName, tblPkName};
            }
            sql = MessageFormat.format(sql, param);
            String dbTypeName = (String)ctx.get((Object)"dbType");
            int CurrentDataBaseType = DbType.getValue((String)dbTypeName);
            if ((CurrentDataBaseType == 2 || CurrentDataBaseType == 7 || CurrentDataBaseType == 8) && sql.indexOf("Create Table") >= 0 && sql.substring(sql.length() - 1).equals(")")) {
                String SelDefine = null;
                try {
                    SelDefine = TransUtil.Translate((String)sql, (int)CurrentDataBaseType);
                }
                catch (SqlTranslateException e) {
                    throw new BOSException(e.getMessage());
                }
                sql = "/*dialect*/" + SelDefine + " nologging ";
            }
            NCMDbUtil.execute(ctx, sql);
            return true;
        }
        return false;
    }

    private static void checkBusiTblName(String busiTblName) {
        Assert.that((busiTblName.equals("T_NCM_MatAllocResult") || busiTblName.equals("T_NCM_OtherAllocResult") || busiTblName.equals("T_NCM_AuxAllocResult") || busiTblName.equals("T_NCM_LinearEquations") || busiTblName.equals("T_NCM_AugmentedMatrix") || busiTblName.equals("T_NCM_CostCalResult") || busiTblName.equals("T_NCM_CostCalMatDetailResult") || busiTblName.equals("T_NCM_CostCalPrdDetailResult") || busiTblName.equals("T_NCM_OrderCostCalResult") || busiTblName.equals("T_NCM_OrderCostCalMatDetailResult") || busiTblName.equals("T_NCM_OrderCostCalActivityResult") || busiTblName.equals("T_NCM_OrderCostCalActivityDetailResult") || busiTblName.equals("T_NCM_OrderCostCalResult_History") || busiTblName.equals("T_NCM_OrderCostCalMatDetailResult_History") || busiTblName.equals("T_NCM_OrderCostCalActivityResult_History") || busiTblName.equals("T_NCM_OrderCostCalActivityDetailResult_History") || busiTblName.equals("T_NCM_OrderCostCalResult_View") || busiTblName.equals("T_NCM_OrderCostCalMatDetailResult_View") || busiTblName.equals("T_NCM_OrderCostCalActivityResult_View") || busiTblName.equals("T_NCM_OrderCostCalActivityDetailResult_View") || busiTblName.equals("T_NCM_Balance") || busiTblName.equals("T_NCM_BalanceEntry") || busiTblName.equals("T_NCM_BalanceMatDetail") || busiTblName.equals("T_NCM_Balance_History") || busiTblName.equals("T_NCM_BalanceEntry_History") || busiTblName.equals("T_NCM_BalanceMatDetail_History") || busiTblName.equals("T_NCM_MatAllocResult_History") || busiTblName.equals("T_NCM_OtherAllocResult_History") || busiTblName.equals("T_NCM_AuxAllocResult_History") || busiTblName.equals("T_NCM_LinearEquations_History") || busiTblName.equals("T_NCM_AugmentedMatrix_History") || busiTblName.equals("T_NCM_CostCalResult_History") || busiTblName.equals("T_NCM_CostCalMatDetailResult_History") || busiTblName.equals("T_NCM_CostCalPrdDetailResult_History") || busiTblName.equals("T_NCM_OtherAllocResult_View") || busiTblName.equals("T_NCM_MatAllocResult_View") || busiTblName.equals("T_NCM_AuxAllocResult_View") || busiTblName.equals("T_NCM_LinearEquations_View") || busiTblName.equals("T_NCM_AugmentedMatrix_View") || busiTblName.equals("T_NCM_CostCalResult_View") || busiTblName.equals("T_NCM_CostCalMatDetailResult_View") || busiTblName.equals("T_NCM_CostCalPrdDetailResult_View") || busiTblName.equals("T_NCM_CostCalReportPreTreatState") || busiTblName.equals("T_NCM_CostCalReportPreTreatData") || busiTblName.equals("T_NCM_YearSumAmountData") || busiTblName.equals("T_NCM_YearSumQtyData") || busiTblName.equals("T_NCM_Balance_View") || busiTblName.equals("T_NCM_BalanceEntry_View") || busiTblName.equals("T_NCM_BalanceMatDetail_View") || busiTblName.equals("T_NCM_LOG_Mat") || busiTblName.equals("T_NCM_LOG_Other") || busiTblName.equals("T_NCM_LOG_CCO") || busiTblName.equals("T_NCM_LOG_OtherInWH") || busiTblName.equals("T_NCM_LOG_CostAdjust") || busiTblName.equals("T_NCM_DataByCostObj") || busiTblName.equals("T_NCM_DataByCostObj_History") || busiTblName.equals("T_NCM_DataByCostObj_View") || busiTblName.equals("T_NCM_DataByOrder") || busiTblName.equals("T_NCM_DataByOrder_History") || busiTblName.equals("T_NCM_DataByOrder_View") || busiTblName.equals("T_NCM_LotMapping") || busiTblName.equals("T_NCM_DataByProduct") || busiTblName.equals("T_NCM_DataByProduct_History") || busiTblName.equals("T_NCM_DataByProduct_View") || busiTblName.equals("T_NCM_AllDataByCostObj") || busiTblName.equals("T_NCM_AllDataByCostObj_History") || busiTblName.equals("T_NCM_AllDataByCostObj_View") || busiTblName.equals("T_NCM_CostCalRevertInfo") || busiTblName.equals("T_NCM_CostCalRevertInfo_History") || busiTblName.equals("T_NCM_CostCalRevertInfo_View") || busiTblName.equals("T_NCM_MatAllocResult_Adjust") || busiTblName.equals("T_NCM_OtherAllocResult_Adjust") || busiTblName.equals("T_NCM_CCOAllocResult_Adjust") || busiTblName.equals("T_NCM_BopWIPCoefByEnd") || busiTblName.equals("T_NCM_BopWIPCoefByEnd_History") || busiTblName.equals("T_NCM_BopWIPCoefByEnd_View") || busiTblName.equals("T_NCM_BopInvCoefByEnd") || busiTblName.equals("T_NCM_BopInvCoefByEnd_History") || busiTblName.equals("T_NCM_BopInvCoefByEnd_View") || busiTblName.equals("T_NCM_CostRecoveryReportByEnd") || busiTblName.equals("T_NCM_CostRecoveryReportByEnd_History") || busiTblName.equals("T_NCM_CostRecoveryReportByEnd_View") || busiTblName.equals("T_NCM_BopWIPCoefByStep") || busiTblName.equals("T_NCM_BopWIPCoefByStep_History") || busiTblName.equals("T_NCM_BopWIPCoefByStep_View") || busiTblName.equals("T_NCM_BopInvCoefByStep") || busiTblName.equals("T_NCM_BopInvCoefByStep_History") || busiTblName.equals("T_NCM_BopInvCoefByStep_View") || busiTblName.equals("T_NCM_CostRecoveryReportByStep") || busiTblName.equals("T_NCM_CostRecoveryReportByStep_History") || busiTblName.equals("T_NCM_CostRecoveryReportByStep_View") || busiTblName.equals("T_NCM_InitSemifinishedProdCoefByEnd") || busiTblName.equals("T_NCM_InitSemifinishedProdCoefByStep") || busiTblName.equals("T_NCM_RecoveryTreeBranchNode") || busiTblName.equals("T_NCM_RecoveryTreeBranchNode_SEQ") || busiTblName.equals("T_NCM_CostRecoveryVourchData") || busiTblName.equals("T_NCM_CostRecoveryVourchData_History") || busiTblName.equals("T_NCM_CostRecoveryVourchData_View") || busiTblName.equals("T_NCM_STDCostBomPath") || busiTblName.equals("T_NCM_STDCostDataMatDetail") || busiTblName.equals("T_NCM_STDCostRollUpMat") || busiTblName.equals("T_NCM_STDCostDataResDetail") || busiTblName.equals("T_NCM_STDCostRollUpRes") || busiTblName.equals("T_NCM_STDCostLowLevelCode") || busiTblName.equals("T_NCM_DynMatAllocResult") || busiTblName.equals("T_NCM_DynMatAllocResult_Adjust") || busiTblName.equals("T_NCM_DynMatAllocResult_History") || busiTblName.equals("T_NCM_DynCostCalResult") || busiTblName.equals("T_NCM_DynCostCalResult_History") || busiTblName.equals("T_NCM_DynCostCalMatDetailResult") || busiTblName.equals("T_NCM_DynCostCalMatDetailResult_History") || busiTblName.equals("T_NCM_DynCostCalPrdDetailResult") || busiTblName.equals("T_NCM_DynCostCalPrdDetailResult_History") || busiTblName.equals("T_NCM_DynDataByCostObj") || busiTblName.equals("T_NCM_DynDataByCostObj_History") || busiTblName.equals("T_NCM_DynDataByProduct") || busiTblName.equals("T_NCM_DynDataByProduct_History") || busiTblName.equals("T_NCM_DynOtherAllocResult") || busiTblName.equals("T_NCM_DynOtherAllocResult_Adjust") || busiTblName.equals("T_NCM_DynOtherAllocResult_History") || busiTblName.equals("T_NCM_LOG_DynMat") || busiTblName.equals("T_NCM_LOG_DynOther") || busiTblName.equals("T_NCM_WIPCountingAllocResult") || busiTblName.equals("T_NCM_WIPCountingAllocResult_History") || busiTblName.equals("T_NCM_WIPCountingAllocResult_View") || busiTblName.equals("T_NCM_CostCalProcess") || busiTblName.equals("T_NCM_OrderCostCalProcess") || busiTblName.equals("T_NCM_OSBomPath") || busiTblName.equals("T_NCM_OSLowLevelCode") || busiTblName.equals("T_NCM_OSMaterialDetail") || busiTblName.equals("T_NCM_OSMaterialRollUp") || busiTblName.equals("T_NCM_OSActivityDetail") || busiTblName.equals("T_NCM_OSActivityRollUp") || busiTblName.equals("T_NCM_LOG_ORDERCCO") || busiTblName.equals("T_NCM_LOG_OCCC2Activity") || busiTblName.equals("T_NCM_OCCC2ActivityAlloc") || busiTblName.equals("T_NCM_OCActivity2OrderAlloc") ? 1 : 0) != 0);
    }

    private static void updateIndexs(Context ctx, String companyId, String busiTblName, String physicalTblName, NCMDynamicTableMapInfo tblMap) throws EASBizException, BOSException, SQLException {
        Assert.that((physicalTblName != null ? 1 : 0) != 0);
        NCMDynamicTableMapEntryCollection idxs = tblMap.getEntries();
        StringBuffer sb = new StringBuffer();
        String sql = null;
        String indexName = null;
        String indexColumns = null;
        if (busiTblName.equals("T_NCM_MatAllocResult") || busiTblName.equals("T_NCM_MatAllocResult_History")) {
            indexColumns = "FCompanyID,FCalculatePeriodID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCompanyID ASC,FCalculatePeriodID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostCenterID,FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC,FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FSourceBillID,FSourceBillEntryID")) {
                sql = "CREATE INDEX {0} ON {1} (FSourceBillID ASC,FSourceBillEntryID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_OtherAllocResult") || busiTblName.equals("T_NCM_OtherAllocResult_History")) {
            indexColumns = "FCompanyID,FCalculatePeriodID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCompanyID ASC,FCalculatePeriodID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostCenterID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FSourceBillID,FSourceBillEntryID")) {
                sql = "CREATE INDEX {0} ON {1} (FSourceBillID ASC,FSourceBillEntryID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostItemID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostItemID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_AuxAllocResult") || busiTblName.equals("T_NCM_AuxAllocResult_History")) {
            indexColumns = "FExpenseID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FExpenseID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostItemID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostItemID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FSourceBillID")) {
                sql = "CREATE INDEX {0} ON {1} (FSourceBillID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FSourceBillEntryID")) {
                sql = "CREATE INDEX {0} ON {1} (FSourceBillEntryID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_LinearEquations") || busiTblName.equals("T_NCM_LinearEquations_History")) {
            indexColumns = "FCostObjectID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID,FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostItemID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostItemID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_AugmentedMatrix") || busiTblName.equals("T_NCM_AugmentedMatrix_History")) {
            indexColumns = "FParentID,FUnkownNumber";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FParentID,FUnkownNumber ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_CostCalResult") || busiTblName.equals("T_NCM_CostCalResult_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostItemID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostItemID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_CostCalReportPreTreatData")) {
            indexColumns = "FCostCenterID,FCostObjectID,FCostItemID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC,FCostObjectID ASC,FCostItemID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FPeriodId,FIsHistoryData")) {
                sql = "CREATE INDEX {0} ON {1} (FPeriodId ASC,FIsHistoryData ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_YearSumAmountData")) {
            indexColumns = "FCostCenterID,FCostObjectID,FCostItemID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC,FCostObjectID ASC,FCostItemID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCalculatePeriodID")) {
                sql = "CREATE INDEX {0} ON {1} (FCalculatePeriodID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_YearSumQtyData")) {
            indexColumns = "FCostCenterID,FCostObjectID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC,FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCalculatePeriodID")) {
                sql = "CREATE INDEX {0} ON {1} (FCalculatePeriodID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_CostCalMatDetailResult") || busiTblName.equals("T_NCM_CostCalMatDetailResult_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_CostCalPrdDetailResult") || busiTblName.equals("T_NCM_CostCalPrdDetailResult_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FProductID")) {
                sql = "CREATE INDEX {0} ON {1} (FProductID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_OrderCostCalResult") || busiTblName.equals("T_NCM_OrderCostCalResult_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FOrderID")) {
                sql = "CREATE INDEX {0} ON {1} (FOrderID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FProductID")) {
                sql = "CREATE INDEX {0} ON {1} (FProductID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_OrderCostCalMatDetailResult") || busiTblName.equals("T_NCM_OrderCostCalMatDetailResult_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FOrderID")) {
                sql = "CREATE INDEX {0} ON {1} (FOrderID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FProductID")) {
                sql = "CREATE INDEX {0} ON {1} (FProductID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_OrderCostCalActivityResult") || busiTblName.equals("T_NCM_OrderCostCalActivityResult_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FOrderID")) {
                sql = "CREATE INDEX {0} ON {1} (FOrderID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FProductID")) {
                sql = "CREATE INDEX {0} ON {1} (FProductID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FActivityID")) {
                sql = "CREATE INDEX {0} ON {1} (FActivityID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_OrderCostCalActivityDetailResult") || busiTblName.equals("T_NCM_OrderCostCalActivityDetailResult_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FOrderID")) {
                sql = "CREATE INDEX {0} ON {1} (FOrderID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FProductID")) {
                sql = "CREATE INDEX {0} ON {1} (FProductID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_Balance") || busiTblName.equals("T_NCM_Balance_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_BalanceMatDetail") || busiTblName.equals("T_NCM_BalanceMatDetail_History")) {
            indexColumns = "FMaterialID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_DataByCostObj") || busiTblName.equals("T_NCM_DataByCostObj_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_DataByOrder") || busiTblName.equals("T_NCM_DataByOrder_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FOrder")) {
                sql = "CREATE INDEX {0} ON {1} (FOrderID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FProductID")) {
                sql = "CREATE INDEX {0} ON {1} (FProductID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_DataByProduct") || busiTblName.equals("T_NCM_DataByProduct_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_AllDataByCostObj") || busiTblName.equals("T_NCM_AllDataByCostObj_History")) {
            indexColumns = "FCompanyID,FCalculatePeriodID,FCostCenterID,FCostObjectID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCompanyID ASC,FCalculatePeriodID ASC,FCostCenterID ASC,FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_BopWIPCoefByEnd") || busiTblName.equals("T_NCM_BopWIPCoefByEnd_History")) {
            indexColumns = "FCalculatePeriodID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCalculatePeriodID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FProductID,FProdBatchNo")) {
                sql = "CREATE INDEX {0} ON {1} (FProductID ASC, FProdBatchNo ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FSubCostObjID,FSubProductID, FSubProdBatchNo,FSubCostItemID")) {
                sql = "CREATE INDEX {0} ON {1} (FSubCostObjID ASC,FSubProductID ASC, FSubProdBatchNo ASC,FSubCostItemID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_BopInvCoefByEnd") || busiTblName.equals("T_NCM_BopInvCoefByEnd_History")) {
            indexColumns = "FCalculatePeriodID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCalculatePeriodID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FProductID,FProdBatchNo")) {
                sql = "CREATE INDEX {0} ON {1} (FProductID ASC, FProdBatchNo ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_InitSemifinishedProdCoefByEnd")) {
            indexColumns = "FCostObjectID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FProductID,FProdBatchNo")) {
                sql = "CREATE INDEX {0} ON {1} (FProductID ASC, FProdBatchNo ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_BopWIPCoefByStep") || busiTblName.equals("T_NCM_BopWIPCoefByStep_History")) {
            indexColumns = "FCalculatePeriodID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCalculatePeriodID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FProductID,FProdBatchNo")) {
                sql = "CREATE INDEX {0} ON {1} (FProductID ASC, FProdBatchNo ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FSubCostObjID,FSubProductID,FSubProdBatchNo,FSubCostItemID")) {
                sql = "CREATE INDEX {0} ON {1} (FSubCostObjID ASC,FSubProductID ASC, FSubProdBatchNo ASC,FSubCostItemID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FBranch")) {
                sql = "CREATE INDEX {0} ON {1} (FBranch ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_BopInvCoefByStep") || busiTblName.equals("T_NCM_BopInvCoefByStep_History")) {
            indexColumns = "FCalculatePeriodID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCalculatePeriodID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FProductID,FProdBatchNo")) {
                sql = "CREATE INDEX {0} ON {1} (FProductID ASC, FProdBatchNo ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FBranch")) {
                sql = "CREATE INDEX {0} ON {1} (FBranch ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_InitSemifinishedProdCoefByStep")) {
            indexColumns = "FCostObjectID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FProductID,FProdBatchNo")) {
                sql = "CREATE INDEX {0} ON {1} (FProductID ASC, FProdBatchNo ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FBranch")) {
                sql = "CREATE INDEX {0} ON {1} (FBranch ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_STDCostBomPath")) {
            indexColumns = "FStorageOrgUnitID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FStorageOrgUnitID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FParentMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FParentMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FBomID,FBomEntryID")) {
                sql = "CREATE INDEX {0} ON {1} (FBomID,FBomEntryID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FBomPath")) {
                sql = "CREATE INDEX {0} ON {1} (FBomPath ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_STDCostLowLevelCode")) {
            indexColumns = "FMaterialID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_STDCostRollUpMat")) {
            indexColumns = "FParentMaterialID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FParentMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FSpreadPath")) {
                sql = "CREATE INDEX {0} ON {1} (FSpreadPath ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_STDCostDataMatDetail")) {
            indexColumns = "FEstimateSchemeID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FEstimateSchemeID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FParentMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FParentMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_STDCostRollUpRes")) {
            indexColumns = "FParentMaterialID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FParentMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FResourceTypeID")) {
                sql = "CREATE INDEX {0} ON {1} (FResourceTypeID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_STDCostDataResDetail")) {
            indexColumns = "FEstimateSchemeID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FEstimateSchemeID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FParentMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FParentMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FResourceTypeID")) {
                sql = "CREATE INDEX {0} ON {1} (FResourceTypeID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_DynMatAllocResult") || busiTblName.equals("T_NCM_DynMatAllocResult_Adjust") || busiTblName.equals("T_NCM_DynMatAllocResult_History")) {
            indexColumns = "FCompanyID,FCalculatePeriodID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCompanyID ASC,FCalculatePeriodID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostCenterID,FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC,FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FSourceBillID,FSourceBillEntryID")) {
                sql = "CREATE INDEX {0} ON {1} (FSourceBillID ASC,FSourceBillEntryID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_DynCostCalResult") || busiTblName.equals("T_NCM_DynCostCalResult_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_DynCostCalMatDetailResult") || busiTblName.equals("T_NCM_DynCostCalMatDetailResult_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_DynCostCalPrdDetailResult") || busiTblName.equals("T_NCM_DynCostCalPrdDetailResult_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FProductID")) {
                sql = "CREATE INDEX {0} ON {1} (FProductID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_DynDataByCostObj") || busiTblName.equals("T_NCM_DynDataByCostObj_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_DynDataByProduct") || busiTblName.equals("T_NCM_DynDataByProduct_History")) {
            indexColumns = "FCostCenterID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostCenterID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FCostObjectID")) {
                sql = "CREATE INDEX {0} ON {1} (FCostObjectID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_WIPCountingAllocResult") || busiTblName.equals("T_NCM_WIPCountingAllocResult")) {
            indexColumns = "FCostCenterid,FMaterialID,FCostItemId,FCostObjectId";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCompanyID ASC, FCalculatePeriodID ASC, FCostCenterid ASC, FMaterialID ASC, FLot ASC, FCostItemId ASC, FCostObjectId ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_OSBomPath")) {
            indexColumns = "FParentMaterialID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FParentMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FBomID,FBomEntryID")) {
                sql = "CREATE INDEX {0} ON {1} (FBomID,FBomEntryID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FBomPath")) {
                sql = "CREATE INDEX {0} ON {1} (FBomPath ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_OSLowLevelCode")) {
            indexColumns = "FMaterialID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_OSMaterialRollUp")) {
            indexColumns = "FParentMaterialID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FParentMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FSpreadPath")) {
                sql = "CREATE INDEX {0} ON {1} (FSpreadPath ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_OSMaterialDetail")) {
            indexColumns = "FCostTypeID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostTypeID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FParentMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FParentMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_OSActivityRollUp")) {
            indexColumns = "FParentMaterialID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FParentMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FActivityID")) {
                sql = "CREATE INDEX {0} ON {1} (FActivityID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        } else if (busiTblName.equals("T_NCM_OSActivityDetail")) {
            indexColumns = "FCostTypeID";
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns)) {
                sql = "CREATE INDEX {0} ON {1} (FCostTypeID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FParentMaterialID")) {
                sql = "CREATE INDEX {0} ON {1} (FParentMaterialID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
            if (!NCMDynamicTableManager.containIndex(idxs, indexColumns = "FActivityID")) {
                sql = "CREATE INDEX {0} ON {1} (FActivityID ASC);";
                indexName = NCMDynamicTableManager.getValidIndexName(ctx);
                sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
                NCMDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
            }
        }
        try {
            if (sb.length() > 0) {
                NCMDbUtil.BatchSqlExecute(ctx, sb.toString(), ";");
            }
        }
        catch (BOSException e) {
            logger.debug((Object)("Create indexs for dynamic business table " + busiTblName + " error."), (Throwable)e);
        }
        ObjectUuidPK pk = new ObjectUuidPK(tblMap.getId());
        tblMap.setNeedUpdateIndex(false);
        NCMDynamicTableMapFactory.getLocalInstance(ctx).update((IObjectPK)pk, tblMap);
    }

    private static boolean containIndex(NCMDynamicTableMapEntryCollection idxs, String columns) {
        NCMDynamicTableMapEntryInfo item = null;
        for (int i = 0; i < idxs.size(); ++i) {
            item = idxs.get(i);
            if (!item.getIndexColumns().equals(columns)) continue;
            return true;
        }
        return false;
    }

    public static String getValidIndexName(Context ctx) throws SQLException, BOSException {
        String indexName;
        do {
            if ((indexName = new UUTN("ZC").toString()).length() <= 10) continue;
            indexName = indexName.substring(0, 10);
        } while (NCMDynamicTableManager.isIndexExists(ctx, indexName = indexName.replaceFirst("ZC", "IX_NCM")));
        return indexName;
    }

    private static void updateColumn(Context ctx, String companyId, String busiTblName, String physicalTblName, NCMDynamicTableMapInfo tblMap) throws EASBizException, BOSException, SQLException {
        Assert.that((physicalTblName != null ? 1 : 0) != 0);
        String sql = null;
        if (busiTblName.equals("T_NCM_MatAllocResult") || busiTblName.equals("T_NCM_MatAllocResult_History") || busiTblName.equals("T_NCM_MatAllocResult_Adjust") || busiTblName.equals("T_NCM_DynMatAllocResult") || busiTblName.equals("T_NCM_DynMatAllocResult_History") || busiTblName.equals("T_NCM_DynMatAllocResult_Adjust")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "AllocBillType")) {
                sql = "alter table " + physicalTblName + " add AllocBillType varchar(4) not null default('" + "MF" + "')";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "AllocBillType")) {
                sql = "alter table " + physicalTblName + " add AllocBillType varchar(4) not null default('" + "MF" + "')";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FCommonQty")) {
                sql = "alter table " + physicalTblName + " add FCommonQty NUMERIC(21,8) not null DEFAULT 0";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAssistQty")) {
                sql = "alter table " + physicalTblName + " add FAssistQty NUMERIC(21,8) not null default 0";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FBaseUnitID")) {
                sql = "alter table " + physicalTblName + " add FBaseUnitID varchar(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FCommonUnitID")) {
                sql = "alter table " + physicalTblName + " add FCommonUnitID varchar(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAssistUnitID")) {
                sql = "alter table " + physicalTblName + " add FAssistUnitID varchar(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FIsRework")) {
                sql = "alter table " + physicalTblName + " add FIsRework INT NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdminOrgUnitID")) {
                sql = "alter table " + physicalTblName + " add FAdminOrgUnitID varchar(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FWarehouseID")) {
                sql = "alter table " + physicalTblName + " add FWarehouseID varchar(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_OtherAllocResult") || busiTblName.equals("T_NCM_OtherAllocResult_History") || busiTblName.equals("T_NCM_OtherAllocResult_Adjust") || busiTblName.equals("T_NCM_DynOtherAllocResult") || busiTblName.equals("T_NCM_DynOtherAllocResult_History") || busiTblName.equals("T_NCM_DynOtherAllocResult_Adjust")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FQty")) {
                sql = "alter table " + physicalTblName + " add FQty NUMERIC(21,8) NOT NULL DEFAULT 0";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FPrice")) {
                sql = "alter table " + physicalTblName + " add FPrice NUMERIC(21,8) NOT NULL DEFAULT 0";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FDepartmentID")) {
                sql = "alter table " + physicalTblName + " add FDepartmentID VARCHAR(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FSourceCostCenterID")) {
                sql = "alter table " + physicalTblName + " add FSourceCostCenterID VARCHAR(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_CostCalResult") || busiTblName.equals("T_NCM_CostCalResult_History") || busiTblName.equals("T_NCM_DynCostCalResult") || busiTblName.equals("T_NCM_DynCostCalResult_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FFinishedQty")) {
                sql = "alter table " + physicalTblName + " add FFinishedQty NUMERIC(21,8) NOT NULL DEFAULT 0";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FEoPWIPQty")) {
                sql = "alter table " + physicalTblName + " add FEoPWIPQty NUMERIC(21,8) NOT NULL DEFAULT 0";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FFinishedAssistQty")) {
                sql = "alter table " + physicalTblName + " add FFinishedAssistQty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FFinishedAddqty")) {
                sql = "alter table " + physicalTblName + " add FFinishedAddqty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FEoPWIPAssistQty")) {
                sql = "alter table " + physicalTblName + " add FEoPWIPAssistQty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FEoPWIPAddqty")) {
                sql = "alter table " + physicalTblName + " add FEoPWIPAddqty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjEoPWipQty")) {
                sql = "alter table " + physicalTblName + " add FAdjEoPWipQty numeric(28,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjEoPWipAmount")) {
                sql = "alter table " + physicalTblName + " add FAdjEoPWipAmount numeric(17,4)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_CostCalMatDetailResult") || busiTblName.equals("T_NCM_CostCalMatDetailResult_History") || busiTblName.equals("T_NCM_DynCostCalMatDetailResult") || busiTblName.equals("T_NCM_DynCostCalMatDetailResult_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FFinishedAssistQty")) {
                sql = "alter table " + physicalTblName + " add FFinishedAssistQty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FFinishedAddqty")) {
                sql = "alter table " + physicalTblName + " add FFinishedAddqty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FEoPWIPAssistQty")) {
                sql = "alter table " + physicalTblName + " add FEoPWIPAssistQty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FEoPWIPAddqty")) {
                sql = "alter table " + physicalTblName + " add FEoPWIPAddqty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FIsReWork")) {
                sql = "alter table " + physicalTblName + " add FIsReWork INT  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjEoPWipQty")) {
                sql = "alter table " + physicalTblName + " add FAdjEoPWipQty numeric(28,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjEoPWipAmount")) {
                sql = "alter table " + physicalTblName + " add FAdjEoPWipAmount numeric(17,4)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_CostCalPrdDetailResult") || busiTblName.equals("T_NCM_CostCalPrdDetailResult_History") || busiTblName.equals("T_NCM_DynCostCalPrdDetailResult") || busiTblName.equals("T_NCM_DynCostCalPrdDetailResult_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FTotalFinishedQty")) {
                sql = "alter table " + physicalTblName + " add FTotalFinishedQty NUMERIC(21,8) NOT NULL DEFAULT 0";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FVoucherid")) {
                sql = "alter table " + physicalTblName + " add FVoucherid VARCHAR(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FRecvQty")) {
                sql = "alter table " + physicalTblName + " add FRecvQty NUMERIC(21,8) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FTempAmount")) {
                sql = "alter table " + physicalTblName + " add FTempAmount NUMERIC(17,4) ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_CCOAllocResult_Adjust")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FDepartmentID")) {
                sql = "alter table " + physicalTblName + " add FDepartmentID VARCHAR(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FSourceCostCenterID")) {
                sql = "alter table " + physicalTblName + " add FSourceCostCenterID VARCHAR(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FBizDate")) {
                sql = "alter table " + physicalTblName + " add FBizDate DateTime ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_Balance") || busiTblName.equals("T_NCM_Balance_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FBopWIPHour")) {
                sql = "alter table " + physicalTblName + " add FBopWIPHour NUMERIC(21,8) NOT NULL DEFAULT 0";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjBopWIPHour")) {
                sql = "alter table " + physicalTblName + " add FAdjBopWIPHour NUMERIC(28,10) NOT NULL DEFAULT 0";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjBopWipQty")) {
                sql = "alter table " + physicalTblName + " add FAdjBopWipQty NUMERIC(28,10) NOT NULL DEFAULT 0";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_BalanceEntry") || busiTblName.equals("T_NCM_BalanceEntry_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FBopWIPQty")) {
                sql = "alter table " + physicalTblName + " add FBopWIPQty numeric(21,10) NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FPrice")) {
                sql = "alter table " + physicalTblName + " add FPrice numeric(21,10) NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjBopWipQty")) {
                sql = "alter table " + physicalTblName + " add FAdjBopWipQty numeric(28,10) NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjBoPWipAmount")) {
                sql = "alter table " + physicalTblName + " add FAdjBoPWipAmount numeric(28,10) NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_BalanceMatDetail") || busiTblName.equals("T_NCM_BalanceMatDetail_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FUnitID")) {
                sql = "alter table " + physicalTblName + " add FUnitID varchar(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAssistQty")) {
                sql = "alter table " + physicalTblName + " add FAssistQty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAddqty")) {
                sql = "alter table " + physicalTblName + " add FAddqty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FIsRework")) {
                sql = "alter table " + physicalTblName + " add FIsRework INT NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjQty")) {
                sql = "alter table " + physicalTblName + " add FAdjQty numeric(28,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjAmount")) {
                sql = "alter table " + physicalTblName + " add FAdjAmount numeric(17,4)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_DataByCostObj") || busiTblName.equals("T_NCM_DataByCostObj_History") || busiTblName.equals("T_NCM_DynDataByCostObj") || busiTblName.equals("T_NCM_DynDataByCostObj_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FFinishedAssistQty")) {
                sql = "alter table " + physicalTblName + " add FFinishedAssistQty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FFinishedAddQty")) {
                sql = "alter table " + physicalTblName + " add FFinishedAddQty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FBOPWIPHOUR")) {
                sql = "alter table " + physicalTblName + " add FBOPWIPHOUR NUMERIC(21,8) NOT NULL DEFAULT 0";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_DataByProduct") || busiTblName.equals("T_NCM_DataByProduct_History") || busiTblName.equals("T_NCM_DataByProduct") || busiTblName.equals("T_NCM_DataByProduct_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FFinishedAssistQty")) {
                sql = "alter table " + physicalTblName + " add FFinishedAssistQty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FFinishedAddQty")) {
                sql = "alter table " + physicalTblName + " add FFinishedAddQty numeric(21,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_AllDataByCostObj") || busiTblName.equals("T_NCM_AllDataByCostObj_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjEopWipQty")) {
                sql = "alter table " + physicalTblName + " add FAdjEopWipQty numeric(28,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjBoPWipQty")) {
                sql = "alter table " + physicalTblName + " add FAdjBoPWipQty numeric(28,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjBopWipHour")) {
                sql = "alter table " + physicalTblName + " add FAdjBopWipHour numeric(28,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjEopWipHour")) {
                sql = "alter table " + physicalTblName + " add FAdjEopWipHour numeric(28,10)  NOT NULL DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FID")) {
                sql = "alter table " + physicalTblName + " add FID VARCHAR(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_LinearEquations") || busiTblName.equals("T_NCM_LinearEquations_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FVoucherID")) {
                sql = "alter table " + physicalTblName + " add FVoucherID varchar(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_DataByOrder") || busiTblName.equals("T_NCM_DataByOrder_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FTotalFinishedQty")) {
                sql = "alter table " + physicalTblName + " add FTotalFinishedQty NUMERIC(28,10) DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FOrderNumber")) {
                sql = "alter table " + physicalTblName + " add FOrderNumber NVARCHAR(80) ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_OCCC2ActivityAlloc")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FCostDriverAmount")) {
                sql = "alter table " + physicalTblName + " add FCostDriverAmount NUMERIC(28,10) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FDepartmentID")) {
                sql = "alter table " + physicalTblName + " add FDepartmentID VARCHAR(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_OCActivity2OrderAlloc")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FOrderProdID")) {
                sql = "alter table " + physicalTblName + " add FOrderProdID VARCHAR(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FOrderProdBatchNo")) {
                sql = "alter table " + physicalTblName + " add FOrderProdBatchNo NVARCHAR(80) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FOrderProdID")) {
                sql = "alter table " + physicalTblName + " add FOrderNumber NVARCHAR(80) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FStorageOrgUnitID")) {
                sql = "alter table " + physicalTblName + " add FStorageOrgUnitID VARCHAR(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FCostItemID")) {
                sql = "alter table " + physicalTblName + " add FCostItemID VARCHAR(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FCostDriverAmount")) {
                sql = "alter table " + physicalTblName + " add FCostDriverAmount NUMERIC(28,10) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FExpenseID")) {
                sql = "alter table " + physicalTblName + " add FExpenseID VARCHAR(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FDepartmentID")) {
                sql = "alter table " + physicalTblName + " add FDepartmentID VARCHAR(44) ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_OrderCostCalMatDetailResult") || busiTblName.equals("T_NCM_OrderCostCalMatDetailResult_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FRatio")) {
                sql = "alter table " + physicalTblName + " add FRatio NUMERIC(24,12) DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_OrderCostCalActivityDetailResult") || busiTblName.equals("T_NCM_OrderCostCalActivityDetailResult_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FRatio")) {
                sql = "alter table " + physicalTblName + " add FRatio NUMERIC(24,12) DEFAULT 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_CostRecoveryReportByEnd") || busiTblName.equals("T_NCM_CostRecoveryReportByEnd_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FProductModel")) {
                sql = "alter table " + physicalTblName + " alter FProductModel NVARCHAR(255) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FMaterielModel")) {
                sql = "alter table " + physicalTblName + " alter FMaterielModel NVARCHAR(255) ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_CostRecoveryReportByStep") || busiTblName.equals("T_NCM_CostRecoveryReportByStep_History")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FProductModel")) {
                sql = "alter table " + physicalTblName + " alter FProductModel NVARCHAR(255) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FMaterielModel")) {
                sql = "alter table " + physicalTblName + " alter FMaterielModel NVARCHAR(255) ";
                NCMDbUtil.execute(ctx, sql);
            }
        } else if (busiTblName.equals("T_NCM_CostCalReportPreTreatData")) {
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FIsHistoryData")) {
                sql = "alter table " + physicalTblName + " add FIsHistoryData int default 0 ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjBopWipQty")) {
                sql = "alter table " + physicalTblName + " add FAdjBopWipQty NUMERIC(21,8) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjEopWipQty")) {
                sql = "alter table " + physicalTblName + " add FAdjEopWipQty NUMERIC(21,8) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjBopWipAmount")) {
                sql = "alter table " + physicalTblName + " add FAdjBopWipAmount NUMERIC(17,4) ";
                NCMDbUtil.execute(ctx, sql);
            }
            if (!NCMDynamicTableManager.isColumnExists(ctx, physicalTblName, "FAdjEopWipAmount")) {
                sql = "alter table " + physicalTblName + " add FAdjEopWipAmount NUMERIC(17,4) ";
                NCMDbUtil.execute(ctx, sql);
            }
        }
        ObjectUuidPK pk = new ObjectUuidPK(tblMap.getId());
        tblMap.setNeedUpdateColumn(false);
        NCMDynamicTableMapFactory.getLocalInstance(ctx).update((IObjectPK)pk, tblMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isColumnExists(Context ctx, String tblName, String columnName) throws SQLException {
        Assert.that((tblName != null ? 1 : 0) != 0);
        Assert.that((columnName != null ? 1 : 0) != 0);
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '" + tblName + "' AND KSQL_COL_NAME = '" + columnName + "'  )";
        IRowSet rs = null;
        try {
            rs = NCMDbUtil.executeQuery(ctx, sql);
            boolean bl = rs.next();
            return bl;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return false;
    }

    public static void buildIndexsOfBusiTbl(Context ctx, String companyId, String busiTblName) throws EASBizException, BOSException, SQLException {
        NCMDynamicTableManager.getPhysicalTblName(ctx, companyId, busiTblName);
    }

    public static void buildIndexsOfBusiTbls(Context ctx, String companyId, Set busiTblNames) throws EASBizException, BOSException, SQLException {
        Iterator it = busiTblNames.iterator();
        while (it.hasNext()) {
            NCMDynamicTableManager.buildIndexsOfBusiTbl(ctx, companyId, (String)it.next());
        }
    }

    public static void clearIndexsOfBusiTbl(Context ctx, String companyId, String busiTblName) throws BOSException, EASBizException {
        HashSet<String> busiTblNames = new HashSet<String>();
        busiTblNames.add(busiTblName);
        NCMDynamicTableManager.clearIndexsOfBusiTbls(ctx, companyId, busiTblNames);
    }

    public static void clearIndexsOfBusiTbls(Context ctx, String companyId, Set busiTblNames) throws BOSException, EASBizException {
        NCMDynamicTableMapInfo mapInfo;
        if (busiTblNames.size() <= 0) {
            return;
        }
        Iterator it = busiTblNames.iterator();
        while (it.hasNext()) {
            NCMDynamicTableManager.checkBusiTblName((String)it.next());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("businessTblName", (Object)busiTblNames, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("company");
        selector.add("businessTblName");
        selector.add("physicalTblName");
        selector.add("primaryKeyName");
        selector.add("needUpdateIndex");
        selector.add("needUpdateColumn");
        selector.add("entries.indexName");
        view.setSelector(selector);
        NCMDynamicTableMapCollection coll = NCMDynamicTableMapFactory.getLocalInstance(ctx).getNCMDynamicTableMapCollection(view);
        if (coll.size() <= 0) {
            return;
        }
        HashMap<String, ArrayList<String>> indexesMap = new HashMap<String, ArrayList<String>>();
        List<String> indexes = null;
        HashSet<String> physTblNames = new HashSet<String>();
        Iterator it2 = coll.iterator();
        while (it2.hasNext()) {
            mapInfo = (NCMDynamicTableMapInfo)it2.next();
            physTblNames.add(mapInfo.getPhysicalTblName());
            NCMDynamicTableMapEntryCollection entries = mapInfo.getEntries();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                indexes = (List)indexesMap.get(mapInfo.getPhysicalTblName());
                if (indexes == null) {
                    indexes = new ArrayList<String>();
                    indexesMap.put(mapInfo.getPhysicalTblName(), (ArrayList<String>)indexes);
                }
                indexes.add(entries.get(i).getIndexName());
            }
        }
        it2 = coll.iterator();
        while (it2.hasNext()) {
            mapInfo = (NCMDynamicTableMapInfo)it2.next();
            indexes = (ArrayList<String>)indexesMap.get(mapInfo.getPhysicalTblName());
            if (indexes == null) continue;
            for (int i = 0; i < indexes.size(); ++i) {
                try {
                    NCMDbUtil.execute(ctx, "drop index " + mapInfo.getPhysicalTblName() + "." + indexes.get(i));
                    continue;
                }
                catch (BOSException e) {
                    logger.debug((Object)("Drop indexs for dynamic business table " + mapInfo.getBusinessTblName() + " error."), (Throwable)e);
                }
            }
            mapInfo.getEntries().clear();
            mapInfo.setNeedUpdateIndex(true);
            try {
                ObjectUuidPK pk = new ObjectUuidPK(mapInfo.getId());
                NCMDynamicTableMapFactory.getLocalInstance(ctx).update((IObjectPK)pk, mapInfo);
                m_DynamicTblMapCache.remove(companyId + mapInfo.getBusinessTblName());
            }
            catch (BOSException e) {
                logger.debug((Object)("Update dynamic business table " + mapInfo.getBusinessTblName() + " info error."), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPhysicalTblNameOnContext(Context ctx) {
        if (ctx != null) {
            Context context = ctx;
            synchronized (context) {
                Map map = (Map)threadLocal.get();
                if (map == null) {
                    threadLocal.set(new HashMap());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releasePhysicalTblNameOnContext(Context ctx) {
        if (ctx != null) {
            Context context = ctx;
            synchronized (context) {
                threadLocal.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPhysicalTblNameFromContext(Context ctx, String companyId, String busiTblName) {
        if (ctx != null && companyId != null && busiTblName != null) {
            Context context = ctx;
            synchronized (context) {
                Map map = (Map)threadLocal.get();
                if (map != null) {
                    String phyTblName = (String)map.get(companyId + "." + busiTblName);
                    return phyTblName;
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setPhysicalTblNameFromContext(Context ctx, String companyId, String busiTblName, String phyTblName) {
        if (ctx != null && companyId != null && busiTblName != null && phyTblName != null) {
            Context context = ctx;
            synchronized (context) {
                Map map = (Map)threadLocal.get();
                if (map != null) {
                    map.put(companyId + "." + busiTblName, phyTblName);
                }
            }
        }
    }

    public static String CreateDynTableForTempUse(Context ctx, String companyId, String busiTblName) throws BOSException, SQLException, EASBizException {
        NCMDynamicTableManager.checkBusiTblName(busiTblName);
        String physTableName = null;
        String[] tblNameInfo = NCMDynamicTableManager.GetRandomTblName(ctx);
        if (tblNameInfo.length == 2) {
            tblNameInfo[0] = tblNameInfo[0].replaceFirst("NCM", "NCN");
            if (NCMDynamicTableManager.CreateDynamicTable(ctx, companyId, busiTblName, tblNameInfo)) {
                physTableName = tblNameInfo[0];
            }
        }
        return physTableName;
    }

    public static void DisablePrimaryKey(Context ctx, String physicalTblName) throws BOSException, EASBizException {
        String dbTypeName = (String)ctx.get((Object)"dbType");
        int CurrentDataBaseType = DbType.getValue((String)dbTypeName);
        if (CurrentDataBaseType == 2 || CurrentDataBaseType == 7 || CurrentDataBaseType == 8) {
            NCMDbUtil.execute(ctx, "/*dialect*/ alter table " + physicalTblName + " disable primary key ");
        } else if (CurrentDataBaseType == 3) {
            NCMDbUtil.execute(ctx, "/*dialect*/ DECLARE @SQL VARCHAR(2000)  SET @SQL='ALTER TABLE " + physicalTblName + " DROP CONSTRAINT ' + (select name from sysobjects where xtype = 'PK' and parent_obj = object_id('" + physicalTblName + "')) exec (@SQL)");
        } else if (CurrentDataBaseType == 1) {
            NCMDbUtil.execute(ctx, "/*dialect*/ alter table " + physicalTblName + " DROP primary key ");
        }
    }

    public static void EnablePrimaryKey(Context ctx, String physicalTblName) throws BOSException, EASBizException {
        String dbTypeName = (String)ctx.get((Object)"dbType");
        int CurrentDataBaseType = DbType.getValue((String)dbTypeName);
        if (CurrentDataBaseType == 2 || CurrentDataBaseType == 7 || CurrentDataBaseType == 8) {
            NCMDbUtil.execute(ctx, "/*dialect*/ alter table " + physicalTblName + " enable primary key ");
        } else if (CurrentDataBaseType == 3) {
            NCMDbUtil.execute(ctx, "/*dialect*/ alter table " + physicalTblName + " ADD primary key (FID)");
        } else if (CurrentDataBaseType == 1) {
            NCMDbUtil.execute(ctx, "/*dialect*/ alter table " + physicalTblName + " ADD primary key (FID)");
        }
    }

    private static void insertHistoryData(Context ctx, String companyID, String physTableName) throws EASBizException, BOSException {
        PeriodInfo startPeriodInfo = NCMUtils.GetStartPeriod(ctx, companyID);
        PeriodInfo currPeriodInfo = NCMUtils.GetCurrentPeriod(ctx, companyID);
        if (startPeriodInfo != null && currPeriodInfo != null && startPeriodInfo.getNumber() != currPeriodInfo.getNumber()) {
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("Insert into ").append(physTableName).append(" (FID,FCOMPANYID,FCALCULATEPERIODID,FCOSTCENTERID,FCOSTOBJECTID, \n");
            insertSql.append(" FBOPWIPQTY,FINPUTQTY,FFINISHEDQTY,FEOPWIPQTY,FBOPWIPHOUR,FINPUTHOUR,FFINISHEDHOUR,FEOPWIPHOUR, \n");
            insertSql.append(" FCOEF,FADJEOPWIPQTY,FADJBOPWIPQTY,FADJBOPWIPHOUR,FADJEOPWIPHOUR) \n");
            insertSql.append("select newbosid('5CEE85BF') fid,FCOMPANYORG,FCALCULATEPERIOD,FCostCenterID,FCostObjectID,FINITBALACNEQTY, \n");
            insertSql.append("   FINPUTQTY,FMANUOVERQTRY,FQTY,0,0,0,0,0,0,0,0,0 \n");
            insertSql.append("from T_NCM_WIPCountingBill ");
            insertSql.append("Where FCOMPANYORG = '").append(companyID).append("' \n");
            NCMDbUtil.execute(ctx, insertSql.toString());
            insertSql.setLength(0);
        }
    }
}

