/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class NCMGenVoucherHelper {
    private static Logger logger = Logger.getLogger((String)NCMGenVoucherHelper.class.getName());

    public static DAPTransformResult generateVoucher(Context ctx, IObjectPK[] srcBillPks, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        if (srcBillPks == null || srcBillPks.length == 0 || botMappingPK == null) {
            return null;
        }
        CoreBillBaseCollection srcBillColl = new CoreBillBaseCollection();
        int srcLength = srcBillPks.length;
        int maxLength = 5000;
        int temp = srcLength / maxLength;
        int times = (double)srcLength / (double)maxLength > (double)temp ? temp + 1 : temp;
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < times; ++i) {
            idSet.clear();
            for (int j = i * maxLength; j < (i + 1) * maxLength && j < srcLength; ++j) {
                idSet.add(srcBillPks[j].toString());
            }
            srcBillColl.addCollection(NCMGenVoucherHelper.getSrcBillColl(ctx, idSet, botpSelectors));
        }
        return NCMGenVoucherHelper.generateVoucher(ctx, (IObjectCollection)srcBillColl, botMappingPK);
    }

    private static CoreBillBaseCollection getSrcBillColl(Context ctx, Set idSet, SelectorItemCollection botpSelectors) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        if (botpSelectors != null) {
            evi.put("selector", (Object)botpSelectors);
        }
        String srcId = null;
        Iterator iter = idSet.iterator();
        if (iter.hasNext()) {
            srcId = iter.next().toString();
        }
        CoreBillBaseCollection srcBillColl = NCMGenVoucherHelper.getBizInterface(ctx, srcId).getCoreBillBaseCollection(evi);
        return srcBillColl;
    }

    private static ICoreBillBase getBizInterface(Context ctx, String id) throws BOSException {
        BOSObjectType srcBosObjectType = BOSUuid.read((String)id).getType();
        ICoreBillBase iSrcBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)srcBosObjectType);
        return iSrcBillBase;
    }

    public static DAPTransformResult generateVoucher(Context ctx, IObjectCollection srcBillColl, IObjectPK botMappingPK) throws BOSException, EASBizException {
        IDAPTransformer dapTrans = DAPTransformerFactory.getLocalInstance((Context)ctx);
        DAPTransformResult dapTransformResult = dapTrans.transformForBotp((CoreBillBaseCollection)srcBillColl, DAPVoucherTypeEnum.FIVoucher, botMappingPK);
        NCMGenVoucherHelper.save(ctx, (CoreBillBaseCollection)srcBillColl, dapTransformResult);
        return dapTransformResult;
    }

    private static void save(Context ctx, CoreBillBaseCollection sourceBillCollection, DAPTransformResult dapTransformerResult) throws BOSException, EASBizException {
        NCMGenVoucherHelper.saveVoucher(ctx, dapTransformerResult);
        NCMGenVoucherHelper.resetRelation(dapTransformerResult);
        if (dapTransformerResult.getRelationCollection() == null || dapTransformerResult.getRelationCollection().size() == 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"15_NCMGenVoucherHelper", (Locale)ctx.getLocale()));
        }
    }

    private static void resetRelation(DAPTransformResult dapTransformerResult) {
        VoucherCollection voucherCols = (VoucherCollection)dapTransformerResult.getVoucherCollection();
        BOTRelationCollection relationCols = dapTransformerResult.getRelationCollection();
        int count = relationCols.size();
        for (int i = 0; i < count; ++i) {
            BOTRelationInfo botRelationInfo = relationCols.get(i);
            boolean hasRelationInfoExist = false;
            VoucherInfo destVoucherInfo = null;
            int size = voucherCols.size();
            for (int j = 0; j < size; ++j) {
                VoucherInfo voucherInfo = voucherCols.get(j);
                if (!botRelationInfo.getDestObjectID().equals(voucherInfo.getId().toString())) continue;
                destVoucherInfo = voucherInfo;
                hasRelationInfoExist = true;
                break;
            }
            if (hasRelationInfoExist && destVoucherInfo != null) {
                BOTRelationEntryCollection botRelationEntryCols = botRelationInfo.getRelationEntries();
                VoucherEntryCollection voucherEntryCollection = destVoucherInfo.getEntries();
                int reCount = botRelationEntryCols.size();
                for (int k = 0; k < reCount; ++k) {
                    BOTRelationEntryInfo botRelationEntryInfo = botRelationEntryCols.get(k);
                    boolean hasEntryExist = false;
                    if (botRelationEntryInfo.getDestEntryID().equals(destVoucherInfo.getId().toString())) {
                        hasEntryExist = true;
                    } else {
                        int veCount = voucherEntryCollection.size();
                        for (int m = 0; m < veCount; ++m) {
                            VoucherEntryInfo voucherEntryInfo = voucherEntryCollection.get(m);
                            if (!botRelationEntryInfo.getDestEntryID().equals(voucherEntryInfo.getId().toString())) continue;
                            hasEntryExist = true;
                            break;
                        }
                    }
                    if (hasEntryExist) continue;
                    botRelationEntryCols.removeObject(k);
                    --k;
                    --reCount;
                }
                continue;
            }
            relationCols.removeObject(i);
            --i;
            --count;
        }
    }

    private static void saveVoucher(Context ctx, DAPTransformResult dapTransformerResult) throws BOSException, EASBizException {
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        try {
            for (VoucherInfo voucher : dapTransformerResult.getVoucherCollection()) {
                if (NCMGenVoucherHelper.isTempSave(ctx, dapTransformerResult.getRelationCollection())) {
                    iVoucher.save((CoreBaseInfo)voucher);
                    continue;
                }
                iVoucher.submit((CoreBaseInfo)voucher);
            }
        }
        catch (EASBizException e) {
            throw new DAPException(DAPException.VOUCHER_NOT_SAVE, (Throwable)e, new Object[]{e.getMessage(ctx.getLocale())});
        }
        catch (WfException e) {
            throw new DAPException(DAPException.VOUCHER_NOT_SUBMIT, (Throwable)e);
        }
    }

    private static boolean isTempSave(Context ctx, BOTRelationCollection relations) {
        BOTRelationInfo relation;
        if (relations != null && relations.size() > 0 && (relation = relations.get(0)) != null && !StringUtils.isEmpty((String)relation.getBOTMappingID())) {
            String sql = "select FIsTempSave from T_BOT_Mapping where FID = ?";
            try {
                IRowSet rowset = NCMDbUtil.executeQuery(ctx, sql, new Object[]{relation.getBOTMappingID()});
                if (rowset.next()) {
                    return rowset.getInt(1) == 1;
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return false;
    }
}

