/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CMBillBaseCollection;
import com.kingdee.eas.ncm.common.CMBillBaseInfo;
import com.kingdee.eas.ncm.common.ICMBillBase;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class NCMServerUtils {
    private static final char CLF = '\n';
    private static Logger logger = Logger.getLogger((String)NCMServerUtils.class.getName());

    public static String getEntityName(Context ctx, BOSObjectType aCMBillBaseInfo) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        if (loader != null) {
            EntityObjectInfo billEntityInfo = loader.getEntity(aCMBillBaseInfo);
            return billEntityInfo.getAlias();
        }
        return null;
    }

    public static List makeBills(Context ctx, String comID, String periodID, ICMBillBase ibiz, IObjectCollection colls, boolean needNumbers) throws BOSException, EASBizException {
        if (colls == null || colls.isEmpty()) {
            return null;
        }
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        ICompanyOrgUnit iComp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        UserInfo userinfo = iUser.getUserInfo(ctx.getCaller());
        PeriodInfo periodinfo = null;
        if (BOSUuid.getBOSObjectType((String)periodID, (boolean)false).toString().equals("82388C4C")) {
            periodinfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodID));
        } else {
            periodinfo = null;
            NCMDbUtil.execute(ctx, " delete from T_Cal_CostObjectRankEntry where FParentID in (select fid from T_Cal_CostObjectRank where FCompanyOrg = ? and FllcType = 2)", new Object[]{comID});
            NCMDbUtil.execute(ctx, " delete from T_Cal_CostObjectRank where FCompanyOrg = ? and FllcType = 2 ", new Object[]{comID});
        }
        CompanyOrgUnitInfo companyinfo = iComp.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(comID));
        CMBillBaseInfo cmBill = null;
        IObjectPK pk = null;
        int nbill = colls.size();
        LinkedHashSet<IObjectPK> pks = new LinkedHashSet<IObjectPK>(nbill);
        for (int bill = 0; bill < nbill; ++bill) {
            cmBill = (CMBillBaseInfo)colls.getObject(bill);
            cmBill.setIsAuto(true);
            if (periodinfo != null) {
                cmBill.setBizDate(periodinfo.getEndDate());
            }
            cmBill.setCalculatePeriod(periodinfo);
            cmBill.setCompanyOrg(companyinfo);
            cmBill.setBillStatus(BillBaseStatusEnum.AUDITED);
            cmBill.setAuditor(userinfo);
            cmBill.setCreator(userinfo);
            try {
                Timestamp now = BDCMUtils.DateToTime((Date)BDCMUtils.now());
                cmBill.setAuditTime(now);
                cmBill.setCreateTime(now);
                pk = ibiz.addnewForCalCost((IObjectValue)cmBill);
                pks.add(pk);
                continue;
            }
            catch (BOSException e) {
                throw e;
            }
            catch (EASBizException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BOSException(e.getCause());
            }
        }
        if (needNumbers) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", pks, CompareType.INCLUDE));
            view.setFilter(filter);
            CMBillBaseCollection newBills = ibiz.getCMBillBaseCollection(view);
            CMBillBaseInfo newBill = null;
            ArrayList<String> numbers = new ArrayList<String>(nbill);
            int ninfo = newBills.size();
            for (int info = 0; info < ninfo; ++info) {
                newBill = (CMBillBaseInfo)newBills.getObject(info);
                if (newBill == null) continue;
                numbers.add(newBill.getNumber());
            }
            return numbers;
        }
        return null;
    }

    public static List makeBills(Context ctx, String comID, String periodID, ICMBillBase ibiz, IObjectCollection colls) throws BOSException, EASBizException {
        return NCMServerUtils.makeBills(ctx, comID, periodID, ibiz, colls, true);
    }

    public static void BatchSqlExecute(Context ctx, String sql, Map[] paramList) throws SQLDataException, SQLException {
        NCMDbUtil.BatchSqlExecute(ctx, sql, paramList);
    }

    public static void BatchSqlExecute(Context ctx, String sql) throws BOSException {
        NCMServerUtils.BatchSqlExecute(ctx, sql, ";");
    }

    public static void BatchSqlExecute(Context ctx, String sql, String separator) throws BOSException {
        String[] list = sql.split(separator);
        NCMServerUtils.BatchSqlExecute(ctx, list);
    }

    public static void BatchSqlExecute(Context ctx, String[] sqlList) throws BOSException {
        NCMDbUtil.BatchSqlExecute(ctx, sqlList);
    }

    public static List executeSQLByBatch(Context ctx, String sql, Object[] params, Collection in_ids) throws BOSException {
        return NCMDbUtil.executeSQLByBatch(ctx, sql, params, in_ids);
    }

    public static boolean checkHasValidCostObject(Context ctx, String companyId, String periodId) throws BOSException, SQLException, EASBizException {
        StringBuffer sb = new StringBuffer();
        String tblBalance = null;
        tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, companyId, "T_NCM_Balance");
        sb.append("SELECT SUM(E.FQty) ").append('\n').append("FROM T_NCM_InputQtyBill B ").append('\n').append("LEFT OUTER JOIN T_NCM_InputQtyBillEntry E ON B.FID = E.FParentID ").append('\n').append("WHERE B.FBillStatus=4 AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n').append("GROUP BY B.FCompanyOrg,B.FCalculatePeriod,E.FCostObjectID ").append('\n').append("HAVING SUM(E.FQty) <>0 ").append('\n');
        sb.append("UNION ").append('\n').append("SELECT SUM(BB.FBopWIPQty) ").append('\n').append("FROM ").append(tblBalance).append(" BB ").append('\n').append("WHERE BB.FCompanyOrg = ? AND BB.FCalculatePeriodID = ? ").append('\n').append("GROUP BY BB.FCompanyOrg,BB.FCalculatePeriodID,BB.FCostObjectID ").append("HAVING SUM(BB.FBopWIPQty) <>0 ");
        Object[] params = new Object[]{companyId, periodId, companyId, periodId};
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sb.toString(), params);
        return rs.next();
    }

    public static Map checkHasAssistantCostObject(Context ctx, String companyId, String periodId, String costCenterID) throws BOSException, SQLException, EASBizException {
        HashMap<String, Boolean> checkResult = new HashMap<String, Boolean>();
        Object[] params = null;
        params = costCenterID != null ? new Object[]{companyId, periodId, costCenterID} : new Object[]{companyId, periodId};
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT SUM(E.FQty) ").append('\n').append("  FROM T_NCM_InnerOverheadBill B ").append('\n').append(" INNER JOIN T_NCM_InnerOverheadBillEntry E ON B.FID = E.FParentID ").append('\n').append(" WHERE B.FBillStatus=4 AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n');
        if (costCenterID != null) {
            sb.append("   AND B.FCostCenterID = ? ").append('\n');
        }
        sb.append(" GROUP BY B.FCostCenterID,E.FAuxOverheadID ").append('\n').append("HAVING SUM(E.FQty) <>0 ").append('\n');
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sb.toString(), params);
        if (rs.next()) {
            checkResult.put("existOverHead", Boolean.TRUE);
            sb.delete(0, sb.length());
            sb.append("SELECT SUM(E.FQty) ").append('\n').append("  FROM T_NCM_InnerOverheadBill B ").append('\n').append(" INNER JOIN T_NCM_InnerOverheadBillEntry E ON B.FID = E.FParentID ").append('\n').append("\tINNER JOIN T_BD_CostObjectEntry COE ON COE.FRelatedID = E.FAuxOverheadID ").append('\n').append("\tINNER JOIN T_BD_CostObject CO ON CO.FID = COE.FParentID AND CO.FCompanyID = B.FCompanyOrg ").append('\n').append(" WHERE B.FBillStatus=4 AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n');
            if (costCenterID != null) {
                sb.append("   AND B.FCostCenterID = ? ").append('\n');
            }
            sb.append(" GROUP BY B.FCostCenterID,E.FAuxOverheadID ").append('\n').append("HAVING SUM(E.FQty) <>0 ").append('\n');
            rs = NCMDbUtil.executeQuery(ctx, sb.toString(), params);
            if (rs.next()) {
                checkResult.put("existAUXOHcostObj", Boolean.TRUE);
            } else {
                checkResult.put("existAUXOHcostObj", Boolean.FALSE);
            }
        } else {
            checkResult.put("existOverHead", Boolean.FALSE);
        }
        return checkResult;
    }

    public static boolean checkHasAssistantCostObject(Context ctx, String companyId, String periodId, String costCenterID, String costObjectID) throws BOSException, SQLException, EASBizException {
        Object[] params = new Object[]{companyId, periodId, costCenterID, costObjectID};
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT SUM(E.FQty) ").append('\n').append("  FROM T_NCM_InnerOverheadBill B ").append('\n').append(" INNER JOIN T_NCM_InnerOverheadBillEntry E ON B.FID = E.FParentID ").append('\n').append("\tINNER JOIN T_BD_CostObjectEntry COE ON COE.FRelatedID = E.FAuxOverheadID ").append('\n').append("\tINNER JOIN T_BD_CostObject CO ON CO.FID = COE.FParentID AND CO.FCompanyID = B.FCompanyOrg ").append('\n').append(" WHERE B.FBillStatus=4 AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n').append("   AND B.FCostCenterID = ? AND CO.FID = ? ").append('\n').append(" GROUP BY B.FCostCenterID,E.FAuxOverheadID ").append('\n').append("HAVING SUM(E.FQty) <>0 ").append('\n');
        IRowSet rs = NCMDbUtil.executeQuery(ctx, sb.toString(), params);
        return rs.next();
    }

    public static String createTempTable(Context ctx, String sqlCreateTbl, String index) throws BOSException {
        return NCMDbUtil.createTempTable(ctx, sqlCreateTbl, index);
    }

    public static List executeSQLByBatch(Context ctx, String sql, Object[] params, Collection in_ids, int inCount) throws BOSException {
        return NCMDbUtil.executeSQLByBatch(ctx, sql, params, in_ids, inCount);
    }

    public static void checkInputQty(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, CostCenterOrgUnitInfo costCenter, CostObjectInfo[] costObjects) throws BOSException, EASBizException {
        if (company == null || period == null || costCenter == null || costObjects == null || costObjects.length == 0) {
            return;
        }
        HashMap<String, CostObjectInfo> noInputMap = new HashMap<String, CostObjectInfo>();
        int size = costObjects.length;
        Object[] costObjectPks = new Object[size];
        for (int i = 0; i < size; ++i) {
            CostObjectInfo costObject = costObjects[i];
            costObjectPks[i] = costObject.getId().toString();
            noInputMap.put(costObject.getId().toString(), costObject);
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select billEntry.FCostObjectId ");
        kSql.append("   from T_NCM_InputQtyBillEntry billEntry ");
        kSql.append("\t     left outer join T_NCM_InputQtyBill bill ");
        kSql.append("\t        on bill.FID = billEntry.FParentID ");
        kSql.append("        left outer join T_ORG_CostCenter cc ");
        kSql.append("           on cc.fid = bill.FCostCenterOrgUnitID ");
        kSql.append("  where bill.FCompanyOrg = ? ");
        kSql.append("    and bill.FCalculatePeriod = ? ");
        kSql.append("    and bill.FCostCenterOrgUnitID = ? ");
        kSql.append("    and bill.FBillStatus = 4 ");
        kSql.append("    and cc.FCostCenterType = 0 ");
        kSql.append("    and billEntry.FCostObjectId in (" + BDCMUtils.splitPK((Object[])costObjectPks) + ")");
        kSql.append("  group by billEntry.FCostObjectId having ISNULL(SUM(billEntry.FQty),0) <> 0 ");
        IRowSet rst = NCMDbUtil.executeQuery(ctx, kSql.toString(), new String[]{company.getId().toString(), period.getId().toString(), costCenter.getId().toString()});
        try {
            while (rst.next()) {
                String costObjectId = rst.getString(1);
                if (!noInputMap.containsKey(costObjectId)) continue;
                noInputMap.remove(costObjectId);
            }
        }
        catch (SQLException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        if (!noInputMap.isEmpty()) {
            kSql.setLength(0);
            String tblBalance = null;
            try {
                tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate(ctx, company.getId().toString(), "T_NCM_Balance");
            }
            catch (SQLException exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            kSql.append(" select FCostObjectID ");
            kSql.append("   from ").append(tblBalance);
            kSql.append("  where FCompanyOrg = ? ");
            kSql.append("    and FCalculatePeriodID = ? ");
            kSql.append("    and FCostCenterID = ? ");
            kSql.append("    and FCostObjectId in (" + BDCMUtils.splitPK((Object[])costObjectPks) + ")");
            kSql.append(" group by FCostObjectID HAVING ISNULL(SUM(FBopWIPQty),0) <>0 ");
            rst = NCMDbUtil.executeQuery(ctx, kSql.toString(), new String[]{company.getId().toString(), period.getId().toString(), costCenter.getId().toString()});
            try {
                while (rst.next()) {
                    String costObjectId = rst.getString(1);
                    if (!noInputMap.containsKey(costObjectId)) continue;
                    noInputMap.remove(costObjectId);
                }
            }
            catch (SQLException exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
        }
        if (!noInputMap.isEmpty()) {
            StringBuffer costObjectNames = new StringBuffer();
            int i = 0;
            Iterator itr = noInputMap.keySet().iterator();
            while (itr.hasNext()) {
                ++i;
                Object value = noInputMap.get(itr.next());
                if (!(value instanceof CostObjectInfo)) continue;
                CostObjectInfo costObject = (CostObjectInfo)value;
                if (i == 1) {
                    costObjectNames.append("\u3010" + costObject.getNumber() + " " + costObject.getName() + "\u3011");
                    continue;
                }
                costObjectNames.append("\u3001\u3010" + costObject.getNumber() + " " + costObject.getName() + "\u3011");
            }
            throw new NcmBillException(NcmBillException.NO_INPUT_FORACTUALHOUR, (Object[])new String[]{costObjectNames.toString(), "\u3010" + costCenter.getNumber() + " " + costCenter.getName() + "\u3011"});
        }
    }

    public static void execute(Context ctx, String sql, Connection conn) throws BOSException {
        NCMDbUtil.execute(ctx, sql, conn);
    }

    public static IRowSet executeQuery(Context ctx, String sql, Connection conn) throws BOSException {
        return NCMDbUtil.executeQuery(ctx, sql, conn);
    }

    public static void BatchSqlExecute(Context ctx, String sql, Connection conn) throws BOSException {
        NCMDbUtil.BatchSqlExecute(ctx, sql, conn);
    }

    public static void BatchSqlExecute(Context ctx, String sql, String separator, Connection conn) throws BOSException {
        NCMDbUtil.BatchSqlExecute(ctx, sql, separator, conn);
    }
}

