/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllocFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdFactory;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdInfo;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.IAllocStdSetByPrd;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllocFactory.DynMatAllocator;
import com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllocFactory.Table.DynManuMatAllocTable;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynManuMatAllocator
extends DynMatAllocator {
    private static Logger logger = Logger.getLogger((String)DynManuMatAllocator.class.getName());

    public DynManuMatAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
        Assert.that((boolean)param.containsKey("sourceBillId"));
        Assert.that((boolean)param.containsKey("sourceBillEntryId"));
        Assert.that((boolean)param.containsKey("isOnlyNotZero"));
        Assert.that((boolean)param.containsKey("isOnlyRangeChange"));
    }

    protected AllocTable setAllocTable(Map param) {
        return new DynManuMatAllocTable(param);
    }

    public AllocStdInfo GetAllocStdSetting(IFeeInfo currFee) throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        AllocStdInfo allocStd = null;
        if (this._param.containsKey("allocStd")) {
            allocStd = (AllocStdInfo)this._param.get("allocStd");
        }
        if (allocStd != null) {
            return allocStd;
        }
        StringBuffer sb = new StringBuffer();
        try {
            IAllocStdSetByPrd fact = AllocStdSetByPrdFactory.getLocalInstance((Context)ctx);
            sb.append("Select allocStd.* ").append(" where company = '").append(companyId).append("'").append("   AND expense = '").append(currFee.GetExpenseId()).append("' ").append("   AND costCenter = '").append(currFee.GetCostCenterId()).append("'").append("   AND calculatePeriod IS NULL and CostType = 2 ").append("   AND allocStd.id is not null ");
            AllocStdSetByPrdInfo info = fact.getAllocStdSetByPrdInfo(sb.toString());
            allocStd = info.getAllocStd();
            return allocStd;
        }
        catch (ObjectNotFoundException e) {
            throw new AllocateException(AllocateException.ITEM_ALLOC_NOTSET, new Object[]{currFee.GetExpenseNumber().concat(" ").concat(currFee.GetExpenseName()), currFee.GetCostCenterNumber().concat(" ").concat(currFee.GetCostCenterName())});
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e);
        }
    }

    public Map processResult() throws AllocateException {
        HashMap<String, Object> ret = null;
        ret = super.processResult();
        if (ret == null) {
            ret = new HashMap<String, Object>();
        }
        if (this._param.get("isOnlyRangeChange").equals(String.valueOf(true))) {
            this.dealWhenOnlyRangeChange();
        }
        IRowSet rs = this.getMatAdjustData();
        ret.put("AdjustData", rs);
        ret.put("AllocStd", this.getAllocStd());
        return ret;
    }

    protected String GetAdjustUserId() {
        return this._param.get("userId").toString();
    }

    protected IRowSet getMatAdjustData() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String sourceBillId = this._param.get("sourceBillId").toString();
        String sourceBillEntryId = this._param.get("sourceBillEntryId").toString();
        String tblResult = this.getAllocTable().GetResultTable();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT D.FID,D.FCostObjectID,O.FNumber As FCostObjectNumber, O.FName_L2 As FCostObjectName,P.FModel As FProdModel,").append('\n').append("  D.FAllocStdData,D.FCommonQty,D.FQty,D.FAssistQty,D.FPrice,D.FAmount,").append('\n').append("  D.FCostItemID, I.FNumber As FCostItemNumber, I.FName_L2 As FCostItemName,").append('\n').append("  D.FAllocStdID, S.FNumber As FAllocStdNumber, S.FName_L2 As FAllocStdName, ").append('\n').append("  D.FCreatorID, CR.FNumber As FCreatorNumber, CR.FName_L2 As FCreatorName,D.FCreateTime,").append('\n').append("  D.FAdjustUserID, AD.FNumber As AdjustUserNumber, AD.FName_L2 As FAdjustUserName,D.FAdjustTime, ").append('\n').append("  BU.FQtyPrecision,CY.FPrecision As FAmountPrecision,MT.FPricePrecision ").append('\n').append("FROM ").append(tblResult).append(" D ").append('\n').append("LEFT OUTER JOIN T_NCM_AllocStd S ON D.FAllocStdID = S.FID ").append('\n').append("LEFT OUTER JOIN T_BD_CostObject O ON D.FCostObjectID = O.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_CostItem I ON D.FCostItemID = I.FID ").append('\n').append("LEFT JOIN T_BD_Material P ON O.FStdProductIDID = P.FID ").append('\n').append("LEFT OUTER JOIN T_PM_User CR ON D.FCreatorID = CR.FID ").append('\n').append("LEFT JOIN T_PM_User AD ON D.FAdjustUserID = AD.FID ").append('\n').append("LEFT OUTER JOIN T_IM_MaterialReqBillEntry ME ON ME.FID=D.FSourceBillEntryID ").append('\n').append("LEFT OUTER JOIN T_BD_MeasureUnit BU ON ME.FUnitID = BU.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_Company COM ON ME.FCompanyOrgUnitID = COM.FID ").append('\n').append("LEFT OUTER JOIN T_BD_Currency CY ON COM.FBaseCurrencyID = CY.FID ").append('\n').append("LEFT OUTER JOIN T_BD_Material MT ON ME.FMaterialID = MT.FID ").append('\n').append("WHERE D.FCompanyID ='").append(companyId).append("' AND D.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND D.FSourceBillID='").append(sourceBillId).append("' AND D.FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append("Order by O.FNumber ").append('\n');
        Context ctx = (Context)this._param.get("ctx");
        try {
            return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e);
        }
    }

    protected boolean IsOnlyNotZero_AllcoStdData() {
        return this._param.get("isOnlyNotZero").equals(String.valueOf(true));
    }

    private void dealWhenOnlyRangeChange() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String sourceBillId = this._param.get("sourceBillId").toString();
        String sourceBillEntryId = this._param.get("sourceBillEntryId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String tblResult_Adjust = this.getAllocTable().GetResultTable();
        String tblResult = null;
        try {
            tblResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_MatAllocResult");
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, (Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ").append(tblResult_Adjust).append(" SET FAllocStdData=0,FQty=0,FPrice=0,FAmount=0 ").append('\n').append("WHERE FCompanyID ='").append(companyId).append("' AND FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append(";").append('\n');
        sb.append("UPDATE ").append(tblResult_Adjust).append(" As D SET (FAllocStdData,FQty,FPrice,FAmount)=( ").append('\n').append("\tSelect S.FAllocStdData,S.FQty,S.FPrice,S.FAmount ").append('\n').append("\tFrom ").append(tblResult).append(" S ").append('\n').append("\tWHERE S.FCompanyID ='").append(companyId).append("' AND S.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  \t\tAND S.FSourceBillID='").append(sourceBillId).append("' AND S.FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append("\t\tAND S.FCompanyID=D.FCompanyID AND S.FCalculatePeriodID=D.FCalculatePeriodID ").append('\n').append("\t\tAND S.FSourceBillID=D.FSourceBillID AND S.FSourceBillEntryID=D.FSourceBillEntryID ").append('\n').append("\t\tAND S.FCostCenterID=D.FCostCenterID AND S.FCostObjectID=D.FCostObjectID ").append('\n').append(");").append('\n');
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append("Delete from ").append(tblResult_Adjust).append('\n').append("WHERE FCompanyID ='").append(companyId).append("' AND FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  \tAND FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append("\tAND FAllocStdData=0 ").append('\n').append(";").append('\n');
        }
        try {
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e);
        }
    }

    public void preAllocProcess() throws AllocateException {
    }

    public void endAllocProcess() throws AllocateException {
    }
}

