/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.app.Calc.Helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.ncm.cal.CheckCalTypeEnum;
import com.kingdee.eas.ncm.cal.app.Calc.Helper.CalcExceptionLog;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.common.utils.NCMCommonParams;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.dynamic.cal.DynCalcLogCollection;
import com.kingdee.eas.ncm.dynamic.cal.DynCalcLogFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.Assert;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynCalcExceptionLog
extends CalcExceptionLog {
    private Context _ctx = null;
    private String _companyId = null;
    private String _periodId = null;
    private String _userId = null;
    private static Logger logger = Logger.getLogger((String)DynCalcExceptionLog.class.getName());

    public DynCalcExceptionLog(Map param) throws BOSException {
        super(param);
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("ctx"));
        this._companyId = (String)param.get("companyId");
        this._periodId = (String)param.get("periodId");
        this._ctx = (Context)param.get("ctx");
        this._userId = (String)param.get("userId");
        this.ClearPreCalcLog();
    }

    public DynCalcExceptionLog(NCMCommonParams param) throws BOSException {
        super(param);
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("ctx"));
        this._companyId = param.getCOMPANY_ID();
        this._periodId = param.getPERIOD_ID();
        this._ctx = param.getCTX();
        this._userId = param.getUSER_ID();
        this.ClearPreCalcLog();
    }

    private void ClearPreCalcLog() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM T_NCM_DynCalcLogEntry WHERE EXISTS( ").append("\tSelect 1 ").append("\tFROM T_NCM_DynCalcLog L ").append("\tWHERE L.FID=T_NCM_DynCalcLogEntry.FParentID AND L.FCompanyID='").append(this._companyId).append("' AND L.FPeriodId='").append(this._periodId).append("' ").append(");").append("DELETE FROM T_NCM_DynCalcLog WHERE FCompanyID='").append(this._companyId).append("' AND FPeriodId='").append(this._periodId).append("';");
        NCMServerUtils.BatchSqlExecute((Context)this._ctx, (String)sb.toString(), (String)";");
    }

    public void AddCalcLog(int dispRank, String costObjectDispName, String calcItem, String status, String attachment, boolean hasDetailLog, String costObjectID, int sort) throws BOSException {
        String rankStr = MessageFormat.format(CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_Rank"), String.valueOf(dispRank));
        int hasDetail = 0;
        if (hasDetailLog) {
            hasDetail = 1;
        }
        this._writeLog(rankStr, costObjectDispName, calcItem, status, attachment, hasDetail, costObjectID, sort);
    }

    public void AddCalcDetailLog(StringBuffer sb, String costObjectID, String allocErrorInfo, String possibleReason, String adviceHandle, CheckCalTypeEnum calcItemType) {
        sb.append("INSERT INTO T_NCM_DynCalcLogEntry(FID,FParentId,FErrorInfo,FPossibleReason,FAdviceHandle,FCalcItemType) ").append('\n').append(" SELECT newbosid('5495C765')As FID,S.FID As FParentId,'").append(allocErrorInfo).append("','").append(possibleReason).append("','").append(adviceHandle).append("', ").append(calcItemType.getValue()).append(" FROM T_NCM_DynCalcLog S ").append(" WHERE FCostObjectID='").append(costObjectID).append("';");
    }

    public void AddCalcLog_Head(int dispRank, String costObjectID) throws BOSException {
        String rankStr = MessageFormat.format(CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_Rank"), String.valueOf(dispRank));
        this._writeLog(rankStr, "", CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_CostCal"), CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_BeginCal"), "", 0, costObjectID, 0);
    }

    public void AddCalcLog_PreSet(int rank, int DispRank) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String rankStr = MessageFormat.format(CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_Rank"), String.valueOf(DispRank));
        String calcItem = ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"22_DynCalcExceptionLog", (Locale)this._ctx.getLocale());
        String status = CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_Sucess");
        sb.append("INSERT INTO T_NCM_DynCalcLog (FID,FCompanyID,FPeriodId,FCreatorID,FCreateTime,").append("\tFCalcRank,FCostObjectDispName,FCalcItem,FStatus,FAttachment,FHasDetailLog,FCostObjectID)").append('\n').append("SELECT newbosid('9DE7F10D'),'").append(this._companyId).append("' As FCompanyID,'").append(this._periodId).append("' As FPeriodId,").append("\t'").append(this._userId).append("' As FCreatorID, GetDate(),").append("\t'").append(rankStr).append("' As FCalcRank, SUBT.FCostObjectDispName,").append("\t'").append(calcItem).append("' As FCalcItem,'").append(status).append("' As FStatus,'' As FAttachment, 0 As FHasDetailLog, SUBT.FCostObjectID ").append('\n').append(" FROM ").append('\n').append(" (SELECT DISTINCT B.FCostObjectID ,CO.FName_L2 ||'('||CO.FNumber||')' As FCostObjectDispName ,B.FRank , CO.FNumber").append('\n').append(" FROM T_CAL_CostObjectRank A ").append('\n').append(" LEFT OUTER JOIN T_CAL_CostObjectRankENTRY B ON A.FID = B.FPARENTID").append(" INNER JOIN T_BD_CostObject CO ON CO.FID=B.FCostObjectID AND CO.FCompanyID=A.FCOMPANYORG ").append('\n').append(" WHERE A.FLlcType=2 AND A.FBillStatus =4 AND B.FRank =").append(String.valueOf(rank)).append(" \tAND A.FCOMPANYORG =? ").append(" ) AS SUBT ").append('\n').append(" ORDER BY SUBT.FRank DESC, SUBT.FNumber ");
        DbUtil.execute((Context)this._ctx, (String)sb.toString(), (Object[])new String[]{this._companyId});
    }

    public void UpdatePreSetCalcLog(int dispRank) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String rankStr = MessageFormat.format(CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_Rank"), String.valueOf(dispRank));
        String status = CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_Fail");
        String attachment = CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_ErrorLog");
        sb.append("UPDATE T_NCM_DynCalcLog AS D SET (FStatus,FAttachment,FHasDetailLog ,FCalcItem)=(").append("\tSelect top 1 '").append(status).append("' As FStatus,'").append(attachment).append("' As FAttachment,1 ").append("   , CASE S.FCalcItemType WHEN 3 THEN '").append(CheckCalTypeEnum.ALLOCWIP.getAlias()).append("   ' WHEN 4 THEN '").append(CheckCalTypeEnum.ALLOCCLASSICO.getAlias()).append("   ' ELSE '").append(CheckCalTypeEnum.factCostCal.getAlias()).append("' END ").append("  FROM T_NCM_DynCalcLogEntry S ").append("  WHERE S.FParentId=D.FID ").append(" ) ").append("WHERE D.FCalcRank='").append(rankStr).append("' AND D.FCompanyID='").append(this._companyId).append("' AND D.FPeriodId='").append(this._periodId).append("' ");
        DbUtil.execute((Context)this._ctx, (String)sb.toString());
    }

    public DynCalcLogCollection GetDynCalcLogData() {
        try {
            return DynCalcExceptionLog.GetDynCalcLogData(this._ctx, this._companyId, this._periodId);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            return null;
        }
    }

    public static DynCalcLogCollection GetDynCalcLogData(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT calcRank, costObjectDispName, calcItem, status, attachment, hasDetailLog, createTime, sort,").append("entries.*, company.*, period.*, creator.* ").append("WHERE company.id = '").append(companyId).append("' AND period.id='").append(periodId).append("'").append(" order by calcRank, sort desc, costObjectDispName  , entries.errorInfo ");
        return DynCalcLogFactory.getLocalInstance(ctx).getDynCalcLogCollection(sb.toString());
    }

    private void _writeLog(String calcRank, String costObjectDispName, String calcItem, String status, String attachment, int hasDetailLog, String costObjectId, int sort) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO T_NCM_DynCalcLog (FID,FCompanyID,FPeriodId,FCreatorID,FCreateTime,").append("\tFCalcRank,FCostObjectDispName,FCalcItem,FStatus,FAttachment,FHasDetailLog,FCostObjectID,FSort)").append(" SELECT newbosid('9DE7F10D'),SUBT.* ").append('\n').append(" FROM ( SELECT DISTINCT '").append(this._companyId).append("' A,'").append(this._periodId).append("' B,'").append(this._userId).append("' C,GetDate() D,'").append(calcRank).append("' E,'").append(costObjectDispName).append("' F,'").append(calcItem).append("' G,'").append(status).append("' H,'").append(attachment).append("' I,").append(hasDetailLog).append(" J,'").append(costObjectId).append("' K,").append(String.valueOf(sort)).append(" L ").append('\n').append(" FROM T_NCM_DynCalcLog WHERE NOT EXISTS ").append('\n').append("( SELECT 1 FROM T_NCM_DynCalcLog WHERE FCompanyId =? AND FPeriodId = ? AND FCostObjectID = ? ").append("  AND fcalcRank = ? )").append(" ) AS SUBT ").append('\n');
        DbUtil.execute((Context)this._ctx, (String)sb.toString(), (Object[])new String[]{this._companyId, this._periodId, costObjectId, calcRank});
    }
}

