/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.app.DCChecker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.DCCMCalChecker;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class CostCenterChecker
extends DCCMCalChecker {
    public CalCostCheckItemCheckResultCollection calChecker(Context ctx, String CompanyOrgID, String callPeriodId, String PeriodId) throws BOSException, EASBizException {
        CalCostCheckItemCheckResultCollection results = new CalCostCheckItemCheckResultCollection();
        try {
            this._check(ctx, CompanyOrgID, callPeriodId, PeriodId, results);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return results;
    }

    private void _check(Context ctx, String companyOrgID, String callPeriodId, String periodId, CalCostCheckItemCheckResultCollection results) throws BOSException, SQLException {
        CompanyOrgUnitInfo company = null;
        PeriodInfo period = null;
        try {
            company = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(companyOrgID));
            period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct fid,fname_l2 from (").append(" (select distinct cc.Fid,cc.fname_l2 from T_IM_MaterialReqBill mb ").append(" inner  join T_SCM_TransactionType tt ").append(" on mb.FTransactionTypeID = tt.FId  ").append(" left outer join T_IM_MaterialReqBillEntry mbe ").append(" on mbe.FParentId = mb.FId ").append(" left outer join T_ORG_CostCenter cc ").append(" on mbe.FCostCenterOrgUnitID = cc.FId ").append(" where  mbe.FCompanyOrgUnitId = ?  and  tt.FIsManuCostCalculate = 1 and cc.FCostCenterType = 0  ").append(" and mb.FBizDate >= TO_DATE('" + dateFormate.format(period.getBeginDate()) + "') ").append(" and mb.FBizDate <= TO_DATE('" + dateFormate.format(period.getEndDate()) + "') ").append(" )").append(" union").append(" (select distinct cc.Fid,cc.fname_l2 from T_NCM_OtherFeeBill ofb ").append(" left outer join T_ORG_CostCenter cc  ").append(" on  ofb.FCostCenterID = cc.FId").append(" where ofb.FCompanyOrg = ?  and cc.FCostCenterType = 0 ").append(" and ofb.FBizDate >= TO_DATE('" + dateFormate.format(period.getBeginDate()) + "') ").append(" and ofb.FBizDate <= TO_DATE('" + dateFormate.format(period.getEndDate()) + "') ").append(" )").append(" )").append("as CostCenter where  fid is not null ");
        Object[] param = new Object[]{company.getId().toString(), company.getId().toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        if (rs.next()) {
            return;
        }
        CalCostCheckItemCheckResultInfo result = new CalCostCheckItemCheckResultInfo();
        result.setDescription(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"27_CostCenterChecker", (Locale)ctx.getLocale()));
        result.setReason(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"24_CompanySetPeriodTypeChecker", (Locale)ctx.getLocale()) + company.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"28_CostCenterChecker", (Locale)ctx.getLocale()));
        result.setSuggestOperation(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"29_CostCenterChecker", (Locale)ctx.getLocale()));
        results.add(result);
    }
}

