/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.app.DCChecker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCheckResultInfo;
import com.kingdee.eas.ncm.cal.app.DCCMCalChecker;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class MaterialFeeUnAssignedChecher
extends DCCMCalChecker {
    private static Logger logger = Logger.getLogger((String)MaterialFeeUnAssignedChecher.class.getName());
    private static final char CLF = '\n';
    private CalCostCheckItemCheckResultCollection rc;

    public CalCostCheckItemCheckResultCollection calChecker(Context ctx, String CompanyOrgID, String callPeriodId, String PeriodId) throws BOSException, EASBizException {
        this.rc = new CalCostCheckItemCheckResultCollection();
        this.checktable(ctx, CompanyOrgID, callPeriodId, PeriodId);
        return this.rc;
    }

    private void checktable(Context ctx, String CompanyOrgID, String callPeriodId, String PeriodId) throws BOSException {
        String tblAllocResult = null;
        try {
            tblAllocResult = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)CompanyOrgID, (String)"T_NCM_DynMatAllocResult");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        com.kingdee.eas.basedata.assistant.PeriodInfo callPeriod = null;
        PeriodInfo period = null;
        try {
            callPeriod = (com.kingdee.eas.basedata.assistant.PeriodInfo)com.kingdee.eas.basedata.assistant.PeriodFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(callPeriodId));
            period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(PeriodId));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT B.FNumber,E.FSeq").append('\n').append("FROM T_IM_MaterialReqBill B").append('\n').append("LEFT OUTER JOIN T_IM_MaterialReqBillEntry E ON B.FID = E.FParentID").append('\n').append("LEFT OUTER JOIN T_ORG_CostCenter C ON E.FCostCenterOrgUnitID = C.FID").append('\n').append("LEFT OUTER JOIN T_SCM_TransactionType TT ON B.FTransactionTypeID = TT.FID").append('\n').append("WHERE B.FBaseStatus=4  AND E.FCompanyOrgUnitID=? AND C.FCostCenterType=0 AND TT.FIsManuCostCalculate=1 ").append('\n').append("    and B.FBizDate >= TO_DATE('" + dateFormate.format(period.getBeginDate()) + "') ").append("    and B.FBizDate <= TO_DATE('" + dateFormate.format(period.getEndDate()) + "') ").append("\tAND NOT EXISTS(").append('\n').append("  \t\tSELECT 1").append('\n').append("\t\tFROM ").append(tblAllocResult).append(" S").append('\n').append("\t\tWHERE S.FSourceBillID=B.FID AND S.FSourceBillEntryID=E.FID AND S.FCompanyID=? AND S.FCalculatePeriodID=?").append('\n').append("\t)").append('\n');
        Object[] param = new Object[]{CompanyOrgID, CompanyOrgID, PeriodId};
        IRowSet rs = null;
        String reason = CalSeverUtils.getNcmCheckResource((Context)ctx, (String)"CheckErrReason_MaterialFeeUnAssignedChecher");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            while (rs.next()) {
                CalCostCheckItemCheckResultInfo rinfo = new CalCostCheckItemCheckResultInfo();
                rinfo.setDescription(CalSeverUtils.getNcmCheckResource((Context)ctx, (String)"CheckErrDescription_MaterialFeeUnAssignedChecher"));
                rinfo.setReason(MessageFormat.format(reason, rs.getString("FNumber"), rs.getString("FSeq")));
                rinfo.setSuggestOperation(CalSeverUtils.getNcmCheckResource((Context)ctx, (String)"CheckErrSuggest_MaterialFeeUnAssignedChecher"));
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

