/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.cal.report.app.MAAllocDetailReport;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.dynamic.cal.utils.CalPeriodUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class DynMAAllocDetailReport
extends MAAllocDetailReport {
    protected IRowSet getReportData(String reportID, RptParams filter) throws BaseException {
        return null;
    }

    protected String buildReportDataTableName(RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        String tempTableName = this.getTempTable();
        this.initTempTblData(filter, tempTableName);
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTableName + "(FTotalRow2,FCompanyOrgName,FPeriodNumber,FNumber,FCommonQty,FQty,FAssistQty,FPrice,FAmount,FCommonqtyPrecision,FqtyPrecision,FAssistqtyPrecision,FPricePrecision)\n");
        sb.append("SELECT 100,FCompanyOrgName,FPeriodNumber,'" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"54_DynMAAllocDetailReport", (Locale)ctx.getLocale()) + "'");
        sb.append(",SUM(FCommonQty),SUM(FQty),SUM(FAssistQty),CASE SUM(FQty) WHEN 0 THEN 0 ELSE  TO_Decimal(SUM(FAmount),21,8)/TO_Decimal(SUM(FQty),21,8) END ,SUM(FAmount)\n");
        sb.append(",isnull(max(FCommonqtyPrecision),4),isnull(max(FqtyPrecision),0),isnull(max(FAssistqtyPrecision),4),isnull(max(FPricePrecision),0)\n");
        sb.append(" FROM " + tempTableName + "\n");
        sb.append(" GROUP BY FCompanyOrgName,FPeriodNumber ");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTableName + "(FTotalRow,FTotalRow2,FItemName,FCommonQty,FQty,FAssistQty,FPrice,FAmount,FCommonqtyPrecision,FqtyPrecision,FAssistqtyPrecision,FPricePrecision)\n");
        sb.append("SELECT 105,105,'" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"0_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "'");
        sb.append(",SUM(FCommonQty),SUM(FQty),SUM(FAssistQty),CASE SUM(FQty) WHEN 0 THEN 0 ELSE  TO_Decimal(SUM(FAmount),21,8)/TO_Decimal(SUM(FQty),21,8) END ,SUM(FAmount)\n");
        sb.append(",isnull(max(FCommonqtyPrecision),4),isnull(max(FqtyPrecision),0),isnull(max(FAssistqtyPrecision),4),isnull(max(FPricePrecision),0)\n");
        sb.append(" FROM " + tempTableName);
        sb.append(" where FTotalRow2<>100");
        DbUtil.execute((Context)this.getContext(), (String)sb.toString());
        return tempTableName;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tableName = this.buildReportDataTableName(filter);
        this.setTablename(tableName);
        return super.getTablename();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        String sql = "SELECT * FROM " + tableName + " Order by  FTotalRow,FCompanyOrgName,FPeriodNumber,FTotalRow2,FNumber,FCostCenterNumber,FItemNumber,FSeq";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (int)start, (int)rows);
        return rs;
    }

    private void initTempTblData(RptParams filter, String tempTableName) throws BOSException {
        String tableName;
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String companyID = companyInfo.getId().toString();
        String companyName = companyInfo.getName();
        try {
            tableName = NCMDynamicTableManager.getPhysicalTblNameForReportNor((Context)this.getContext(), (String)companyID, (String)"T_NCM_DynMatAllocResult");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String L2 = this.getContext().getLocale().getDisplayName();
        StringBuffer sb = new StringBuffer();
        this.getDataFromSpecialBill(companyID, companyName, L2, tableName, tempTableName, "t_im_MaterialReqBill", "t_im_MaterialReqBillEntry", filter, sb);
        this.getDataFromSpecialBill(companyID, companyName, L2, tableName, tempTableName, "T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry", filter, sb);
        this.getDataFromSpecialBill(companyID, companyName, L2, tableName, tempTableName, "T_CL_CostAdjustBill", "T_CL_CostAdjustBillEntry", filter, sb);
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sb.toString());
    }

    private void getDataFromSpecialBill(String companyID, String companyName, String L2, String tableName, String tempTableName, String phsicalTblBill, String phsicalTblEntry, RptParams filter, StringBuffer sb) throws BOSException {
        sb.append("INSERT INTO " + tempTableName + "(FID,FCompanyOrgName,FPeriodNumber,FCostCenterNumber,FCostCenterName,FNumber \n");
        sb.append(",FSeq,FItemNumber,FItemName,FItemModel,FItemShortName,FUnitCommonName,FUnitName,FUnitAssistName,FLot,FCostObjectNumber,FCostObjectName,FProductModel,FProductShortName,FBatchNumber");
        sb.append(",FCostItemNumber,FCostItemName,FCommonQty,FQty,FAssistQty,FCommonqtyPrecision,FqtyPrecision,FAssistqtyPrecision,FPrice,FPricePrecision,FAmount,FAllocStdName");
        sb.append(",FAllocStdData)\n");
        sb.append("SELECT t1.FSourceBillID, '" + companyName + "',TO_CHAR(t2.FNumber),t3.FNumber,t3.FName_" + L2 + ",isnull(v.FNumber,' ') \n");
        sb.append(",isnull(u.FSeq,0),t6.FNumber,t6.FName_" + L2 + ",t6.FModel,t6.FShortName" + ",commonUnit.FName_" + L2 + ",unit.FName_" + L2 + " , assistUnit.FName_" + L2 + ",t1.FLot,t7.FNumber,t7.FName_" + L2 + ",t8.FModel,t8.FShortName,t7.FbatchNumber");
        sb.append(",t9.FNumber,t9.FName_" + L2 + ",t1.FCommonQty,t1.FQty,t1.FAssistQty,ISNULL(mmu.FqtyPrecision,4),ISNULL(mmu1.FqtyPrecision,4),ISNULL(mmu2.FqtyPrecision,4),t1.FPrice,ISNULL(t8.FPricePrecision,2),t1.FAmount,t10.FName_" + L2 + ",t1.FAllocStdData \n");
        sb.append(" from " + tableName + " t1 \n");
        sb.append(" inner join T_NCM_Period t2 on t1.FCalculatePeriodID = t2.FID \n ");
        sb.append(" join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID \n");
        sb.append(" join ").append(phsicalTblBill).append(" v on t1.FSourceBillID = v.FID \n");
        sb.append(" join ").append(phsicalTblEntry).append(" u on t1.FSourceBillEntryID = u.FID  \n");
        sb.append(" join T_BD_CostObject t7 on t1.FCostObjectID = t7.FID  \n");
        sb.append(" join t_bd_material t6 on t1.FMaterialID = t6.FID  \n");
        sb.append(" LEFT  JOIN T_BD_MaterialCompanyInfo ON T_BD_MaterialCompanyInfo.FMaterialID=t7.FStdProductIDID and t1.FCompanyID=T_BD_MaterialCompanyInfo.FCompanyID \n");
        sb.append(" LEFt  JOIN T_BD_Material t8 ON t8.FID=T_BD_MaterialCompanyInfo.FMaterialID \n");
        sb.append(" Left  join t_bd_MeasureUnit commonUnit on u.FUnitID = commonUnit.FID \n");
        sb.append(" Left  join t_bd_MeasureUnit unit on t6.FBaseUnit = unit.FID \n");
        sb.append(" Left  join t_bd_MeasureUnit assistUnit on t6.FAssistUnit = assistUnit.FID \n");
        sb.append(" Left JOIN t_bd_multiMeasureUnit mmu on  t1.FMaterialID=mmu.FMaterialID and commonUnit.fid=mmu.FMeasureUnitID ");
        sb.append(" Left JOIN t_bd_multiMeasureUnit mmu1 on  t1.FMaterialID=mmu1.FMaterialID and unit.fid=mmu1.FMeasureUnitID   ");
        sb.append(" Left JOIN t_bd_multiMeasureUnit mmu2 on  t1.FMaterialID=mmu2.FMaterialID and assistUnit.fid=mmu2.FMeasureUnitID ");
        sb.append(" join t_Ncm_Costitem t9 on t1.FCostItemID = t9.FID  \n");
        sb.append(" left  join  T_NCM_AllocStd t10 on t1.FAllocStdID = t10.FID  ");
        sb.append(" where t1.FCompanyID = '" + companyID + "' \n");
        this.buildFilter(filter, sb, companyID);
    }

    private void buildFilter(RptParams filter, StringBuffer sb, String companyID) {
        PeriodInfo periodInfo;
        if (filter.getObject("norStartPeriod") != null) {
            periodInfo = (PeriodInfo)filter.getObject("norStartPeriod");
            sb.append(" and v.FBizDate >= TO_DATE('").append(Constants.FORMAT_TIME.format(periodInfo.getBeginDate())).append("') and t2.FBeginDate >=TO_DATE('").append(Constants.FORMAT_TIME.format(periodInfo.getBeginDate())).append("')");
        }
        if (filter.getObject("norEndPeriod") != null) {
            periodInfo = (PeriodInfo)filter.getObject("norEndPeriod");
            sb.append(" and v.FBizDate <= TO_DATE('").append(Constants.FORMAT_TIME.format(periodInfo.getEndDate())).append("') and t2.FBeginDate <=TO_DATE('").append(Constants.FORMAT_TIME.format(periodInfo.getEndDate())).append("')");
        }
        if (filter.getString("costcenterFrom") != null && !"".equals(filter.getString("costcenterFrom"))) {
            sb.append(" and t3.FNumber >='").append(filter.getString("costcenterFrom")).append("'");
        }
        if (filter.getString("costcenterTo") != null && !"".equals(filter.getString("costcenterTo"))) {
            sb.append(" and t3.FNumber <='").append(filter.getString("costcenterTo")).append("'");
        }
        if (filter.getString("itemFrom") != null && !"".equals(filter.getString("itemFrom"))) {
            sb.append(" and t6.FNumber >='").append(filter.getString("itemFrom")).append("'");
        }
        if (filter.getString("itemTo") != null && !"".equals(filter.getString("itemTo"))) {
            sb.append(" and t6.FNumber <='").append(filter.getString("itemTo")).append("'");
        }
        if (filter.getString("costobjectFrom") != null && !"".equals(filter.getString("costobjectFrom"))) {
            sb.append(" and t7.FNumber >='").append(filter.getString("costobjectFrom")).append("'");
        }
        if (filter.getString("costobjectTo") != null && !"".equals(filter.getString("costobjectTo"))) {
            sb.append(" and t7.FNumber <='").append(filter.getString("costobjectTo")).append("'");
        }
        if (filter.getString("costitemFrom") != null && !"".equals(filter.getString("costitemFrom"))) {
            sb.append(" and t9.FNumber >='").append(filter.getString("costitemFrom")).append("'");
        }
        if (filter.getString("costitemTo") != null && !"".equals(filter.getString("costitemTo"))) {
            sb.append(" and t9.FNumber <='").append(filter.getString("costitemTo")).append("'");
        }
        sb.append(" ;\n");
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"2_DynByClassCostCalReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"3_DynByClassCostCalReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"55_DynMAAllocDetailReport", (Locale)ctx.getLocale()) + filter.getObject("norStartPeriod").toString() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"56_DynMAAllocDetailReport", (Locale)ctx.getLocale()) + filter.getObject("norEndPeriod").toString() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"6_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"17_DynCCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costcenterFrom"), (String)filter.getString("costcenterTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"57_DynMAAllocDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("itemFrom"), (String)filter.getString("itemTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"58_DynMAAllocDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costobjectFrom"), (String)filter.getString("costobjectTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"59_DynMAAllocDetailReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costitemFrom"), (String)filter.getString("costitemTo")));
        return titles;
    }

    private String getFormatDate(java.util.Date periodDate, boolean isBegin) {
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date formaDate = null;
        if (isBegin) {
            GregorianCalendar beginCalendar = new GregorianCalendar();
            beginCalendar.setTime(periodDate);
            beginCalendar.set(11, 0);
            beginCalendar.set(12, 0);
            beginCalendar.set(13, 0);
            formaDate = new Date(beginCalendar.getTime().getTime());
        } else {
            GregorianCalendar endCalendar = new GregorianCalendar();
            endCalendar.setTime(periodDate);
            endCalendar.set(11, 23);
            endCalendar.set(12, 59);
            endCalendar.set(13, 59);
            formaDate = new Date(endCalendar.getTime().getTime());
        }
        String strDate = "TO_DATE('" + dateFormate.format(formaDate) + "')";
        return strDate;
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        BigDecimal totalRow = (BigDecimal)rowData.get("FTOTALROW");
        if (totalRow.compareTo(SysConstant.BIGZERO) == 0) {
            RptParams params = new RptParams();
            Object companyOrg = totalFilter.getObject("companyorg");
            if (companyOrg == null) {
                companyOrg = ContextUtil.getCurrentFIUnit((Context)this.getContext());
            }
            params.setObject("companyorg", companyOrg);
            String periodNumer = (String)rowData.get("FPERIODNUMBER");
            HashSet<String> numbers = new HashSet<String>();
            numbers.add(periodNumer);
            Map periods = CalPeriodUtils.getPeriods(this.getContext(), ((CompanyOrgUnitInfo)companyOrg).getId().toString(), numbers);
            if (periods.containsKey(periodNumer)) {
                params.setObject("norStartPeriod", periods.get(periodNumer));
                params.setObject("norEndPeriod", periods.get(periodNumer));
            }
            params.setString("costcenterFrom", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("costcenterTo", (String)rowData.get("FCOSTCENTERNUMBER"));
            params.setString("itemFrom", (String)rowData.get("FITEMNUMBER"));
            params.setString("itemTo", (String)rowData.get("FITEMNUMBER"));
            params.setString("costobjectFrom", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("costobjectTo", (String)rowData.get("FCOSTOBJECTNUMBER"));
            params.setString("costitemFrom", (String)rowData.get("FCOSTITEMNUMBER"));
            params.setString("costitemTo", (String)rowData.get("FCOSTITEMNUMBER"));
            return params;
        }
        throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow2", (Object)new BigDecimal(100), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow", 1, (Object)new BigDecimal(105), a);
        return conditions;
    }
}

