/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.CReportViewHandle;
import com.kingdee.eas.ncm.cal.report.app.OtherCostAllocTotalReport;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DynOtherCostAllocTotalReport
extends OtherCostAllocTotalReport {
    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        String tempTableName;
        Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.DynOtherCostAllocTotalReport");
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        if (filter == null) {
            return null;
        }
        this.dealFilter(filter, logger, ctx);
        if (filter.getObject("companyorg") == null || !(filter.getObject("companyorg") instanceof CompanyOrgUnitInfo)) {
            return null;
        }
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        String tableName = null;
        try {
            tableName = NCMDynamicTableManager.getPhysicalTblNameForReportNor((Context)this.getContext(), (String)companyID, (String)"T_NCM_DynOtherAllocResult");
        }
        catch (EASBizException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw e1;
        }
        catch (SQLException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table t2 ( ");
        createTable.append(" FPeriodNumber varchar(80) ");
        createTable.append(" , FExpenseID varchar(44) ");
        createTable.append(" , FExpenseNumber varchar(80) ");
        createTable.append(" , FExpenseName varchar(255) ");
        createTable.append(" , FCostCenterID varchar(44) ");
        createTable.append(" , FCostCenterNumber varchar(80) ");
        createTable.append(" , FCostCenterName varchar(255) ");
        createTable.append(" , FCostObjectID varchar(44) ");
        createTable.append(" , FCostObjectNumber varchar(80)  ");
        createTable.append(" , FCostObjectName varchar(255) ");
        createTable.append(" , FProductModel nvarchar(255) ");
        createTable.append(" , FProductShortName nvarchar(80) ");
        createTable.append(" , FCostItemID varchar(80) ");
        createTable.append(" , FCostItemNumber varchar(80)  ");
        createTable.append(" , FCostItemName varchar(255) ");
        createTable.append(" , FQty decimal(19,4) ");
        createTable.append(" , FQtyPrecision int default(0) ");
        createTable.append(" , FPrice decimal(19,4) ");
        createTable.append(" , FPricePrecision int default(2) ");
        createTable.append(" , FAmount decimal(19,4) ");
        createTable.append(" , FTotalRow decimal(28,16) not null default(0) ");
        createTable.append(" , FTotalRow2 decimal(28,16) not null default(0) ");
        createTable.append(" , FIsTotalRow int not null default(1) ");
        createTable.append(" , FTotalCostCenterRow int not null default(0) ");
        createTable.append(" , FTotalCostObjectRow int not null default(0) ");
        createTable.append(" , FTotalExpenseRow int not null default(0) ");
        createTable.append(" , FTotalCostItemRow int not null default(0) ");
        createTable.append(" ,FTotalCostObjectSuiteRow int not null default(0) ");
        createTable.append(" ) ");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO " + tempTableName + " ( FPeriodNumber, " + " FExpenseID, FExpenseNumber, FExpenseName, " + " FCostCenterID, FCostCenterNumber, FCostCenterName, " + " FCostObjectID, FCostObjectNumber, FCostObjectName, " + " FProductModel, FProductShortName," + " FCostItemID, FCostItemNumber, FCostItemName, " + " FQty , FPrice , FAmount, FIsTotalRow) \n");
        sb.append(" SELECT  t2.fnumber ,  w.FID, w.FNumber, w.FName_" + locale + ", " + " t3.FID, t3.FNumber, t3.FName_" + locale + ", " + " t4.FID, t4.FNumber, t4.FName_" + locale + ", " + " t8.fmodel, t8.FShortName, " + " t5.FID, t5.FNumber, t5.FName_" + locale + ", " + " sum(t1.FQty), " + " case when ( sum(t1.FQty)=0 or sum(t1.FQty) is null ) then 0.00 else to_number(sum(t1.FAmount))/to_number(sum(t1.FQty)) end ," + " sum(t1.FAmount), 0 AS FIsTotalRow \n");
        sb.append(" from " + tableName + " t1 \n");
        sb.append(" inner join T_NCM_Period t2 on t1.FCalculatePeriodID = t2.FID \n ");
        sb.append(" inner join t_NCM_OtherFeeBill v on t1.FSourceBillID = v.FID \n");
        sb.append(" inner join T_NCM_Expense w on v.FExpenseID = w.FID \n");
        sb.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sb.append(" left outer join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID  \n");
        sb.append(" left outer join t_bd_material t8 on t4.FStdProductIDID = t8.FID  \n");
        sb.append(" left outer join t_Ncm_Costitem t5 on t1.FCostItemID = t5.FID  \n");
        sb.append(" where t1.FCompanyID = ? \n");
        this.buildFilter(filter, sb);
        sb.append(" group by  t2.fnumber,  w.FID, w.FNumber, w.FName_" + locale + ", " + " t3.FID, t3.FNumber, t3.FName_" + locale + ", " + " t4.FID, t4.FNumber, t4.FName_" + locale + ", " + " t8.fmodel, t8.FShortName, " + " t5.FID, t5.FNumber, t5.FName_" + locale + "  \n");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{companyID});
        Connection cn = null;
        Statement st = null;
        IRowSet rs = null;
        String[] fields = new String[]{"  FExpenseNumber , FCostCenterNumber  ", "  FExpenseNumber "};
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(cn, tempTableName);
            st = cn.createStatement();
            sb = new StringBuffer();
            ArrayList list = this.getGroupByList(this.doPerQuerySolution(filter));
            String groupInsertStr = "";
            for (int i = 0; i < list.size(); ++i) {
                HashMap map = (HashMap)list.get(list.size() - i - 1);
                String field = (String)map.get("groupby");
                groupInsertStr = " insert into " + tempTableName + "(FTotalRow,FTotalRow2," + field + ",Famount,Fqty) \n" + " SELECT " + map.get("totalrow").toString() + ",0," + field + " ,sum(famount),SUM(fqty)\n" + " FROM " + tempTableName + "\n" + " where FTotalRow = 0 \n";
                sb.append(groupInsertStr);
                sb.append(" group by " + field);
                sb.append("\n\n");
                sb.append(";");
            }
            sb.append(" update " + tempTableName + " set FQtyPrecision = ( select isnull(unit.FQtyPrecision,0) " + " from T_NCM_Expense exp left outer join T_BD_MeasureUnit unit on exp.funitid = unit.fid " + " where " + tempTableName + ".FExpenseID = exp.fid  ) , " + " FPricePrecision = ( select isnull(exp.FPricePrecision,0) from T_NCM_Expense exp " + " where " + tempTableName + ".FExpenseID = exp.fid )");
            NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sb.toString());
            sb = new StringBuffer();
            sb.append("INSERT INTO " + tempTableName + " (FExpenseID,FCostCenterID,FCostItemID,  FExpenseNumber, FExpenseName, " + " FCostCenterNumber, FCostCenterName, " + " FCostObjectID, FCostObjectNumber, FCostObjectName, " + " FProductModel, FProductShortName," + " FCostItemNumber, FCostItemName, " + " FAmount,FQty ,FIsTotalRow,FTotalRow2,FQtyPrecision,FTotalRow) \n");
            sb.append("SELECT ");
            sb.append("' ' as fexpenseid,'' as fcostcenterid,'' as FCostItemID,");
            sb.append("N'' as fexpensenumber,'' as fexpensename,");
            sb.append("N'' as fcostcenternumber,N'' as fcostcentername,");
            sb.append("N'' as fcostobjectID,N'' as fcostobjectnumber,N'' as fcostobjectname,");
            sb.append("N'' as FProductModel,N'' as fproductshortname,");
            sb.append("N'' as fcostitemnumber,N'' as fcostitemname,");
            sb.append("sum(FAMOUNT) as famount,");
            sb.append("sum(FQty) as fqty, \n");
            sb.append("1 as FIstotalrow,3 as FTotalRow2, max(isnull(FQtyPrecision,0)),200 AS FTotalRow from \n");
            sb.append(tempTableName);
            sb.append("  where FIsTotalRow = 0");
            sb.append("\n\n");
            sb.append(";");
            st.addBatch(sb.toString());
            String orderBy = this.getShowString(this.doPerQuerySolution(filter)).toString();
            String[] orderStrings = orderBy.split(",");
            String totalFieldNumber = orderStrings[0];
            sb = new StringBuffer();
            sb.append("Update ");
            sb.append(tempTableName);
            sb.append(" set ");
            sb.append(totalFieldNumber);
            sb.append(" = '");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()));
            sb.append("'  where Ftotalrow2 = 3 \n");
            sb.append("\n\n");
            sb.append(";");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + tempTableName + " as t1 set (FCostCenterNumber,FCostCenterName)  =(select  t2.FNumber, t2.FName_L2 \n");
            sb.append(" from T_ORG_CostCenter t2 \n");
            sb.append(" where t1.FCostCenterID = t2.FID) ");
            sb.append("\n\n");
            sb.append(";");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + tempTableName + " as t1 set (FCostObjectNumber ,FCostObjectName,FProductModel,FProductShortName) = (select t2.FNumber,t2.FName_L2, t3.FModel,t3.FShortName \n");
            sb.append(" from  T_BD_CostObject t2 ");
            sb.append(" JOIN T_BD_MaterialCompanyInfo ON T_BD_MaterialCompanyInfo.FMaterialID=t2.FStdProductIDID \n");
            sb.append(" JOIN T_BD_Material t3 ON t3.FID=T_BD_MaterialCompanyInfo.FMaterialID \n");
            sb.append(" where t1.FCostObjectID = t2.FID AND T_BD_MaterialCompanyInfo.FCompanyID='").append(companyID).append("'");
            sb.append(" AND T_BD_MaterialCompanyInfo.FStatus = 1 )");
            sb.append("\n\n");
            sb.append(";");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + tempTableName + " as t1  set (FCostItemNumber, FCostItemName )= (select  t2.FNumber,t2.FName_L2 \n");
            sb.append(" from t_Ncm_Costitem t2 where  t1.FCostItemID = t2.FID ) ");
            sb.append("\n\n");
            sb.append(";");
            st.addBatch(sb.toString());
            sb = new StringBuffer();
            sb.append(" update " + tempTableName + " as t1  set (FExpenseNumber, FExpenseName )= (select  t2.FNumber,t2.FName_L2 \n");
            sb.append(" from t_Ncm_Expense t2 where  t1.FExpenseID = t2.FID ) ");
            sb.append("\n\n");
            sb.append(";");
            st.addBatch(sb.toString());
            st.executeBatch();
            sb = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                HashMap map = (HashMap)list.get(i);
                String field = (String)map.get("id");
                String fieldName = field.substring(0, field.length() - 2) + "Name";
                String fieldNumber = field.substring(0, field.length() - 2) + "Number";
                String whichTotal = "";
                if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                    whichTotal = ", FTotalCostCenterRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FCostObjectNumber")) {
                    whichTotal = ", FTotalCostObjectRow = 1 ";
                    fieldNumber = "FCostObjectNumber";
                    fieldName = "FCostObjectName";
                }
                if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                    whichTotal = ", FTotalCostItemRow = 1 ";
                }
                if (fieldNumber.equalsIgnoreCase("FExpenseNumber")) {
                    whichTotal = ", FTotalExpenseRow = 1 ";
                }
                sb.append(" update " + tempTableName + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "'," + fieldNumber + " = " + fieldNumber);
                sb.append(whichTotal);
                sb.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
                sb.append("\n\n");
                sb.append(";");
            }
            sb.append(" DELETE " + tempTableName + " \n");
            sb.append("  WHERE FTOTALROW > 0 \n");
            sb.append("    AND ((FCostCenterName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FCostCenterNumber is null OR FCostCenterNumber = '')) OR \n");
            sb.append("         (FCostObjectName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FCostObjectNumber is null OR FCostObjectNumber = '')) OR \n");
            sb.append("         (FExpenseName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FExpenseNumber is null OR FExpenseNumber = '')) OR \n");
            sb.append("         (FCostItemName = '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "' AND (FCostItemNumber is null OR FCostItemNumber = '')) ) ");
            sb.append("    AND FTotalRow2 != 3 \n");
            sb.append("\n\n;");
            NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sb.toString());
            String sql = this.buildDataSql(filter, tempTableName);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.size() == 1) {
                rs = null;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        SQLUtils.cleanup((Statement)st, (Connection)cn);
        return rs;
    }

    private void buildFilter(RptParams filter, StringBuffer sb) {
        sb.append(" and v.fbillStatus = 4");
        if (filter.getObject("norStartPeriod") != null) {
            PeriodInfo periodStartInfo = (PeriodInfo)filter.getObject("norStartPeriod");
            sb.append(" and t2.FBeginDate >= TO_DATE('");
            sb.append(Constants.FORMAT_TIME.format(periodStartInfo.getBeginDate()));
            sb.append("') \n");
        }
        if (filter.getObject("norStartPeriod") != null) {
            PeriodInfo periodEndInfo = (PeriodInfo)filter.getObject("norEndPeriod");
            sb.append(" and t2.FEndDate <= TO_DATE('");
            sb.append(Constants.FORMAT_TIME.format(periodEndInfo.getEndDate()));
            sb.append("') \n");
        }
        if (filter.getString("costcenterFrom") != null && !"".equals(filter.getString("costcenterFrom"))) {
            sb.append(" and t3.FNumber >='").append(filter.getString("costcenterFrom")).append("'");
        }
        if (filter.getString("costcenterTo") != null && !"".equals(filter.getString("costcenterTo"))) {
            sb.append(" and t3.FNumber <='").append(filter.getString("costcenterTo")).append("'");
        }
        if (filter.getString("expenseFrom") != null && !"".equals(filter.getString("expenseFrom").trim())) {
            sb.append(" and w.FNumber >='").append(filter.getString("expenseFrom")).append("'");
        }
        if (filter.getString("expenseTo") != null && !"".equals(filter.getString("expenseTo"))) {
            sb.append(" and w.FNumber <='").append(filter.getString("expenseTo")).append("'");
        }
        if (filter.getString("costobjectFrom") != null && !"".equals(filter.getString("costobjectFrom"))) {
            sb.append(" and t4.FNumber >='").append(filter.getString("costobjectFrom")).append("'");
        }
        if (filter.getString("costobjectTo") != null && !"".equals(filter.getString("costobjectTo"))) {
            sb.append(" and t4.FNumber <='").append(filter.getString("costobjectTo")).append("'");
        }
        if (filter.getString("costitemFrom") != null && !"".equals(filter.getString("costitemFrom"))) {
            sb.append(" and t5.FNumber >='").append(filter.getString("costitemFrom")).append("'");
        }
        if (filter.getString("costitemTo") != null && !"".equals(filter.getString("costitemTo"))) {
            sb.append(" and t5.FNumber <='").append(filter.getString("costitemTo")).append("'");
        }
    }

    protected void dealFilter(RptParams filter, Logger logger, Context ctx) throws BOSException {
        if (filter.getString("prmtCompanyOrg") != null) {
            String comNumber = filter.getString("prmtCompanyOrg");
            CompanyOrgUnitInfo company = null;
            try {
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(" select id,name,number where number = '" + comNumber + "'");
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            filter.setObject("companyorg", (Object)company);
            filter.remove("prmtCompanyOrg");
        }
        if (filter.getObject("prmtNorStartPeriod") != null) {
            filter.setObject("norStartPeriod", filter.getObject("prmtNorStartPeriod"));
            filter.remove("prmtNorStartPeriod");
        }
        if (filter.getObject("prmtNorEndPeriod") != null) {
            filter.setObject("norEndPeriod", filter.getObject("prmtNorEndPeriod"));
            filter.remove("prmtNorEndPeriod");
        }
        if (filter.getObject("prmtExpenseFrom") != null) {
            filter.setObject("expenseFrom", filter.getObject("prmtExpenseFrom"));
            filter.remove("prmtExpenseFrom");
        }
        if (filter.getObject("prmtExpenseTo") != null) {
            filter.setObject("expenseTo", filter.getObject("prmtExpenseTo"));
            filter.remove("prmtExpenseTo");
        }
        if (filter.getObject("prmtCostCenterFrom") != null) {
            filter.setObject("costcenterFrom", filter.getObject("prmtCostCenterFrom"));
            filter.remove("prmtCostCenterFrom");
        }
        if (filter.getObject("prmtCostCenterTo") != null) {
            filter.setObject("costcenterTo", filter.getObject("prmtCostCenterTo"));
            filter.remove("prmtCostCenterTo");
        }
        if (filter.getObject("prmtCostObjectFrom") != null) {
            filter.setObject("costobjectFrom", filter.getObject("prmtCostObjectFrom"));
            filter.remove("prmtCostObjectFrom");
        }
        if (filter.getObject("prmtCostObjectTo") != null) {
            filter.setObject("costobjectTo", filter.getObject("prmtCostObjectTo"));
            filter.remove("prmtCostObjectTo");
        }
        if (filter.getObject("prmtCostItemFrom") != null) {
            filter.setObject("costitemFrom", filter.getObject("prmtCostItemFrom"));
            filter.remove("prmtCostItemFrom");
        }
        if (filter.getObject("prmtCostItemTo") != null) {
            filter.setObject("costitemTo", filter.getObject("prmtCostItemTo"));
            filter.remove("prmtCostItemTo");
        }
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"2_DynByClassCostCalReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"3_DynByClassCostCalReport", (Locale)ctx.getLocale()) + number);
        String periodFrom = ((PeriodInfo)filter.getObject("norStartPeriod")).getName();
        String periodTo = ((PeriodInfo)filter.getObject("norEndPeriod")).getName();
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"55_DynMAAllocDetailReport", (Locale)ctx.getLocale()) + periodFrom + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"56_DynMAAllocDetailReport", (Locale)ctx.getLocale()) + periodTo + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"6_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"17_DynCCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costcenterFrom"), (String)filter.getString("costcenterTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"18_DynCCFeeTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("expenseFrom"), (String)filter.getString("expenseTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"60_DynMAAllocTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costobjectFrom"), (String)filter.getString("costobjectTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"61_DynMAAllocTotalReport", (Locale)ctx.getLocale()) + CReportViewHandle.HandleTitleString((Context)ctx, (String)filter.getString("costitemFrom"), (String)filter.getString("costitemTo")));
        return titles;
    }

    private String buildDataSql(RptParams filter, String tempTableName) {
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT  * FROM ");
        sql.append(tempTableName);
        sql.append(where);
        sql.append(" Order by  FTotalRow2 ");
        sql.append(orderByMode);
        sql.append(", ");
        ArrayList list = this.getGroupByList(this.doPerQuerySolution(filter));
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String orderByWhichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                orderByWhichTotal = ", FTotalCostCenterRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostobjectNumber")) {
                orderByWhichTotal = ", FTotalCostObjectRow " + orderByMode;
                fieldNumber = "FCostObjectID";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                orderByWhichTotal = ", FTotalCostItemRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FExpenseNumber")) {
                orderByWhichTotal = ", FTotalExpenseRow " + orderByMode;
            }
            if (fieldNumber.equalsIgnoreCase("FCostObjectSuiteNumber")) {
                orderByWhichTotal = ", FTotalCostObjectSuiteRow " + orderByMode;
            }
            sql.append(fieldNumber);
            sql.append(orderByWhichTotal);
            sql.append(",");
        }
        sql.append("FTotalRow");
        return sql.toString();
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                HashMap map = (HashMap)list.get(i);
                if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                String fieldID = (String)map.get("id");
                sb.append(fieldID);
                map.put("groupby", sb.toString());
                map.put("totalrow", new Integer(104 - i));
                newList.add(map);
            }
        }
        return newList;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        Context ctx = this.getContext();
        ReportHeader reportHeader = new ReportHeader();
        String orderBy = this.getShowString(this.doPerQuerySolution(filter)).toString();
        String[] orderStrings = orderBy.split(",");
        boolean isItem = false;
        int index = 0;
        for (int i = 0; i < orderStrings.length; ++i) {
            index = isItem ? i + 2 : i + 1;
            if (orderStrings[i].equalsIgnoreCase("FCostcenterNumber")) {
                reportHeader.addChild("FCostcenterNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"59_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostcenterName")) {
                reportHeader.addChild("FCostcenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"60_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostobjectNumber")) {
                reportHeader.addChild("FCostobjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"61_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostobjectName")) {
                isItem = true;
                reportHeader.addChild("FCostobjectName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"62_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
                reportHeader.addChild("fproductshortname", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"64_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index + 2);
            }
            if (orderStrings[i].equalsIgnoreCase("FExpenseNumber")) {
                reportHeader.addChild("FExpenseNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FExpenseName")) {
                reportHeader.addChild("FExpenseName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"ExpenseName", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostItemNumber")) {
                reportHeader.addChild("FCostItemNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"67_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index + 4);
            }
            if (!orderStrings[i].equalsIgnoreCase("FCostItemName")) continue;
            reportHeader.addChild("FCostItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"68_CostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(index);
        }
        reportHeader.addChild("FQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Qty", (Locale)ctx.getLocale())).setAlign(1).setType(2).setDecimalField("FQtyPrecision");
        reportHeader.addChild("FPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Price", (Locale)ctx.getLocale())).setAlign(1).setType(2).setDecimalField("fpriceprecision");
        reportHeader.addChild("FAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"Amount", (Locale)ctx.getLocale())).setAlign(1).setType(2).setDecimal(4);
        return reportHeader;
    }

    private StringBuffer getShowString(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getField(map));
        }
        return sb;
    }

    private StringBuffer getField(HashMap map) {
        StringBuffer sb = new StringBuffer();
        String field = (String)map.get("id");
        String fieldName = "";
        String fieldNumber = "";
        if (!field.equals("FPeriodName")) {
            fieldName = field.substring(0, field.length() - 2) + "Name";
            fieldNumber = field.substring(0, field.length() - 2) + "Number";
            sb.append(fieldNumber + "," + fieldName);
        } else {
            sb.append(field);
        }
        return sb;
    }

    private ArrayList doPerQuerySolution(RptParams filter) {
        ArrayList tableMain = (ArrayList)filter.getObject("table");
        if (tableMain == null) {
            tableMain = new ArrayList();
            HashMap<String, Object> mapExpense = new HashMap<String, Object>();
            mapExpense.put("groupby", "FExpenseID");
            mapExpense.put("totalrow", "104");
            mapExpense.put("isTotal", Boolean.TRUE);
            mapExpense.put("id", "FExpenseID");
            tableMain.add(mapExpense);
            HashMap<String, Object> mapCostCenter = new HashMap<String, Object>();
            mapCostCenter.put("groupby", "FExpenseID,FCostCenterID");
            mapCostCenter.put("totalrow", "103");
            mapCostCenter.put("isTotal", Boolean.TRUE);
            mapCostCenter.put("id", "FCostCenterID");
            tableMain.add(mapCostCenter);
            HashMap<String, Object> mapCostObject = new HashMap<String, Object>();
            mapCostObject.put("isTotal", Boolean.FALSE);
            mapCostObject.put("id", "FCostObjectID");
            tableMain.add(mapCostObject);
            HashMap<String, Object> mapCostItem = new HashMap<String, Object>();
            mapCostItem.put("isTotal", Boolean.FALSE);
            mapCostItem.put("id", "FCostItemID");
            tableMain.add(mapCostItem);
        }
        return tableMain;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow", (Object)new BigDecimal(100), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow2", 1, (Object)new BigDecimal(3), a);
        return conditions;
    }
}

