/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.PeriodStatusCollection;
import com.kingdee.eas.basedata.ncm.PeriodStatusFactory;
import com.kingdee.eas.basedata.ncm.PeriodStatusInfo;
import com.kingdee.eas.basedata.ncm.utils.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CalPeriodUtils {
    public static void initPrmtPeriodStatu(com.kingdee.eas.basedata.assistant.PeriodInfo currPeriod, KDBizPromptBox prmtPeriod) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodStatus.company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId()));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)currPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)PeriodUtils.getDayEnd((Date)currPeriod.getEndDate()), CompareType.LESS_EQUALS));
        view.setFilter(filter);
        prmtPeriod.setEntityViewInfo(view);
        prmtPeriod.setEditFormat("$number$");
        prmtPeriod.setDisplayFormat("$name$");
        prmtPeriod.setCommitFormat("$number$");
        prmtPeriod.setQueryInfo("com.kingdee.eas.ncm.dynamic.bill.app.PeriodFilterF7Query");
        prmtPeriod.getQueryAgent().resetRuntimeEntityView();
    }

    public static PeriodInfo getFirstPeriod(com.kingdee.eas.basedata.assistant.PeriodInfo currPeriod, CompanyOrgUnitInfo companyOrg) throws BOSException {
        return CalPeriodUtils.getBeginOrEndPeriod(currPeriod, companyOrg, true);
    }

    public static PeriodInfo getEndPeriod(com.kingdee.eas.basedata.assistant.PeriodInfo currPeriod, CompanyOrgUnitInfo companyOrg) throws BOSException {
        return CalPeriodUtils.getBeginOrEndPeriod(currPeriod, companyOrg, false);
    }

    private static PeriodInfo getBeginOrEndPeriod(com.kingdee.eas.basedata.assistant.PeriodInfo currPeriod, CompanyOrgUnitInfo companyOrg, boolean isBeginPeriod) throws BOSException {
        if (currPeriod == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("period.name");
        selector.add("period.number");
        selector.add("number");
        selector.add("*");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrg.getId()));
        filter.getFilterItems().add(new FilterItemInfo("statu", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("period.beginDate", (Object)currPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period.endDate", (Object)PeriodUtils.getDayEnd((Date)currPeriod.getEndDate()), CompareType.LESS_EQUALS));
        view.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("period.number");
        if (!isBeginPeriod) {
            sorter.setSortType(SortType.DESCEND);
        }
        view.getSorter().add(sorter);
        PeriodStatusCollection coll = PeriodStatusFactory.getRemoteInstance().getPeriodStatusCollection(view);
        if (coll != null && coll.size() > 0) {
            PeriodStatusInfo periodStatu = coll.get(0);
            return periodStatu.getPeriod();
        }
        return null;
    }

    public static void initDailyPeriodStatusForView(KDBizPromptBox prmtPeriod) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodStatus.company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId()));
        view.setFilter(filter);
        prmtPeriod.setEntityViewInfo(view);
        prmtPeriod.setEditFormat("$number$");
        prmtPeriod.setDisplayFormat("$name$");
        prmtPeriod.setCommitFormat("$number$");
        prmtPeriod.setQueryInfo("com.kingdee.eas.ncm.dynamic.bill.app.PeriodFilterF7Query");
        prmtPeriod.getQueryAgent().resetRuntimeEntityView();
    }

    public static PeriodInfo getLastClsoePeriodBefroeOpen(com.kingdee.eas.basedata.assistant.PeriodInfo currPeriod, CompanyOrgUnitInfo companyOrg) throws BOSException {
        PeriodInfo firstPeriod = CalPeriodUtils.getFirstPeriod(currPeriod, companyOrg);
        if (firstPeriod == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("period.name");
        selector.add("period.number");
        selector.add("number");
        selector.add("*");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrg.getId()));
        filter.getFilterItems().add(new FilterItemInfo("statu", (Object)"2"));
        filter.getFilterItems().add(new FilterItemInfo("period.beginDate", (Object)firstPeriod.getBeginDate(), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("period.endDate", (Object)firstPeriod.getBeginDate(), CompareType.LESS_EQUALS));
        view.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("period.number");
        sorter.setSortType(SortType.DESCEND);
        view.getSorter().add(sorter);
        PeriodStatusCollection coll = PeriodStatusFactory.getRemoteInstance().getPeriodStatusCollection(view);
        if (coll != null && coll.size() > 0) {
            PeriodStatusInfo periodStatu = coll.get(0);
            return periodStatu.getPeriod();
        }
        return null;
    }

    public static Map getPeriods(String comapnyID, Set numbers) throws BOSException {
        return CalPeriodUtils.getPeriods(null, comapnyID, numbers);
    }

    public static Map getPeriods(Context ctx, String comapnyID, Set numbers) throws BOSException {
        HashMap<String, PeriodInfo> periods = new HashMap<String, PeriodInfo>();
        if (numbers.size() == 0) {
            return periods;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("period.*");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)comapnyID));
        filter.getFilterItems().add(new FilterItemInfo("period.number", (Object)numbers, CompareType.INCLUDE));
        view.setFilter(filter);
        PeriodStatusCollection coll = ctx == null ? PeriodStatusFactory.getRemoteInstance().getPeriodStatusCollection(view) : PeriodStatusFactory.getLocalInstance((Context)ctx).getPeriodStatusCollection(view);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                PeriodInfo period = coll.get(i).getPeriod();
                if (period == null || period.getNumber() == null) continue;
                periods.put(period.getNumber(), period);
            }
        }
        return periods;
    }
}

