/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.qm.basedata.app.AbstractQCCertificateMaterialFacadeControllerBean;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.app.util.QMServerUtils;
import com.kingdee.eas.qm.common.util.QMDateUtils;
import com.kingdee.eas.qm.common.util.QMResourceUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCCertificateMaterialFacadeControllerBean
extends AbstractQCCertificateMaterialFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.basedata.app.QCCertificateMaterialFacadeControllerBean");
    private boolean isOnlyForQCC;

    private void checkCanEdit(BomInfo info) throws EASBizException {
        if (null != info && info.getBaseStatus().getValue() == 4) {
            return;
        }
        throw new QMException(QMException.BLANK, (Object[])new String[]{QMResourceUtils.getMessage((String)"com.kingdee.eas.qm.common.QMResource", (String)"NotAuditCannotEditCM")});
    }

    @Override
    public void updateQCCertificate(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        LogControllManager.getInstance().disableLog();
        super.updateQCCertificate(ctx, model);
    }

    @Override
    protected void _updateQCCertificate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BomInfo info = (BomInfo)model;
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"updateQCCertificate", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)info.getNumber(), (String)"qm_QCCertificateMaterial_update");
        String tableName = this.getTableName(ctx);
        QMServerUtils.checkLastUpTime((Context)ctx, (ObjectBaseInfo)info, (String)tableName);
        this.checkCanEdit(info);
        this.updateBomInfo(ctx, info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
    }

    private void updateBomInfo(Context ctx, BomInfo info) throws BOSException {
        if (null == info || null == info.getEntrys()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_MM_BomEntry \n");
        sql.append(" set FQcCertificate = ? \n");
        sql.append(" where FID = ? \n");
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        BomEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            BomEntryInfo entryInfo = entrys.get(i);
            Integer qccerFlag = null;
            qccerFlag = entryInfo.isQcCertificate() ? new Integer(1) : new Integer(0);
            list.add(new Object[]{qccerFlag, entryInfo.getId().toString()});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), list);
        StringBuffer sql1 = new StringBuffer();
        sql1.append(" update T_MM_Bom \n");
        sql1.append(" set FLastUpdateTime = now(), \n");
        sql1.append(" FLastUpdateUserID = ? \n");
        sql1.append(" where FID = ?");
        DbUtil.execute((Context)ctx, (String)sql1.toString(), (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
    }

    @Override
    protected Map _getAllCerSubMaterials(Context ctx, String storageOrgUnitID, String materialID, Date bomDate, boolean isVisibleForQCC) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap relMap = new HashMap();
        this.isOnlyForQCC = isVisibleForQCC;
        if (QMStringUtils.isEmpty((String)storageOrgUnitID) || QMStringUtils.isEmpty((String)materialID) || null == bomDate) {
            return map;
        }
        String tableName = null;
        String strBomDate = QMDateUtils.DateToString((Date)bomDate);
        try {
            tableName = this.createTempTable(ctx);
            this.createFirstData(ctx, tableName, storageOrgUnitID, materialID, relMap, strBomDate);
            this.cycleCreateSubDatas(ctx, tableName, storageOrgUnitID, materialID, strBomDate, 1, relMap);
            String sql = "select FMaterialID, FStorageOrgUnitID, FParentMaterialID, FLevel from " + tableName + " order by FLevel ASC";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            map.put("rtnMaterials", rs);
            map.put("materialRelation", relMap);
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            if (!QMStringUtils.isEmpty((String)tableName)) {
                String clearSQL = "delete from " + tableName;
                DbUtil.execute((Context)ctx, (String)clearSQL);
                this.releaseTempTable(ctx, tableName);
            }
        }
        return map;
    }

    private void createFirstData(Context ctx, String tableName, String storageOrgUnitID, String materialID, Map relMap, String strBomDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tableName).append("\n");
        sql.append(" (FMaterialID, FStorageOrgUnitID, FLevel)\n");
        sql.append(" select a.FMaterialID, a.FStorageOrgUnitID, 1 \n");
        sql.append(" from T_MM_Bom as a \n");
        sql.append(" where a.FMaterialID = ? \n");
        sql.append(" and a.FStorageOrgUnitID = ? \n");
        sql.append(" and a.FUsageType = ? \n");
        sql.append(" and a.FBaseStatus = ? \n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{materialID, storageOrgUnitID, new Integer(10), new Integer(4)});
        this.getSubMaterials(ctx, tableName, storageOrgUnitID, strBomDate, 1, relMap);
    }

    private void cycleCreateSubDatas(Context ctx, String tableName, String storageOrgUnitID, String materialIDs, String strBomDate, int level, Map relMap) throws BOSException, EASBizException {
        if (++level > 50) {
            throw new BomException(BomException.CYCLE);
        }
        this.insertData(ctx, tableName, storageOrgUnitID, materialIDs, strBomDate, level);
        this.needCycle(ctx, tableName, storageOrgUnitID, strBomDate, level, relMap);
    }

    private void insertData(Context ctx, String tableName, String storageOrgUnitID, String materialIDs, String strBomDate, int level) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tableName).append("\n");
        sql.append(" (FMaterialID, FStorageOrgUnitID, FParentMaterialID, FLevel)\n");
        sql.append(" select b.FMaterialID, a.FStorageOrgUnitID, a.FMaterialID, ");
        sql.append(level);
        sql.append(" \n");
        sql.append(" from T_MM_Bom as a \n");
        sql.append(" inner join T_MM_BomEntry as b on a.FID = b.FParentID\n");
        sql.append(" where a.FMaterialID in ('").append(materialIDs).append("') \n");
        sql.append(" and a.FStorageOrgUnitID = ? \n");
        sql.append(" and a.FUsageType = ? \n");
        sql.append(" and a.FBaseStatus = ? \n");
        if (this.isOnlyForQCC) {
            sql.append(" and b.FQcCertificate = 1 \n");
        }
        sql.append(" and to_char(b.FEffectiveDate,'yyyy-mm-dd') <= ? \n");
        sql.append(" and to_char(b.FDisableDate,'yyyy-mm-dd') >= ? \n");
        sql.append(" \n");
        sql.append(" \n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{storageOrgUnitID, new Integer(10), new Integer(4), strBomDate, strBomDate});
    }

    private void needCycle(Context ctx, String tableName, String storageOrgUnitID, String strBomDate, int level, Map relMap) throws BOSException, EASBizException {
        Map rtnMap = this.getSubMaterials(ctx, tableName, storageOrgUnitID, strBomDate, level, relMap);
        String sMaterialIDs = (String)rtnMap.get("rtnSMaterial");
        String pMaterialIDs = (String)rtnMap.get("rtnPMaterial");
        if (!QMStringUtils.isEmpty((String)sMaterialIDs)) {
            this.cycleCreateSubDatas(ctx, tableName, storageOrgUnitID, pMaterialIDs, strBomDate, level, relMap);
        } else {
            this.insertData(ctx, tableName, storageOrgUnitID, pMaterialIDs, strBomDate, level + 1);
        }
    }

    private Map getSubMaterials(Context ctx, String tableName, String storageOrgUnitID, String strBomDate, int level, Map relMap) throws BOSException, SQLDataException {
        StringBuffer sql = new StringBuffer();
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        String rtnPMaterialIDs = "";
        String rtnSMaterialIDs = "";
        sql.append(" select a.FMaterialID as parentMaterialID, b.FMaterialID as subMaterialID \n");
        sql.append(" from T_MM_Bom as a \n");
        sql.append(" inner join T_MM_BomEntry as b on a.FID = b.FParentID \n");
        sql.append(" where a.FMaterialID in \n");
        sql.append(" \t( \n");
        sql.append(" \tselect FMaterialID \n");
        sql.append(" \tfrom ").append(tableName).append("\n");
        sql.append(" \twhere FLevel = ? \n");
        sql.append(" \t) \n");
        sql.append(" and a.FStorageOrgUnitID = ? \n");
        sql.append(" and a.FUsageType = ? \n");
        sql.append(" and a.FBaseStatus = ? \n");
        if (this.isOnlyForQCC) {
            sql.append(" and b.FQcCertificate = 1 \n");
        }
        sql.append(" and to_char(b.FEffectiveDate,'yyyy-mm-dd') <= ? \n");
        sql.append(" and to_char(b.FDisableDate,'yyyy-mm-dd') >= ? \n");
        sql.append(" order by a.FMaterialID \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(level), storageOrgUnitID, new Integer(10), new Integer(4), strBomDate, strBomDate});
        String key_parentMaterialID = "";
        String materialIDs = null;
        int index = 0;
        try {
            while (rs.next()) {
                String parentMaterialID = rs.getString("parentMaterialID");
                String subMaterialID = rs.getString("subMaterialID");
                if (!parentMaterialID.equals(key_parentMaterialID)) {
                    if (!QMStringUtils.isEmpty(materialIDs)) {
                        relMap.put(key_parentMaterialID, materialIDs);
                    }
                    key_parentMaterialID = parentMaterialID;
                    if (index > 0) {
                        rtnPMaterialIDs = rtnPMaterialIDs + "','";
                    }
                    rtnPMaterialIDs = rtnPMaterialIDs + parentMaterialID;
                    materialIDs = "";
                    index = 0;
                }
                if (index > 0 && !QMStringUtils.isEmpty(materialIDs)) {
                    materialIDs = materialIDs + "','";
                }
                if (index > 0) {
                    rtnSMaterialIDs = rtnSMaterialIDs + "','";
                }
                materialIDs = materialIDs + subMaterialID;
                rtnSMaterialIDs = rtnSMaterialIDs + subMaterialID;
                ++index;
            }
            relMap.put(key_parentMaterialID, materialIDs);
            rtnMap.put("rtnPMaterial", rtnPMaterialIDs);
            rtnMap.put("rtnSMaterial", rtnSMaterialIDs);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return rtnMap;
    }

    private String createTempTable(Context ctx) throws BOSException {
        String tableName = "";
        StringBuffer sql = new StringBuffer();
        sql.append(" create table t1 (\n");
        sql.append(" \tFMaterialID VARCHAR(44), \n");
        sql.append(" \tFStorageOrgUnitID VARCHAR(44),\n");
        sql.append(" \tFParentMaterialID VARCHAR(44),\n");
        sql.append(" \tFLevel INT\n");
        sql.append(" \t);\n");
        logger.debug((Object)("create temporary table sql:\n" + sql.toString()));
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tableName = pool.createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException("create temporary table failed!");
        }
        return tableName;
    }

    private void releaseTempTable(Context ctx, String tableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    public String getTableName(Context ctx) {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)"8F409A89"));
        return entity.getTable().getName();
    }

    @Override
    protected BOSObjectType getBOSType() {
        return super.getBOSType();
    }
}

