/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.basedata.app.verify.QCDataBaseSamplingProgramCancelCancelVerifyItem;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.QMVerifyException;
import com.kingdee.eas.qm.common.app.action.ISuportServerBatchAction;
import com.kingdee.eas.qm.common.app.action.ServerBatchAction;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class QCSamplingProgramServerBatchCancelCancelAction
extends ServerBatchAction {
    public QCSamplingProgramServerBatchCancelCancelAction(ISuportServerBatchAction bean, String beforeEventName, String afterEventName) {
        super(bean, beforeEventName, afterEventName);
    }

    protected IVerifyManager getVerifyManager(Context ctx, CoreBaseInfo info) {
        IVerifyManager verifymanager = super.getVerifyManager(ctx, info);
        verifymanager.addVerifyItem((IVerifyItem)new QCDataBaseSamplingProgramCancelCancelVerifyItem((QCSamplingProgramInfo)info, ctx));
        return verifymanager;
    }

    protected CoreBaseCollection batchVerify(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException {
        if (null == successedColl || successedColl.size() == 0) {
            result.setException(0, (Throwable)new QMException(QMException.RECORDNOTEXIST));
            return null;
        }
        CoreBaseCollection firstResultcol = super.batchVerify(ctx, result, successedColl);
        QualityOrgUnitInfo qmOrgInfo = ContextUtil.getCurrentQualityUnit((Context)ctx);
        String currentQMOrgID = qmOrgInfo.getId().toString();
        CoreBaseCollection tmpCol = (CoreBaseCollection)firstResultcol.clone();
        String ids = this.getSuccessedIDS(ctx, tmpCol);
        this.checkCancelStatusSql(ctx, result, tmpCol, currentQMOrgID, ids, false);
        return tmpCol;
    }

    public CoreBaseCollection doIt(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException, EASBizException {
        QualityOrgUnitInfo qmOrgInfo = ContextUtil.getCurrentQualityUnit((Context)ctx);
        String currentQMOrgID = qmOrgInfo.getId().toString();
        CoreBaseCollection tmpCol = (CoreBaseCollection)successedColl.clone();
        String ids = this.getSuccessedIDS(ctx, tmpCol);
        if (ids == null) {
            return null;
        }
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            StringBuffer sql = this.doCancel1(currentQMOrgID, ids, false);
            st.addBatch(sql.toString());
            sql = this.doCancel2(currentQMOrgID, ids, false);
            st.addBatch(sql.toString());
            sql = this.doCancel3(currentQMOrgID, ids, false);
            st.addBatch(sql.toString());
            int[] rsarray = st.executeBatch();
        }
        catch (SQLException sqlEx) {
            try {
                throw new SQLDataException(sqlEx);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
        return tmpCol;
    }

    protected String getSuccessedIDS(Context ctx, CoreBaseCollection successedColl) {
        StringBuffer ids = new StringBuffer();
        ids.append("''");
        for (Object obj : successedColl) {
            IObjectValue objValue;
            String tempID;
            if (!(obj instanceof IObjectValue) || (tempID = (objValue = (IObjectValue)obj).getString(objValue.getPKField())) == null) continue;
            ids.append(",'" + tempID + "'");
        }
        return ids.toString();
    }

    protected void checkCancelStatusSql(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl, String currentQMOrgID, String ids, boolean iscancel) throws BOSException {
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("select t1.fid as fid1, \n");
        checkSql.append("t2.fid as fid2,t2.FDELETEDSTATUS \n");
        checkSql.append("from t_qm_qcsamplingprogram t1 \n");
        checkSql.append("left join T_QM_QCSProgramExtendAttr t2 \n");
        checkSql.append("on (t1.fid = t2.fparentid \n");
        checkSql.append("and t2.fqualityorgunitid = '" + currentQMOrgID + "' \n");
        checkSql.append(") \n");
        checkSql.append("where t1.fid in (" + ids + ") \n");
        if (iscancel) {
            checkSql.append("and t2.FDELETEDSTATUS = 2 \n");
        } else {
            checkSql.append("and t2.FDELETEDSTATUS = 1 \n");
        }
        checkSql.append(" \n");
        this.batchCheckBySql(ctx, checkSql.toString(), "fid1", (Throwable)new QMVerifyException(iscancel ? QMVerifyException.DBCANCEL_HASCANCEL : QMVerifyException.DBCANCELCANCEL_NOCANCEL), result, successedColl);
    }

    protected void batchCheckBySql(Context ctx, String checkSql, String pkFiledName, Throwable ex, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        try {
            while (rs.next()) {
                String standardID = rs.getString(pkFiledName);
                BOSUuid sduuid = BOSUuid.read((String)standardID);
                int index = successedColl.indexOf((Object)sduuid);
                if (index < 0) continue;
                successedColl.removeObject(index);
                this.putException(result, standardID, ex);
            }
        }
        catch (SQLException sqlex) {
            throw new SQLDataException(sqlex);
        }
    }

    protected StringBuffer doCancel1(String currentQMOrgID, String ids, boolean iscancel) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_QM_QCSProgramExtendAttr  \n");
        sql.append("SET FDELETEDSTATUS = " + (iscancel ? 2 : 1) + " \n");
        sql.append("WHERE FPARENTID IN(" + ids + ") \n");
        sql.append("AND FQUALITYORGUNITID = '" + currentQMOrgID + "' \n");
        sql.append(" \n");
        return sql;
    }

    protected StringBuffer doCancel2(String currentQMOrgID, String ids, boolean iscancel) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE t_qm_qcsamplingprogram  \n");
        sql.append(" SET FDELETEDSTATUS =" + (iscancel ? 2 : 1) + " \n");
        sql.append(" WHERE FID IN (" + ids + ") \n");
        sql.append(" AND FQUALITYORGUNITID = '" + currentQMOrgID + "' \n");
        sql.append(" \n");
        return sql;
    }

    protected StringBuffer doCancel3(String currentQMOrgID, String ids, boolean iscancel) {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_QM_QCSProgramExtendAttr ");
        sql.append("set FDELETEDSTATUS = " + (iscancel ? 2 : 1) + "  ");
        sql.append(" where fqualityorgunitid!='").append(currentQMOrgID).append("' ");
        sql.append("and fparentid in ( \n ");
        sql.append(" SELECT FID FROM t_qm_qcsamplingprogram TS \n");
        sql.append(" WHERE TS.FID IN (" + ids + ") \n");
        sql.append("AND TS.FQUALITYORGUNITID = '" + currentQMOrgID + "' \n");
        sql.append(") \n");
        sql.append(" \n");
        return sql;
    }
}

