/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.formula.utils;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.qm.basedata.QCItemAttributeEnum;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCValueTypeEnum;
import com.kingdee.eas.qm.basedata.formula.client.QCItemSelectorForFormulaUI;
import com.kingdee.eas.qm.basedata.formula.client.QMFormulaPromptSelector;
import com.kingdee.eas.qm.basedata.formula.utils.QMFormulaUtils;
import com.kingdee.eas.qm.common.util.KDTableUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class QMFormulaPromptHelper
implements Serializable {
    private static final long serialVersionUID = 9083781494914899785L;
    public static final String resPath = "com.kingdee.eas.qm.basedata.QMFormulaResource";
    private static final Logger logger = CoreUIObject.getLogger(QMFormulaPromptHelper.class);
    private KDTable kdtItemEntries = null;
    private String qcItemNumberKeyName = "";
    private String qcItemNameKeyName = "";
    private String qcItemAttrKeyName = "";
    private String qcValueTypeKeyName = "";
    private String qcDefaultVlaueKeyName = "";
    private String expressionKeyName = "";
    private String[] showKeys = null;
    private CoreUI formulaUI = null;

    public static String getMsg(String key, Object[] objs) {
        String msg = EASResource.getString((String)resPath, (String)key);
        if (objs != null && objs.length > 0) {
            msg = MessageFormat.format(msg, objs);
        }
        return msg;
    }

    public QMFormulaPromptHelper(CoreUI formulaUI) {
        this.formulaUI = formulaUI;
    }

    public QMFormulaPromptHelper(KDTable kdtItemEntries, CoreUI formulaUI, String itemNumber, String itemName, String itemAttr, String valueType, String defaultValue, String exp) {
        this.kdtItemEntries = kdtItemEntries;
        this.formulaUI = formulaUI;
        this.qcItemNumberKeyName = itemNumber;
        this.qcItemNameKeyName = itemName;
        this.qcItemAttrKeyName = itemAttr;
        this.qcValueTypeKeyName = valueType;
        this.qcDefaultVlaueKeyName = defaultValue;
        this.expressionKeyName = exp;
        this.showKeys = new String[]{this.qcItemNumberKeyName, this.qcItemNameKeyName, this.qcValueTypeKeyName, this.qcDefaultVlaueKeyName};
    }

    public List getAllQCItem() {
        ArrayList<List> allQCItemEntryList = new ArrayList<List>();
        for (int rowIndex = 0; rowIndex < this.kdtItemEntries.getRowCount(); ++rowIndex) {
            Object o = KDTableUtils.getFieldValue((KDTable)this.kdtItemEntries, (int)rowIndex, (String)this.qcValueTypeKeyName);
            Object attr = KDTableUtils.getFieldValue((KDTable)this.kdtItemEntries, (int)rowIndex, (String)this.qcItemAttrKeyName);
            if (!QCValueTypeEnum.number.equals(o) || !QCItemAttributeEnum.checkItem.equals(attr) && !QCItemAttributeEnum.variableItem.equals(attr)) continue;
            List list = KDTableUtils.getFieldValues((KDTable)this.kdtItemEntries, (int)rowIndex, (String[])this.showKeys);
            allQCItemEntryList.add(list);
        }
        return allQCItemEntryList;
    }

    public List getSelectedQCItem(String exp) {
        String[] selectedFormulaQCItemNumbers;
        ArrayList<List> selectedQCItemList = new ArrayList<List>();
        if (!StringUtils.isEmpty((String)exp) && (selectedFormulaQCItemNumbers = QMFormulaUtils.parseQCItemNumber(exp)) != null) {
            for (int i = 0; i < selectedFormulaQCItemNumbers.length; ++i) {
                for (int rowIndex = 0; rowIndex < this.kdtItemEntries.getRowCount(); ++rowIndex) {
                    QCItemInfo innerItem;
                    Object o = KDTableUtils.getFieldValue((KDTable)this.kdtItemEntries, (int)rowIndex, (String)this.qcItemNumberKeyName);
                    if (!(o instanceof QCItemInfo) || !this.isQCItemNumberEquals((innerItem = (QCItemInfo)o).getNumber(), selectedFormulaQCItemNumbers[i])) continue;
                    List list = KDTableUtils.getFieldValues((KDTable)this.kdtItemEntries, (int)rowIndex, (String[])this.showKeys);
                    selectedQCItemList.add(list);
                }
            }
        }
        return selectedQCItemList;
    }

    public boolean isQCItemNumberEquals(String itemNumber, String formulaItemNumber) {
        String srcNumber = QMFormulaUtils.getVarNameByQCItemNumber(itemNumber);
        String destNumber = "var_" + formulaItemNumber;
        return srcNumber.equals(destNumber);
    }

    public void removeSelectedQCItemFromAllQCItemList(List selectedQCItemList, List allQCItemList) {
        for (int i = 0; i < selectedQCItemList.size(); ++i) {
            List outList = (List)selectedQCItemList.get(i);
            for (int k = 0; k < outList.size(); ++k) {
                if (!(outList.get(k) instanceof QCItemInfo)) continue;
                QCItemInfo outInfo = (QCItemInfo)outList.get(k);
                for (int j = 0; j < allQCItemList.size(); ++j) {
                    List tempList = (List)allQCItemList.get(j);
                    for (int index = 0; index < tempList.size(); ++index) {
                        if (!(tempList.get(index) instanceof QCItemInfo)) continue;
                        QCItemInfo inInfo = (QCItemInfo)tempList.get(index);
                        if (!outInfo.getId().toString().equals(inInfo.getId().toString())) continue;
                        allQCItemList.remove(j);
                    }
                }
            }
        }
    }

    public String showQCItemSelectUI(List selectedQCItemList, List allQCItemList, String exp) throws Exception {
        UIContext uiContext = new UIContext((Object)this.formulaUI);
        uiContext.put((Object)"allQCItemEntryList", (Object)allQCItemList);
        uiContext.put((Object)"selectedQCItemList", (Object)selectedQCItemList);
        int winStyle = 95;
        winStyle &= 0xFFFFFFF6;
        IUIWindow window = null;
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        window = uiFactory.create(QCItemSelectorForFormulaUI.class.getName(), (Map)uiContext, null, "EDIT", winStyle &= 0xFFFFFFFD);
        window.show();
        QCItemSelectorForFormulaUI object = (QCItemSelectorForFormulaUI)window.getUIObject();
        if ("YES".equals(object.getIsSure())) {
            if (selectedQCItemList == null || selectedQCItemList.size() == 0) {
                String msg = QMFormulaPromptHelper.getMsg("QCItem_Empty", null);
                MsgBox.showInfo((Component)this.formulaUI, (String)msg);
                SysUtil.abort();
            }
            String initexp = QMFormulaUtils.getInitFormulaFromSelectQCItemList(selectedQCItemList);
            String oldBody = "";
            if (!StringUtils.isEmpty((String)exp)) {
                Pattern pt = Pattern.compile("(var )(.+)(})");
                Matcher matcher = pt.matcher(exp);
                int end = 0;
                while (matcher.find()) {
                    end = matcher.end();
                }
                oldBody = exp.substring(end);
            }
            exp = initexp + oldBody;
        } else {
            this.formulaUI.requestFocus();
            SysUtil.abort();
        }
        return exp;
    }

    public void setupFormulaPrompt(int rowIndex, int colIndex) {
        List allQCItemList = this.getAllQCItem();
        String exp = "";
        if (this.kdtItemEntries.getRow(rowIndex).getCell(this.expressionKeyName).getValue() != null) {
            exp = this.kdtItemEntries.getRow(rowIndex).getCell(this.expressionKeyName).getValue().toString();
        }
        List selectedQCItemList = this.getSelectedQCItem(exp);
        this.removeSelectedQCItemFromAllQCItemList(selectedQCItemList, allQCItemList);
        try {
            exp = this.showQCItemSelectUI(selectedQCItemList, allQCItemList, exp);
            EntityObjectInfo entityObjectInfo = null;
            QMFormulaPromptSelector fs = new QMFormulaPromptSelector(null, entityObjectInfo, exp);
            fs.show();
            if (!fs.isCanceled()) {
                this.kdtItemEntries.getRow(rowIndex).getCell("expression").setValue(fs.getData());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

