/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.qm.basedata.QCItemFactory;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCLowerLimitEnum;
import com.kingdee.eas.qm.basedata.QCUpperLimitEnum;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.qm.qc.HQualityHPriceCalException;
import com.kingdee.eas.qm.qc.QCReportFactory;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCRequestEntryFactory;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.app.AbstractCalculateBalPriceFacadeControllerBean;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCPurReportCalBalPriceHelper;
import com.kingdee.eas.qm.qc.app.verify.qcreport.QCPurReportCalculateBalPriceVerifyItem;
import com.kingdee.eas.qm.qc.app.verify.qcreport.QCPurReportSubmitBalPriceVerifyItem;
import com.kingdee.eas.qm.qc.util.QMDataRigthCheckHelper;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.sm.pur.SettlementPriceTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalculateBalPriceFacadeControllerBean
extends AbstractCalculateBalPriceFacadeControllerBean {
    private static final long serialVersionUID = 4626865075458135301L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.qc.app.CalculateBalPriceFacadeControllerBean");

    @Override
    public void calBalPrice(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LogControllManager.getInstance().disableLog();
        super.calBalPrice(ctx, pk);
    }

    @Override
    public void submitBalPrice(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LogControllManager.getInstance().disableLog();
        super.submitBalPrice(ctx, pk);
    }

    private IObjectPK doBeginLog(Context ctx, boolean isSubmit, IObjectPK pk, QCReportInfo reportInfo) {
        IObjectPK logPk = null;
        logPk = !isSubmit ? LogUtil.beginLog((Context)ctx, (String)"calBalPrice", (BOSObjectType)this.getBOSType(), (IObjectPK)pk, (String)reportInfo.getNumber(), (String)"qm_HqualityHPrice_Cal") : LogUtil.beginLog((Context)ctx, (String)"submitBalPrice", (BOSObjectType)this.getBOSType(), (IObjectPK)pk, (String)reportInfo.getNumber(), (String)"qm_HqualityHPrice_Submit");
        return logPk;
    }

    private void doEndLog(Context ctx, boolean isSubmit, IObjectPK logPk) {
        if (!isSubmit) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        } else {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
    }

    private void updateBalPriceMaker(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userPK = userInfo.getId().toString();
        String sql = "UPDATE T_QM_QCREPORT SET FBalancePriceMakerID = '" + userPK + "' WHERE FID='" + pk.toString() + "' ";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _calBalPrice(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isSubmitBalPrice"));
        sic.add(new SelectorItemInfo("isCalBalPrice"));
        sic.add(new SelectorItemInfo("requestEntryID"));
        sic.add(new SelectorItemInfo("entrys.*"));
        QCReportInfo reportInfo = QCReportFactory.getLocalInstance(ctx).getQCReportInfo(pk, sic);
        IObjectPK logPk = this.doBeginLog(ctx, false, pk, reportInfo);
        this._innerCalBalPrice(ctx, pk, reportInfo);
        this.updateBalPriceMaker(ctx, pk);
        this.doEndLog(ctx, false, logPk);
    }

    @Override
    protected void _submitBalPrice(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isSubmitBalPrice"));
        sic.add(new SelectorItemInfo("isCalBalPrice"));
        sic.add(new SelectorItemInfo("requestEntryID"));
        sic.add(new SelectorItemInfo("entrys.*"));
        QCReportInfo reportInfo = QCReportFactory.getLocalInstance(ctx).getQCReportInfo(pk, sic);
        IObjectPK logPk = this.doBeginLog(ctx, true, pk, reportInfo);
        this._innerSubmitBalPrice(ctx, pk, reportInfo);
        this.updateBalPriceMaker(ctx, pk);
        this.doEndLog(ctx, true, logPk);
    }

    protected void _innerCalBalPrice(Context ctx, IObjectPK pk, QCReportInfo reportInfo) throws BOSException, EASBizException {
        logger.debug((Object)(pk + " \uff1a>> Begin cal Bal Price!!!"));
        this.getCalBalPriceVerifyManager(ctx, reportInfo).verify();
        String sql = QCPurReportCalBalPriceHelper.buildDataSql(ctx, pk);
        BigDecimal taxPrice = null;
        BigDecimal protectPrice = null;
        HashMap<String, BigDecimal> rewriteMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> computeMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> errorMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> repeatMap = new HashMap<String, BigDecimal>();
        boolean hasQCItem = false;
        try {
            String itemName;
            String itemNumber;
            QCItemInfo itemInfo;
            String itemID;
            Map.Entry entry;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                BigDecimal fixedPrice;
                BigDecimal floatPrice;
                BigDecimal floatValue;
                BigDecimal upperValue;
                QCUpperLimitEnum upperLimit;
                BigDecimal lowerValue;
                QCLowerLimitEnum lowerLimit;
                boolean notCompute;
                hasQCItem = true;
                if (taxPrice == null) {
                    taxPrice = rs.getBigDecimal("FTAXPRICE");
                }
                protectPrice = rs.getBigDecimal("PROTECTPRICE");
                String reportEntryID = rs.getString("FREPORTENTRYID");
                String qcItemID = rs.getString("FITEMID");
                BigDecimal checkValue = rs.getBigDecimal("FCHECKVALUE");
                boolean bl = notCompute = !QCPurReportCalBalPriceHelper.isMatchPurContractFilterRange(ctx, checkValue, lowerLimit = QCLowerLimitEnum.getEnum((int)rs.getInt("FLOWERLIMIT")), lowerValue = rs.getBigDecimal("FLOWERVALUE"), upperLimit = QCUpperLimitEnum.getEnum((int)rs.getInt("FUPPERLIMIT")), upperValue = rs.getBigDecimal("FUPPERVALUE"));
                if (computeMap.containsKey(qcItemID)) {
                    if (notCompute) continue;
                    repeatMap.put(qcItemID, checkValue);
                    continue;
                }
                if (notCompute) {
                    errorMap.put(qcItemID, checkValue);
                    continue;
                }
                computeMap.put(qcItemID, checkValue);
                SettlementPriceTypeEnum balPriceType = SettlementPriceTypeEnum.getEnum((int)rs.getInt("FBALPRICETYPE"));
                BigDecimal baseValue = rs.getBigDecimal("FBASEVALUE");
                if (baseValue == null) {
                    baseValue = SysConstant.BIGZERO;
                }
                if ((floatValue = rs.getBigDecimal("FFLOATVALUE")) == null) {
                    floatValue = SysConstant.BIGZERO;
                }
                if ((floatPrice = rs.getBigDecimal("FFLOATPRICE")) == null) {
                    floatPrice = SysConstant.BIGZERO;
                }
                if ((fixedPrice = rs.getBigDecimal("FADDPRICE")) == null) {
                    fixedPrice = SysConstant.BIGZERO;
                }
                BigDecimal balPrice = SysConstant.BIGZERO;
                BigDecimal floatRewrite = SysConstant.BIGZERO;
                if (balPriceType == SettlementPriceTypeEnum.SCALE) {
                    if (baseValue.signum() == 0) {
                        throw new QMException(QMException.BLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.qm.qc.QCAutoGenerateResource", (String)"0_CalculateBalPriceFacadeControllerBean", (Locale)ctx.getLocale())});
                    }
                    BigDecimal floatScal = checkValue.divide(baseValue, 4, 5);
                    balPrice = taxPrice.multiply(floatScal);
                    floatRewrite = floatScal;
                } else if (balPriceType == SettlementPriceTypeEnum.FLOAT) {
                    if (floatValue.signum() == 0) {
                        throw new QMException(QMException.BLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.qm.qc.QCAutoGenerateResource", (String)"1_CalculateBalPriceFacadeControllerBean", (Locale)ctx.getLocale())});
                    }
                    BigDecimal tempFloatPrice = checkValue.subtract(baseValue).divide(floatValue, 4, 5).multiply(floatPrice);
                    balPrice = taxPrice.add(tempFloatPrice);
                    floatRewrite = tempFloatPrice;
                } else if (balPriceType == SettlementPriceTypeEnum.FIXED) {
                    balPrice = taxPrice.add(fixedPrice);
                }
                taxPrice = balPrice;
                rewriteMap.put(reportEntryID, floatRewrite);
            }
            if (!hasQCItem) {
                throw new HQualityHPriceCalException(HQualityHPriceCalException.NOITEMSCANCOMPUTE);
            }
            for (Object key : computeMap.keySet()) {
                if (!errorMap.containsKey(key)) continue;
                errorMap.remove(key);
            }
            Iterator<Object> it = errorMap.entrySet().iterator();
            if (it.hasNext()) {
                entry = (Map.Entry)it.next();
                itemID = (String)entry.getKey();
                itemInfo = this.getQCItemInfo(ctx, itemID);
                itemNumber = itemInfo.getNumber();
                itemName = itemInfo.getName();
                Object obj = entry.getValue();
                String itemCheckValue = obj == null ? "" : obj.toString();
                throw new HQualityHPriceCalException(HQualityHPriceCalException.RANGENOTOK, new Object[]{itemNumber + " " + itemName, itemCheckValue});
            }
            it = repeatMap.entrySet().iterator();
            if (it.hasNext()) {
                entry = (Map.Entry)it.next();
                itemID = (String)entry.getKey();
                itemInfo = this.getQCItemInfo(ctx, itemID);
                itemNumber = itemInfo.getNumber();
                itemName = itemInfo.getName();
                throw new HQualityHPriceCalException(HQualityHPriceCalException.RANGEERROR, new String[]{itemNumber + " " + itemName});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (protectPrice == null) {
            protectPrice = SysConstant.BIGZERO;
        }
        if (taxPrice == null) {
            taxPrice = SysConstant.BIGZERO;
        }
        if (protectPrice.compareTo(taxPrice) == 1) {
            taxPrice = protectPrice;
        }
        try {
            QMDataRigthCheckHelper.checkBigDecimalNumberRight(taxPrice);
        }
        catch (QMException e) {
            throw new QMException(QMException.BLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.qm.qc.QCAutoGenerateResource", (String)"2_CalculateBalPriceFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage()});
        }
        String rewriteSql = "UPDATE T_QM_QCREPORT SET FIsCalBalPrice=1,FBalancePrice=" + taxPrice + " WHERE FID = '" + pk + "' ";
        logger.debug((Object)rewriteSql);
        DbUtil.execute((Context)ctx, (String)rewriteSql);
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pst = conn.prepareStatement(" UPDATE T_QM_QCREPORTENTRY SET FFLOATINGPRICE = ? WHERE FID = ? ");
            for (Map.Entry entry : rewriteMap.entrySet()) {
                pst.setObject(1, entry.getValue());
                pst.setObject(2, entry.getKey());
                pst.addBatch();
            }
            pst.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
    }

    protected IVerifyManager getCalBalPriceVerifyManager(Context ctx, QCReportInfo reportInfo) {
        VerifyManager verifyManager = new VerifyManager();
        QCPurReportCalculateBalPriceVerifyItem verifyItem = new QCPurReportCalculateBalPriceVerifyItem(ctx, reportInfo);
        verifyManager.addVerifyItem((IVerifyItem)verifyItem);
        return verifyManager;
    }

    protected IVerifyManager getSubmitalPriceVerifyManager(Context ctx, QCReportInfo reportInfo) {
        VerifyManager verifyManager = new VerifyManager();
        QCPurReportSubmitBalPriceVerifyItem verifyItem = new QCPurReportSubmitBalPriceVerifyItem(ctx, reportInfo);
        verifyManager.addVerifyItem((IVerifyItem)verifyItem);
        return verifyManager;
    }

    protected void _innerSubmitBalPrice(Context ctx, IObjectPK pk, QCReportInfo reportInfo) throws BOSException, EASBizException {
        Object msgObj;
        logger.debug((Object)(pk + " \uff1a>> Begin cal Bal Price!!!"));
        this.getSubmitalPriceVerifyManager(ctx, reportInfo).verify();
        String requestEntryID = reportInfo.getRequestEntryID();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("sourceBillEntryID"));
        QCRequestEntryInfo requestEntryInfo = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectUuidPK(requestEntryID), sic);
        String sourceEntryID = requestEntryInfo.getSourceBillEntryID();
        BigDecimal balPrice = reportInfo.getBalancePrice();
        HashMap<String, BigDecimal> rewriteMap = new HashMap<String, BigDecimal>();
        rewriteMap.put(sourceEntryID, balPrice);
        Map errorMsg = PurInWarehsBillFactory.getLocalInstance((Context)ctx).writeBackSettlementPrice(rewriteMap);
        Object v0 = msgObj = errorMsg != null && errorMsg.get(sourceEntryID) != null ? errorMsg.get(sourceEntryID) : null;
        if (msgObj != null) {
            throw new HQualityHPriceCalException(HQualityHPriceCalException.CANNOTSUBMITFORPUR, new Object[]{msgObj});
        }
        String rewriteSql = "UPDATE T_QM_QCREPORT SET FIsSubmitBalPrice=1  WHERE FID = '" + pk + "' ";
        logger.debug((Object)rewriteSql);
        DbUtil.execute((Context)ctx, (String)rewriteSql);
    }

    @Override
    protected Set _getToDelegateOrgIDS(Context ctx, OrgType srcOrgType, OrgType destOrgType, Set ids) throws BOSException, EASBizException {
        String orgID;
        OrgUnitCollection tempCols;
        HashSet<Object> getOrgIDSet = new HashSet<Object>();
        Iterator it = ids.iterator();
        IOrgUnitRelation iorgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        if (it.hasNext() && (tempCols = iorgRelation.getToUnit(orgID = it.next().toString(), srcOrgType.getValue(), destOrgType.getValue())) != null) {
            for (IObjectValue orgInfo : tempCols) {
                Object tempOrgID = orgInfo.get(orgInfo.getPKField());
                getOrgIDSet.add(tempOrgID);
            }
        }
        if (getOrgIDSet.isEmpty()) {
            getOrgIDSet.add("''");
        }
        return getOrgIDSet;
    }

    private QCItemInfo getQCItemInfo(Context ctx, String itemID) throws EASBizException, BOSException {
        if (itemID == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        QCItemInfo itemInfo = QCItemFactory.getLocalInstance((Context)ctx).getQCItemInfo((IObjectPK)new ObjectUuidPK(itemID), sic);
        return itemInfo;
    }
}

