/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCBizBillTypeFactory;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCSourceBillTypeInfo;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.app.action.IServerAction;
import com.kingdee.eas.qm.common.app.action.IServerActionManager;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.common.util.QMParamUtil;
import com.kingdee.eas.qm.common.util.QMUnitAndExchangeUtils;
import com.kingdee.eas.qm.common.util.QMUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.qm.qc.IQCReinspectReq;
import com.kingdee.eas.qm.qc.QCBillEntryInfo;
import com.kingdee.eas.qm.qc.QCBillException;
import com.kingdee.eas.qm.qc.QCBillInfo;
import com.kingdee.eas.qm.qc.QCBillSampleEntryCollection;
import com.kingdee.eas.qm.qc.QCBillSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCReinspectReqEntryCollection;
import com.kingdee.eas.qm.qc.QCReinspectReqEntryInfo;
import com.kingdee.eas.qm.qc.QCReinspectReqFactory;
import com.kingdee.eas.qm.qc.QCReinspectReqInfo;
import com.kingdee.eas.qm.qc.QCReportCreateResult;
import com.kingdee.eas.qm.qc.QCReportFactory;
import com.kingdee.eas.qm.qc.QCRequestFactory;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.qm.qc.QCSampleInfo;
import com.kingdee.eas.qm.qc.ReinspectFormEnum;
import com.kingdee.eas.qm.qc.ReportEntrySrcTypeEnum;
import com.kingdee.eas.qm.qc.app.AbstractQCBillControllerBean;
import com.kingdee.eas.qm.qc.app.reversesave.qcbill.QCBillToQCReinspectReqAction;
import com.kingdee.eas.qm.qc.app.reversesave.qcbill.QCBillToQCRequestAction;
import com.kingdee.eas.qm.qc.app.reversesave.qcbill.QCBillToQCSampleAction;
import com.kingdee.eas.qm.qc.util.QMUnitConvertHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class QCBillControllerBean
extends AbstractQCBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.qc.app.QCBillControllerBean");

    protected String getMultiLangString(String key, Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.qm.qc.QCBillResource", (String)key, (Locale)ctx.getLocale());
    }

    protected void regesterServerAction(Context ctx, QMCoreBillBaseInfo model, IServerActionManager serverActionManager) throws BOSException {
        BOSObjectType requestObjectType;
        BOSObjectType reinspectReqObjectType;
        super.regesterServerAction(ctx, model, serverActionManager);
        QCBillInfo info = (QCBillInfo)model;
        BOSObjectType srcType = QMUtils.getSourceBillType((QMCoreBillBaseInfo)model);
        BOSObjectType sampleObjectType = new QCSampleInfo().getBOSType();
        if (sampleObjectType.equals((Object)srcType)) {
            serverActionManager.addServerAction((IServerAction)new QCBillToQCSampleAction());
        }
        if ((reinspectReqObjectType = new QCReinspectReqInfo().getBOSType()).equals((Object)srcType)) {
            serverActionManager.addServerAction((IServerAction)new QCBillToQCReinspectReqAction());
        }
        if ((requestObjectType = new QCRequestInfo().getBOSType()).equals((Object)srcType)) {
            serverActionManager.addServerAction((IServerAction)new QCBillToQCRequestAction());
        }
    }

    protected boolean isAuditBySubmit(Context ctx, QMCoreBillBaseInfo info) throws BOSException, EASBizException {
        boolean isAutoAudit = QMParamUtil.paramIsSelected((Context)ctx, (String)"QM003", (String)info.getMainOrgUnit().getId().toString());
        return isAutoAudit;
    }

    protected IVerifyManager getUnAuditVerifyManager(final Context ctx, final QMCoreBillBaseInfo info1) {
        VerifyManager verifymanager = new VerifyManager();
        verifymanager.addVerifyItem((IVerifyItem)new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                boolean canBeUnAudit = true;
                QCBillInfo info = (QCBillInfo)info1;
                if (info.getBillStatus().getValue() != 30) {
                    throw new EASBizException(new NumericExceptionSubItem("____", QCBillControllerBean.this.getMultiLangString("cannotAudit", ctx)));
                }
                Iterator it = info.getSampleEntries().iterator();
                while (it.hasNext() && canBeUnAudit) {
                    QCBillSampleEntryInfo entryInfo = (QCBillSampleEntryInfo)it.next();
                    if (!entryInfo.isIsReinspect() && !entryInfo.isIsQCReport()) continue;
                    canBeUnAudit = false;
                    throw new EASBizException(new NumericExceptionSubItem("____", QCBillControllerBean.this.getMultiLangString("existsBill", ctx)));
                }
                return canBeUnAudit;
            }
        });
        return verifymanager;
    }

    private QCSourceBillTypeInfo getBillInfoSourceBillType(String sourceBillTypeID) {
        String id = null;
        if (sourceBillTypeID == null || sourceBillTypeID.length() <= 0) {
            id = "2eH0lXkJSGmyruNHY57llubqiQE=";
        } else if (sourceBillTypeID.equals("3ipz+O47Tl2jWeZXuaHqUubqiQE=")) {
            id = "2eH0lXkJSGmyruNHY57llubqiQE=";
        } else if (sourceBillTypeID.equals("Kf2yRiYGTleSq8GLlGZegubqiQE=")) {
            id = "O9U4Te37Qw+Rongn15Y+YObqiQE=";
        }
        BOSUuid oid = BOSUuid.read((String)id);
        QCSourceBillTypeInfo info = new QCSourceBillTypeInfo();
        info.setId(oid);
        return info;
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        super._handleAfterTransform(ctx, action, collection);
        for (QCBillInfo billInfo : collection) {
            if (!billInfo.getSourceBillType().getId().toString().equals(QCSourceBillTypeInfo.getQCBillIDByBizType((QCBizTypeEnum)QCBizTypeEnum.purCheck)) && !billInfo.getSourceBillType().getId().toString().equals(QCSourceBillTypeInfo.getQCBillIDByBizType((QCBizTypeEnum)QCBizTypeEnum.pdtDiscreteCheck))) continue;
            billInfo.setSourceBillType(this.getBillInfoSourceBillType(billInfo.getSourceBillType().getId().toString()));
            QCBillSampleEntryCollection sampleEntryCollection = billInfo.getSampleEntries();
            String sourceID = billInfo.getSourceBillId();
            QCReinspectReqInfo reinspectReqInfo = this.getQCReinspectReqInfo(ctx, sourceID);
            String sampleEntryID = reinspectReqInfo.getSourceBillEntryID();
            Map dataMap = this.getSomethingFromQCSampleEntry(ctx, sampleEntryID);
            billInfo.setBillType(reinspectReqInfo.getBillType());
            if (billInfo.getBillType() == null) {
                String requestID = billInfo.getRequestID();
                ObjectUuidPK reqID = new ObjectUuidPK(BOSUuid.read((String)requestID));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("billType"));
                QCRequestInfo requestInfo = QCRequestFactory.getLocalInstance(ctx).getQCRequestInfo((IObjectPK)reqID, sic);
                billInfo.setBillType(requestInfo.getBillType());
            }
            for (int i = 0; i < sampleEntryCollection.size(); ++i) {
                QCBillSampleEntryInfo sampleEntryInfo = sampleEntryCollection.get(i);
                sampleEntryInfo.setSampleDes((String)dataMap.get("sampleDes"));
                sampleEntryInfo.setSampleDate((java.util.Date)dataMap.get("sampleDate"));
                sampleEntryInfo.setSaveTerm((BigDecimal)dataMap.get("SaveTerm"));
                sampleEntryInfo.setVerifyDate(new Time(new java.util.Date().getTime()));
                sampleEntryInfo.setIsResResult(true);
                sampleEntryInfo.setReinspectForm(ReinspectFormEnum.isNull);
                sampleEntryInfo.setIsReinspect(false);
                QCReinspectReqEntryCollection reinspectReqEntryCollection = reinspectReqInfo.getEntrys();
                for (int j = 0; j < reinspectReqEntryCollection.size(); ++j) {
                    QCReinspectReqEntryInfo reinEntryInfo = reinspectReqEntryCollection.get(j);
                    this.createNewQCBillItemEntry(billInfo, sampleEntryInfo, reinEntryInfo);
                }
            }
        }
    }

    private void createNewQCBillItemEntry(QCBillInfo billInfo, QCBillSampleEntryInfo sampleEntryInfo, QCReinspectReqEntryInfo reinEntryInfo) {
        QCBillEntryInfo itemInfo = new QCBillEntryInfo();
        itemInfo.setParent(billInfo);
        itemInfo.setSampleParent(sampleEntryInfo);
        itemInfo.setQCItem(reinEntryInfo.getQCItem());
        itemInfo.setIsMustCheck(reinEntryInfo.isIsMustCheck());
        itemInfo.setIsKeyItem(reinEntryInfo.isIsKeyItem());
        itemInfo.setQCMethod(reinEntryInfo.getQCMethod());
        itemInfo.setJudgeType(reinEntryInfo.getJudgeType());
        itemInfo.setLower(reinEntryInfo.getLower());
        itemInfo.setLowerLimit(reinEntryInfo.getLowerLimit());
        itemInfo.setUpper(reinEntryInfo.getUpper());
        itemInfo.setUpperLimit(reinEntryInfo.getUpperLimit());
        itemInfo.setAnalysisMethod(reinEntryInfo.getQCItem().getAnalysisMethod());
        itemInfo.setQCItemAttr(reinEntryInfo.getQCItem().getQCItemAttr());
        itemInfo.setQCValueType(reinEntryInfo.getQCItem().getQCValueType());
        itemInfo.setDefaultValue(reinEntryInfo.getDefaultValue());
        itemInfo.setQCInstrumentGroup(reinEntryInfo.getQCInstrumentGroup());
        itemInfo.setQCInstrument(reinEntryInfo.getQCInstrument());
        itemInfo.setStandardRequirement(reinEntryInfo.getStandardRequirement());
        itemInfo.setQCFrequency(reinEntryInfo.getQCFrequency());
        itemInfo.setExpression(reinEntryInfo.getExpression());
        itemInfo.setEnums(reinEntryInfo.getEnums());
        itemInfo.setItemType(reinEntryInfo.getItemType());
        itemInfo.setCheckStep(reinEntryInfo.getCheckStep());
        itemInfo.setQCGroup(reinEntryInfo.getQCGroup());
        itemInfo.setSampleNumber(reinEntryInfo.getSampleNumber());
        itemInfo.setQCModifyMode(reinEntryInfo.getQCModifyMode());
        itemInfo.setDelegOrgUnit(reinEntryInfo.getDelegOrgUnit());
        itemInfo.setIsRuinous(reinEntryInfo.isIsRuinous());
        itemInfo.setIsBalanceItem(reinEntryInfo.isIsBalanceItem());
        itemInfo.setDataPrecision(reinEntryInfo.getDataPrecision());
        itemInfo.setQcBillNumber(reinEntryInfo.getQcBillNumber());
        itemInfo.setUnit(reinEntryInfo.getUnit());
        itemInfo.setQCDescription(reinEntryInfo.getQCDescription());
        itemInfo.setVerifyFinishedDate(reinEntryInfo.getVerifyFinishedDate());
        itemInfo.setChecker(reinEntryInfo.getChecker());
        itemInfo.setAnalysisMethod(reinEntryInfo.getAnalysisMethod());
        itemInfo.setQCValueType(reinEntryInfo.getQCValueType());
        itemInfo.setQCItemAttr(reinEntryInfo.getQCItemAttr());
        itemInfo.setRemark(reinEntryInfo.getRemark());
        itemInfo.setQCValueAcquisitionMode(reinEntryInfo.getQCValueAcquisitionMode());
        itemInfo.setSampleShares(reinEntryInfo.getSampleShares());
        itemInfo.setSampleProgram(reinEntryInfo.getSampleProgram());
        itemInfo.setAcValue(reinEntryInfo.getAcValue());
        itemInfo.setReValue(reinEntryInfo.getReValue());
        billInfo.getEntrys().add(itemInfo);
    }

    private QCReinspectReqInfo getQCReinspectReqInfo(Context ctx, String id) throws BOSException, EASBizException {
        IQCReinspectReq QCReinspectReq2 = QCReinspectReqFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        QCReinspectReqInfo info = QCReinspectReq2.getQCReinspectReqInfo((IObjectPK)pk);
        return info;
    }

    private Map getSomethingFromQCSampleEntry(Context ctx, String sampleEntryID) throws BOSException, EASBizException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String sql = "select FSampleDes,FSampleDate,FSaveTerm from T_QM_QCBillSampleEntry where FID='" + sampleEntryID + "'";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (set.next()) {
                String sampleDes = set.getString("FSampleDes");
                Date sampleDate = set.getDate("FSampleDate");
                String saveTerm = set.getString("FSaveTerm");
                dataMap.put("sampleDes", sampleDes);
                dataMap.put("sampleDate", sampleDate);
                if (saveTerm != null) {
                    dataMap.put("SaveTerm", new BigDecimal(saveTerm));
                    continue;
                }
                dataMap.put("SaveTerm", null);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return dataMap;
    }

    @Override
    protected List _createToQCReport(Context ctx, Map idMap) throws BOSException, EASBizException {
        if (idMap == null || idMap.size() <= 0) {
            return null;
        }
        ArrayList<QCReportCreateResult> retValue = new ArrayList<QCReportCreateResult>();
        Iterator iter = idMap.keySet().iterator();
        String mainOrgID = null;
        QCBizTypeEnum[] bizTypeEnum = null;
        HashMap<String, StringBuffer> qcBillMap = new HashMap<String, StringBuffer>();
        while (iter.hasNext()) {
            mainOrgID = (String)iter.next();
            if (mainOrgID.equals("QCBizType")) continue;
            bizTypeEnum = (QCBizTypeEnum[])idMap.get("QCBizType");
            List ids = (List)idMap.get(mainOrgID);
            if (ids == null || ids.size() <= 0) continue;
            Iterator it = ids.iterator();
            StringBuffer requestEntryID = new StringBuffer();
            while (it.hasNext()) {
                StringBuffer qcBuffer;
                String idStr = (String)it.next();
                String[] key = idStr.split("<#>");
                requestEntryID.append("'" + key[1] + "',");
                StringBuffer stringBuffer = qcBuffer = qcBillMap.get(key[3]) == null ? null : (StringBuffer)qcBillMap.get(key[3]);
                if (qcBuffer == null) {
                    qcBuffer = new StringBuffer();
                }
                qcBuffer.append(key[4] + ",");
                qcBillMap.put(key[3], qcBuffer);
            }
            if (requestEntryID.length() <= 0) continue;
            List idList = this.constructidList(ctx, mainOrgID, requestEntryID, bizTypeEnum);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("isCreateByEntry", Boolean.TRUE);
            params.put("MainOrgID", mainOrgID);
            QCReportCreateResult result = QCReportFactory.getLocalInstance(ctx).createBillInfoWithIDList(idList, params);
            if (result.getErrorList().size() > 0) {
                result.getErrorList().put("QCBILLS", qcBillMap);
            }
            if (result.getSucessMap().size() > 0) {
                result.getSucessMap().put("QCBILLS", qcBillMap);
            }
            retValue.add(result);
        }
        return retValue;
    }

    private List constructidList(Context ctx, String mainOrgID, StringBuffer requestEntryID, QCBizTypeEnum[] qcBizTypes) throws BOSException, EASBizException {
        if (qcBizTypes == null || qcBizTypes.length == 0) {
            throw new QMException(QMException.BLANK, (Object[])new String[]{"Error QCBizType"});
        }
        StringBuffer qcBizTypeStr = new StringBuffer();
        for (int i = 0; i < qcBizTypes.length; ++i) {
            qcBizTypeStr.append("," + qcBizTypes[i].getValue());
        }
        String qcBizTypeList = qcBizTypeStr.substring(1);
        String requestEntryList = requestEntryID.substring(0, requestEntryID.toString().length() - 1);
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT     T1.FID AS REQUESTID,   T1.FNUMBER AS REQUESTNUMBER,   T2.FID AS REQUESTENTRYID,   T2.FNUMBER AS REQUESTENTRYNUMBER,   '" + ReportEntrySrcTypeEnum.QCBill.toString() + "' AS SOURCEBILLTYPE," + "   QCBILL.FID AS SOURCEBILLID," + "   QCBILL.FNUMBER AS SOURCEBILLNUMBER," + "   QCBILLENTRY.FID AS SOURCEBILLENTRYID," + "   QCBILLENTRY.FNUMBER AS SAMPLENUMBER" + " FROM " + "   T_QM_QCREQUEST T1   INNER JOIN T_QM_QCREQUESTENTRY T2 ON T1.FID = T2.FPARENTID " + " \t\t                INNER JOIN T_QM_QCBILL QCBILL ON QCBILL.FREQUESTID = T1.FID  AND QCBILL.FREQUESTENTRYID = T2.FID" + "\t                    INNER JOIN T_QM_QCBILLSAMPLEENTRY QCBILLENTRY ON QCBILL.FID = QCBILLENTRY.FPARENTID" + "      \t\t            INNER JOIN T_QM_QCBIZBILLTYPE BIZTYPE ON QCBILL.FBILLTYPEID =BIZTYPE.FID " + " WHERE" + "   T2.FID IN (" + requestEntryList + ") AND " + "   BIZTYPE.FQCBIZTYPE IN (" + qcBizTypeList + ") AND" + "   QCBILL.FQualityOrgUnitID = '" + mainOrgID + "' AND" + "   QCBILL.FBILLSTATUS IN(" + "30" + ") AND" + "   ISNULL(QCBILLENTRY.FIsResResult,0) = 1 AND" + "   ISNULL(QCBILLENTRY.FIsReinspect,0) = 0 AND" + "   ISNULL(QCBILLENTRY.FIsQCReport,0) = 0" + " " + "UNION ALL" + " " + " SELECT" + "   T1.FID AS REQUESTID," + "   T1.FNUMBER AS REQUESTNUMBER," + "   T2.FID AS REQUESTENTRYID," + "   T2.FNUMBER AS REQUESTENTRYNUMBER," + "   '" + ReportEntrySrcTypeEnum.QCReport.toString() + "' AS SOURCEBILLTYPE," + "   QCREPORT.FID AS SOURCEBILLID," + "   QCREPORT.FNUMBER AS SOURCEBILLNUMBER," + "   QCREPORTENTRY.FID AS SOURCEBILLENTRYID," + "   REQUESTENTRY.FSAMPLENUMBER AS SAMPLENUMBER" + " FROM" + "   T_QM_QCREQUEST T1 INNER JOIN T_QM_QCREQUESTENTRY T2 ON T1.FID = T2.FPARENTID " + "\t\t              INNER JOIN T_QM_QCREQUESTENTRY REQUESTENTRY ON REQUESTENTRY.FSOURCEREQUESTID = T1.FID AND REQUESTENTRY.FSOURCEREQUESTENTRYID = T2.FID" + "\t\t              INNER JOIN T_QM_QCREPORT QCREPORT ON QCREPORT.FREQUESTID = REQUESTENTRY.FPARENTID AND QCREPORT.FREQUESTENTRYID = REQUESTENTRY.FID" + "\t\t              INNER JOIN T_QM_QCREPORTENTRY QCREPORTENTRY ON QCREPORT.FID = QCREPORTENTRY.FPARENTID" + " WHERE" + "   T2.FID IN (" + requestEntryList + ") AND " + "   QCREPORT.FBILLSTATUS IN (" + "30" + ")  AND" + "   ISNULL(QCREPORT.FISCOMBINEREPORT,0) = 0" + " " + "ORDER BY" + "   REQUESTNUMBER,REQUESTENTRYNUMBER,SAMPLENUMBER");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        List idList = this.buildRowSet(rs);
        return idList;
    }

    private List buildRowSet(IRowSet rs) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        try {
            while (rs.next()) {
                StringBuffer key = new StringBuffer();
                key.append(rs.getString("REQUESTNUMBER"));
                key.append("<#>");
                key.append(rs.getString("REQUESTENTRYNUMBER"));
                key.append("<#>");
                key.append(rs.getString("REQUESTID"));
                key.append("<#>");
                key.append(rs.getString("REQUESTENTRYID"));
                key.append("<#>");
                key.append(rs.getString("SOURCEBILLTYPE"));
                key.append("<#>");
                key.append(rs.getString("SOURCEBILLID"));
                key.append("<#>");
                key.append(rs.getString("SOURCEBILLENTRYID"));
                key.append("<#>");
                key.append(rs.getString("SAMPLENUMBER"));
                idList.add(key.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return idList;
    }

    protected String getAuditPerItem(Context ctx, QMCoreBillBaseInfo info) throws EASBizException, BOSException {
        QCBillInfo model = (QCBillInfo)info;
        String auditPermName = "";
        QCBizTypeEnum qcBizType = model.getBillType().getQCBizType();
        if (null == qcBizType) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("QCBizType"));
            qcBizType = QCBizBillTypeFactory.getLocalInstance((Context)ctx).getQCBizBillTypeInfo((IObjectPK)new ObjectUuidPK(model.getBillType().getId()), sic).getQCBizType();
        }
        if (qcBizType.equals((Object)QCBizTypeEnum.purCheck)) {
            auditPermName = "qm_QCPurBill_04audit";
        } else if (qcBizType.equals((Object)QCBizTypeEnum.pdtProcessCheck)) {
            auditPermName = "qm_QCMMBill_04audit";
        } else if (qcBizType.equals((Object)QCBizTypeEnum.pdtDiscreteCheck)) {
            auditPermName = "qm_QCMMBill_04audit";
        } else if (qcBizType.equals((Object)QCBizTypeEnum.otherCheck)) {
            auditPermName = "";
        }
        return auditPermName;
    }

    protected SelectorItemCollection getPrepareDataSelector(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("sampleEntries.*"));
        return sic;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verifyBeforeSubmit(ctx, model);
        return super._submit(ctx, model);
    }

    private void verifyBeforeSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        QCBillInfo info = (QCBillInfo)model;
        boolean autoSum = QMParamUtil.paramIsSelected((Context)ctx, (String)"QM015", (String)info.getQualityOrgUnit().getId().toString());
        if (autoSum) {
            this.verifyUnit(ctx, info);
        }
    }

    private void verifyUnit(Context ctx, QCBillInfo info) throws EASBizException, BOSException {
        MaterialInfo material = info.getMaterial();
        if (material == null) {
            return;
        }
        HashMap multiMeasureUnit = QMUnitConvertHelper.getMultiMeasureUnit(ctx, material.getId().toString());
        Set unitIds = multiMeasureUnit.keySet();
        int size = info.getSampleEntries().size();
        for (int i = 0; i < size; ++i) {
            QCBillSampleEntryInfo sampleEntry = info.getSampleEntries().get(i);
            MeasureUnitInfo unit = sampleEntry.getUnit();
            if (unitIds.contains(unit.getId().toString())) continue;
            throw new QCBillException(QCBillException.UNLEGAL_UNIT, new String[]{sampleEntry.getNumber()});
        }
    }

    private void verifyQty(Context ctx, QCBillInfo info) throws EASBizException, BOSException {
        MaterialInfo material = info.getMaterial();
        if (material == null) {
            return;
        }
        BigDecimal sumBaseQty = QMConstant.ZERO;
        QCBillSampleEntryCollection sampleEntries = info.getSampleEntries();
        for (int i = 0; i < sampleEntries.size(); ++i) {
            BigDecimal sampleQty;
            QCBillSampleEntryInfo sampleEntryInfo = sampleEntries.get(i);
            MeasureUnitInfo unit = sampleEntryInfo.getUnit();
            BigDecimal sampleBaseQty = QMUnitAndExchangeUtils.getExchangeBaseQty((Context)ctx, (MeasureUnitInfo)unit, (BigDecimal)(sampleQty = sampleEntryInfo.getSampleQty()), (String)material.getId().toString());
            if (sampleBaseQty == null) continue;
            sumBaseQty = sumBaseQty.add(sampleBaseQty);
        }
        String requestEntryID = info.getRequestEntryID();
        if (StringUtils.isEmpty((String)requestEntryID)) {
            return;
        }
        String sql = "select FBaseDeliverQty from T_QM_QCRequestEntry where fid = '" + requestEntryID + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            BigDecimal baseDeliverQty;
            if (rs.next() && (baseDeliverQty = TypeConversionUtils.objToBigDecimal((Object)rs.getObject("FBaseDeliverQty"))) != null && sumBaseQty.compareTo(baseDeliverQty) > 0) {
                throw new QCBillException(QCBillException.DELIVERQTY_OVER_REQ);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

