/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryInfo;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.qm.basedata.IQCSamplingProgramFacade;
import com.kingdee.eas.qm.basedata.ItemTypeEnum;
import com.kingdee.eas.qm.basedata.QCBizBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCRoutingInspectionPlanInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramFacadeFactory;
import com.kingdee.eas.qm.basedata.QCStandardFactory;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrCollection;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrFactory;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrInfo;
import com.kingdee.eas.qm.basedata.RoutingInspectionModeEnum;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.ctx.QMContextHelperFactory;
import com.kingdee.eas.qm.common.util.NumericUtils;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.util.QMParamUtil;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.qc.QCMMPatrolReportCollection;
import com.kingdee.eas.qm.qc.QCMMPatrolReportEntryCollection;
import com.kingdee.eas.qm.qc.QCMMPatrolReportEntryInfo;
import com.kingdee.eas.qm.qc.QCMMPatrolReportInfo;
import com.kingdee.eas.qm.qc.app.AbstractQCMMPatrolReportControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class QCMMPatrolReportControllerBean
extends AbstractQCMMPatrolReportControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.qc.app.QCMMPatrolReportControllerBean");

    protected String getAuditPerItem(Context ctx, QMCoreBillBaseInfo info) throws EASBizException, BOSException {
        return "qm_QCMMPatrolReport_05audit";
    }

    @Override
    protected BTPTransformResult _getBotCreateFromBills(Context ctx, Map params) throws BOSException, EASBizException {
        IManufactureOrder order;
        String productOrderId = (String)params.get("productOrderId");
        QCBizBillTypeInfo billTypeInfo = (QCBizBillTypeInfo)params.get("billTypeInfo");
        QualityOrgUnitInfo qOrgInfo = (QualityOrgUnitInfo)params.get("MainOrgCtx");
        Object wpNo = params.get("wpNo");
        String wp = (String)params.get("wp");
        boolean isKeyWP = "1".equals(((BigDecimal)params.get("isKeyWP")).toString());
        String wpid = (String)params.get("WPid");
        QCRoutingInspectionPlanInfo planInfo = (QCRoutingInspectionPlanInfo)params.get("PatrolPlan");
        CoreBillBaseCollection cols = new CoreBillBaseCollection();
        if (QCBizTypeEnum.pdtDiscreteCheck.equals((Object)billTypeInfo.getQCBizType())) {
            order = ManufactureOrderFactory.getLocalInstance((Context)ctx);
            cols.add((CoreBillBaseInfo)((ManufactureOrderInfo)order.getValue((IObjectPK)new ObjectUuidPK(productOrderId))));
        } else if (QCBizTypeEnum.pdtProcessCheck.equals((Object)billTypeInfo.getQCBizType())) {
            order = ProductionOrderFactory.getLocalInstance((Context)ctx);
            cols.add((CoreBillBaseInfo)((ProductionOrderInfo)order.getValue((IObjectPK)new ObjectUuidPK(productOrderId))));
        }
        IBTPManager btpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        String destBillBosType = new QCMMPatrolReportInfo().getBOSType().toString();
        BTPTransformResult btpResult = btpManager.transform(cols, destBillBosType);
        QCMMPatrolReportCollection qcPatrolReportColl = (QCMMPatrolReportCollection)btpResult.getBills();
        if (qcPatrolReportColl == null || qcPatrolReportColl.size() <= 0) {
            return null;
        }
        QCMMPatrolReportInfo prInfo = qcPatrolReportColl.get(0);
        if (prInfo == null) {
            return null;
        }
        prInfo.setQualityOrgUnit(qOrgInfo);
        prInfo.setBillType(billTypeInfo);
        prInfo.setWpNo(wpNo.toString());
        prInfo.setWpName(wp);
        List list = QCMMPatrolReportControllerBean.getMaxCheckBatchAndReportDate(ctx, prInfo, planInfo);
        if (planInfo != null) {
            prInfo.setRoutingInspectionPlan(planInfo);
            if (RoutingInspectionModeEnum.batch.equals((Object)planInfo.getRoutingInspectionMode())) {
                prInfo.setDeliverQty(planInfo.getCheckLot());
            } else if (RoutingInspectionModeEnum.frequency.equals((Object)planInfo.getRoutingInspectionMode())) {
                prInfo.setDeliverQty(prInfo.getOrderAmount());
                prInfo.setPatrolCycle(planInfo.getRoutingInspectionPeriod());
            }
        }
        prInfo.setReportDate((Date)list.get(1));
        prInfo.setCheckLot(prInfo.getSourceBillNumber() + "_" + QMStringUtils.leftPadString((char)'0', (String)wpNo.toString(), (int)3) + "_" + (String)list.get(0));
        if (QCBizTypeEnum.pdtDiscreteCheck.equals((Object)billTypeInfo.getQCBizType())) {
            ManufactureOrderInfo info = (ManufactureOrderInfo)cols.get(0);
            IMaterialPlan mplan = MaterialPlanFactory.getLocalInstance((Context)ctx);
            MaterialPlanInfo mPlanInfo = mplan.getPlanInfo(info.getMaterial().getId().toString(), info.getStorageOrgUnit().getId().toString());
            if (mPlanInfo != null) {
                prInfo.setIsFirstCheck(mPlanInfo.isIsFirstCheck());
                prInfo.setIsKeyAndImportant(mPlanInfo.isIsKeyPart());
            }
            prInfo.setIsKeyWP(isKeyWP);
            OperationInfo opInfo = new OperationInfo();
            opInfo.setId(BOSUuid.read((String)wpid));
            prInfo.setOperation(opInfo);
        } else if (QCBizTypeEnum.pdtProcessCheck.equals((Object)billTypeInfo.getQCBizType())) {
            ProductLineWPEntryInfo wpInfo = new ProductLineWPEntryInfo();
            wpInfo.setId(BOSUuid.read((String)wpid));
            prInfo.setProductLineWP(wpInfo);
        }
        return btpResult;
    }

    public static List getMaxCheckBatchAndReportDate(Context ctx, QCMMPatrolReportInfo info, QCRoutingInspectionPlanInfo planInfo) throws BOSException, EASBizException {
        ArrayList<Object> list = new ArrayList<Object>();
        String maxBatch = "001";
        Date reportDate = new Date();
        String orgID = info.getQualityOrgUnit().getId().toString();
        QCBizTypeEnum bizType = info.getBillType().getQCBizType();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT r.FCHECKLOT AS LOT, r.FReportDate ");
        sql.append("FROM t_qm_qcmmpatrolreport r, T_QM_QCBizBillType t ");
        sql.append("WHERE  r.fbilltypeid = t.fid ");
        sql.append("and r.FQUALITYORGUNITID = '").append(orgID).append("' ");
        sql.append("and r.fsourcebillnumber = '").append(info.getSourceBillNumber()).append("' ");
        sql.append("and r.fwpno = '").append(info.getWpNo()).append("' ");
        sql.append("and t.fQCBizType = ").append(bizType.getValue()).append(" ");
        sql.append("ORDER BY r.fchecklot desc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                String[] strs;
                String curLot = rs.getString("LOT");
                if (!StringUtil.isEmptyString((String)curLot) && (strs = curLot.split("_")).length > 0) {
                    String dbStr = strs[strs.length - 1];
                    maxBatch = QCMMPatrolReportControllerBean.addAtCurrentBatch(dbStr);
                }
                if (rs.getDate("FReportDate") != null) {
                    reportDate = rs.getDate("FReportDate");
                }
                if (planInfo != null) {
                    reportDate = QCMMPatrolReportControllerBean.addTime(reportDate, planInfo.getRoutingInspectionPeriod());
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        list.add(maxBatch);
        list.add(reportDate);
        return list;
    }

    public static String addAtCurrentBatch(String str) {
        int temp = 0;
        try {
            temp = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
        }
        if (++temp > 999) {
            return str;
        }
        str = String.valueOf(temp);
        return QMStringUtils.leftPadString((char)'0', (String)str, (int)3);
    }

    public static void botpSave(Context ctx, BOTRelationCollection botRelationCols, QMCoreBillBaseInfo destBillInfo) throws BOSException, EASBizException {
        IBTPManager btpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (destBillInfo.getBillStatus() == QMBillBaseStatusEnum.Submit) {
            btpManager.submitRelations((CoreBillBaseInfo)destBillInfo, botRelationCols);
        } else {
            btpManager.saveRelations((CoreBillBaseInfo)destBillInfo, botRelationCols);
        }
    }

    private static Date addTime(Date date, BigDecimal hour) {
        if (hour == null || date == null) {
            return new Date();
        }
        BigDecimal newTime = hour.multiply(new BigDecimal("60")).multiply(new BigDecimal("60")).multiply(new BigDecimal("1000")).add(new BigDecimal(date.getTime()));
        date.setTime(newTime.longValue());
        return date;
    }

    @Override
    protected IObjectCollection _getQcItemEntryColl(Context ctx, IObjectValue qualityOrgUnit, IObjectValue patrolReportInfo, IObjectValue standardInfo) throws BOSException, EASBizException {
        QCMMPatrolReportEntryCollection newQcItemEntries = new QCMMPatrolReportEntryCollection();
        newQcItemEntries = this.getStandardItems(ctx, (QualityOrgUnitInfo)qualityOrgUnit, (QCMMPatrolReportInfo)patrolReportInfo, (QCStandardInfo)standardInfo);
        return newQcItemEntries;
    }

    public QCMMPatrolReportEntryCollection getStandardItems(Context ctx, QualityOrgUnitInfo qualityOrgUnit, QCMMPatrolReportInfo patrolReportInfo, QCStandardInfo standardInfo) throws BOSException, EASBizException {
        QCMMPatrolReportEntryCollection qcitems = new QCMMPatrolReportEntryCollection();
        if (standardInfo == null || standardInfo.getId() == null) {
            return qcitems;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("itemEntries.*");
        selector.add("itemEntries.qCItem.id");
        selector.add("itemEntries.qCItem.*");
        selector.add("itemEntries.qCItem.group.id");
        selector.add("itemEntries.qCItem.group.name");
        selector.add("itemEntries.qCItem.group.number");
        selector.add("itemEntries.qCItem.group.longnumber");
        selector.add("itemEntries.qCFrequency.id");
        selector.add("itemEntries.qCFrequency.name");
        selector.add("itemEntries.qCFrequency.number");
        selector.add("itemEntries.qCMethod.id");
        selector.add("itemEntries.qCMethod.name");
        selector.add("itemEntries.qCMethod.number");
        selector.add("itemEntries.qCModifyMode.id");
        selector.add("itemEntries.qCModifyMode.name");
        selector.add("itemEntries.qCModifyMode.number");
        selector.add("itemEntries.qCModifyMode.modifyOffset");
        selector.add("itemEntries.qCModifyMode.multiple");
        selector.add("itemEntries.qCModifyMode.dataPrecision");
        selector.add("itemEntries.qCValueAcquisitionMode");
        selector.add("itemEntries.mergeMode");
        selector.add("itemEntries.unit.id");
        selector.add("itemEntries.unit.name");
        selector.add("itemEntries.unit.number");
        QCStandardInfo qcStandardInfo = QCStandardFactory.getLocalInstance((Context)ctx).getQCStandardInfo((IObjectPK)new ObjectUuidPK(standardInfo.getId()), selector);
        QCStandardItemExtendAttrCollection extendAttr = this.getExtendAttr(ctx, qualityOrgUnit, standardInfo);
        for (int i = 0; i < qcStandardInfo.getItemEntries().size(); ++i) {
            QCStandardItemEntryInfo stEntryInfo = qcStandardInfo.getItemEntries().get(i);
            if (stEntryInfo.getItemType() != ItemTypeEnum.standard || stEntryInfo.isIsFreeze()) continue;
            QCMMPatrolReportEntryInfo itemEntryInfo = new QCMMPatrolReportEntryInfo();
            itemEntryInfo.setParent(patrolReportInfo);
            itemEntryInfo.setQCItem(stEntryInfo.getQCItem());
            itemEntryInfo.setUnit(stEntryInfo.getUnit());
            itemEntryInfo.setCheckStep(stEntryInfo.getCheckStep());
            itemEntryInfo.setStandardRequirement(stEntryInfo.getStandardRequirement());
            itemEntryInfo.setIsMustCheck(stEntryInfo.isIsMustCheck());
            itemEntryInfo.setIsKeyItem(stEntryInfo.isIsKeyItem());
            itemEntryInfo.setIsRuinous(stEntryInfo.getQCItem().isIsRuinous());
            itemEntryInfo.setIsBalanceItem(false);
            itemEntryInfo.setQCFrequency(stEntryInfo.getQCFrequency());
            itemEntryInfo.setQCMethod(stEntryInfo.getQCMethod());
            itemEntryInfo.setDefaultValue(stEntryInfo.getDefaultValue());
            itemEntryInfo.setExpression(stEntryInfo.getExpression());
            itemEntryInfo.setEnums(stEntryInfo.getQCItem().getEnums());
            itemEntryInfo.setItemType(stEntryInfo.getItemType());
            itemEntryInfo.setJudgeType(stEntryInfo.getJudgeType());
            itemEntryInfo.setLowerLimit(stEntryInfo.getLowerLimit());
            itemEntryInfo.setLower(stEntryInfo.getLower());
            itemEntryInfo.setUpper(stEntryInfo.getUpper());
            itemEntryInfo.setUpperLimit(stEntryInfo.getUpperLimit());
            itemEntryInfo.setQCModifyMode(stEntryInfo.getQCModifyMode());
            itemEntryInfo.setRemark(stEntryInfo.getRemark());
            itemEntryInfo.setQCValueType(stEntryInfo.getQCItem().getQCValueType());
            itemEntryInfo.setAnalysisMethod(stEntryInfo.getQCItem().getAnalysisMethod());
            itemEntryInfo.setQCItemAttr(stEntryInfo.getQCItem().getQCItemAttr());
            itemEntryInfo.setDataPrecision(stEntryInfo.getDataPrecision());
            itemEntryInfo.setQCValueAcquisitionMode(stEntryInfo.getQCValueAcquisitionMode());
            for (int j = 0; j < extendAttr.size(); ++j) {
                QCStandardItemExtendAttrInfo extendAttrInfo = extendAttr.get(j);
                if (!QMEqualsUtils.equals((Object)extendAttrInfo.getQCStandardEntry(), (Object)stEntryInfo)) continue;
                itemEntryInfo.setDelegOrgUnit(extendAttrInfo.getDelegOrgUnit());
                itemEntryInfo.setQCGroup(extendAttrInfo.getQCGroup());
                itemEntryInfo.setQCInstrument(extendAttrInfo.getQCInstrument());
                itemEntryInfo.setQCInstrumentGroup(extendAttrInfo.getQCInstrumentGroup());
                itemEntryInfo.setSampleProgram(extendAttrInfo.getSampleProgram());
                break;
            }
            this.setSampleProgramQty(ctx, itemEntryInfo, patrolReportInfo.getDeliverQty());
            itemEntryInfo.setSourceBillID(patrolReportInfo.getSourceBillId());
            itemEntryInfo.setSourceBillNumber(patrolReportInfo.getSourceBillNumber());
            itemEntryInfo.setSourceBillType(patrolReportInfo.getSourceBillType());
            qcitems.add(itemEntryInfo);
        }
        return qcitems;
    }

    protected QCStandardItemExtendAttrCollection getExtendAttr(Context ctx, QualityOrgUnitInfo qualityOrgUnit, QCStandardInfo qcStandard) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)qcStandard.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)qualityOrgUnit.getId().toString()));
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add("qCGroup.id");
        view.getSelector().add("qCGroup.name");
        view.getSelector().add("qCGroup.number");
        view.getSelector().add("delegOrgUnit.id");
        view.getSelector().add("delegOrgUnit.name");
        view.getSelector().add("delegOrgUnit.number");
        view.getSelector().add("qCInstrument.id");
        view.getSelector().add("qCInstrument.name");
        view.getSelector().add("qCInstrument.number");
        view.getSelector().add("qCInstrumentGroup.id");
        view.getSelector().add("qCInstrumentGroup.name");
        view.getSelector().add("qCInstrumentGroup.number");
        view.getSelector().add("sampleProgram.id");
        view.getSelector().add("sampleProgram.number");
        view.getSelector().add("sampleProgram.name");
        view.getSelector().add("sampleProgram.evaluationMode");
        view.getSelector().add("qCStandardEntry.*");
        QCStandardItemExtendAttrCollection extendAttr = QCStandardItemExtendAttrFactory.getLocalInstance((Context)ctx).getQCStandardItemExtendAttrCollection(view);
        return extendAttr;
    }

    protected void setSampleProgramQty(Context ctx, QCMMPatrolReportEntryInfo itemEntryInfo, BigDecimal deliveryQty) throws BOSException, EASBizException {
        if (NumericUtils.equalsZero((BigDecimal)deliveryQty) || itemEntryInfo.getSampleProgram() == null) {
            return;
        }
        IQCSamplingProgramFacade facade = QCSamplingProgramFacadeFactory.getLocalInstance((Context)ctx);
        Map map = facade.getAcceptStandard(itemEntryInfo.getSampleProgram().getId().toString(), deliveryQty);
        BigDecimal sampleShares = map.get("sampleCount") != null ? (BigDecimal)map.get("sampleCount") : null;
        BigDecimal acValue = map.get("ac") != null ? (BigDecimal)map.get("ac") : null;
        BigDecimal reValue = map.get("re") != null ? (BigDecimal)map.get("re") : null;
        itemEntryInfo.setSampleShares(sampleShares);
        itemEntryInfo.setAcValue(acValue);
        itemEntryInfo.setReValue(reValue);
    }

    @Override
    protected Set _getAdminOrgForQualityOrg(Context ctx, IObjectValue qualityOrg) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        HashSet<String> set = new HashSet<String>();
        OrgUnitCollection StorageOrgIds = iOrgUnitRel.getFromUnit(((OrgUnitInfo)qualityOrg).getId().toString(), 32, 4);
        Iterator it = StorageOrgIds.iterator();
        OrgUnitInfo storageOrgInfo = null;
        OrgUnitCollection adminOrgIds = null;
        while (it.hasNext()) {
            storageOrgInfo = (OrgUnitInfo)it.next();
            adminOrgIds = iOrgUnitRel.getToUnit(storageOrgInfo.getId().toString(), 4, 0);
            for (int i = 0; i < adminOrgIds.size(); ++i) {
                set.add(adminOrgIds.get(i).getId().toString());
            }
        }
        return set;
    }

    protected boolean isAuditBySubmit(Context ctx, QMCoreBillBaseInfo info) throws BOSException, EASBizException {
        boolean isAutoAudit = QMParamUtil.paramIsSelected((Context)ctx, (String)"QM014", (String)info.getMainOrgUnit().getId().toString());
        return isAutoAudit;
    }

    @Override
    protected String _getMaxCheckBatch(Context ctx, IObjectValue info, IObjectValue planInfo) throws BOSException, EASBizException {
        List list = QCMMPatrolReportControllerBean.getMaxCheckBatchAndReportDate(ctx, (QCMMPatrolReportInfo)info, (QCRoutingInspectionPlanInfo)planInfo);
        return (String)list.get(0);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QCMMPatrolReportInfo info = (QCMMPatrolReportInfo)model;
        boolean isCopy = true;
        if (info.getId() != null) {
            isCopy = false;
        }
        IObjectPK pk = super._addnew(ctx, model);
        if (isCopy) {
            String srcType = null;
            if (QCBizTypeEnum.pdtDiscreteCheck.equals((Object)info.getBillType().getQCBizType())) {
                srcType = new ManufactureOrderInfo().getBOSType().toString();
            } else if (QCBizTypeEnum.pdtProcessCheck.equals((Object)info.getBillType().getQCBizType())) {
                srcType = new ProductionOrderInfo().getBOSType().toString();
            }
            BOTRelationCollection bcolls = new BOTRelationCollection();
            BOTRelationInfo item = new BOTRelationInfo();
            item.setSrcObjectID(info.getSourceBillId());
            item.setSrcEntityID(srcType);
            item.setDestObjectID(pk.toString());
            item.setDestEntityID(info.getBOSType().toString());
            item.setType(0);
            item.setOperatorID(QMContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString());
            bcolls.add(item);
            QCMMPatrolReportControllerBean.botpSave(ctx, bcolls, (QMCoreBillBaseInfo)info);
        }
        return pk;
    }
}

