/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCBizBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCRoutingInspectionPlanEntryCollection;
import com.kingdee.eas.qm.basedata.QCRoutingInspectionPlanEntryInfo;
import com.kingdee.eas.qm.basedata.QCRoutingInspectionPlanInfo;
import com.kingdee.eas.qm.basedata.RoutingInspectionRuleEnum;
import com.kingdee.eas.qm.basedata.util.QCSqlUtil;
import com.kingdee.eas.qm.common.QMCommonFacadeFactory;
import com.kingdee.eas.qm.common.util.QMDateUtils;
import com.kingdee.eas.qm.qc.QCMMPatrolReportException;
import com.kingdee.eas.qm.qc.app.AbstractQCMMPatrolReportCreateFromListFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCMMPatrolReportCreateFromListFacadeControllerBean
extends AbstractQCMMPatrolReportCreateFromListFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.qc.app.QCMMPatrolReportCreateFromListFacadeControllerBean");

    @Override
    protected IRowSet _getListData(Context ctx, Map params) throws BOSException, EASBizException {
        if (params == null) {
            return null;
        }
        QCRoutingInspectionPlanInfo rplan = null;
        if (params.get("patrolPlan") != null) {
            rplan = (QCRoutingInspectionPlanInfo)params.get("patrolPlan");
        }
        QualityOrgUnitInfo qualityOrg = null;
        if (params.get("qualityOrg") != null) {
            qualityOrg = (QualityOrgUnitInfo)params.get("qualityOrg");
        }
        QCBizBillTypeInfo billType = null;
        if (params.get("billType") != null) {
            billType = (QCBizBillTypeInfo)params.get("billType");
        }
        String numberStart = null;
        if (params.get("numberStart") != null && !StringUtils.isEmpty((String)((String)params.get("numberStart")))) {
            numberStart = (String)params.get("numberStart");
        }
        String numberEnd = null;
        if (params.get("numberEnd") != null && !StringUtils.isEmpty((String)((String)params.get("numberEnd")))) {
            numberEnd = (String)params.get("numberEnd");
        }
        Date bizDateStart = null;
        if (params.get("bizDateStart") != null) {
            bizDateStart = (Date)params.get("bizDateStart");
        }
        Date bizDateEnd = null;
        if (params.get("bizDateEnd") != null) {
            bizDateEnd = (Date)params.get("bizDateEnd");
        }
        if (qualityOrg == null || billType == null) {
            return null;
        }
        IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        HashSet<StorageOrgUnitInfo> set = new HashSet<StorageOrgUnitInfo>();
        OrgUnitCollection orgs = iOrgUnitRel.getFromUnit(qualityOrg.getId().toString(), 32, 4);
        Iterator it = orgs.iterator();
        while (it.hasNext()) {
            set.add((StorageOrgUnitInfo)it.next());
        }
        OrgUnitInfo[] storageOrgArray = null;
        if (QCBizTypeEnum.pdtProcessCheck.equals((Object)billType.getQCBizType())) {
            storageOrgArray = QMCommonFacadeFactory.getLocalInstance((Context)ctx).getAuthorizedBizOrgUnits(OrgType.Storage, "mm_productionOrder_view");
        } else if (QCBizTypeEnum.pdtDiscreteCheck.equals((Object)billType.getQCBizType())) {
            storageOrgArray = QMCommonFacadeFactory.getLocalInstance((Context)ctx).getAuthorizedBizOrgUnits(OrgType.Storage, "mm_mo_view");
        }
        HashSet<OrgUnitInfo> setAuth = new HashSet<OrgUnitInfo>();
        if (storageOrgArray == null || storageOrgArray.length == 0) {
            Object[] names = new String[]{qualityOrg.getName()};
            throw new QCMMPatrolReportException(QCMMPatrolReportException.NOTRELATIONSTORAGEORGUNIT, names);
        }
        for (int i = 0; i < storageOrgArray.length; ++i) {
            setAuth.add(storageOrgArray[i]);
        }
        set.retainAll(setAuth);
        HashSet<String> resultSet = new HashSet<String>();
        Iterator it2 = set.iterator();
        while (it2.hasNext()) {
            resultSet.add(((StorageOrgUnitInfo)it2.next()).getId().toString());
        }
        String storageOrgSQLIds = QCSqlUtil.getInSQLFromSet(resultSet);
        if (storageOrgSQLIds == null || storageOrgSQLIds.trim().length() == 0) {
            Object[] names = new String[]{qualityOrg.getName()};
            throw new QCMMPatrolReportException(QCMMPatrolReportException.NOTRELATIONSTORAGEORGUNIT, names);
        }
        StringBuffer sb = new StringBuffer();
        if (QCBizTypeEnum.pdtProcessCheck.equals((Object)billType.getQCBizType())) {
            sb.append("select mmOrder.fid, storage.FNAME_L2, mmOrder.FNUMBER, mmOrder.FBASESTATUS, mmOrder.FBIZDATE, ");
            sb.append("material.FNAME_L2, nullif(0,0) as TransacType, mmOrder.FMmBizType, mmOrder.FQty, ");
            sb.append("unit.FNAME_L2, admin.FNAME_L2, mmOrder.FLOTNO, mmOrder.FExpectOutputQty, ");
            sb.append("productLine.FNAME_L2, nullif(0,0) as techLine, productionOrderEntry.FPrdLineWPNumber, wpEntry.FNAME_L2, ");
            sb.append("isnull(null,0.0) as isKeyWP, wpEntry.fid as wpid, material.fid, unit.fid ");
            sb.append("from T_MM_ProductionOrder as mmOrder ");
            sb.append("INNER JOIN T_MM_ProductionOrderEntry AS productionOrderEntry on mmOrder.FID = productionOrderEntry.FParentID ");
            sb.append("LEFT OUTER JOIN T_MM_ProductLineWPEntry AS wpEntry ON productionOrderEntry.FProductLineWPID = wpEntry.FID ");
            sb.append("LEFT OUTER JOIN T_ORG_Storage AS storage ON mmOrder.FStorageOrgUnitID = storage.FID ");
            sb.append("LEFT OUTER JOIN T_BD_Material AS material ON mmOrder.FMaterialID = material.FID ");
            sb.append("LEFT OUTER JOIN T_BD_MeasureUnit AS unit ON mmOrder.FUnitID = unit.FID ");
            sb.append("LEFT OUTER JOIN T_ORG_Admin AS admin ON mmOrder.FWorkShopID = admin.FID ");
            sb.append("LEFT OUTER JOIN T_MM_ProductLine AS productLine ON mmOrder.FProductLineID = productLine.FID ");
        } else if (QCBizTypeEnum.pdtDiscreteCheck.equals((Object)billType.getQCBizType())) {
            sb.append("select mmOrder.fid, storage.FNAME_L2, mmOrder.FNUMBER, mmOrder.FBASESTATUS, mmOrder.FBIZDATE, ");
            sb.append("material.FNAME_L2, transactionType.FNAME_L2, bizType.FNAME_L2, mmOrder.FQty, ");
            sb.append("unit.FNAME_L2, admin.FNAME_L2, mmOrder.FLot, mmOrder.FDeliveryQty, ");
            sb.append("nullif(0,0) as productLine, standardRooting.FNAME_L2, orderTechnics.FOperationNo, operation.FNAME_L2, ");
            sb.append("operation.FIsKeyOperation, operation.fid as wpid, material.fid, unit.fid ");
            sb.append("from T_MM_ManufactureOrder as mmOrder ");
            sb.append("INNER JOIN T_MM_MFTOrderTechnics AS orderTechnics on mmOrder.FID = orderTechnics.FParentID ");
            sb.append("LEFT OUTER JOIN T_MM_Operation AS operation ON orderTechnics.FOperationID = operation.FID ");
            sb.append("LEFT OUTER JOIN T_ORG_Storage AS storage ON mmOrder.FStorageOrgUnitID = storage.FID ");
            sb.append("LEFT OUTER JOIN T_BD_Material AS material ON mmOrder.FMaterialID = material.FID ");
            sb.append("LEFT OUTER JOIN T_BD_MeasureUnit AS unit ON mmOrder.FUnitID = unit.FID ");
            sb.append("LEFT OUTER JOIN T_ORG_Admin AS admin ON mmOrder.FAdminOrgUnitID = admin.FID ");
            sb.append("LEFT OUTER JOIN T_MM_StandardRooting AS standardRooting ON mmOrder.FRoutingID = standardRooting.FID ");
            sb.append("LEFT OUTER JOIN T_MM_ProductTransactionType AS transactionType ON mmOrder.FTransactionTypeID = transactionType.FID ");
            sb.append("LEFT OUTER JOIN T_SCM_BizType AS bizType ON mmOrder.FBizTypeID = bizType.FID ");
        }
        sb.append(" where 1=1 ");
        sb.append(" and mmOrder.FStorageOrgUnitID in (").append(storageOrgSQLIds).append(") ");
        sb.append(QCMMPatrolReportCreateFromListFacadeControllerBean.getFilterByPatrolPlan(rplan, billType.getQCBizType()));
        if (numberStart != null && numberEnd != null) {
            sb.append(" and mmOrder.FNUMBER >= '").append(numberStart).append("' and mmOrder.FNUMBER <= '").append(numberEnd).append("' ");
        }
        if (bizDateStart != null && bizDateEnd != null) {
            sb.append(" and mmOrder.FBIZDATE >= TO_DATE('").append(QMDateUtils.formatDate2((Date)bizDateStart)).append("') and mmOrder.FBIZDATE <= TO_DATE('").append(QMDateUtils.formatDate2((Date)bizDateEnd)).append("') ");
        }
        sb.append(" order by mmOrder.FNUMBER desc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        logger.debug((Object)("sql-->" + sb));
        return rs;
    }

    private static String getFilterByPatrolPlan(QCRoutingInspectionPlanInfo plan, QCBizTypeEnum bizType) {
        StringBuffer sb = new StringBuffer();
        HashSet<Integer> set = new HashSet<Integer>();
        if (plan == null) {
            set.add(new Integer(5));
            set.add(new Integer(8));
        } else {
            if (plan.isIsRelease()) {
                set.add(new Integer(5));
            }
            if (plan.isIsFinish()) {
                set.add(new Integer(8));
            }
        }
        sb.append(" and mmOrder.FBASESTATUS in (").append(QCSqlUtil.getInSQLFromSet(set)).append(") ");
        if (plan == null) {
            return sb.toString();
        }
        QCRoutingInspectionPlanEntryCollection cols = plan.getPlanEntrys();
        if (cols != null && cols.size() > 0) {
            Iterator it = cols.iterator();
            HashSet<String> mSet = new HashSet<String>();
            HashSet<String> trSet = new HashSet<String>();
            HashSet<String> plSet = new HashSet<String>();
            HashSet<String> plwpSet = new HashSet<String>();
            HashSet<String> wpSet = new HashSet<String>();
            while (it.hasNext()) {
                RoutingInspectionRuleEnum rule;
                QCRoutingInspectionPlanEntryInfo einfo = (QCRoutingInspectionPlanEntryInfo)it.next();
                if (einfo.getMaterial() != null && einfo.getMaterial().getId() != null) {
                    mSet.add(einfo.getMaterial().getId().toString());
                }
                if (RoutingInspectionRuleEnum.technicsRoute.equals((Object)(rule = plan.getRoutingInspectionRule())) && QCBizTypeEnum.pdtDiscreteCheck.equals((Object)bizType)) {
                    if (einfo.getTechnicsRoute() != null && einfo.getTechnicsRoute().getId() != null) {
                        trSet.add(einfo.getTechnicsRoute().getId().toString());
                    }
                    if (einfo.getOperation() == null || einfo.getOperation().getId() == null) continue;
                    wpSet.add(einfo.getOperation().getId().toString());
                    continue;
                }
                if (!RoutingInspectionRuleEnum.pdtLine.equals((Object)rule) || !QCBizTypeEnum.pdtProcessCheck.equals((Object)bizType)) continue;
                if (einfo.getProductLine() != null && einfo.getProductLine().getId() != null) {
                    plSet.add(einfo.getProductLine().getId().toString());
                }
                if (einfo.getProductLineWP() == null || einfo.getProductLineWP().getId() == null) continue;
                plwpSet.add(einfo.getProductLineWP().getId().toString());
            }
            if (mSet.size() > 0) {
                sb.append(" and mmOrder.FMaterialID in (").append(QCSqlUtil.getInSQLFromSet(mSet)).append(") ");
            }
            if (trSet.size() > 0) {
                sb.append(" and mmOrder.FRoutingID in (").append(QCSqlUtil.getInSQLFromSet(trSet)).append(") ");
            }
            if (plSet.size() > 0) {
                sb.append(" and mmOrder.FProductLineID in (").append(QCSqlUtil.getInSQLFromSet(plSet)).append(") ");
            }
            if (wpSet.size() > 0) {
                sb.append(" and operation.FID in (").append(QCSqlUtil.getInSQLFromSet(wpSet)).append(") ");
            }
            if (plwpSet.size() > 0) {
                sb.append(" and wpEntry.FID in (").append(QCSqlUtil.getInSQLFromSet(plwpSet)).append(") ");
            }
        }
        return sb.toString();
    }
}

