/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCSourceBillTypeFactory;
import com.kingdee.eas.qm.basedata.QCSourceBillTypeInfo;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.app.action.IServerAction;
import com.kingdee.eas.qm.common.app.action.IServerActionManager;
import com.kingdee.eas.qm.common.app.action.IServerBatchAction;
import com.kingdee.eas.qm.common.util.QMParamUtil;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.qm.qc.QCRejectProcessException;
import com.kingdee.eas.qm.qc.QCRejectProcessInfo;
import com.kingdee.eas.qm.qc.app.AbstractQCRejectProcessControllerBean;
import com.kingdee.eas.qm.qc.app.reversesave.qcreject.QCRejectPrepareAction;
import com.kingdee.eas.qm.qc.app.reversesave.qcreject.QCRejectToQCReportAction;
import com.kingdee.eas.qm.qc.app.verify.QCRejectRedoResultVerifyItem;
import com.kingdee.eas.qm.qc.app.verify.QCRejectSubmitResultVerifyItem;
import com.kingdee.eas.qm.qc.app.verify.QCRejectSubmitVerifyItem;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class QCRejectProcessControllerBean
extends AbstractQCRejectProcessControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.qc.app.QCRejectProcessControllerBean");

    protected void regesterServerAction(Context ctx, QMCoreBillBaseInfo model, IServerActionManager serverActionManager) throws BOSException {
        super.regesterServerAction(ctx, model, serverActionManager);
        if (null == model.getSourceBillId()) {
            return;
        }
        serverActionManager.addServerAction((IServerAction)new QCRejectToQCReportAction());
        serverActionManager.addServerAction((IServerAction)new QCRejectPrepareAction());
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        super._handleAfterTransform(ctx, action, collection);
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws EASBizException, BOSException {
        super._handleAfterTransform(ctx, action, objectValue);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QCRejectProcessInfo info = (QCRejectProcessInfo)model;
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QCRejectProcessInfo info = (QCRejectProcessInfo)model;
        this.getSubmitVerifyManager(ctx, info).verify();
        return super._submit(ctx, model);
    }

    protected boolean isAuditBySubmit(Context ctx, QMCoreBillBaseInfo info) throws BOSException, EASBizException {
        boolean isAutoAudit = QMParamUtil.paramIsSelected((Context)ctx, (String)"QM006", (String)info.getMainOrgUnit().getId().toString());
        return isAutoAudit;
    }

    protected IVerifyManager getUnAuditVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        IVerifyManager unAuditVerifyManager = super.getUnAuditVerifyManager(ctx, info);
        final QCRejectProcessInfo rpInfo = (QCRejectProcessInfo)info;
        unAuditVerifyManager.addVerifyItem((IVerifyItem)new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                if (!rpInfo.isSubmitResult()) {
                    return true;
                }
                throw new QCRejectProcessException(QCRejectProcessException.SUBMITRESULT_CANNOT_UNAUDIT);
            }
        });
        return unAuditVerifyManager;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        QCRejectProcessInfo info = (QCRejectProcessInfo)super._getValue(ctx, pk);
        this.loadUserInfoToDataObject(ctx, info);
        return info;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        QCRejectProcessInfo info = (QCRejectProcessInfo)super._getValue(ctx, pk, selector);
        this.loadUserInfoToDataObject(ctx, info);
        return info;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        QCRejectProcessInfo info = (QCRejectProcessInfo)super._getValue(ctx, pk, selector, sorter);
        this.loadUserInfoToDataObject(ctx, info);
        return info;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        QCRejectProcessInfo info = (QCRejectProcessInfo)super._getValue(ctx, pk, sorter);
        this.loadUserInfoToDataObject(ctx, info);
        return info;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        QCRejectProcessInfo info = (QCRejectProcessInfo)super._getValue(ctx, oql);
        this.loadUserInfoToDataObject(ctx, info);
        return info;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Class[] parameTypes = new Class[]{IObjectPK.class};
        BatchExecuteParamsEntry p = new BatchExecuteParamsEntry(parameTypes);
        p.add((Object)pk);
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[]{p};
        BatchExecuteResult result = this.batchDelete(ctx, paramEntries);
        this.throwException(result);
    }

    public BatchExecuteResult batchDelete(Context ctx, BatchExecuteParamsEntry[] paramEntries) throws BOSException, EASBizException {
        IServerBatchAction action = this.getBatchDeleteAction();
        return this.doBatchExcuter(ctx, action, "batchDelete", paramEntries);
    }

    @Override
    protected void _submitResult(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        LogControllManager.getInstance().enableLog();
        QCRejectProcessInfo info = this.getSubmitRejectInfo(ctx, pk);
        IVerifyManager verifymanager = this.getSubmitResultVerifyManager(ctx, info);
        verifymanager.verify();
        this.fireServerAction(ctx, (IObjectValue)info, "BEFORE_SUBMITRESULT");
        this.fireServerAction(ctx, (IObjectValue)info, "AFTER_SUBMITRESULT");
    }

    @Override
    protected void _redoResult(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        LogControllManager.getInstance().enableLog();
        QCRejectProcessInfo info = this.getSubmitRejectInfo(ctx, pk);
        this.getRedoResultVerifyManager(ctx, info).verify();
        this.fireServerAction(ctx, (IObjectValue)info, "BEFORE_REDORESULT");
        this.fireServerAction(ctx, (IObjectValue)info, "AFTER_REDORESULT");
    }

    private QCRejectProcessInfo getSubmitRejectInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("billType.*"));
        sic.add(new SelectorItemInfo("rstEntry.*"));
        sic.add(new SelectorItemInfo("rstEntry.material.*"));
        sic.add(new SelectorItemInfo("rstEntry.dPProcessMode.*"));
        sic.add(new SelectorItemInfo("rstEntry.unit.*"));
        QCRejectProcessInfo info = this.getQCRejectProcessInfo(ctx, pk, sic);
        return info;
    }

    private void loadUserInfoToDataObject(Context ctx, QCRejectProcessInfo info) throws BOSException, EASBizException {
        String requestID = info.getRequestID();
        String sql = "SELECT T.Fsourcebilltypeid AS SBID FROM T_QM_QCREQUEST T WHERE T.FID = '" + requestID + "' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String sourceTypeID = null;
        try {
            if (!rs.next()) {
                return;
            }
            sourceTypeID = rs.getString("SBID");
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (!StringUtil.isEmptyString((String)sourceTypeID)) {
            QCSourceBillTypeInfo sbInfo = QCSourceBillTypeFactory.getLocalInstance((Context)ctx).getQCSourceBillTypeInfo((IObjectPK)new ObjectStringPK(sourceTypeID));
            info.setIsQCReportFromQCBill(sbInfo.isQCBill());
            info.setIsQCReportFromOtherSubSystem(sbInfo.isFromOtherSubSystem());
        }
    }

    private IVerifyManager getSubmitVerifyManager(Context ctx, QCRejectProcessInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        verifymanager.addVerifyItem((IVerifyItem)new QCRejectSubmitVerifyItem(ctx, info));
        return verifymanager;
    }

    protected IVerifyManager getSubmitResultVerifyManager(Context ctx, QCRejectProcessInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        verifymanager.addVerifyItem((IVerifyItem)new QCRejectSubmitResultVerifyItem(ctx, info));
        return verifymanager;
    }

    private IVerifyManager getRedoResultVerifyManager(Context ctx, QCRejectProcessInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        verifymanager.addVerifyItem((IVerifyItem)new QCRejectRedoResultVerifyItem(ctx, info));
        return verifymanager;
    }

    protected String getAuditPerItem(Context ctx, QMCoreBillBaseInfo info) throws EASBizException, BOSException {
        return "qm_QCRejectProcess_04audit";
    }
}

