/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteException;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.qm.basedata.QCBizBillTypeFactory;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.RejectProcessModeEnum;
import com.kingdee.eas.qm.basedata.util.QCModifyModeHelper;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.common.QMCommonFacadeFactory;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.app.QMCoreBillBaseControllerBean;
import com.kingdee.eas.qm.common.app.action.IServerAction;
import com.kingdee.eas.qm.common.app.action.IServerActionManager;
import com.kingdee.eas.qm.common.app.action.IServerBatchAction;
import com.kingdee.eas.qm.common.app.action.ISuportServerBatchAction;
import com.kingdee.eas.qm.common.codingrule.ISuportCodingRule;
import com.kingdee.eas.qm.common.util.QMParamUtil;
import com.kingdee.eas.qm.common.util.QMSelectorUtils;
import com.kingdee.eas.qm.common.util.QMUtils;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.qm.qc.IQCRequest;
import com.kingdee.eas.qm.qc.QCBillInfo;
import com.kingdee.eas.qm.qc.QCReportCollection;
import com.kingdee.eas.qm.qc.QCReportCreateResult;
import com.kingdee.eas.qm.qc.QCReportCreateToVerifyResult;
import com.kingdee.eas.qm.qc.QCReportEntryInfo;
import com.kingdee.eas.qm.qc.QCReportException;
import com.kingdee.eas.qm.qc.QCReportFactory;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCRequestEntryFactory;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCRequestFactory;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.qm.qc.QCResultJudgeEnum;
import com.kingdee.eas.qm.qc.QCResultReWriteTypeEnum;
import com.kingdee.eas.qm.qc.app.AbstractQCReportControllerBean;
import com.kingdee.eas.qm.qc.app.action.QCReportBatchAuditAction;
import com.kingdee.eas.qm.qc.app.action.QCReportBatchUnAuditAction;
import com.kingdee.eas.qm.qc.app.action.QCReportRepareDataServerAction;
import com.kingdee.eas.qm.qc.app.reversesave.qcreport.QCBillToQCReportAction;
import com.kingdee.eas.qm.qc.app.reversesave.qcreport.QCRequestToQCReportAction;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportCheckLotHelper;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportCheckResultServerHelper;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportCreateHelper;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportServerHelper;
import com.kingdee.eas.qm.qc.app.verify.qcreport.QCReportDataRightServerVerifyItem;
import com.kingdee.eas.qm.qc.app.verify.qcreport.QCReportDeleteServerVerifyItem;
import com.kingdee.eas.qm.qc.app.verify.qcreport.QCReportRedoResultServerVerifyItem;
import com.kingdee.eas.qm.qc.app.verify.qcreport.QCReportSubmitResultServerVerifyItem;
import com.kingdee.eas.qm.qc.app.verify.qcreport.QCReportUnAuditServerVerifyItem;
import com.kingdee.eas.qm.qc.util.QMUnitConvertHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCReportControllerBean
extends AbstractQCReportControllerBean {
    private static final long serialVersionUID = 2041167550570585331L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.qc.app.QCReportControllerBean");

    public void getNotRelate(Context ctx, QCReportInfo info) throws BOSException, EASBizException {
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QCReportInfo reportInfo = (QCReportInfo)model;
        QCBizTypeEnum bizType = reportInfo.getBillType().getQCBizType();
        if (null == reportInfo.getBillType().getQCBizType()) {
            bizType = QCBizBillTypeFactory.getLocalInstance((Context)ctx).getQCBizBillTypeInfo((IObjectPK)new ObjectUuidPK(reportInfo.getBillType().getId())).getQCBizType();
        }
        if (bizType.equals((Object)QCBizTypeEnum.purCheck)) {
            // empty if block
        }
        return super._save(ctx, (IObjectValue)reportInfo);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QCReportInfo reportInfo = (QCReportInfo)model;
        this.getSubmitVerifyManager(ctx, reportInfo).verify();
        QCBizTypeEnum bizType = reportInfo.getBillType().getQCBizType();
        if (null == reportInfo.getBillType().getQCBizType()) {
            bizType = QCBizBillTypeFactory.getLocalInstance((Context)ctx).getQCBizBillTypeInfo((IObjectPK)new ObjectUuidPK(reportInfo.getBillType().getId())).getQCBizType();
        }
        if (bizType.equals((Object)QCBizTypeEnum.purCheck)) {
            // empty if block
        }
        IObjectPK pk = super._submit(ctx, (IObjectValue)reportInfo);
        return pk;
    }

    @Override
    protected void _isExist(Context ctx, String weibillEntryID) throws BOSException {
        String sql = " select * from T_QM_QCRequestRelWeighEntry where FRelNoticeEntryID ='" + weibillEntryID + "'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs != null && rs.size() > 0 && rs.next()) {
                String sql1 = "delete from T_QM_QCRequestRelWeighEntry where FRelNoticeEntryID='" + weibillEntryID + "' ";
                DbUtil.execute((Context)ctx, (String)sql1);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        QCReportInfo reportInfo = (QCReportInfo)model;
        this.getUpdateVerifyManager(ctx, reportInfo).verify();
        super._update(ctx, pk, model);
    }

    public void getAuditVerify(Context ctx, QCReportInfo reportInfo) throws EASBizException, BOSException {
        String sourceBillTypeId;
        QCRequestInfo requestInfo = QCRequestFactory.getLocalInstance(ctx).getQCRequestInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportInfo.getRequestID())));
        if (requestInfo != null && requestInfo.getSourceBillType() != null && !(sourceBillTypeId = requestInfo.getSourceBillType().getId().toString()).equals("FLJ+4hsARhavfhBsrOo52+bqiQE=")) {
            return;
        }
        QCRequestEntryInfo requestEntryInfo = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportInfo.getRequestEntryID())));
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        QMCoreBillBaseInfo info = (QMCoreBillBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getAuditVerifyManager(ctx, info);
        verifymanager.verify();
        QCReportInfo reportInfo = QCReportFactory.getLocalInstance(ctx).getQCReportInfo(pk);
        QCBizTypeEnum bizType = reportInfo.getBillType().getQCBizType();
        if (null == reportInfo.getBillType().getQCBizType()) {
            bizType = QCBizBillTypeFactory.getLocalInstance((Context)ctx).getQCBizBillTypeInfo((IObjectPK)new ObjectUuidPK(reportInfo.getBillType().getId())).getQCBizType();
        }
        if (bizType.equals((Object)QCBizTypeEnum.purCheck)) {
            this.getAuditVerify(ctx, reportInfo);
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        String sql = "update " + this.getTableName(ctx) + " set FBillStatus=? ,FAuditorId=? , FAuditTime=getDate() where fid =?";
        this.fireServerAction(ctx, (IObjectValue)info, "BEFORE_AUDIT");
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(30), userId, pk.toString()});
        this.fireServerAction(ctx, (IObjectValue)info, "AFTER_AUDIT");
        this.submitQtyToQCRequest(ctx, pk, true);
        this.setReportIsUsed(ctx, pk);
    }

    public String getBillNumber(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return "";
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        QMCoreBillBaseInfo info = (QMCoreBillBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getUnAuditVerifyManager(ctx, info);
        verifymanager.verify();
        QCReportInfo reportInfo = QCReportFactory.getLocalInstance(ctx).getQCReportInfo(pk);
        QCBizTypeEnum bizType = reportInfo.getBillType().getQCBizType();
        if (null == reportInfo.getBillType().getQCBizType()) {
            bizType = QCBizBillTypeFactory.getLocalInstance((Context)ctx).getQCBizBillTypeInfo((IObjectPK)new ObjectUuidPK(reportInfo.getBillType().getId())).getQCBizType();
        }
        if (bizType.equals((Object)QCBizTypeEnum.purCheck)) {
            this.getUnAuditVerify(ctx, this.getBillNumber(ctx, pk));
        }
        String sql = "update " + this.getTableName(ctx) + " set FBillStatus=? ,FAuditorId=null , FAuditTime=null where fid =?";
        this.fireServerAction(ctx, (IObjectValue)info, "BEFORE_UNAUDIT");
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(20), pk.toString()});
        this.fireServerAction(ctx, (IObjectValue)info, "AFTER_UNAUDIT");
        this.submitQtyToQCRequest(ctx, pk, false);
        this.setReportIsUsed(ctx, pk);
    }

    public void getUnAuditVerify(Context ctx, String billNumber) throws EASBizException, BOSException {
        if (billNumber != null && !billNumber.equals("")) {
            throw new QCReportException(QCReportException.CANNOT_UNAUDIT, new String[]{billNumber});
        }
    }

    public IServerBatchAction getBatchAuditAction(Context ctx) {
        QCReportBatchAuditAction action = new QCReportBatchAuditAction((QMCoreBillBaseControllerBean)this, (ISuportServerBatchAction)this, this.getTableName(ctx));
        return action;
    }

    public IServerBatchAction getBatchUnAuditAction(Context ctx) {
        QCReportBatchUnAuditAction action = new QCReportBatchUnAuditAction((QMCoreBillBaseControllerBean)this, (ISuportServerBatchAction)this, this.getTableName(ctx));
        return action;
    }

    protected void submitQtyToQCRequest(Context ctx, IObjectPK pk, boolean isAudit) throws BOSException, EASBizException {
        QCReportInfo reportInfo = (QCReportInfo)this._getValue(ctx, pk);
        if (reportInfo.isQCReportFromQCBill()) {
            return;
        }
        String requestEntryID = reportInfo.getRequestEntryID();
        QCRequestEntryInfo reqeustEntryInfo = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectStringPK(requestEntryID));
        MeasureUnitInfo srcUnit = reportInfo.getUnit();
        MeasureUnitInfo destUnit = reqeustEntryInfo.getBaseUnit();
        MeasureUnitInfo destUnit1 = reqeustEntryInfo.getUnit();
        String materialID = "";
        if (reportInfo.getJudgeMaterial() != null) {
            materialID = reportInfo.getJudgeMaterial().getId().toString();
        }
        String srcUnitID = srcUnit != null ? srcUnit.getId().toString() : "";
        String destUnitID = destUnit != null ? destUnit.getId().toString() : "";
        String destUnitID1 = destUnit1 != null ? destUnit1.getId().toString() : "";
        BigDecimal passQty = reportInfo.getPassQty();
        passQty = QMUnitConvertHelper.convertQtyByUnit(ctx, materialID, srcUnitID, destUnitID1, passQty);
        BigDecimal passBaseQty = QMUnitConvertHelper.convertQtyByUnit(ctx, materialID, srcUnitID, destUnitID, passQty);
        BigDecimal unpassQty = reportInfo.getUnPassQty();
        unpassQty = QMUnitConvertHelper.convertQtyByUnit(ctx, materialID, srcUnitID, destUnitID1, unpassQty);
        BigDecimal unpassBaseQty = QMUnitConvertHelper.convertQtyByUnit(ctx, materialID, srcUnitID, destUnitID, unpassQty);
        passQty = passQty.setScale(8, 5);
        unpassQty = unpassQty.setScale(8, 5);
        passBaseQty = passBaseQty.setScale(8, 5);
        unpassBaseQty = unpassBaseQty.setScale(8, 5);
        String flag = isAudit ? "+" : "-";
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_QM_QCREQUESTENTRY  \n");
        sql.append("SET FQualifiedQty = FQualifiedQty" + flag + QCModifyModeHelper.toPlainString((BigDecimal)passQty) + ", \n");
        sql.append("FUnQualifiedQty = FUnQualifiedQty" + flag + QCModifyModeHelper.toPlainString((BigDecimal)unpassQty) + ", \n");
        sql.append("FBaseQualifiedQty =FBaseQualifiedQty" + flag + QCModifyModeHelper.toPlainString((BigDecimal)passBaseQty) + ", \n");
        sql.append("FBaseUnQualifiedQty = FBaseUnQualifiedQty" + flag + QCModifyModeHelper.toPlainString((BigDecimal)unpassBaseQty) + " \n");
        sql.append("WHERE FID = '" + requestEntryID + "' \n");
        sql.append(" \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (isAudit) {
            this.checkQtyFromQCRequest(ctx, pk);
        }
    }

    protected void checkQtyFromQCRequest(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("unit.*");
        QCReportInfo reportInfo = (QCReportInfo)this._getValue(ctx, pk, sic);
        BigDecimal curPassQty = reportInfo.getPassQty();
        BigDecimal curUnpassQty = reportInfo.getUnPassQty();
        String curUnitName = reportInfo.getUnit().getName();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT RE.FUNITID,RE.FDELIVERQTY, \n");
        sql.append("RE.FQUALIFIEDQTY, \n");
        sql.append("RE.FUNQUALIFIEDQTY  \n");
        sql.append("FROM T_QM_QCREQUESTENTRY RE \n");
        sql.append("WHERE RE.FID  \n");
        sql.append("IN( \n");
        sql.append("SELECT T.FREQUESTENTRYID  \n");
        sql.append("FROM T_QM_QCREPORT T  \n");
        sql.append("WHERE FID = '" + pk.toString() + "') \n");
        sql.append(" \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            rs.next();
            BigDecimal sendQty = rs.getBigDecimal("FDELIVERQTY");
            BigDecimal passQty = rs.getBigDecimal("FQUALIFIEDQTY");
            BigDecimal unPassQty = rs.getBigDecimal("FUNQUALIFIEDQTY");
            BigDecimal totalQty = passQty.add(unPassQty);
            if (totalQty.compareTo(sendQty) == 1) {
                String checkBatchUnitID = rs.getString("FUNITID");
                MeasureUnitInfo checkBatchUnit = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectStringPK(checkBatchUnitID));
                String checkBatchUnitName = checkBatchUnit.getName();
                throw new QCReportException(QCReportException.SUBMITQTY_ERROR, new Object[]{curUnitName + "\n", curPassQty.toString(), curUnpassQty.toString(), "\n", checkBatchUnitName, "\n", passQty.toString(), unPassQty.toString(), "\n", totalQty.toString(), sendQty.toString()});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void setReportIsUsed(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer clearSql = new StringBuffer();
        clearSql.append("UPDATE T_QM_QCREPORT SET FISUSEDREPORT =0 \n");
        clearSql.append("WHERE FREQUESTENTRYID in \n");
        clearSql.append("( \n");
        clearSql.append("SELECT REPORT.FREQUESTENTRYID \n");
        clearSql.append("FROM T_QM_QCREPORT REPORT \n");
        clearSql.append("WHERE REPORT.FID = '" + pk.toString() + "' \n");
        clearSql.append(") \n");
        clearSql.append(" \n");
        logger.debug((Object)clearSql.toString());
        DbUtil.execute((Context)ctx, (String)clearSql.toString());
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_QM_QCREPORT  \n");
        sql.append("SET FISUSEDREPORT = 1 \n");
        sql.append("WHERE FREQUESTENTRYID IN \n");
        sql.append("(SELECT REPORT.FREQUESTENTRYID \n");
        sql.append("FROM T_QM_QCREPORT REPORT \n");
        sql.append("WHERE REPORT.FID = '" + pk.toString() + "') \n");
        sql.append("AND FREPORTDATE IN \n");
        sql.append("( \n");
        sql.append("SELECT MAX(TT.FREPORTDATE) \n");
        sql.append("FROM T_QM_QCREPORT TT \n");
        sql.append("INNER JOIN T_QM_QCREPORT OT \n");
        sql.append("ON TT.FREQUESTENTRYID = OT.FREQUESTENTRYID \n");
        sql.append("WHERE OT.FID = '" + pk.toString() + "' \n");
        sql.append("AND TT.FBILLSTATUS = 30 \n");
        sql.append(") \n");
        sql.append(" AND FBILLSTATUS = 30 \n");
        sql.append(" \n");
        logger.debug((Object)sql.toString());
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _repaireBaseQty(Context ctx, IObjectPK pk, IObjectValue value) throws BOSException, EASBizException {
    }

    @Override
    protected IRowSet _getBotCreateFromBills(Context ctx, Map params) throws BOSException, EASBizException {
        QCReportCreateHelper.getQCBillToQCReportBotMappingID(ctx);
        IRowSet rs = null;
        QCBizTypeEnum[] bizTypes = (QCBizTypeEnum[])params.get("QCBizType");
        if (bizTypes == null || bizTypes.length == 0) {
            throw new QMException(QMException.BLANK, (Object[])new String[]{"Error QCBizType"});
        }
        String orgID = (String)params.get("MainOrgID");
        String sql = QCReportCreateHelper.buildCanCreateReportBillsSql(ctx, bizTypes, orgID, params);
        rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rs;
    }

    @Override
    protected QCReportCreateResult _createBillInfoWithIDList(Context ctx, List idList, Map params) throws BOSException, EASBizException {
        QCReportCreateHelper.getQCBillToQCReportBotMappingID(ctx);
        ArrayList createList = new ArrayList();
        String orgID = (String)params.get("MainOrgID");
        QualityOrgUnitInfo mainOrgInfo = QualityOrgUnitFactory.getLocalInstance((Context)ctx).getQualityOrgUnitInfo((IObjectPK)new ObjectStringPK(orgID));
        boolean isCreateByEntry = (Boolean)params.get("isCreateByEntry");
        Map errorMap = QCReportCreateHelper.processInfoToErrorMap(ctx, orgID, isCreateByEntry, idList);
        QCReportCreateHelper.processInfoToCreateList(ctx, isCreateByEntry, createList, idList, errorMap);
        List successList = new ArrayList();
        if (createList.size() > 0) {
            successList = QCReportCreateHelper.createReportWithCreateList(ctx, mainOrgInfo, createList, this.getCodingRuleStrategy(), (ISuportCodingRule)this);
        }
        Map successMap = QCReportCreateHelper.processSuccessListToSuccessMap(ctx, successList);
        QCReportCreateResult createResult = new QCReportCreateResult(successMap, errorMap, isCreateByEntry);
        return createResult;
    }

    protected void regesterServerAction(Context ctx, QMCoreBillBaseInfo model, IServerActionManager serverActionManager) throws BOSException {
        super.regesterServerAction(ctx, model, serverActionManager);
        if (!model.isFromBOTP()) {
            return;
        }
        BOSObjectType srcType = QMUtils.getSourceBillType((QMCoreBillBaseInfo)model);
        BOSObjectType qcbillObjectType = new QCBillInfo().getBOSType();
        BOSObjectType qcreportObjectType = new QCReportInfo().getBOSType();
        BOSObjectType qcrequestObjectType = new QCRequestInfo().getBOSType();
        if (qcbillObjectType.equals((Object)srcType) || qcreportObjectType.equals((Object)srcType)) {
            serverActionManager.addServerAction((IServerAction)new QCBillToQCReportAction());
        } else if (qcrequestObjectType.equals((Object)srcType)) {
            serverActionManager.addServerAction((IServerAction)new QCRequestToQCReportAction());
        }
        if (serverActionManager.getName() == "BEFORE_ADDNEW") {
            serverActionManager.addServerAction((IServerAction)new QCReportRepareDataServerAction());
        }
    }

    protected void isCanDelete(Context ctx, IObjectPK pk, CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        QCReportInfo reportInfo = (QCReportInfo)this._getValue(ctx, pk);
        BOSObjectType srcType = QMUtils.getSourceBillType((QMCoreBillBaseInfo)reportInfo);
        BOSObjectType qcbillObjectType = new QCBillInfo().getBOSType();
        if (qcbillObjectType.equals((Object)srcType)) {
            return;
        }
        super.isCanDelete(ctx, pk, coreBillInfo);
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        super._handleAfterTransform(ctx, action, collection);
        QCReportCheckLotHelper.addBatchInfo(ctx, collection);
        QCReportCheckResultServerHelper.computeCheckResult(ctx, collection);
    }

    protected boolean isAuditBySubmit(Context ctx, QMCoreBillBaseInfo info) throws BOSException, EASBizException {
        boolean isAutoAudit = QMParamUtil.paramIsSelected((Context)ctx, (String)"QM004", (String)info.getMainOrgUnit().getId().toString());
        return isAutoAudit;
    }

    protected IVerifyManager getUnAuditVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        IVerifyManager verifyManager = super.getUnAuditVerifyManager(ctx, info);
        QCReportUnAuditServerVerifyItem verifyItem = new QCReportUnAuditServerVerifyItem(ctx, (QCReportInfo)info);
        verifyManager.addVerifyItem((IVerifyItem)verifyItem);
        return verifyManager;
    }

    protected IVerifyManager getAuditVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        IVerifyManager verifyManager = super.getAuditVerifyManager(ctx, info);
        return verifyManager;
    }

    protected IVerifyManager getDeleteVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        IVerifyManager verifyManager = super.getDeleteVerifyManager(ctx, info);
        QCReportDeleteServerVerifyItem verifyItem = new QCReportDeleteServerVerifyItem(ctx, (QCReportInfo)info);
        verifyManager.addVerifyItem((IVerifyItem)verifyItem);
        return verifyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitResult(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.submitResult(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    @Override
    protected void _submitResult(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("billType.*"));
        QCReportInfo reportInfo = (QCReportInfo)this._getValue(ctx, pk, sic);
        this.getSubmitResultVerifyManager(ctx, reportInfo).verify();
        String requestEntryID = reportInfo.getRequestEntryID();
        String requestId = reportInfo.getRequestID();
        IQCRequest qcr = QCRequestFactory.getLocalInstance(ctx);
        QCRequestInfo requestInfo = qcr.getQCRequestInfo((IObjectPK)new ObjectStringPK(requestId));
        QCResultReWriteTypeEnum type = this.getRewriteType(reportInfo);
        if (type != QCResultReWriteTypeEnum.pass || reportInfo.getPassQty().signum() > 0) {
            qcr.submitResult(requestInfo, requestEntryID, pk.toString(), type);
        }
        String upDateSql = "UPDATE T_QM_QCREPORT SET FSubmitResult = 1 WHERE FID = '" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)upDateSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redoResult(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.redoResult(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    @Override
    protected void _redoResult(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("billType.*"));
        QCReportInfo reportInfo = (QCReportInfo)this._getValue(ctx, pk, sic);
        this.getRedoResultVerifyManager(ctx, reportInfo).verify();
        String requestEntryID = reportInfo.getRequestEntryID();
        String requestId = reportInfo.getRequestID();
        IQCRequest qcr = QCRequestFactory.getLocalInstance(ctx);
        QCRequestInfo requestInfo = qcr.getQCRequestInfo((IObjectPK)new ObjectStringPK(requestId));
        QCResultReWriteTypeEnum type = this.getRewriteType(reportInfo);
        if (type != QCResultReWriteTypeEnum.pass || reportInfo.getPassQty().signum() > 0) {
            qcr.cancleResult(requestInfo, requestEntryID, pk.toString(), type);
        }
        String upDateSql = "UPDATE T_QM_QCREPORT SET FSubmitResult = 0 WHERE FID = '" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)upDateSql);
    }

    protected QCResultReWriteTypeEnum getRewriteType(QCReportInfo reportInfo) {
        QCResultReWriteTypeEnum type = QCResultReWriteTypeEnum.all;
        type = reportInfo.getRejectProcessMode() == RejectProcessModeEnum.inspectionReport ? QCResultReWriteTypeEnum.all : QCResultReWriteTypeEnum.pass;
        return type;
    }

    protected IVerifyManager getSubmitResultVerifyManager(Context ctx, QCReportInfo reportInfo) {
        VerifyManager verifyManager = new VerifyManager();
        QCReportSubmitResultServerVerifyItem verifyItem = new QCReportSubmitResultServerVerifyItem(ctx, reportInfo);
        verifyManager.addVerifyItem((IVerifyItem)verifyItem);
        return verifyManager;
    }

    protected IVerifyManager getRedoResultVerifyManager(Context ctx, QCReportInfo reportInfo) {
        VerifyManager verifyManager = new VerifyManager();
        QCReportRedoResultServerVerifyItem verifyItem = new QCReportRedoResultServerVerifyItem(ctx, reportInfo);
        verifyManager.addVerifyItem((IVerifyItem)verifyItem);
        return verifyManager;
    }

    protected IVerifyManager getSubmitVerifyManager(Context ctx, QCReportInfo reportInfo) {
        VerifyManager verifyManager = new VerifyManager();
        QCReportDataRightServerVerifyItem verifyItem = new QCReportDataRightServerVerifyItem(ctx, reportInfo);
        verifyManager.addVerifyItem((IVerifyItem)verifyItem);
        return verifyManager;
    }

    protected IVerifyManager getAddnewVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        IVerifyManager verifyManager = super.getAddnewVerifyManager(ctx, info);
        QCReportDataRightServerVerifyItem verifyItem = new QCReportDataRightServerVerifyItem(ctx, (QCReportInfo)info);
        verifyManager.addVerifyItem((IVerifyItem)verifyItem);
        return verifyManager;
    }

    protected IVerifyManager getUpdateVerifyManager(Context ctx, QCReportInfo reportInfo) {
        VerifyManager verifyManager = new VerifyManager();
        QCReportDataRightServerVerifyItem verifyItem = new QCReportDataRightServerVerifyItem(ctx, reportInfo);
        verifyManager.addVerifyItem((IVerifyItem)verifyItem);
        return verifyManager;
    }

    @Override
    protected QCReportCreateToVerifyResult _batchCreateToVerify(Context ctx, List idList) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String[])new String[]{"billType"}, (String[])new String[]{"*"});
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String)"entrys", (String[])new String[]{"*"});
        ev.setSelector(sic);
        QCReportCollection colls = this.getQCReportCollection(ctx, ev);
        QCReportCreateToVerifyResult rs = new QCReportCreateToVerifyResult();
        IQCRequest ibiz = QCRequestFactory.getLocalInstance(ctx);
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            boolean isQCBill;
            QCReportInfo reportInfo = (QCReportInfo)it.next();
            String key = reportInfo.getNumber();
            if (reportInfo.getId() == null || reportInfo.getBillStatus() != QMBillBaseStatusEnum.Audit) {
                rs.addErrorInfoToResult(key, "CreateTo_NoAduit");
                continue;
            }
            if (reportInfo.isIsMRB()) {
                rs.addErrorInfoToResult(key, "CreateTo_Created");
                continue;
            }
            if (!reportInfo.getBillType().isIsEnableMRB()) {
                rs.addErrorInfoToResult(key, "CreateTo_NoMRBProcess");
                continue;
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("sourceBillType"));
            QCRequestInfo requestInfo = ibiz.getQCRequestInfo((IObjectPK)new ObjectStringPK(reportInfo.getRequestID()), selector);
            boolean bl = isQCBill = requestInfo.getSourceBillType() == null ? false : requestInfo.getSourceBillType().isQCBill();
            if (isQCBill) {
                rs.addErrorInfoToResult(key, "CreateTo_IsQCBill");
                continue;
            }
            if (reportInfo.getUnPassQty().signum() != 1) {
                rs.addErrorInfoToResult(key, "CreateTo_NotBiggerThenUnPassQty");
                continue;
            }
            Iterator innerIt = reportInfo.getEntrys().iterator();
            boolean hasRejectObject = false;
            while (innerIt.hasNext()) {
                QCReportEntryInfo entryInfo = (QCReportEntryInfo)innerIt.next();
                if (entryInfo.getCheckResult() == QCResultJudgeEnum.pass) continue;
                hasRejectObject = true;
                break;
            }
            if (hasRejectObject) continue;
            rs.addErrorInfoToResult(key, "CreateTo_NoHasRejectObject");
        }
        return rs;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectValue obj = super._getValue(ctx, pk);
        QCReportServerHelper.loadUserInfoToDataObject(ctx, (QCReportInfo)obj);
        return obj;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        IObjectValue obj = super._getValue(ctx, pk, selector);
        QCReportServerHelper.loadUserInfoToDataObject(ctx, (QCReportInfo)obj);
        return obj;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        IObjectValue obj = super._getValue(ctx, pk, selector, sorter);
        QCReportServerHelper.loadUserInfoToDataObject(ctx, (QCReportInfo)obj);
        return obj;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        IObjectValue obj = super._getValue(ctx, pk, sorter);
        QCReportServerHelper.loadUserInfoToDataObject(ctx, (QCReportInfo)obj);
        return obj;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectValue obj = super._getValue(ctx, oql);
        QCReportServerHelper.loadUserInfoToDataObject(ctx, (QCReportInfo)obj);
        return obj;
    }

    @Override
    protected Map _getMaterialCache(Context ctx, OrgType mainOrgType, String permItemName) throws BOSException, EASBizException {
        OrgUnitInfo[] mainOrgs = QMCommonFacadeFactory.getLocalInstance((Context)ctx).getAuthorizedBizOrgUnits(mainOrgType, permItemName);
        if (mainOrgs == null) {
            mainOrgs = new OrgUnitInfo[]{};
        }
        HashMap<String, FilterInfo> cacheMap = new HashMap<String, FilterInfo>();
        for (int i = 0; i < mainOrgs.length; ++i) {
            OrgUnitInfo orgInfo = mainOrgs[i];
            if (orgInfo == null || orgInfo.getCU() == null || orgInfo.getId() == null) continue;
            String cuID = orgInfo.getCU().getId().toString();
            FilterInfo filterInfo = MaterialFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuID), "id", "cu.id");
            cacheMap.put(cuID, filterInfo);
        }
        return cacheMap;
    }

    @Override
    public BatchExecuteResult loopBatchExecute(Context ctx, String methodName, Class[] parameTypes, BatchExecuteParamsEntry[] paramEntries) throws BOSException {
        return this._loopBatchExecute(ctx, methodName, parameTypes, paramEntries);
    }

    @Override
    protected BatchExecuteResult _loopBatchExecute(Context ctx, String methodName, Class[] parameTypes, BatchExecuteParamsEntry[] paramEntries) throws BOSException {
        if (methodName == null || methodName.length() == 0) {
            throw new IllegalArgumentException("methodName cannot be null.");
        }
        if (parameTypes == null) {
            throw new IllegalArgumentException("method parameter cannot be null.");
        }
        if (paramEntries == null || paramEntries.length == 0) {
            throw new IllegalArgumentException("method arguments cannot be null.");
        }
        if (parameTypes.length == 0) {
            throw new BatchExecuteException("method parameter cannot be empty.");
        }
        MetaDataPK methodPK = this.getMethodPK(ctx, methodName, parameTypes);
        if (methodPK == null) {
            throw new BatchExecuteException("No Such method: " + methodName + "(" + this.paramTypesToString(parameTypes) + ")");
        }
        return this.loopingExecute(ctx, methodName, parameTypes, paramEntries);
    }

    private BatchExecuteResult loopingExecute(Context ctx, String name, Class[] paramTypes, BatchExecuteParamsEntry[] paramEntries) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult(paramEntries.length);
        BizController bizCtrl = EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)this.getBOSType());
        Method mth = QCReportControllerBean.getMethod(bizCtrl, name, QCReportControllerBean.getParamTypeArray(paramTypes));
        if (mth == null) {
            throw new BatchExecuteException("No Such method: " + name + "(" + this.paramTypesToString(paramTypes) + ")");
        }
        for (int i = 0; i < result.size(); ++i) {
            try {
                Object rtv = this.invoke(bizCtrl, mth, this.getParamValueArray(ctx, paramEntries[i]));
                result.setReturnValue(i, rtv);
                continue;
            }
            catch (Throwable th) {
                result.setException(i, th);
            }
        }
        return result;
    }

    private MetaDataPK getMethodPK(Context ctx, String name, Class[] parameterTypes) {
        BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(this.getBOSType());
        MethodCollection mthdCol = bo.getAllMethods();
        for (int i = 0; i < mthdCol.size(); ++i) {
            ParameterCollection paramCol;
            boolean nameMatch;
            MethodInfo mthd = mthdCol.get(i);
            String pimMthdName = mthd.getName();
            boolean bl = nameMatch = pimMthdName.equals(name) || "getValue".equals(pimMthdName) && name.equals(this.get_GETVALUE_MethodName(bo)) || "getCollection".equals(pimMthdName) && name.equals(this.get_GETCOLLECTION_MethodName(bo));
            if (!nameMatch || (paramCol = mthd.getParameters()).size() != parameterTypes.length) continue;
            boolean paramTypeMatch = true;
            int n = paramCol.size();
            for (int j = 0; j < n; ++j) {
                TypeReference psmType = new TypeReference(parameterTypes[j]);
                TypeReference pimType = TypeReference.getParameterType((BusinessObjectInfo)bo, (ParameterInfo)paramCol.get(j));
                if (psmType.equals((Object)pimType)) continue;
                paramTypeMatch = false;
                break;
            }
            if (!paramTypeMatch) continue;
            return new MetaDataPK(mthd.getInnerID());
        }
        return null;
    }

    private String get_GETVALUE_MethodName(BusinessObjectInfo bo) {
        if (bo instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)bo;
            String className = entity.getObjectValueClassRuntime();
            int pos = className.lastIndexOf(46);
            return "get" + className.substring(pos + 1);
        }
        return null;
    }

    private String get_GETCOLLECTION_MethodName(BusinessObjectInfo bo) {
        if (bo instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)bo;
            String className = entity.getObjectCollectionClassRuntime();
            int pos = className.lastIndexOf(46);
            return "get" + className.substring(pos + 1);
        }
        return null;
    }

    private static Class[] getParamTypeArray(Class[] parameterTypes) {
        Class[] types = new Class[parameterTypes.length + 1];
        types[0] = Context.class;
        System.arraycopy(parameterTypes, 0, types, 1, parameterTypes.length);
        return types;
    }

    private static Method getMethod(Object obj, String methodName, Class[] parameterTypes) {
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != parameterTypes.length) continue;
            Class<?>[] params = m.getParameterTypes();
            boolean flag = true;
            for (int j = 0; j < params.length; ++j) {
                if (params[j].isAssignableFrom(parameterTypes[j])) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return m;
        }
        return null;
    }

    private String paramTypesToString(Class[] paramTypes) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < paramTypes.length; ++i) {
            sbuf.append(paramTypes[i].getName());
            if (i >= paramTypes.length - 1) continue;
            sbuf.append(", ");
        }
        return sbuf.toString();
    }

    @Override
    protected boolean _executeReport(Context ctx, String reportSql) throws BOSException {
        boolean flag = true;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)reportSql);
        try {
            if (rs != null && rs.size() > 0 && rs.next()) {
                flag = false;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException();
        }
        return flag;
    }

    protected String getAuditPerItem(Context ctx, QMCoreBillBaseInfo info) throws EASBizException, BOSException {
        String auditPermName = "";
        QCReportInfo model = (QCReportInfo)info;
        QCBizTypeEnum qcBizType = model.getBillType().getQCBizType();
        if (null == qcBizType) {
            qcBizType = QCBizBillTypeFactory.getLocalInstance((Context)ctx).getQCBizBillTypeInfo((IObjectPK)new ObjectUuidPK(model.getBillType().getId())).getQCBizType();
        }
        if (qcBizType.equals((Object)QCBizTypeEnum.purCheck)) {
            auditPermName = "qm_QCPurReport_05audit";
        } else if (qcBizType.equals((Object)QCBizTypeEnum.pdtProcessCheck)) {
            auditPermName = "qm_QCMMReport_05audit";
        } else if (qcBizType.equals((Object)QCBizTypeEnum.pdtDiscreteCheck)) {
            auditPermName = "qm_QCMMReport_05audit";
        } else if (qcBizType.equals((Object)QCBizTypeEnum.otherCheck)) {
            auditPermName = "qm_QCOtherReport_04audit";
        }
        return auditPermName;
    }

    @Override
    protected boolean _executeSql(Context ctx, String sql) throws BOSException {
        DbUtil.execute((Context)ctx, (String)sql);
        return true;
    }
}

