/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.IQCSamplingProgramFacade;
import com.kingdee.eas.qm.basedata.ItemTypeEnum;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCSamplingProgramFacadeFactory;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.basedata.QCStandardFactory;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrCollection;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrFactory;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrInfo;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.app.action.IServerAction;
import com.kingdee.eas.qm.common.app.action.IServerActionManager;
import com.kingdee.eas.qm.common.app.action.ServerActionManager;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.util.NumericUtils;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.common.util.QMDateUtils;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.util.QMParamUtil;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.qc.QCBillInfo;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCRequestEntryCollection;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCRequestException;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryCollection;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryInfo;
import com.kingdee.eas.qm.qc.QCResultReWriteTypeEnum;
import com.kingdee.eas.qm.qc.QCReturnResultCollection;
import com.kingdee.eas.qm.qc.QCSampleInfo;
import com.kingdee.eas.qm.qc.app.AbstractQCRequestControllerBean;
import com.kingdee.eas.qm.qc.app.action.QCRequestBatchCreateToBillServerAction;
import com.kingdee.eas.qm.qc.app.action.QCRequestRepareServerAction;
import com.kingdee.eas.qm.qc.app.action.QCStandardFilterServerAction;
import com.kingdee.eas.qm.qc.app.reversesave.qcrequest.QCRequestReverseSaveAction;
import com.kingdee.eas.qm.qc.app.verify.QCRequestSaveServerVerify;
import com.kingdee.eas.qm.qc.verify.QCStandardDelegOrgUnitVerifyItem;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.pur.PurContractQCItemsNorthCollection;
import com.kingdee.eas.scm.sm.pur.PurContractQCItemsNorthFactory;
import com.kingdee.eas.scm.sm.pur.PurContractQCItemsNorthInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCRequestControllerBean
extends AbstractQCRequestControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.qc.app.QCRequestControllerBean");

    protected void regesterServerAction(Context ctx, QMCoreBillBaseInfo model, IServerActionManager serverActionManager) throws BOSException {
        super.regesterServerAction(ctx, model, serverActionManager);
        QCRequestReverseSaveAction.regesterServerAction(ctx, model, serverActionManager);
        if (serverActionManager.getName() == "BEFORE_ADDNEW") {
            serverActionManager.addServerAction((IServerAction)new QCRequestRepareServerAction());
        }
        if (serverActionManager.getName() == "BEFORE_UPDATE") {
            serverActionManager.addServerAction((IServerAction)new QCRequestRepareServerAction());
        }
    }

    protected boolean isAuditBySubmit(Context ctx, QMCoreBillBaseInfo info) throws BOSException, EASBizException {
        boolean isAutoAudit = QMParamUtil.paramIsSelected((Context)ctx, (String)"QM001", (String)info.getMainOrgUnit().getId().toString());
        return isAutoAudit;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum billOperStateEnum, IObjectValue relationInfo) throws BOSException, EASBizException {
        BOTRelationInfo r = (BOTRelationInfo)relationInfo;
        String did = r.getDestObjectID();
        if (did != null) {
            BOSUuid ddid = BOSUuid.read((String)did);
            if (ddid.getType().equals((Object)new QCSampleInfo().getBOSType())) {
                return;
            }
            if (ddid.getType().equals((Object)new QCBillInfo().getBOSType())) {
                return;
            }
            if (ddid.getType().equals((Object)new QCReportInfo().getBOSType())) {
                return;
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, billOperStateEnum, relationInfo);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("QCRequestControllerBean.reverseSave( srcBillPK = " + srcBillPK + "srcBillVO=" + srcBillVO + "billOperStateEnum=" + billOperStateEnum + "relationInfo=" + relationInfo));
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QCRequestInfo info = (QCRequestInfo)model;
        if (info.getReqDate() == null) {
            info.setReqDate(QMDateUtils.getTimeStampDayBegin());
        }
        return super._addnew(ctx, model);
    }

    protected IVerifyManager getAddnewVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        IVerifyManager addnewVerifyManager = super.getAddnewVerifyManager(ctx, info);
        return addnewVerifyManager;
    }

    protected IVerifyManager getSaveVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        IVerifyManager verifyManager = super.getSaveVerifyManager(ctx, info);
        if (!info.isBotpCallSave()) {
            verifyManager.addVerifyItem((IVerifyItem)new QCRequestSaveServerVerify(ctx, (QCRequestInfo)info));
        }
        return verifyManager;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QCRequestInfo info = (QCRequestInfo)model;
        this.repairSamplePrgmQtys(ctx, info);
        this.removeEntryFieldsMapping(info);
        return super._save(ctx, model);
    }

    protected IVerifyManager getSubmitVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        IVerifyManager manager = super.getSubmitVerifyManager(ctx, info);
        manager.addVerifyItem((IVerifyItem)new QCStandardDelegOrgUnitVerifyItem(ctx, (QCRequestInfo)info));
        manager.addVerifyItem((IVerifyItem)new QCRequestSaveServerVerify(ctx, (QCRequestInfo)info));
        return manager;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QCRequestInfo info = (QCRequestInfo)model;
        this.repairSamplePrgmQtys(ctx, info);
        this.removeEntryFieldsMapping(info);
        IVerifyManager verifymanager = this.getSaveVerifyManager(ctx, (QMCoreBillBaseInfo)info);
        verifymanager.verify();
        return super._submit(ctx, model);
    }

    protected void removeEntryFieldsMapping(QCRequestInfo info) {
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            QCRequestEntryInfo entryInfo = info.getEntrys().get(i);
            entryInfo.remove("isGenDestBill");
            entryInfo.remove("sampleState");
            entryInfo.remove("qcBillState");
            entryInfo.remove("reportState");
        }
    }

    public QCRequestQcItemEntryCollection getStandardItems(Context ctx, QualityOrgUnitInfo qualityOrgUnit, QCRequestEntryInfo qcRequestEntryInfo) throws BOSException, EASBizException {
        QCRequestQcItemEntryCollection qcitems = new QCRequestQcItemEntryCollection();
        QCStandardInfo qcStandard = qcRequestEntryInfo.getQcStandard();
        if (qcStandard == null || qcStandard.getId() == null) {
            return qcitems;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("itemEntries.*");
        selector.add("itemEntries.qCItem.id");
        selector.add("itemEntries.qCItem.*");
        selector.add("itemEntries.qCItem.group.id");
        selector.add("itemEntries.qCItem.group.name");
        selector.add("itemEntries.qCItem.group.number");
        selector.add("itemEntries.qCItem.group.longnumber");
        selector.add("itemEntries.qCFrequency.id");
        selector.add("itemEntries.qCFrequency.name");
        selector.add("itemEntries.qCFrequency.number");
        selector.add("itemEntries.qCMethod.id");
        selector.add("itemEntries.qCMethod.name");
        selector.add("itemEntries.qCMethod.number");
        selector.add("itemEntries.qCModifyMode.id");
        selector.add("itemEntries.qCModifyMode.name");
        selector.add("itemEntries.qCModifyMode.number");
        selector.add("itemEntries.qCModifyMode.dataPrecision");
        selector.add("itemEntries.qCValueAcquisitionMode");
        selector.add("itemEntries.mergeMode");
        selector.add("itemEntries.unit.id");
        selector.add("itemEntries.unit.name");
        selector.add("itemEntries.unit.number");
        QCStandardInfo qcStandardInfo = QCStandardFactory.getLocalInstance((Context)ctx).getQCStandardInfo((IObjectPK)new ObjectUuidPK(qcStandard.getId()), selector);
        QCStandardItemExtendAttrCollection extendAttr = this.getExtendAttr(ctx, qualityOrgUnit, qcStandard);
        for (int i = 0; i < qcStandardInfo.getItemEntries().size(); ++i) {
            QCStandardItemEntryInfo stEntryInfo = qcStandardInfo.getItemEntries().get(i);
            if (stEntryInfo.getItemType() != ItemTypeEnum.standard || stEntryInfo.isIsFreeze()) continue;
            QCRequestQcItemEntryInfo itemEntryInfo = new QCRequestQcItemEntryInfo();
            itemEntryInfo.setEntry(qcRequestEntryInfo);
            itemEntryInfo.setQCItem(stEntryInfo.getQCItem());
            itemEntryInfo.setUnit(stEntryInfo.getUnit());
            itemEntryInfo.setCheckStep(stEntryInfo.getCheckStep());
            itemEntryInfo.setStandardRequirement(stEntryInfo.getStandardRequirement());
            itemEntryInfo.setIsMustCheck(stEntryInfo.isIsMustCheck());
            itemEntryInfo.setIsKeyItem(stEntryInfo.isIsKeyItem());
            itemEntryInfo.setIsRuinous(stEntryInfo.getQCItem().isIsRuinous());
            itemEntryInfo.setIsBalanceItem(false);
            itemEntryInfo.setQCFrequency(stEntryInfo.getQCFrequency());
            itemEntryInfo.setQCMethod(stEntryInfo.getQCMethod());
            itemEntryInfo.setDefaultValue(stEntryInfo.getDefaultValue());
            itemEntryInfo.setExpression(stEntryInfo.getExpression());
            itemEntryInfo.setEnums(stEntryInfo.getQCItem().getEnums());
            itemEntryInfo.setItemType(stEntryInfo.getItemType());
            itemEntryInfo.setJudgeType(stEntryInfo.getJudgeType());
            itemEntryInfo.setLowerLimit(stEntryInfo.getLowerLimit());
            itemEntryInfo.setLower(stEntryInfo.getLower());
            itemEntryInfo.setUpper(stEntryInfo.getUpper());
            itemEntryInfo.setUpperLimit(stEntryInfo.getUpperLimit());
            itemEntryInfo.setQCModifyMode(stEntryInfo.getQCModifyMode());
            itemEntryInfo.setRemark(stEntryInfo.getRemark());
            itemEntryInfo.setQCValueType(stEntryInfo.getQCItem().getQCValueType());
            itemEntryInfo.setAnalysisMethod(stEntryInfo.getQCItem().getAnalysisMethod());
            itemEntryInfo.setQCItemAttr(stEntryInfo.getQCItem().getQCItemAttr());
            itemEntryInfo.setDataPrecision(stEntryInfo.getDataPrecision());
            itemEntryInfo.setQCValueAcquisitionMode(stEntryInfo.getQCValueAcquisitionMode());
            itemEntryInfo.setMergeMode(stEntryInfo.getMergeMode());
            for (int j = 0; j < extendAttr.size(); ++j) {
                QCStandardItemExtendAttrInfo extendAttrInfo = extendAttr.get(j);
                if (!QMEqualsUtils.equals((Object)extendAttrInfo.getQCStandardEntry(), (Object)stEntryInfo)) continue;
                itemEntryInfo.setDelegOrgUnit(extendAttrInfo.getDelegOrgUnit());
                itemEntryInfo.setQCGroup(extendAttrInfo.getQCGroup());
                itemEntryInfo.setQCInstrument(extendAttrInfo.getQCInstrument());
                itemEntryInfo.setQCInstrumentGroup(extendAttrInfo.getQCInstrumentGroup());
                itemEntryInfo.setSampleProgram(extendAttrInfo.getSampleProgram());
                break;
            }
            this.setSampleProgramQty(ctx, itemEntryInfo, qcRequestEntryInfo.getDeliverQty());
            qcitems.add(itemEntryInfo);
        }
        return qcitems;
    }

    protected QCStandardItemExtendAttrCollection getExtendAttr(Context ctx, QualityOrgUnitInfo qualityOrgUnit, QCStandardInfo qcStandard) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)qcStandard.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)qualityOrgUnit.getId().toString()));
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add("qCGroup.id");
        view.getSelector().add("qCGroup.name");
        view.getSelector().add("qCGroup.number");
        view.getSelector().add("delegOrgUnit.id");
        view.getSelector().add("delegOrgUnit.name");
        view.getSelector().add("delegOrgUnit.number");
        view.getSelector().add("qCInstrument.id");
        view.getSelector().add("qCInstrument.name");
        view.getSelector().add("qCInstrument.number");
        view.getSelector().add("qCInstrumentGroup.id");
        view.getSelector().add("qCInstrumentGroup.name");
        view.getSelector().add("qCInstrumentGroup.number");
        view.getSelector().add("sampleProgram.id");
        view.getSelector().add("sampleProgram.number");
        view.getSelector().add("sampleProgram.name");
        view.getSelector().add("qCStandardEntry.*");
        QCStandardItemExtendAttrCollection extendAttr = QCStandardItemExtendAttrFactory.getLocalInstance((Context)ctx).getQCStandardItemExtendAttrCollection(view);
        return extendAttr;
    }

    protected void setSampleProgramQty(Context ctx, QCRequestQcItemEntryInfo itemEntryInfo, BigDecimal deliveryQty) throws BOSException, EASBizException {
        if (NumericUtils.equalsZero((BigDecimal)deliveryQty) || itemEntryInfo.getSampleProgram() == null) {
            return;
        }
        IQCSamplingProgramFacade facade = QCSamplingProgramFacadeFactory.getLocalInstance((Context)ctx);
        Map map = facade.getAcceptStandard(itemEntryInfo.getSampleProgram().getId().toString(), deliveryQty);
        BigDecimal sampleShares = map.get("sampleCount") != null ? (BigDecimal)map.get("sampleCount") : null;
        BigDecimal acValue = map.get("ac") != null ? (BigDecimal)map.get("ac") : null;
        BigDecimal reValue = map.get("re") != null ? (BigDecimal)map.get("re") : null;
        itemEntryInfo.setSampleShares(sampleShares);
        itemEntryInfo.setAcValue(acValue);
        itemEntryInfo.setReValue(reValue);
    }

    protected void isAssignedConStdToOrg(Context ctx, QualityOrgUnitInfo qualityOrgUnit, QCStandardInfo qcStandardInfo) throws BOSException, EASBizException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("select FDATABASEDID   from  T_QM_DataBaseDAssign ");
        sb.appendSql(" where FBOSOBJECTTYPE='C8666A62' and FDATABASEDID in (");
        sb.appendParam((Object)qcStandardInfo.getId().toString());
        sb.appendSql(") and FASSIGNORGUNITID in (");
        sb.appendParam((Object)qualityOrgUnit.getId().toString());
        sb.appendSql(")");
        ResultSet rs = sb.exeQuery(ctx);
        try {
            if (!rs.next()) {
                throw new QCRequestException(QCRequestException.CONSTDHASNOTASSIGNEDORG, new Object[]{qcStandardInfo.getName(), qualityOrgUnit.getName()});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public QCRequestQcItemEntryCollection getConStandardItems(Context ctx, QualityOrgUnitInfo qualityOrgUnit, QCRequestEntryInfo qcRequestEntryInfo) throws BOSException, EASBizException {
        QCRequestQcItemEntryCollection qcitems = new QCRequestQcItemEntryCollection();
        QCStandardInfo qcStandardInfo = qcRequestEntryInfo.getQcStandard();
        this.isAssignedConStdToOrg(ctx, qualityOrgUnit, qcStandardInfo);
        MaterialInfo materialInfo = qcRequestEntryInfo.getMaterial();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (qcRequestEntryInfo.getSourceBillID() == null) {
            PurContractInfo purContractInfo = qcRequestEntryInfo.getPurContract();
            if (purContractInfo == null) {
                return qcitems;
            }
            filter.getFilterItems().add(new FilterItemInfo("parent3.material.id", (Object)materialInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("parent3.parent.id", (Object)purContractInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("checkStandard.id", (Object)qcStandardInfo.getId().toString()));
        } else {
            String sql = "select oe.fsourcebillentryid purcontractentryid  from t_sm_purorderentry oe, t_im_purreceivalentry re where re.fpurorderentryid =oe.fid and re.fid='" + qcRequestEntryInfo.getSourceBillEntryID() + "'";
            filter.getFilterItems().add(new FilterItemInfo("parent3.id", (Object)sql, CompareType.INNER));
        }
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add("qcItem.*");
        QCStandardItemExtendAttrCollection extendAttr = this.getExtendAttr(ctx, qualityOrgUnit, qcStandardInfo);
        PurContractQCItemsNorthCollection coll = PurContractQCItemsNorthFactory.getLocalInstance((Context)ctx).getPurContractQCItemsNorthCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            PurContractQCItemsNorthInfo qcStandardEntryInfo = coll.get(i);
            qcStandardEntryInfo.getParent3();
            QCRequestQcItemEntryInfo itemEntryInfo = new QCRequestQcItemEntryInfo();
            itemEntryInfo.setEntry(qcRequestEntryInfo);
            QCStandardItemExtendAttrInfo extendAttrInfo = null;
            QCStandardItemEntryInfo qcentry = null;
            for (int j = 0; j < extendAttr.size(); ++j) {
                extendAttrInfo = extendAttr.get(j);
                if (!QMEqualsUtils.equals((Object)extendAttrInfo.getQCStandardEntry().getQCItem(), (Object)qcStandardEntryInfo.getQcItem())) continue;
                itemEntryInfo.setDelegOrgUnit(extendAttrInfo.getDelegOrgUnit());
                itemEntryInfo.setQCGroup(extendAttrInfo.getQCGroup());
                itemEntryInfo.setQCInstrument(extendAttrInfo.getQCInstrument());
                itemEntryInfo.setQCInstrumentGroup(extendAttrInfo.getQCInstrumentGroup());
                itemEntryInfo.setUnit(extendAttrInfo.getQCStandardEntry().getUnit());
                itemEntryInfo.setSampleProgram(extendAttrInfo.getSampleProgram());
                qcentry = extendAttrInfo.getQCStandardEntry();
                break;
            }
            itemEntryInfo.setSeq(qcStandardEntryInfo.getSeq());
            itemEntryInfo.setQCItem(qcStandardEntryInfo.getQcItem());
            itemEntryInfo.setIsRuinous(qcStandardEntryInfo.getQcItem().isIsRuinous());
            itemEntryInfo.setIsBalanceItem(qcStandardEntryInfo.isIsSettlementItem());
            itemEntryInfo.setIsMustCheck(qcStandardEntryInfo.isIsRequiredCheck());
            itemEntryInfo.setIsKeyItem(qcStandardEntryInfo.isIsKeyItem());
            itemEntryInfo.setEnums(qcStandardEntryInfo.getQcItem().getEnums());
            itemEntryInfo.setJudgeType(qcStandardEntryInfo.getJudgeType());
            itemEntryInfo.setLowerLimit(qcStandardEntryInfo.getComparator1());
            itemEntryInfo.setLower(qcStandardEntryInfo.getLowRange());
            itemEntryInfo.setUpper(qcStandardEntryInfo.getUpperRange());
            itemEntryInfo.setUpperLimit(qcStandardEntryInfo.getComparator2());
            itemEntryInfo.setQCValueType(qcStandardEntryInfo.getQcItem().getQCValueType());
            itemEntryInfo.setAnalysisMethod(qcStandardEntryInfo.getQcItem().getAnalysisMethod());
            itemEntryInfo.setQCItemAttr(qcStandardEntryInfo.getQcItem().getQCItemAttr());
            if (null != qcentry) {
                itemEntryInfo.setCheckStep(qcentry.getCheckStep());
                itemEntryInfo.setStandardRequirement(qcentry.getStandardRequirement());
                itemEntryInfo.setQCFrequency(qcentry.getQCFrequency());
                itemEntryInfo.setQCMethod(qcentry.getQCMethod());
                itemEntryInfo.setDefaultValue(qcentry.getDefaultValue());
                itemEntryInfo.setExpression(qcentry.getExpression());
                itemEntryInfo.setItemType(qcentry.getItemType());
                itemEntryInfo.setQCModifyMode(qcentry.getQCModifyMode());
                itemEntryInfo.setRemark(qcentry.getRemark());
                itemEntryInfo.setDataPrecision(qcentry.getDataPrecision());
                itemEntryInfo.setQCValueAcquisitionMode(qcentry.getQCValueAcquisitionMode());
                itemEntryInfo.setMergeMode(qcentry.getMergeMode());
            }
            qcitems.add(itemEntryInfo);
        }
        return qcitems;
    }

    @Override
    protected IObjectCollection _getQcItemEntryColl(Context ctx, IObjectValue qualityOrgUnit, IObjectValue qcRequestEntry) throws BOSException, EASBizException {
        QCRequestEntryInfo qcRequestEntryInfo = (QCRequestEntryInfo)qcRequestEntry;
        QCRequestQcItemEntryCollection newQcItemEntries = new QCRequestQcItemEntryCollection();
        newQcItemEntries = qcRequestEntryInfo.isIsConStandard() ? this.getConStandardItems(ctx, (QualityOrgUnitInfo)qualityOrgUnit, qcRequestEntryInfo) : this.getStandardItems(ctx, (QualityOrgUnitInfo)qualityOrgUnit, qcRequestEntryInfo);
        return newQcItemEntries;
    }

    @Override
    protected BatchExecuteResult _batchCreateToBill(Context ctx, List idArray, List entriesIds) throws BOSException, EASBizException {
        this.lockData(ctx, idArray);
        ServerEvent event = new ServerEvent();
        String eventName = "createToBill";
        event.setEventName(eventName);
        event.setSrcObject((Object)idArray);
        event.setParams(new Object[]{idArray, entriesIds});
        ServerActionManager serverActionManager = new ServerActionManager(eventName);
        serverActionManager.addServerAction((IServerAction)new QCRequestBatchCreateToBillServerAction());
        serverActionManager.fireServerAction(ctx, event);
        if (event.getResult() != null) {
            return (BatchExecuteResult)event.getResult();
        }
        return null;
    }

    protected IVerifyManager getUnAuditVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        IVerifyManager unAuditVerifyManager = super.getUnAuditVerifyManager(ctx, info);
        final QCRequestInfo reqInfo = (QCRequestInfo)info;
        unAuditVerifyManager.addVerifyItem((IVerifyItem)new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                for (int i = 0; i < reqInfo.getEntrys().size(); ++i) {
                    QCRequestEntryInfo entry = reqInfo.getEntrys().get(i);
                    if (entry.isIsGenDestBill()) continue;
                    return true;
                }
                throw new QCRequestException(QCRequestException.UNAUDIT_ALLGENBILL);
            }
        });
        return unAuditVerifyManager;
    }

    protected void _createToQCReport(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected boolean _hasDestBill(Context ctx, String reqEntryId) throws BOSException, EASBizException {
        return false;
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        super._handleAfterTransform(ctx, action, collection);
    }

    @Override
    protected EntityViewInfo _getQCStandardFilter(Context ctx, IObjectValue mainOrgUnit, QCBizTypeEnum qcBizType, IObjectValue bizGroup, IObjectValue bizInfo, IObjectValue material, IObjectValue person, IObjectValue standardRooting, int wpSeq, IObjectValue operation, IObjectValue productLine, IObjectValue productLineWPEntry) throws BOSException, EASBizException {
        ServerEvent event = new ServerEvent();
        String eventName = "getQCStandardFilter";
        event.setEventName(eventName);
        event.setSrcObject((Object)mainOrgUnit);
        event.setParams(new Object[]{mainOrgUnit, qcBizType, bizGroup, bizInfo, material, person, standardRooting, new Integer(wpSeq), operation, productLine, productLineWPEntry});
        ServerActionManager serverActionManager = new ServerActionManager(eventName);
        serverActionManager.addServerAction((IServerAction)new QCStandardFilterServerAction());
        serverActionManager.fireServerAction(ctx, event);
        if (event.getResult() != null) {
            return (EntityViewInfo)event.getResult();
        }
        return null;
    }

    @Override
    protected void _cancleResult(Context ctx, IObjectValue qcRequestInfo, String qcRequestEntryId, String qcReportId, QCResultReWriteTypeEnum type) throws BOSException, EASBizException {
        ServerEvent event = new ServerEvent();
        String eventName = "CANCEL_RESULT";
        event.setEventName(eventName);
        event.setSrcObject((Object)qcRequestInfo);
        event.setParams(new Object[]{qcRequestInfo, qcRequestEntryId, qcReportId, type});
        QMCoreBillBaseInfo model = (QMCoreBillBaseInfo)qcRequestInfo;
        this.getServerActionManager(ctx, model, eventName).fireServerAction(ctx, event);
    }

    @Override
    protected void _submitResult(Context ctx, IObjectValue qcRequestInfo, String qcRequestEntryId, String qcReportId, QCResultReWriteTypeEnum type) throws BOSException, EASBizException {
        ServerEvent event = new ServerEvent();
        String eventName = "SUBMIT_RESULT";
        event.setEventName(eventName);
        event.setSrcObject((Object)qcRequestInfo);
        event.setParams(new Object[]{qcRequestInfo, qcRequestEntryId, qcReportId, type});
        QMCoreBillBaseInfo model = (QMCoreBillBaseInfo)qcRequestInfo;
        this.getServerActionManager(ctx, model, eventName).fireServerAction(ctx, event);
    }

    @Override
    protected EntityViewInfo _getPurQCStandardFilter(Context ctx, IObjectValue purOrg, String materialId, String supplierId, IObjectValue qualityOrgUnit) throws BOSException, EASBizException {
        PurchaseOrgUnitInfo purOrgInfo = (PurchaseOrgUnitInfo)purOrg;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (purOrg == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
            ev.setFilter(filter);
            return ev;
        }
        if (materialId == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
            ev.setFilter(filter);
            return ev;
        }
        if (supplierId == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
            ev.setFilter(filter);
            return ev;
        }
        if (qualityOrgUnit == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
            ev.setFilter(filter);
            return ev;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("purchaseOrg.id", (Object)purOrgInfo.getId().toString()));
        filter2.getFilterItems().add(new FilterItemInfo("materialItem.id", (Object)materialId));
        filter2.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierId));
        filter2.getFilterItems().add(new FilterItemInfo("checkStandard.id", null, CompareType.NOTEQUALS));
        view.setFilter(filter2);
        ApprovedSupplierCollection coll = ApprovedSupplierFactory.getLocalInstance((Context)ctx).getApprovedSupplierCollection(view);
        if (coll.size() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                QCStandardInfo checkStandard = coll.get(i).getCheckStandard();
                String id = checkStandard.getId().toString();
                set.add(id);
            }
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            ev.setFilter(filter);
            return ev;
        }
        MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialId));
        return this._getQCStandardFilter(ctx, qualityOrgUnit, QCBizTypeEnum.purCheck, null, null, (IObjectValue)materialInfo, null, null, 0, null, null, null);
    }

    @Override
    protected boolean _updateUrgentRelease(Context ctx, List srcEntryIds, boolean isRealeas) throws BOSException, EASBizException {
        if (srcEntryIds == null || srcEntryIds.size() == 0) {
            return false;
        }
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("update T_QM_QCRequestEntry set FIsReturnResult=? where FSourceBillEntryId in (");
        sb.addParam((Object)(isRealeas ? QMConstant.TRUE : QMConstant.FALSE));
        sb.appendParam((Object[])srcEntryIds.toArray(new String[srcEntryIds.size()]));
        sb.appendSql(")");
        sb.execute(ctx);
        return true;
    }

    private String addSearchCondition(Context ctx, String sql) {
        StringBuffer sbSQL = new StringBuffer(sql);
        if (ctx.get((Object)"weighTypeInfo") != null) {
            sbSQL.append(" and nb.FBillTypeID = '").append(ctx.get((Object)"weighTypeInfo")).append("'");
        }
        DateFormat formatter = BOSLocaleUtil.getDateFormat();
        if (ctx.get((Object)"tareWeightStartTime") != null) {
            Date tStartTime = (Date)ctx.get((Object)"tareWeightStartTime");
            sbSQL.append(" and to_char(wbill.TarePoundTime, 'yyyy-MM-dd') >= '").append(formatter.format(tStartTime)).append("'");
        }
        if (ctx.get((Object)"tareWeightEndTime") != null) {
            Date tEndTime = (Date)ctx.get((Object)"tareWeightEndTime");
            sbSQL.append(" and to_char(wbill.TarePoundTime, 'yyyy-MM-dd') <= '").append(formatter.format(tEndTime)).append("'");
        }
        if (ctx.get((Object)"tareGrossStartTime") != null) {
            Date gStartTime = (Date)ctx.get((Object)"tareGrossStartTime");
            sbSQL.append(" and to_char(wbill.GrossPoundTime, 'yyyy-MM-dd') >= '").append(formatter.format(gStartTime)).append("'");
        }
        if (ctx.get((Object)"tareGrossEndTime") != null) {
            Date gEndTime = (Date)ctx.get((Object)"tareGrossEndTime");
            sbSQL.append(" and to_char(wbill.GrossPoundTime, 'yyyy-MM-dd') <= '").append(formatter.format(gEndTime)).append("'");
        }
        if (!QMStringUtils.isEmpty((String)((String)ctx.get((Object)"carNum")))) {
            String carNum = (String)ctx.get((Object)"carNum");
            if (!QMStringUtils.isEmpty((String)carNum)) {
                carNum = carNum.replaceAll("'", "''");
            }
            sbSQL.append(" and nbe.FCarNumber like '%").append(carNum).append("%'");
        }
        if (ctx.get((Object)"requestID") != null) {
            String requestID = (String)ctx.get((Object)"requestID");
            sbSQL.append(" and (rrwe.FParentID is null or rrwe.FParentID = '").append(requestID).append("')");
        }
        return sbSQL.toString();
    }

    @Override
    protected Map _getRelatedNotices(Context ctx, String materialID, String sourceBillEntryID, String qcRequestID) throws BOSException, EASBizException {
        if (QMStringUtils.isEmpty((String)sourceBillEntryID) || QMStringUtils.isEmpty((String)materialID)) {
            return null;
        }
        String sql = this.getRelateSQL();
        sql = this.addSearchCondition(ctx, sql);
        String enableSQL = sql + " and nbe.FBillStatus = ?";
        String disableSQL = sql + " and (nbe.FBillStatus <> ? or nbe.FBillStatus is null)";
        String orderASC = " order by nb.FNumber,nbe.FCarNumber ASC ";
        enableSQL = enableSQL + orderASC;
        disableSQL = disableSQL + orderASC;
        IRowSet enableRS = DbUtil.executeQuery((Context)ctx, (String)enableSQL, (Object[])new Object[]{new Integer(40), sourceBillEntryID, materialID, qcRequestID, new Integer(30)});
        HashMap<String, IRowSet> map = new HashMap<String, IRowSet>();
        map.put("enableRS", enableRS);
        return map;
    }

    private String getRelateSQL() {
        StringBuffer sql = new StringBuffer();
        String localFName = this.getLocalField("FName");
        sql.append(" select nb.FNumber as weighNoticeNumber, \n");
        sql.append("\t\tnbe.FID as weighNoticeEntryID, \n");
        sql.append("\t\tnbe.FCarNumber as carNumber, \n");
        sql.append("\t\tbt." + localFName + " as weighBillType, \n");
        sql.append("\t\tnbe.FWeighStatus as weighStatus, \n");
        sql.append("\t\tnb.FBillStatus as weighBillStatus, \n");
        sql.append("\t\tmat.FNumber as materialNumber, \n");
        sql.append("\t\tmat." + localFName + " as materialNumber, \n");
        sql.append("\t\twbill.ID as weighBillID, \n");
        sql.append("\t\twbill.Number as weighNumber, \n");
        sql.append("\t\twbill.GrossScaleUit as grossScaleUit, \n");
        sql.append("\t\twbill.GrossWeight as grossWeight, \n");
        sql.append("\t\twbill.TareScaleUnit as tareScaleUnit, \n");
        sql.append("\t\twbill.TareWeight as tareWeight, \n");
        sql.append("\t\twbill.Incidental as incidental, \n");
        sql.append("\t\twbill.NetWeight as netWeight, \n");
        sql.append("\t\tnbe.FOpponentWeight as supportAmt, \n");
        sql.append("\t\twbill.Unit as unit, \n");
        sql.append("\t\twbill.IsContinuousCar as continousCar, \n");
        sql.append("\t\twbill.IsMuchCarry as muchCarry, \n");
        sql.append("\t\twbill.SendOrgId as sendOrgUnit, \n");
        sql.append("\t\twbill.InceptOrgId as inspectOrgUnit, \n");
        sql.append("\t\tdw." + localFName + " as sendWarehouse, \n");
        sql.append("\t\tuw." + localFName + " as inspectWarehouse, \n");
        sql.append("\t\twbill.GrossAdminOrg as grossAdminOrg, \n");
        sql.append("\t\twbill.TareAdminOrg as tareAdminOrg, \n");
        sql.append("\t\twbill.GrossPoundor as grossPoundor, \n");
        sql.append("\t\twbill.TarePoundor as tarePoundor, \n");
        sql.append("\t\twbill.GrossPoundTime as grossWeighTime, \n");
        sql.append("\t\twbill.TarePoundTime as tareWeighTime, \n");
        sql.append("\t\t\n");
        sql.append("\t\tnbe.FIsRelatingQcRequest as isRelatingQC, \n");
        sql.append("\t\trrwe.FParentID as requestId \n");
        sql.append(" from T_WM_WeighNoticeBillEntry as nbe \n");
        sql.append(" inner join T_WM_WeighNoticeBill as nb on nbe.FParentID = nb.FID \n");
        sql.append(" inner join T_WM_WeighBillType as bt on nb.FBillTypeID = bt.FID \n");
        sql.append(" inner join T_BD_Material as mat on nbe.FMaterialID = mat.FID \n");
        sql.append(" left outer join T_DB_WAREHOUSE as dw on nbe.FDeliveryWarehouseID = dw.FID \n");
        sql.append(" left outer join T_DB_WAREHOUSE as uw on nbe.FUnloadWareHouseID = uw.FID \n");
        sql.append(" left outer join T_QM_QCRequestRelWeighEntry as rrwe on nbe.FID = rrwe.FRelNoticeEntryID \n");
        sql.append(" left outer join ( \n");
        sql.append(" select bill.FID as ID,bill.FNumber as Number,bill.FGrossWeight as GrossWeight, \n");
        sql.append("\t\tbill.FTareWeight as TareWeight,bill.FIncidental as Incidental,bill.FNetWeight as NetWeight,");
        sql.append("\t\tbill.FTheWeight as TheWeight,");
        sql.append("\t\tbill.FIsContinuousCar as IsContinuousCar,bill.FIsMuchCarry as IsMuchCarry, \n");
        sql.append("\t\tbill.FSendOrgId as SendOrgId,bill.FInceptOrgId as InceptOrgId, \n");
        sql.append("\t\tbill.FGrossPoundTime as GrossPoundTime,bill.FTarePoundTime as TarePoundTime,");
        sql.append("\t\tbill.FSourceBillEntryID as SourceBillEntryID, \n");
        sql.append("\t\tunit." + localFName + " as Unit, \n");
        sql.append("\t\tgsu." + localFName + " as GrossScaleUit, \n");
        sql.append("\t\ttsu." + localFName + " as TareScaleUnit, \n");
        sql.append("\t\tgao." + localFName + " as GrossAdminOrg, \n");
        sql.append("\t\ttao." + localFName + " as TareAdminOrg, \n");
        sql.append("\t\tsp." + localFName + " as GrossPoundor, \n");
        sql.append("\t\ttp." + localFName + " as TarePoundor \n");
        sql.append(" from \tT_WM_WeighBill as bill \n");
        sql.append(" left outer join T_BD_MeasureUnit as unit on bill.FUnitID = unit.FID \n");
        sql.append(" left outer join T_WM_Scale as gs on bill.FGrossScaleID = gs.FID \n");
        sql.append(" left outer join T_WM_Scale as ts on bill.FTareScaleID = ts.FID \n");
        sql.append(" left outer join T_BD_MeasureUnit as gsu on gs.FUnitID = gsu.FID \n");
        sql.append(" left outer join T_BD_MeasureUnit as tsu on ts.FUnitID = tsu.FID \n");
        sql.append(" left outer join T_ORG_Admin as gao on bill.FGrossAdminOrgID = gao.FID \n");
        sql.append(" left outer join T_ORG_Admin as tao on bill.FTareAdminOrgID = tao.FID \n");
        sql.append(" left outer join T_PM_User as sp on bill.FGrossPoundorID = sp.FID \n");
        sql.append(" left outer join T_PM_User as tp on bill.FTarePoundorID = tp.FID \n");
        sql.append(" where bill.FBillStatus is null or bill.FBillStatus <> ? \n");
        sql.append(" ) as wbill on nbe.FID = wbill.SourceBillEntryID \n");
        sql.append(" where nbe.FSourceBillEntryID = ? \n");
        sql.append(" and nbe.FMaterialID = ? \n");
        sql.append(" and (rrwe.FParentID = ?  \n");
        sql.append(" or nbe.FIsRelatingQCRequest = 0) \n");
        return sql.toString();
    }

    @Override
    protected void _relateWeighNotice(Context ctx, QCRequestInfo requestInfo, List noticeEntryIDs, List requestEntryIDs) throws BOSException, EASBizException {
        ServerEvent event = new ServerEvent();
        String eventName = "relateWeighNotice";
        event.setEventName(eventName);
        event.setSrcObject((Object)requestInfo);
        event.setParams(new Object[]{noticeEntryIDs, requestEntryIDs});
        QCRequestInfo model = requestInfo;
        this.getServerActionManager(ctx, (QMCoreBillBaseInfo)model, eventName).fireServerAction(ctx, event);
    }

    @Override
    protected void _relateWeighNotice(Context ctx, QCRequestInfo requestInfo, List requestEntrys) throws BOSException, EASBizException {
        ServerEvent event = new ServerEvent();
        String eventName = "relateWeighNotice";
        event.setEventName(eventName);
        event.setSrcObject((Object)requestInfo);
        event.setParams(new Object[]{requestEntrys});
        QCRequestInfo model = requestInfo;
        this.getServerActionManager(ctx, (QMCoreBillBaseInfo)model, eventName).fireServerAction(ctx, event);
    }

    private String getLocalField(String field) {
        String name = null;
        Locale locale = ContextUtils.getLocaleFromEnv();
        if ("l1".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L1 ";
        } else if ("l3".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L3 ";
        } else if ("l2".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L2 ";
        }
        return name;
    }

    protected String getAuditPerItem(Context ctx, QMCoreBillBaseInfo info) throws EASBizException, BOSException {
        String auditPermName = "";
        QCRequestInfo reqInfo = (QCRequestInfo)info;
        if (reqInfo.getQcBizType().equals((Object)QCBizTypeEnum.purCheck)) {
            auditPermName = "qm_QCPurRequest_06audit";
        } else if (reqInfo.getQcBizType().equals((Object)QCBizTypeEnum.pdtProcessCheck)) {
            auditPermName = "qm_QCMMRequest_06audit";
        } else if (reqInfo.getQcBizType().equals((Object)QCBizTypeEnum.pdtDiscreteCheck)) {
            auditPermName = "qm_QCMMRequest_06audit";
        } else if (reqInfo.getQcBizType().equals((Object)QCBizTypeEnum.otherCheck)) {
            auditPermName = "qm_QCOtherRequest_06audit";
        }
        return auditPermName;
    }

    @Override
    protected StringBuffer _canCancelResult(Context ctx, String srcbillId, String srcbillEntryId, QCReturnResultCollection rsList) throws BOSException, EASBizException {
        StringBuffer result = new StringBuffer();
        return result;
    }

    protected SelectorItemCollection getPrepareDataSelector(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        return sic;
    }

    private void repairSamplePrgmQtys(Context ctx, QCRequestInfo info) throws BOSException, EASBizException {
        QCRequestEntryCollection materialEntrys = info.getEntrys();
        for (int i = 0; i < materialEntrys.size(); ++i) {
            QCRequestEntryInfo entry = materialEntrys.get(i);
            BigDecimal deliverQty = entry.getDeliverQty();
            QCRequestQcItemEntryCollection itemEntrys = entry.getQcItemEntrys();
            for (int j = 0; j < itemEntrys.size(); ++j) {
                QCRequestQcItemEntryInfo itemEntry = itemEntrys.get(j);
                QCSamplingProgramInfo sampleProgram = itemEntry.getSampleProgram();
                if (null == itemEntry.getSampleProgram()) continue;
                IQCSamplingProgramFacade facade = QCSamplingProgramFacadeFactory.getLocalInstance((Context)ctx);
                Map map = facade.getAcceptStandard(sampleProgram.getId().toString(), deliverQty);
                if (map.get("ac") != null) {
                    itemEntry.setAcValue((BigDecimal)map.get("ac"));
                }
                if (map.get("re") != null) {
                    itemEntry.setReValue((BigDecimal)map.get("re"));
                }
                if (map.get("sampleCount") == null) continue;
                itemEntry.setSampleShares((BigDecimal)map.get("sampleCount"));
            }
        }
    }
}

