/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.qm.basedata.IQCSamplingProgramFacade;
import com.kingdee.eas.qm.basedata.IQCStandardExtendAttr;
import com.kingdee.eas.qm.basedata.QCBizObjectGroupInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramFacadeFactory;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrCollection;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrFactory;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.common.app.action.IServerAction;
import com.kingdee.eas.qm.common.app.action.ServerAction;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.common.util.QMDateUtils;
import com.kingdee.eas.qm.common.util.QMResourceUtils;
import com.kingdee.eas.qm.common.util.QMVerifyHelper;
import com.kingdee.eas.qm.qc.QCRequestEntryCollection;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCRequestException;
import com.kingdee.eas.qm.qc.QCRequestFactory;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryCollection;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryInfo;
import com.kingdee.eas.qm.qc.app.reversesave.qcrequest.QCRequestReverseSaveUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCRequestRepareServerAction
extends ServerAction
implements IServerAction {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.qc.app.action.QCRequestRepareQCItemEntriesServerAction");
    private IMaterial imaterial = null;
    private IMultiMeasureUnit iMultiMeasureUnit = null;

    public void handler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCRequestEntryInfo qcRequestEntryInfo;
        super.handler(ctx, event);
        QCRequestInfo info = (QCRequestInfo)event.getSrcObject();
        QCRequestEntryCollection entries = info.getEntrys();
        QCRequestQcItemEntryCollection qcItemEntries = info.getQcItemEntrys();
        logger.info((Object)("qcItemEntries.size:" + qcItemEntries.size()));
        qcItemEntries.clear();
        for (int i = 0; i < entries.size(); ++i) {
            QCRequestEntryInfo qcRequestEntryInfo2 = entries.get(i);
            QCStandardInfo qcStandardInfo = qcRequestEntryInfo2.getQcStandard();
            if (qcRequestEntryInfo2.getId() == null) {
                qcRequestEntryInfo2.setId(BOSUuid.create((BOSObjectType)qcRequestEntryInfo2.getBOSType()));
            }
            if (qcStandardInfo != null) {
                QCRequestQcItemEntryCollection entryQcItemEntries = qcRequestEntryInfo2.getQcItemEntrys();
                if (entryQcItemEntries.size() == 0) {
                    logger.error((Object)("begin getQCItemEntryColl " + i));
                    QCRequestQcItemEntryCollection qcItemEntryColl = QCRequestFactory.getLocalInstance(ctx).getQcItemEntryColl(info.getQualityOrgUnit(), qcRequestEntryInfo2);
                    if (qcItemEntryColl.size() == 0) {
                        throw new QCRequestException(QCRequestException.HASNOTEFFECTIVEITEM, new Object[]{qcStandardInfo.getNumber()});
                    }
                    entryQcItemEntries.addCollection(qcItemEntryColl);
                }
            } else {
                logger.error((Object)("qcStandardInfo is null " + i));
                qcRequestEntryInfo2.getQcItemEntrys().clear();
            }
            this.adjustItemEntrys(ctx, qcRequestEntryInfo2.getQcItemEntrys());
            qcItemEntries.addCollection(qcRequestEntryInfo2.getQcItemEntrys());
        }
        logger.info((Object)("qcItemEntries.size:" + qcItemEntries.size()));
        Hashtable<String, MultiMeasureUnitInfo> cache = new Hashtable<String, MultiMeasureUnitInfo>();
        if (info.getQcObjectGroup() == null) {
            QCBizObjectGroupInfo item = new QCBizObjectGroupInfo();
            item.setId(BOSUuid.read((String)"riT9zswST8WoeecRK1GOvg5tH1I="));
            info.setQcObjectGroup(item);
        }
        if (info.getQcBizType() == null && info.getBillType() != null && info.getBillType().getQCBizType() != null) {
            info.setQcBizType(info.getBillType().getQCBizType());
        }
        if (info.getBillType() == null && info.getQcBizType() != null) {
            info.setBillType(QCRequestReverseSaveUtils.getDefaultBillType(ctx, info.getQcBizType()));
        }
        if (info.getReqDate() == null) {
            info.setReqDate(QMDateUtils.transformTimestamp((Date)QMDateUtils.getCurrentTime()));
        }
        if (info.getQcObjectGroup() != null && !info.getQcObjectGroup().getId().toString().equals("riT9zswST8WoeecRK1GOvg5tH1I=")) {
            for (int i = 0; i < entries.size(); ++i) {
                qcRequestEntryInfo = entries.get(i);
                if (qcRequestEntryInfo.getBaseUnit() != null) continue;
                qcRequestEntryInfo.setBaseUnit(qcRequestEntryInfo.getUnit());
                qcRequestEntryInfo.setBaseDeliverQty(qcRequestEntryInfo.getDeliverQty());
            }
        }
        if (info.getQcObjectGroup() != null && info.getQcObjectGroup().getId().toString().equals("riT9zswST8WoeecRK1GOvg5tH1I=")) {
            for (int i = 0; i < entries.size(); ++i) {
                qcRequestEntryInfo = entries.get(i);
                MaterialInfo material = qcRequestEntryInfo.getMaterial();
                BigDecimal qty = qcRequestEntryInfo.getDeliverQty();
                QMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)qcRequestEntryInfo, (String)"deliverQty");
                MeasureUnitInfo baseUnit = qcRequestEntryInfo.getBaseUnit();
                MeasureUnitInfo unit = qcRequestEntryInfo.getUnit();
                if (material == null) {
                    ActionCommonException bizExp = new ActionCommonException(null);
                    bizExp.setMessage(QMResourceUtils.getMessage((String)"com.kingdee.eas.qm.qc.QCRequestResource", (String)"MaterialPlanInfoNotExsist"));
                    throw bizExp;
                }
                String materialid = material.getId().toString();
                String unitid = unit.getId().toString();
                if (baseUnit == null) {
                    material = this.getMaterial(ctx, material.getId());
                    baseUnit = material.getBaseUnit();
                    qcRequestEntryInfo.setBaseUnit(baseUnit);
                }
                String basunitid = baseUnit.getId().toString();
                BigDecimal rate = QMConstant.ONE;
                if (unitid.equals(basunitid)) {
                    rate = QMConstant.ONE;
                } else {
                    String key = materialid + unitid;
                    MultiMeasureUnitInfo m = (MultiMeasureUnitInfo)cache.get(key);
                    if (m == null) {
                        m = this.getMultiMeasureUnitInfo(ctx, materialid, unitid);
                        cache.put(key, m);
                    }
                    if (m != null) {
                        rate = m.getBaseConvsRate();
                    }
                }
                BigDecimal baseQty = qty.multiply(rate);
                qcRequestEntryInfo.setBaseDeliverQty(baseQty);
            }
        }
    }

    private void repairQCRequestEntry(Context ctx, QCRequestEntryInfo reqEntryInfo, QCRequestInfo reqInfo) throws BOSException, EASBizException {
        if (null == reqEntryInfo || null == reqEntryInfo.getQcStandard()) {
            return;
        }
        QCStandardInfo qcStandard = reqEntryInfo.getQcStandard();
        if (null == reqEntryInfo.getQcStandardType()) {
            reqEntryInfo.setQcStandardType(qcStandard.getQcStandardType());
        }
        if (null == reqEntryInfo.getQcType()) {
            reqEntryInfo.setQcType(qcStandard.getSampleSolution());
        }
        if (reqEntryInfo.getEachSampleUnit() == null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)qcStandard.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)reqInfo.getQualityOrgUnit().getId().toString()));
            view.setFilter(filter);
            IQCStandardExtendAttr iext = QCStandardExtendAttrFactory.getLocalInstance((Context)ctx);
            QCStandardExtendAttrCollection coll = iext.getQCStandardExtendAttrCollection(view);
            QCStandardExtendAttrInfo stdExtInfo = coll.get(0);
            reqEntryInfo.setEachSampleUnit(stdExtInfo.getEachSampleUnit());
            reqEntryInfo.setEachSampleQty(stdExtInfo.getEachSampleQty());
        }
    }

    private void updateQCSampleQtys(Context ctx, QCRequestQcItemEntryCollection qcItemEntryColl) throws BOSException, EASBizException {
        for (int i = 0; i < qcItemEntryColl.size(); ++i) {
            QCRequestQcItemEntryInfo itemEntryInfo = qcItemEntryColl.get(i);
            QCSamplingProgramInfo sampleProgram = itemEntryInfo.getSampleProgram();
            if (null == sampleProgram) continue;
            BigDecimal deliverQty = itemEntryInfo.getEntry().getDeliverQty();
            IQCSamplingProgramFacade facade = QCSamplingProgramFacadeFactory.getLocalInstance((Context)ctx);
            Map map = facade.getAcceptStandard(sampleProgram.getId().toString(), deliverQty);
            if (map.get("ac") != null) {
                itemEntryInfo.setAcValue((BigDecimal)map.get("ac"));
            }
            if (map.get("re") == null) continue;
            itemEntryInfo.setReValue((BigDecimal)map.get("re"));
        }
    }

    protected void adjustItemEntrys(Context ctx, QCRequestQcItemEntryCollection qcItemEntryColl) {
        if (qcItemEntryColl == null || qcItemEntryColl.size() == 0) {
            return;
        }
        for (int i = 0; i < qcItemEntryColl.size(); ++i) {
            QCRequestQcItemEntryInfo itemEntry = qcItemEntryColl.get(i);
            if (itemEntry.getQCValueType() == null) {
                itemEntry.setQCValueType(itemEntry.getQCItem().getQCValueType());
            }
            if (itemEntry.getEnums() != null) continue;
            itemEntry.setEnums(itemEntry.getQCItem().getEnums());
        }
    }

    private MaterialInfo getMaterial(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (this.imaterial == null) {
            this.imaterial = MaterialFactory.getLocalInstance((Context)ctx);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseUnit.*"));
        return this.imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    private MultiMeasureUnitInfo getMultiMeasureUnitInfo(Context ctx, String strMaterialID, String strMeasureUnitID) throws BOSException, EASBizException {
        if (this.iMultiMeasureUnit == null) {
            this.iMultiMeasureUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        }
        return this.iMultiMeasureUnit.getMultiUnit(strMaterialID, strMeasureUnitID);
    }
}

