/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.reversesave.qcreject;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCSourceBillTypeInfo;
import com.kingdee.eas.qm.common.app.action.IServerAction;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.app.reversesave.ReverseServerAction;
import com.kingdee.eas.qm.common.util.NumericUtils;
import com.kingdee.eas.qm.common.util.QMUnitAndExchangeUtils;
import com.kingdee.eas.qm.qc.QCRPBillTypeEnum;
import com.kingdee.eas.qm.qc.QCRejectProcessEntryCollection;
import com.kingdee.eas.qm.qc.QCRejectProcessEntryInfo;
import com.kingdee.eas.qm.qc.QCRejectProcessException;
import com.kingdee.eas.qm.qc.QCRejectProcessInfo;
import com.kingdee.eas.qm.qc.QCRejectProcessRstEntryCollection;
import com.kingdee.eas.qm.qc.QCRejectProcessRstEntryInfo;
import com.kingdee.eas.qm.qc.QCReportFactory;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Iterator;

public class QCRejectPrepareAction
extends ReverseServerAction
implements IServerAction {
    public void afterTransFormHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.afterTransFormHandler(ctx, event);
    }

    public void beforeAddnewHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeAddnewHandler(ctx, event);
        QCRejectProcessInfo info = (QCRejectProcessInfo)event.getSrcObject();
        if (null == info.getSourceBillType()) {
            this.setBtpData(ctx, info);
            this.setBaseUnitAndQty(ctx, info);
        }
    }

    public void beforeUpdateHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeUpdateHandler(ctx, event);
        QCRejectProcessInfo info = (QCRejectProcessInfo)event.getSrcObject();
        this.setBaseUnitAndQty(ctx, info);
    }

    private void setBtpData(Context ctx, QCRejectProcessInfo info) throws EASBizException, BOSException {
        QCSourceBillTypeInfo sourceBillTypeInfo = new QCSourceBillTypeInfo();
        if (null != info.getSourceBillType()) {
            return;
        }
        if (info.getRpBillType().equals((Object)QCRPBillTypeEnum.qcPurRP)) {
            sourceBillTypeInfo.setId(BOSUuid.read((String)"4o71JVzlT/avO5iRUJkDRObqiQE="));
        } else if (info.getRpBillType().equals((Object)QCRPBillTypeEnum.qcFlowManuRP) || info.getRpBillType().equals((Object)QCRPBillTypeEnum.qcDiscreateRP)) {
            sourceBillTypeInfo.setId(BOSUuid.read((String)"GnHD33UuQOmGDfR7lyYQGebqiQE="));
        } else if (info.getRpBillType().equals((Object)QCRPBillTypeEnum.qcStoRP)) {
            sourceBillTypeInfo.setId(BOSUuid.read((String)"L5K5pnofQVO46vaItSdpQObqiQE="));
        }
        info.setSourceBillType(sourceBillTypeInfo);
        info.setCurrency(this.getBaseCurrency(ctx, info.getMainOrgUnit().getId().toString()));
        QCReportInfo rptInfo = QCReportFactory.getLocalInstance(ctx).getQCReportInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        if (null == info.getBillType()) {
            info.setBillType(rptInfo.getBillType());
        }
        if (NumericUtils.equalsZero((BigDecimal)info.getDefectRate())) {
            BigDecimal sampleQty = info.getSampleQty();
            BigDecimal unQualitySamQty = info.getUnQualitySamQty();
            BigDecimal defectRate = null;
            if (NumericUtils.equalsZero((BigDecimal)unQualitySamQty)) {
                unQualitySamQty = rptInfo.getUnPassQty();
                info.setUnQualitySamQty(unQualitySamQty);
            }
            if (NumericUtils.equalsZero((BigDecimal)sampleQty)) {
                sampleQty = rptInfo.getPassQty();
                info.setSampleQty(sampleQty);
            }
            if (!NumericUtils.equalsZero((BigDecimal)unQualitySamQty)) {
                BigDecimal sumQty = unQualitySamQty.add(sampleQty);
                defectRate = unQualitySamQty.divide(sumQty, 4, 4).multiply(NumericUtils.toBigDecimal((Object)new String("100")));
            }
            info.setDefectRate(defectRate);
        }
        MeasureUnitInfo baseUnit = info.getBaseUnit();
        String materialID = info.getMaterial().getId().toString();
        if (null == baseUnit) {
            baseUnit = QMUnitAndExchangeUtils.getBaseUnitForServer((Context)ctx, (String)materialID);
            info.setBaseUnit(baseUnit);
        }
        if (null == info.getBaseSampleQty()) {
            info.setBaseSampleQty(QMUnitAndExchangeUtils.getExchangeQtyForServer((Context)ctx, (MeasureUnitInfo)info.getUnit(), (MeasureUnitInfo)baseUnit, (BigDecimal)info.getSampleQty(), (String)materialID));
        }
        if (null == info.getBaseUnQualitySamQty()) {
            info.setBaseUnQualitySamQty(QMUnitAndExchangeUtils.getExchangeQtyForServer((Context)ctx, (MeasureUnitInfo)info.getUnit(), (MeasureUnitInfo)baseUnit, (BigDecimal)info.getUnQualitySamQty(), (String)materialID));
        }
        QCRejectProcessEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            QCRejectProcessEntryInfo entryInfo = entrys.get(i);
            entryInfo.setMasterDPReason(true);
        }
    }

    private CurrencyInfo getBaseCurrency(Context ctx, String mainOrgID) throws BOSException, EASBizException {
        CurrencyInfo currencyInfo = null;
        if (StringUtils.isEmpty((String)mainOrgID)) {
            return null;
        }
        OrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgID));
        CompanyOrgUnitInfo company = null;
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgID));
        } else {
            Iterator iter;
            IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            company = (CompanyOrgUnitInfo)iOrgRelation.getDefaultToUnit(mainOrgID, 32, 1);
            OrgUnitCollection collection = iOrgRelation.getToUnit(mainOrgID, 32, 1);
            if (null != collection && collection.size() > 0 && (iter = collection.iterator()).hasNext()) {
                company = (CompanyOrgUnitInfo)iter.next();
            }
        }
        if (null == company) {
            throw new QCRejectProcessException(QCRejectProcessException.HASNOTDELECOMPANY);
        }
        currencyInfo = company.getBaseCurrency();
        if (null == currencyInfo) {
            throw new QCRejectProcessException(QCRejectProcessException.HASNOTBASECURRENCY);
        }
        return currencyInfo;
    }

    private void setBaseUnitAndQty(Context ctx, QCRejectProcessInfo info) throws EASBizException, BOSException {
        if (null == info) {
            return;
        }
        QCRejectProcessRstEntryCollection rstEntrys = info.getRstEntry();
        if (null != rstEntrys && rstEntrys.size() > 0) {
            Iterator iter = rstEntrys.iterator();
            while (iter.hasNext()) {
                QCRejectProcessRstEntryInfo rstEntryInfo = (QCRejectProcessRstEntryInfo)iter.next();
                BigDecimal qty = rstEntryInfo.getQty();
                MeasureUnitInfo rstUnit = rstEntryInfo.getUnit();
                MaterialInfo rstMaterial = rstEntryInfo.getMaterial();
                MeasureUnitInfo rstBaseUnit = QMUnitAndExchangeUtils.getBaseUnitForServer((Context)ctx, (String)rstMaterial.getId().toString());
                rstEntryInfo.setBaseUnit(rstBaseUnit);
                rstEntryInfo.setBaseQty(QMUnitAndExchangeUtils.getExchangeQtyForServer((Context)ctx, (MeasureUnitInfo)rstUnit, (MeasureUnitInfo)rstBaseUnit, (BigDecimal)qty, (String)rstMaterial.getId().toString()));
            }
        }
    }

    private MeasureUnitInfo getBaseUnit(Context ctx, String materialID) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)materialID)) {
            return null;
        }
        MeasureUnitInfo baseUnit = null;
        MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
        if (null != material && null != material.getBaseUnit()) {
            baseUnit = material.getBaseUnit();
        }
        return baseUnit;
    }

    private BigDecimal getExchangeQty(Context ctx, MeasureUnitInfo srcUnit, MeasureUnitInfo desUnit, BigDecimal qty, String materialID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)materialID) || null == srcUnit || null == desUnit) {
            return null;
        }
        BigDecimal targetQty = null;
        if (srcUnit.getId().toString().equals(desUnit.getId().toString())) {
            return qty;
        }
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo srcMultiUnitInfo = multiUnit.getMultiUnit(materialID, srcUnit.getId().toString());
        MultiMeasureUnitInfo desMultiUnitInfo = multiUnit.getMultiUnit(materialID, desUnit.getId().toString());
        if (srcMultiUnitInfo != null && desMultiUnitInfo != null) {
            BigDecimal baseExchangeRate1 = srcMultiUnitInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = desMultiUnitInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, baseQty.scale() + qty.scale(), 4);
        }
        return targetQty;
    }
}

