/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.reversesave.qcreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.app.reversesave.ReverseServerAction;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportCreateHelper;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportServerHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCBillToQCReportAction
extends ReverseServerAction {
    private static Logger logger = Logger.getLogger((String)QCBillToQCReportAction.class.getName());

    public void afterAddnewHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCReportInfo reportInfo = (QCReportInfo)event.getSrcObject();
        if (!reportInfo.isFromBOTP()) {
            return;
        }
        this.addBotRelation(ctx, reportInfo);
        this.rewriteQCBillAndQCReport(ctx, reportInfo, true);
    }

    public void beforeDeleteHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCReportInfo reportInfo = (QCReportInfo)event.getSrcObject();
        if (!reportInfo.isFromBOTP()) {
            return;
        }
        this.deleteBotRelation(ctx, reportInfo);
        this.rewriteQCBillAndQCReport(ctx, reportInfo, false);
    }

    public void afterAuditHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCReportInfo reportInfo = (QCReportInfo)event.getSrcObject();
        if (!reportInfo.isFromBOTP()) {
            return;
        }
        this.rewriteQCRequest(ctx, reportInfo, true);
    }

    public void afterUnAuditHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCReportInfo reportInfo = (QCReportInfo)event.getSrcObject();
        if (!reportInfo.isFromBOTP()) {
            return;
        }
        this.rewriteQCRequest(ctx, reportInfo, false);
    }

    public void addBotRelation(Context ctx, QCReportInfo reportInfo) throws BOSException, EASBizException {
        if (!QCReportServerHelper.isQCReportCreateFromInCtx(ctx)) {
            return;
        }
        String sql = this.buildGetBotRelationSql(reportInfo);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap srcKeyMap = new HashMap();
        try {
            while (rs.next()) {
                String srcBosType = rs.getString("SRCBOSTYPE");
                String srcBillID = rs.getString("SRCBILLID");
                String srcBillEntryID = rs.getString("SRCBILLENTRYID");
                String destBosType = rs.getString("DESTBOSTYPE");
                String destBillID = rs.getString("DESTBILLID");
                String destBillEntryID = rs.getString("DESTBILLENTRYID");
                this.processBotRelationInfo(ctx, srcBosType, srcBillID, srcBillEntryID, destBosType, destBillID, destBillEntryID, srcKeyMap, true);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String sql2 = "select distinct(bill.fid) from T_QM_QCBill bill inner join T_QM_QCBillSampleEntry sample ON sample.FParentID = bill.FID where bill.FRequestEntryID = '" + reportInfo.getRequestEntryID() + "' and sample.FIsResResult = 1";
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql2);
        try {
            while (rs2.next()) {
                String srcBillID = rs2.getString("fid");
                if (srcKeyMap.containsKey(srcBillID)) continue;
                String srcBosType = "1AC2BFF5";
                String destBosType = "9029ADA2";
                String destBillID = reportInfo.getId().toString();
                this.processBotRelationInfo(ctx, srcBosType, srcBillID, null, destBosType, destBillID, null, srcKeyMap, false);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        Iterator it = srcKeyMap.keySet().iterator();
        IBOTRelation ibiz = BOTRelationFactory.getLocalInstance((Context)ctx);
        while (it.hasNext()) {
            BOTRelationInfo botRelationInfo = (BOTRelationInfo)srcKeyMap.get(it.next());
            ibiz.addnew(botRelationInfo);
        }
    }

    public String buildGetBotRelationSql(QCReportInfo reportInfo) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T.FREPORTENTRYSRCTYPE AS SRCBOSTYPE, \n");
        sql.append("T.FSOURCEBILLID AS SRCBILLID, \n");
        sql.append("T.FSOURCEBILLENTRYID AS SRCBILLENTRYID, \n");
        sql.append("'" + reportInfo.getBOSType().toString() + "' AS DESTBOSTYPE , \n");
        sql.append("T.FPARENTID AS DESTBILLID, \n");
        sql.append("T.FID AS DESTBILLENTRYID \n");
        sql.append("FROM T_QM_QCReportAllItemEntry T \n");
        sql.append("WHERE T.FPARENTID = '" + reportInfo.getId().toString() + "' \n");
        sql.append("ORDER BY T.FPARENTID, T.FID,T.FREPORTENTRYSRCTYPE, \n");
        sql.append("T.FSOURCEBILLID,T.FSOURCEBILLENTRYID \n");
        sql.append(" \n");
        return sql.toString();
    }

    public void processBotRelationInfo(Context ctx, String srcBosType, String srcBillID, String srcBillEntryID, String destBosType, String destBillID, String destBillEntryID, Map srcKeyMap, boolean isCreateBotRelationEntryInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelationInfo = null;
        if (!srcKeyMap.containsKey(srcBillID)) {
            botRelationInfo = new BOTRelationInfo();
            botRelationInfo.setSrcEntityID(srcBosType);
            botRelationInfo.setSrcObjectID(srcBillID);
            botRelationInfo.setDestEntityID(destBosType);
            botRelationInfo.setDestObjectID(destBillID);
            String botMappingID = QCReportCreateHelper.getQCBillToQCReportBotMappingID(ctx);
            botRelationInfo.setBOTMappingID(botMappingID);
            botRelationInfo.setType(0);
            botRelationInfo.setDate(new Date());
            botRelationInfo.setOperatorID("user");
            if (isCreateBotRelationEntryInfo) {
                this.createBotRelationEntryInfo(srcBosType, srcBillID, srcBillEntryID, destBosType, destBillID, destBillEntryID, botRelationInfo);
            }
            srcKeyMap.put(srcBillID, botRelationInfo);
        } else if (isCreateBotRelationEntryInfo) {
            botRelationInfo = (BOTRelationInfo)srcKeyMap.get(srcBillID);
            this.createBotRelationEntryInfo(srcBosType, srcBillID, srcBillEntryID, destBosType, destBillID, destBillEntryID, botRelationInfo);
        }
    }

    public void createBotRelationEntryInfo(String srcBosType, String srcBillID, String srcBillEntryID, String destBosType, String destBillID, String destBillEntryID, BOTRelationInfo botRelationInfo) throws BOSException, EASBizException {
        BOTRelationEntryInfo entryInfo = new BOTRelationEntryInfo();
        entryInfo.setSrcObjectID(srcBillID);
        entryInfo.setSrcEntryID(srcBillEntryID);
        if ("1AC2BFF5".equals(srcBosType)) {
            entryInfo.setSrcEntryPropName("__src.entrys");
        } else if ("9029ADA2".equals(srcBosType)) {
            entryInfo.setSrcEntryPropName("__src.entrys");
        }
        entryInfo.setDestObjectID(destBillID);
        entryInfo.setDestEntryID(destBillEntryID);
        entryInfo.setDestEntryPropName("__dest.entrys");
        entryInfo.setDestPropertyName("id");
        entryInfo.setRelation(botRelationInfo);
        botRelationInfo.getRelationEntries().add(entryInfo);
    }

    public void deleteBotRelation(Context ctx, QCReportInfo reportInfo) throws BOSException, EASBizException {
        StringBuffer delSql1 = new StringBuffer();
        delSql1.append("DELETE FROM T_BOT_RELATIONENTRY  \n");
        delSql1.append("WHERE FKEYID IN(SELECT FID FROM T_BOT_RELATION  \n");
        delSql1.append("WHERE FDESTENTITYID = '" + reportInfo.getBOSType().toString() + "' \n");
        delSql1.append("AND FDESTOBJECTID = '" + reportInfo.getId().toString() + "' ) \n");
        logger.debug((Object)("Del bot relation sql is:" + delSql1.toString()));
        DbUtil.execute((Context)ctx, (String)delSql1.toString());
        StringBuffer delSql2 = new StringBuffer();
        delSql2.append("DELETE FROM T_BOT_RELATION  \n");
        delSql2.append("WHERE FDESTENTITYID = '" + reportInfo.getBOSType().toString() + "' \n");
        delSql2.append("AND FDESTOBJECTID = '" + reportInfo.getId().toString() + "' \n");
        logger.debug((Object)("Del bot relation sql is:" + delSql2.toString()));
        DbUtil.execute((Context)ctx, (String)delSql2.toString());
    }

    public void rewriteQCBillAndQCReport(Context ctx, QCReportInfo reportInfo, boolean isAddNew) throws BOSException, EASBizException {
        StringBuffer sql1 = new StringBuffer();
        sql1.append("UPDATE T_QM_QCBILLSAMPLEENTRY \n");
        sql1.append("SET FISQCREPORT = " + (isAddNew ? 1 : 0) + " \n");
        sql1.append("WHERE FID IN \n");
        sql1.append("( \n");
        sql1.append("SELECT FSOURCEBILLENTRYID  \n");
        sql1.append("FROM T_QM_QCReportAllItemEntry  \n");
        sql1.append("WHERE FPARENTID = '" + reportInfo.getId().toString() + "' \n");
        sql1.append(") \n");
        logger.debug((Object)sql1.toString());
        StringBuffer sql2 = new StringBuffer();
        sql2.append("UPDATE T_QM_QCREQUESTENTRY  \n");
        sql2.append("SET FREPORTSTATE = " + (isAddNew ? 10 : 0) + " \n");
        sql2.append("WHERE FID IN \n");
        sql2.append("( \n");
        sql2.append("SELECT TB.FREQUESTENTRYID  \n");
        sql2.append("FROM T_QM_QCReportAllItemEntry TE \n");
        sql2.append("INNER JOIN T_QM_QCBILL TB  \n");
        sql2.append("ON TE.FSOURCEBILLID = TB.FID \n");
        sql2.append("WHERE TE.FPARENTID = '" + reportInfo.getId().toString() + "'  \n");
        sql2.append("AND TE.FREPORTENTRYSRCTYPE = '1AC2BFF5' \n");
        sql2.append(") \n");
        sql2.append(" \n");
        logger.debug((Object)sql2.toString());
        StringBuffer sql3 = new StringBuffer();
        sql3.append("UPDATE T_QM_QCREPORT \n");
        sql3.append("SET FISCOMBINEREPORT = " + (isAddNew ? 1 : 0) + " \n");
        sql3.append("WHERE FID IN \n");
        sql3.append("( \n");
        sql3.append("SELECT T.FSOURCEBILLID \n");
        sql3.append("FROM T_QM_QCReportAllItemEntry T \n");
        sql3.append("WHERE T.FPARENTID ='" + reportInfo.getId().toString() + "' \n");
        sql3.append("AND T.FREPORTENTRYSRCTYPE = '9029ADA2' \n");
        sql3.append(") \n");
        logger.debug((Object)sql3.toString());
        StringBuffer sql4 = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        sb.append("(select fid from T_QM_QCBill where FRequestEntryID = '" + reportInfo.getRequestEntryID() + "'");
        sb.append(" and fid not in ( select FSOURCEBILLID from T_QM_QCReportAllItemEntry where FPARENTID = '");
        sb.append(reportInfo.getId().toString() + "'))");
        IRowSet rsttt = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rsttt.next()) {
                String temp = rsttt.getString("fid");
                logger.debug((Object)temp);
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        sql4.append("UPDATE T_QM_QCBILLSAMPLEENTRY \n");
        sql4.append("SET FISQCREPORT = " + (isAddNew ? 1 : 0) + " \n");
        sql4.append("WHERE FParentID IN \n");
        sql4.append(sb.toString() + " and FIsResResult = 1");
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            st.addBatch(sql1.toString());
            st.addBatch(sql2.toString());
            st.addBatch(sql3.toString());
            st.addBatch(sql4.toString());
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    public void rewriteQCRequest(Context ctx, QCReportInfo reportInfo, boolean isAudit) throws BOSException, EASBizException {
        String requestID = reportInfo.getRequestID();
        String requestEntryID = reportInfo.getRequestEntryID();
        if (isAudit) {
            boolean isCanCloseRequestReport = this.checkCanCloseRequestReport(ctx, reportInfo);
            if (isCanCloseRequestReport) {
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE T_QM_QCREQUESTENTRY \n");
                sql.append("SET FREPORTSTATE = 20 \n");
                sql.append("WHERE FID = '" + requestEntryID + "'  \n");
                sql.append("AND FPARENTID = '" + requestID + "' \n");
                sql.append(" \n");
                logger.debug((Object)sql.toString());
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE T_QM_QCREQUESTENTRY \n");
            sql.append("SET FREPORTSTATE = 10 \n");
            sql.append("WHERE FID = '" + requestEntryID + "'  \n");
            sql.append("AND FPARENTID = '" + requestID + "' \n");
            sql.append(" \n");
            logger.debug((Object)sql.toString());
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    public boolean checkCanCloseRequestReport(Context ctx, QCReportInfo reportInfo) throws BOSException, EASBizException {
        String requestID = reportInfo.getRequestID();
        String requestEntryID = reportInfo.getRequestEntryID();
        String fid = reportInfo.getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT QCBILL.FID AS FID FROM T_QM_QCBILL QCBILL \n");
        sql.append("INNER JOIN T_QM_QCBILLSAMPLEENTRY QCBILLENTRY  \n");
        sql.append("ON QCBILL.FID = QCBILLENTRY.FPARENTID \n");
        sql.append("WHERE QCBILL.FREQUESTID = '" + requestID + "' \n");
        sql.append("AND QCBILL.FREQUESTENTRYID = '" + requestEntryID + "' \n");
        sql.append("AND ISNULL(QCBILLENTRY.FISRESRESULT,0) = 1 \n");
        sql.append("AND ISNULL(QCBILLENTRY.FISQCREPORT,0) = 0 \n");
        sql.append("UNION ALL  \n");
        sql.append("SELECT REPORT.FID AS FID FROM T_QM_QCREPORT REPORT \n");
        sql.append("WHERE REPORT.FREQUESTID='" + requestID + "'  \n");
        sql.append("AND REPORT.FREQUESTENTRYID ='" + requestEntryID + "' \n");
        sql.append("AND REPORT.FID!='" + fid + "' \n");
        sql.append("AND REPORT.FBILLSTATUS IN (0,10,20) \n");
        sql.append(" \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            return !rs.next();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public void beforeUpdateHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
    }
}

