/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.reversesave.qcrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryInfo;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.control.FinishedRptInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.sfc.CompletionReportInfo;
import com.kingdee.eas.qm.basedata.DPProcessModeFactory;
import com.kingdee.eas.qm.basedata.DPProcessModeInfo;
import com.kingdee.eas.qm.basedata.QCBizBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCBizObjectGroupInfo;
import com.kingdee.eas.qm.basedata.QCBizObjectInfo;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCSourceBillTypeFactory;
import com.kingdee.eas.qm.basedata.QCSourceBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCStandardCollection;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrCollection;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrFactory;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCStandardFactory;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStrategyEnum;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.app.action.IServerAction;
import com.kingdee.eas.qm.common.app.action.IServerActionManager;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.app.reversesave.ReverseServerAction;
import com.kingdee.eas.qm.common.ctx.QMContextHelperFactory;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.util.QMResourceUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.util.QMUtils;
import com.kingdee.eas.qm.common.util.QMVerifyHelper;
import com.kingdee.eas.qm.qc.IQCRequest;
import com.kingdee.eas.qm.qc.IQCRequestRelWeighEntry;
import com.kingdee.eas.qm.qc.QCReinspectReqInfo;
import com.kingdee.eas.qm.qc.QCRelWeighBaseCollection;
import com.kingdee.eas.qm.qc.QCReportFactory;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCReportNCPPREntryCollection;
import com.kingdee.eas.qm.qc.QCReportNCPPREntryInfo;
import com.kingdee.eas.qm.qc.QCRequestEntryCollection;
import com.kingdee.eas.qm.qc.QCRequestEntryFactory;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCRequestException;
import com.kingdee.eas.qm.qc.QCRequestFactory;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryCollection;
import com.kingdee.eas.qm.qc.QCRequestRelWeighEntryCollection;
import com.kingdee.eas.qm.qc.QCRequestRelWeighEntryFactory;
import com.kingdee.eas.qm.qc.QCRequestRelWeighEntryInfo;
import com.kingdee.eas.qm.qc.QCResultReWriteTypeEnum;
import com.kingdee.eas.qm.qc.QCReturnResultCollection;
import com.kingdee.eas.qm.qc.QCReturnResultInfo;
import com.kingdee.eas.qm.qc.QCSampleInfo;
import com.kingdee.eas.qm.qc.app.reversesave.qcrequest.PurReceivalBill4QCRequestAction;
import com.kingdee.eas.qm.qc.app.reversesave.qcrequest.QCReinspectReq4QCRequestAction;
import com.kingdee.eas.qm.qc.app.reversesave.qcrequest.QCRequest4QCRequestAction;
import com.kingdee.eas.qm.qc.app.reversesave.qcrequest.QCRequestReverseSaveUtils;
import com.kingdee.eas.qm.qc.app.reversesave.qcrequest.QCSample4QCRequestAction;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class QCRequestReverseSaveAction
extends ReverseServerAction {
    private static final String IS_CHANGE_QTY = "isChangeQty";
    public static final String SUBMIT_RESULT = "SUBMIT_RESULT";
    public static final String CANCEL_RESULT = "CANCEL_RESULT";
    public static final String RELATE_WEIGHNOTICE = "relateWeighNotice";
    private static final String QCRequestRes = "com.kingdee.eas.qm.qc.QCRequestResource";

    public abstract String getSrcBillEntryTbl();

    public static void regesterServerAction(Context ctx, QMCoreBillBaseInfo model, IServerActionManager serverActionManager) throws BOSException {
        EntityObjectInfo entity;
        String handler;
        BOSObjectType qcReinspectType;
        BOSObjectType qcSampleType;
        BOSObjectType requestBillType;
        BOSObjectType sfcmmorderType;
        BOSObjectType sfcfinishedRptType;
        BOSObjectType finishedRptType;
        BOSObjectType srcType = QMUtils.getSourceBillType((QMCoreBillBaseInfo)model);
        if (srcType == null) {
            if (model.getSourceBillType() != null && !model.getSourceBillType().getId().toString().equals("UzuilRaMQXKxCKhSpl2dyubqiQE=")) {
                throw new BOSException(QMResourceUtils.getMessage((String)QCRequestRes, (String)"SrcBillInfoError"));
            }
            return;
        }
        BOSObjectType purReceivalBilltype = new PurReceivalBillInfo().getBOSType();
        if (purReceivalBilltype.equals((Object)srcType)) {
            serverActionManager.addServerAction((IServerAction)new PurReceivalBill4QCRequestAction());
        }
        if ((finishedRptType = new FinishedRptInfo().getBOSType()).equals((Object)srcType)) {
            serverActionManager.addServerAction("com.kingdee.eas.mm.control.app.FinishedRpt4QCRequestAction");
        }
        if ((sfcfinishedRptType = new CompletionReportInfo().getBOSType()).equals((Object)srcType)) {
            serverActionManager.addServerAction("com.kingdee.eas.mm.sfc.app.srv.qm.SFCCompletionReportOpertion4QCRequestAction");
        }
        if ((sfcmmorderType = new ManufactureOrderInfo().getBOSType()).equals((Object)srcType)) {
            QCRequestInfo info = (QCRequestInfo)model;
            if (info.getSourceBillType() != null && info.getSourceBillType().getId().toString().equals("9cJS6I4xTRKZaJv44sbGcebqiQE=")) {
                serverActionManager.addServerAction("com.kingdee.eas.mm.sfc.app.srv.qm.SFCManufactureOrderProduct4QCRequestAction");
            } else {
                serverActionManager.addServerAction("com.kingdee.eas.mm.sfc.app.srv.qm.SFCManufactureOrderOpertion4QCRequestAction");
            }
        }
        if ((requestBillType = new QCRequestInfo().getBOSType()).equals((Object)srcType)) {
            serverActionManager.addServerAction((IServerAction)new QCRequest4QCRequestAction());
        }
        if ((qcSampleType = new QCSampleInfo().getBOSType()).equals((Object)srcType)) {
            serverActionManager.addServerAction((IServerAction)new QCSample4QCRequestAction());
        }
        if ((qcReinspectType = new QCReinspectReqInfo().getBOSType()).equals((Object)srcType)) {
            serverActionManager.addServerAction((IServerAction)new QCReinspectReq4QCRequestAction());
        }
        if ((handler = (entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(srcType)).getExtendedProperty("QCHandler")) != null && handler.trim().length() > 0) {
            try {
                serverActionManager.addServerAction((IServerAction)Class.forName(handler).newInstance());
            }
            catch (InstantiationException e) {
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new BOSException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public void handler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.handler(ctx, event);
        if (SUBMIT_RESULT.equals(event.getEventName())) {
            this.submitResultHandler(ctx, event);
            return;
        }
        if (CANCEL_RESULT.equals(event.getEventName())) {
            this.cancelResultHandler(ctx, event);
            return;
        }
    }

    public void cancelResultHandler(Context ctx, ServerEvent event) throws EASBizException, BOSException {
        QCRequestInfo info = (QCRequestInfo)event.getSrcObject();
        Object[] paras = event.getParams();
        int i = 0;
        IObjectValue qcRequestInfo = (IObjectValue)paras[i++];
        String qcRequestEntryId = (String)paras[i++];
        String qcReportId = (String)paras[i++];
        QCResultReWriteTypeEnum type = (QCResultReWriteTypeEnum)((Object)paras[i++]);
        QCRequestEntryInfo qcRequestEntry = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectStringPK(qcRequestEntryId));
        String sBillId = qcRequestEntry.getSourceBillID();
        String sbillEntryId = qcRequestEntry.getSourceBillEntryID();
        QCReturnResultCollection rsList = this.processDataList(ctx, (IObjectPK)new ObjectUuidPK(qcReportId), type);
        if (null == rsList || rsList.size() <= 0) {
            return;
        }
        this.canCancelResultHandler(ctx, sBillId, sbillEntryId, rsList);
        MaterialInfo material = qcRequestEntry.getMaterial();
        MeasureUnitInfo unit = qcRequestEntry.getUnit();
        String sourceBillEntryID = qcRequestEntry.getSourceBillEntryID();
        BigDecimal[] qtyAry = this.getQtyAry(ctx, material, unit, rsList);
        this.processSubmitResult(ctx, qcRequestEntry, sourceBillEntryID, material, unit, rsList, "-");
    }

    public abstract void canCancelResultHandler(Context var1, String var2, String var3, QCReturnResultCollection var4) throws EASBizException, BOSException;

    public abstract void canSubmitResultHandler(Context var1, String var2, String var3, QCReturnResultCollection var4) throws EASBizException, BOSException;

    public void submitResultHandler(Context ctx, ServerEvent event) throws EASBizException, BOSException {
        QCRequestInfo info = (QCRequestInfo)event.getSrcObject();
        Object[] paras = event.getParams();
        int i = 0;
        IObjectValue qcRequestInfo = (IObjectValue)paras[i++];
        String qcRequestEntryId = (String)paras[i++];
        String qcReportId = (String)paras[i++];
        QCResultReWriteTypeEnum type = (QCResultReWriteTypeEnum)((Object)paras[i++]);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("material.*");
        selector.add("parent.*");
        QCRequestEntryInfo qcRequestEntry = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectStringPK(qcRequestEntryId), selector);
        QCReturnResultCollection rsList = this.processDataList(ctx, (IObjectPK)new ObjectUuidPK(qcReportId), type);
        if (rsList == null || rsList.size() == 0) {
            return;
        }
        this.canSubmitResultHandler(ctx, qcRequestEntry.getSourceBillID(), qcRequestEntry.getSourceBillEntryID(), rsList);
        MaterialInfo material = qcRequestEntry.getMaterial();
        MeasureUnitInfo unit = qcRequestEntry.getUnit();
        String sourceBillEntryID = qcRequestEntry.getSourceBillEntryID();
        this.processSubmitResult(ctx, qcRequestEntry, sourceBillEntryID, material, unit, rsList, "+");
        BigDecimal[] qtyAry = this.getQtyAry(ctx, material, unit, rsList);
    }

    private void checkSumQualifiedQty(Context ctx, QCRequestEntryInfo qcRequestEntry) throws EASBizException, BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("select m.fname_l2 mname ,e.FDeliverQty , e.FQualifiedQty,e.FUnQualifiedQty from T_QM_QCRequestEntry e ,T_BD_material m ");
        sb.appendSql(" where m.fid=e.fmaterialid and e.FQualifiedQty +e.FUnQualifiedQty> e.FDeliverQty and e.fid in ( ");
        sb.appendParam((Object)qcRequestEntry.getId().toString());
        sb.appendSql(")");
        ResultSet rs = sb.exeQuery(ctx);
        try {
            if (rs.next()) {
                String ma = rs.getString(1);
                String DeliverQty = rs.getString(2);
                String QualifiedQty = rs.getString(3);
                String UnQualifiedQty = rs.getString(4);
                throw new QCRequestException(QCRequestException.DELIVERYQTYCHECK, new Object[]{ma, QualifiedQty, UnQualifiedQty, DeliverQty});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void processSubmitResult(Context ctx, QCRequestEntryInfo qcRequestEntry, String sourceBillEntryID, MaterialInfo material, MeasureUnitInfo srcUnit, QCReturnResultCollection rsList, String flag) throws BOSException, EASBizException {
        BigDecimal[] qtyAry = this.getQtyAry(ctx, material, srcUnit, rsList);
        String[] fieldAry = this.getFieldAry();
        String srcBillEntryTbl = this.getSrcBillEntryTbl();
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("update " + srcBillEntryTbl + "  set  ");
        for (int i = 0; i < fieldAry.length; ++i) {
            if (fieldAry[i] == null) continue;
            if (i > 0) {
                sb.appendSql(",");
            }
            sb.appendSql(fieldAry[i] + "=" + fieldAry[i] + flag);
            sb.appendParam((Object)qtyAry[i]);
        }
        sb.appendSql("   where  fid in ('',  ");
        sb.appendParam((Object)sourceBillEntryID);
        sb.appendSql(") ");
        sb.execute(ctx);
    }

    private void submitQCRequest(Context ctx, QCRequestEntryInfo qcRequestEntry, String flag, BigDecimal[] qtyAry) throws BOSException {
        BigDecimal sumQualifiedQty = qtyAry[0];
        BigDecimal sumBaseQualifiedQty = qtyAry[1];
        BigDecimal sumUnQualifiedQty = QMConstant.ZERO;
        BigDecimal sumBaseUnQualifiedQty = QMConstant.ZERO;
        for (int i = 2; i < qtyAry.length; i += 2) {
            sumUnQualifiedQty = sumUnQualifiedQty.add(qtyAry[i]);
            sumBaseUnQualifiedQty = sumUnQualifiedQty.add(qtyAry[i + 1]);
        }
        FMQuerySqlBuilder reqSb = new FMQuerySqlBuilder();
        reqSb.appendSql("update T_QM_QCRequestEntry  set FQualifiedQty=FQualifiedQty" + flag + "?, FBaseQualifiedQty=FBaseQualifiedQty" + flag + "?, FUnQualifiedQty=FUnQualifiedQty" + flag + "? , FBaseUnQualifiedQty=FBaseUnQualifiedQty" + flag + "? where fid=?  ");
        reqSb.addParam((Object)sumQualifiedQty);
        reqSb.addParam((Object)sumBaseQualifiedQty);
        reqSb.addParam((Object)sumUnQualifiedQty);
        reqSb.addParam((Object)sumBaseUnQualifiedQty);
        reqSb.addParam((Object)qcRequestEntry.getId().toString());
        reqSb.execute(ctx);
    }

    public abstract String[] getFieldAry();

    public abstract BigDecimal[] getQtyAry(Context var1, MaterialInfo var2, MeasureUnitInfo var3, QCReturnResultCollection var4) throws BOSException, EASBizException;

    private void addFlag(Context ctx, QCRequestInfo info) throws BOSException, EASBizException {
        HashSet<String> newEntrySet = new HashSet<String>();
        HashSet<QCRequestEntryInfo> reqEntrySet = new HashSet<QCRequestEntryInfo>();
        HashSet<String> newSRCEntrySet = new HashSet<String>();
        BOSUuid pk = info.getId();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            QCRequestEntryInfo requestEntryInfo = info.getEntrys().get(i);
            if (requestEntryInfo.getSourceBillEntryID() == null) continue;
            newEntrySet.add(requestEntryInfo.getId().toString());
            reqEntrySet.add(requestEntryInfo);
            newSRCEntrySet.add(requestEntryInfo.getSourceBillEntryID());
        }
        this.updateDeliverQty(ctx, this.getSrcBillEntryTbl(), newEntrySet, reqEntrySet, "+");
        this.checkDeliverQty(ctx, reqEntrySet);
        if (info.getQcBizType() != null && info.getQcBizType().getValue() == 30) {
            this.checkQty(ctx, this.getSrcBillEntryTbl(), reqEntrySet);
        }
    }

    private void checkDeliverQty(Context ctx, Set reqEntrySet) throws BOSException, QMException {
        Set notWeightReqEntryInfoSet;
        if ("T_IM_PurReceivalEntry".equals(this.getSrcBillEntryTbl()) && (notWeightReqEntryInfoSet = this.getNotWeightReqEntryInfoSet(reqEntrySet)) != null && notWeightReqEntryInfoSet.size() > 0) {
            try {
                this.checkSumDeliverQty(ctx, notWeightReqEntryInfoSet);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private Set getNotWeightReqEntryInfoSet(Set reqEntrySet) {
        if (reqEntrySet != null && reqEntrySet.size() > 0) {
            HashSet<QCRequestEntryInfo> notWeightReqEntryInfoSet = new HashSet<QCRequestEntryInfo>();
            for (QCRequestEntryInfo entryInfo : reqEntrySet) {
                if (entryInfo.isIsWeigh()) continue;
                notWeightReqEntryInfoSet.add(entryInfo);
            }
            return notWeightReqEntryInfoSet;
        }
        return null;
    }

    private void checkSumDeliverQty(Context ctx, Set notWeightReqEntryInfoSet) throws BOSException, SQLException, QMException {
        Iterator iter = notWeightReqEntryInfoSet.iterator();
        StringBuffer sb = new StringBuffer();
        while (iter.hasNext()) {
            QCRequestEntryInfo entryInfo = (QCRequestEntryInfo)iter.next();
            sb.append("'").append(entryInfo.getSourceBillEntryID());
            sb.append("',");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        String mname = this.getLocalField("fname");
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(re.fDeliverQty) as sumDeliverQty, ").append("        pre.fqty-pre.FReverseQty as qty, ").append("        m.").append(mname).append(" as mName ").append(" from T_QM_QCRequestEntry re, T_IM_PurReceivalEntry pre, T_BD_Material m ").append(" where re.FSourceBillEntryID = pre.fid ").append("   and re.FMaterialID = m.fid ").append("   and pre.fid in (").append(sb).append(") ").append(" group by pre.fqty-pre.FReverseQty,pre.FID, m.").append(mname);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet != null && rowSet.size() > 0) {
            String sumQty = null;
            String qty = null;
            String name = null;
            StringBuffer message = new StringBuffer();
            while (rowSet.next()) {
                sumQty = rowSet.getString("sumDeliverQty");
                qty = rowSet.getString("qty");
                name = rowSet.getString("mName");
                if (QCRequestReverseSaveAction.toBigDecimal(sumQty).compareTo(QCRequestReverseSaveAction.toBigDecimal(qty)) <= 0) continue;
                String str = ResourceBase.getString((String)"com.kingdee.eas.qm.qc.QCAutoGenerateResource", (String)"45_Check_SumDeliverQty", (Locale)ctx.getLocale());
                String temp = MessageFormat.format(str, name, sumQty, qty);
                message.append(temp);
                message.append("\n");
            }
            if (message.length() > 0) {
                throw new QMException(QMException.BLANK, (Object[])new String[]{message.toString()});
            }
        }
    }

    public static BigDecimal toBigDecimal(Object o) {
        BigDecimal result = QCRequestReverseSaveAction.effectualNumeric(null);
        if (o != null) {
            String vString;
            if (o instanceof BigDecimal) {
                result = (BigDecimal)o;
            } else if ((o instanceof String || o instanceof StringBuffer) && (vString = o.toString().trim()).matches("(-|\\+)?\\d+\\.?\\d*")) {
                result = new BigDecimal(vString);
            }
        }
        return result;
    }

    public static BigDecimal effectualNumeric(BigDecimal v) {
        return QCRequestReverseSaveAction.equalsZero(v) ? new BigDecimal("0.0") : v;
    }

    public static boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    public void afterAddnewHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.afterAddnewHandler(ctx, event);
        QCRequestInfo info = (QCRequestInfo)event.getSrcObject();
        this.addFlag(ctx, info);
    }

    public void afterUpdateHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCRequestInfo info = (QCRequestInfo)event.getSrcObject();
        if (info == null) {
            return;
        }
        if (info.getAuditor() != null) {
            return;
        }
        if (info.getBoolean(IS_CHANGE_QTY)) {
            this.addFlag(ctx, info);
            info.setBoolean(IS_CHANGE_QTY, false);
        }
    }

    public boolean isChangeQty(Context ctx, QCRequestInfo info) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString()));
        view.setFilter(filter);
        view.getSelector().add("deliverQty");
        QCRequestEntryCollection coll = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryCollection(view);
        if (coll.size() != info.getEntrys().size()) {
            return true;
        }
        for (int i = 0; i < coll.size(); ++i) {
            BigDecimal newQty;
            BigDecimal oldQty = coll.get(i).getDeliverQty();
            if (QMEqualsUtils.equals((Object)oldQty, (Object)(newQty = info.getEntrys().get(i).getDeliverQty()))) continue;
            return true;
        }
        return false;
    }

    public void beforeDeleteHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeDeleteHandler(ctx, event);
        QCRequestInfo info = (QCRequestInfo)event.getSrcObject();
        this.deleteFlag(ctx, info);
    }

    public void beforeUpdateHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCRequestInfo info = (QCRequestInfo)event.getSrcObject();
        if (info == null) {
            return;
        }
        if (info.getAuditor() != null) {
            return;
        }
        if (this.isChangeQty(ctx, info)) {
            this.deleteFlag(ctx, info);
            info.setBoolean(IS_CHANGE_QTY, true);
        } else {
            info.setBoolean(IS_CHANGE_QTY, false);
        }
    }

    private void dealRelWeighEntrys(Context ctx, QCRequestInfo info) throws BOSException, EASBizException {
        if (null == info.isRelWeighSave() || !info.isRelWeighSave().booleanValue()) {
            return;
        }
        if (QMStringUtils.isEmpty((String)info.getSourceBillId()) || !info.getSourceBillType().getId().toString().equals("FLJ+4hsARhavfhBsrOo52+bqiQE=")) {
            return;
        }
        IQCRequest ibiz = QCRequestFactory.getLocalInstance(ctx);
        QCRequestEntryCollection entrys = info.getEntrys();
        ArrayList<QCRequestEntryInfo> relEntrys = new ArrayList<QCRequestEntryInfo>();
        for (int i = 0; i < entrys.size(); ++i) {
            relEntrys.add(entrys.get(i));
        }
        ibiz.relateWeighNotice(info, relEntrys);
    }

    private void deleteRelWeigh(Context ctx, QCRequestInfo info) throws EASBizException, BOSException {
    }

    private void deleteFlag(Context ctx, QCRequestInfo info) throws BOSException {
        String getOldSourceBillEntrySql = "select fid ,fSourceBillEntryID from T_QM_QCRequestEntry where fparentid=? and fsourcebillentryid is not null";
        HashSet<String> oldentrySet = new HashSet<String>();
        HashSet<QCRequestEntryInfo> reqEntrySet = new HashSet<QCRequestEntryInfo>();
        HashSet<String> oldSRCEntrySet = new HashSet<String>();
        BOSUuid pk = info.getId();
        if (pk != null) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getOldSourceBillEntrySql, (Object[])new String[]{pk.toString()});
                while (rs.next()) {
                    oldentrySet.add(rs.getString(1));
                    oldSRCEntrySet.add(rs.getString(2));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            for (int i = 0; i < info.getEntrys().size(); ++i) {
                reqEntrySet.add(info.getEntrys().get(i));
            }
            this.updateDeliverQty(ctx, this.getSrcBillEntryTbl(), oldentrySet, reqEntrySet, "-");
        }
    }

    public void updateDeliverQty(Context ctx, String srcBillEntryTbl, Set entryIdSet, Set reqEntrySet, String flag) throws BOSException {
        boolean supUnDeliverQty;
        if (entryIdSet.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update " + srcBillEntryTbl + " as t \n");
        sql.append(" set (" + this.getDeliverQty() + "," + this.getBaseDeliverQty() + ")\n");
        sql.append(" =( \n");
        sql.append(" select \n");
        sql.append("t." + this.getDeliverQty() + " " + flag + " a.fdeliverQty \n");
        sql.append(" ,t." + this.getBaseDeliverQty() + " " + flag + " a.fBasedeliverQty \n");
        sql.append(" from T_QM_QCRequestEntry as a \n");
        sql.append(" where a.FSourceBillEntryID = t.FID \n");
        sql.append(" and a.FID = ? \n");
        sql.append(" )");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Iterator iter = entryIdSet.iterator();
        while (iter.hasNext()) {
            paramsList.add(new Object[]{iter.next()});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
        boolean bl = supUnDeliverQty = this.getUnDeliverQty() != null && this.getUnDeliverQty().trim().length() > 0;
        if (supUnDeliverQty) {
            this.updateUnDeliverQty(ctx, srcBillEntryTbl, reqEntrySet);
        }
    }

    public void updateUnDeliverQty(Context ctx, String srcBillEntryTbl, Set reqEntrySet) throws BOSException {
        if (reqEntrySet.size() == 0) {
            return;
        }
        for (QCRequestEntryInfo entry : reqEntrySet) {
            String qtySql = this.getQtySql(srcBillEntryTbl, this.getQty(entry.isIsWeigh()));
            String qtybaseSql = this.getQtySql(srcBillEntryTbl, this.getBaseQty(entry.isIsWeigh()));
            FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
            sb.appendSql("update " + srcBillEntryTbl + "  set  ");
            sb.appendSql(this.getUnDeliverQty() + "= isnull(");
            sb.appendSql(qtySql + " - " + srcBillEntryTbl + "." + this.getDeliverQty() + ", 0.00),");
            sb.appendSql(this.getBaseUnDeliverQty() + "= isnull(");
            sb.appendSql(qtybaseSql + " - " + srcBillEntryTbl + "." + this.getBaseDeliverQty());
            sb.appendSql(",0.00 )    where  fid = '" + entry.getSourceBillEntryID() + "'");
            DbUtil.execute((Context)ctx, (String)sb.getSql());
        }
    }

    public void updateUnDeliverQtyBySrcEntryIds(Context ctx, String srcBillEntryTbl, Set newSRCEntrySet) throws BOSException {
        if (newSRCEntrySet.size() == 0) {
            return;
        }
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("update " + srcBillEntryTbl + "  set  ");
        sb.appendSql(this.getUnDeliverQty() + "=");
        String qtySql = this.getQtySql(srcBillEntryTbl, this.getQty());
        sb.appendSql(qtySql + " - " + srcBillEntryTbl + "." + this.getDeliverQty() + ",");
        sb.appendSql(this.getBaseUnDeliverQty() + "=");
        String qtybaseSql = this.getQtySql(srcBillEntryTbl, this.getBaseQty());
        sb.appendSql(qtybaseSql + " - " + srcBillEntryTbl + "." + this.getBaseDeliverQty());
        sb.appendSql("    where  fid   in (");
        sb.appendParam(newSRCEntrySet.toArray());
        sb.appendSql(") ");
        String sql = sb.getTestSql();
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public abstract String getDeliverQty();

    public abstract String getBaseDeliverQty();

    public abstract String[] getQty();

    public String[] getQty(boolean isWeigh) {
        return this.getQty();
    }

    public abstract String[] getBaseQty();

    public String[] getBaseQty(boolean isWeigh) {
        return this.getBaseQty();
    }

    public abstract String getBaseUnDeliverQty();

    public abstract String getUnDeliverQty();

    public void checkQty(Context ctx, String srcBillEntryTbl, Set reqEntrySet) throws BOSException, QMException {
        QCRequestEntryInfo entry;
        Iterator iter;
        if (reqEntrySet.size() == 0) {
            return;
        }
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        String QtySql = this.getQtySql("e", this.getQty());
        String materialField = this.getMaterialField();
        if (this.getParentTable() == null) {
            iter = reqEntrySet.iterator();
            int index = 0;
            sb.appendSql("select t.materialName as materialName, t.deliverQty as deliverQty, t.qty as qty ");
            sb.appendSql(" from ( \n");
            while (iter.hasNext()) {
                entry = (QCRequestEntryInfo)iter.next();
                QtySql = this.getQtySql("e", this.getQty(entry.isIsWeigh()));
                if (index++ > 0) {
                    sb.appendSql("\n union \n");
                }
                sb.appendSql(" select m." + this.getLocalField("FName") + " as materialName, ");
                sb.appendSql(" e." + this.getDeliverQty() + " as deliverQty, ");
                sb.appendSql(QtySql + " as qty ");
                sb.appendSql(" from " + srcBillEntryTbl + " as e,T_BD_material m ");
                sb.appendSql(" where m.fid=e." + materialField);
                sb.appendSql(" and e." + this.getDeliverQty() + " >" + QtySql);
                sb.appendSql(" and e.fid = '" + entry.getSourceBillEntryID() + "'");
            }
            sb.appendSql(" \n) as t");
        } else {
            iter = reqEntrySet.iterator();
            HashSet<String> srcEntryIds = new HashSet<String>();
            while (iter.hasNext()) {
                entry = (QCRequestEntryInfo)iter.next();
                srcEntryIds.add(entry.getSourceBillEntryID());
            }
            sb.appendSql("select m.fname_l2 mname ,e." + this.getDeliverQty() + " ," + QtySql + " from " + srcBillEntryTbl + " e ,T_BD_material m , " + this.getParentTable() + " p ");
            sb.appendSql(" where m.fid=p." + materialField + " and p.fid=e.fparentid and e." + this.getDeliverQty() + " >" + QtySql + " and e.fid in ( ");
            sb.appendParam(srcEntryIds.toArray());
            sb.appendSql(")");
        }
        ResultSet rs = sb.exeQuery(ctx);
        StringBuffer s = new StringBuffer();
        try {
            while (rs.next()) {
                String ma = rs.getString(1);
                String dqty = rs.getString(2);
                String qty = rs.getString(3);
                String str = this.getCheckQtyTitle(ctx);
                String sss = MessageFormat.format(str, ma, dqty, qty);
                s.append(sss);
                s.append("\n");
            }
            if (s.length() > 0) {
                throw new QMException(QMException.BLANK, (Object[])new String[]{s.toString()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void checkQtyBySrcEntryIds(Context ctx, String srcBillEntryTbl, Set srcEntrySet) throws BOSException, QMException {
        if (null == srcEntrySet || srcEntrySet.size() == 0) {
            return;
        }
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        String QtySql = this.getQtySql("e", this.getQty());
        String materialField = this.getMaterialField();
        if (this.getParentTable() == null) {
            sb.appendSql("select m.fname_l2 mname ,e." + this.getDeliverQty() + " ," + QtySql + " from " + srcBillEntryTbl + " e ,T_BD_material m ");
            sb.appendSql(" where m.fid=e." + materialField + " and e." + this.getDeliverQty() + " >" + QtySql + " and e.fid in ( ");
            sb.appendParam(srcEntrySet.toArray());
            sb.appendSql(")");
        } else {
            sb.appendSql("select m.fname_l2 mname ,e." + this.getDeliverQty() + " ," + QtySql + " from " + srcBillEntryTbl + " e ,T_BD_material m , " + this.getParentTable() + " p ");
            sb.appendSql(" where m.fid=p." + materialField + " and p.fid=e.fparentid and e." + this.getDeliverQty() + " >" + QtySql + " and e.fid in ( ");
            sb.appendParam(srcEntrySet.toArray());
            sb.appendSql(")");
        }
        ResultSet rs = sb.exeQuery(ctx);
        StringBuffer s = new StringBuffer();
        try {
            while (rs.next()) {
                String ma = rs.getString(1);
                String dqty = rs.getString(2);
                String qty = rs.getString(3);
                String str = this.getCheckQtyTitle(ctx);
                String sss = MessageFormat.format(str, ma, dqty, qty);
                s.append(sss);
                s.append("\n");
            }
            if (s.length() > 0) {
                throw new QMException(QMException.BLANK, (Object[])new String[]{s.toString()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String getMaterialField() {
        String materialField = "fmaterialid";
        return materialField;
    }

    public abstract String getCheckQtyTitle(Context var1);

    public String getParentTable() {
        return null;
    }

    public String getQtySql(String tblName, String[] qty) {
        String qtySql = tblName + "." + qty[0];
        for (int i = 1; i < qty.length; ++i) {
            String string = qty[i];
            qtySql = string.startsWith("-") ? qtySql + "-" + tblName + "." + string.substring(1) : qtySql + "+" + tblName + "." + string;
        }
        return qtySql;
    }

    public void afterTransFormHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        int i;
        super.afterTransFormHandler(ctx, event);
        QCRequestInfo qcInfo = (QCRequestInfo)event.getSrcObject();
        BOSObjectType srcType = QMUtils.getSourceBillType((QMCoreBillBaseInfo)qcInfo);
        String p = this.getAddNewPermItemName();
        if (p != null) {
            UserInfo user = QMContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            ObjectUuidPK userPK = new ObjectUuidPK(user.getId());
            QMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)qcInfo, (String)"qualityOrgUnit");
            ObjectUuidPK orgPK = new ObjectUuidPK(qcInfo.getQualityOrgUnit().getId());
            String permItemName = p;
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permItemName);
        }
        QCBizTypeEnum qcBizType = qcInfo.getQcBizType();
        QCBizBillTypeInfo qcBillType = QCRequestReverseSaveUtils.getDefaultBillType(ctx, qcBizType);
        qcInfo.setBillType(qcBillType);
        qcInfo.setFromBOTP(true);
        this.dealStandard(ctx, qcBizType, qcInfo);
        QCRequestEntryCollection entryColl = qcInfo.getEntrys();
        FullOrgUnitInfo orgUnit = qcInfo.getReqOrgUnit();
        if ((qcBizType == QCBizTypeEnum.pdtDiscreteCheck || qcBizType == QCBizTypeEnum.pdtProcessCheck) && orgUnit != null) {
            int i2;
            HashSet<String> materialIdSet = new HashSet<String>();
            for (int i3 = 0; i3 < entryColl.size(); ++i3) {
                QCRequestEntryInfo entry = entryColl.get(i3);
                MaterialInfo m = entry.getMaterial();
                if (m == null) continue;
                materialIdSet.add(m.getId().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnit.getId().toString()));
            view.setFilter(filter);
            view.getSelector().add("id");
            view.getSelector().add("isCheck");
            view.getSelector().add("isKeyPart");
            view.getSelector().add("isFirstCheck");
            view.getSelector().add("material.id");
            view.getSelector().add("material.name");
            view.getSelector().add("material.number");
            MaterialPlanCollection planColl = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(view);
            HashMap<String, MaterialPlanInfo> set = new HashMap<String, MaterialPlanInfo>();
            for (i2 = 0; i2 < planColl.size(); ++i2) {
                MaterialPlanInfo info = planColl.get(i2);
                set.put(info.getMaterial().getId().toString(), info);
            }
            for (i2 = 0; i2 < entryColl.size(); ++i2) {
                QCRequestEntryInfo entry = entryColl.get(i2);
                MaterialInfo m = entry.getMaterial();
                if (m == null) continue;
                MaterialPlanInfo info = (MaterialPlanInfo)set.get(m.getId().toString());
                if (!info.isIsCheck()) {
                    throw new QCRequestException(QCRequestException.MATERIALCANNOTSUPPORTCHECKFLOW, new Object[]{info.getMaterial().getNumber()});
                }
                entry.setIsKeyPart(info.isIsKeyPart());
                entry.setFirstCheck(info.isIsFirstCheck());
            }
        }
        this.verifySrcBillData(ctx, qcInfo);
        for (i = 0; i < entryColl.size(); ++i) {
            QCRequestEntryInfo entry = entryColl.get(i);
            if (entry.getDeliverQty() != null && entry.getDeliverQty().signum() > 0) continue;
            throw new QCRequestException(QCRequestException.QTYISNULLCANNOTCHECK);
        }
        if (qcInfo.getEntrys().size() > 0) {
            for (i = 0; i < qcInfo.getEntrys().size(); ++i) {
                QCRequestQcItemEntryCollection newQcItemEntries = QCRequestFactory.getLocalInstance(ctx).getQcItemEntryColl(qcInfo.getQualityOrgUnit(), qcInfo.getEntrys().get(i));
                qcInfo.getQcItemEntrys().addCollection(newQcItemEntries);
                qcInfo.getEntrys().get(i).getQcItemEntrys().addCollection(newQcItemEntries);
            }
        }
    }

    protected void verifySrcBillData(Context ctx, QCRequestInfo qcReqInfo) throws BOSException, EASBizException {
    }

    public abstract String getAddNewPermItemName();

    private void dealStandard(Context ctx, QCBizTypeEnum bizType, QCRequestInfo qcInfo) throws BOSException, EASBizException {
        QCRequestEntryCollection entryColl = qcInfo.getEntrys();
        UserInfo user = (UserInfo)UserFactory.getLocalInstance((Context)ctx).getValue(ctx.getCaller());
        PersonInfo person = user.getPerson();
        if (person != null) {
            qcInfo.setReqPerson(person);
        }
        for (int i = 0; i < entryColl.size(); ++i) {
            QCRequestEntryInfo entryInfo = entryColl.get(i);
            QCStandardInfo qcStandardInfo = entryInfo.getQcStandard();
            if (qcStandardInfo == null) {
                QualityOrgUnitInfo mainOrgUnit = qcInfo.getQualityOrgUnit();
                QCBizTypeEnum qcBizType = bizType;
                QCBizObjectGroupInfo bizGroup = qcInfo.getQcObjectGroup();
                QCBizObjectInfo bizInfo = entryInfo.getQcBizObject();
                PersonInfo qcPerson = entryInfo.getQcPerson();
                MaterialInfo material = entryInfo.getMaterial();
                StandardRootingInfo standardRooting = entryInfo.getTechnicsRoute();
                int wpSeq = entryInfo.getWpSeq();
                OperationInfo operation = entryInfo.getOperation();
                ProductLineInfo productLine = entryInfo.getPdtLine();
                ProductLineWPEntryInfo productLineWPEntry = entryInfo.getPdtLineWP();
                IQCRequest iQCRequest = QCRequestFactory.getLocalInstance(ctx);
                EntityViewInfo ev = null;
                if (QCBizTypeEnum.purCheck.equals((Object)bizType)) {
                    String strMaterialId = material == null ? null : material.getId().toString();
                    String strSupplierId = qcInfo.getSupplier() == null ? null : qcInfo.getSupplier().getId().toString();
                    PurchaseOrgUnitInfo purOrg = null;
                    if (qcInfo.getReqOrgUnit() != null) {
                        purOrg = new PurchaseOrgUnitInfo();
                        purOrg.setId(qcInfo.getReqOrgUnit().getId());
                    }
                    ev = iQCRequest.getPurQCStandardFilter(purOrg, strMaterialId, strSupplierId, mainOrgUnit);
                } else {
                    ev = iQCRequest.getQCStandardFilter(mainOrgUnit, qcBizType, bizGroup, bizInfo, material, qcPerson, standardRooting, wpSeq, operation, productLine, productLineWPEntry);
                }
                ev.getSelector().add("*");
                ev.getSelector().add("billType.*");
                QCStandardCollection coll = QCStandardFactory.getLocalInstance((Context)ctx).getQCStandardCollection(ev);
                if (coll.size() > 0) {
                    qcStandardInfo = coll.get(0);
                }
            }
            if (qcStandardInfo != null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("*");
                selector.add("billType.*");
                selector.add("extendAttr.*");
                QCStandardInfo tempStandInfo = QCStandardFactory.getLocalInstance((Context)ctx).getQCStandardInfo((IObjectPK)new ObjectUuidPK(qcStandardInfo.getId()), selector);
                entryInfo.setQcStandard(tempStandInfo);
                if (tempStandInfo.getBillType() != null) {
                    BigDecimal checkHour = tempStandInfo.getBillType().getCheckHour();
                    entryInfo.setCheckHour(checkHour);
                } else {
                    entryInfo.setCheckHour(new BigDecimal("0"));
                }
                QCStrategyEnum qcStrategy = this.getQCStrategyByQcstandard(ctx, tempStandInfo, qcInfo.getQualityOrgUnit());
                entryInfo.setQcStrategy(qcStrategy);
                Calendar cal = Calendar.getInstance();
                cal.setTime(qcInfo.getReqDate());
                cal.add(5, entryInfo.getCheckHour().intValue());
                entryInfo.setReqFinishDate(cal.getTime());
                entryInfo.setQcStandardType(tempStandInfo.getQcStandardType());
                entryInfo.setQcType(tempStandInfo.getSampleSolution());
                QCStandardExtendAttrCollection extColl = tempStandInfo.getExtendAttr();
                if (extColl != null) {
                    QCStandardExtendAttrInfo stdExtInfo = extColl.get(0);
                    entryInfo.setEachSampleQty(stdExtInfo.getEachSampleQty());
                    entryInfo.setEachSampleUnit(stdExtInfo.getEachSampleUnit());
                }
            }
            if (qcInfo.getBillStatus() != QMBillBaseStatusEnum.Submit) continue;
            QMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)entryInfo, (String)"qcStandard");
        }
    }

    private QCStrategyEnum getQCStrategyByQcstandard(Context ctx, QCStandardInfo qcStandard, QualityOrgUnitInfo org) throws EASBizException, BOSException {
        if (qcStandard != null && qcStandard.getId() != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("billType.*");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)qcStandard.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)org.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            QCStandardExtendAttrCollection coll = QCStandardExtendAttrFactory.getLocalInstance((Context)ctx).getQCStandardExtendAttrCollection(view);
            if (coll.size() > 0) {
                QCStandardExtendAttrInfo standardExtendAttrInfo = coll.get(0);
                QCStrategyEnum qcStrategy = standardExtendAttrInfo.getQCStrategy();
                return qcStrategy;
            }
            return QCStrategyEnum.oneStepCheck;
        }
        return null;
    }

    private QCReturnResultCollection processDataList(Context ctx, IObjectPK pk, QCResultReWriteTypeEnum type) throws BOSException, EASBizException {
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        select.add("material.*");
        select.add("nCPPREntries.*");
        select.add("nCPPREntries.dPProcessMode.*");
        QCReportInfo reportInfo = QCReportFactory.getLocalInstance(ctx).getQCReportInfo(pk, select);
        String requestEntryID = reportInfo.getRequestEntryID();
        SelectorItemCollection reqSic = new SelectorItemCollection();
        reqSic.add("*");
        reqSic.add("qcStandard.sampleSolution");
        reqSic.add("relWeighEntrys.*");
        reqSic.add("relWeighEntrys.relWeighBill.*");
        QCRequestEntryInfo requestEntryInfo = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectStringPK(requestEntryID), reqSic);
        QCReturnResultCollection rsCols = new QCReturnResultCollection();
        if (type == QCResultReWriteTypeEnum.pass) {
            this.insertPassInfoToDataList(ctx, rsCols, reportInfo, requestEntryInfo);
        } else if (type == QCResultReWriteTypeEnum.unpass) {
            this.insertUnPassInfoToDataList(ctx, rsCols, reportInfo, requestEntryInfo);
        } else {
            this.insertPassInfoToDataList(ctx, rsCols, reportInfo, requestEntryInfo);
            this.insertUnPassInfoToDataList(ctx, rsCols, reportInfo, requestEntryInfo);
        }
        return rsCols;
    }

    private void insertPassInfoToDataList(Context ctx, QCReturnResultCollection rsCols, QCReportInfo reportInfo, QCRequestEntryInfo requestEntryInfo) throws EASBizException, BOSException {
        if (reportInfo.getPassQty().signum() <= 0) {
            return;
        }
        QCReturnResultInfo info = new QCReturnResultInfo();
        info.setBillID(requestEntryInfo.getSourceBillID());
        info.setBillEntryID(requestEntryInfo.getSourceBillEntryID());
        info.setCheckBatch(reportInfo.getCheckLot());
        DPProcessModeInfo item = DPProcessModeFactory.getLocalInstance((Context)ctx).getDPProcessModeInfo((IObjectPK)new ObjectUuidPK("ebzQHFu8QiO155c/afxYgF8G5DM="));
        info.setDPProcessMode(item);
        info.setMaterial(reportInfo.getMaterial());
        if (reportInfo.getJudgeMaterial() == null) {
            info.setJudgeMaterial(reportInfo.getMaterial());
        } else {
            info.setJudgeMaterial(reportInfo.getJudgeMaterial());
        }
        info.setQty(reportInfo.getPassQty());
        info.setBaseQty(reportInfo.getPassBaseQty());
        QMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)reportInfo, (String)"passBaseQty");
        info.setUnit(reportInfo.getUnit());
        info.setBaseUnit(reportInfo.getBaseUnit());
        info.setValidDate(reportInfo.getValidDate());
        info.setRemark(reportInfo.getDescription());
        info.setSourceBillID(reportInfo.getId().toString());
        info.setSourceBillNum(reportInfo.getNumber());
        info.setSourceBillEntryID(reportInfo.getId().toString());
        QCSourceBillTypeInfo type = QCSourceBillTypeFactory.getLocalInstance((Context)ctx).getQCSourceBillTypeInfo((IObjectPK)new ObjectUuidPK("GnHD33UuQOmGDfR7lyYQGebqiQE="));
        info.setSourceBillType(type);
        rsCols.add(info);
    }

    private void insertUnPassInfoToDataList(Context ctx, QCReturnResultCollection rsCols, QCReportInfo reportInfo, QCRequestEntryInfo requestEntryInfo) throws EASBizException, BOSException {
        QCReportNCPPREntryCollection nccpEntryCols = reportInfo.getNCPPREntries();
        if (nccpEntryCols.size() > 0) {
            Iterator it = nccpEntryCols.iterator();
            while (it.hasNext()) {
                QCReportNCPPREntryInfo entryInfo = (QCReportNCPPREntryInfo)it.next();
                if (entryInfo.getQty().signum() <= 0) continue;
                QCReturnResultInfo info = new QCReturnResultInfo();
                info.setBillID(requestEntryInfo.getSourceBillID());
                info.setBillEntryID(requestEntryInfo.getSourceBillEntryID());
                info.setCheckBatch(reportInfo.getCheckLot());
                info.setDPProcessMode(entryInfo.getDPProcessMode());
                info.setMaterial(reportInfo.getMaterial());
                if (reportInfo.getJudgeMaterial() == null) {
                    info.setJudgeMaterial(reportInfo.getMaterial());
                } else {
                    info.setJudgeMaterial(reportInfo.getJudgeMaterial());
                }
                info.setQty(entryInfo.getQty());
                info.setBaseQty(entryInfo.getBaseQty());
                info.setUnit(entryInfo.getUnit());
                QMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)entryInfo, (String)"baseQty");
                info.setBaseUnit(entryInfo.getBaseUnit());
                info.setValidDate(entryInfo.getValidDate());
                info.setRemark(entryInfo.getRemark());
                info.setSourceBillID(entryInfo.getSourceBillID());
                info.setSourceBillNum(entryInfo.getSourceBillNumber());
                String srcBillEntryId = QMStringUtils.isEmpty((String)entryInfo.getSourceBillEntryID()) ? entryInfo.getId().toString() : entryInfo.getSourceBillEntryID();
                info.setSourceBillEntryID(srcBillEntryId);
                info.setSeq(entryInfo.getSeq());
                info.setSourceBillType(entryInfo.getSourceBillType());
                rsCols.add(info);
            }
        }
    }

    private void relateWeighNoticeHandler(Context ctx, ServerEvent event) throws EASBizException, BOSException {
        int index;
        Object[] params = event.getParams();
        List requestEntrys = (List)params[index = 0];
        if (null == requestEntrys || requestEntrys.size() <= 0) {
            throw new QMException(QMException.BLANK, new Object[]{"data error: request entrys is null!"});
        }
        List oldNoticeEntryIds = new ArrayList();
        ArrayList newNoticeEntryIds = new ArrayList();
        ArrayList<String> reqEntryIds = new ArrayList<String>();
        int reqEntrySize = requestEntrys.size();
        for (int i = 0; i < reqEntrySize; ++i) {
            QCRequestEntryInfo reqEntry = (QCRequestEntryInfo)requestEntrys.get(i);
            reqEntryIds.add(reqEntry.getId().toString());
        }
        oldNoticeEntryIds = this.getOldRelNoticeEntryIds(ctx, reqEntryIds);
        QCRequestInfo info = (QCRequestInfo)event.getSrcObject();
        this.verifyIsQCRel(ctx, newNoticeEntryIds, info);
        this.updateRelation(ctx, newNoticeEntryIds, oldNoticeEntryIds);
        try {
            QCRequestRelWeighEntryCollection oldRelWeiEntrys = this.getOldRelWeighEntrys(ctx, reqEntryIds);
            if (null != oldRelWeiEntrys && oldRelWeiEntrys.size() > 0) {
                for (int i = 0; i < oldRelWeiEntrys.size(); ++i) {
                    QCRequestRelWeighEntryInfo relEntry = oldRelWeiEntrys.get(i);
                    QCRequestRelWeighEntryFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(relEntry.getId()));
                }
            }
            this.saveRelEntrys(ctx, info, requestEntrys);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private List getOldRelNoticeEntryIds(Context ctx, List reqEntryIds) throws BOSException, EASBizException {
        ArrayList oldNoticeEntryIds = new ArrayList();
        QCRequestRelWeighEntryCollection oldRelWeiEntrys = this.getOldRelWeighEntrys(ctx, reqEntryIds);
        if (null != oldRelWeiEntrys && oldRelWeiEntrys.size() > 0) {
            for (int i = 0; i < oldRelWeiEntrys.size(); ++i) {
                QCRequestRelWeighEntryInfo relEntry = oldRelWeiEntrys.get(i);
            }
        }
        return oldNoticeEntryIds;
    }

    private QCRequestRelWeighEntryCollection getOldRelWeighEntrys(Context ctx, List reqEntryIds) throws QMException, BOSException {
        if (null == reqEntryIds || reqEntryIds.size() <= 0) {
            throw new QMException(QMException.BLANK, new Object[]{"data error: request entrys is null!"});
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        filter.getFilterItems().add(new FilterItemInfo("materialEntry.id", new HashSet(reqEntryIds), CompareType.INCLUDE));
        view.setFilter(filter);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("relNoticeEntry.id"));
        view.setSelector(sic);
        QCRequestRelWeighEntryCollection oldRelWeiEntrys = QCRequestRelWeighEntryFactory.getLocalInstance(ctx).getQCRequestRelWeighEntryCollection(view);
        return oldRelWeiEntrys;
    }

    private void saveRelEntrys(Context ctx, QCRequestInfo requestInfo, List requestEntrys) throws SQLException, BOSException, EASBizException {
    }

    private void updateRelation(Context ctx, List newNoticeEntryIds, List oldNoticeEntryIds) throws BOSException, EASBizException {
    }

    private String getLocalField(String field) {
        String name = null;
        Locale locale = ContextUtils.getLocaleFromEnv();
        if ("l1".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L1 ";
        } else if ("l3".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L3 ";
        } else if ("l2".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L2 ";
        }
        return name;
    }

    private void verifyIsQCRel(Context ctx, List newNoticeEntryIds, QCRequestInfo info) throws BOSException, EASBizException {
        if (this.isWeighChecked(ctx, (ArrayList)newNoticeEntryIds, info)) {
            throw new QCRequestException(QCRequestException.WEIGHBILLALREADYRELATIONQC);
        }
    }

    private SelectorItemCollection getRelWeighSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("relNoticeEntry"));
        return null;
    }

    private boolean isWeighChecked(Context ctx, ArrayList selectNoticeEntrys, QCRequestInfo info) throws BOSException {
        return false;
    }

    private ArrayList removeSelfRel(Context ctx, Set selectNoticeEntrys, QCRequestInfo info) throws BOSException {
        ArrayList noticeEntrys = new ArrayList();
        ArrayList selfRelWeigh = this.getSelfRelWeigh(ctx, info);
        selectNoticeEntrys.removeAll(selfRelWeigh);
        noticeEntrys.addAll(selectNoticeEntrys);
        return noticeEntrys;
    }

    private ArrayList getSelfRelWeigh(Context ctx, QCRequestInfo info) throws BOSException {
        ArrayList selfRelWeigh = new ArrayList();
        IQCRequestRelWeighEntry QCRequestRelWeighEntry2 = QCRequestRelWeighEntryFactory.getLocalInstance(ctx);
        QCRelWeighBaseCollection QCRelWeighEntryInfos = QCRequestRelWeighEntry2.getQCRelWeighBaseCollection(this.getQCRelWeighEntryView(info));
        return selfRelWeigh;
    }

    private EntityViewInfo getQCRelWeighEntryView(QCRequestInfo info) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)info.getId().toString()));
        view.setFilter(filter);
        return view;
    }

    private EntityViewInfo getWeighNoticeEntrysView(ArrayList selectNoticeEntrys) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("relatingQcRequest", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(selectNoticeEntrys), CompareType.INCLUDE));
        view.setFilter(filter);
        return view;
    }
}

